/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.signing.internal;

import com.oracle.bmc.http.client.InternalSdk;
import com.oracle.bmc.http.signing.internal.KeySupplier;
import com.oracle.bmc.http.signing.internal.PEMStreamRSAPrivateKeySupplier;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.security.interfaces.RSAPrivateKey;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PEMFileRSAPrivateKeySupplier
implements KeySupplier<RSAPrivateKey> {
    private static final Logger LOG = LoggerFactory.getLogger(PEMFileRSAPrivateKeySupplier.class);
    private final PEMStreamRSAPrivateKeySupplier delegate;

    public PEMFileRSAPrivateKeySupplier(@Nonnull InputStream inputStream, @Nullable char[] passphraseCharacters) {
        try {
            LOG.debug("Initializing private key");
            this.delegate = new PEMStreamRSAPrivateKeySupplier(inputStream, passphraseCharacters);
        }
        catch (IOException ex) {
            LOG.debug("Failed to read RSA private key from file ", (Throwable)ex);
            throw new PEMFileRSAPrivateKeySupplierException("Failed to read RSA private key from file ", ex);
        }
    }

    @Override
    @InternalSdk(backwardCompatibilityRequired=true)
    public Optional<RSAPrivateKey> supplyKey(@Nonnull String ignored) {
        return this.delegate.supplyKey(ignored);
    }

    @Nonnull
    @InternalSdk(backwardCompatibilityRequired=true)
    public Optional<RSAPrivateKey> supplyKey() {
        return this.supplyKey(null);
    }

    public static class PEMFileRSAPrivateKeySupplierException
    extends RuntimeException {
        public PEMFileRSAPrivateKeySupplierException(String message, Throwable cause) {
            super(message, cause);
        }

        public PEMFileRSAPrivateKeySupplierException(Throwable cause) {
            super(cause);
        }
    }
}

