/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import javax.sql.DataSource;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatabaseConfiguration
extends AbstractConfiguration {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$configuration$DatabaseConfiguration == null ? (class$org$apache$commons$configuration$DatabaseConfiguration = DatabaseConfiguration.class$("org.apache.commons.configuration.DatabaseConfiguration")) : class$org$apache$commons$configuration$DatabaseConfiguration));
    private DataSource datasource;
    private String table;
    private String nameColumn;
    private String keyColumn;
    private String valueColumn;
    private String name;
    static /* synthetic */ Class class$org$apache$commons$configuration$DatabaseConfiguration;

    public DatabaseConfiguration(DataSource datasource, String table, String nameColumn, String keyColumn, String valueColumn, String name) {
        this.datasource = datasource;
        this.table = table;
        this.nameColumn = nameColumn;
        this.keyColumn = keyColumn;
        this.valueColumn = valueColumn;
        this.name = name;
    }

    public DatabaseConfiguration(DataSource datasource, String table, String keyColumn, String valueColumn) {
        this(datasource, table, null, keyColumn, valueColumn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String key) {
        ArrayList<Object> result = null;
        StringBuffer query = new StringBuffer("SELECT * FROM " + this.table + " WHERE " + this.keyColumn + "=?");
        if (this.nameColumn != null) {
            query.append(" AND " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            ResultSet rs;
            conn = this.datasource.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            pstmt.setString(1, key);
            if (this.nameColumn != null) {
                pstmt.setString(2, this.name);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                result = rs.getObject(this.valueColumn);
            }
            if (rs.next()) {
                ArrayList<Object> results = new ArrayList<Object>();
                results.add(result);
                results.add(rs.getObject(this.valueColumn));
                while (rs.next()) {
                    results.add(rs.getObject(this.valueColumn));
                }
                result = results;
            }
            this.closeQuietly(conn, pstmt);
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                this.closeQuietly(conn, pstmt);
            }
            catch (Throwable throwable) {
                this.closeQuietly(conn, pstmt);
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPropertyDirect(String key, Object obj) {
        StringBuffer query = new StringBuffer("INSERT INTO " + this.table);
        if (this.nameColumn != null) {
            query.append(" (" + this.nameColumn + ", " + this.keyColumn + ", " + this.valueColumn + ") VALUES (?, ?, ?)");
        } else {
            query.append(" (" + this.keyColumn + ", " + this.valueColumn + ") VALUES (?, ?)");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.datasource.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            int index = 1;
            if (this.nameColumn != null) {
                pstmt.setString(index++, this.name);
            }
            pstmt.setString(index++, key);
            pstmt.setString(index++, String.valueOf(obj));
            pstmt.executeUpdate();
            this.closeQuietly(conn, pstmt);
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                this.closeQuietly(conn, pstmt);
            }
            catch (Throwable throwable) {
                this.closeQuietly(conn, pstmt);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean empty = true;
        StringBuffer query = new StringBuffer("SELECT count(*) FROM " + this.table);
        if (this.nameColumn != null) {
            query.append(" WHERE " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            ResultSet rs;
            conn = this.datasource.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            if (this.nameColumn != null) {
                pstmt.setString(1, this.name);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                empty = rs.getInt(1) == 0;
            }
            this.closeQuietly(conn, pstmt);
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                this.closeQuietly(conn, pstmt);
            }
            catch (Throwable throwable) {
                this.closeQuietly(conn, pstmt);
                throw throwable;
            }
        }
        return empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        boolean found = false;
        StringBuffer query = new StringBuffer("SELECT * FROM " + this.table + " WHERE " + this.keyColumn + "=?");
        if (this.nameColumn != null) {
            query.append(" AND " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.datasource.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            pstmt.setString(1, key);
            if (this.nameColumn != null) {
                pstmt.setString(2, this.name);
            }
            ResultSet rs = pstmt.executeQuery();
            found = rs.next();
            this.closeQuietly(conn, pstmt);
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                this.closeQuietly(conn, pstmt);
            }
            catch (Throwable throwable) {
                this.closeQuietly(conn, pstmt);
                throw throwable;
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProperty(String key) {
        StringBuffer query = new StringBuffer("DELETE FROM " + this.table + " WHERE " + this.keyColumn + "=?");
        if (this.nameColumn != null) {
            query.append(" AND " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.datasource.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            pstmt.setString(1, key);
            if (this.nameColumn != null) {
                pstmt.setString(2, this.name);
            }
            pstmt.executeUpdate();
            this.closeQuietly(conn, pstmt);
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                this.closeQuietly(conn, pstmt);
            }
            catch (Throwable throwable) {
                this.closeQuietly(conn, pstmt);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        StringBuffer query = new StringBuffer("DELETE FROM " + this.table);
        if (this.nameColumn != null) {
            query.append(" WHERE " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.datasource.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            if (this.nameColumn != null) {
                pstmt.setString(1, this.name);
            }
            pstmt.executeUpdate();
            this.closeQuietly(conn, pstmt);
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                this.closeQuietly(conn, pstmt);
            }
            catch (Throwable throwable) {
                this.closeQuietly(conn, pstmt);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        StringBuffer query = new StringBuffer("SELECT DISTINCT " + this.keyColumn + " FROM " + this.table);
        if (this.nameColumn != null) {
            query.append(" WHERE " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.datasource.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            if (this.nameColumn != null) {
                pstmt.setString(1, this.name);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                keys.add(rs.getString(1));
            }
            this.closeQuietly(conn, pstmt);
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                this.closeQuietly(conn, pstmt);
            }
            catch (Throwable throwable) {
                this.closeQuietly(conn, pstmt);
                throw throwable;
            }
        }
        return keys.iterator();
    }

    private void closeQuietly(Connection conn, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

