/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.policies.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ForwardedRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xwt.tools.ui.designer.commands.GridLayoutCommandsFactory;
import org.eclipse.xwt.tools.ui.designer.commands.NoOpCommand;
import org.eclipse.xwt.tools.ui.designer.editor.palette.CreateReqHelper;
import org.eclipse.xwt.tools.ui.designer.editor.palette.EntryHelper;
import org.eclipse.xwt.tools.ui.designer.layouts.LayoutType;
import org.eclipse.xwt.tools.ui.designer.parts.CompositeEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.MenuBarEditPart;
import org.eclipse.xwt.tools.ui.designer.policies.NewNonResizeEditPolicy;
import org.eclipse.xwt.tools.ui.designer.policies.NewResizableEditPolicy;
import org.eclipse.xwt.tools.ui.designer.policies.feedback.FeedbackHelper;
import org.eclipse.xwt.tools.ui.designer.policies.feedback.FeedbackManager;
import org.eclipse.xwt.tools.ui.designer.policies.layout.ILayoutEditPolicy;
import org.eclipse.xwt.tools.ui.designer.policies.layout.grid.GridController;
import org.eclipse.xwt.tools.ui.designer.policies.layout.grid.GridLayoutAddedCellFeedbackFigure;
import org.eclipse.xwt.tools.ui.designer.policies.layout.grid.GridLayoutColumnFigure;
import org.eclipse.xwt.tools.ui.designer.policies.layout.grid.GridLayoutFeedbackFigure;
import org.eclipse.xwt.tools.ui.designer.policies.layout.grid.GridLayoutGridFigure;
import org.eclipse.xwt.tools.ui.designer.policies.layout.grid.GridLayoutPolicyHelper;
import org.eclipse.xwt.tools.ui.designer.policies.layout.grid.GridLayoutRequest;
import org.eclipse.xwt.tools.ui.designer.policies.layout.grid.GridLayoutRowFigure;
import org.eclipse.xwt.tools.ui.designer.policies.layout.grid.GridLayoutSpanFeedbackFigure;
import org.eclipse.xwt.tools.ui.designer.policies.layout.grid.GridSpanHandle;
import org.eclipse.xwt.tools.ui.designer.policies.layout.grid.IGridListener;
import org.eclipse.xwt.tools.ui.palette.Entry;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class GridLayoutEditPolicy
extends LayoutEditPolicy
implements IGridListener,
ILayoutEditPolicy {
    public static final String REQ_GRIDLAYOUT_SPAN = "GridLayout span cells";
    public static final int DEFAULT_CELL_WIDTH = 40;
    public static final int DEFAULT_CELL_HEIGHT = 35;
    private static final int ADDEDCELLBORDER = 3;
    private GridController gridController;
    private boolean fShowGrid = false;
    private GridLayoutGridFigure fGridLayoutGridFigure;
    private GridLayoutSpanFeedbackFigure fGridLayoutSpanFigure;
    private GridLayoutFeedbackFigure fGridLayoutCellFigure;
    private IFigure fRowColFigure = null;
    private EditPartListener editPartListener;
    private GridLayoutPolicyHelper helper = new GridLayoutPolicyHelper();
    private FeedbackManager fbm = new FeedbackManager((GraphicalEditPolicy)this);
    protected FigureListener hostFigureListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            GridLayoutEditPolicy.this.refresh();
        }
    };

    public void activate() {
        this.helper.setHost((CompositeEditPart)this.getHost());
        this.gridController = new GridController();
        GridController.registerEditPart(this.getHost(), this.gridController);
        this.gridController.addGridListener(this);
        this.getHostFigure().addFigureListener(this.hostFigureListener);
        if (this.getHost().getSelected() == 1 || this.getHost().getSelected() == 2) {
            this.gridController.setGridShowing(true);
        }
        this.editPartListener = this.createEditPartListener();
        this.getHost().addEditPartListener(this.editPartListener);
        List children = this.getHost().getChildren();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            ((EditPart)iterator.next()).addEditPartListener(this.editPartListener);
        }
        super.activate();
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof MenuBarEditPart) {
            return new NewNonResizeEditPolicy(false);
        }
        return new NewResizableEditPolicy(20, true);
    }

    private EditPartListener createEditPartListener() {
        return new EditPartListener.Stub(){

            public void childAdded(EditPart editpart, int index) {
                if (GridLayoutEditPolicy.this.editPartListener != null) {
                    editpart.addEditPartListener(GridLayoutEditPolicy.this.editPartListener);
                }
                GridLayoutEditPolicy.this.helper.refresh();
                GridLayoutEditPolicy.this.refreshGridFigure();
            }

            public void removingChild(EditPart editpart, int index) {
                if (GridLayoutEditPolicy.this.editPartListener != null) {
                    editpart.removeEditPartListener(GridLayoutEditPolicy.this.editPartListener);
                }
                GridLayoutEditPolicy.this.helper.refresh();
                GridLayoutEditPolicy.this.refreshGridFigure();
            }

            public void selectedStateChanged(EditPart editpart) {
                if (editpart == null || editpart == GridLayoutEditPolicy.this.getHost() || GridLayoutEditPolicy.this.isChildEditPart(editpart) && (editpart.getSelected() == 1 || editpart.getSelected() == 2)) {
                    if (GridLayoutEditPolicy.this.gridController != null) {
                        GridLayoutEditPolicy.this.gridController.setGridShowing(true);
                    } else if (GridLayoutEditPolicy.this.gridController != null) {
                        GridLayoutEditPolicy.this.gridController.setGridShowing(false);
                    }
                } else if (GridLayoutEditPolicy.this.gridController != null && GridLayoutEditPolicy.this.gridController.isGridShowing()) {
                    GridLayoutEditPolicy.this.gridController.setGridShowing(false);
                }
            }
        };
    }

    private GridLayoutRequest createGridLayoutRequest(Point position) {
        return this.getGridLayoutGridFigure().getGridLayoutRequest(position, this.helper);
    }

    public void deactivate() {
        GridController gridController = GridController.getGridController(this.getHost());
        this.eraseGridFigure();
        if (gridController != null) {
            gridController.removeGridListener(this);
            GridController.unregisterEditPart(this.getHost());
        }
        this.getHostFigure().removeFigureListener(this.hostFigureListener);
        if (this.editPartListener != null) {
            this.getHost().removeEditPartListener(this.editPartListener);
            List children = this.getHost().getChildren();
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                ((EditPart)iterator.next()).removeEditPartListener(this.editPartListener);
            }
            this.editPartListener = null;
        }
        super.deactivate();
    }

    private void eraseGridFigure() {
        if (this.fGridLayoutGridFigure != null) {
            if (this.fGridLayoutGridFigure.getParent() != null) {
                this.removeFeedback((IFigure)this.fGridLayoutGridFigure);
            }
            this.fGridLayoutGridFigure = null;
        }
        this.fShowGrid = false;
    }

    public void eraseTargetFeedback(Request request) {
        this.fbm.eraseFeedback(request);
        if (!this.fShowGrid && this.fGridLayoutGridFigure != null) {
            if (this.fGridLayoutGridFigure.getParent() != null) {
                this.removeFeedback((IFigure)this.fGridLayoutGridFigure);
            }
            this.fGridLayoutGridFigure = null;
        }
        if (this.fGridLayoutSpanFigure != null) {
            this.removeFeedback((IFigure)this.fGridLayoutSpanFigure);
            this.fGridLayoutSpanFigure = null;
        }
        if (this.fGridLayoutCellFigure != null) {
            this.removeFeedback((IFigure)this.fGridLayoutCellFigure);
            this.fGridLayoutCellFigure = null;
        }
        if (this.fRowColFigure != null) {
            this.removeFeedback(this.fRowColFigure);
            this.fRowColFigure = null;
        }
        super.eraseTargetFeedback(request);
    }

    public Command getCommand(Request request) {
        if ("resize children".equals(request.getType())) {
            return this.getResizeCommand(request);
        }
        return super.getCommand(request);
    }

    private Command getResizeCommand(Request request) {
        ChangeBoundsRequest req = (ChangeBoundsRequest)request;
        CompoundCommand resize = new CompoundCommand();
        List children = req.getEditParts();
        int i = 0;
        while (i < children.size()) {
            GraphicalEditPart child = (GraphicalEditPart)children.get(i);
            Command c = this.createResizeChildrenCommand(request, (EditPart)child, req.getSizeDelta());
            resize.add(c);
            ++i;
        }
        return resize.unwrap();
    }

    protected Command createResizeChildrenCommand(Request request, EditPart child, Object newSize) {
        GridLayoutCommandsFactory factory = new GridLayoutCommandsFactory((CompositeEditPart)this.getHost());
        return factory.getResizeChildrenCommand(child, (ChangeBoundsRequest)request);
    }

    protected Command getAddCommand(Request request) {
        return this.getMoveChildrenCommand(request);
    }

    protected Command getCreateCommand(CreateRequest request) {
        CreateReqHelper reqHelper = new CreateReqHelper(request);
        if (!reqHelper.canCreate(this.getHost())) {
            return null;
        }
        if (this.fGridLayoutGridFigure == null) {
            return UnexecutableCommand.INSTANCE;
        }
        Point position = this.getLocationFromRequest((Request)request).getCopy();
        GridLayoutRequest gridReq = this.createGridLayoutRequest(position);
        Point cell = new Point(gridReq.column, gridReq.row);
        Entry entry = (Entry)request.getNewObject();
        XamlNode newObject = EntryHelper.getNode(entry);
        if (newObject == null) {
            return UnexecutableCommand.INSTANCE;
        }
        Object requestType = request.getType();
        this.helper.startRequest();
        switch (gridReq.type) {
            case 6: {
                this.helper.replaceFiller(newObject, requestType, cell);
                break;
            }
            case 1: {
                this.helper.insertColWithinRow(cell);
                this.helper.replaceFillerOrEmpty(newObject, requestType, cell);
                break;
            }
            case 0: 
            case 3: {
                this.helper.createNewCol(cell.x);
                this.helper.replaceFillerOrEmpty(newObject, requestType, cell);
                break;
            }
            case 2: 
            case 4: {
                this.helper.createNewRow(cell.y);
                this.helper.replaceFillerOrEmpty(newObject, requestType, cell);
                break;
            }
            case 7: {
                this.helper.replaceEmptyCell(newObject, requestType, cell);
                break;
            }
            case 5: {
                cell.setLocation(this.helper.getNumColumns(), this.helper.getNumRows());
                this.helper.createNewCol(cell.x);
                if (cell.x != 0 || cell.y != 0) {
                    this.helper.createNewRow(cell.y);
                }
                this.helper.replaceFillerOrEmpty(newObject, requestType, cell);
                break;
            }
            case -1: {
                return UnexecutableCommand.INSTANCE;
            }
        }
        Command result = this.helper.stopRequest();
        return result;
    }

    protected Command getDeleteDependantCommand(Request request) {
        EditPart editPart;
        if (request instanceof ForwardedRequest && (editPart = ((ForwardedRequest)request).getSender()) instanceof CompositeEditPart) {
            this.helper.setHost((CompositeEditPart)editPart);
            this.helper.startRequest();
            this.helper.deleteChild((XamlNode)editPart.getModel());
            return this.helper.stopRequest();
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getOrphanChildrenCommand(Request request) {
        if (request instanceof GroupRequest) {
            this.helper.startRequest();
            List children = this.getChildren((GroupRequest)request);
            this.helper.orphanChildren(children);
            return this.helper.stopRequest();
        }
        return UnexecutableCommand.INSTANCE;
    }

    public List getChildren(GroupRequest request) {
        List cEP = request.getEditParts();
        ArrayList<Object> children = new ArrayList<Object>(cEP.size());
        Iterator itr = cEP.iterator();
        while (itr.hasNext()) {
            Object child = ((EditPart)itr.next()).getModel();
            children.add(child);
        }
        return children;
    }

    public Rectangle getFullCellBounds(EditPart child) {
        if (this.getGridLayoutGridFigure() == null) {
            return new Rectangle();
        }
        Rectangle dims = this.helper.getChildDimensions((EObject)child.getModel());
        Rectangle bounds = dims != null ? this.getGridLayoutGridFigure().getGridBroundsForCellBounds(dims) : new Rectangle();
        return bounds;
    }

    protected GridLayoutGridFigure getGridLayoutGridFigure() {
        if (this.fGridLayoutGridFigure == null) {
            this.fGridLayoutGridFigure = new GridLayoutGridFigure(this.helper);
        }
        return this.fGridLayoutGridFigure;
    }

    public GridLayoutPolicyHelper getHelper() {
        return this.helper;
    }

    private Point getLocationFromRequest(Request request) {
        Point loc = ((DropRequest)request).getLocation().getCopy();
        this.getHostFigure().translateToRelative((Translatable)loc);
        return loc;
    }

    protected Command getMoveChildrenCommand(Request request) {
        if (this.fGridLayoutGridFigure == null || !(request instanceof ChangeBoundsRequest)) {
            return UnexecutableCommand.INSTANCE;
        }
        ChangeBoundsRequest req = (ChangeBoundsRequest)request;
        List editparts = req.getEditParts();
        if (editparts.size() > 1) {
            return UnexecutableCommand.INSTANCE;
        }
        XamlNode trueEObject = (XamlNode)((EditPart)editparts.get(0)).getModel();
        if (trueEObject == null) {
            return UnexecutableCommand.INSTANCE;
        }
        Point position = this.getLocationFromRequest(request).getCopy();
        GridLayoutRequest gridReq = this.createGridLayoutRequest(position);
        Point cell = new Point(gridReq.column, gridReq.row);
        Object requestType = request.getType();
        this.helper.startRequest();
        switch (gridReq.type) {
            case 6: {
                this.helper.replaceFiller(trueEObject, requestType, cell);
                break;
            }
            case 1: {
                this.helper.insertColWithinRow(cell);
                this.helper.replaceFillerOrEmpty(trueEObject, requestType, cell);
                break;
            }
            case 0: 
            case 3: {
                this.helper.createNewCol(cell.x);
                this.helper.replaceFillerOrEmpty(trueEObject, requestType, cell);
                break;
            }
            case 2: 
            case 4: {
                this.helper.createNewRow(cell.y);
                this.helper.replaceFillerOrEmpty(trueEObject, requestType, cell);
                break;
            }
            case 7: {
                this.helper.replaceEmptyCell(trueEObject, requestType, cell);
                break;
            }
            case 5: {
                cell.setLocation(this.helper.getNumColumns(), this.helper.getNumRows());
                this.helper.createNewCol(cell.x);
                if (cell.x != 0 || cell.y != 0) {
                    this.helper.createNewRow(cell.y);
                }
                this.helper.replaceFillerOrEmpty(trueEObject, requestType, cell);
                break;
            }
            case -1: {
                return UnexecutableCommand.INSTANCE;
            }
        }
        Command command = this.helper.stopRequest();
        return command;
    }

    protected Command getSpanChildrenCommand(Request generic) {
        ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
        List editParts = request.getEditParts();
        if (editParts.isEmpty() || editParts.size() > 1) {
            return UnexecutableCommand.INSTANCE;
        }
        Point spanToPosition = this.getLocationFromRequest((Request)request).getCopy();
        Point spanToCellLocation = this.getGridLayoutGridFigure().getCellLocation(spanToPosition.x, spanToPosition.y);
        Dimension dim = request.getSizeDelta();
        int handleSizeOffset = GridSpanHandle.HANDLE_SIZE / 2;
        Point startPosition = new Point(spanToPosition.x - dim.width - handleSizeOffset, spanToPosition.y - dim.height - handleSizeOffset);
        GraphicalEditPart ep = (GraphicalEditPart)editParts.get(0);
        EObject child = (EObject)ep.getModel();
        Point childCellLocation = this.helper.getChildDimensions(child).getLocation();
        Point startCellLocation = this.getGridLayoutGridFigure().getCellLocation(startPosition);
        if (spanToCellLocation.x >= childCellLocation.x && spanToCellLocation.y >= childCellLocation.y && (spanToCellLocation.x != startCellLocation.x || spanToCellLocation.y != startCellLocation.y)) {
            this.helper.startRequest();
            this.helper.spanChild(child, new Point(spanToCellLocation.x - childCellLocation.x + 1, spanToCellLocation.y - childCellLocation.y + 1), request.getResizeDirection(), null);
            return this.helper.stopRequest();
        }
        return NoOpCommand.INSTANCE;
    }

    @Override
    public void gridHeightChanged(int gridHeight, int oldGridHeight) {
    }

    @Override
    public void gridMarginChanged(int gridMargin, int oldGridMargin) {
    }

    @Override
    public void gridVisibilityChanged(boolean showGrid) {
        if (showGrid) {
            this.showGridFigure();
        } else {
            this.eraseGridFigure();
        }
    }

    @Override
    public void gridWidthChanged(int gridWidth, int oldGridWidth) {
    }

    private boolean isChildEditPart(EditPart ep) {
        List children;
        if (ep != null && !(children = this.getHost().getChildren()).isEmpty()) {
            return children.indexOf(ep) != -1;
        }
        return false;
    }

    protected void refreshGridFigure() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (GridLayoutEditPolicy.this.fShowGrid) {
                    GridLayoutEditPolicy.this.eraseGridFigure();
                    GridLayoutEditPolicy.this.showGridFigure();
                } else {
                    GridLayoutEditPolicy.this.fGridLayoutGridFigure = null;
                }
            }
        });
    }

    protected void showAddedCellFeedback(Rectangle cellBounds) {
        cellBounds = cellBounds.getExpanded(cellBounds.width < 10 ? 20 : 0, cellBounds.height < 10 ? 20 : 0);
        this.fRowColFigure = new GridLayoutAddedCellFeedbackFigure();
        this.fRowColFigure.setBounds(cellBounds);
        this.addFeedback(this.fRowColFigure);
    }

    protected void showColumnFeedBackWithinARow(Rectangle cellBounds) {
        cellBounds = cellBounds.getCopy();
        cellBounds.x -= 3;
        cellBounds.width = 6;
        this.fRowColFigure = new GridLayoutColumnFigure(cellBounds);
        this.addFeedback(this.fRowColFigure);
    }

    private void showGridFigure() {
        if (!this.fShowGrid) {
            this.fShowGrid = true;
            this.addFeedback((IFigure)this.getGridLayoutGridFigure());
        }
        this.fShowGrid = true;
    }

    public void showTargetFeedback(Request request) {
        if (!("create child".equals(request.getType()) && request instanceof CreateRequest && FeedbackHelper.showCreationFeedback(this.fbm, (CreateRequest)request))) {
            super.showTargetFeedback(request);
        }
    }

    protected void showLayoutTargetFeedback(Request request) {
        if (!"create child".equals(request.getType()) || !FeedbackHelper.showCreationFeedback(this.fbm, (CreateRequest)request)) {
            super.showLayoutTargetFeedback(request);
        }
        if (!this.fShowGrid) {
            this.addFeedback((IFigure)this.getGridLayoutGridFigure());
        }
        if (this.fRowColFigure != null) {
            this.removeFeedback(this.fRowColFigure);
            this.fRowColFigure = null;
        }
        if (this.fGridLayoutCellFigure != null) {
            this.removeFeedback((IFigure)this.fGridLayoutCellFigure);
            this.fGridLayoutCellFigure = null;
        }
        Point position = this.getLocationFromRequest(request).getCopy();
        GridLayoutRequest gridReq = this.createGridLayoutRequest(position);
        Point cell = new Point(gridReq.column, gridReq.row);
        Rectangle cellBounds = this.getGridLayoutGridFigure().getCellBounds(cell);
        switch (gridReq.type) {
            case 0: {
                this.showNewColumnFeedBack(gridReq.column);
                Rectangle colFigBounds = this.fRowColFigure.getBounds();
                cellBounds.width = 40;
                if (cellBounds.height < 10) {
                    cellBounds.expand(0, 20);
                }
                cellBounds.x = colFigBounds.x + colFigBounds.width / 2 - cellBounds.width / 2;
                break;
            }
            case 2: {
                this.showNewRowFeedBack(gridReq.row);
                Rectangle rowFigBounds = this.fRowColFigure.getBounds();
                cellBounds.height = 35;
                if (cellBounds.width < 10) {
                    cellBounds.expand(20, 0);
                }
                cellBounds.y = rowFigBounds.y + rowFigBounds.height / 2 - cellBounds.height / 2;
                break;
            }
            case 1: {
                this.showColumnFeedBackWithinARow(cellBounds);
                Rectangle colFigBounds = this.fRowColFigure.getBounds();
                cellBounds.width = 40;
                if (cellBounds.height < 10) {
                    cellBounds.expand(0, 20);
                }
                cellBounds.x = colFigBounds.x + colFigBounds.width / 2 - cellBounds.width / 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.showAddedCellFeedback(cellBounds);
                Rectangle colFigBounds = this.fRowColFigure.getBounds();
                cellBounds = colFigBounds.getCopy().shrink(3, 3);
                break;
            }
            case -1: {
                return;
            }
        }
        if (this.fGridLayoutCellFigure == null) {
            this.fGridLayoutCellFigure = new GridLayoutFeedbackFigure();
        }
        this.fGridLayoutCellFigure.setBounds(cellBounds);
        this.addFeedback((IFigure)this.fGridLayoutCellFigure);
    }

    protected void showNewColumnFeedBack(int col) {
        Rectangle rect = this.fGridLayoutGridFigure.getColumnRectangle(col);
        rect.x -= 3;
        rect.width = 6;
        this.fRowColFigure = new GridLayoutColumnFigure(rect);
        this.addFeedback(this.fRowColFigure);
    }

    protected void showNewRowFeedBack(int row) {
        Rectangle rect = this.fGridLayoutGridFigure.getRowRectangle(row);
        rect.translate(-2, -3);
        rect.width += 4;
        rect.height = 6;
        this.fRowColFigure = new GridLayoutRowFigure(rect);
        this.addFeedback(this.fRowColFigure);
    }

    public void showSpanTargetFeedback(ChangeBoundsRequest request) {
        if (!this.fShowGrid) {
            this.addFeedback((IFigure)this.getGridLayoutGridFigure());
        }
        Point spanToPosition = request.getLocation().getCopy();
        GraphicalEditPart ep = (GraphicalEditPart)request.getEditParts().get(0);
        EObject child = (EObject)ep.getModel();
        Rectangle childDim = this.getHelper().getChildDimensions(child);
        Rectangle startCellBounds = this.getGridLayoutGridFigure().getCellBounds(childDim.getLocation());
        Rectangle endCellChildBounds = this.getGridLayoutGridFigure().getCellBounds(childDim.getBottomRight().translate(-1, -1));
        if (request.getResizeDirection() == 16 || request.getResizeDirection() == 8) {
            spanToPosition.y = endCellChildBounds.y;
        } else {
            spanToPosition.x = endCellChildBounds.x + endCellChildBounds.width - 1;
        }
        Rectangle endCellBounds = this.getGridLayoutGridFigure().getCellBounds(this.getGridLayoutGridFigure().getCellLocation(spanToPosition));
        if (endCellBounds == null || endCellBounds.x < startCellBounds.x || endCellBounds.y < startCellBounds.y) {
            if (this.fGridLayoutSpanFigure != null) {
                this.removeFeedback((IFigure)this.fGridLayoutSpanFigure);
                this.fGridLayoutSpanFigure = null;
            }
            return;
        }
        Rectangle spanrect = startCellBounds.union(endCellBounds).resize(-1, -1);
        if (this.fGridLayoutSpanFigure == null) {
            this.fGridLayoutSpanFigure = new GridLayoutSpanFeedbackFigure(request.getResizeDirection());
        }
        this.fGridLayoutSpanFigure.setLayoutFigureBounds(spanrect);
        this.addFeedback((IFigure)this.fGridLayoutSpanFigure);
    }

    @Override
    public void refresh() {
        this.helper.refresh();
        this.refreshGridFigure();
    }

    @Override
    public LayoutType getType() {
        return LayoutType.GridLayout;
    }
}

