/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.core.images;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xwt.tools.ui.designer.core.images.IImageListener;

public class ImageNotifierSupport {
    protected ListenerList imageListeners = null;

    public synchronized void addImageListener(IImageListener aListener) {
        if (this.imageListeners == null) {
            this.imageListeners = new ListenerList(1);
        }
        this.imageListeners.add((Object)aListener);
    }

    public synchronized void fireImageChanged(Image image) {
        Object[] listeners = this.imageListeners.getListeners();
        if (listeners != null) {
            int i = 0;
            while (i < listeners.length) {
                ((IImageListener)listeners[i]).imageChanged(image);
                ++i;
            }
        }
    }

    public synchronized boolean hasImageListeners() {
        return this.imageListeners != null && !this.imageListeners.isEmpty();
    }

    public synchronized void removeImageListener(IImageListener aListener) {
        if (this.imageListeners != null) {
            this.imageListeners.remove((Object)aListener);
        }
    }
}

