/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.orm.Embeddable;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.MappedSuperclass;
import org.eclipse.dali.orm.NullTypeMapping;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.orm.provider.PersistentTypeItemProvider;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.EmbeddableComposite;
import org.eclipse.dali.ui.views.EntityComposite;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.MappedSuperclassComposite;
import org.eclipse.dali.ui.views.ScrolledPageContent;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.PageBook;

public class PersistentTypeComposite
extends Composite
implements IPersistenceComposite {
    private PersistentType persistentType;
    private PersistentTypeItemProvider persistentTypeItemProvider;
    private ComboViewer typeMappingCombo;
    public static final String NULL_TYPE_MAPPING_COMBO_CHOICE = DaliUiMessages.PersistentTypeComposite_notPersistent;
    public static final String ENTITY_COMBO_CHOICE = DaliUiMessages.PersistentTypeComposite_entity;
    public static final String EMBEDDABLE_TYPE_MAPPING_COMBO_CHOICE = DaliUiMessages.PersistentTypeComposite_embeddable;
    public static final String MAPPED_SUPERCLASS_COMBO_CHOICE = DaliUiMessages.PersistentTypeComposite_mappedSuperclass;
    private PageBook typePageBook;
    private Composite nullComposite;
    private EntityComposite entityComposite;
    private EmbeddableComposite embeddableComposite;
    private MappedSuperclassComposite mappedSuperclassComposite;
    private EditingDomain editingDomain;
    private INotifyChangedListener persistentTypeListener;
    private boolean populating;
    static /* synthetic */ Class class$0;

    public PersistentTypeComposite(Composite parent, EditingDomain editingDomain) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        OrmItemProviderAdapterFactory adapterFactory = new OrmItemProviderAdapterFactory();
        this.persistentTypeItemProvider = (PersistentTypeItemProvider)adapterFactory.createPersistentTypeAdapter();
        this.initializeLayout(adapterFactory);
    }

    private void initializeLayout(OrmItemProviderAdapterFactory adapterFactory) {
        this.setLayout((Layout)new FillLayout());
        ScrolledPageContent pageContent = new ScrolledPageContent(this);
        GridLayout layout = new GridLayout(2, false);
        Composite composite = pageContent.getBody();
        composite.setLayout((Layout)layout);
        Label mappingTypeLabel = new Label(composite, 16384);
        mappingTypeLabel.setText(DaliUiMessages.PersistentTypeComposite_mapAs);
        this.typeMappingCombo = this.buildTypeMappingCombo(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.typeMappingCombo.getCombo().setLayoutData((Object)gridData);
        this.typePageBook = new PageBook(composite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.typePageBook.setLayoutData((Object)gridData);
        this.nullComposite = new Composite((Composite)this.typePageBook, 0);
        this.entityComposite = new EntityComposite((Composite)this.typePageBook, this.editingDomain, adapterFactory);
        this.embeddableComposite = new EmbeddableComposite((Composite)this.typePageBook, this.editingDomain, adapterFactory);
        this.mappedSuperclassComposite = new MappedSuperclassComposite((Composite)this.typePageBook, this.editingDomain, adapterFactory);
        this.typePageBook.showPage((Control)this.entityComposite);
    }

    private ComboViewer buildTypeMappingCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add((Object)NULL_TYPE_MAPPING_COMBO_CHOICE);
        viewer.add((Object)ENTITY_COMBO_CHOICE);
        viewer.add((Object)EMBEDDABLE_TYPE_MAPPING_COMBO_CHOICE);
        viewer.add((Object)MAPPED_SUPERCLASS_COMBO_CHOICE);
        viewer.setSelection((ISelection)new StructuredSelection((Object)NULL_TYPE_MAPPING_COMBO_CHOICE));
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PersistentTypeComposite.this.typeMappingChanged(event);
            }
        });
        return viewer;
    }

    private void typeMappingChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof StructuredSelection) {
            String selection = (String)((StructuredSelection)event.getSelection()).getFirstElement();
            if (selection.equals(NULL_TYPE_MAPPING_COMBO_CHOICE)) {
                this.persistentType.setTypeMappingKey((TypeMapping.Key)NullTypeMapping.Key.INSTANCE);
            } else if (selection.equals(ENTITY_COMBO_CHOICE)) {
                this.persistentType.setTypeMappingKey((TypeMapping.Key)Entity.Key.INSTANCE);
            } else if (selection.equals(EMBEDDABLE_TYPE_MAPPING_COMBO_CHOICE)) {
                this.persistentType.setTypeMappingKey((TypeMapping.Key)Embeddable.Key.INSTANCE);
            } else if (selection.equals(MAPPED_SUPERCLASS_COMBO_CHOICE)) {
                this.persistentType.setTypeMappingKey((TypeMapping.Key)MappedSuperclass.Key.INSTANCE);
            }
        }
    }

    public void populate(EObject persistentType) {
        this.populating = true;
        if (this.persistentType != null) {
            this.persistentType.eAdapters().remove((Object)this.persistentTypeItemProvider);
            this.persistentTypeItemProvider.removeListener(this.getPersistentTypeListener());
        }
        this.persistentType = (PersistentType)persistentType;
        if (this.persistentType == null) {
            this.populate((TypeMapping)null);
            return;
        }
        this.persistentTypeItemProvider.addListener(this.getPersistentTypeListener());
        this.persistentType.eAdapters().add((Object)this.persistentTypeItemProvider);
        this.populate(this.persistentType.getTypeMapping());
        this.populating = false;
    }

    private void populate(TypeMapping typeMapping) {
        TypeMapping.Key typeMappingKey;
        this.unpopulateSubPanels();
        TypeMapping.Key key = typeMappingKey = typeMapping == null ? null : typeMapping.getKey();
        if (typeMappingKey == null) {
            return;
        }
        if (NullTypeMapping.Key.INSTANCE.equals(typeMappingKey)) {
            this.typePageBook.showPage((Control)this.nullComposite);
            this.typeMappingCombo.setSelection((ISelection)new StructuredSelection((Object)NULL_TYPE_MAPPING_COMBO_CHOICE));
        } else if (Entity.Key.INSTANCE.equals(typeMappingKey)) {
            this.typePageBook.showPage((Control)this.entityComposite);
            this.entityComposite.populate((EObject)typeMapping);
            this.typeMappingCombo.setSelection((ISelection)new StructuredSelection((Object)ENTITY_COMBO_CHOICE));
        } else if (Embeddable.Key.INSTANCE.equals(typeMappingKey)) {
            this.typePageBook.showPage((Control)this.embeddableComposite);
            this.embeddableComposite.populate((EObject)typeMapping);
            this.typeMappingCombo.setSelection((ISelection)new StructuredSelection((Object)EMBEDDABLE_TYPE_MAPPING_COMBO_CHOICE));
        } else if (MappedSuperclass.Key.INSTANCE.equals(typeMappingKey)) {
            this.typePageBook.showPage((Control)this.mappedSuperclassComposite);
            this.mappedSuperclassComposite.populate((EObject)typeMapping);
            this.typeMappingCombo.setSelection((ISelection)new StructuredSelection((Object)MAPPED_SUPERCLASS_COMBO_CHOICE));
        }
    }

    private void unpopulateSubPanels() {
        this.entityComposite.populate(null);
        this.embeddableComposite.populate(null);
        this.mappedSuperclassComposite.populate(null);
    }

    private INotifyChangedListener getPersistentTypeListener() {
        if (this.persistentTypeListener == null) {
            this.persistentTypeListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.dali.orm.PersistentType");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (notification.getFeatureID((Class)clazz) == 2) {
                        TypeMapping typeMapping = (TypeMapping)notification.getNewValue();
                        Display.getDefault().asyncExec(new Runnable(this, typeMapping){
                            final /* synthetic */ 2 this$1;
                            private final /* synthetic */ TypeMapping val$typeMapping;
                            {
                                this.this$1 = var1_1;
                                this.val$typeMapping = typeMapping;
                            }

                            public void run() {
                                PersistentTypeComposite.access$1(2.access$0(this.this$1), this.val$typeMapping);
                            }
                        });
                    }
                }

                static /* synthetic */ PersistentTypeComposite access$0(2 var0) {
                    return var0.PersistentTypeComposite.this;
                }
            };
        }
        return this.persistentTypeListener;
    }

    public boolean setFocus() {
        super.setFocus();
        return this.typeMappingCombo.getCombo().setFocus();
    }

    public void dispose() {
        this.persistentTypeItemProvider.removeListener(this.persistentTypeListener);
        this.entityComposite.dispose();
        this.embeddableComposite.dispose();
        this.mappedSuperclassComposite.dispose();
        super.dispose();
    }

    public EObject getEObject() {
        return this.persistentType;
    }

    static /* synthetic */ void access$1(PersistentTypeComposite persistentTypeComposite, TypeMapping typeMapping) {
        persistentTypeComposite.populate(typeMapping);
    }
}

