/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.orm.Column;
import org.eclipse.dali.orm.adapters.IColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.BooleanAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.ColumnInfoAdapter;
import org.eclipse.dali.orm.adapters.java.ColumnInsertableInfo;
import org.eclipse.dali.orm.adapters.java.ColumnUpdatableInfo;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.jdt.core.dom.CompilationUnit;

abstract class AbstractJavaColumnModelAdapter
implements IColumnModelAdapter {
    Column column;
    private IColumnModelAdapter.ColumnOwner owner;
    private BooleanAnnotationElementAdapter insertableAdapter;
    private BooleanAnnotationElementAdapter updatableAdapter;

    AbstractJavaColumnModelAdapter(IColumnModelAdapter.ColumnOwner owner) {
        this.owner = owner;
        this.insertableAdapter = new BooleanAnnotationElementAdapter(this.buildInsertableInfo());
        this.updatableAdapter = new BooleanAnnotationElementAdapter(this.buildUpdatableInfo());
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildInsertableInfo() {
        return new ColumnInsertableInfo(this.buildColumnInfoAdapter());
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildUpdatableInfo() {
        return new ColumnUpdatableInfo(this.buildColumnInfoAdapter());
    }

    private ColumnInfoAdapter buildColumnInfoAdapter() {
        return new ColumnInfoAdapter(){

            public Column column() {
                return AbstractJavaColumnModelAdapter.this.column;
            }

            public Member member() {
                return AbstractJavaColumnModelAdapter.this.member();
            }
        };
    }

    protected void updatePersModel(CompilationUnit astRoot) {
        this.updatePersInsertable(astRoot);
        this.updatePersUpdatable(astRoot);
    }

    private void updatePersInsertable(CompilationUnit astRoot) {
        this.insertableAdapter.updatePersElement(astRoot);
    }

    private void updatePersUpdatable(CompilationUnit astRoot) {
        this.updatableAdapter.updatePersElement(astRoot);
    }

    public IColumnModelAdapter.ColumnOwner getOwner() {
        return this.owner;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    protected abstract Member member();

    public void insertableChanged() {
        this.insertableAdapter.updateJavaElement();
    }

    public void updatableChanged() {
        this.updatableAdapter.updateJavaElement();
    }
}

