/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.selection.tracker;

import java.util.Collection;
import org.eclipse.dali.ui.selection.notification.SelectionNotificationEvent;
import org.eclipse.dali.ui.selection.tracker.SelectionTracker;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;

public abstract class PartSelectionTracker
extends SelectionTracker
implements IPartListener {
    protected final IWorkbenchPart part;

    public PartSelectionTracker(IWorkbenchPart aPart) {
        this.part = aPart;
    }

    protected abstract EObject getEObjectAt(ISelection var1);

    protected abstract Collection getEObjectsAt(EObject var1);

    protected abstract void addListener();

    protected abstract void removeListener();

    public void selectionChanged(SelectionChangedEvent event) {
        EObject eObj = this.getEObjectAt(event.getSelection());
        Collection coll = this.getEObjectsAt(eObj);
        this.notifyChanged(SelectionNotificationEvent.SELECTION_CHANGED, eObj, coll, this.part);
    }

    public void partClosed(IWorkbenchPart aPart) {
        if (aPart.equals(this.part)) {
            this.part.getSite().getPage().removePartListener((IPartListener)this);
            EObject eObj = this.getEObjectAt(this.part.getSite().getSelectionProvider().getSelection());
            Collection coll = this.getEObjectsAt(eObj);
            this.notifyChanged(SelectionNotificationEvent.CLOSED, eObj, coll, this.part);
        }
    }

    public void partActivated(IWorkbenchPart aPart) {
        if (aPart.equals(this.part)) {
            EObject eObj = this.getEObjectAt(this.part.getSite().getSelectionProvider().getSelection());
            Collection coll = this.getEObjectsAt(eObj);
            this.notifyChanged(SelectionNotificationEvent.ACTIVATED, eObj, coll, this.part);
            this.addListener();
        }
    }

    public void partOpened(IWorkbenchPart aPart) {
        if (aPart.equals(this.part)) {
            this.part.getSite().getPage().addPartListener((IPartListener)this);
            EObject eObj = this.getEObjectAt(this.part.getSite().getSelectionProvider().getSelection());
            Collection coll = this.getEObjectsAt(eObj);
            this.notifyChanged(SelectionNotificationEvent.OPENED, eObj, coll, this.part);
        }
    }

    public void partDeactivated(IWorkbenchPart aPart) {
        if (aPart.equals(this.part)) {
            this.removeListener();
            EObject eObj = this.getEObjectAt(this.part.getSite().getSelectionProvider().getSelection());
            Collection coll = this.getEObjectsAt(eObj);
            this.notifyChanged(SelectionNotificationEvent.DEACTIVATED, eObj, coll, this.part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart aPart) {
        if (aPart.equals(this.part)) {
            EObject eObj = this.getEObjectAt(this.part.getSite().getSelectionProvider().getSelection());
            Collection coll = this.getEObjectsAt(eObj);
            this.notifyChanged(SelectionNotificationEvent.BROUGHT_TO_TOP, eObj, coll, this.part);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PartSelectionTracker) {
            PartSelectionTracker tracker = (PartSelectionTracker)obj;
            if (tracker.part.equals(this.part)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.part.hashCode();
    }
}

