/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.api.model.datatype;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PrimitiveType implements Enumerator
{
    STRING(0, "string", "string"),
    INT(1, "int", "int"),
    FLOAT(2, "float", "float"),
    BOOLEAN(3, "boolean", "boolean"),
    DATETIME(4, "datetime", "dateTime"),
    DOUBLE(5, "double", "double"),
    LONG(6, "long", "long"),
    SHORT(7, "short", "short"),
    BASE64_BINARY(8, "base64Binary", "base64Binary"),
    BYTE(9, "byte", "byte");

    public static final String copyright = "Copyright (c) 2017 Bosch Software Innovations GmbH and others.\nAll rights reserved. This program and the accompanying materials\nare made available under the terms of the Eclipse Public License v1.0\nand Eclipse Distribution License v1.0 which accompany this distribution.\n \nThe Eclipse Public License is available at\nhttp://www.eclipse.org/legal/epl-v10.html\nThe Eclipse Distribution License is available at\nhttp://www.eclipse.org/org/documents/edl-v10.php.\n\nContributors:\nBosch Software Innovations GmbH - Please refer to git log\n\n*******************************************************************************\ngenerated by Datatype.genmodel";
    public static final int STRING_VALUE = 0;
    public static final int INT_VALUE = 1;
    public static final int FLOAT_VALUE = 2;
    public static final int BOOLEAN_VALUE = 3;
    public static final int DATETIME_VALUE = 4;
    public static final int DOUBLE_VALUE = 5;
    public static final int LONG_VALUE = 6;
    public static final int SHORT_VALUE = 7;
    public static final int BASE64_BINARY_VALUE = 8;
    public static final int BYTE_VALUE = 9;
    private static final PrimitiveType[] VALUES_ARRAY;
    public static final List<PrimitiveType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PrimitiveType[]{STRING, INT, FLOAT, BOOLEAN, DATETIME, DOUBLE, LONG, SHORT, BASE64_BINARY, BYTE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PrimitiveType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveType get(int value) {
        switch (value) {
            case 0: {
                return STRING;
            }
            case 1: {
                return INT;
            }
            case 2: {
                return FLOAT;
            }
            case 3: {
                return BOOLEAN;
            }
            case 4: {
                return DATETIME;
            }
            case 5: {
                return DOUBLE;
            }
            case 6: {
                return LONG;
            }
            case 7: {
                return SHORT;
            }
            case 8: {
                return BASE64_BINARY;
            }
            case 9: {
                return BYTE;
            }
        }
        return null;
    }

    private PrimitiveType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

