/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.datatype.validation;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.vorto.core.api.model.datatype.Constraint;
import org.eclipse.vorto.core.api.model.datatype.DatatypePackage;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteral;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelPackage;
import org.eclipse.vorto.core.api.model.model.ModelReference;
import org.eclipse.vorto.editor.datatype.internal.validation.ConstraintValueValidator;
import org.eclipse.vorto.editor.datatype.validation.AbstractDatatypeValidator;
import org.eclipse.vorto.editor.datatype.validation.ConstraintValidatorFactory;
import org.eclipse.vorto.editor.datatype.validation.PropertyConstraintMappingValidation;
import org.eclipse.vorto.editor.datatype.validation.ValidatorUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class DatatypeValidator
extends AbstractDatatypeValidator {
    public final PropertyConstraintMappingValidation propertyValidator = new PropertyConstraintMappingValidation();

    @Check
    public void checkCircularRefInObjectPropertyType(ObjectPropertyType ref) {
        boolean _tripleNotEquals;
        Type _type = ref.getType();
        boolean bl = _tripleNotEquals = _type != null;
        if (_tripleNotEquals) {
            try {
                boolean _hasCircularReference;
                EObject _parentOfType = ValidatorUtils.getParentOfType((EObject)ref, Model.class);
                Model parent = (Model)_parentOfType;
                if (parent != null && (_hasCircularReference = ValidatorUtils.hasCircularReference(parent, (Model)ref.getType(), ValidatorUtils.entityTypeToChildrenSupplierFunction))) {
                    this.error("Object property type has circular reference", (EObject)ref, (EStructuralFeature)DatatypePackage.Literals.OBJECT_PROPERTY_TYPE__TYPE);
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    @Check
    public void checkCircularRefInSuperType(Entity entity) {
        boolean _tripleNotEquals;
        Entity _superType = entity.getSuperType();
        boolean bl = _tripleNotEquals = _superType != null;
        if (_tripleNotEquals) {
            try {
                boolean _hasCircularReference = ValidatorUtils.hasCircularReference((Model)entity, (Model)entity.getSuperType(), ValidatorUtils.entityTypeToChildrenSupplierFunction);
                if (_hasCircularReference) {
                    this.error("Super type has circular reference", (EObject)entity, (EStructuralFeature)DatatypePackage.Literals.ENTITY__SUPER_TYPE);
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    @Check
    public void checkConstraint(Property prop) {
        EList constraints = prop.getConstraintRule().getConstraints();
        if (((Object[])Conversions.unwrapArray((Object)constraints, Object.class)).length == 0 || prop.getType() instanceof ObjectPropertyType) {
            return;
        }
        PropertyType _type = prop.getType();
        PrimitivePropertyType primi = (PrimitivePropertyType)_type;
        boolean isMultiplcity = prop.isMultiplicity();
        for (Constraint constraint : constraints) {
            this.verifyConstraintForType(primi, constraint, isMultiplcity);
        }
    }

    public void verifyConstraintForType(PrimitivePropertyType primitivePropertyType, Constraint constraint, boolean isMultiplcity) {
        boolean _not;
        boolean _isValidConstraintType = this.isValidConstraintType(primitivePropertyType.getType(), constraint);
        boolean bl = _not = !_isValidConstraintType;
        if (_not) {
            this.error(this.propertyValidator.getErrorMessage(), (EObject)constraint, (EStructuralFeature)DatatypePackage.Literals.CONSTRAINT__TYPE);
        } else {
            boolean _not_1;
            ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator(constraint.getType());
            boolean _isValidConstraintValue = this.isValidConstraintValue(validator, primitivePropertyType.getType(), constraint);
            boolean bl2 = _not_1 = !_isValidConstraintValue;
            if (_not_1) {
                this.error(validator.getErrorMessage(), (EObject)constraint, (EStructuralFeature)DatatypePackage.Literals.CONSTRAINT__CONSTRAINT_VALUES);
            }
        }
        boolean _isMimeConstraint = this.isMimeConstraint(primitivePropertyType.getType().getName(), constraint);
        if (_isMimeConstraint && !isMultiplcity) {
            this.error("MIMEType only applies to byte array, have you forgotten to add 'multiple' ?", (EObject)constraint, (EStructuralFeature)DatatypePackage.Literals.CONSTRAINT__TYPE);
        }
    }

    public boolean isValidConstraintType(PrimitiveType primitiveType, Constraint constraint) {
        return this.propertyValidator.checkPropertyConstraints(primitiveType, constraint);
    }

    public boolean isValidConstraintValue(ConstraintValueValidator validator, PrimitiveType primitiveType, Constraint constraint) {
        return validator.evaluateValueType(primitiveType, constraint);
    }

    public boolean isMimeConstraint(String primitiveTypeName, Constraint constraint) {
        return Objects.equal((Object)"MIMETYPE", (Object)constraint.getType().getLiteral()) && Objects.equal((Object)"byte", (Object)primitiveTypeName);
    }

    @Check
    public void checkEnumName_Literal(Enum ent) {
        String name = ent.getName();
        boolean _isCamelCasedName = this.isCamelCasedName(name);
        if (_isCamelCasedName) {
            this.error("Enum name must begin with a capital letter", (EObject)ent, (EStructuralFeature)ModelPackage.Literals.MODEL__NAME);
        }
    }

    @Check
    public void checkDuplicatedLiteral(Enum enu) {
        EList list = enu.getEnums();
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < ((Object[])Conversions.unwrapArray((Object)list, Object.class)).length) {
            boolean _not;
            boolean _add = set.add(((EnumLiteral)list.get(i)).getName());
            boolean bl = _not = !_add;
            if (_not) {
                this.error("Enumeration literal has been defined", (EObject)list.get(i), (EStructuralFeature)DatatypePackage.Literals.ENUM_LITERAL__NAME);
            }
            ++i;
        }
    }

    @Check
    public void checkDuplicatedConstraint(Property feature) {
        HashSet<String> set = new HashSet<String>();
        EList list = feature.getConstraintRule().getConstraints();
        int i = 0;
        while (i < ((Object[])Conversions.unwrapArray((Object)list, Object.class)).length) {
            boolean _not;
            Constraint con = (Constraint)list.get(i);
            boolean _add = set.add(con.getType().getLiteral());
            boolean bl = _not = !_add;
            if (_not) {
                this.error("Constraint Type has been defined", (EObject)con, (EStructuralFeature)DatatypePackage.Literals.CONSTRAINT__TYPE);
            }
            ++i;
        }
    }

    @Check
    public void checkEntityName(Entity entity) {
        String name = entity.getName();
        boolean _isCamelCasedName = this.isCamelCasedName(name);
        if (_isCamelCasedName) {
            this.error("Entity name must begin with a capital letter", (EObject)entity, (EStructuralFeature)ModelPackage.Literals.MODEL__NAME);
        }
    }

    public boolean isCamelCasedName(String name) {
        boolean _isUpperCase = Character.isUpperCase(name.charAt(0));
        return !_isUpperCase;
    }

    public void checkDuplicatedProperty(List<Property> props) {
        HashSet<String> set = new HashSet<String>();
        for (Property pp : props) {
            boolean _not;
            boolean _add = set.add(pp.getName());
            boolean bl = _not = !_add;
            if (!_not) continue;
            this.error("Property name has been defined", (EObject)pp, (EStructuralFeature)DatatypePackage.Literals.PROPERTY__NAME);
        }
    }

    @Check
    public void checkPropertyIfInReferences(Property property) {
        EObject _parentOfType;
        Model topParent;
        PropertyType _type = property.getType();
        if (_type instanceof ObjectPropertyType && (topParent = (Model)(_parentOfType = ValidatorUtils.getParentOfType((EObject)property, Model.class))) != null && !ValidatorUtils.isTypeInReferences((Model)((ObjectPropertyType)property.getType()).getType(), (EList<ModelReference>)topParent.getReferences())) {
            this.error("This property type has not been imported", (EObject)property, (EStructuralFeature)DatatypePackage.Literals.PROPERTY__TYPE);
        }
    }
}

