/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace.indexer;

import java.util.ArrayList;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.FlatArray;
import org.eclipse.tracecompass.tmf.core.tests.trace.indexer.AbstractCheckpointCollectionTest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfPersistentlyIndexable;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;
import org.junit.Assert;
import org.junit.Test;

public class FlatArrayTest
extends AbstractCheckpointCollectionTest {
    private FlatArray fFlatArray;

    protected FlatArray createCollection() {
        this.fFlatArray = new FlatArray(this.getFile(), (ITmfPersistentlyIndexable)this.getTrace());
        this.fCheckpointCollection = this.fFlatArray;
        return this.fFlatArray;
    }

    @Override
    public boolean isPersistableCollection() {
        return true;
    }

    @Test
    public void testBinarySearch() {
        long i = 0L;
        while (i < 50000L) {
            TmfCheckpoint checkpoint = new TmfCheckpoint(TmfTimestamp.fromSeconds((long)i), (ITmfLocation)new TmfLongLocation(i), 0L);
            this.fFlatArray.insert((ITmfCheckpoint)checkpoint);
            ++i;
        }
        TmfCheckpoint expectedCheckpoint = new TmfCheckpoint(TmfTimestamp.fromSeconds((long)122L), (ITmfLocation)new TmfLongLocation(122L), 0L);
        int expectedRank = 122;
        long rank = this.fFlatArray.binarySearch((ITmfCheckpoint)expectedCheckpoint);
        ITmfCheckpoint found = this.fFlatArray.get(rank);
        Assert.assertEquals((long)expectedRank, (long)rank);
        Assert.assertEquals((Object)found, (Object)expectedCheckpoint);
    }

    @Test
    public void testInsertAlotCheckEquals() {
        ArrayList<Integer> list = this.insertAlot();
        this.fFlatArray = this.createCollection();
        int i = 0;
        while (i < 50000) {
            int checkpointIndex = list.get(i);
            TmfCheckpoint checkpoint = new TmfCheckpoint(TmfTimestamp.fromSeconds((long)(12345 + checkpointIndex)), (ITmfLocation)new TmfLongLocation(123456L + (long)checkpointIndex), (long)checkpointIndex);
            ITmfCheckpoint found = this.fFlatArray.get((long)checkpointIndex);
            Assert.assertEquals((Object)checkpoint, (Object)found);
            ++i;
        }
    }
}

