/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.filter;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterNode;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public abstract class TmfFilterTreeNodeTestBase {
    protected static final @NonNull ITmfTrace TRACE = new TmfTraceStub();
    protected static final @NonNull String FIELD = "field";
    protected static final ITmfFilterTreeNode TRUE_NODE = new TmfFilterNode(null){

        public boolean matches(ITmfEvent event) {
            return true;
        }
    };
    protected static final ITmfFilterTreeNode FALSE_NODE = new TmfFilterNode(null){

        public boolean matches(ITmfEvent event) {
            return false;
        }
    };
    protected static final ITmfEventType EVENT_TYPE = new TmfEventType("Type", TmfEventField.makeRoot((String[])new String[]{"field"}));
    protected ITmfFilterTreeNode fFilterNode;

    @AfterClass
    public static void disposeTrace() {
        TRACE.dispose();
    }

    @Test
    public void testDefaults() {
        Assert.assertNull((String)"getParent()", (Object)this.fFilterNode.getParent());
        Assert.assertEquals((String)"hasChildren()", (Object)false, (Object)this.fFilterNode.hasChildren());
        Assert.assertEquals((String)"getChildrenCount()", (long)0L, (long)this.fFilterNode.getChildrenCount());
        Assert.assertEquals((String)"getChildren()", (long)0L, (long)this.fFilterNode.getChildren().length);
    }

    @Test
    public void testClone() {
        ITmfFilterTreeNode clone = this.fFilterNode.clone();
        Assert.assertFalse((String)"clone().equals()", (boolean)this.fFilterNode.equals(clone));
        Assert.assertFalse((String)"clone() ==", (this.fFilterNode == clone ? 1 : 0) != 0);
        Assert.assertEquals((String)"clone().toString.equals()", (Object)this.fFilterNode.toString(), (Object)clone.toString());
        Assert.assertNull((String)"clone().getParent()", (Object)clone.getParent());
    }

    @Test
    public void testAddChild() {
        ITmfFilterTreeNode child = this.fFilterNode.clone();
        Assert.assertEquals((String)"addChild()", (long)0L, (long)this.fFilterNode.addChild(child));
        Assert.assertEquals((String)"hasChildren()", (Object)true, (Object)this.fFilterNode.hasChildren());
        Assert.assertEquals((String)"removeChild()", (Object)child, (Object)this.fFilterNode.removeChild(child));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetChild() {
        this.fFilterNode.getChild(0);
    }

    @Test
    public void testRemove() {
        ITmfFilterTreeNode child = this.fFilterNode.clone();
        Assert.assertEquals((String)"addChild()", (long)0L, (long)this.fFilterNode.addChild(child));
        Assert.assertEquals((String)"remove()", (Object)child, (Object)child.remove());
        Assert.assertEquals((String)"hasChildren()", (Object)false, (Object)this.fFilterNode.hasChildren());
    }

    @Test
    public void testRemoveChild() {
        ITmfFilterTreeNode child = this.fFilterNode.clone();
        Assert.assertEquals((String)"addChild()", (long)0L, (long)this.fFilterNode.addChild(child));
        Assert.assertEquals((String)"removeChild()", (Object)child, (Object)this.fFilterNode.removeChild(child));
        Assert.assertEquals((String)"hasChildren()", (Object)false, (Object)this.fFilterNode.hasChildren());
    }

    @Test
    public void testReplaceChild() {
        ITmfFilterTreeNode child1 = this.fFilterNode.clone();
        ITmfFilterTreeNode child2 = this.fFilterNode.clone();
        child1.addChild(child1.clone());
        Assert.assertEquals((String)"addChild()", (long)0L, (long)this.fFilterNode.addChild(child1));
        Assert.assertEquals((String)"getChild()", (Object)child1, (Object)this.fFilterNode.getChild(0));
        Assert.assertEquals((String)"replaceChild()", (Object)child1, (Object)this.fFilterNode.replaceChild(0, child2));
        Assert.assertEquals((String)"getChildrenCount()", (long)1L, (long)this.fFilterNode.getChildrenCount());
        Assert.assertEquals((String)"getChild()", (Object)child2, (Object)this.fFilterNode.getChild(0));
        Assert.assertEquals((String)"removeChild()", (Object)child2, (Object)this.fFilterNode.removeChild(child2));
    }
}

