/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.analysis;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisModuleHelperConfigElement;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.AnalysisRequirementFactory;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestAnalysis;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestAnalysis2;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub2;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub3;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class AnalysisModuleHelperTest {
    private static final @NonNull String ANALYSIS_TRACETYPE_ID = "org.eclipse.linuxtools.tmf.core.tests.analysis.testtracetype";
    private IAnalysisModuleHelper fModule;
    private IAnalysisModuleHelper fModuleOther;
    private IAnalysisModuleHelper fReqModule;
    private IAnalysisModuleHelper fTraceTypeModule;
    private ITmfTrace fTrace;

    private static IAnalysisModuleHelper getModuleHelper(@NonNull String moduleId) {
        Multimap helpers = TmfAnalysisManager.getAnalysisModules();
        Assert.assertEquals((long)1L, (long)helpers.get((Object)moduleId).size());
        return (IAnalysisModuleHelper)helpers.get((Object)moduleId).iterator().next();
    }

    @Before
    public void getModules() {
        this.fModule = AnalysisModuleHelperTest.getModuleHelper("org.eclipse.linuxtools.tmf.core.tests.analysis.test");
        Assert.assertNotNull((Object)this.fModule);
        Assert.assertTrue((boolean)(this.fModule instanceof TmfAnalysisModuleHelperConfigElement));
        this.fModuleOther = AnalysisModuleHelperTest.getModuleHelper("org.eclipse.linuxtools.tmf.core.tests.analysis.testother");
        Assert.assertNotNull((Object)this.fModuleOther);
        Assert.assertTrue((boolean)(this.fModuleOther instanceof TmfAnalysisModuleHelperConfigElement));
        this.fReqModule = AnalysisModuleHelperTest.getModuleHelper("org.eclipse.linuxtools.tmf.core.tests.analysis.reqtest");
        Assert.assertNotNull((Object)this.fReqModule);
        Assert.assertTrue((boolean)(this.fReqModule instanceof TmfAnalysisModuleHelperConfigElement));
        this.fTraceTypeModule = AnalysisModuleHelperTest.getModuleHelper(ANALYSIS_TRACETYPE_ID);
        Assert.assertNotNull((Object)this.fTraceTypeModule);
        Assert.assertTrue((boolean)(this.fTraceTypeModule instanceof TmfAnalysisModuleHelperConfigElement));
        this.fTrace = TmfTestTrace.A_TEST_10K2.getTraceAsStub2();
    }

    @After
    public void cleanupTraces() {
        TmfTestTrace.A_TEST_10K.dispose();
        this.fTrace.dispose();
    }

    @Test
    public void testHelperGetters() {
        Assert.assertEquals((Object)"org.eclipse.linuxtools.tmf.core.tests.analysis.test", (Object)this.fModule.getId());
        Assert.assertEquals((Object)"Test analysis", (Object)this.fModule.getName());
        Assert.assertFalse((boolean)this.fModule.isAutomatic());
        Bundle helperbundle = this.fModule.getBundle();
        Bundle thisbundle = Platform.getBundle((String)"org.eclipse.tracecompass.tmf.core.tests");
        Assert.assertNotNull((Object)helperbundle);
        Assert.assertEquals((Object)thisbundle, (Object)helperbundle);
        Assert.assertEquals((Object)"org.eclipse.linuxtools.tmf.core.tests.analysis.testother", (Object)this.fModuleOther.getId());
        Assert.assertEquals((Object)"Test other analysis", (Object)this.fModuleOther.getName());
        Assert.assertTrue((boolean)this.fModuleOther.isAutomatic());
    }

    @Test
    public void testAppliesToTrace() {
        Assert.assertFalse((boolean)this.fModule.appliesToTraceType(TmfTrace.class));
        Assert.assertTrue((boolean)this.fModule.appliesToTraceType(TmfTraceStub.class));
        Assert.assertTrue((boolean)this.fModule.appliesToTraceType(TmfTraceStub2.class));
        Assert.assertFalse((boolean)this.fModule.appliesToTraceType(TmfTraceStub3.class));
        Assert.assertFalse((boolean)this.fModule.appliesToTraceType(TmfExperiment.class));
        Assert.assertFalse((boolean)this.fModuleOther.appliesToTraceType(TmfTrace.class));
        Assert.assertFalse((boolean)this.fModuleOther.appliesToTraceType(TmfTraceStub.class));
        Assert.assertTrue((boolean)this.fModuleOther.appliesToTraceType(TmfTraceStub2.class));
        Assert.assertTrue((boolean)this.fModuleOther.appliesToTraceType(TmfTraceStub3.class));
        Assert.assertTrue((boolean)this.fModuleOther.appliesToTraceType(TmfExperiment.class));
        Assert.assertFalse((boolean)this.fTraceTypeModule.appliesToTraceType(TmfTrace.class));
        Assert.assertFalse((boolean)this.fTraceTypeModule.appliesToTraceType(TmfTraceStub.class));
        Assert.assertTrue((boolean)this.fTraceTypeModule.appliesToTraceType(TmfTraceStub2.class));
        Assert.assertFalse((boolean)this.fTraceTypeModule.appliesToTraceType(TmfTraceStub3.class));
        Assert.assertFalse((boolean)this.fTraceTypeModule.appliesToTraceType(TmfExperiment.class));
    }

    @Test
    public void testNewModule() {
        IAnalysisModule module;
        block24: {
            block22: {
                module = null;
                try {
                    try {
                        module = this.fModule.newModule(TmfTestTrace.A_TEST_10K.getTrace());
                        Assert.assertNotNull((Object)module);
                        Assert.assertTrue((boolean)(module instanceof TestAnalysis));
                    }
                    catch (TmfAnalysisException e) {
                        Assert.fail();
                        if (module != null) {
                            module.dispose();
                        }
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    if (module != null) {
                        module.dispose();
                    }
                    throw throwable;
                }
                if (module != null) {
                    module.dispose();
                }
            }
            try {
                try {
                    module = this.fModuleOther.newModule(TmfTestTrace.A_TEST_10K.getTrace());
                    Assert.assertNull((Object)module);
                }
                catch (TmfAnalysisException e) {
                    Assert.fail();
                    if (module != null) {
                        module.dispose();
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (module != null) {
                    module.dispose();
                }
                throw throwable;
            }
            if (module != null) {
                module.dispose();
            }
        }
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        try {
            try {
                module = this.fModuleOther.newModule(trace);
                Assert.assertNotNull((Object)module);
                Assert.assertTrue((boolean)(module instanceof TestAnalysis2));
            }
            catch (TmfAnalysisException e) {
                Assert.fail();
                if (module != null) {
                    module.dispose();
                }
            }
        }
        finally {
            if (module != null) {
                module.dispose();
            }
        }
    }

    @Test
    public void testAppliesToExperiment() {
        ITmfTrace trace1 = TmfTestTrace.A_TEST_10K.getTrace();
        ITmfTrace trace2 = TmfTestTrace.A_TEST_10K2.getTrace();
        ITmfTrace trace3 = TmfTestTrace.A_TEST_10K2.getTraceAsStub2();
        ITmfTrace[] tracesExp1 = new ITmfTrace[]{trace1, trace2};
        TmfExperiment exp1 = new TmfExperiment(tracesExp1[0].getEventType(), "Experiment 1", tracesExp1, 5000, null);
        ITmfTrace[] tracesExp2 = new ITmfTrace[]{trace1, trace3};
        TmfExperiment exp2 = new TmfExperiment(tracesExp2[0].getEventType(), "Experiment 1", tracesExp2, 5000, null);
        try {
            IAnalysisModule module;
            block36: {
                block34: {
                    block32: {
                        module = null;
                        try {
                            try {
                                module = this.fModule.newModule((ITmfTrace)exp1);
                                Assert.assertNull((Object)module);
                            }
                            catch (TmfAnalysisException e) {
                                Assert.fail();
                                if (module != null) {
                                    module.dispose();
                                }
                                break block32;
                            }
                        }
                        catch (Throwable throwable) {
                            if (module != null) {
                                module.dispose();
                            }
                            throw throwable;
                        }
                        if (module != null) {
                            module.dispose();
                        }
                    }
                    try {
                        try {
                            module = this.fModule.newModule((ITmfTrace)exp2);
                            Assert.assertNull((Object)module);
                        }
                        catch (TmfAnalysisException e) {
                            Assert.fail();
                            if (module != null) {
                                module.dispose();
                            }
                            break block34;
                        }
                    }
                    catch (Throwable throwable) {
                        if (module != null) {
                            module.dispose();
                        }
                        throw throwable;
                    }
                    if (module != null) {
                        module.dispose();
                    }
                }
                try {
                    try {
                        module = this.fModuleOther.newModule((ITmfTrace)exp1);
                        Assert.assertNull((Object)module);
                    }
                    catch (TmfAnalysisException e) {
                        Assert.fail();
                        if (module != null) {
                            module.dispose();
                        }
                        break block36;
                    }
                }
                catch (Throwable throwable) {
                    if (module != null) {
                        module.dispose();
                    }
                    throw throwable;
                }
                if (module != null) {
                    module.dispose();
                }
            }
            try {
                try {
                    module = this.fModuleOther.newModule((ITmfTrace)exp2);
                    Assert.assertNotNull((Object)module);
                }
                catch (TmfAnalysisException e) {
                    Assert.fail();
                    if (module != null) {
                        module.dispose();
                    }
                }
            }
            finally {
                if (module != null) {
                    module.dispose();
                }
            }
        }
        finally {
            exp2.dispose();
            exp1.dispose();
        }
    }

    @Test
    public void testParameters() {
        ITmfTrace trace = TmfTestTrace.A_TEST_10K.getTrace();
        IAnalysisModuleHelper helper = AnalysisModuleHelperTest.getModuleHelper("org.eclipse.linuxtools.tmf.core.tests.analysis.test");
        Assert.assertNotNull((Object)helper);
        IAnalysisModule module = null;
        try {
            try {
                module = helper.newModule(trace);
                Assert.assertNotNull((Object)module);
                Assert.assertNull((Object)module.getParameter("test"));
                module.setParameter("test", (Object)1);
                Assert.assertEquals((Object)1, (Object)module.getParameter("test"));
            }
            catch (TmfAnalysisException e1) {
                Assert.fail((String)e1.getMessage());
                if (module != null) {
                    module.dispose();
                }
                return;
            }
        }
        finally {
            if (module != null) {
                module.dispose();
            }
        }
        helper = AnalysisModuleHelperTest.getModuleHelper("org.eclipse.linuxtools.tmf.core.tests.analysis.test2");
        Assert.assertNotNull((Object)helper);
        try {
            try {
                module = helper.newModule(trace);
                Assert.assertNotNull((Object)module);
                Assert.assertEquals((Object)3, (Object)module.getParameter("test"));
                module.setParameter("test", (Object)1);
                Assert.assertEquals((Object)1, (Object)module.getParameter("test"));
            }
            catch (TmfAnalysisException e1) {
                Assert.fail((String)e1.getMessage());
                if (module != null) {
                    module.dispose();
                }
                return;
            }
        }
        finally {
            if (module != null) {
                module.dispose();
            }
        }
        helper = AnalysisModuleHelperTest.getModuleHelper("org.eclipse.linuxtools.tmf.core.tests.analysis.testother");
        Assert.assertNotNull((Object)helper);
        RuntimeException exception = null;
        trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        try {
            try {
                module = helper.newModule(trace);
                Assert.assertNotNull((Object)module);
                Assert.assertNull((Object)module.getParameter("test"));
                try {
                    module.setParameter("test", (Object)1);
                }
                catch (RuntimeException e) {
                    exception = e;
                }
            }
            catch (TmfAnalysisException e1) {
                Assert.fail((String)e1.getMessage());
                if (module != null) {
                    module.dispose();
                }
                return;
            }
        }
        finally {
            if (module != null) {
                module.dispose();
            }
        }
        Assert.assertNotNull((Object)exception);
    }

    @Test
    public void testGetValidTraceTypes() {
        ImmutableSet expected = ImmutableSet.of(TmfTraceStub.class, TmfTraceStub2.class, TmfTraceStub3.class);
        Iterable traceTypes = this.fReqModule.getValidTraceTypes();
        Assert.assertEquals((Object)expected, (Object)traceTypes);
    }

    @Test
    public void testGetRequirements() {
        Iterable requirements = this.fReqModule.getAnalysisRequirements();
        ImmutableSet expected = ImmutableSet.of((Object)AnalysisRequirementFactory.REQUIREMENT_1, (Object)AnalysisRequirementFactory.REQUIREMENT_3);
        Assert.assertEquals((Object)expected, (Object)requirements);
    }
}

