/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.findandreplace.overlay;

import java.util.List;
import java.util.function.Supplier;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.internal.findandreplace.FindReplaceLogic;
import org.eclipse.ui.internal.findandreplace.FindReplaceMessages;
import org.eclipse.ui.internal.findandreplace.HistoryStore;
import org.eclipse.ui.internal.findandreplace.SearchOptions;
import org.eclipse.ui.internal.findandreplace.overlay.AccessibleToolBar;
import org.eclipse.ui.internal.findandreplace.overlay.AccessibleToolItemBuilder;
import org.eclipse.ui.internal.findandreplace.overlay.FindReplaceOverlayAction;
import org.eclipse.ui.internal.findandreplace.overlay.FindReplaceOverlayImages;
import org.eclipse.ui.internal.findandreplace.overlay.FindReplaceShortcutUtil;
import org.eclipse.ui.internal.findandreplace.overlay.HistoryTextWrapper;
import org.eclipse.ui.internal.findandreplace.status.IFindReplaceStatus;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class FindReplaceOverlay
extends Dialog {
    private static final String REPLACE_BAR_OPEN_DIALOG_SETTING = "replaceBarOpen";
    private static final double WORST_CASE_RATIO_EDITOR_TO_OVERLAY = 0.95;
    private static final double BIG_WIDTH_RATIO_EDITOR_TO_OVERLAY = 0.7;
    private static final String MINIMAL_WIDTH_TEXT = "THIS TEXT IS SHORT ";
    private static final String IDEAL_WIDTH_TEXT = "THIS TEXT HAS A REASONABLE LENGTH FOR SEARCHING";
    private static final int HISTORY_SIZE = 15;
    private FindReplaceLogic findReplaceLogic;
    private final IWorkbenchPart targetPart;
    private boolean overlayOpen;
    private boolean replaceBarOpen;
    private Composite container;
    private Button replaceToggle;
    private FindReplaceOverlayAction replaceToggleShortcut;
    private Composite contentGroup;
    private Composite searchContainer;
    private Composite searchBarContainer;
    private HistoryTextWrapper searchBar;
    private AccessibleToolBar searchTools;
    private ToolItem searchInSelectionButton;
    private ToolItem wholeWordSearchButton;
    private ToolItem caseSensitiveSearchButton;
    private ToolItem regexSearchButton;
    private ToolItem searchUpButton;
    private ToolItem searchDownButton;
    private ToolItem searchAllButton;
    private AccessibleToolBar closeTools;
    private ToolItem closeButton;
    private Composite replaceContainer;
    private Composite replaceBarContainer;
    private HistoryTextWrapper replaceBar;
    private AccessibleToolBar replaceTools;
    private ToolItem replaceButton;
    private ToolItem replaceAllButton;
    private Color backgroundToUse;
    private Color normalTextForegroundColor;
    private boolean positionAtTop = true;
    private final TargetPartVisibilityHandler targetPartVisibilityHandler;
    private ContentAssistCommandAdapter contentAssistSearchField;
    private ContentAssistCommandAdapter contentAssistReplaceField;
    private ControlListener shellMovementListener = new ControlListener(){

        public void controlMoved(ControlEvent e) {
            FindReplaceOverlay.this.asyncUpdatePlacementAndVisibility();
        }

        public void controlResized(ControlEvent e) {
            FindReplaceOverlay.this.asyncUpdatePlacementAndVisibility();
        }
    };
    private PaintListener widgetMovementListener = __ -> this.asyncUpdatePlacementAndVisibility();
    private ShellAdapter overlayDeactivationListener = new ShellAdapter(){

        public void shellActivated(ShellEvent e) {
        }

        public void shellDeactivated(ShellEvent e) {
            FindReplaceOverlay.this.removeSearchScope();
        }
    };
    private KeyListener closeOnTargetEscapeListener = KeyListener.keyPressedAdapter(c -> {
        if (c.keyCode == 27) {
            this.close();
        }
    });

    public FindReplaceOverlay(Shell parent, IWorkbenchPart part, IFindReplaceTarget target) {
        super(parent);
        this.createFindReplaceLogic(target);
        this.setShellStyle(0);
        this.setBlockOnOpen(false);
        this.targetPart = part;
        this.targetPartVisibilityHandler = new TargetPartVisibilityHandler(this.targetPart, () -> ((FindReplaceOverlay)this).getShell(), this::close, this::updatePlacementAndVisibility);
    }

    protected boolean isResizable() {
        return false;
    }

    private void createFindReplaceLogic(IFindReplaceTarget target) {
        this.findReplaceLogic = new FindReplaceLogic();
        boolean isTargetEditable = false;
        if (target != null) {
            isTargetEditable = target.isEditable();
        }
        this.findReplaceLogic.updateTarget(target, isTargetEditable);
        this.findReplaceLogic.activate(SearchOptions.INCREMENTAL);
        this.findReplaceLogic.activate(SearchOptions.GLOBAL);
        this.findReplaceLogic.activate(SearchOptions.WRAP);
        this.findReplaceLogic.activate(SearchOptions.FORWARD);
    }

    private void performReplaceAll() {
        BusyIndicator.showWhile((Display)(this.getShell() != null ? this.getShell().getDisplay() : Display.getCurrent()), () -> this.findReplaceLogic.performReplaceAll(this.getFindString(), this.getReplaceString()));
        this.evaluateFindReplaceStatus();
        this.replaceBar.storeHistory();
        this.searchBar.storeHistory();
    }

    private void performSelectAll() {
        BusyIndicator.showWhile((Display)(this.getShell() != null ? this.getShell().getDisplay() : Display.getCurrent()), () -> this.findReplaceLogic.performSelectAll(this.getFindString()));
        this.searchBar.storeHistory();
    }

    private void asyncUpdatePlacementAndVisibility() {
        Shell shell = this.getShell();
        if (shell != null) {
            shell.getDisplay().asyncExec(this::updatePlacementAndVisibility);
        }
    }

    private static IDialogSettings getDialogSettings() {
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(FindReplaceOverlay.class)).getDialogSettings();
        return settings;
    }

    public boolean close() {
        if (!this.overlayOpen) {
            return true;
        }
        if (this.targetPart != null) {
            this.targetPart.setFocus();
        }
        this.storeOverlaySettings();
        this.findReplaceLogic.activate(SearchOptions.GLOBAL);
        this.overlayOpen = false;
        this.replaceBarOpen = false;
        this.unbindListeners();
        this.container.dispose();
        return super.close();
    }

    public int open() {
        int returnCode = 0;
        if (!this.overlayOpen) {
            returnCode = super.open();
            this.bindListeners();
            this.restoreOverlaySettings();
        }
        this.overlayOpen = true;
        this.applyOverlayColors(this.backgroundToUse, true);
        this.updateFromTargetSelection();
        this.searchBar.forceFocus();
        this.getShell().layout();
        this.updatePlacementAndVisibility();
        this.updateContentAssistAvailability();
        return returnCode;
    }

    private void storeOverlaySettings() {
        FindReplaceOverlay.getDialogSettings().put(REPLACE_BAR_OPEN_DIALOG_SETTING, this.replaceBarOpen);
    }

    private void restoreOverlaySettings() {
        Boolean shouldOpenReplaceBar = FindReplaceOverlay.getDialogSettings().getBoolean(REPLACE_BAR_OPEN_DIALOG_SETTING);
        if (shouldOpenReplaceBar.booleanValue()) {
            this.toggleReplace();
        }
    }

    private void applyOverlayColors(Color color, boolean tryToColorReplaceBar) {
        this.closeTools.setBackground(color);
        this.closeButton.setBackground(color);
        this.searchTools.setBackground(color);
        this.searchInSelectionButton.setBackground(color);
        this.wholeWordSearchButton.setBackground(color);
        this.regexSearchButton.setBackground(color);
        this.caseSensitiveSearchButton.setBackground(color);
        this.searchAllButton.setBackground(color);
        this.searchUpButton.setBackground(color);
        this.searchDownButton.setBackground(color);
        this.searchBarContainer.setBackground(color);
        this.searchBar.setBackground(color);
        this.searchContainer.setBackground(color);
        if (this.replaceBarOpen && tryToColorReplaceBar) {
            this.replaceContainer.setBackground(color);
            this.replaceBar.setBackground(color);
            this.replaceBarContainer.setBackground(color);
            this.replaceTools.setBackground(color);
            this.replaceAllButton.setBackground(color);
            this.replaceButton.setBackground(color);
        }
    }

    private void unbindListeners() {
        StatusTextEditor textEditor;
        StyledText targetWidget;
        IWorkbenchPart iWorkbenchPart;
        this.getShell().removeShellListener((ShellListener)this.overlayDeactivationListener);
        if (this.targetPart != null && (iWorkbenchPart = this.targetPart) instanceof StatusTextEditor && (targetWidget = (textEditor = (StatusTextEditor)iWorkbenchPart).getAdapter(ITextViewer.class).getTextWidget()) != null) {
            targetWidget.getShell().removeControlListener(this.shellMovementListener);
            targetWidget.removePaintListener(this.widgetMovementListener);
            targetWidget.removeKeyListener(this.closeOnTargetEscapeListener);
            this.targetPart.getSite().getPage().removePartListener((IPartListener2)this.targetPartVisibilityHandler);
        }
    }

    private void bindListeners() {
        this.getShell().addShellListener((ShellListener)this.overlayDeactivationListener);
        IWorkbenchPart iWorkbenchPart = this.targetPart;
        if (iWorkbenchPart instanceof StatusTextEditor) {
            StatusTextEditor textEditor = (StatusTextEditor)iWorkbenchPart;
            StyledText targetWidget = textEditor.getAdapter(ITextViewer.class).getTextWidget();
            targetWidget.getShell().addControlListener(this.shellMovementListener);
            targetWidget.addPaintListener(this.widgetMovementListener);
            targetWidget.addKeyListener(this.closeOnTargetEscapeListener);
            this.targetPart.getSite().getPage().addPartListener((IPartListener2)this.targetPartVisibilityHandler);
        }
    }

    public Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "org.eclipse.ui.find_replace_overlay_context");
        this.backgroundToUse = new Color((Device)this.getShell().getDisplay(), new RGBA(0, 0, 0, 0));
        return this.createDialog(parent);
    }

    private Control createDialog(Composite parent) {
        this.createMainContainer(parent);
        this.retrieveBackgroundColor();
        this.createFindContainer();
        this.createSearchBar();
        this.createSearchTools();
        this.createCloseTools();
        this.initializeSearchShortcutHandlers();
        this.container.layout();
        FindReplaceOverlay.applyDialogFont((Control)this.container);
        return this.container;
    }

    private void initializeSearchShortcutHandlers() {
        this.searchTools.registerActionShortcutsAtControl((Control)this.searchBar);
        this.closeTools.registerActionShortcutsAtControl((Control)this.searchBar);
        FindReplaceShortcutUtil.registerActionShortcutsAtControl(this.replaceToggleShortcut, (Control)this.searchBar);
    }

    private void retrieveBackgroundColor() {
        IWorkbenchPart iWorkbenchPart = this.targetPart;
        if (iWorkbenchPart instanceof StatusTextEditor) {
            StatusTextEditor textEditor = (StatusTextEditor)iWorkbenchPart;
            StyledText targetWidget = textEditor.getAdapter(ITextViewer.class).getTextWidget();
            this.backgroundToUse = targetWidget.getBackground();
            this.normalTextForegroundColor = targetWidget.getForeground();
        } else {
            Text textBarForRetrievingTheRightColor = new Text(this.container, 132);
            this.container.layout();
            this.backgroundToUse = textBarForRetrievingTheRightColor.getBackground();
            this.normalTextForegroundColor = textBarForRetrievingTheRightColor.getForeground();
            textBarForRetrievingTheRightColor.dispose();
        }
    }

    private void createSearchTools() {
        this.searchTools = new AccessibleToolBar(this.searchContainer);
        GridDataFactory.fillDefaults().grab(false, true).align(3, 3).applyTo((Control)this.searchTools);
        this.searchTools.createToolItem(2);
        this.createCaseSensitiveButton();
        this.createRegexSearchButton();
        this.createWholeWordsButton();
        this.createAreaSearchButton();
        this.searchTools.createToolItem(2);
        this.searchUpButton = new AccessibleToolItemBuilder(this.searchTools).withStyleBits(8).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.select_prev")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_upSearchButton_toolTip).withOperation(() -> this.performSearch(false)).withShortcuts(KeyboardShortcuts.SEARCH_BACKWARD).build();
        this.searchDownButton = new AccessibleToolItemBuilder(this.searchTools).withStyleBits(8).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.select_next")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_downSearchButton_toolTip).withOperation(() -> this.performSearch(true)).withShortcuts(KeyboardShortcuts.SEARCH_FORWARD).build();
        this.searchDownButton.setSelection(true);
        this.searchAllButton = new AccessibleToolItemBuilder(this.searchTools).withStyleBits(8).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.search_all")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_searchAllButton_toolTip).withOperation(this::performSelectAll).withShortcuts(KeyboardShortcuts.SEARCH_ALL).build();
    }

    private void createCloseTools() {
        this.closeTools = new AccessibleToolBar(this.searchContainer);
        GridDataFactory.fillDefaults().grab(false, true).align(3, 3).applyTo((Control)this.closeTools);
        this.closeButton = new AccessibleToolItemBuilder(this.closeTools).withStyleBits(8).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.close")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_closeButton_toolTip).withOperation(this::close).withShortcuts(KeyboardShortcuts.CLOSE).build();
    }

    private void createAreaSearchButton() {
        this.searchInSelectionButton = new AccessibleToolItemBuilder(this.searchTools).withStyleBits(32).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.search_in_selection")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_searchInSelectionButton_toolTip).withOperation(() -> {
            this.activateInFindReplacerIf(SearchOptions.GLOBAL, !this.searchInSelectionButton.getSelection());
            this.updateIncrementalSearch();
        }).withShortcuts(KeyboardShortcuts.OPTION_SEARCH_IN_SELECTION).build();
        this.searchInSelectionButton.setSelection(this.findReplaceLogic.isActive(SearchOptions.WHOLE_WORD));
    }

    private void createRegexSearchButton() {
        this.regexSearchButton = new AccessibleToolItemBuilder(this.searchTools).withStyleBits(32).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.regex")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_regexSearchButton_toolTip).withOperation(() -> {
            this.activateInFindReplacerIf(SearchOptions.REGEX, this.regexSearchButton.getSelection());
            this.wholeWordSearchButton.setEnabled(this.findReplaceLogic.isWholeWordSearchAvailable(this.getFindString()));
            this.updateIncrementalSearch();
            this.updateContentAssistAvailability();
        }).withShortcuts(KeyboardShortcuts.OPTION_REGEX).build();
        this.regexSearchButton.setSelection(this.findReplaceLogic.isActive(SearchOptions.REGEX));
    }

    private void createCaseSensitiveButton() {
        this.caseSensitiveSearchButton = new AccessibleToolItemBuilder(this.searchTools).withStyleBits(32).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.case_sensitive")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_caseSensitiveButton_toolTip).withOperation(() -> {
            this.activateInFindReplacerIf(SearchOptions.CASE_SENSITIVE, this.caseSensitiveSearchButton.getSelection());
            this.updateIncrementalSearch();
        }).withShortcuts(KeyboardShortcuts.OPTION_CASE_SENSITIVE).build();
        this.caseSensitiveSearchButton.setSelection(this.findReplaceLogic.isActive(SearchOptions.CASE_SENSITIVE));
    }

    private void createWholeWordsButton() {
        this.wholeWordSearchButton = new AccessibleToolItemBuilder(this.searchTools).withStyleBits(32).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.whole_word")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_wholeWordsButton_toolTip).withOperation(() -> {
            this.activateInFindReplacerIf(SearchOptions.WHOLE_WORD, this.wholeWordSearchButton.getSelection());
            this.updateIncrementalSearch();
        }).withShortcuts(KeyboardShortcuts.OPTION_WHOLE_WORD).build();
        this.wholeWordSearchButton.setSelection(this.findReplaceLogic.isActive(SearchOptions.WHOLE_WORD));
    }

    private void createReplaceTools() {
        Color warningColor = JFaceColors.getErrorText((Display)this.getShell().getDisplay());
        this.replaceTools = new AccessibleToolBar(this.replaceContainer);
        this.replaceTools.createToolItem(2);
        GridDataFactory.fillDefaults().grab(false, true).align(2, 3).applyTo((Control)this.replaceTools);
        this.replaceButton = new AccessibleToolItemBuilder(this.replaceTools).withStyleBits(8).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.replace")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_replaceButton_toolTip).withOperation(() -> {
            if (this.getFindString().isEmpty()) {
                this.showUserFeedback(warningColor, true);
                return;
            }
            this.performSingleReplace();
        }).withShortcuts(KeyboardShortcuts.SEARCH_FORWARD).build();
        this.replaceAllButton = new AccessibleToolItemBuilder(this.replaceTools).withStyleBits(8).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.replace_all")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_replaceAllButton_toolTip).withOperation(() -> {
            if (this.getFindString().isEmpty()) {
                this.showUserFeedback(warningColor, true);
                return;
            }
            this.performReplaceAll();
        }).withShortcuts(KeyboardShortcuts.SEARCH_ALL).build();
    }

    private ContentAssistCommandAdapter createContentAssistField(HistoryTextWrapper control, boolean isFind) {
        TextContentAdapter contentAdapter = new TextContentAdapter();
        FindReplaceDocumentAdapterContentProposalProvider findProposer = new FindReplaceDocumentAdapterContentProposalProvider(isFind);
        return new ContentAssistCommandAdapter((Control)control.getTextBar(), (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
    }

    private void createSearchBar() {
        HistoryStore searchHistory = new HistoryStore(FindReplaceOverlay.getDialogSettings(), "searchhistory", 15);
        this.searchBar = new HistoryTextWrapper(searchHistory, this.searchBarContainer, 4);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.searchBar);
        this.searchBar.forceFocus();
        this.searchBar.selectAll();
        this.searchBar.addModifyListener(e -> {
            this.wholeWordSearchButton.setEnabled(this.findReplaceLogic.isWholeWordSearchAvailable(this.getFindString()));
            this.showUserFeedback(this.normalTextForegroundColor, true);
            this.updateIncrementalSearch();
        });
        this.searchBar.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                FindReplaceOverlay.this.findReplaceLogic.resetIncrementalBaseLocation();
            }

            public void focusLost(FocusEvent e) {
                FindReplaceOverlay.this.showUserFeedback(FindReplaceOverlay.this.normalTextForegroundColor, false);
            }
        });
        this.searchBar.setMessage(FindReplaceMessages.FindReplaceOverlay_searchBar_message);
        this.contentAssistSearchField = this.createContentAssistField(this.searchBar, true);
    }

    private void updateIncrementalSearch() {
        this.findReplaceLogic.performSearch(this.getFindString());
        this.evaluateFindReplaceStatus();
    }

    private void createReplaceBar() {
        HistoryStore replaceHistory = new HistoryStore(FindReplaceOverlay.getDialogSettings(), "replacehistory", 15);
        this.replaceBar = new HistoryTextWrapper(replaceHistory, this.replaceBarContainer, 4);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000008).applyTo((Control)this.replaceBar);
        this.replaceBar.setMessage(FindReplaceMessages.FindReplaceOverlay_replaceBar_message);
        this.replaceBar.addFocusListener(FocusListener.focusLostAdapter(e -> {
            this.replaceBar.setForeground(this.normalTextForegroundColor);
            this.searchBar.setForeground(this.normalTextForegroundColor);
        }));
        this.contentAssistReplaceField = this.createContentAssistField(this.replaceBar, false);
    }

    private void createFindContainer() {
        this.searchContainer = new Composite(this.contentGroup, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.searchContainer);
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(4, 4, 3, 5).equalWidth(false).applyTo(this.searchContainer);
        this.searchContainer.setBackground(this.getShell().getDisplay().getSystemColor(19));
        this.searchBarContainer = new Composite(this.searchContainer, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.searchBarContainer);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.searchBarContainer);
    }

    private void createReplaceContainer() {
        this.replaceContainer = new Composite(this.contentGroup, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.replaceContainer);
        GridLayoutFactory.fillDefaults().margins(0, 1).numColumns(2).extendedMargins(4, 4, 3, 5).equalWidth(false).applyTo(this.replaceContainer);
        this.replaceContainer.setBackground(this.getShell().getDisplay().getSystemColor(19));
        this.replaceBarContainer = new Composite(this.replaceContainer, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 3).applyTo((Control)this.replaceBarContainer);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).applyTo(this.replaceBarContainer);
    }

    private void createMainContainer(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(2, 2).spacing(2, 0).applyTo(this.container);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.container);
        this.createReplaceToggle();
        this.contentGroup = new Composite(this.container, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).spacing(2, 3).applyTo(this.contentGroup);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.contentGroup);
    }

    private void createReplaceToggle() {
        this.replaceToggleShortcut = new FindReplaceOverlayAction(this::toggleReplace);
        this.replaceToggleShortcut.addShortcuts(KeyboardShortcuts.TOGGLE_REPLACE);
        this.replaceToggle = new Button(this.container, 0x800008);
        GridDataFactory.fillDefaults().grab(false, true).align(1, 4).applyTo((Control)this.replaceToggle);
        this.replaceToggle.setToolTipText(this.replaceToggleShortcut.addShortcutHintToTooltipText(FindReplaceMessages.FindReplaceOverlay_replaceToggle_toolTip));
        this.replaceToggle.setImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.open_replace"));
        this.replaceToggle.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.toggleReplace()));
    }

    private void toggleReplace() {
        if (!this.replaceBarOpen && this.findReplaceLogic.getTarget().isEditable()) {
            this.createReplaceDialog();
            this.replaceToggle.setImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.close_replace"));
        } else {
            this.hideReplace();
            this.replaceToggle.setImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.open_replace"));
        }
        this.replaceToggle.setSelection(false);
        this.updateContentAssistAvailability();
    }

    private void hideReplace() {
        if (!this.replaceBarOpen) {
            return;
        }
        this.searchBar.forceFocus();
        this.contentAssistReplaceField = null;
        this.replaceBarOpen = false;
        this.replaceContainer.dispose();
        this.updatePlacementAndVisibility();
    }

    private void createReplaceDialog() {
        if (this.replaceBarOpen) {
            return;
        }
        this.replaceBarOpen = true;
        this.createReplaceContainer();
        this.createReplaceBar();
        this.createReplaceTools();
        this.initializeReplaceShortcutHandlers();
        this.updatePlacementAndVisibility();
        this.applyOverlayColors(this.backgroundToUse, true);
        this.replaceBar.forceFocus();
    }

    private void initializeReplaceShortcutHandlers() {
        this.replaceTools.registerActionShortcutsAtControl((Control)this.replaceBar);
        this.closeTools.registerActionShortcutsAtControl((Control)this.replaceBar);
        FindReplaceShortcutUtil.registerActionShortcutsAtControl(this.replaceToggleShortcut, (Control)this.replaceBar);
    }

    private void enableSearchTools(boolean enable) {
        ((GridData)this.searchTools.getLayoutData()).exclude = !enable;
        this.searchTools.setVisible(enable);
    }

    private void enableReplaceToggle(boolean enable) {
        if (!FindReplaceOverlay.okayToUse((Widget)this.replaceToggle)) {
            return;
        }
        boolean visible = enable && this.findReplaceLogic.getTarget().isEditable();
        ((GridData)this.replaceToggle.getLayoutData()).exclude = !visible;
        this.replaceToggle.setVisible(visible);
    }

    private void enableReplaceTools(boolean enable) {
        if (!FindReplaceOverlay.okayToUse((Widget)this.replaceTools)) {
            return;
        }
        ((GridData)this.replaceTools.getLayoutData()).exclude = !enable;
        this.replaceTools.setVisible(enable);
    }

    private int getIdealOverlayWidth(Rectangle targetBounds) {
        int idealOverlayWidth = this.calculateOverlayWidthWithToolbars(IDEAL_WIDTH_TEXT);
        int minimumOverlayWidth = Math.min(this.calculateOverlayWidthWithoutToolbars(MINIMAL_WIDTH_TEXT), (int)((double)targetBounds.width * 0.95));
        int overlayWidth = idealOverlayWidth;
        int maximumOverlayWidth = (int)((double)targetBounds.width * 0.7);
        if (overlayWidth > maximumOverlayWidth) {
            overlayWidth = maximumOverlayWidth;
        }
        if (overlayWidth < minimumOverlayWidth) {
            overlayWidth = minimumOverlayWidth;
        }
        return overlayWidth;
    }

    private void configureDisplayedWidgetsForWidth(int overlayWidth) {
        int minimumWidthWithToolbars = this.calculateOverlayWidthWithoutToolbars(IDEAL_WIDTH_TEXT);
        int minimumWidthWithReplaceToggle = this.calculateOverlayWidthWithoutToolbars(MINIMAL_WIDTH_TEXT);
        this.enableSearchTools(overlayWidth >= minimumWidthWithToolbars);
        this.enableReplaceTools(overlayWidth >= minimumWidthWithToolbars);
        this.enableReplaceToggle(overlayWidth >= minimumWidthWithReplaceToggle);
    }

    private int calculateOverlayWidthWithToolbars(String searchInput) {
        int toolbarWidth = this.searchTools.getSize().x;
        return this.calculateOverlayWidthWithoutToolbars(searchInput) + toolbarWidth;
    }

    private int calculateOverlayWidthWithoutToolbars(String searchInput) {
        int replaceToggleWidth = 0;
        if (FindReplaceOverlay.okayToUse((Widget)this.replaceToggle)) {
            replaceToggleWidth = this.replaceToggle.getBounds().width;
        }
        int closeButtonWidth = this.closeTools.getSize().x;
        int searchInputWidth = this.getTextWidthInSearchBar(searchInput);
        return replaceToggleWidth + closeButtonWidth + searchInputWidth;
    }

    private int getTextWidthInSearchBar(String input) {
        GC gc = new GC((Drawable)this.searchBar);
        gc.setFont(this.searchBar.getFont());
        int textWidth = gc.stringExtent((String)input).x;
        gc.dispose();
        return textWidth;
    }

    private void repositionTextSelection() {
        if (FindReplaceOverlay.okayToUse((Widget)this.searchBar) && !this.searchBar.isFocusControl()) {
            this.searchBar.setSelection(0, 0);
        }
        if (FindReplaceOverlay.okayToUse((Widget)this.replaceBar) && !this.replaceBar.isFocusControl()) {
            this.replaceBar.setSelection(0, 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updatePlacementAndVisibility() {
        void textEditor;
        if (!this.targetPartVisibilityHandler.isTargetVisible()) {
            this.getShell().setVisible(false);
            return;
        }
        if (this.isInvalidTargetShell()) {
            this.getShell().getDisplay().asyncExec(() -> {
                if (this.isInvalidTargetShell()) {
                    this.close();
                    this.setParentShell(this.targetPart.getSite().getShell());
                    this.open();
                    this.targetPart.setFocus();
                }
            });
            return;
        }
        this.getShell().requestLayout();
        IWorkbenchPart iWorkbenchPart = this.targetPart;
        if (!(iWorkbenchPart instanceof StatusTextEditor)) {
            return;
        }
        StatusTextEditor statusTextEditor = (StatusTextEditor)iWorkbenchPart;
        StyledText targetWidget = textEditor.getAdapter(ITextViewer.class).getTextWidget();
        if (!FindReplaceOverlay.okayToUse((Widget)targetWidget)) {
            this.close();
            return;
        }
        Rectangle targetControlBounds = this.calculateAbsoluteControlBounds((Control)targetWidget);
        Rectangle overlayBounds = this.calculateDesiredOverlayBounds(targetControlBounds);
        this.updatePosition(overlayBounds);
        this.configureDisplayedWidgetsForWidth(overlayBounds.width);
        this.updateVisibility(targetControlBounds, overlayBounds);
        this.repositionTextSelection();
    }

    private boolean isInvalidTargetPart() {
        return this.targetPart == null || this.targetPart.getSite() == null || this.targetPart.getSite().getShell() == null;
    }

    private boolean isInvalidTargetShell() {
        if (this.isInvalidTargetPart()) {
            return false;
        }
        return this.getShell() == null || !this.targetPart.getSite().getShell().equals(this.getShell().getParent());
    }

    private Rectangle calculateAbsoluteControlBounds(Control control) {
        Rectangle localControlBounds = control.getBounds();
        int width = localControlBounds.width;
        int height = localControlBounds.height;
        if (control instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)control;
            ScrollBar verticalBar = scrollable.getVerticalBar();
            ScrollBar horizontalBar = scrollable.getHorizontalBar();
            if (verticalBar != null) {
                width -= verticalBar.getSize().x;
            }
            if (horizontalBar != null) {
                height -= horizontalBar.getSize().y;
            }
        }
        if (control instanceof StyledText) {
            StyledText styledText = (StyledText)control;
            width -= styledText.getRightMargin();
        }
        Point absoluteControlPosition = control.toDisplay(0, 0);
        return new Rectangle(absoluteControlPosition.x, absoluteControlPosition.y, width, height);
    }

    private Rectangle calculateDesiredOverlayBounds(Rectangle targetControlBounds) {
        int width = this.getIdealOverlayWidth(targetControlBounds);
        int height = this.container.computeSize((int)-1, (int)-1).y;
        int x = targetControlBounds.x + targetControlBounds.width - width;
        int y = targetControlBounds.y;
        if (!this.positionAtTop) {
            y += targetControlBounds.height - height;
        }
        return new Rectangle(x, y, width, height);
    }

    private void updatePosition(Rectangle overlayBounds) {
        this.getShell().setSize(new Point(overlayBounds.width, overlayBounds.height));
        this.getShell().setLocation(new Point(overlayBounds.x, overlayBounds.y));
        this.getShell().layout(true);
    }

    private void updateVisibility(Rectangle targetControlBounds, Rectangle overlayBounds) {
        Shell shell;
        boolean shallBeVisible = true;
        shallBeVisible = this.positionAtTop ? overlayBounds.y + overlayBounds.height <= targetControlBounds.y + targetControlBounds.height : overlayBounds.y >= targetControlBounds.y;
        if (shallBeVisible != (shell = this.getShell()).isVisible()) {
            shell.setVisible(shallBeVisible);
        }
    }

    private String getFindString() {
        return this.searchBar.getText();
    }

    private String getReplaceString() {
        if (!FindReplaceOverlay.okayToUse((Widget)this.replaceBar)) {
            return "";
        }
        return this.replaceBar.getText();
    }

    private void performSingleReplace() {
        this.findReplaceLogic.performReplaceAndFind(this.getFindString(), this.getReplaceString());
        this.evaluateFindReplaceStatus();
        this.replaceBar.storeHistory();
        this.searchBar.storeHistory();
    }

    private void performSearch(boolean forward) {
        boolean oldForwardSearchSetting = this.findReplaceLogic.isActive(SearchOptions.FORWARD);
        this.activateInFindReplacerIf(SearchOptions.FORWARD, forward);
        this.findReplaceLogic.deactivate(SearchOptions.INCREMENTAL);
        this.findReplaceLogic.performSearch(this.getFindString());
        this.activateInFindReplacerIf(SearchOptions.FORWARD, oldForwardSearchSetting);
        this.findReplaceLogic.activate(SearchOptions.INCREMENTAL);
        this.evaluateFindReplaceStatus();
        this.searchBar.storeHistory();
    }

    private void updateFromTargetSelection() {
        String selectionText = this.findReplaceLogic.getTarget().getSelectionText();
        if (selectionText.contains("\n")) {
            this.findReplaceLogic.deactivate(SearchOptions.GLOBAL);
            this.searchInSelectionButton.setSelection(true);
        } else if (!selectionText.isEmpty()) {
            if (this.findReplaceLogic.isRegExSearchAvailableAndActive()) {
                selectionText = FindReplaceDocumentAdapter.escapeForRegExPattern((String)selectionText);
            }
            this.searchBar.setText(selectionText);
            this.findReplaceLogic.findAndSelect(this.findReplaceLogic.getTarget().getSelection().x, this.searchBar.getText());
        }
        this.searchBar.setSelection(0, this.searchBar.getText().length());
    }

    private void evaluateFindReplaceStatus() {
        Color warningColor = JFaceColors.getErrorText((Display)this.getShell().getDisplay());
        IFindReplaceStatus status = this.findReplaceLogic.getStatus();
        if (!status.wasSuccessful()) {
            boolean colorReplaceBar = FindReplaceOverlay.okayToUse((Widget)this.replaceBar) && this.replaceBar.isFocusControl();
            this.showUserFeedback(warningColor, colorReplaceBar);
        } else {
            this.showUserFeedback(this.normalTextForegroundColor, false);
        }
    }

    private void showUserFeedback(Color feedbackColor, boolean colorReplaceBar) {
        this.searchBar.setForeground(feedbackColor);
        if (colorReplaceBar && FindReplaceOverlay.okayToUse((Widget)this.replaceBar)) {
            this.replaceBar.setForeground(feedbackColor);
        }
    }

    private void activateInFindReplacerIf(SearchOptions option, boolean shouldActivate) {
        if (shouldActivate) {
            this.findReplaceLogic.activate(option);
        } else {
            this.findReplaceLogic.deactivate(option);
        }
    }

    private static boolean okayToUse(Widget widget) {
        return widget != null && !widget.isDisposed();
    }

    public void setPositionToTop(boolean shouldPositionOverlayOnTop) {
        this.positionAtTop = shouldPositionOverlayOnTop;
        if (this.overlayOpen) {
            this.updatePlacementAndVisibility();
        }
    }

    private void removeSearchScope() {
        this.findReplaceLogic.activate(SearchOptions.GLOBAL);
        this.searchInSelectionButton.setSelection(false);
    }

    private void setContentAssistsEnablement(boolean enable) {
        this.contentAssistSearchField.setEnabled(enable);
        if (FindReplaceOverlay.okayToUse((Widget)this.replaceBar)) {
            this.contentAssistReplaceField.setEnabled(enable);
        }
    }

    private void updateContentAssistAvailability() {
        this.setContentAssistsEnablement(this.findReplaceLogic.isRegExSearchAvailableAndActive());
    }

    private final class KeyboardShortcuts {
        private static final List<KeyStroke> SEARCH_FORWARD = List.of(KeyStroke.getInstance((int)13), KeyStroke.getInstance((int)0x1000050));
        private static final List<KeyStroke> SEARCH_BACKWARD = List.of(KeyStroke.getInstance((int)131072, (int)13), KeyStroke.getInstance((int)131072, (int)0x1000050));
        private static final List<KeyStroke> SEARCH_ALL = List.of(KeyStroke.getInstance((int)SWT.MOD1, (int)13), KeyStroke.getInstance((int)SWT.MOD1, (int)0x1000050));
        private static final List<KeyStroke> OPTION_CASE_SENSITIVE = List.of(KeyStroke.getInstance((int)(SWT.MOD1 | 0x20000), (int)67), KeyStroke.getInstance((int)(SWT.MOD1 | 0x20000), (int)99));
        private static final List<KeyStroke> OPTION_WHOLE_WORD = List.of(KeyStroke.getInstance((int)(SWT.MOD1 | 0x20000), (int)87), KeyStroke.getInstance((int)(SWT.MOD1 | 0x20000), (int)119));
        private static final List<KeyStroke> OPTION_REGEX = List.of(KeyStroke.getInstance((int)(SWT.MOD1 | 0x20000), (int)80), KeyStroke.getInstance((int)(SWT.MOD1 | 0x20000), (int)112));
        private static final List<KeyStroke> OPTION_SEARCH_IN_SELECTION = List.of(KeyStroke.getInstance((int)(SWT.MOD1 | 0x20000), (int)65), KeyStroke.getInstance((int)(SWT.MOD1 | 0x20000), (int)97));
        private static final List<KeyStroke> CLOSE = List.of(KeyStroke.getInstance((int)27), KeyStroke.getInstance((int)SWT.MOD1, (int)70), KeyStroke.getInstance((int)SWT.MOD1, (int)102));
        private static final List<KeyStroke> TOGGLE_REPLACE = List.of(KeyStroke.getInstance((int)SWT.MOD1, (int)82), KeyStroke.getInstance((int)SWT.MOD1, (int)114));

        private KeyboardShortcuts() {
        }
    }

    private static class TargetPartVisibilityHandler
    implements IPartListener2,
    IPageChangedListener {
        private final IWorkbenchPart targetPart;
        private final IWorkbenchPart topLevelPart;
        private final Supplier<Shell> shellProvider;
        private final Runnable closeCallback;
        private final Runnable placementUpdateCallback;
        private boolean isTopLevelVisible = true;
        private boolean isNestedLevelVisible = true;

        TargetPartVisibilityHandler(IWorkbenchPart targetPart, Supplier<Shell> shellProvider, Runnable closeCallback, Runnable placementUpdateCallback) {
            IWorkbenchPartSite iWorkbenchPartSite;
            this.targetPart = targetPart;
            this.shellProvider = shellProvider;
            this.closeCallback = closeCallback;
            this.placementUpdateCallback = placementUpdateCallback;
            if (targetPart != null && (iWorkbenchPartSite = targetPart.getSite()) instanceof MultiPageEditorSite) {
                MultiPageEditorSite multiEditorSite = (MultiPageEditorSite)iWorkbenchPartSite;
                this.topLevelPart = multiEditorSite.getMultiPageEditor();
            } else {
                this.topLevelPart = targetPart;
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == this.topLevelPart && !this.isTopLevelVisible) {
                this.isTopLevelVisible = true;
                this.shellProvider.get().getDisplay().asyncExec(this::adaptToPartActivationChange);
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == this.topLevelPart && !this.isTopLevelVisible) {
                this.isTopLevelVisible = true;
                this.shellProvider.get().getDisplay().asyncExec(this::adaptToPartActivationChange);
            }
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == this.topLevelPart && this.isTopLevelVisible) {
                this.isTopLevelVisible = false;
                this.shellProvider.get().getDisplay().asyncExec(this::adaptToPartActivationChange);
            }
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == this.topLevelPart) {
                this.closeCallback.run();
            }
        }

        public void pageChanged(PageChangedEvent event) {
            if (event.getSource() == this.topLevelPart) {
                boolean isPageVisible;
                boolean bl = isPageVisible = event.getSelectedPage() == this.targetPart;
                if (this.isNestedLevelVisible != isPageVisible) {
                    this.isNestedLevelVisible = isPageVisible;
                    this.shellProvider.get().getDisplay().asyncExec(this::adaptToPartActivationChange);
                }
            }
        }

        private void adaptToPartActivationChange() {
            if (this.shellProvider.get() == null || this.targetPart.getSite().getPart() == null) {
                return;
            }
            this.placementUpdateCallback.run();
            if (!this.isTargetVisible()) {
                this.targetPart.getSite().getShell().setActive();
                this.targetPart.setFocus();
                this.shellProvider.get().getDisplay().asyncExec(this::focusTargetWidget);
            }
        }

        private void focusTargetWidget() {
            if (this.shellProvider.get() == null || this.targetPart.getSite().getPart() == null) {
                return;
            }
            IWorkbenchPart iWorkbenchPart = this.targetPart;
            if (iWorkbenchPart instanceof StatusTextEditor) {
                StatusTextEditor textEditor = (StatusTextEditor)iWorkbenchPart;
                textEditor.getAdapter(ITextViewer.class).getTextWidget().forceFocus();
            }
        }

        public boolean isTargetVisible() {
            return this.isTopLevelVisible && this.isNestedLevelVisible;
        }
    }
}

