/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import java.util.Arrays;
import java.util.function.LongBinaryOperator;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNaryTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.CStringValue;
import org.eclipse.cdt.internal.core.dom.parser.DependentValue;
import org.eclipse.cdt.internal.core.dom.parser.FloatingPointValue;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.SizeofCalculator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeTraits;
import org.eclipse.cdt.internal.core.parser.scanner.ExpressionEvaluator;

public class ValueFactory {
    public static IValue create(IASTExpression expr) {
        try {
            CPPSemantics.pushLookupPoint(expr);
            IValue val = ValueFactory.evaluate(expr);
            if (val != null) {
                IValue iValue = val;
                return iValue;
            }
            if (expr instanceof ICPPASTInitializerClause) {
                ICPPASTInitializerClause clause = (ICPPASTInitializerClause)((Object)expr);
                ICPPEvaluation evaluation = clause.getEvaluation();
                IValue iValue = evaluation.getValue();
                return iValue;
            }
            IntegralValue integralValue = IntegralValue.UNKNOWN;
            return integralValue;
        }
        finally {
            CPPSemantics.popLookupPoint();
        }
    }

    public static IValue evaluateUnaryExpression(int unaryOp, IValue value, IType type) {
        IValue val = ValueFactory.applyUnaryOperator(unaryOp, value, type);
        if (ValueFactory.isInvalidValue(val)) {
            return IntegralValue.UNKNOWN;
        }
        return val;
    }

    public static IValue evaluateBinaryExpression(int op, IValue v1, IValue v2, IType type) {
        if (v1 instanceof FloatingPointValue && v2 instanceof FloatingPointValue) {
            FloatingPointValue fv1 = (FloatingPointValue)v1;
            FloatingPointValue fv2 = (FloatingPointValue)v2;
            return ValueFactory.applyBinaryOperator(op, fv1.numberValue().doubleValue(), fv2.numberValue().doubleValue());
        }
        if (v1 instanceof FloatingPointValue && v2 instanceof IntegralValue) {
            FloatingPointValue fv1 = (FloatingPointValue)v1;
            IntegralValue iv2 = (IntegralValue)v2;
            return ValueFactory.applyBinaryOperator(op, fv1.numberValue().doubleValue(), iv2.numberValue().doubleValue());
        }
        if (v1 instanceof IntegralValue && v2 instanceof FloatingPointValue) {
            IntegralValue iv1 = (IntegralValue)v1;
            FloatingPointValue fv2 = (FloatingPointValue)v2;
            return ValueFactory.applyBinaryOperator(op, iv1.numberValue().doubleValue(), fv2.numberValue().doubleValue());
        }
        if (v1 instanceof IntegralValue && v2 instanceof IntegralValue) {
            IntegralValue iv1 = (IntegralValue)v1;
            IntegralValue iv2 = (IntegralValue)v2;
            return ValueFactory.applyBinaryOperator(op, iv1.numberValue().longValue(), iv2.numberValue().longValue(), type);
        }
        return IntegralValue.UNKNOWN;
    }

    private static IValue applyBinaryOperator(int op, double v1, double v2) {
        Double doubleValue = null;
        Long longValue = null;
        switch (op) {
            case 1: {
                doubleValue = v1 * v2;
                break;
            }
            case 2: {
                if (v2 == 0.0) break;
                doubleValue = v1 / v2;
                break;
            }
            case 4: {
                doubleValue = v1 + v2;
                break;
            }
            case 5: {
                doubleValue = v1 - v2;
                break;
            }
            case 8: {
                longValue = v1 < v2 ? 1L : 0L;
                break;
            }
            case 9: {
                longValue = v1 > v2 ? 1L : 0L;
                break;
            }
            case 10: {
                longValue = v1 <= v2 ? 1L : 0L;
                break;
            }
            case 11: {
                longValue = v1 >= v2 ? 1L : 0L;
                break;
            }
            case 15: {
                longValue = v1 != 0.0 && v2 != 0.0 ? 1L : 0L;
                break;
            }
            case 16: {
                longValue = v1 != 0.0 || v2 != 0.0 ? 1L : 0L;
                break;
            }
            case 28: {
                longValue = v1 == v2 ? 1L : 0L;
                break;
            }
            case 29: {
                longValue = v1 != v2 ? 1L : 0L;
            }
        }
        if (doubleValue != null) {
            return FloatingPointValue.create(doubleValue);
        }
        if (longValue != null) {
            return IntegralValue.create(longValue);
        }
        return IntegralValue.UNKNOWN;
    }

    private static IntegralValue applyBinaryOperator(int op, long v1, long v2, IType type) {
        IBasicType basicType;
        IType iType;
        if ((v1 < 0L || v2 < 0L) && (iType = SemanticUtil.getNestedType(type, 13)) instanceof IBasicType && (basicType = (IBasicType)iType).isUnsigned()) {
            return ValueFactory.applyBinaryOperator(op, v1, v2, (long x, long y) -> Long.compareUnsigned(x, y));
        }
        return ValueFactory.applyBinaryOperator(op, v1, v2, (long x, long y) -> Long.compare(x, y));
    }

    private static IntegralValue applyBinaryOperator(int op, long v1, long v2, LongBinaryOperator comparator) {
        Long value = null;
        switch (op) {
            case 1: {
                value = v1 * v2;
                break;
            }
            case 2: {
                if (v2 == 0L) break;
                value = v1 / v2;
                break;
            }
            case 3: {
                if (v2 == 0L) break;
                value = v1 % v2;
                break;
            }
            case 4: {
                value = v1 + v2;
                break;
            }
            case 5: {
                value = v1 - v2;
                break;
            }
            case 6: {
                value = v1 << (int)v2;
                break;
            }
            case 7: {
                value = v1 >> (int)v2;
                break;
            }
            case 8: {
                value = comparator.applyAsLong(v1, v2) < 0L ? 1L : 0L;
                break;
            }
            case 9: {
                value = comparator.applyAsLong(v1, v2) > 0L ? 1L : 0L;
                break;
            }
            case 10: {
                value = comparator.applyAsLong(v1, v2) <= 0L ? 1L : 0L;
                break;
            }
            case 11: {
                value = comparator.applyAsLong(v1, v2) >= 0L ? 1L : 0L;
                break;
            }
            case 35: {
                value = comparator.applyAsLong(v1, v2);
                break;
            }
            case 12: {
                value = v1 & v2;
                break;
            }
            case 13: {
                value = v1 ^ v2;
                break;
            }
            case 14: {
                value = v1 | v2;
                break;
            }
            case 15: {
                value = v1 != 0L && v2 != 0L ? 1L : 0L;
                break;
            }
            case 16: {
                value = v1 != 0L || v2 != 0L ? 1L : 0L;
                break;
            }
            case 28: {
                value = v1 == v2 ? 1L : 0L;
                break;
            }
            case 29: {
                value = v1 != v2 ? 1L : 0L;
                break;
            }
            case 32: {
                value = comparator.applyAsLong(v1, v2) >= 0L ? v1 : v2;
                break;
            }
            case 33: {
                value = comparator.applyAsLong(v1, v2) <= 0L ? v1 : v2;
            }
        }
        if (value != null) {
            return IntegralValue.create(value);
        }
        return IntegralValue.UNKNOWN;
    }

    public static IValue evaluateUnaryTypeIdExpression(int operator, IType type) {
        IValue val = ValueFactory.applyUnaryTypeIdOperator(operator, type);
        if (ValueFactory.isInvalidValue(val)) {
            return IntegralValue.UNKNOWN;
        }
        return val;
    }

    public static IValue evaluateBinaryTypeIdExpression(IASTBinaryTypeIdExpression.Operator operator, IType type1, IType type2) {
        IValue val = ValueFactory.applyBinaryTypeIdOperator(operator, type1, type2);
        if (ValueFactory.isInvalidValue(val)) {
            return IntegralValue.UNKNOWN;
        }
        return val;
    }

    public static IValue evaluateNaryTypeIdExpression(ICPPASTNaryTypeIdExpression.Operator operator, IType[] operands, IBinding pointOfDefinition) {
        IValue val = ValueFactory.applyNaryTypeIdOperator(operator, operands, pointOfDefinition);
        if (ValueFactory.isInvalidValue(val)) {
            return IntegralValue.UNKNOWN;
        }
        return val;
    }

    private static IValue evaluate(IASTExpression exp) {
        IASTExpression typeIdExp;
        if (exp instanceof ICPPASTFunctionCallExpression || exp instanceof ICPPASTSimpleTypeConstructorExpression || exp instanceof ICPPASTUnaryExpression || exp instanceof ICPPASTBinaryExpression) {
            return null;
        }
        if (exp == null) {
            return IntegralValue.UNKNOWN;
        }
        if (exp instanceof IASTArraySubscriptExpression) {
            return IntegralValue.UNKNOWN;
        }
        if (exp instanceof IASTBinaryExpression) {
            return ValueFactory.evaluateBinaryExpression((IASTBinaryExpression)exp);
        }
        if (exp instanceof IASTCastExpression) {
            return ValueFactory.evaluate(((IASTCastExpression)exp).getOperand());
        }
        if (exp instanceof IASTUnaryExpression) {
            return ValueFactory.evaluateUnaryExpression((IASTUnaryExpression)exp);
        }
        if (exp instanceof IASTConditionalExpression) {
            IASTConditionalExpression cexpr = (IASTConditionalExpression)exp;
            IValue v = ValueFactory.evaluate(cexpr.getLogicalConditionExpression());
            if (ValueFactory.isInvalidValue(v)) {
                return v;
            }
            if (ValueFactory.isDeferredValue(v)) {
                return null;
            }
            Number numericValue = v.numberValue();
            if (numericValue == null) {
                return IntegralValue.UNKNOWN;
            }
            if (v instanceof IntegralValue ? numericValue.longValue() == 0L : numericValue.doubleValue() == 0.0) {
                return ValueFactory.evaluate(cexpr.getNegativeResultExpression());
            }
            IASTExpression pe = cexpr.getPositiveResultExpression();
            if (pe == null) {
                return v;
            }
            return ValueFactory.evaluate(pe);
        }
        if (exp instanceof IASTIdExpression) {
            IBinding b = ((IASTIdExpression)exp).getName().resolvePreBinding();
            return ValueFactory.evaluateBinding(b);
        }
        if (exp instanceof IASTLiteralExpression) {
            IASTLiteralExpression litEx = (IASTLiteralExpression)exp;
            switch (litEx.getKind()) {
                case 6: 
                case 7: {
                    return IntegralValue.create(0L);
                }
                case 5: {
                    return IntegralValue.create(1L);
                }
                case 0: {
                    try {
                        return IntegralValue.create(ExpressionEvaluator.getNumber(litEx.getValue()));
                    }
                    catch (ExpressionEvaluator.EvalException e) {
                        return IntegralValue.UNKNOWN;
                    }
                }
                case 2: {
                    try {
                        char[] image = litEx.getValue();
                        if (image.length > 1 && image[0] == 'L') {
                            return IntegralValue.create(ExpressionEvaluator.getChar(image, 2));
                        }
                        return IntegralValue.create(ExpressionEvaluator.getChar(image, 1));
                    }
                    catch (ExpressionEvaluator.EvalException e) {
                        return IntegralValue.UNKNOWN;
                    }
                }
                case 1: {
                    return FloatingPointValue.create(litEx.getValue());
                }
                case 3: {
                    return CStringValue.create(litEx.getValue());
                }
            }
        }
        if (exp instanceof IASTTypeIdExpression) {
            typeIdExp = (IASTTypeIdExpression)exp;
            ASTTranslationUnit ast = (ASTTranslationUnit)exp.getTranslationUnit();
            IType type = ast.createType(typeIdExp.getTypeId());
            if (type instanceof ICPPUnknownType) {
                return null;
            }
            return ValueFactory.applyUnaryTypeIdOperator(typeIdExp.getOperator(), type);
        }
        if (exp instanceof IASTBinaryTypeIdExpression) {
            typeIdExp = (IASTBinaryTypeIdExpression)exp;
            ASTTranslationUnit ast = (ASTTranslationUnit)exp.getTranslationUnit();
            IType t1 = ast.createType(typeIdExp.getOperand1());
            IType t2 = ast.createType(typeIdExp.getOperand2());
            if (CPPTemplates.isDependentType(t1) || CPPTemplates.isDependentType(t2)) {
                return null;
            }
            return ValueFactory.applyBinaryTypeIdOperator(typeIdExp.getOperator(), t1, t2);
        }
        return IntegralValue.UNKNOWN;
    }

    private static IValue evaluateBinding(IBinding b) {
        if (b instanceof IType) {
            return IntegralValue.UNKNOWN;
        }
        if (b instanceof ICPPTemplateNonTypeParameter) {
            return null;
        }
        if (b instanceof ICPPUnknownBinding) {
            return null;
        }
        IValue value = null;
        if (b instanceof IVariable) {
            value = ((IVariable)b).getInitialValue();
        } else if (b instanceof IEnumerator) {
            value = ((IEnumerator)b).getValue();
        }
        if (ValueFactory.isInvalidValue(value)) {
            return IntegralValue.UNKNOWN;
        }
        return value;
    }

    private static IValue applyUnaryTypeIdOperator(int operator, IType type) {
        type = SemanticUtil.getNestedType(type, 9);
        switch (operator) {
            case 0: {
                return ValueFactory.getSize(type);
            }
            case 2: {
                return ValueFactory.getAlignment(type);
            }
            case 1: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 9: {
                break;
            }
            case 8: {
                return IntegralValue.create(!(type instanceof ICPPClassType) || TypeTraits.hasTrivialCopyCtor((ICPPClassType)type) ? 1 : 0);
            }
            case 10: {
                break;
            }
            case 25: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                return IntegralValue.create(type instanceof ICPPClassType && TypeTraits.isAbstract((ICPPClassType)type) ? 1 : 0);
            }
            case 26: {
                return IntegralValue.create(type instanceof ICPPClassType && TypeTraits.isAggregateClass((ICPPClassType)type) ? 1 : 0);
            }
            case 13: {
                return IntegralValue.create(type instanceof ICompositeType && ((ICompositeType)type).getKey() != 2 ? 1 : 0);
            }
            case 14: {
                return IntegralValue.create(TypeTraits.isEmpty(type) ? 1 : 0);
            }
            case 15: {
                return IntegralValue.create(type instanceof IEnumeration ? 1 : 0);
            }
            case 23: {
                return IntegralValue.create(type instanceof ICPPClassType && ((ICPPClassType)type).isFinal() ? 1 : 0);
            }
            case 19: {
                break;
            }
            case 16: {
                return IntegralValue.create(TypeTraits.isPOD(type) ? 1 : 0);
            }
            case 17: {
                return IntegralValue.create(type instanceof ICPPClassType && TypeTraits.isPolymorphic((ICPPClassType)type) ? 1 : 0);
            }
            case 20: {
                return IntegralValue.create(TypeTraits.isStandardLayout(type) ? 1 : 0);
            }
            case 21: {
                return IntegralValue.create(type instanceof ICPPClassType && TypeTraits.isTrivial((ICPPClassType)type) ? 1 : 0);
            }
            case 24: {
                return IntegralValue.create(TypeTraits.isTriviallyCopyable(type) ? 1 : 0);
            }
            case 18: {
                return IntegralValue.create(type instanceof ICompositeType && ((ICompositeType)type).getKey() == 2 ? 1 : 0);
            }
            case 27: {
                return IntegralValue.create(TypeTraits.isFunction(type) ? 1 : 0);
            }
        }
        return IntegralValue.UNKNOWN;
    }

    private static IValue getAlignment(IType type) {
        SizeofCalculator.SizeAndAlignment sizeAndAlignment = SizeofCalculator.getSizeAndAlignment(type);
        if (sizeAndAlignment == null) {
            return IntegralValue.UNKNOWN;
        }
        return IntegralValue.create(sizeAndAlignment.alignment);
    }

    private static IValue getSize(IType type) {
        SizeofCalculator.SizeAndAlignment sizeAndAlignment = SizeofCalculator.getSizeAndAlignment(type);
        if (sizeAndAlignment == null) {
            return IntegralValue.UNKNOWN;
        }
        return IntegralValue.create(sizeAndAlignment.size);
    }

    private static IValue evaluateUnaryExpression(IASTUnaryExpression exp) {
        int unaryOp = exp.getOperator();
        if (unaryOp == 8) {
            IASTExpression operand = exp.getOperand();
            if (operand != null) {
                IType type = operand.getExpressionType();
                if (type instanceof ICPPUnknownType) {
                    return null;
                }
                ASTTranslationUnit ast = (ASTTranslationUnit)exp.getTranslationUnit();
                SizeofCalculator calculator = ast.getSizeofCalculator();
                SizeofCalculator.SizeAndAlignment info = calculator.sizeAndAlignment(type);
                if (info != null) {
                    return IntegralValue.create(info.size);
                }
            }
            return IntegralValue.UNKNOWN;
        }
        if (unaryOp == 5 || unaryOp == 4 || unaryOp == 16) {
            return IntegralValue.UNKNOWN;
        }
        IValue value = ValueFactory.evaluate(exp.getOperand());
        if (ValueFactory.isInvalidValue(value)) {
            return value;
        }
        if (ValueFactory.isDeferredValue(value)) {
            return null;
        }
        return ValueFactory.applyUnaryOperator(unaryOp, value, exp.getExpressionType());
    }

    private static IValue applyUnaryOperator(int unaryOp, IValue value, IType type) {
        if (ValueFactory.isInvalidValue(value) || value.numberValue() == null) {
            return IntegralValue.UNKNOWN;
        }
        if (!(value instanceof IntegralValue) && !(value instanceof FloatingPointValue)) {
            return IntegralValue.UNKNOWN;
        }
        switch (unaryOp) {
            case 2: 
            case 11: {
                return value;
            }
            case 0: 
            case 9: {
                if (value instanceof IntegralValue) {
                    return IntegralValue.create(value.numberValue().longValue() + 1L);
                }
                FloatingPointValue fpv = (FloatingPointValue)value;
                return FloatingPointValue.create(fpv.numberValue().doubleValue() + 1.0);
            }
            case 1: 
            case 10: {
                if (value instanceof IntegralValue) {
                    return IntegralValue.create(value.numberValue().longValue() - 1L);
                }
                FloatingPointValue fpv = (FloatingPointValue)value;
                return FloatingPointValue.create(fpv.numberValue().doubleValue() - 1.0);
            }
            case 3: {
                if (value instanceof IntegralValue) {
                    IBasicType basicType;
                    if (type instanceof IBasicType && (basicType = (IBasicType)type).isUnsigned()) {
                        SizeofCalculator.SizeAndAlignment sizeAndAlignment = SizeofCalculator.getSizeAndAlignment(basicType);
                        if (sizeAndAlignment != null && sizeAndAlignment.size < 8L) {
                            long range = 1L << (int)(sizeAndAlignment.size * 8L);
                            return IntegralValue.create(range - value.numberValue().longValue());
                        }
                        return IntegralValue.create(-value.numberValue().longValue());
                    }
                    return IntegralValue.create(-value.numberValue().longValue());
                }
                FloatingPointValue fpv = (FloatingPointValue)value;
                return FloatingPointValue.create(-fpv.numberValue().doubleValue());
            }
            case 6: {
                if (value instanceof IntegralValue) {
                    return IntegralValue.create(value.numberValue().longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                }
                return IntegralValue.UNKNOWN;
            }
            case 7: {
                if (value instanceof IntegralValue) {
                    Long num = value.numberValue().longValue();
                    return IntegralValue.create(num == 0L ? 1 : 0);
                }
                FloatingPointValue fpv = (FloatingPointValue)value;
                Double num = fpv.numberValue().doubleValue();
                return IntegralValue.create(num == 0.0 ? 1 : 0);
            }
        }
        return IntegralValue.UNKNOWN;
    }

    private static IValue evaluateBinaryExpression(IASTBinaryExpression exp) {
        int op = exp.getOperator();
        if (op == 28 && exp.getOperand1().equals(exp.getOperand2())) {
            return IntegralValue.create(true);
        }
        if (op == 29 && exp.getOperand1().equals(exp.getOperand2())) {
            return IntegralValue.create(false);
        }
        IValue o1 = ValueFactory.evaluate(exp.getOperand1());
        if (ValueFactory.isInvalidValue(o1)) {
            return o1;
        }
        IValue o2 = ValueFactory.evaluate(exp.getOperand2());
        if (ValueFactory.isInvalidValue(o2)) {
            return o2;
        }
        if (ValueFactory.isDeferredValue(o1) || ValueFactory.isDeferredValue(o2)) {
            return null;
        }
        IType commonType = CPPArithmeticConversion.convertCppOperandTypes(op, exp.getOperand1().getExpressionType(), exp.getOperand2().getExpressionType());
        return ValueFactory.evaluateBinaryExpression(op, o1, o2, commonType);
    }

    private static IValue applyBinaryTypeIdOperator(IASTBinaryTypeIdExpression.Operator operator, IType type1, IType type2) {
        switch (operator) {
            case __is_base_of: {
                type1 = SemanticUtil.getNestedType(type1, 1);
                type2 = SemanticUtil.getNestedType(type2, 1);
                if (type1 instanceof ICPPClassType && type2 instanceof ICPPClassType && (type1.isSameType(type2) || ClassTypeHelper.isSubclass((ICPPClassType)type2, (ICPPClassType)type1))) {
                    return IntegralValue.create(1L);
                }
                return IntegralValue.create(0L);
            }
            case __is_assignable: {
                return IntegralValue.UNKNOWN;
            }
            case __is_nothrow_assignable: {
                return IntegralValue.UNKNOWN;
            }
            case __is_same: {
                if (type1.isSameType(type2)) {
                    return IntegralValue.create(1L);
                }
                return IntegralValue.create(0L);
            }
            case __is_trivially_assignable: {
                return IntegralValue.UNKNOWN;
            }
        }
        return IntegralValue.UNKNOWN;
    }

    private static IValue applyNaryTypeIdOperator(ICPPASTNaryTypeIdExpression.Operator operator, IType[] operands, IBinding pointOfDefinition) {
        switch (operator) {
            case __is_trivially_constructible: 
            case __is_constructible: {
                if (operands.length == 0) {
                    return IntegralValue.UNKNOWN;
                }
                boolean checkTrivial = operator == ICPPASTNaryTypeIdExpression.Operator.__is_trivially_constructible;
                IType typeToConstruct = operands[0];
                IType[] argumentTypes = Arrays.copyOfRange(operands, 1, operands.length);
                return IntegralValue.create(TypeTraits.isConstructible(typeToConstruct, argumentTypes, pointOfDefinition, checkTrivial) ? 1 : 0);
            }
            case __is_nothrow_constructible: {
                return IntegralValue.UNKNOWN;
            }
        }
        return IntegralValue.UNKNOWN;
    }

    private static boolean isInvalidValue(IValue value) {
        return value == null || value == IntegralValue.UNKNOWN || value == IntegralValue.ERROR;
    }

    private static boolean isDeferredValue(IValue value) {
        return value instanceof DependentValue || value instanceof IntegralValue && ((IntegralValue)value).numberValue() == null;
    }

    public static Number getConstantNumericalValue(IASTExpression expr) {
        try {
            ICPPEvaluation eval;
            CPPSemantics.pushLookupPoint(expr);
            IValue val = ValueFactory.evaluate(expr);
            if (val != null) {
                Number number = val.numberValue();
                return number;
            }
            if (expr instanceof ICPPASTInitializerClause && (eval = ((ICPPASTInitializerClause)((Object)expr)).getEvaluation()).isConstantExpression() && !eval.isValueDependent()) {
                Number number = eval.getValue().numberValue();
                return number;
            }
            return null;
        }
        finally {
            CPPSemantics.popLookupPoint();
        }
    }
}

