/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.commentelement.util;

public class TagScanner {
    private int length = 0;
    private int memOffset = 0;
    private int offset = 0;
    private boolean oneLine = false;
    private String tag = null;

    private static boolean isEqual(char c) {
        return c == '=';
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'';
    }

    private static boolean isSpace(char c) {
        return Character.isWhitespace(c);
    }

    public TagScanner(String tag, int offset) {
        this.tag = tag;
        this.offset = offset;
        this.memOffset = -1;
        if (tag != null) {
            this.length = tag.length();
        }
    }

    public TagScanner(String tag, int offset, boolean oneLine) {
        this(tag, offset);
        this.oneLine = oneLine;
    }

    public int getNextOffset() {
        int i = this.offset;
        while (i < this.length) {
            char c = this.tag.charAt(i);
            if (this.isEnd(c)) break;
            if (TagScanner.isQuote(c)) {
                ++i;
                break;
            }
            if (!TagScanner.isSpace(c) && !TagScanner.isEqual(c)) break;
            ++i;
        }
        return i;
    }

    public int getOffset() {
        return this.memOffset;
    }

    private final boolean isEnd(char c) {
        return this.oneLine && (c == '\r' || c == '\n');
    }

    public boolean isNewLine() {
        if (this.oneLine) {
            return false;
        }
        int i = this.memOffset - 1;
        while (i >= 0) {
            char c = this.tag.charAt(i);
            if (c == '\r' || c == '\n') {
                return true;
            }
            if (!TagScanner.isSpace(c)) {
                return false;
            }
            --i;
        }
        return false;
    }

    private char nextChar() {
        while (this.offset < this.length) {
            char c = this.tag.charAt(this.offset);
            if (this.isEnd(c)) break;
            if (!TagScanner.isSpace(c)) {
                return c;
            }
            ++this.offset;
        }
        return '\u0000';
    }

    public String nextName() {
        if (this.tag == null) {
            return null;
        }
        if (this.offset >= this.length) {
            return null;
        }
        if (this.nextChar() == '\u0000') {
            return null;
        }
        int nameOffset = this.offset;
        while (this.offset < this.length) {
            char c = this.tag.charAt(this.offset);
            if (this.isEnd(c) || TagScanner.isSpace(c) || TagScanner.isEqual(c) && this.offset > nameOffset) break;
            ++this.offset;
        }
        if (this.offset == nameOffset) {
            return null;
        }
        this.memOffset = nameOffset;
        return this.tag.substring(nameOffset, this.offset);
    }

    public String nextValue() {
        if (this.tag == null) {
            return null;
        }
        if (this.offset >= this.length) {
            return null;
        }
        char seperator = this.nextChar();
        if (!TagScanner.isEqual(seperator)) {
            return null;
        }
        ++this.offset;
        char quote = this.nextChar();
        if (quote == '\u0000') {
            return null;
        }
        if (TagScanner.isQuote(quote)) {
            ++this.offset;
        } else {
            quote = '\u0000';
        }
        int valueOffset = this.offset;
        while (this.offset < this.length) {
            char c = this.tag.charAt(this.offset);
            if (this.isEnd(c)) {
                quote = '\u0000';
                break;
            }
            if (quote == '\u0000' ? TagScanner.isSpace(c) : c == quote) break;
            ++this.offset;
        }
        int valueEnd = this.offset;
        if (quote != '\u0000' && this.offset < this.length) {
            ++this.offset;
        }
        if (valueEnd == valueOffset) {
            return null;
        }
        this.memOffset = valueOffset;
        return this.tag.substring(valueOffset, valueEnd);
    }
}

