/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows;

import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.FlowsNodeMap;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.flows.IFlowsNode;
import org.eclipse.tracecompass.incubator.internal.otf2.core.trace.SystemTreeNode;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

class FlowsSystemTreeNode
extends SystemTreeNode
implements IFlowsNode {
    private int fInputQuark = -1;
    private int fOutputQuark = -1;

    public FlowsSystemTreeNode(ITmfEvent event) {
        super(event);
    }

    public void initializeQuarks(ITmfStateSystemBuilder ssb, @Nullable FlowsNodeMap<Long, FlowsSystemTreeNode> systemTreeNodeMap, Map<Integer, String> stringIdMap) {
        String fullName = this.getFullName(stringIdMap);
        long parentId = this.getParentId();
        if (this.isRootNode()) {
            this.fInputQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"In", fullName});
            this.fOutputQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"Out", fullName});
        } else if (systemTreeNodeMap != null) {
            int parentInputQuark = systemTreeNodeMap.getNodeQuark(parentId, "In");
            int parentOutputQuark = systemTreeNodeMap.getNodeQuark(parentId, "Out");
            this.fInputQuark = ssb.getQuarkRelativeAndAdd(parentInputQuark, new String[]{fullName});
            this.fOutputQuark = ssb.getQuarkRelativeAndAdd(parentOutputQuark, new String[]{fullName});
        }
    }

    @Override
    public int getInputQuark() {
        return this.fInputQuark;
    }

    @Override
    public int getOutputQuark() {
        return this.fOutputQuark;
    }
}

