/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.kernel.core.fileaccess;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.analysis.core.model.ModelManager;
import org.eclipse.tracecompass.incubator.internal.kernel.core.Activator;
import org.eclipse.tracecompass.incubator.internal.kernel.core.fileaccess.FileAccessAnalysis;
import org.eclipse.tracecompass.incubator.internal.kernel.core.fileaccess.FileEntryModel;
import org.eclipse.tracecompass.incubator.internal.kernel.core.filedescriptor.ThreadEntryModel;
import org.eclipse.tracecompass.incubator.internal.kernel.core.filedescriptor.TidTimeQueryFilter;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.internal.tmf.core.model.timegraph.AbstractTimeGraphDataProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class FileAccessDataProvider
extends AbstractTimeGraphDataProvider<FileAccessAnalysis, TimeGraphEntryModel> {
    public static final String SUFFIX = ".dataprovider";
    private static final Pattern IS_INTEGER = Pattern.compile("\\d+");
    private static final int OFFSET = 100000;
    private static final AtomicInteger STRING_VALUE = new AtomicInteger(100000);
    private Map<String, Integer> fileIds = new HashMap<String, Integer>();

    public FileAccessDataProvider(ITmfTrace trace, FileAccessAnalysis analysisModule) {
        super(trace, (TmfStateSystemAnalysisModule)analysisModule);
    }

    @Deprecated
    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(@NonNull TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        Map parameters = FetchParametersUtils.timeQueryToMap((TimeQueryFilter)filter);
        return this.fetchArrows(parameters, monitor);
    }

    public TmfModelResponse<List<ITimeGraphArrow>> fetchArrows(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public @NonNull String getId() {
        return String.valueOf(((FileAccessAnalysis)this.getAnalysisModule()).getId()) + SUFFIX;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable TimeGraphModel getRowModel(ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(parameters);
        if (filter == null) {
            return null;
        }
        TreeMultimap intervals = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
        @NonNull @NonNull Map entries = this.getSelectedEntries(filter);
        Collection times = FileAccessDataProvider.getTimes((TimeQueryFilter)filter, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
        for (ITmfStateInterval interval : ss.query2D(entries.values(), times)) {
            if (monitor != null && monitor.isCanceled()) {
                return new TimeGraphModel(Collections.emptyList());
            }
            intervals.put((Object)interval.getAttribute(), (Object)interval);
        }
        HashMap<@NonNull K, @NonNull @NonNull @NonNull @NonNull V> predicates = new HashMap();
        @NonNull @NonNull Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(parameters);
        if (regexesMap != null) {
            predicates.putAll(this.computeRegexPredicate(regexesMap));
        }
        ArrayList<@NonNull TimeGraphRowModel> rows = new ArrayList<TimeGraphRowModel>();
        for (Map.Entry entry : entries.entrySet()) {
            if (monitor != null && monitor.isCanceled()) {
                return new TimeGraphModel(Collections.emptyList());
            }
            ArrayList eventList = new ArrayList();
            for (ITmfStateInterval interval : intervals.get((Object)((Integer)entry.getValue()))) {
                long startTime = interval.getStartTime();
                long duration = interval.getEndTime() - startTime + 1L;
                Object state = interval.getValue();
                String label = null;
                TimeGraphState value = null;
                if (Integer.valueOf(1).equals(state)) {
                    ITmfTrace trace = this.getTrace();
                    List sub = ss.getSubAttributes(interval.getAttribute(), false);
                    for (ITmfStateInterval threadInterval : ss.query2D((Collection)sub, Collections.singleton(startTime))) {
                        Object sv = threadInterval.getValue();
                        if (sv == null) continue;
                        int tid = FileAccessDataProvider.getTid(ss, threadInterval.getAttribute());
                        label = String.valueOf(FileAccessDataProvider.getThreadName(tid, interval.getStartTime(), trace)) + " (" + tid + ")";
                        value = new TimeGraphState(startTime, duration, tid, label);
                        break;
                    }
                }
                if (state != null && value == null) {
                    value = new TimeGraphState(startTime, duration, 1);
                }
                if (value == null) {
                    value = new TimeGraphState(startTime, duration, Integer.MIN_VALUE);
                }
                this.applyFilterAndAddState(eventList, (ITimeGraphState)value, (Long)entry.getKey(), predicates, monitor);
            }
            rows.add(new TimeGraphRowModel(((Long)entry.getKey()).longValue(), eventList));
        }
        return new TimeGraphModel(rows);
    }

    protected boolean isCacheable() {
        return false;
    }

    @Deprecated
    public TmfModelResponse<Map<String, String>> fetchTooltip(SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        Map parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter);
        return this.fetchTooltip(parameters, monitor);
    }

    public TmfModelResponse<Map<String, String>> fetchTooltip(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        ITmfStateSystem ss = ((FileAccessAnalysis)this.getAnalysisModule()).getStateSystem();
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        if (filter == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        Collection<@NonNull V> quarks = this.getSelectedEntries(filter).values();
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>();
        if (quarks.size() != 1) {
            return new TmfModelResponse(retMap, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        long start = filter.getStart();
        if (ss == null || quarks.size() != 1 || !((FileAccessAnalysis)this.getAnalysisModule()).isQueryable(start)) {
            return new TmfModelResponse(retMap, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        int quark = (Integer)quarks.iterator().next();
        try {
            ITmfStateInterval current = ss.querySingleState(start, quark);
            int resQuark = ss.optQuarkAbsolute(new String[]{"RES"});
            if (resQuark == -2) {
                return new TmfModelResponse(retMap, ITmfResponse.Status.FAILED, "Bizarre quark value for the file resources");
            }
            int parentQuark = ss.getParentAttributeQuark(quark);
            if (parentQuark == resQuark) {
                String fileName = ss.getAttributeName(quark);
                retMap.put("File Name", fileName);
                Object value = current.getValue();
                retMap.put("Number of opened FD", value instanceof Number ? String.valueOf(value) : "0");
                return new TmfModelResponse(retMap, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
            }
            int parentQuark2 = ss.getParentAttributeQuark(parentQuark);
            if (parentQuark2 == resQuark) {
                String fileName = ss.getAttributeName(parentQuark);
                retMap.put("File Name", fileName);
                Object value = current.getValue();
                if (value instanceof Number) {
                    retMap.put("FD", String.valueOf(value));
                }
                return new TmfModelResponse(retMap, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
            }
            return new TmfModelResponse(retMap, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected TmfTreeModel<TimeGraphEntryModel> getTree(ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        Set<Integer> selectedTids = Collections.emptySet();
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(parameters);
        if (filter instanceof TidTimeQueryFilter) {
            selectedTids = ((TidTimeQueryFilter)filter).getTids();
        }
        // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull ImmutableList.Builder builder = new ImmutableList.Builder();
        long rootId = this.getId(-1);
        ITmfTrace trace = this.getTrace();
        builder.add((Object)new TimeGraphEntryModel(rootId, -1L, String.valueOf(trace.getName()), ss.getStartTime(), ss.getCurrentEndTime()));
        try {
            this.addResources(ss, (ImmutableList.Builder<TimeGraphEntryModel>)builder, ss.getQuarkAbsolute(new String[]{"RES"}), rootId, selectedTids);
        }
        catch (AttributeNotFoundException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
        return new TmfTreeModel(Collections.emptyList(), (List)builder.build());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void addResources(ITmfStateSystem ss, // Could not load outer class - annotation placement on inner may be incorrect
    ImmutableList.Builder<@NonNull TimeGraphEntryModel> builder, int quark, long parentId, Collection<Integer> filter) {
        @NonNull List fileQuarks = ss.getSubAttributes(quark, false);
        String ramFiles = "in memory";
        boolean hasMemfile = false;
        int ramHash = this.fileIds.computeIfAbsent(ramFiles, a -> STRING_VALUE.incrementAndGet());
        long ramId = this.getId(ramHash);
        TimeGraphEntryModel ramElement = new TimeGraphEntryModel(ramId, parentId, ramFiles, ss.getStartTime(), ss.getCurrentEndTime());
        for (Integer fileQuark : fileQuarks) {
            String name = ss.getAttributeName(fileQuark.intValue());
            long id = this.getId(fileQuark);
            List sub = ss.getSubAttributes(fileQuark.intValue(), false);
            Set contributingTids = sub.stream().map(arg_0 -> ((ITmfStateSystem)ss).getAttributeName(arg_0)).filter(FileAccessDataProvider::isInteger).map(Integer::parseInt).collect(Collectors.toSet());
            if (!filter.isEmpty() && Sets.intersection(contributingTids, new HashSet<Integer>(filter)).isEmpty()) continue;
            if (name.startsWith(File.separator)) {
                String[] segments = name.split(File.separator);
                StringBuilder sb = new StringBuilder();
                long parent = parentId;
                builder.add((Object)new FileEntryModel(this.getId(this.fileIds.computeIfAbsent(File.separator, a -> STRING_VALUE.incrementAndGet())), parentId, File.separator, ss.getStartTime(), ss.getCurrentEndTime(), false, FileEntryModel.Type.Directory));
                int i = 0;
                while (i < segments.length - 1) {
                    sb.append('/').append(segments[i]);
                    String fileName = sb.toString();
                    Long fileId = this.getId(this.fileIds.computeIfAbsent(fileName, a -> STRING_VALUE.incrementAndGet()));
                    builder.add((Object)new FileEntryModel(fileId, parent, String.valueOf(segments[i]) + File.separator, ss.getStartTime(), ss.getCurrentEndTime(), false, FileEntryModel.Type.Directory));
                    parent = fileId;
                    ++i;
                }
                builder.add((Object)new FileEntryModel(id, parent, name.substring(1 + name.lastIndexOf(File.separator)), ss.getStartTime(), ss.getCurrentEndTime(), true, FileEntryModel.Type.File));
            } else {
                if (!hasMemfile) {
                    builder.add((Object)ramElement);
                    hasMemfile = true;
                }
                builder.add((Object)new FileEntryModel(id, ramId, name, ss.getStartTime(), ss.getCurrentEndTime(), true, FileEntryModel.Type.InRam));
            }
            @NonNull List threadQuarks = ss.getSubAttributes(fileQuark.intValue(), false);
            if (threadQuarks.size() == 1) continue;
            for (Integer threadQuark : threadQuarks) {
                ITmfTrace trace = this.getTrace();
                int tid = FileAccessDataProvider.getTid(ss, threadQuark);
                if (tid == -1) continue;
                String threadName = FileAccessDataProvider.getThreadName(tid, ss.getStartTime(), trace);
                builder.add((Object)new ThreadEntryModel(this.getId(threadQuark), id, String.valueOf(threadName), ss.getStartTime(), ss.getCurrentEndTime(), true, tid));
            }
        }
    }

    private static @Nullable String getThreadName(int tid, long time, ITmfTrace trace) {
        if (tid != -1) {
            return ModelManager.getModelFor((String)trace.getHostId()).getExecName(tid, time);
        }
        return null;
    }

    private static int getTid(ITmfStateSystem ss, int threadQuark) {
        String attributeName = ss.getAttributeName(threadQuark);
        if (FileAccessDataProvider.isInteger(attributeName)) {
            return Integer.parseInt(attributeName);
        }
        return -1;
    }

    private static boolean isInteger(String attributeName) {
        return IS_INTEGER.matcher(attributeName).matches();
    }

    public @Nullable Long getBytesRead(long start, long end, long attributeId) {
        ITmfStateSystem ss = ((FileAccessAnalysis)this.getAnalysisModule()).getStateSystem();
        if (ss == null) {
            return null;
        }
        Map selectedEntries = this.getSelectedEntries(new SelectionTimeQueryFilter(Arrays.asList(start, end), Collections.singleton(attributeId)));
        Integer startingNodeQuark = (Integer)selectedEntries.get(attributeId);
        if (startingNodeQuark == null || startingNodeQuark >= 100000) {
            return null;
        }
        int readQuark = ss.optQuarkRelative(startingNodeQuark.intValue(), new String[]{"read"});
        return FileAccessDataProvider.getdelta(start, end, ss, readQuark);
    }

    public @Nullable Long getBytesWrite(long start, long end, long attributeId) {
        ITmfStateSystem ss = ((FileAccessAnalysis)this.getAnalysisModule()).getStateSystem();
        if (ss == null) {
            return null;
        }
        Map selectedEntries = this.getSelectedEntries(new SelectionTimeQueryFilter(Arrays.asList(start, end), Collections.singleton(attributeId)));
        Integer startingNodeQuark = (Integer)selectedEntries.get(attributeId);
        if (startingNodeQuark == null || startingNodeQuark >= 100000) {
            return null;
        }
        int readQuark = ss.optQuarkRelative(startingNodeQuark.intValue(), new String[]{"write"});
        return FileAccessDataProvider.getdelta(start, end, ss, readQuark);
    }

    private static @Nullable Long getdelta(long start, long end, ITmfStateSystem ss, int readQuark) {
        if (readQuark == -2) {
            return null;
        }
        try {
            ITmfStateInterval startInterval = ss.querySingleState(start, readQuark);
            ITmfStateInterval endInterval = ss.querySingleState(end, readQuark);
            return endInterval.getValueLong() - startInterval.getValueLong();
        }
        catch (StateSystemDisposedException e) {
            return null;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Multimap<@NonNull String, @NonNull Object> getFilterData(long entryId, long time, @Nullable IProgressMonitor monitor) {
        @NonNull @NonNull HashMultimap data = HashMultimap.create();
        data.putAll(super.getFilterData(entryId, time, monitor));
        SelectionTimeQueryFilter filter = new SelectionTimeQueryFilter(Collections.singletonList(time), Collections.singleton(Objects.requireNonNull(entryId)));
        TmfModelResponse<Map<String, String>> response = this.fetchTooltip(filter, monitor);
        @NonNull @NonNull Map model = (Map)response.getModel();
        if (model != null) {
            for (Map.Entry entry : model.entrySet()) {
                data.put((Object)((String)entry.getKey()), entry.getValue());
            }
        }
        return data;
    }
}

