/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.resources.undo.snapshot.IContainerSnapshot;
import org.eclipse.core.resources.undo.snapshot.IResourceSnapshot;
import org.eclipse.core.resources.undo.snapshot.ResourceSnapshotFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.ide.dialogs.UIResourceFilterDescription;
import org.eclipse.ui.ide.undo.AbstractCreateResourcesOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class CreateFolderOperation
extends AbstractCreateResourcesOperation {
    public CreateFolderOperation(IFolder folderHandle, URI linkLocation, String label) {
        this(folderHandle, linkLocation, false, null, label);
    }

    public CreateFolderOperation(IFolder folderHandle, URI linkLocation, boolean virtual, UIResourceFilterDescription[] filterList, String label) {
        super((IResourceSnapshot<? extends IResource>[])null, label);
        IContainerSnapshot containerDescription;
        IContainerSnapshot iContainerSnapshot = containerDescription = virtual ? ResourceSnapshotFactory.fromVirtualFolderContainer((IContainer)folderHandle) : ResourceSnapshotFactory.fromContainer((IContainer)folderHandle);
        if (linkLocation != null) {
            WorkspaceUndoUtil.getFirstLeafFolder((IContainerSnapshot<? extends IContainer>)containerDescription).setLocation(linkLocation);
        }
        if (filterList != null) {
            List<IResourceFilterDescription> l = Arrays.asList(filterList).stream().map(x -> this.convert((UIResourceFilterDescription)x)).collect(Collectors.toList());
            IResourceFilterDescription[] asArr = l.toArray(new IResourceFilterDescription[l.size()]);
            WorkspaceUndoUtil.getFirstLeafFolder((IContainerSnapshot<? extends IContainer>)containerDescription).setFilters(asArr);
        }
        this.setResourceDescriptions(new IResourceSnapshot[]{containerDescription});
    }

    private IResourceFilterDescription convert(final UIResourceFilterDescription desc) {
        return new IResourceFilterDescription(){

            public FileInfoMatcherDescription getFileInfoMatcherDescription() {
                return desc.getFileInfoMatcherDescription();
            }

            public IResource getResource() {
                return desc.getProject();
            }

            public int getType() {
                return desc.getType();
            }

            public void delete(int updateFlags, IProgressMonitor monitor) {
            }
        };
    }
}

