/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.auth;

import java.util.ArrayList;
import javax.security.auth.login.Configuration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.equinox.internal.security.auth.AuthPlugin;
import org.eclipse.equinox.internal.security.auth.nls.SecAuthMessages;
import org.eclipse.osgi.util.NLS;

public class ConfigurationFactory {
    private static final String ELEM_PROVIDER = "loginConfigurationProvider";
    private static final String ATTR_PROVIDER_CLASS = "class";
    private static final String POINT_PROVIDER = "org.eclipse.equinox.security.loginConfigurationProvider";
    private static ConfigurationFactory s_instance = new ConfigurationFactory();

    static ConfigurationFactory getInstance() {
        return s_instance;
    }

    public Configuration[] getConfigurations() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint point = registry.getExtensionPoint(POINT_PROVIDER);
        IExtension[] extensions = point.getExtensions();
        ArrayList<Configuration> returnValue = new ArrayList<Configuration>(extensions.length);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                Configuration provider = this.readProvider(element);
                if (provider != null) {
                    returnValue.add(provider);
                }
                ++n4;
            }
            ++n2;
        }
        return returnValue.toArray(new Configuration[0]);
    }

    private Configuration readProvider(IConfigurationElement element) {
        if (!ELEM_PROVIDER.equals(element.getName())) {
            this.reportError(SecAuthMessages.unexpectedConfigElement, element.getName(), element, null);
            return null;
        }
        try {
            return (Configuration)element.createExecutableExtension(ATTR_PROVIDER_CLASS);
        }
        catch (CoreException e) {
            this.reportError(SecAuthMessages.instantiationFailed, element.getAttribute(ATTR_PROVIDER_CLASS), element, e);
            return null;
        }
    }

    private void reportError(String template, String arg, IConfigurationElement element, Throwable e) {
        String supplier = element.getContributor().getName();
        String message = NLS.bind((String)template, (Object)arg, (Object)supplier);
        AuthPlugin.getDefault().logError(message, e);
    }
}

