/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.parser;

import java.io.Reader;
import java.util.List;
import java.util.Map;
import org.eclipse.tm4e.core.internal.parser.PListContentHandler;
import org.eclipse.tm4e.core.internal.parser.PListParser;
import org.eclipse.tm4e.core.internal.parser.PListPath;
import org.eclipse.tm4e.core.internal.parser.PropertySettable;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.xml.sax.SAXException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public final class PListParserYAML<T>
implements PListParser<T> {
    private final PropertySettable.Factory<PListPath> objectFactory;

    public PListParserYAML(PropertySettable.Factory<PListPath> objectFactory) {
        this.objectFactory = objectFactory;
    }

    private void addListToPList(PListContentHandler<T> pList, List<Object> list) throws SAXException {
        pList.startElement(null, "array", null, null);
        for (Object item : list) {
            if (item instanceof List var5_5) {
                this.addListToPList(pList, (List<Object>)items);
                continue;
            }
            if (item instanceof Map var8_7) {
                this.addMapToPList(pList, (Map<String, Object>)map);
                continue;
            }
            this.addStringToPList(pList, item.toString());
        }
        pList.endElement(null, "array", null);
    }

    /*
     * WARNING - void declaration
     */
    private void addMapToPList(PListContentHandler<T> pList, Map<String, Object> map) throws SAXException {
        pList.startElement(null, "dict", null, null);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            pList.startElement(null, "key", null, null);
            pList.characters(entry.getKey());
            pList.endElement(null, "key", null);
            Object object = entry.getValue();
            if (object instanceof List var5_5) {
                void list;
                this.addListToPList(pList, (List<Object>)list);
                continue;
            }
            Object object2 = entry.getValue();
            if (object2 instanceof Map var8_7) {
                void valueMap;
                this.addMapToPList(pList, (Map<String, Object>)valueMap);
                continue;
            }
            this.addStringToPList(pList, NullSafetyHelper.castNonNull(entry.getValue()).toString());
        }
        pList.endElement(null, "dict", null);
    }

    private void addStringToPList(PListContentHandler<T> pList, String value) throws SAXException {
        pList.startElement(null, "string", null, null);
        pList.characters(value);
        pList.endElement(null, "string", null);
    }

    @Override
    public T parse(Reader contents) throws SAXException, YAMLException {
        PListContentHandler pList = new PListContentHandler(this.objectFactory);
        pList.startElement(null, "plist", null, null);
        this.addMapToPList(pList, (Map)new Yaml().loadAs(contents, Map.class));
        pList.endElement(null, "plist", null);
        return pList.getResult();
    }
}

