/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.terminals.ui.handlers;

import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.terminals.ui.TerminalServiceHelper;
import org.eclipse.rse.internal.terminals.ui.views.TerminalViewer;
import org.eclipse.rse.internal.terminals.ui.views.TerminalsUI;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.subsystems.terminals.core.ITerminalServiceSubSystem;
import org.eclipse.rse.subsystems.terminals.core.elements.TerminalElement;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.ui.handlers.HandlerUtil;

public class LaunchTerminalCommandHandler
extends AbstractHandler {
    private ITerminalServiceSubSystem subSystem;
    private Object selected;
    private ISystemFilterReference selectedFilterRef;
    static /* synthetic */ Class class$0;

    private IHost getCurrentHost(IAdaptable adaptable) {
        ISubSystem ss;
        ISystemViewElementAdapter adapter;
        IHost currentHost = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ISystemViewElementAdapter)adaptable.getAdapter((Class)clazz)) != null && (ss = adapter.getSubSystem((Object)adaptable)) != null) {
            currentHost = ss.getHost();
        }
        return currentHost;
    }

    private ITerminalServiceSubSystem getTerminalSubSystem() {
        IHost currentHost = null;
        if (this.selectedFilterRef != null) {
            currentHost = this.getCurrentHost((IAdaptable)this.selectedFilterRef);
        } else if (this.selected != null) {
            currentHost = this.getCurrentHost((IAdaptable)this.selected);
        }
        if (currentHost != null) {
            return TerminalServiceHelper.getTerminalSubSystem(currentHost);
        }
        return this.subSystem;
    }

    private Object getTargetFromFilter() {
        Object target;
        ISubSystem ss;
        ISystemViewElementAdapter adapter;
        IAdaptable iAdaptable = (IAdaptable)this.selectedFilterRef;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz)) != null && (ss = adapter.getSubSystem((Object)this.selectedFilterRef)) != null && (target = ss.getTargetForFilter(this.selectedFilterRef)) != null) {
            return target;
        }
        return null;
    }

    private void init(IStructuredSelection selection) {
        Iterator e = selection.iterator();
        Object selectedObject = e.next();
        this.selected = null;
        this.subSystem = null;
        this.selectedFilterRef = null;
        if (selectedObject != null) {
            if (selectedObject instanceof ISystemFilterReference) {
                this.selectedFilterRef = (ISystemFilterReference)selectedObject;
                this.selected = this.getTargetFromFilter();
            } else if (selectedObject instanceof ITerminalServiceSubSystem) {
                this.subSystem = (ITerminalServiceSubSystem)selectedObject;
            } else {
                this.selected = selectedObject;
            }
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.init((IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        ITerminalServiceSubSystem terminalSubSystem = this.getTerminalSubSystem();
        if (terminalSubSystem != null) {
            TerminalsUI terminalsUI = TerminalsUI.getInstance();
            TerminalViewer viewer = terminalsUI.activateTerminalsView();
            if (!terminalSubSystem.isConnected()) {
                try {
                    terminalSubSystem.connect((IProgressMonitor)new NullProgressMonitor(), false);
                }
                catch (OperationCanceledException e) {
                    return null;
                }
                catch (Exception e) {
                    SystemBasePlugin.logError((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (terminalSubSystem.isConnected()) {
                CTabItem tab = viewer.getTabFolder().createTabItem((IAdaptable)terminalSubSystem.getHost(), this.getInitialDirectoryCmd());
                TerminalElement element = TerminalServiceHelper.createTerminalElement(tab, terminalSubSystem);
                terminalSubSystem.addChild(element);
            }
        }
        return null;
    }

    private String getInitialDirectoryCmd() {
        if (this.selected == null) {
            return null;
        }
        String path = this.getWorkingDirectory(this.selected);
        String cdCmd = this.getTerminalSubSystem().getHost().getSystemType().isWindows() ? "cd /d \"" + path + '\"' : "cd " + PathUtility.enQuoteUnix((String)path);
        return String.valueOf(cdCmd) + "\r";
    }

    private String getWorkingDirectory(Object element) {
        ISystemViewElementAdapter adapter;
        IAdaptable iAdaptable = (IAdaptable)element;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
            String path = adapter.getAbsoluteName(element);
            if (ArchiveHandlerManager.isVirtual((String)path)) {
                path = path.substring(0, path.indexOf("#virtual#"));
            }
            return path;
        }
        return null;
    }
}

