/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.dom;

import com.sun.tools.javac.code.AnnoConstruct;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.lang.model.type.NullType;
import javax.tools.JavaFileObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.JavacBindingResolver;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.ResolvedBinaryType;
import org.eclipse.jdt.internal.core.ResolvedSourceType;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.javac.dom.JavacMethodBinding;

public abstract class JavacTypeBinding
implements ITypeBinding {
    private static final ITypeBinding[] NO_TYPE_ARGUMENTS = new ITypeBinding[0];
    final JavacBindingResolver resolver;
    public final Symbol.TypeSymbol typeSymbol;
    private final Types types;
    public final Type type;
    private final boolean isGeneric;
    private boolean recovered = false;

    public JavacTypeBinding(Type type, Symbol.TypeSymbol typeSymbol, boolean isDeclaration, JavacBindingResolver resolver) {
        if (!JavacBindingResolver.isTypeOfType(type) && typeSymbol != null) {
            type = typeSymbol.type;
        }
        this.isGeneric = type.isParameterized() && isDeclaration;
        this.typeSymbol = typeSymbol.kind == Kinds.Kind.ERR && type != null ? type.tsym : typeSymbol;
        this.type = this.isGeneric || type == null ? this.typeSymbol.type : type;
        this.resolver = resolver;
        this.types = Types.instance(this.resolver.context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof JavacTypeBinding)) return false;
        JavacTypeBinding other = (JavacTypeBinding)obj;
        if (!Objects.equals((Object)this.resolver, (Object)other.resolver)) return false;
        if (!Objects.equals(this.type, other.type)) return false;
        if (!Objects.equals(this.typeSymbol, other.typeSymbol)) return false;
        if (!Objects.equals(this.isGeneric, other.isGeneric)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resolver, this.type, this.typeSymbol, this.isGeneric});
    }

    public IAnnotationBinding[] getAnnotations() {
        java.util.List annots = this.typeSymbol.getAnnotationMirrors();
        if (this.resolver.isRecoveringBindings()) {
            return (IAnnotationBinding[])annots.stream().map(am -> this.resolver.bindings.getAnnotationBinding((Attribute.Compound)am, (IBinding)this)).toArray(IAnnotationBinding[]::new);
        }
        return (IAnnotationBinding[])annots.stream().filter(x -> !(x.type instanceof Type.ErrorType)).map(am -> this.resolver.bindings.getAnnotationBinding((Attribute.Compound)am, (IBinding)this)).toArray(IAnnotationBinding[]::new);
    }

    public int getKind() {
        return 2;
    }

    public boolean isDeprecated() {
        return this.typeSymbol.isDeprecated();
    }

    public boolean isRecovered() {
        if (this.recovered) {
            return true;
        }
        if (this.isArray()) {
            return this.getComponentType().isRecovered();
        }
        return this.typeSymbol.kind == Kinds.Kind.ERR || Object.class.getName().equals(this.typeSymbol.getQualifiedName().toString()) && this.getJavaElement() == null;
    }

    public boolean isSynthetic() {
        return (this.typeSymbol.flags() & 0x1000L) != 0L;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public IJavaElement getJavaElement() {
        block22: {
            if (!this.isTypeVariable() || this.typeSymbol == null) break block22;
            var3_1 = this.typeSymbol.owner;
            if (!(var3_1 instanceof Symbol.ClassSymbol)) ** GOTO lbl-1000
            ownerSymbol = (Symbol.ClassSymbol)var3_1;
            if (ownerSymbol.type != null) {
                var4_3 = this.resolver.bindings.getTypeBinding(ownerSymbol.type).getJavaElement();
                if (var4_3 instanceof IType && (ownerType = (IType)var4_3).getTypeParameter(this.getName()) != null) {
                    return ownerType.getTypeParameter(this.getName());
                }
            } else if ((ownerType = this.typeSymbol.owner) instanceof Symbol.MethodSymbol) {
                ownerSymbol /* !! */  = (Symbol.MethodSymbol)ownerType;
                if (ownerSymbol /* !! */ .type != null && (var5_5 = (mb = this.resolver.bindings.getMethodBinding(ownerSymbol /* !! */ .type.asMethodType(), (Symbol.MethodSymbol)ownerSymbol /* !! */ , null, this.isGeneric)).getJavaElement()) instanceof IMethod && (ownerMethod = (IMethod)var5_5).getTypeParameter(this.getName()) != null) {
                    return ownerMethod.getTypeParameter(this.getName());
                }
            }
        }
        if (this.resolver.javaProject == null) {
            return null;
        }
        if (this.isArray()) {
            return this.getElementType().getJavaElement();
        }
        ownerSymbol /* !! */  = this.typeSymbol;
        if (ownerSymbol /* !! */  instanceof Symbol.ClassSymbol) {
            classSymbol = (Symbol.ClassSymbol)ownerSymbol /* !! */ ;
            if (this.isAnonymous()) {
                if (this.getDeclaringMethod() != null && (var6_7 = this.getDeclaringMethod().getJavaElement()) instanceof IMethod) {
                    method = (IMethod)var6_7;
                    return this.resolved(method.getType("", 1));
                }
                var6_7 = this.getDeclaringMember();
                if (var6_7 instanceof IBinding && (gdm = var6_7) != null && (var6_7 = gdm.getJavaElement()) instanceof IField) {
                    field = (IField)var6_7;
                    return this.resolved(field.getType("", 1));
                }
                if (this.getDeclaringClass() != null && (var6_7 = this.getDeclaringClass().getJavaElement()) instanceof IType) {
                    type = (IType)var6_7;
                    return this.resolved(type.getType("", 1));
                }
            }
            if (this.typeSymbol.owner instanceof Symbol.MethodSymbol && this.getDeclaringMethod() != null && (gdm = this.getDeclaringMethod().getJavaElement()) instanceof IMethod) {
                method = (IMethod)gdm;
                return this.resolved(method.getType(this.typeSymbol.name.toString(), 1));
            }
            jfo = classSymbol == null ? null : classSymbol.sourcefile;
            typeRoot = null;
            if (jfo != null) {
                jfoFile = new File(jfo.getName());
                jfoPath = new Path(jfo.getName());
                fileStream = jfoFile.isFile() != false ? Arrays.stream(this.resolver.javaProject.getResource().getWorkspace().getRoot().findFilesForLocationURI(jfoFile.toURI())) : (jfoPath.segmentCount() > 1 ? Stream.of(this.resolver.javaProject.getResource().getWorkspace().getRoot().getFile((IPath)jfoPath)) : Stream.of(new IFile[0]));
                typeRoot = fileStream.map((Function<IFile, IJavaElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, create(org.eclipse.core.resources.IFile ), (Lorg/eclipse/core/resources/IFile;)Lorg/eclipse/jdt/core/IJavaElement;)()).filter((Predicate<IJavaElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/eclipse/jdt/core/IJavaElement;)Z)(ITypeRoot.class)).map((Function<IJavaElement, ITypeRoot>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Lorg/eclipse/jdt/core/IJavaElement;)Lorg/eclipse/jdt/core/ITypeRoot;)(ITypeRoot.class)).findAny().orElse(null);
            }
            candidate = null;
            if (typeRoot instanceof ICompilationUnit) {
                tmp = (ICompilationUnit)typeRoot;
                wc = tmp.findWorkingCopy(this.resolver.getWorkingCopyOwner());
                if (wc != null) {
                    tmp = wc;
                }
                if ((cleaned = JavacTypeBinding.cleanedUpName(this.type).split("\\$")).length > 0) {
                    cleaned[0] = cleaned[0].substring(cleaned[0].lastIndexOf(46) + 1);
                }
                done = false;
                for (i = 0; i < cleaned.length && !done; done |= candidate == null, ++i) {
                    candidate = candidate == null ? tmp.getType(cleaned[i]) : candidate.getType(cleaned[i]);
                }
                if (candidate != null && candidate.exists()) {
                    return this.resolved(candidate);
                }
            }
            try {
                ret = this.resolver.javaProject.findType(JavacTypeBinding.cleanedUpName(this.type), this.resolver.getWorkingCopyOwner(), (IProgressMonitor)new NullProgressMonitor());
                if (ret != null) {
                    return this.resolved(ret);
                }
            }
            catch (JavaModelException ex) {
                ILog.get().error(ex.getMessage(), (Throwable)ex);
            }
            return this.resolved(candidate);
        }
        return null;
    }

    private IType resolved(IType type) {
        if (type instanceof SourceType && !(type instanceof ResolvedSourceType)) {
            return new ResolvedSourceType((JavaElement)type.getParent(), type.getElementName(), this.getKey(), type.getOccurrenceCount());
        }
        if (type instanceof BinaryType && !(type instanceof ResolvedBinaryType)) {
            return new ResolvedBinaryType((JavaElement)type.getParent(), type.getElementName(), this.getKey(), type.getOccurrenceCount());
        }
        return type;
    }

    private static String cleanedUpName(Type type) {
        Type.ClassType classType;
        AnnoConstruct annoConstruct;
        if (type instanceof Type.ClassType && (annoConstruct = (classType = (Type.ClassType)type).getEnclosingType()) instanceof Type.ClassType) {
            Type.ClassType enclosing = (Type.ClassType)annoConstruct;
            return JavacTypeBinding.cleanedUpName(enclosing) + "$" + ((Name)type.tsym.getSimpleName()).toString();
        }
        annoConstruct = type.tsym;
        if (annoConstruct instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)annoConstruct;
            annoConstruct = type.tsym.owner;
            if (annoConstruct instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol enclosingSymbol = (Symbol.ClassSymbol)annoConstruct;
                return enclosingSymbol.getQualifiedName().toString() + "$" + classSymbol.getSimpleName().toString();
            }
        }
        return type.tsym.getQualifiedName().toString();
    }

    public String getKey() {
        if (this.isGenericType()) {
            return JavacTypeBinding.removeTrailingSemicolon(this.getKey(false)) + "<" + Arrays.stream(this.getTypeParameters()).map(ITypeBinding::getName).map(name -> "T" + name + ";").collect(Collectors.joining()) + ">;";
        }
        if (this.isParameterizedType()) {
            return JavacTypeBinding.removeTrailingSemicolon(this.getKey(false)) + "<" + Arrays.stream(this.getTypeArguments()).map(IBinding::getKey).collect(Collectors.joining()) + ">;";
        }
        return this.getKey(this.type, this.typeSymbol.flatName());
    }

    private static String removeTrailingSemicolon(String key) {
        return key.endsWith(";") ? key.substring(0, key.length() - 1) : key;
    }

    private String getKey(Type t) {
        return this.getKey(t, this.typeSymbol.flatName());
    }

    public String getKey(boolean includeTypeParameters) {
        return this.getKey(this.type, this.typeSymbol.flatName(), includeTypeParameters);
    }

    public String getKey(Type t, Name n) {
        return this.getKey(this.type, n, true);
    }

    public String getKey(Type t, Name n, boolean includeTypeParameters) {
        try {
            StringBuilder builder = new StringBuilder();
            JavacTypeBinding.getKey(builder, t, n, false, includeTypeParameters, this.resolver);
            return builder.toString();
        }
        catch (JavacBindingResolver.BindingKeyException bke) {
            return null;
        }
    }

    static void getKey(StringBuilder builder, Type typeToBuild, boolean isLeaf, JavacBindingResolver resolver) throws JavacBindingResolver.BindingKeyException {
        JavacTypeBinding.getKey(builder, typeToBuild, typeToBuild.asElement().flatName(), isLeaf, false, resolver);
    }

    static void getKey(StringBuilder builder, Type typeToBuild, boolean isLeaf, boolean includeParameters, JavacBindingResolver resolver) throws JavacBindingResolver.BindingKeyException {
        JavacTypeBinding.getKey(builder, typeToBuild, typeToBuild.asElement().flatName(), isLeaf, includeParameters, resolver);
    }

    static void getKey(StringBuilder builder, Type typeToBuild, Name n, boolean isLeaf, boolean includeParameters, JavacBindingResolver resolver) throws JavacBindingResolver.BindingKeyException {
        if (typeToBuild instanceof Type.JCNoType) {
            return;
        }
        if (typeToBuild instanceof Type.CapturedType) {
            Type.CapturedType capturedType = (Type.CapturedType)typeToBuild;
            builder.append('!');
            JavacTypeBinding.getKey(builder, capturedType.wildcard, false, includeParameters, resolver);
            builder.append(((long)capturedType.hashCode() & 0xFFFFFFFFL) % 997L);
            builder.append(';');
            return;
        }
        if (typeToBuild.hasTag(TypeTag.UNKNOWN)) {
            builder.append('*');
            return;
        }
        if (typeToBuild instanceof Type.ArrayType) {
            Type.ArrayType arrayType = (Type.ArrayType)typeToBuild;
            builder.append('[');
            JavacTypeBinding.getKey(builder, arrayType.elemtype, isLeaf, includeParameters, resolver);
            return;
        }
        if (typeToBuild instanceof Type.WildcardType) {
            Type.WildcardType wildcardType = (Type.WildcardType)typeToBuild;
            if (wildcardType.isUnbound()) {
                builder.append('*');
            } else if (wildcardType.isExtendsBound()) {
                builder.append('+');
                JavacTypeBinding.getKey(builder, wildcardType.getExtendsBound(), isLeaf, includeParameters, resolver);
            } else if (wildcardType.isSuperBound()) {
                builder.append('-');
                JavacTypeBinding.getKey(builder, wildcardType.getSuperBound(), isLeaf, includeParameters, resolver);
            }
            return;
        }
        if (typeToBuild.isReference()) {
            if (!isLeaf) {
                if (typeToBuild.tsym instanceof Symbol.TypeVariableSymbol) {
                    builder.append('T');
                } else {
                    builder.append('L');
                }
            }
            builder.append(n.toString().replace('.', '/'));
            Symbol.TypeSymbol typeSymbol = typeToBuild.tsym;
            if (typeSymbol instanceof Symbol.ClassSymbol) {
                JavaFileObject sourcefile;
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)typeSymbol;
                if (!(classSymbol.type instanceof Type.ErrorType) && classSymbol.owner instanceof Symbol.PackageSymbol && (sourcefile = classSymbol.sourcefile) != null && sourcefile.getKind() == JavaFileObject.Kind.SOURCE) {
                    URI uri = sourcefile.toUri();
                    String fileName = null;
                    try {
                        fileName = Paths.get(uri).getFileName().toString();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (fileName != null && !fileName.startsWith(classSymbol.getSimpleName().toString())) {
                        int simpleNameIndex = builder.lastIndexOf(classSymbol.getSimpleName().toString());
                        builder.insert(simpleNameIndex, fileName.substring(0, fileName.indexOf(".java")) + "~");
                    }
                }
            }
            boolean b1 = typeToBuild.isParameterized();
            boolean b2 = false;
            try {
                b2 = typeToBuild.tsym != null && typeToBuild.tsym.type != null && typeToBuild.tsym.type.isParameterized();
            }
            catch (Symbol.CompletionFailure cf1) {
                throw new JavacBindingResolver.BindingKeyException(cf1);
            }
            if ((b1 || b2) && includeParameters) {
                builder.append('<');
                for (Type typeArgument : typeToBuild.getTypeArguments()) {
                    JavacTypeBinding.getKey(builder, typeArgument, false, includeParameters, resolver);
                }
                builder.append('>');
            }
            if (!isLeaf) {
                builder.append(';');
            }
            return;
        }
        if (typeToBuild.isPrimitiveOrVoid()) {
            switch (typeToBuild.getKind()) {
                case BYTE: {
                    builder.append('B');
                    return;
                }
                case CHAR: {
                    builder.append('C');
                    return;
                }
                case DOUBLE: {
                    builder.append('D');
                    return;
                }
                case FLOAT: {
                    builder.append('F');
                    return;
                }
                case INT: {
                    builder.append('I');
                    return;
                }
                case LONG: {
                    builder.append('J');
                    return;
                }
                case SHORT: {
                    builder.append('S');
                    return;
                }
                case BOOLEAN: {
                    builder.append('Z');
                    return;
                }
                case VOID: {
                    builder.append('V');
                    return;
                }
            }
        }
        if (typeToBuild.isNullOrReference()) {
            return;
        }
        throw new UnsupportedOperationException("Unimplemented method 'getKey'");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEqualTo(IBinding binding) {
        if (!(binding instanceof ITypeBinding)) return false;
        ITypeBinding other = (ITypeBinding)binding;
        if (!Objects.equals(this.getKey(), other.getKey())) return false;
        return true;
    }

    public ITypeBinding createArrayType(int dimension) {
        if (this.type instanceof Type.JCVoidType) {
            return null;
        }
        Type type = this.type;
        for (int i = 0; i < dimension; ++i) {
            type = this.types.makeArrayType(type);
        }
        return this.resolver.bindings.getTypeBinding(type);
    }

    public String getBinaryName() {
        if (this.type.isPrimitive()) {
            final StringBuilder res = new StringBuilder();
            Types.SignatureGenerator generator = new Types.SignatureGenerator(this, this.types){

                @Override
                protected void append(char ch) {
                    res.append(ch);
                }

                @Override
                protected void append(byte[] ba) {
                    res.append(new String(ba));
                }

                @Override
                protected void append(Name name) {
                    res.append(name.toString());
                }
            };
            generator.assembleSig(this.type);
            return res.toString();
        }
        return this.typeSymbol.flatName().toString();
    }

    public ITypeBinding getBound() {
        Type.WildcardType wildcardType;
        Type type = this.type;
        if (type instanceof Type.WildcardType && !(wildcardType = (Type.WildcardType)type).isUnbound()) {
            Type bound = wildcardType.getExtendsBound();
            if (bound == null) {
                bound = wildcardType.getSuperBound();
            }
            if (bound != null) {
                return this.resolver.bindings.getTypeBinding(bound);
            }
            ITypeBinding[] boundsArray = this.getTypeBounds();
            if (boundsArray.length == 1) {
                return boundsArray[0];
            }
        }
        return null;
    }

    public ITypeBinding getGenericTypeOfWildcardType() {
        if (!this.isWildcardType()) {
            return null;
        }
        Type type = this.typeSymbol.type;
        if (type instanceof Type.WildcardType) {
            Type.WildcardType wildcardType = (Type.WildcardType)type;
            return (ITypeBinding)this.resolver.bindings.getBinding(wildcardType.type.tsym, wildcardType.type);
        }
        throw new IllegalStateException("Binding is a wildcard, but type cast failed");
    }

    public int getRank() {
        if (this.isWildcardType() || this.isIntersectionType()) {
            return this.types.rank(this.type);
        }
        return -1;
    }

    public ITypeBinding getComponentType() {
        Type type = this.type;
        if (type instanceof Type.ArrayType) {
            Type.ArrayType arrayType = (Type.ArrayType)type;
            return this.resolver.bindings.getTypeBinding(arrayType.elemtype);
        }
        return null;
    }

    public IVariableBinding[] getDeclaredFields() {
        if (this.typeSymbol.members() == null) {
            return new IVariableBinding[0];
        }
        return (IVariableBinding[])StreamSupport.stream(this.typeSymbol.members().getSymbols().spliterator(), false).filter(Symbol.VarSymbol.class::isInstance).map(Symbol.VarSymbol.class::cast).map(this.resolver.bindings::getVariableBinding).toArray(IVariableBinding[]::new);
    }

    public IMethodBinding[] getDeclaredMethods() {
        IMethodBinding[] ret;
        if (this.typeSymbol.members() == null) {
            return new IMethodBinding[0];
        }
        ArrayList<Symbol> l = new ArrayList<Symbol>();
        this.typeSymbol.members().getSymbols().forEach(l::add);
        Collections.reverse(l);
        if (this.isRecord() && (ret = this.getDeclaredMethodsForRecords(l)) != null) {
            return ret;
        }
        return this.getDeclaredMethodsDefaultImpl(l);
    }

    private IMethodBinding[] getDeclaredMethodsDefaultImpl(ArrayList<Symbol> l) {
        return (IMethodBinding[])StreamSupport.stream(l.spliterator(), false).filter(Symbol.MethodSymbol.class::isInstance).map(Symbol.MethodSymbol.class::cast).map(sym -> {
            Type.MethodType methodType = this.types.memberType(this.type, (Symbol)sym).asMethodType();
            return this.resolver.bindings.getMethodBinding(methodType, (Symbol.MethodSymbol)sym, this.type, this.isGeneric);
        }).filter(Objects::nonNull).sorted(Comparator.comparing(IMethodBinding::getName)).toArray(IMethodBinding[]::new);
    }

    private IMethodBinding[] getDeclaredMethodsForRecords(ArrayList<Symbol> l) {
        boolean isRecord;
        ASTNode node = this.resolver.symbolToDeclaration.get(this.typeSymbol);
        boolean bl = isRecord = this.isRecord() && node instanceof RecordDeclaration;
        if (!isRecord) {
            return null;
        }
        RecordDeclaration rd = (RecordDeclaration)node;
        java.util.List bodies = rd.bodyDeclarations();
        java.util.List explicitMethods = bodies.stream().filter(MethodDeclaration.class::isInstance).map(MethodDeclaration.class::cast).filter(Objects::nonNull).map(x -> x.getName().toString()).map(String.class::cast).collect(Collectors.toList());
        explicitMethods.add("<init>");
        return (IMethodBinding[])StreamSupport.stream(l.spliterator(), false).filter(Symbol.MethodSymbol.class::isInstance).map(Symbol.MethodSymbol.class::cast).map(sym -> {
            String symName = sym.name.toString();
            boolean isSynthetic = !explicitMethods.contains(symName);
            Type.MethodType methodType = this.types.memberType(this.type, (Symbol)sym).asMethodType();
            return this.resolver.bindings.getMethodBinding(methodType, (Symbol.MethodSymbol)sym, this.type, isSynthetic);
        }).filter(Objects::nonNull).toArray(IMethodBinding[]::new);
    }

    public int getDeclaredModifiers() {
        int n;
        ASTNode aSTNode = this.resolver.findNode(this.typeSymbol);
        if (aSTNode instanceof TypeDeclaration) {
            TypeDeclaration typeDecl = (TypeDeclaration)aSTNode;
            n = typeDecl.getModifiers();
        } else {
            n = 0;
        }
        return n;
    }

    public ITypeBinding[] getDeclaredTypes() {
        Scope.WriteableScope members = this.typeSymbol.members();
        if (members == null) {
            return new ITypeBinding[0];
        }
        return (ITypeBinding[])StreamSupport.stream(members.getSymbols().spliterator(), false).filter(Symbol.TypeSymbol.class::isInstance).map(Symbol.TypeSymbol.class::cast).map(sym -> this.resolver.bindings.getTypeBinding(sym.type)).toArray(ITypeBinding[]::new);
    }

    public ITypeBinding getDeclaringClass() {
        Symbol parentSymbol = this.typeSymbol.owner;
        do {
            if (!(parentSymbol instanceof Symbol.ClassSymbol)) continue;
            Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)parentSymbol;
            return this.resolver.bindings.getTypeBinding(clazz.type, true);
        } while ((parentSymbol = parentSymbol.owner) != null);
        return null;
    }

    public IMethodBinding getDeclaringMethod() {
        Symbol parentSymbol = this.typeSymbol.owner;
        do {
            if (!(parentSymbol instanceof Symbol.MethodSymbol)) continue;
            Symbol.MethodSymbol method = (Symbol.MethodSymbol)parentSymbol;
            Type type = method.type;
            if (type instanceof Type.MethodType) {
                Type.MethodType methodType = (Type.MethodType)type;
                return this.resolver.bindings.getMethodBinding(methodType, method, null, true);
            }
            Type type2 = method.type;
            if (type2 instanceof Type.ForAll) {
                Type.ForAll faType = (Type.ForAll)type2;
                type2 = faType.qtype;
                if (type2 instanceof Type.MethodType) {
                    Type.MethodType mtt = (Type.MethodType)type2;
                    JavacMethodBinding found = this.resolver.bindings.getMethodBinding(mtt, method, null, true);
                    return found;
                }
            }
            return null;
        } while ((parentSymbol = parentSymbol.owner) != null);
        return null;
    }

    public IBinding getDeclaringMember() {
        if (!this.isLocal()) {
            return null;
        }
        return this.resolver.bindings.getBinding(this.typeSymbol.owner, this.typeSymbol.owner.type);
    }

    public int getDimensions() {
        return this.types.dimensions(this.type);
    }

    public ITypeBinding getElementType() {
        Type t = this.types.elemtype(this.type);
        while (t instanceof Type.ArrayType) {
            t = this.types.elemtype(t);
        }
        if (t == null) {
            return null;
        }
        return this.resolver.bindings.getTypeBinding(t);
    }

    public ITypeBinding getErasure() {
        if (this.isParameterizedType()) {
            return this.resolver.bindings.getTypeBinding(this.type, true);
        }
        if (this.isRawType() && this.typeSymbol.type.isParameterized()) {
            return this.resolver.bindings.getTypeBinding(this.typeSymbol.type, true);
        }
        return this.resolver.bindings.getTypeBinding(this.types.erasureRecursive(this.type));
    }

    public IMethodBinding getFunctionalInterfaceMethod() {
        if (this.typeSymbol == null) {
            return null;
        }
        try {
            Symbol.MethodSymbol methodSymbol;
            Type.MethodType res;
            Symbol symbol = this.types.findDescriptorSymbol(this.typeSymbol);
            if (symbol instanceof Symbol.MethodSymbol && (res = this.types.memberType(this.type, methodSymbol = (Symbol.MethodSymbol)symbol).asMethodType()) != null) {
                return this.resolver.bindings.getMethodBinding(res, methodSymbol, this.type, false);
            }
        }
        catch (Types.FunctionDescriptorLookupError functionDescriptorLookupError) {
            // empty catch block
        }
        return null;
    }

    public ITypeBinding[] getInterfaces() {
        return (ITypeBinding[])this.types.interfaces(this.type).stream().map(this.resolver.bindings::getTypeBinding).toArray(ITypeBinding[]::new);
    }

    public int getModifiers() {
        int modifiers = JavacMethodBinding.toInt(this.typeSymbol.getModifiers());
        if (this.isInterface()) {
            modifiers &= 0xFFFFFBFF;
        }
        return modifiers;
    }

    public String getName() {
        return this.getName(true);
    }

    public String getName(boolean checkParameterized) {
        ITypeBinding[] types;
        if (this.isArray()) {
            StringBuilder builder = new StringBuilder(this.getElementType().getName());
            for (int i = 0; i < this.getDimensions(); ++i) {
                builder.append("[]");
            }
            return builder.toString();
        }
        Type i = this.type;
        if (i instanceof Type.WildcardType) {
            Type.WildcardType wt = (Type.WildcardType)i;
            if (wt.type == null || this.resolver.resolveWellKnownType("java.lang.Object").equals((Object)this.resolver.bindings.getTypeBinding(wt.type))) {
                return "?";
            }
            StringBuilder builder = new StringBuilder("? ");
            if (wt.isExtendsBound()) {
                builder.append("extends ");
            } else if (wt.isSuperBound()) {
                builder.append("super ");
            }
            builder.append(this.resolver.bindings.getTypeBinding(wt.type).getName());
            return builder.toString();
        }
        StringBuilder builder = new StringBuilder(((Name)this.typeSymbol.getSimpleName()).toString());
        if (checkParameterized && this.isParameterizedType() && (types = this.getUncheckedTypeArguments(this.type, this.typeSymbol)) != null && types.length > 0) {
            builder.append("<");
            for (int z = 0; z < types.length; ++z) {
                ITypeBinding zBinding = types[z];
                if (zBinding == null) continue;
                builder.append(zBinding.getName());
                if (z == types.length - 1) continue;
                builder.append(",");
            }
            builder.append(">");
        }
        return builder.toString();
    }

    public IPackageBinding getPackage() {
        if (this.isPrimitive() || this.isArray() || this.isWildcardType() || this.isNullType() || this.isTypeVariable()) {
            return null;
        }
        return this.typeSymbol.packge() != null ? this.resolver.bindings.getPackageBinding(this.typeSymbol.packge()) : null;
    }

    public String getQualifiedName() {
        return this.getQualifiedNameImpl(this.type, this.typeSymbol, this.typeSymbol.owner, !this.isGeneric);
    }

    protected String getQualifiedNameImpl(Type type, Symbol.TypeSymbol typeSymbol, Symbol owner, boolean includeParameters) {
        if (owner instanceof Symbol.MethodSymbol) {
            return "";
        }
        if (type instanceof NullType) {
            return "null";
        }
        if (type instanceof Type.ArrayType) {
            Type.ArrayType at = (Type.ArrayType)type;
            if (type.tsym.isAnonymous()) {
                return "";
            }
            return this.resolver.bindings.getTypeBinding(at.getComponentType()).getQualifiedName() + "[]";
        }
        if (type instanceof Type.WildcardType) {
            Type.WildcardType wt = (Type.WildcardType)type;
            if (wt.type == null || this.resolver.resolveWellKnownType("java.lang.Object").equals((Object)this.resolver.bindings.getTypeBinding(wt.type))) {
                return "?";
            }
            StringBuilder builder = new StringBuilder("? ");
            if (wt.isExtendsBound()) {
                builder.append("extends ");
            } else if (wt.isSuperBound()) {
                builder.append("super ");
            }
            builder.append(this.resolver.bindings.getTypeBinding(wt.type).getQualifiedName());
            return builder.toString();
        }
        if (this.isAnonymous()) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        if (owner instanceof Symbol.RootPackageSymbol) {
            return type == null || type.tsym == null || type.tsym.name == null ? "" : type.tsym.name.toString();
        }
        if (owner instanceof Symbol.TypeSymbol) {
            Type.ClassType ct;
            Symbol.TypeSymbol tss = (Symbol.TypeSymbol)owner;
            Type parentType = type instanceof Type.ClassType && (ct = (Type.ClassType)type).getEnclosingType() != Type.noType ? ct.getEnclosingType() : tss.type;
            String parentName = this.getQualifiedNameImpl(parentType, tss, tss.owner, includeParameters);
            res.append(parentName);
            if (!"".equals(parentName)) {
                res.append(".");
            }
            res.append(typeSymbol.name.toString());
        } else {
            res.append(typeSymbol.toString());
        }
        if (includeParameters) {
            boolean isTypeDeclaration;
            ITypeBinding[] typeArguments = this.getUncheckedTypeArguments(type, typeSymbol);
            boolean bl = isTypeDeclaration = typeSymbol != null && typeSymbol.type == type;
            if (!isTypeDeclaration && typeArguments.length > 0) {
                int i;
                res.append("<");
                for (i = 0; i < typeArguments.length - 1; ++i) {
                    res.append(typeArguments[i].getQualifiedName());
                    res.append(",");
                }
                res.append(typeArguments[i].getQualifiedName());
                res.append(">");
            }
        }
        int annotationIndex = -1;
        while ((annotationIndex = res.lastIndexOf("@")) >= 0) {
            int nextSpace = res.indexOf(" ", annotationIndex);
            if (nextSpace < 0) continue;
            res.delete(annotationIndex, nextSpace + 1);
        }
        return res.toString();
    }

    public ITypeBinding getSuperclass() {
        Symbol.ClassSymbol classSymbol;
        AnnoConstruct annoConstruct;
        Type superType = this.types.supertype(this.type);
        if (superType != null && !(superType instanceof Type.JCNoType)) {
            if (this.isInterface() && superType.toString().equals("java.lang.Object")) {
                return null;
            }
            return this.resolver.bindings.getTypeBinding(superType);
        }
        String jlObject = this.typeSymbol.getQualifiedName().toString();
        if (Object.class.getName().equals(jlObject)) {
            return null;
        }
        if (this.typeSymbol instanceof Symbol.TypeVariableSymbol && (annoConstruct = this.type) instanceof Type.TypeVar) {
            Type.TypeVar tv = (Type.TypeVar)annoConstruct;
            Type t = tv.getUpperBound();
            JavacTypeBinding possible = this.resolver.bindings.getTypeBinding(t);
            if (!possible.isInterface()) {
                return possible;
            }
            if (t instanceof Type.ClassType) {
                Type.ClassType ct;
                Type.ClassType working = ct = (Type.ClassType)t;
                while (working != null) {
                    Type wt = working.supertype_field;
                    String sig = this.getKey(wt);
                    if (new String(ConstantPool.JavaLangObjectSignature).equals(sig)) {
                        return this.resolver.bindings.getTypeBinding(wt);
                    }
                    working = wt instanceof Type.ClassType ? (Type.ClassType)wt : null;
                }
            }
        }
        if ((annoConstruct = this.typeSymbol) instanceof Symbol.ClassSymbol && (classSymbol = (Symbol.ClassSymbol)annoConstruct).getSuperclass() != null && classSymbol.getSuperclass().tsym != null) {
            return this.resolver.bindings.getTypeBinding(classSymbol.getSuperclass());
        }
        return null;
    }

    public IAnnotationBinding[] getTypeAnnotations() {
        if (this.typeSymbol.hasTypeAnnotations()) {
            return new IAnnotationBinding[0];
        }
        return new IAnnotationBinding[0];
    }

    public ITypeBinding[] getTypeArguments() {
        if (!this.isParameterizedType() || this.isTargettingPreGenerics()) {
            return NO_TYPE_ARGUMENTS;
        }
        return this.getUncheckedTypeArguments(this.type, this.typeSymbol);
    }

    private ITypeBinding[] getUncheckedTypeArguments(Type t, Symbol.TypeSymbol ts) {
        return (ITypeBinding[])t.getTypeArguments().stream().map(this.resolver.bindings::getTypeBinding).toArray(ITypeBinding[]::new);
    }

    private boolean isTargettingPreGenerics() {
        if (this.resolver.javaProject == null) {
            return false;
        }
        String target = this.resolver.javaProject.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true);
        return "1.1".equals(target) || "cldc1.1".equals(target) || "1.2".equals(target) || "1.3".equals(target) || "1.4".equals(target);
    }

    public ITypeBinding[] getTypeBounds() {
        Type bounds;
        Type z1;
        Type type = this.type;
        if (type instanceof Type.ClassType) {
            Type.ClassType classType = (Type.ClassType)type;
            z1 = classType.supertype_field;
            List<Type> z2 = classType.interfaces_field;
            ArrayList<JavacTypeBinding> l = new ArrayList<JavacTypeBinding>();
            if (z1 != null) {
                l.add(this.resolver.bindings.getTypeBinding(z1));
            }
            if (z2 != null) {
                for (int i = 0; i < z2.size(); ++i) {
                    l.add(this.resolver.bindings.getTypeBinding((Type)z2.get(i)));
                }
            }
            return (ITypeBinding[])l.toArray(JavacTypeBinding[]::new);
        }
        z1 = this.type;
        if (z1 instanceof Type.TypeVar) {
            Type.TypeVar typeVar = (Type.TypeVar)z1;
            bounds = typeVar.getUpperBound();
            if (bounds instanceof Type.IntersectionClassType) {
                Type.IntersectionClassType intersectionType = (Type.IntersectionClassType)bounds;
                return (ITypeBinding[])intersectionType.getBounds().stream().filter(Type.class::isInstance).map(Type.class::cast).map(this.resolver.bindings::getTypeBinding).toArray(ITypeBinding[]::new);
            }
            return new ITypeBinding[]{this.resolver.bindings.getTypeBinding(bounds)};
        }
        bounds = this.type;
        if (bounds instanceof Type.WildcardType) {
            Type.WildcardType wildcardType = (Type.WildcardType)bounds;
            Type.TypeVar typeVar = wildcardType.bound;
            if (typeVar instanceof Type.TypeVar) {
                Type.TypeVar typeVar2 = typeVar;
                return this.resolver.bindings.getTypeVariableBinding(typeVar2).getTypeBounds();
            }
            return new ITypeBinding[]{wildcardType.isUnbound() || wildcardType.isSuperBound() ? this.resolver.resolveWellKnownType(Object.class.getName()) : this.resolver.bindings.getTypeBinding(wildcardType.bound)};
        }
        return new ITypeBinding[0];
    }

    public ITypeBinding getTypeDeclaration() {
        if (this.isParameterizedType() || this.isRawType()) {
            return this.getErasure();
        }
        return this.typeSymbol.type == this.type ? this : this.resolver.bindings.getTypeBinding(this.typeSymbol.type, true);
    }

    public ITypeBinding[] getTypeParameters() {
        if (!this.isGenericType() || this.isTargettingPreGenerics()) {
            return new ITypeBinding[0];
        }
        return (ITypeBinding[])((List)((Type.ClassType)this.type).getTypeArguments()).map(this.resolver.bindings::getTypeBinding).toArray(ITypeBinding[]::new);
    }

    public ITypeBinding getWildcard() {
        Type type = this.type;
        if (type instanceof Type.CapturedType) {
            Type.CapturedType capturedType = (Type.CapturedType)type;
            return this.resolver.bindings.getTypeBinding(capturedType.wildcard);
        }
        return null;
    }

    public boolean isAnnotation() {
        return this.typeSymbol.isAnnotationType();
    }

    public boolean isAnonymous() {
        return this.typeSymbol.isAnonymous();
    }

    public boolean isArray() {
        return this.type instanceof Type.ArrayType;
    }

    public boolean isAssignmentCompatible(ITypeBinding variableType) {
        if (variableType instanceof JavacTypeBinding) {
            JavacTypeBinding other = (JavacTypeBinding)variableType;
            return this.types.isAssignable(this.type, other.type);
        }
        throw new UnsupportedOperationException("Cannot mix with non Javac binding");
    }

    public boolean isCapture() {
        return this.type instanceof Type.CapturedType;
    }

    public boolean isCastCompatible(ITypeBinding type) {
        if (type instanceof JavacTypeBinding) {
            JavacTypeBinding other = (JavacTypeBinding)type;
            return this.types.isCastable(other.type, this.type);
        }
        throw new UnsupportedOperationException("Cannot mix with non Javac binding");
    }

    public boolean isClass() {
        Symbol.ClassSymbol classSymbol;
        Symbol.TypeSymbol typeSymbol = this.typeSymbol;
        return typeSymbol instanceof Symbol.ClassSymbol && !(classSymbol = (Symbol.ClassSymbol)typeSymbol).isEnum() && !classSymbol.isInterface();
    }

    public boolean isEnum() {
        return this.typeSymbol.isEnum();
    }

    public boolean isRecord() {
        Symbol.ClassSymbol classSymbol;
        Symbol.TypeSymbol typeSymbol = this.typeSymbol;
        return typeSymbol instanceof Symbol.ClassSymbol && (classSymbol = (Symbol.ClassSymbol)typeSymbol).isRecord();
    }

    public boolean isFromSource() {
        return this.resolver.findDeclaringNode((IBinding)this) != null || this.getJavaElement() instanceof SourceType || this.getDeclaringClass() != null && this.getDeclaringClass().isFromSource() || this.isCapture();
    }

    public boolean isGenericType() {
        return !this.isRawType() && this.type.isParameterized() && this.isGeneric;
    }

    public boolean isInterface() {
        return this.typeSymbol.isInterface();
    }

    public boolean isIntersectionType() {
        return this.type.isIntersection();
    }

    public boolean isLocal() {
        ASTNode aSTNode = this.resolver.findDeclaringNode((IBinding)this);
        if (aSTNode instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration node = (AbstractTypeDeclaration)aSTNode;
            return !(node.getParent() instanceof CompilationUnit) && !(node.getParent() instanceof AbstractTypeDeclaration) && !(node.getParent() instanceof AnonymousClassDeclaration);
        }
        return this.typeSymbol.owner.kind.matches(Kinds.KindSelector.VAL_MTH);
    }

    public boolean isMember() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            return this.typeSymbol.owner instanceof Symbol.ClassSymbol;
        }
        return false;
    }

    public boolean isNested() {
        if (this.isTypeVariable()) {
            return false;
        }
        return this.getDeclaringClass() != null;
    }

    public boolean isNullType() {
        Type.ErrorType et;
        Type type;
        return this.type instanceof NullType || (type = this.type) instanceof Type.ErrorType && (et = (Type.ErrorType)type).getOriginalType() instanceof NullType;
    }

    public boolean isParameterizedType() {
        return this.type.isParameterized() && !this.isGeneric;
    }

    public boolean isPrimitive() {
        return this.type.isPrimitiveOrVoid();
    }

    public boolean isRawType() {
        return this.type.isRaw();
    }

    public boolean isSubTypeCompatible(ITypeBinding type) {
        if (this == type) {
            return true;
        }
        if (type instanceof JavacTypeBinding) {
            JavacTypeBinding other = (JavacTypeBinding)type;
            return this.types.isSubtype(this.type, other.type);
        }
        return false;
    }

    public boolean isTopLevel() {
        return this.getDeclaringClass() == null;
    }

    public boolean isTypeVariable() {
        return this.type instanceof Type.TypeVar;
    }

    public boolean isUpperbound() {
        return this.type.isExtendsBound();
    }

    public boolean isWildcardType() {
        return this.type instanceof Type.WildcardType;
    }

    public IModuleBinding getModule() {
        Symbol o = this.type.tsym.owner;
        if (o instanceof Symbol.PackageSymbol) {
            Symbol.PackageSymbol ps = (Symbol.PackageSymbol)o;
            return this.resolver.bindings.getModuleBinding(ps.modle);
        }
        return null;
    }

    public void setRecovered(boolean recovered) {
        this.recovered = recovered;
    }

    public String toString() {
        return Arrays.stream(this.getAnnotations()).map(Object::toString).map(ann -> ann + " ").collect(Collectors.joining()) + this.getQualifiedName();
    }
}

