/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.handlers;

import com.microsoft.gradle.compile.CompletionVisitor;
import com.microsoft.gradle.utils.CompletionUtils;
import com.microsoft.gradle.utils.LSPUtils;
import com.microsoft.gradle.utils.Utils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class MavenLocalCompletionHandler {
    private static String sequence = "1";
    private List<String> sortedGroupIds;
    private Map<String, List<String>> localRepository = new HashMap<String, List<String>>();

    public MavenLocalCompletionHandler() {
        Path localRepositoryPath = Paths.get(System.getProperty("user.home"), ".m2", "repository");
        List<File> pomFiles = Utils.listAllFiles(localRepositoryPath.toFile(), "pom");
        HashSet<String> groupIds = new HashSet<String>();
        HashMap repository = new HashMap();
        for (File file : pomFiles) {
            Path path = file.toPath();
            Path relativePath = localRepositoryPath.relativize(path);
            int nameCount = relativePath.getNameCount();
            if (nameCount < 4) continue;
            String artifactId = relativePath.getName(nameCount - 3).toString();
            ArrayList groupIdParts = new ArrayList();
            relativePath.subpath(0, nameCount - 3).iterator().forEachRemaining(e -> groupIdParts.add(e.toString()));
            String groupId = String.join((CharSequence)".", groupIdParts);
            groupIds.add(groupId);
            if (repository.containsKey(groupId)) {
                ((Set)repository.get(groupId)).add(artifactId);
                continue;
            }
            HashSet<String> artifactIds = new HashSet<String>();
            artifactIds.add(artifactId);
            repository.put(groupId, artifactIds);
        }
        this.sortedGroupIds = new ArrayList<String>(groupIds);
        Collections.sort(this.sortedGroupIds);
        for (Map.Entry entry : repository.entrySet()) {
            List values = ((Set)entry.getValue()).stream().collect(Collectors.toList());
            Collections.sort(values);
            this.localRepository.put((String)entry.getKey(), values);
        }
    }

    public List<CompletionItem> getDependencyCompletionItems(CompletionVisitor.DependencyItem dependency, Position position) {
        Range range = new Range(dependency.getRange().getStart(), position);
        String validText = LSPUtils.getStringBeforePosition(dependency.getText(), dependency.getRange(), position);
        String[] validTexts = validText.split(":", -1);
        switch (validTexts.length) {
            case 1: {
                return this.getGroupIdCompletions(validTexts[0], range);
            }
            case 2: {
                return this.getArtifactIdCompletions(validTexts[0], validTexts[1], range);
            }
        }
        return Collections.emptyList();
    }

    private List<CompletionItem> getGroupIdCompletions(String text, Range range) {
        return CompletionUtils.getGroupIdCompletions(text, range, this.sortedGroupIds, sequence);
    }

    private List<CompletionItem> getArtifactIdCompletions(String groupId, String text, Range range) {
        if (!this.localRepository.containsKey(groupId)) {
            return Collections.emptyList();
        }
        return CompletionUtils.getArtifactIdCompletions(groupId, text, range, (Collection<String>)this.localRepository.get(groupId), sequence);
    }
}

