/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.util.StringMatcher;

public class ParameterGuesser {
    private final Set<String> fAlreadyMatchedNames;
    private final IJavaElement fEnclosingElement;

    public ParameterGuesser(IJavaElement enclosingElement) {
        this.fEnclosingElement = enclosingElement;
        this.fAlreadyMatchedNames = new HashSet<String>();
    }

    private List<Variable> evaluateVisibleMatches(String expectedType, IJavaElement[] suggestions) throws JavaModelException {
        PrimitiveType.Code primitiveTypeCode;
        String fullyQualifiedName;
        IMethod method;
        IJavaElement iJavaElement;
        IType currentType = null;
        if (this.fEnclosingElement != null) {
            currentType = (IType)this.fEnclosingElement.getAncestor(7);
        }
        ArrayList<Variable> res = new ArrayList<Variable>();
        int i = 0;
        while (i < suggestions.length) {
            Variable variable = this.createVariable(suggestions[i], currentType, expectedType, i);
            if (variable != null) {
                if (this.fAlreadyMatchedNames.contains(variable.name)) {
                    variable.alreadyMatched = true;
                }
                res.add(variable);
            }
            ++i;
        }
        if (!(currentType == null || (iJavaElement = this.fEnclosingElement) instanceof IMethod && Flags.isStatic((int)(method = (IMethod)iJavaElement).getFlags()) || !(fullyQualifiedName = currentType.getFullyQualifiedName('.')).equals(expectedType))) {
            res.add(new Variable(fullyQualifiedName, "this", 5, false, res.size()));
        }
        if ((primitiveTypeCode = this.getPrimitiveTypeCode(expectedType)) == null) {
            res.add(new Variable(expectedType, "null", 5, false, res.size()));
        } else {
            boolean isAutoboxing;
            String typeName = primitiveTypeCode.toString();
            boolean bl = isAutoboxing = !typeName.equals(expectedType);
            if (primitiveTypeCode == PrimitiveType.BOOLEAN) {
                res.add(new Variable(typeName, "true", 5, isAutoboxing, res.size()));
                res.add(new Variable(typeName, "false", 5, isAutoboxing, res.size()));
            } else {
                res.add(new Variable(typeName, "0", 5, isAutoboxing, res.size()));
            }
        }
        return res;
    }

    public Variable createVariable(IJavaElement element, IType enclosingType, String expectedType, int positionScore) throws JavaModelException {
        String typeSignature;
        int variableType;
        int elementType = element.getElementType();
        Object elementName = element.getElementName();
        switch (elementType) {
            case 8: {
                IField field = (IField)element;
                variableType = field.getDeclaringType().equals(enclosingType) ? 1 : 2;
                if (field.isResolved()) {
                    typeSignature = new BindingKey(field.getKey()).toSignature();
                    break;
                }
                typeSignature = field.getTypeSignature();
                break;
            }
            case 14: {
                ILocalVariable locVar = (ILocalVariable)element;
                variableType = 0;
                typeSignature = locVar.getTypeSignature();
                break;
            }
            case 9: {
                IMethod method = (IMethod)element;
                if (this.isMethodToSuggest(method)) {
                    variableType = method.getDeclaringType().equals(enclosingType) ? 3 : 4;
                    typeSignature = method.isResolved() ? Signature.getReturnType((String)new BindingKey(method.getKey()).toSignature()) : method.getReturnType();
                    elementName = (String)elementName + "()";
                    break;
                }
                return null;
            }
            default: {
                return null;
            }
        }
        String type = Signature.toString((String)typeSignature);
        boolean isAutoboxMatch = this.isPrimitiveType(expectedType) ^ this.isPrimitiveType(type);
        return new Variable(type, (String)elementName, variableType, isAutoboxMatch, positionScore);
    }

    private boolean isPrimitiveType(String type) {
        return PrimitiveType.toCode((String)type) != null;
    }

    private PrimitiveType.Code getPrimitiveTypeCode(String type) {
        PrimitiveType.Code code = PrimitiveType.toCode((String)type);
        if (code != null) {
            return code;
        }
        if (this.fEnclosingElement != null && JavaModelUtil.is50OrHigher((IJavaProject)this.fEnclosingElement.getJavaProject()) && (code == PrimitiveType.SHORT ? "java.lang.Short".equals(type) : (code == PrimitiveType.INT ? "java.lang.Integer".equals(type) : (code == PrimitiveType.LONG ? "java.lang.Long".equals(type) : (code == PrimitiveType.FLOAT ? "java.lang.Float".equals(type) : (code == PrimitiveType.DOUBLE ? "java.lang.Double".equals(type) : (code == PrimitiveType.CHAR ? "java.lang.Character".equals(type) : code == PrimitiveType.BYTE && "java.lang.Byte".equals(type)))))))) {
            return code;
        }
        return null;
    }

    private boolean isMethodToSuggest(IMethod method) {
        try {
            String methodName = method.getElementName();
            return method.getNumberOfParameters() == 0 && !"V".equals(method.getReturnType()) && (methodName.startsWith("get") || methodName.startsWith("is"));
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    public String parameterProposals(String expectedType, String paramName, IJavaElement[] suggestions) throws JavaModelException {
        List<Variable> typeMatches = this.evaluateVisibleMatches(expectedType, suggestions);
        ParameterGuesser.orderMatches(typeMatches, paramName);
        String[] ret = new String[typeMatches.size()];
        if (typeMatches.size() > 0) {
            int i = 0;
            for (Variable v : typeMatches) {
                if (i == 0) {
                    this.fAlreadyMatchedNames.add(v.name);
                }
                ret[i++] = v.name;
            }
            return ret[0];
        }
        return null;
    }

    private static void orderMatches(List<Variable> typeMatches, String paramName) {
        if (typeMatches != null) {
            Collections.sort(typeMatches, new MatchComparator(paramName));
        }
    }

    private static String getLongestCommonSubstring(String first, String second) {
        String shorter = first.length() <= second.length() ? first : second;
        String longer = shorter == first ? second : first;
        int minLength = shorter.length();
        StringBuilder pattern = new StringBuilder(shorter.length() + 2);
        String longestCommonSubstring = "";
        int i = 0;
        while (i < minLength) {
            int j = i + 1;
            while (j <= minLength) {
                if (j - i >= longestCommonSubstring.length()) {
                    String substring = shorter.substring(i, j);
                    pattern.setLength(0);
                    pattern.append('*');
                    pattern.append(substring);
                    pattern.append('*');
                    StringMatcher matcher = new StringMatcher(pattern.toString(), true, false);
                    if (matcher.match(longer)) {
                        longestCommonSubstring = substring;
                    }
                }
                ++j;
            }
            ++i;
        }
        return longestCommonSubstring;
    }

    private static class MatchComparator
    implements Comparator<Variable> {
        private String fParamName;

        MatchComparator(String paramName) {
            this.fParamName = paramName;
        }

        @Override
        public int compare(Variable one, Variable two) {
            return this.score(two) - this.score(one);
        }

        private int score(Variable v) {
            int shorter;
            int variableScore = 100 - v.variableType;
            int subStringScore = ParameterGuesser.getLongestCommonSubstring(v.name, this.fParamName).length();
            if ((double)subStringScore < 0.6 * (double)(shorter = Math.min(v.name.length(), this.fParamName.length()))) {
                subStringScore = 0;
            }
            int positionScore = v.positionScore;
            int matchedScore = v.alreadyMatched ? 0 : 1;
            int autoboxingScore = v.isAutoboxingMatch ? 0 : 1;
            int score = autoboxingScore << 30 | variableScore << 21 | subStringScore << 11 | matchedScore << 10 | positionScore;
            return score;
        }
    }

    private static final class Variable {
        public static final int LOCAL = 0;
        public static final int FIELD = 1;
        public static final int INHERITED_FIELD = 2;
        public static final int METHOD = 3;
        public static final int INHERITED_METHOD = 4;
        public static final int LITERALS = 5;
        public final String qualifiedTypeName;
        public final String name;
        public final int variableType;
        public final int positionScore;
        public final boolean isAutoboxingMatch;
        public boolean alreadyMatched;

        public Variable(String qualifiedTypeName, String name, int variableType, boolean isAutoboxMatch, int positionScore) {
            this.qualifiedTypeName = qualifiedTypeName;
            this.name = name;
            this.variableType = variableType;
            this.positionScore = positionScore;
            this.isAutoboxingMatch = isAutoboxMatch;
            this.alreadyMatched = false;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.qualifiedTypeName);
            buffer.append(' ');
            buffer.append(this.name);
            buffer.append(" (");
            buffer.append(this.variableType);
            buffer.append(')');
            return buffer.toString();
        }
    }
}

