/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.runner.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.microsoft.java.test.runner.common.Pair;
import com.microsoft.java.test.runner.common.TestMessageItem;
import com.microsoft.java.test.runner.common.TestStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Type;

public class TestOutputStream
implements TestStream {
    private PrintWriter out;
    private static final JsonSerializer<TestMessageItem> serializer = new JsonSerializer<TestMessageItem>(){

        @Override
        public JsonElement serialize(TestMessageItem item, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonMsgItem = new JsonObject();
            jsonMsgItem.addProperty("name", item.name);
            if (item.attributes != null) {
                JsonObject jsonAttributes = new JsonObject();
                for (Pair pair : item.attributes) {
                    jsonAttributes.addProperty(pair.first, pair.second);
                }
                jsonMsgItem.add("attributes", jsonAttributes);
            }
            return jsonMsgItem;
        }
    };

    private TestOutputStream() {
    }

    public void initialize(OutputStream outputStream) {
        if (this.out == null) {
            this.out = new PrintWriter(outputStream, true);
        }
    }

    public static TestOutputStream instance() {
        return SingletonHelper.INSTANCE;
    }

    @Override
    public void println(TestMessageItem item) {
        String content = TestOutputStream.toJson(item);
        this.out.println(content);
        this.out.println();
    }

    @Override
    public void close() {
        this.out.close();
    }

    private static String toJson(TestMessageItem item) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter((Type)((Object)TestMessageItem.class), serializer);
        Gson customGson = gsonBuilder.create();
        StringBuilder builder = new StringBuilder("@@<TestRunner-");
        builder.append(customGson.toJson(item));
        builder.append("-TestRunner>");
        return builder.toString();
    }

    private static class SingletonHelper {
        private static final TestOutputStream INSTANCE = new TestOutputStream();

        private SingletonHelper() {
        }
    }
}

