/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.gradle.internal.InternalTransformer;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.serialize.TopLevelExceptionPlaceholder;

public class ExceptionReplacingObjectOutputStream
extends ObjectOutputStream {
    private InternalTransformer<Object, Object> objectTransformer = new InternalTransformer<Object, Object>(){

        @Override
        public Object transform(Object obj) {
            try {
                return ExceptionReplacingObjectOutputStream.this.doReplaceObject(obj);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
    };

    public ExceptionReplacingObjectOutputStream(OutputStream outputSteam) throws IOException {
        super(outputSteam);
        this.enableReplaceObject(true);
    }

    public final InternalTransformer<ExceptionReplacingObjectOutputStream, OutputStream> getObjectOutputStreamCreator() {
        return new InternalTransformer<ExceptionReplacingObjectOutputStream, OutputStream>(){

            @Override
            public ExceptionReplacingObjectOutputStream transform(OutputStream outputStream) {
                try {
                    return ExceptionReplacingObjectOutputStream.this.createNewInstance(outputStream);
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
        };
    }

    protected ExceptionReplacingObjectOutputStream createNewInstance(OutputStream outputStream) throws IOException {
        return new ExceptionReplacingObjectOutputStream(outputStream);
    }

    @Override
    protected final Object replaceObject(Object obj) throws IOException {
        return this.getObjectTransformer().transform(obj);
    }

    protected Object doReplaceObject(Object obj) throws IOException {
        if (obj instanceof Throwable) {
            return new TopLevelExceptionPlaceholder((Throwable)obj, this.getObjectOutputStreamCreator());
        }
        return obj;
    }

    public InternalTransformer<Object, Object> getObjectTransformer() {
        return this.objectTransformer;
    }

    public void setObjectTransformer(InternalTransformer<Object, Object> objectTransformer) {
        this.objectTransformer = objectTransformer;
    }
}

