/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.SymbolMetadata;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.file.PathFileObject;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.StreamSupport;
import javax.lang.model.element.ElementKind;
import javax.tools.JavaFileObject;
import org.eclipse.core.runtime.ILog;

public class CachingClassSymbolClassReader
extends ClassReader {
    private static Map<JavaFileObject, ClassSymbolTemplate> CACHE = Collections.synchronizedMap(new HashMap());
    private final Types localTypes;
    private final Names localNames;
    private final Symtab localSyms;
    private final StoringQueriesAnnotate localAnnotate;
    private final byte[] signatureBuffer = new byte[2000];
    private Method superSigToTypeMethod = null;

    public static void preRegister(Context context) {
        StoringQueriesAnnotate.preRegister(context);
        context.put(classReaderKey, c -> new CachingClassSymbolClassReader(c));
    }

    protected CachingClassSymbolClassReader(Context context) {
        super(context);
        this.localTypes = Types.instance(context);
        this.localNames = Names.instance(context);
        this.localSyms = Symtab.instance(context);
        this.localAnnotate = (StoringQueriesAnnotate)Annotate.instance(context);
        try {
            Field utf8ValidationField = ClassReader.class.getDeclaredField("utf8validation");
            utf8ValidationField.setAccessible(true);
            utf8ValidationField.set(this, (Object)Convert.Validation.STRICT);
            Field field = ClassReader.class.getDeclaredField("signatureBuffer");
            field.setAccessible(true);
            field.set(this, this.signatureBuffer);
            this.superSigToTypeMethod = ClassReader.class.getDeclaredMethod("sigToType", byte[].class, Integer.TYPE, Integer.TYPE);
            this.superSigToTypeMethod.setAccessible(true);
        }
        catch (Exception ex) {
            ILog.get().error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void readClassFile(Symbol.ClassSymbol c) {
        PathFileObject pathFileObject;
        JavaFileObject javaFileObject;
        if (c.classfile == null || c.classfile.getClass().getSimpleName().equals("JRTFileObject") || c.classfile.getClass().getSimpleName().endsWith("SigJavaFileObject") || (javaFileObject = c.classfile) instanceof PathFileObject && "JrtPath".equals((pathFileObject = (PathFileObject)javaFileObject).getPath().getClass().getSimpleName()) || Objects.equals(this.localNames.module_info, c.getSimpleName())) {
            super.readClassFile(c);
        } else {
            ClassSymbolTemplate template = CACHE.get(c.classfile);
            if (template == null || template.isObsolete()) {
                Instant now = Instant.now();
                super.readClassFile(c);
                CACHE.put(c.classfile, new ClassSymbolTemplate(c, now, this));
            } else {
                template.applyTo(c, this);
            }
        }
    }

    public static Symbol.ModuleSymbol findModule(Symbol target) {
        Symbol moduleSymbol = target;
        while (!(moduleSymbol instanceof Symbol.ModuleSymbol) && !(moduleSymbol instanceof Symbol.PackageSymbol) && moduleSymbol != null) {
            moduleSymbol = moduleSymbol.owner;
        }
        if (moduleSymbol instanceof Symbol.ModuleSymbol) {
            Symbol.ModuleSymbol theModuleSymbol = (Symbol.ModuleSymbol)moduleSymbol;
            return theModuleSymbol;
        }
        if (moduleSymbol instanceof Symbol.PackageSymbol) {
            Symbol.PackageSymbol packageSymbol = (Symbol.PackageSymbol)moduleSymbol;
            return packageSymbol.modle;
        }
        return null;
    }

    Type sigToType(String typeSignature) {
        if (typeSignature == null || this.superSigToTypeMethod == null) {
            return Type.noType;
        }
        try {
            byte[] bytes = typeSignature.getBytes();
            return (Type)this.superSigToTypeMethod.invoke((Object)this, bytes, 0, bytes.length);
        }
        catch (Exception ex) {
            ILog.get().error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    String typeToSig(Type type) {
        if (type == Type.noType || type.getTag() == TypeTag.ERROR) {
            return null;
        }
        final StringBuilder res = new StringBuilder();
        final boolean[] hasError = new boolean[]{false};
        Types types = this.localTypes;
        Objects.requireNonNull(types);
        var generator = new Types.SignatureGenerator(this, types){
            {
                Objects.requireNonNull(this$0);
                super(x0);
            }

            @Override
            public void assembleSig(Type type) {
                if (type.getTag() == TypeTag.ERROR) {
                    hasError[0] = true;
                    return;
                }
                super.assembleSig(type);
            }

            @Override
            protected void append(char ch) {
                res.append(ch);
            }

            @Override
            protected void append(byte[] ba) {
                res.append(new String(ba));
            }

            @Override
            protected void append(Name name) {
                res.append(name.toString());
            }

            @Override
            public boolean hasTypeVar(List<Type> l) {
                return l != null && !l.isEmpty();
            }
        };
        generator.assembleSig(type);
        return hasError[0] ? null : res.toString();
    }

    private static class StoringQueriesAnnotate
    extends Annotate {
        private final CachingClassSymbolClassReader reader;
        private final java.util.List<AnnotationCompleterWrapper> requested = new ArrayList<AnnotationCompleterWrapper>();

        public static void preRegister(Context context) {
            context.put(annotateKey, c -> new StoringQueriesAnnotate(c));
        }

        protected StoringQueriesAnnotate(Context context) {
            super(context);
            this.reader = (CachingClassSymbolClassReader)ClassReader.instance(context);
        }

        @Override
        public void normal(Runnable r) {
            super.normal(r);
            AnnotationCompleterWrapper annotationCompleter = new AnnotationCompleterWrapper(r);
            Symbol sym = annotationCompleter.annotationFor();
            if (sym != null) {
                this.requested.add(annotationCompleter);
            }
        }

        public java.util.List<CompoundTemplate> annotationsFor(Symbol sym) {
            return new ArrayList<AnnotationCompleterWrapper>(this.requested).stream().filter(annCompleter -> annCompleter.annotationFor() == sym).map(annCompleter -> annCompleter.value(this.reader)).flatMap(Collection::stream).toList();
        }

        public void normal(Symbol sym, java.util.List<CompoundTemplate> toAnnotate) {
            if (!toAnnotate.isEmpty()) {
                this.normal(() -> {
                    Symbol.ModuleSymbol previousModule = this.reader.currentModule;
                    try {
                        this.reader.currentModule = CachingClassSymbolClassReader.findModule(sym);
                        List<Attribute.Compound> newList = List.from(toAnnotate.stream().map(template -> template.create(this.reader)).toList());
                        if (sym.annotationsPendingCompletion()) {
                            sym.setDeclarationAttributes(newList);
                        } else {
                            sym.appendAttributes(newList);
                        }
                    }
                    finally {
                        this.reader.currentModule = previousModule;
                    }
                });
            }
        }
    }

    private static class ClassSymbolTemplate {
        private final Instant creationTime;
        private final long flags;
        private final String superSymbol;
        private final java.util.List<String> interfaces;
        private final java.util.List<String> permitted;
        private final java.util.List<TypeVariableTemplate> typeParams;
        private final boolean isPermittedExplicit;
        private final java.util.List<?> members;
        private final java.util.List<String> innerTypes;
        private final JavaFileObject classFile;
        private final SymbolMetadataTemplate metadata;
        private final AnnotationTypeMetadataTemplate annotationTypeMetadataTemplate;
        private java.util.List<CompoundTemplate> toAnnotate;

        public ClassSymbolTemplate(Symbol.ClassSymbol base, Instant creationTime, CachingClassSymbolClassReader reader) {
            this.creationTime = creationTime;
            this.classFile = base.classfile;
            this.flags = base.flags_field;
            this.superSymbol = reader.typeToSig(base.getSuperclass());
            this.interfaces = ((List)base.getInterfaces()).map(reader::typeToSig);
            this.permitted = ((List)base.getPermittedSubclasses()).map(reader.localTypes::erasure).map(reader::typeToSig);
            this.typeParams = ((List)base.getTypeParameters()).map(t -> new TypeVariableTemplate((Symbol.TypeVariableSymbol)t, reader));
            this.isPermittedExplicit = base.isPermittedExplicit;
            this.members = StreamSupport.stream(base.members().getSymbols().spliterator(), false).map(member -> {
                Object object;
                if (member instanceof Symbol.VarSymbol) {
                    Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)member;
                    object = new VarSymbolTemplate(varSymbol, reader);
                } else if (member instanceof Symbol.MethodSymbol) {
                    Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)member;
                    object = new MethodSymbolTemplate(methodSymbol, reader);
                } else {
                    object = null;
                }
                return object;
            }).toList();
            this.innerTypes = StreamSupport.stream(base.members().getSymbols(Symbol.ClassSymbol.class::isInstance).spliterator(), false).map(Symbol.ClassSymbol.class::cast).map(Symbol.ClassSymbol::getSimpleName).map(Name::toString).toList();
            this.metadata = new SymbolMetadataTemplate(base.getMetadata(), reader);
            this.annotationTypeMetadataTemplate = base.isAnnotationType() ? new AnnotationTypeMetadataTemplate(base.getAnnotationTypeMetadata(), reader) : null;
            this.toAnnotate = reader.localAnnotate.annotationsFor(base);
        }

        public boolean isObsolete() {
            return this.classFile.getLastModified() > this.creationTime.toEpochMilli();
        }

        public void applyTo(Symbol.ClassSymbol target, CachingClassSymbolClassReader reader) {
            if (target.classfile == null) {
                target.classfile = this.classFile;
            }
            reader.currentOwner = target;
            reader.currentClassFile = target.classfile;
            target.flags_field = this.flags;
            reader.currentModule = CachingClassSymbolClassReader.findModule(target);
            target.isPermittedExplicit = this.isPermittedExplicit;
            Type.ClassType ct = (Type.ClassType)target.type;
            target.members_field = Scope.WriteableScope.create(target);
            reader.typevars = reader.typevars.dup(reader.currentOwner);
            if (ct.getEnclosingType().hasTag(TypeTag.CLASS)) {
                reader.enterTypevars(target.owner, ct.getEnclosingType());
            }
            this.typeParams.stream().map(template -> template.create(target, reader)).forEach(reader.typevars::enter);
            this.members.stream().map(template -> this.toSymbol(template, target, reader)).filter(Symbol.class::isInstance).map(Symbol.class::cast).forEach(target.members_field::enter);
            ct.supertype_field = reader.sigToType(this.superSymbol);
            ct.interfaces_field = List.from((Type[])this.interfaces.stream().map(reader::sigToType).toArray(Type[]::new));
            ct.typarams_field = List.from((Type[])this.typeParams.stream().map(t -> t.name).map(reader.typevars::findFirst).filter(Objects::nonNull).map(s -> s.type).toArray(Type[]::new));
            target.isPermittedExplicit = this.isPermittedExplicit;
            this.permitted.stream().map(reader::sigToType).map(type -> type.tsym).filter(Symbol.ClassSymbol.class::isInstance).map(Symbol.ClassSymbol.class::cast).forEach(tsym -> target.addPermittedSubclass((Symbol.ClassSymbol)tsym, 0));
            this.metadata.applyTo(target, reader);
            if (target.isAnnotationType() && this.annotationTypeMetadataTemplate != null) {
                target.setAnnotationTypeMetadata(this.annotationTypeMetadataTemplate.create(target, reader));
            }
            for (String innerClass : this.innerTypes) {
                Symbol.ClassSymbol member = reader.enterClass(reader.localNames.fromString(innerClass), target);
                if ((this.flags & 8L) == 0L) {
                    ((Type.ClassType)member.type).setEnclosingType(target.type);
                    if (member.erasure_field != null) {
                        ((Type.ClassType)member.erasure_field).setEnclosingType(reader.localTypes.erasure(target.type));
                    }
                }
                if ((member.flags_field & 0x80001000L) == 4096L && !member.name.startsWith(reader.localNames.lambda)) continue;
                target.members().enter(member);
            }
            reader.localAnnotate.normal(target, this.toAnnotate);
            reader.typevars = reader.typevars.leave();
        }

        private Object toSymbol(Object o, Symbol owner, CachingClassSymbolClassReader reader) {
            if (o instanceof VarSymbolTemplate) {
                VarSymbolTemplate varTemplate = (VarSymbolTemplate)o;
                return varTemplate.create(owner, reader);
            }
            if (o instanceof MethodSymbolTemplate) {
                MethodSymbolTemplate methodTemplate = (MethodSymbolTemplate)o;
                if (owner instanceof Symbol.TypeSymbol) {
                    Symbol.TypeSymbol typeOwner = (Symbol.TypeSymbol)owner;
                    return methodTemplate.create(typeOwner, reader);
                }
            }
            return null;
        }
    }

    private static class AnnotationCompleterWrapper {
        private static final Class<?> ANNOTATION_COMPLETER_CLASS;
        private static final Field SYM_FIELD;
        private static final Field VALUE_FIELD;
        private final Object annotationCompleter;

        public AnnotationCompleterWrapper(Object o) {
            this.annotationCompleter = ANNOTATION_COMPLETER_CLASS.isInstance(o) ? o : null;
        }

        public Symbol annotationFor() {
            if (this.annotationCompleter == null) {
                return null;
            }
            try {
                return (Symbol)SYM_FIELD.get(this.annotationCompleter);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                ILog.get().error(e.getMessage(), (Throwable)e);
                return null;
            }
        }

        public java.util.List<CompoundTemplate> value(CachingClassSymbolClassReader reader) {
            if (this.annotationCompleter == null) {
                return java.util.List.of();
            }
            try {
                Object o = VALUE_FIELD.get(this.annotationCompleter);
                if (o instanceof java.util.List) {
                    java.util.List attributes = (java.util.List)o;
                    return attributes.stream().map(Attribute.class::cast).map(attr -> AttributeTemplate.of(attr, reader)).map(CompoundTemplate.class::cast).toList();
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                ILog.get().error(e.getMessage(), (Throwable)e);
            }
            return java.util.List.of();
        }

        static {
            Class<?> c = null;
            Field sym = null;
            Field value = null;
            try {
                c = ClassReader.class.getClassLoader().loadClass(ClassReader.class.getName() + "$AnnotationCompleter");
                sym = c.getDeclaredField("sym");
                sym.setAccessible(true);
                value = c.getDeclaredField("l");
                value.setAccessible(true);
            }
            catch (ClassNotFoundException | NoClassDefFoundError | NoSuchFieldException err) {
                ILog.get().error(err.getMessage(), err);
            }
            ANNOTATION_COMPLETER_CLASS = c;
            SYM_FIELD = sym;
            VALUE_FIELD = value;
        }
    }

    private static class AnnotationTypeMetadataTemplate {
        private final CompoundTemplate target;
        private final CompoundTemplate repeatable;

        public AnnotationTypeMetadataTemplate(Annotate.AnnotationTypeMetadata annotationTypeMetadata, CachingClassSymbolClassReader reader) {
            this.target = annotationTypeMetadata.getTarget() != null ? new CompoundTemplate(annotationTypeMetadata.getTarget(), reader) : null;
            this.repeatable = annotationTypeMetadata.getRepeatable() != null ? new CompoundTemplate(annotationTypeMetadata.getRepeatable(), reader) : null;
        }

        public Annotate.AnnotationTypeMetadata create(Symbol.ClassSymbol c, final CachingClassSymbolClassReader reader) {
            return new Annotate.AnnotationTypeMetadata(c, new Annotate.AnnotationTypeCompleter(){
                final /* synthetic */ AnnotationTypeMetadataTemplate this$0;
                {
                    AnnotationTypeMetadataTemplate annotationTypeMetadataTemplate = this$0;
                    Objects.requireNonNull(annotationTypeMetadataTemplate);
                    this.this$0 = annotationTypeMetadataTemplate;
                }

                @Override
                public void complete(Symbol.ClassSymbol sym) throws Symbol.CompletionFailure {
                    if (this.this$0.target != null) {
                        sym.getAnnotationTypeMetadata().setTarget(this.this$0.target.create(reader));
                    }
                    if (this.this$0.repeatable != null) {
                        sym.getAnnotationTypeMetadata().setRepeatable(this.this$0.repeatable.create(reader));
                    }
                }
            });
        }
    }

    private static class DummyAttributeTemplate
    extends AttributeTemplate<Attribute> {
        public DummyAttributeTemplate() {
            super((Attribute)null, null);
        }

        @Override
        public Attribute create(CachingClassSymbolClassReader reader) {
            return new Attribute(this, null){
                {
                    Objects.requireNonNull(this$0);
                    super(arg0);
                }

                @Override
                public void accept(Attribute.Visitor arg0) {
                }
            };
        }
    }

    private static class ArrayAttrTemplate
    extends AttributeTemplate<Attribute.Array> {
        private java.util.List<? extends AttributeTemplate<?>> elements;

        public ArrayAttrTemplate(Type type, java.util.List<Attribute> values, CachingClassSymbolClassReader reader) {
            super(type, reader);
            this.elements = values.stream().map(elt -> AttributeTemplate.of(elt, reader)).toList();
        }

        public ArrayAttrTemplate(Attribute.Array array, CachingClassSymbolClassReader reader) {
            super(array, reader);
            this.elements = array.getValue().stream().map(elt -> AttributeTemplate.of(elt, reader)).toList();
        }

        @Override
        public Attribute.Array create(CachingClassSymbolClassReader reader) {
            return new Attribute.Array(reader.sigToType(this.type), (Attribute[])this.elements.stream().map(elt -> elt.create(reader)).toArray(Attribute[]::new));
        }
    }

    private static class EnumAttrTemplate
    extends AttributeTemplate<Attribute.Enum> {
        private final String name;

        public EnumAttrTemplate(Type enumType, String value, CachingClassSymbolClassReader reader) {
            super(enumType, reader);
            this.name = value;
        }

        public EnumAttrTemplate(Attribute.Enum target, CachingClassSymbolClassReader reader) {
            super(target, reader);
            this.name = ((Name)target.getValue().getSimpleName()).toString();
        }

        @Override
        public Attribute.Enum create(CachingClassSymbolClassReader reader) {
            Type enumType = reader.sigToType(this.type);
            Symbol.ModuleSymbol previousModule = reader.currentModule;
            Symbol.VarSymbol sym = (Symbol.VarSymbol)enumType.tsym.members().findFirst(reader.localNames.fromString(this.name), s -> {
                Symbol.VarSymbol vSym;
                return s instanceof Symbol.VarSymbol && (vSym = (Symbol.VarSymbol)s).isEnum();
            });
            reader.currentModule = previousModule;
            return new Attribute.Enum(enumType, sym);
        }
    }

    private static class ClassAttrTemplate
    extends AttributeTemplate<Attribute.Class> {
        private final String classType;

        public ClassAttrTemplate(Type classType, CachingClassSymbolClassReader reader) {
            super((Type)null, reader);
            this.classType = reader.typeToSig(classType);
        }

        public ClassAttrTemplate(Attribute.Class target, CachingClassSymbolClassReader reader) {
            super(target, reader);
            this.classType = reader.typeToSig(target.getValue());
        }

        @Override
        public Attribute.Class create(CachingClassSymbolClassReader reader) {
            return new Attribute.Class(reader.localTypes, reader.sigToType(this.classType));
        }
    }

    private static class ConstantAttrTemplate
    extends AttributeTemplate<Attribute.Constant> {
        private final Object value;

        public ConstantAttrTemplate(Attribute.Constant target, CachingClassSymbolClassReader reader) {
            super(target, reader);
            this.value = target.getValue();
        }

        @Override
        public Attribute.Constant create(CachingClassSymbolClassReader reader) {
            return new Attribute.Constant(reader.sigToType(this.type), this.value);
        }
    }

    private static class CompoundTemplate
    extends AttributeTemplate<Attribute.Compound> {
        private final boolean synthetized;
        private Map<String, AttributeTemplate<?>> values = new HashMap();

        public CompoundTemplate(Attribute.Compound target, CachingClassSymbolClassReader reader) {
            super(target, reader);
            this.synthetized = target.isSynthesized();
            target.getElementValues().forEach((method, attr) -> this.values.put(((Name)method.getSimpleName()).toString(), AttributeTemplate.of(attr, reader)));
        }

        public CompoundTemplate(Attribute attr, java.util.List<Pair<Name, Attribute>> list, CachingClassSymbolClassReader reader) {
            super(attr, reader);
            this.synthetized = false;
            list.forEach(pair -> this.values.put(((Name)pair.fst).toString(), AttributeTemplate.of((Attribute)pair.snd, reader)));
        }

        @Override
        public Attribute.Compound create(CachingClassSymbolClassReader reader) {
            List<Pair<Symbol.MethodSymbol, Attribute>> values = List.nil();
            Type type = reader.sigToType(this.type);
            for (Map.Entry<String, AttributeTemplate<?>> entry : this.values.entrySet()) {
                Symbol.MethodSymbol method = this.findAccessMethod(type, reader.localNames.fromString(entry.getKey()), reader);
                values = values.append(new Pair(method, entry.getValue().create(reader)));
            }
            Attribute.Compound res = new Attribute.Compound(reader.sigToType(this.type), values, null);
            res.setSynthesized(this.synthetized);
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Symbol.MethodSymbol findAccessMethod(Type container, Name name, CachingClassSymbolClassReader reader) {
            Symbol.CompletionFailure failure = null;
            Symbol.ModuleSymbol previousModule = reader.currentModule;
            try {
                for (Symbol sym : container.tsym.members().getSymbolsByName(name)) {
                    if (sym.kind != Kinds.Kind.MTH || sym.type.getParameterTypes().length() != 0) continue;
                    Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)sym;
                    return methodSymbol;
                }
            }
            catch (Symbol.CompletionFailure ex) {
                failure = ex;
            }
            finally {
                reader.currentModule = previousModule;
            }
            Type.MethodType mt = new Type.MethodType(List.nil(), reader.localSyms.botType, List.nil(), reader.localSyms.methodClass);
            return new Symbol.MethodSymbol(1025L, name, mt, container.tsym);
        }
    }

    private static abstract class AttributeTemplate<T extends Attribute> {
        protected final String type;

        protected AttributeTemplate(Type type, CachingClassSymbolClassReader reader) {
            this.type = type != null && reader != null ? reader.typeToSig(type) : null;
        }

        protected AttributeTemplate(Attribute source, CachingClassSymbolClassReader reader) {
            this(source != null ? source.type : null, reader);
        }

        public abstract T create(CachingClassSymbolClassReader var1);

        public static AttributeTemplate<? extends Attribute> of(Attribute attribute, CachingClassSymbolClassReader reader) {
            if (attribute == null) {
                return null;
            }
            if (attribute instanceof Attribute.Compound) {
                Attribute.Compound compound = (Attribute.Compound)attribute;
                return new CompoundTemplate(compound, reader);
            }
            if (attribute instanceof Attribute.Constant) {
                Attribute.Constant constant = (Attribute.Constant)attribute;
                return new ConstantAttrTemplate(constant, reader);
            }
            if (attribute instanceof Attribute.Class) {
                Attribute.Class classAttr = (Attribute.Class)attribute;
                return new ClassAttrTemplate(classAttr, reader);
            }
            if (attribute instanceof Attribute.Enum) {
                Attribute.Enum enumAttr = (Attribute.Enum)attribute;
                return new EnumAttrTemplate(enumAttr, reader);
            }
            if (attribute instanceof Attribute.Array) {
                Attribute.Array arrayAttr = (Attribute.Array)attribute;
                return new ArrayAttrTemplate(arrayAttr, reader);
            }
            Class<?> clazz = attribute.getClass();
            if (clazz.getName().equals(ClassReader.class.getName() + "$CompoundAnnotationProxy")) {
                try {
                    Field valuesField = clazz.getDeclaredField("values");
                    valuesField.setAccessible(true);
                    return new CompoundTemplate(attribute, (java.util.List)valuesField.get(attribute), reader);
                }
                catch (IllegalAccessException | NoSuchFieldException ex) {
                    ILog.get().error(ex.getMessage(), (Throwable)ex);
                }
            }
            if (clazz.getName().equals(ClassReader.class.getName() + "$EnumAttributeProxy")) {
                try {
                    Field enumType = clazz.getDeclaredField("enumType");
                    enumType.setAccessible(true);
                    Type type = (Type)enumType.get(attribute);
                    Field enumValue = clazz.getDeclaredField("enumerator");
                    enumValue.setAccessible(true);
                    String value = enumValue.get(attribute).toString();
                    return new EnumAttrTemplate(type, value, reader);
                }
                catch (IllegalAccessException | NoSuchFieldException ex) {
                    ILog.get().error(ex.getMessage(), (Throwable)ex);
                }
            }
            if (clazz.getName().equals(ClassReader.class.getName() + "$ArrayAttributeProxy")) {
                try {
                    Field valuesField = clazz.getDeclaredField("values");
                    valuesField.setAccessible(true);
                    java.util.List values = (java.util.List)valuesField.get(attribute);
                    return new ArrayAttrTemplate(null, values, reader);
                }
                catch (IllegalAccessException | NoSuchFieldException ex) {
                    ILog.get().error(ex.getMessage(), (Throwable)ex);
                }
            }
            if (clazz.getName().equals(ClassReader.class.getName() + "$ClassAttributeProxy")) {
                try {
                    Field classField = clazz.getDeclaredField("classType");
                    classField.setAccessible(true);
                    Type c = (Type)classField.get(attribute);
                    return new ClassAttrTemplate(c, reader);
                }
                catch (IllegalAccessException | NoSuchFieldException ex) {
                    ILog.get().error(ex.getMessage(), (Throwable)ex);
                }
            }
            return new DummyAttributeTemplate();
        }
    }

    private static class SymbolMetadataTemplate {
        public SymbolMetadataTemplate(SymbolMetadata base, CachingClassSymbolClassReader reader) {
        }

        public void applyTo(Symbol owner, CachingClassSymbolClassReader reader) {
        }
    }

    private static class MethodSymbolTemplate {
        private final long flags;
        private final String name;
        private final String methodTypeSignature;
        private final java.util.List<VarSymbolTemplate> params;
        private final java.util.List<TypeVariableTemplate> typeVariables;
        private final SymbolMetadataTemplate metadata;
        private final AttributeTemplate<?> defaultValue;
        private final java.util.List<CompoundTemplate> toAnnotate;

        public MethodSymbolTemplate(Symbol.MethodSymbol sym, CachingClassSymbolClassReader reader) {
            this.flags = sym.flags_field;
            this.name = sym.name.toString();
            this.params = sym.params().map(p -> new VarSymbolTemplate((Symbol.VarSymbol)p, reader));
            this.methodTypeSignature = reader.typeToSig(sym.type);
            this.typeVariables = ((List)sym.getTypeParameters()).map(t -> new TypeVariableTemplate((Symbol.TypeVariableSymbol)t, reader));
            this.metadata = new SymbolMetadataTemplate(sym.getMetadata(), reader);
            this.defaultValue = AttributeTemplate.of(sym.getDefaultValue(), reader);
            this.toAnnotate = reader.localAnnotate.annotationsFor(sym);
        }

        public Symbol.MethodSymbol create(Symbol.TypeSymbol owner, CachingClassSymbolClassReader reader) {
            reader.typevars = reader.typevars.dup(owner);
            this.typeVariables.stream().map(template -> template.create(owner, reader)).forEach(reader.typevars::enter);
            Type type = reader.sigToType(this.methodTypeSignature);
            Symbol.MethodSymbol res = new Symbol.MethodSymbol(this.flags, reader.localNames.fromString(this.name), type, owner);
            res.params = List.from(this.params.stream().map(param -> param.create(res, reader)).toList());
            if (this.defaultValue != null) {
                res.defaultValue = this.defaultValue.create(reader);
            }
            this.metadata.applyTo(owner, reader);
            reader.localAnnotate.normal(res, this.toAnnotate);
            reader.typevars = reader.typevars.leave();
            return res;
        }
    }

    private static class TypeVariableTemplate {
        private final long flags;
        private final Name name;
        private final String lowerBound;
        private final String upperBound;
        private final SymbolMetadataTemplate metadata;
        private final java.util.List<CompoundTemplate> toAnnotate;

        public TypeVariableTemplate(Symbol.TypeVariableSymbol base, CachingClassSymbolClassReader reader) {
            Type.TypeVar typeVar;
            this.flags = base.flags_field;
            this.name = base.name;
            Type type = base.type;
            this.lowerBound = type instanceof Type.TypeVar && (typeVar = (Type.TypeVar)type).getLowerBound() != null && typeVar.getLowerBound() != reader.localSyms.botType ? reader.typeToSig(typeVar.getLowerBound()) : null;
            type = base.type;
            this.upperBound = type instanceof Type.TypeVar && (typeVar = (Type.TypeVar)type).getUpperBound() != null && typeVar.getUpperBound() != reader.localSyms.botType ? reader.typeToSig(typeVar.getUpperBound()) : null;
            this.metadata = new SymbolMetadataTemplate(base.getMetadata(), reader);
            this.toAnnotate = reader.localAnnotate.annotationsFor(base);
        }

        public Symbol.TypeVariableSymbol create(Symbol owner, CachingClassSymbolClassReader reader) {
            Type.TypeVar tvar = new Type.TypeVar(this.name, owner, this.lowerBound != null ? reader.sigToType(this.lowerBound) : reader.localSyms.botType);
            tvar.tsym.flags_field = this.flags;
            reader.typevars.enter(tvar.tsym);
            if (this.upperBound != null) {
                tvar.setUpperBound(reader.sigToType(this.upperBound));
            }
            this.metadata.applyTo(tvar.tsym, reader);
            reader.localAnnotate.normal(tvar.tsym, this.toAnnotate);
            return (Symbol.TypeVariableSymbol)tvar.tsym;
        }
    }

    private static class VarSymbolTemplate {
        private final long flags;
        private final Name name;
        private final int pos;
        private final String typeSignature;
        private final Object constantValue;
        private boolean isDataExceptionParameter;
        private boolean isDataResourceVariable;
        private final SymbolMetadataTemplate metadata;
        private java.util.List<CompoundTemplate> toAnnotate;

        public VarSymbolTemplate(Symbol.VarSymbol sym, CachingClassSymbolClassReader reader) {
            this.flags = sym.flags_field;
            this.name = sym.name;
            this.pos = sym.pos;
            this.typeSignature = reader.typeToSig(sym.type);
            this.constantValue = sym.getConstantValue();
            this.isDataExceptionParameter = sym.isExceptionParameter();
            this.isDataResourceVariable = sym.isResourceVariable();
            this.metadata = new SymbolMetadataTemplate(sym.getMetadata(), reader);
            this.toAnnotate = reader.localAnnotate.annotationsFor(sym);
        }

        public Symbol.VarSymbol create(Symbol owner, CachingClassSymbolClassReader reader) {
            Symbol.VarSymbol res = new Symbol.VarSymbol(this.flags, this.name, reader.sigToType(this.typeSignature), owner);
            res.pos = this.pos;
            if (this.isDataExceptionParameter) {
                res.setData((Object)ElementKind.EXCEPTION_PARAMETER);
            } else if (this.isDataResourceVariable) {
                res.setData((Object)ElementKind.RESOURCE_VARIABLE);
            } else {
                res.setData(this.constantValue);
            }
            this.metadata.applyTo(res, reader);
            reader.localAnnotate.normal(res, this.toAnnotate);
            return res;
        }
    }
}

