/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.dom;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import org.eclipse.jdt.core.dom.JavacBindingResolver;
import org.eclipse.jdt.internal.javac.dom.JavacTypeBinding;

public class JavacErrorTypeBinding
extends JavacTypeBinding {
    private Symbol.TypeSymbol originatingSymbol;

    public JavacErrorTypeBinding(Type type, Symbol.TypeSymbol typeSymbol, boolean isDeclaration, JavacBindingResolver resolver, Symbol.TypeSymbol originatingSymbol) {
        super(type, typeSymbol, isDeclaration, resolver);
        this.originatingSymbol = originatingSymbol;
    }

    @Override
    public String getKey() {
        return this.getKeyImpl();
    }

    private String getKeyImpl() {
        StringBuilder builder = new StringBuilder();
        builder.append("L");
        String packageName = "";
        if (this.originatingSymbol.packge() != null) {
            packageName = this.originatingSymbol.packge().getQualifiedName().toString();
        }
        if (!packageName.isEmpty()) {
            builder.append(packageName.replace(".", "/"));
            builder.append("/");
        }
        String typeName = this.originatingSymbol.getQualifiedName().toString();
        if (!packageName.isEmpty()) {
            typeName = typeName.substring(packageName.length() + 1);
        }
        if (typeName.indexOf(".") < 0 && !((Symbol.ClassSymbol)this.originatingSymbol).sourcefile.getName().endsWith(typeName + ".java")) {
            int lastDot;
            String fileName = ((Symbol.ClassSymbol)this.originatingSymbol).sourcefile.toUri().getPath();
            int lastSlash = fileName.lastIndexOf(47);
            if (lastSlash >= 0) {
                fileName = fileName.substring(lastSlash + 1);
            }
            if (!(fileName = fileName.substring(0, lastDot = fileName.lastIndexOf(46))).equals(typeName)) {
                builder.append(fileName);
                builder.append('~');
            }
        }
        builder.append(typeName.replace(".", "$"));
        builder.append(";");
        return builder.toString();
    }
}

