/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.jdt.core.search.TypeReferenceMatch;
import org.eclipse.jdt.internal.core.search.DOMASTNodeUtils;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfReferencedTypesPattern;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;
import org.eclipse.jdt.internal.core.search.matching.TypeReferenceLocator;

public class DOMTypeReferenceLocator
extends DOMPatternLocator {
    private TypeReferenceLocator locator;
    private List<IJavaElement> foundElements = new ArrayList<IJavaElement>();

    public DOMTypeReferenceLocator(TypeReferenceLocator locator) {
        super((SearchPattern)locator.pattern);
        this.locator = locator;
    }

    private boolean hasPackageDeclarationAncestor(ASTNode node) {
        if (node instanceof PackageDeclaration) {
            return true;
        }
        return node == null ? false : this.hasPackageDeclarationAncestor(node.getParent());
    }

    @Override
    public int match(Annotation node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.match(node.getTypeName(), nodeSet, locator);
    }

    @Override
    public int match(Name name, NodeSetWrapper nodeSet, MatchLocator locator) {
        BreakStatement bs;
        LabeledStatement ls;
        if (name.getParent() instanceof AbstractTypeDeclaration) {
            return 0;
        }
        ASTNode aSTNode = name.getParent();
        if (aSTNode instanceof LabeledStatement && (ls = (LabeledStatement)aSTNode).getLabel() == name) {
            return 0;
        }
        aSTNode = name.getParent();
        if (aSTNode instanceof BreakStatement && (bs = (BreakStatement)aSTNode).getLabel() == name) {
            return 0;
        }
        if (this.locator.pattern.simpleName == null) {
            return nodeSet.addMatch((ASTNode)name, this.locator.pattern.mustResolve ? 2 : 3);
        }
        if (name instanceof SimpleName) {
            QualifiedName qn3;
            SimpleName sn2 = (SimpleName)name;
            if (this.locator.pattern.qualification == null) {
                return this.match(sn2, nodeSet);
            }
            ASTNode parent3 = name.getParent();
            if (!(parent3 instanceof QualifiedName)) {
                return this.match(sn2, nodeSet);
            }
            if (parent3 instanceof QualifiedName && (qn3 = (QualifiedName)parent3).getQualifier() == name && this.match(sn2, nodeSet) == 2) {
                return 2;
            }
            if (this.locator.pattern.getMatchMode() == 0) {
                return 0;
            }
            if (this.match(sn2, nodeSet) == 2) {
                return 2;
            }
            return 0;
        }
        if (name instanceof QualifiedName) {
            QualifiedName qn2 = (QualifiedName)name;
            return this.match(qn2, nodeSet);
        }
        return 0;
    }

    @Override
    public int match(ASTNode node, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (node instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumConstantDecl = (EnumConstantDeclaration)node;
            ASTNode aSTNode = node.getParent();
            if (aSTNode instanceof EnumDeclaration) {
                EnumDeclaration enumDeclaration = (EnumDeclaration)aSTNode;
                if (enumConstantDecl.getAnonymousClassDeclaration() != null) {
                    if (this.locator.pattern.simpleName == null) {
                        return nodeSet.addMatch(node, this.locator.pattern.mustResolve ? 2 : 3);
                    }
                    if (this.locator.matchesName(this.locator.pattern.simpleName, enumDeclaration.getName().getIdentifier().toCharArray())) {
                        return nodeSet.addMatch(node, this.locator.pattern.mustResolve ? 2 : 3);
                    }
                }
            }
        }
        return 0;
    }

    @Override
    public int match(Type node, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (this.locator.pattern.simpleName == null) {
            return nodeSet.addMatch((ASTNode)node, this.locator.pattern.mustResolve ? 2 : 3);
        }
        String qualifiedName = null;
        String simpleName = null;
        if (node instanceof SimpleType) {
            SimpleName name;
            SimpleType simple = (SimpleType)node;
            Name name2 = simple.getName();
            if (name2 instanceof SimpleName) {
                name = (SimpleName)name2;
                simpleName = name.getIdentifier();
            }
            if ((name2 = simple.getName()) instanceof QualifiedName) {
                name = (QualifiedName)name2;
                simpleName = name.getName().getIdentifier();
                qualifiedName = name.getFullyQualifiedName();
            }
        } else if (node instanceof QualifiedType) {
            QualifiedType qualified = (QualifiedType)node;
            simpleName = qualified.getName().getIdentifier();
            qualifiedName = qualified.getName().getFullyQualifiedName();
        }
        if (qualifiedName != null && this.locator.pattern.qualification != null) {
            char[] found;
            char[] patternQualified = (new String(this.locator.pattern.qualification) + "." + new String(this.locator.pattern.simpleName)).toCharArray();
            if (this.locator.matchesName(patternQualified, found = qualifiedName.toCharArray())) {
                return nodeSet.addMatch((ASTNode)node, this.locator.pattern.mustResolve ? 2 : 3);
            }
        } else if (simpleName != null && this.locator.matchesName(this.locator.pattern.simpleName, simpleName.toCharArray())) {
            return nodeSet.addMatch((ASTNode)node, this.locator.pattern.mustResolve || this.locator.pattern.qualification == null ? 2 : 3);
        }
        return 0;
    }

    @Override
    public int resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        if (binding == null) {
            SimpleName sn;
            int accuracy;
            if (node instanceof SimpleName && (accuracy = this.resolveLevelForSimpleName(node, (sn = (SimpleName)node).getIdentifier())) != -1) {
                IResource r = null;
                IJavaElement enclosing = DOMASTNodeUtils.getEnclosingJavaElement(node);
                IJavaElement ancestor = enclosing == null ? null : enclosing.getAncestor(5);
                try {
                    r = ancestor == null ? null : ancestor.getCorrespondingResource();
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                TypeReferenceMatch typeMatch = new TypeReferenceMatch(enclosing, accuracy, node.getStartPosition(), node.getLength(), DOMASTNodeUtils.insideDocComment(node), locator.getParticipant(), r);
                try {
                    locator.report((SearchMatch)typeMatch);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                return 0;
            }
            return 1;
        }
        if (binding instanceof ITypeBinding) {
            ITypeBinding typeBinding = (ITypeBinding)binding;
            return this.resolveLevelForTypeBinding(node, typeBinding, locator);
        }
        if (binding instanceof IPackageBinding && node instanceof SimpleName) {
            SimpleName sn = (SimpleName)node;
            if (this.locator.isDeclarationOfReferencedTypesPattern) {
                return 0;
            }
            if (this.hasPackageDeclarationAncestor(node)) {
                return 0;
            }
            String identifier = sn.getIdentifier();
            if (this.locator.matchesName(this.locator.pattern.simpleName, identifier.toCharArray())) {
                return 1;
            }
        }
        return 0;
    }

    private int resolveLevelForSimpleName(ASTNode node, String simpleNameNeedle) {
        if (!simpleNameNeedle.contains(".") && this.locator.pattern.qualification != null && this.locator.pattern.qualification.length > 0) {
            CompilationUnit cu = this.findCU(node);
            List imports = cu.imports();
            for (Object id : imports) {
                QualifiedName qn;
                ImportDeclaration idd = (ImportDeclaration)id;
                Name name = idd.getName();
                if (!(name instanceof QualifiedName) || !(qn = (QualifiedName)name).getName().toString().equals(simpleNameNeedle)) continue;
                char[] qualifiedPattern = this.locator.getQualifiedPattern(this.locator.pattern.simpleName, this.locator.pattern.qualification);
                int level3 = this.resolveLevelForTypeSourceName(qualifiedPattern, qn.toString().toCharArray(), null);
                if (level3 == 3) {
                    return 1;
                }
                return 1;
            }
        }
        return -1;
    }

    private int resolveLevelForTypeBinding(ASTNode node, ITypeBinding typeBinding, MatchLocator locator) {
        String qualNameFromBinding;
        int simpleNameMatch;
        int newLevel = this.resolveLevelForType(this.locator.pattern.simpleName, this.locator.pattern.qualification, typeBinding);
        if (newLevel == 0 && (simpleNameMatch = this.resolveLevelForSimpleName(node, qualNameFromBinding = typeBinding.getQualifiedName())) != -1) {
            return simpleNameMatch;
        }
        if (this.locator.isDeclarationOfReferencedTypesPattern) {
            IJavaElement je;
            IJavaElement enclosing = ((DeclarationOfReferencedTypesPattern)this.locator.pattern).enclosingElement;
            ITypeBinding t2 = typeBinding.getTypeDeclaration();
            IJavaElement iJavaElement = je = t2 == null ? null : t2.getJavaElement();
            if (je != null && !this.foundElements.contains(je) && DOMASTNodeUtils.isWithinRange(node, enclosing)) {
                ISourceRange rangeToUse;
                ISourceReference sr = je instanceof ISourceReference ? (ISourceReference)je : null;
                IResource r = null;
                ISourceRange srg = null;
                ISourceRange nameRange = null;
                try {
                    srg = sr.getSourceRange();
                    nameRange = sr.getNameRange();
                    IJavaElement ancestor = je.getAncestor(5);
                    r = ancestor == null ? null : ancestor.getCorrespondingResource();
                }
                catch (JavaModelException ancestor) {
                    // empty catch block
                }
                ISourceRange iSourceRange = rangeToUse = nameRange == null ? srg : nameRange;
                if (rangeToUse != null) {
                    TypeDeclarationMatch tdm = new TypeDeclarationMatch(je, newLevel, rangeToUse.getOffset(), rangeToUse.getLength(), locator.getParticipant(), r);
                    try {
                        this.foundElements.add(je);
                        locator.report((SearchMatch)tdm);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            }
            return 0;
        }
        return newLevel;
    }

    private CompilationUnit findCU(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)node;
            return cu;
        }
        return this.findCU(node.getParent());
    }

    public int match(SimpleName name, NodeSetWrapper nodeSet) {
        String simpleName = name.getIdentifier();
        return simpleName != null && this.locator.matchesName(this.locator.pattern.simpleName, simpleName.toCharArray()) ? 2 : 0;
    }

    public int match(QualifiedName name, NodeSetWrapper nodeSet) {
        String desiredQualifier;
        String simpleName = name.getName().getIdentifier();
        String qualifier = name.getQualifier().toString();
        if (this.locator.pattern.qualification == null) {
            return 0;
        }
        if (qualifier != null && !qualifier.equals(desiredQualifier = new String(this.locator.pattern.qualification))) {
            return 0;
        }
        return simpleName != null && this.locator.matchesName(this.locator.pattern.simpleName, simpleName.toCharArray()) ? 2 : 0;
    }

    protected int resolveLevelForType(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            if (this.locator.pattern.typeSuffix != '\u0000') {
                return 1;
            }
        } else {
            switch (this.locator.pattern.typeSuffix) {
                case 'C': {
                    if (typeBinding.isClass()) break;
                    return 0;
                }
                case '\n': {
                    if (typeBinding.isClass() || typeBinding.isInterface() && !typeBinding.isAnnotation()) break;
                    return 0;
                }
                case '\t': {
                    if (typeBinding.isClass() || typeBinding.isEnum()) break;
                    return 0;
                }
                case 'I': {
                    if (typeBinding.isInterface() && !typeBinding.isAnnotation()) break;
                    return 0;
                }
                case '\u000b': {
                    if (typeBinding.isInterface() || typeBinding.isAnnotation()) break;
                    return 0;
                }
                case 'E': {
                    if (typeBinding.isEnum()) break;
                    return 0;
                }
                case 'A': {
                    if (typeBinding.isAnnotation()) break;
                    return 0;
                }
            }
        }
        return this.resolveLevelForType(this.locator.pattern.simpleName, this.locator.pattern.qualification, typeBinding);
    }
}

