/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;
import org.eclipse.jdt.internal.core.search.matching.TypeParameterLocator;

public class DOMTypeParameterLocator
extends DOMPatternLocator {
    private TypeParameterLocator locator;

    public DOMTypeParameterLocator(TypeParameterLocator locator) {
        super((SearchPattern)locator.pattern);
        this.locator = locator;
    }

    private static boolean nodeSourceRangeMatchesElement(ASTNode node, IJavaElement focus) {
        if (focus == null) {
            return false;
        }
        ISourceRange sr = null;
        try {
            if (focus instanceof ISourceReference) {
                ISourceReference isr2 = (ISourceReference)focus;
                sr = isr2.getSourceRange();
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (sr == null) {
            return false;
        }
        return sr.getOffset() == node.getStartPosition() && sr.getLength() == node.getLength();
    }

    @Override
    public int match(Type node, NodeSetWrapper nodeSet, MatchLocator locator) {
        SimpleType simple;
        if (this.locator.pattern.findReferences && node instanceof SimpleType && this.locator.matchesName(this.locator.pattern.name, (simple = (SimpleType)node).getName().toString().toCharArray())) {
            int level = this.locator.pattern.mustResolve ? 2 : 3;
            return nodeSet.addMatch((ASTNode)node, level);
        }
        return 0;
    }

    @Override
    public int match(TypeParameter node, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (this.locator.pattern.findReferences && this.locator.matchesName(this.locator.pattern.name, node.getName().toString().toCharArray())) {
            int level = this.locator.pattern.mustResolve ? 2 : 3;
            return nodeSet.addMatch((ASTNode)node, level);
        }
        if (this.locator.pattern.findDeclarations && this.locator.matchesName(this.locator.pattern.name, node.getName().toString().toCharArray())) {
            int level = this.locator.pattern.mustResolve ? 2 : 3;
            return nodeSet.addMatch((ASTNode)node, level);
        }
        return 0;
    }

    @Override
    public int resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof ITypeBinding)) {
            return 0;
        }
        ITypeBinding tb = (ITypeBinding)binding;
        int ret = this.matchTypeParameter(tb, true);
        if (ret == 3 && !this.locator.pattern.findDeclarations && DOMTypeParameterLocator.nodeSourceRangeMatchesElement(node, this.locator.pattern.focus)) {
            return 0;
        }
        return ret;
    }

    protected int matchTypeParameter(ITypeBinding variable, boolean matchName) {
        IMethodBinding methBinding;
        if (variable.getDeclaringMethod() != null && this.locator.matchesName((methBinding = variable.getDeclaringMethod()).getDeclaringClass().getName().toCharArray(), this.locator.pattern.methodDeclaringClassName) && (methBinding.isConstructor() || this.locator.matchesName(methBinding.getName().toCharArray(), this.locator.pattern.declaringMemberName))) {
            int length;
            int n = length = this.locator.pattern.methodArgumentTypes == null ? 0 : this.locator.pattern.methodArgumentTypes.length;
            if (methBinding.getParameterTypes() == null) {
                if (length == 0) {
                    return 3;
                }
            } else if (methBinding.getParameterTypes().length == length) {
                ITypeBinding[] p = methBinding.getParameterTypes();
                for (int i = 0; i < length; ++i) {
                    if (this.locator.matchesName(this.locator.pattern.methodArgumentTypes[i], p[i].getName().toCharArray())) continue;
                    return 0;
                }
                return 3;
            }
        }
        if (variable.getDeclaringMember() != null && this.locator.matchesName(variable.getDeclaringMember().getName().toCharArray(), this.locator.pattern.declaringMemberName)) {
            return 3;
        }
        return 0;
    }
}

