/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.repository.Repository;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.internal.embedder.AbstractTransferListenerAdapter;

final class WagonTransferListenerAdapter
extends AbstractTransferListenerAdapter
implements TransferListener {
    WagonTransferListenerAdapter(IProgressMonitor monitor) {
        super(monitor);
    }

    public void transferInitiated(TransferEvent e) {
        this.transferInitiated((String)null);
    }

    public void transferStarted(TransferEvent e) {
        StringBuilder sb = new StringBuilder();
        if (e.getWagon() != null && e.getWagon().getRepository() != null) {
            Wagon wagon = e.getWagon();
            Repository repository = wagon.getRepository();
            String repositoryId = repository.getId();
            sb.append(repositoryId).append(" : ");
        }
        sb.append(e.getResource().getName());
        this.transferStarted(sb.toString());
    }

    public void transferProgress(TransferEvent e, byte[] buffer, int length) {
        long total = e.getResource().getContentLength();
        String artifactUrl = e.getWagon().getRepository() + "/" + e.getResource().getName();
        this.transferProgress(artifactUrl, total, length);
    }

    public void transferCompleted(TransferEvent e) {
        String artifactUrl = e.getWagon().getRepository() + "/" + e.getResource().getName();
        this.transferCompleted(artifactUrl);
    }

    public void transferError(TransferEvent e) {
        this.transferError(e.getWagon().getRepository() + "/" + e.getResource().getName(), e.getException());
    }

    public void debug(String message) {
    }
}

