/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.ServiceStatus;
import org.eclipse.jdt.ls.core.internal.handlers.BaseInitHandler;
import org.eclipse.jdt.ls.core.internal.handlers.BundleUtils;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.InlayHintsPreferenceChangeListener;
import org.eclipse.jdt.ls.core.internal.handlers.RenameHandler;
import org.eclipse.jdt.ls.core.internal.handlers.SemanticTokensHandler;
import org.eclipse.jdt.ls.core.internal.handlers.SignatureHelpHandler;
import org.eclipse.jdt.ls.core.internal.handlers.WorkspaceExecuteCommandHandler;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.managers.TelemetryManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jdt.ls.internal.gradle.checksums.WrapperValidator;
import org.eclipse.lsp4j.CodeActionOptions;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.DocumentFilter;
import org.eclipse.lsp4j.DocumentOnTypeFormattingOptions;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.FileOperationFilter;
import org.eclipse.lsp4j.FileOperationOptions;
import org.eclipse.lsp4j.FileOperationPattern;
import org.eclipse.lsp4j.FileOperationsServerCapabilities;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.SaveOptions;
import org.eclipse.lsp4j.SemanticTokensServerFull;
import org.eclipse.lsp4j.SemanticTokensWithRegistrationOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.osgi.framework.BundleException;

public final class InitHandler
extends BaseInitHandler {
    private static final String BUNDLES_KEY = "bundles";
    private JavaClientConnection connection;
    private PreferenceManager preferenceManager;
    private WorkspaceExecuteCommandHandler commandHandler;
    private TelemetryManager telemetryManager;

    public InitHandler(ProjectsManager manager, PreferenceManager preferenceManager, JavaClientConnection connection, WorkspaceExecuteCommandHandler commandHandler) {
        this(manager, preferenceManager, connection, commandHandler, new TelemetryManager());
    }

    public InitHandler(ProjectsManager manager, PreferenceManager preferenceManager, JavaClientConnection connection, WorkspaceExecuteCommandHandler commandHandler, TelemetryManager telemetryManager) {
        super(manager, preferenceManager);
        this.connection = connection;
        this.preferenceManager = preferenceManager;
        this.commandHandler = commandHandler;
        this.telemetryManager = telemetryManager;
    }

    @Override
    public Map<?, ?> handleInitializationOptions(InitializeParams param) {
        this.startBundle("org.eclipse.m2e.core");
        long start = System.currentTimeMillis();
        JobHelpers.waitForProjectRegistryRefreshJob();
        JavaLanguageServerPlugin.logInfo("ProjectRegistryRefreshJob finished " + (System.currentTimeMillis() - start) + "ms");
        this.startBundle("org.eclipse.buildship.core");
        Map<?, ?> initializationOptions = super.handleInitializationOptions(param);
        try {
            Collection bundleList = this.getInitializationOption(initializationOptions, BUNDLES_KEY, Collection.class);
            BundleUtils.loadBundles(bundleList);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Failed to load extension bundles ", e);
        }
        return initializationOptions;
    }

    @Override
    public void registerCapabilities(InitializeResult initializeResult) {
        ServerCapabilities capabilities = new ServerCapabilities();
        if (!this.preferenceManager.getClientPreferences().isCompletionDynamicRegistered()) {
            capabilities.setCompletionProvider(CompletionHandler.getDefaultCompletionOptions(this.preferenceManager));
        }
        if (!this.preferenceManager.getClientPreferences().isFormattingDynamicRegistrationSupported()) {
            capabilities.setDocumentFormattingProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isRangeFormattingDynamicRegistrationSupported()) {
            capabilities.setDocumentRangeFormattingProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isOnTypeFormattingDynamicRegistrationSupported()) {
            capabilities.setDocumentOnTypeFormattingProvider(new DocumentOnTypeFormattingOptions(";", Arrays.asList("\n", "}")));
        }
        if (!this.preferenceManager.getClientPreferences().isCodeLensDynamicRegistrationSupported()) {
            capabilities.setCodeLensProvider(new CodeLensOptions(Boolean.valueOf(true)));
        }
        if (!this.preferenceManager.getClientPreferences().isSignatureHelpDynamicRegistrationSupported()) {
            capabilities.setSignatureHelpProvider(SignatureHelpHandler.createOptions());
        }
        if (!this.preferenceManager.getClientPreferences().isRenameDynamicRegistrationSupported()) {
            capabilities.setRenameProvider(RenameHandler.createOptions());
        }
        if (!this.preferenceManager.getClientPreferences().isCodeActionDynamicRegistered()) {
            if (this.preferenceManager.getClientPreferences().isResolveCodeActionSupported()) {
                CodeActionOptions codeActionOptions = new CodeActionOptions();
                codeActionOptions.setResolveProvider(Boolean.TRUE);
                capabilities.setCodeActionProvider(codeActionOptions);
            } else {
                capabilities.setCodeActionProvider(Boolean.TRUE);
            }
        }
        if (!this.preferenceManager.getClientPreferences().isExecuteCommandDynamicRegistrationSupported()) {
            Set<String> commands = this.commandHandler.getAllCommands();
            if (!commands.isEmpty()) {
                capabilities.setExecuteCommandProvider(new ExecuteCommandOptions(new ArrayList<String>(commands)));
            }
        } else {
            Set<String> staticCommands = this.commandHandler.getStaticCommands();
            if (!staticCommands.isEmpty()) {
                capabilities.setExecuteCommandProvider(new ExecuteCommandOptions(new ArrayList<String>(staticCommands)));
            }
        }
        if (!this.preferenceManager.getClientPreferences().isWorkspaceSymbolDynamicRegistered()) {
            capabilities.setWorkspaceSymbolProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isClientDocumentSymbolProviderRegistered() && !this.preferenceManager.getClientPreferences().isDocumentSymbolDynamicRegistered()) {
            capabilities.setDocumentSymbolProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isDefinitionDynamicRegistered()) {
            capabilities.setDefinitionProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isDeclarationDynamicRegistered()) {
            capabilities.setDeclarationProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isTypeDefinitionDynamicRegistered()) {
            capabilities.setTypeDefinitionProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isClientHoverProviderRegistered() && !this.preferenceManager.getClientPreferences().isHoverDynamicRegistered()) {
            capabilities.setHoverProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isReferencesDynamicRegistered()) {
            capabilities.setReferencesProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isDocumentHighlightDynamicRegistered()) {
            capabilities.setDocumentHighlightProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isFoldgingRangeDynamicRegistered()) {
            capabilities.setFoldingRangeProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isImplementationDynamicRegistered()) {
            capabilities.setImplementationProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isSelectionRangeDynamicRegistered()) {
            capabilities.setSelectionRangeProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isInlayHintDynamicRegistered()) {
            capabilities.setInlayHintProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isTypeHierarchyDynamicRegistrationSupported()) {
            capabilities.setTypeHierarchyProvider(Boolean.TRUE);
        }
        capabilities.setCallHierarchyProvider(Boolean.TRUE);
        TextDocumentSyncOptions textDocumentSyncOptions = new TextDocumentSyncOptions();
        textDocumentSyncOptions.setOpenClose(Boolean.TRUE);
        textDocumentSyncOptions.setSave(new SaveOptions(Boolean.TRUE));
        textDocumentSyncOptions.setChange(TextDocumentSyncKind.Incremental);
        if (this.preferenceManager.getClientPreferences().isWillSaveRegistered()) {
            textDocumentSyncOptions.setWillSave(Boolean.TRUE);
        }
        if (this.preferenceManager.getClientPreferences().isWillSaveWaitUntilRegistered()) {
            textDocumentSyncOptions.setWillSaveWaitUntil(Boolean.TRUE);
        }
        capabilities.setTextDocumentSync(textDocumentSyncOptions);
        WorkspaceServerCapabilities wsCapabilities = new WorkspaceServerCapabilities();
        WorkspaceFoldersOptions wsFoldersOptions = new WorkspaceFoldersOptions();
        wsFoldersOptions.setSupported(Boolean.TRUE);
        wsFoldersOptions.setChangeNotifications(Boolean.TRUE);
        if (this.preferenceManager.getClientPreferences().isWorkspaceWillRenameFilesSupported()) {
            FileOperationsServerCapabilities wsFileOperations = new FileOperationsServerCapabilities();
            FileOperationPattern fileOpPattern = new FileOperationPattern("**/*.java");
            fileOpPattern.setMatches("file");
            wsFileOperations.setWillRename(new FileOperationOptions(List.of(new FileOperationFilter(fileOpPattern, "file"))));
            wsCapabilities.setFileOperations(wsFileOperations);
        }
        wsCapabilities.setWorkspaceFolders(wsFoldersOptions);
        capabilities.setWorkspace(wsCapabilities);
        SemanticTokensWithRegistrationOptions semanticTokensOptions = new SemanticTokensWithRegistrationOptions();
        semanticTokensOptions.setFull(new SemanticTokensServerFull(Boolean.valueOf(false)));
        semanticTokensOptions.setRange(Boolean.valueOf(false));
        semanticTokensOptions.setDocumentSelector(List.of(new DocumentFilter("java", "file", null), new DocumentFilter("java", "jdt", null)));
        semanticTokensOptions.setLegend(SemanticTokensHandler.legend());
        capabilities.setSemanticTokensProvider(semanticTokensOptions);
        initializeResult.setCapabilities(capabilities);
    }

    @Override
    public void triggerInitialization(final Collection<IPath> roots) {
        Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_AUTO_BUILD);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace instanceof Workspace) {
            Workspace workspaceImpl = (Workspace)workspace;
            workspaceImpl.getBuildManager().waitForAutoBuildOff();
        }
        WorkspaceJob job = new WorkspaceJob("Initialize Workspace"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                long start = System.currentTimeMillis();
                InitHandler.this.connection.sendStatus(ServiceStatus.Starting, "Init...");
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                Preferences preferences = InitHandler.this.preferenceManager.getPreferences();
                if (preferences.isImportGradleEnabled()) {
                    WrapperValidator.putSha256(preferences.getGradleWrapperList());
                }
                Runnable resetBuildState = () -> {};
                try {
                    try {
                        start = System.currentTimeMillis();
                        JobHelpers.waitForRepositoryRegistryUpdateJob();
                        JavaLanguageServerPlugin.logInfo("RepositoryRegistryUpdateJob finished " + (System.currentTimeMillis() - start) + "ms");
                        resetBuildState = ProjectsManager.interruptAutoBuild();
                        InitHandler.this.projectsManager.initializeProjects(roots, (IProgressMonitor)subMonitor);
                        InitHandler.this.projectsManager.configureFilters(monitor);
                        JavaLanguageServerPlugin.logInfo("Workspace initialized in " + (System.currentTimeMillis() - start) + "ms");
                        InitHandler.this.connection.sendStatus(ServiceStatus.Started, "Ready");
                        InitHandler.this.telemetryManager.onProjectsInitialized(System.currentTimeMillis());
                    }
                    catch (OperationCanceledException e) {
                        InitHandler.this.connection.sendStatus(ServiceStatus.Error, "Initialization has been cancelled.");
                        IStatus iStatus = Status.CANCEL_STATUS;
                        resetBuildState.run();
                        InitHandler.this.projectsManager.registerListeners();
                        InitHandler.this.preferenceManager.addPreferencesChangeListener(new InlayHintsPreferenceChangeListener());
                        return iStatus;
                    }
                    catch (Exception e) {
                        JavaLanguageServerPlugin.logException("Initialization failed ", e);
                        InitHandler.this.connection.sendStatus(ServiceStatus.Error, e.getMessage());
                        resetBuildState.run();
                        InitHandler.this.projectsManager.registerListeners();
                        InitHandler.this.preferenceManager.addPreferencesChangeListener(new InlayHintsPreferenceChangeListener());
                    }
                }
                finally {
                    resetBuildState.run();
                    InitHandler.this.projectsManager.registerListeners();
                    InitHandler.this.preferenceManager.addPreferencesChangeListener(new InlayHintsPreferenceChangeListener());
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                Collection rootPathsSet = roots.stream().collect(Collectors.toSet());
                boolean equalToRootPaths = false;
                if (family instanceof Collection) {
                    Collection familyCollection = (Collection)family;
                    equalToRootPaths = rootPathsSet.equals(familyCollection.stream().collect(Collectors.toSet()));
                }
                return "java-ls-initialization-jobs".equals(family) || equalToRootPaths;
            }
        };
        job.setPriority(40);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }

    private void startBundle(String symbolicName) {
        try {
            long start = System.currentTimeMillis();
            JavaLanguageServerPlugin.debugTrace("Starting " + symbolicName);
            Platform.getBundle((String)symbolicName).start(1);
            JavaLanguageServerPlugin.logInfo("Started " + symbolicName + " " + (System.currentTimeMillis() - start) + "ms");
        }
        catch (BundleException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
    }
}

