(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_debug_lib_browser_debug-session-manager_js"],{

/***/ "../../node_modules/@theia/console/lib/browser/ansi-console-item.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@theia/console/lib/browser/ansi-console-item.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AnsiConsoleItem = void 0;
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const DOMPurify = __webpack_require__(/*! @theia/core/shared/dompurify */ "../../node_modules/@theia/core/shared/dompurify/index.js");
const Anser = __webpack_require__(/*! anser */ "../../node_modules/anser/lib/index.js");
class AnsiConsoleItem {
    constructor(content, severity) {
        this.content = content;
        this.severity = severity;
        this.htmlContent = new Anser().ansiToHtml(this.content, {
            use_classes: true,
            remove_empty: true
        });
    }
    get visible() {
        return !!this.htmlContent;
    }
    render() {
        return React.createElement("div", { className: 'theia-console-ansi-console-item', dangerouslySetInnerHTML: { __html: DOMPurify.sanitize(this.htmlContent) } });
    }
}
exports.AnsiConsoleItem = AnsiConsoleItem;


/***/ }),

/***/ "../../node_modules/@theia/core/shared/react-dom/client/index.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@theia/core/shared/react-dom/client/index.js ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! react-dom/client */ "../../node_modules/react-dom/client.js");


/***/ }),

/***/ "../../node_modules/@theia/core/shared/vscode-uri/index.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/@theia/core/shared/vscode-uri/index.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! vscode-uri */ "../../node_modules/vscode-uri/lib/esm/index.js");


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/breakpoint/breakpoint-manager.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/breakpoint/breakpoint-manager.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var BreakpointManager_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BreakpointManager = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const deepEqual = __webpack_require__(/*! fast-deep-equal */ "../../node_modules/fast-deep-equal/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const marker_manager_1 = __webpack_require__(/*! @theia/markers/lib/browser/marker-manager */ "../../node_modules/@theia/markers/lib/browser/marker-manager.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const breakpoint_marker_1 = __webpack_require__(/*! ./breakpoint-marker */ "../../node_modules/@theia/debug/lib/browser/breakpoint/breakpoint-marker.js");
let BreakpointManager = BreakpointManager_1 = class BreakpointManager extends marker_manager_1.MarkerManager {
    constructor() {
        super(...arguments);
        this.owner = 'breakpoint';
        this.onDidChangeBreakpointsEmitter = new common_1.Emitter();
        this.onDidChangeBreakpoints = this.onDidChangeBreakpointsEmitter.event;
        this.onDidChangeFunctionBreakpointsEmitter = new common_1.Emitter();
        this.onDidChangeFunctionBreakpoints = this.onDidChangeFunctionBreakpointsEmitter.event;
        this.onDidChangeInstructionBreakpointsEmitter = new common_1.Emitter();
        this.onDidChangeInstructionBreakpoints = this.onDidChangeInstructionBreakpointsEmitter.event;
        this._breakpointsEnabled = true;
        this.exceptionBreakpoints = new Map();
        this.functionBreakpoints = [];
        this.instructionBreakpoints = [];
    }
    getKind() {
        return breakpoint_marker_1.BREAKPOINT_KIND;
    }
    setMarkers(uri, owner, newMarkers) {
        const result = this.findMarkers({ uri, owner });
        const added = [];
        const removed = [];
        const changed = [];
        const oldMarkers = new Map(result.map(({ data }) => [data.id, data]));
        const ids = new Set();
        let didChangeMarkers = false;
        for (const newMarker of newMarkers) {
            ids.add(newMarker.id);
            const oldMarker = oldMarkers.get(newMarker.id);
            if (!oldMarker) {
                added.push(newMarker);
            }
            else {
                // We emit all existing markers as 'changed', but we only fire an event if something really did change.
                // We also fire an event if oldMarker === newMarker, as we cannot actually detect a change in this case
                // (https://github.com/eclipse-theia/theia/issues/12546).
                didChangeMarkers || (didChangeMarkers = !!added.length || oldMarker === newMarker || !deepEqual(oldMarker, newMarker));
                changed.push(newMarker);
            }
        }
        for (const [id, data] of oldMarkers.entries()) {
            if (!ids.has(id)) {
                removed.push(data);
            }
        }
        if (added.length || removed.length || didChangeMarkers) {
            super.setMarkers(uri, owner, newMarkers);
            this.onDidChangeBreakpointsEmitter.fire({ uri, added, removed, changed });
        }
        return result;
    }
    getLineBreakpoints(uri, line) {
        return this.findMarkers({
            uri,
            dataFilter: breakpoint => breakpoint.raw.line === line
        }).map(({ data }) => data);
    }
    getInlineBreakpoint(uri, line, column) {
        const marker = this.findMarkers({
            uri,
            dataFilter: breakpoint => breakpoint.raw.line === line && breakpoint.raw.column === column
        })[0];
        return marker && marker.data;
    }
    getBreakpoints(uri) {
        return this.findMarkers({ uri }).map(marker => marker.data);
    }
    setBreakpoints(uri, breakpoints) {
        this.setMarkers(uri, this.owner, breakpoints.sort((a, b) => (a.raw.line - b.raw.line) || ((a.raw.column || 0) - (b.raw.column || 0))));
    }
    addBreakpoint(breakpoint) {
        const uri = new uri_1.default(breakpoint.uri);
        const breakpoints = this.getBreakpoints(uri);
        const newBreakpoints = breakpoints.filter(({ raw }) => !(raw.line === breakpoint.raw.line && raw.column === breakpoint.raw.column));
        if (breakpoints.length === newBreakpoints.length) {
            newBreakpoints.push(breakpoint);
            this.setBreakpoints(uri, newBreakpoints);
            return true;
        }
        return false;
    }
    enableAllBreakpoints(enabled) {
        for (const uriString of this.getUris()) {
            let didChange = false;
            const uri = new uri_1.default(uriString);
            const markers = this.findMarkers({ uri });
            for (const marker of markers) {
                if (marker.data.enabled !== enabled) {
                    marker.data.enabled = enabled;
                    didChange = true;
                }
            }
            if (didChange) {
                this.fireOnDidChangeMarkers(uri);
            }
        }
        let didChangeFunction = false;
        for (const breakpoint of this.getFunctionBreakpoints().concat(this.getInstructionBreakpoints())) {
            if (breakpoint.enabled !== enabled) {
                breakpoint.enabled = enabled;
                didChangeFunction = true;
            }
        }
        if (didChangeFunction) {
            this.fireOnDidChangeMarkers(BreakpointManager_1.FUNCTION_URI);
        }
    }
    get breakpointsEnabled() {
        return this._breakpointsEnabled;
    }
    set breakpointsEnabled(breakpointsEnabled) {
        if (this._breakpointsEnabled !== breakpointsEnabled) {
            this._breakpointsEnabled = breakpointsEnabled;
            for (const uri of this.getUris()) {
                this.fireOnDidChangeMarkers(new uri_1.default(uri));
            }
            this.fireOnDidChangeMarkers(BreakpointManager_1.FUNCTION_URI);
        }
    }
    getExceptionBreakpoint(filter) {
        return this.exceptionBreakpoints.get(filter);
    }
    getExceptionBreakpoints() {
        return this.exceptionBreakpoints.values();
    }
    setExceptionBreakpoints(exceptionBreakpoints) {
        const toRemove = new Set(this.exceptionBreakpoints.keys());
        for (const exceptionBreakpoint of exceptionBreakpoints) {
            const filter = exceptionBreakpoint.raw.filter;
            toRemove.delete(filter);
            this.exceptionBreakpoints.set(filter, exceptionBreakpoint);
        }
        for (const filter of toRemove) {
            this.exceptionBreakpoints.delete(filter);
        }
        if (toRemove.size || exceptionBreakpoints.length) {
            this.fireOnDidChangeMarkers(BreakpointManager_1.EXCEPTION_URI);
        }
    }
    toggleExceptionBreakpoint(filter) {
        const breakpoint = this.getExceptionBreakpoint(filter);
        if (breakpoint) {
            breakpoint.enabled = !breakpoint.enabled;
            this.fireOnDidChangeMarkers(BreakpointManager_1.EXCEPTION_URI);
        }
    }
    updateExceptionBreakpoint(filter, options) {
        const breakpoint = this.getExceptionBreakpoint(filter);
        if (breakpoint) {
            Object.assign(breakpoint, options);
            this.fireOnDidChangeMarkers(BreakpointManager_1.EXCEPTION_URI);
        }
    }
    getFunctionBreakpoints() {
        return this.functionBreakpoints;
    }
    setFunctionBreakpoints(functionBreakpoints) {
        const oldBreakpoints = new Map(this.functionBreakpoints.map(b => [b.id, b]));
        this.functionBreakpoints = functionBreakpoints;
        this.fireOnDidChangeMarkers(BreakpointManager_1.FUNCTION_URI);
        const added = [];
        const removed = [];
        const changed = [];
        const ids = new Set();
        for (const newBreakpoint of functionBreakpoints) {
            ids.add(newBreakpoint.id);
            if (oldBreakpoints.has(newBreakpoint.id)) {
                changed.push(newBreakpoint);
            }
            else {
                added.push(newBreakpoint);
            }
        }
        for (const [id, breakpoint] of oldBreakpoints.entries()) {
            if (!ids.has(id)) {
                removed.push(breakpoint);
            }
        }
        this.onDidChangeFunctionBreakpointsEmitter.fire({ uri: BreakpointManager_1.FUNCTION_URI, added, removed, changed });
    }
    getInstructionBreakpoints() {
        return Object.freeze(this.instructionBreakpoints.slice());
    }
    hasBreakpoints() {
        return Boolean(this.getUris().next().value || this.functionBreakpoints.length || this.instructionBreakpoints.length);
    }
    setInstructionBreakpoints(newBreakpoints) {
        const oldBreakpoints = new Map(this.instructionBreakpoints.map(breakpoint => [breakpoint.id, breakpoint]));
        const currentBreakpoints = new Map(newBreakpoints.map(breakpoint => [breakpoint.id, breakpoint]));
        const added = [];
        const changed = [];
        for (const [id, breakpoint] of currentBreakpoints.entries()) {
            const old = oldBreakpoints.get(id);
            if (old) {
                changed.push(old);
            }
            else {
                added.push(breakpoint);
            }
            oldBreakpoints.delete(id);
        }
        const removed = Array.from(oldBreakpoints.values());
        this.instructionBreakpoints = Array.from(currentBreakpoints.values());
        this.fireOnDidChangeMarkers(BreakpointManager_1.INSTRUCTION_URI);
        this.onDidChangeInstructionBreakpointsEmitter.fire({ uri: BreakpointManager_1.INSTRUCTION_URI, added, removed, changed });
    }
    addInstructionBreakpoint(address, offset, condition, hitCondition) {
        this.setInstructionBreakpoints(this.instructionBreakpoints.concat(breakpoint_marker_1.InstructionBreakpoint.create({
            instructionReference: address,
            offset,
            condition,
            hitCondition,
        })));
    }
    updateInstructionBreakpoint(id, options) {
        const breakpoint = this.instructionBreakpoints.find(candidate => id === candidate.id);
        if (breakpoint) {
            Object.assign(breakpoint, options);
            this.fireOnDidChangeMarkers(BreakpointManager_1.INSTRUCTION_URI);
            this.onDidChangeInstructionBreakpointsEmitter.fire({ uri: BreakpointManager_1.INSTRUCTION_URI, changed: [breakpoint], added: [], removed: [] });
        }
    }
    removeInstructionBreakpoint(address) {
        if (!address) {
            this.clearInstructionBreakpoints();
        }
        const breakpointIndex = this.instructionBreakpoints.findIndex(breakpoint => breakpoint.instructionReference === address);
        if (breakpointIndex !== -1) {
            const removed = this.instructionBreakpoints.splice(breakpointIndex, 1);
            this.fireOnDidChangeMarkers(BreakpointManager_1.INSTRUCTION_URI);
            this.onDidChangeInstructionBreakpointsEmitter.fire({ uri: BreakpointManager_1.INSTRUCTION_URI, added: [], changed: [], removed });
        }
    }
    clearInstructionBreakpoints() {
        this.setInstructionBreakpoints([]);
    }
    removeBreakpoints() {
        this.cleanAllMarkers();
        this.setFunctionBreakpoints([]);
        this.setInstructionBreakpoints([]);
    }
    async load() {
        const data = await this.storage.getData('breakpoints', {
            breakpointsEnabled: true,
            breakpoints: {}
        });
        this._breakpointsEnabled = data.breakpointsEnabled;
        // eslint-disable-next-line guard-for-in
        for (const uri in data.breakpoints) {
            this.setBreakpoints(new uri_1.default(uri), data.breakpoints[uri]);
        }
        if (data.functionBreakpoints) {
            this.setFunctionBreakpoints(data.functionBreakpoints);
        }
        if (data.exceptionBreakpoints) {
            this.setExceptionBreakpoints(data.exceptionBreakpoints);
        }
        if (data.instructionBreakpoints) {
            this.setInstructionBreakpoints(data.instructionBreakpoints);
        }
    }
    save() {
        const data = {
            breakpointsEnabled: this._breakpointsEnabled,
            breakpoints: {}
        };
        const uris = this.getUris();
        for (const uri of uris) {
            data.breakpoints[uri] = this.findMarkers({ uri: new uri_1.default(uri) }).map(marker => marker.data);
        }
        if (this.functionBreakpoints.length) {
            data.functionBreakpoints = this.functionBreakpoints;
        }
        if (this.exceptionBreakpoints.size) {
            data.exceptionBreakpoints = [...this.exceptionBreakpoints.values()];
        }
        if (this.instructionBreakpoints.length) {
            data.instructionBreakpoints = this.instructionBreakpoints;
        }
        this.storage.setData('breakpoints', data);
    }
};
exports.BreakpointManager = BreakpointManager;
BreakpointManager.EXCEPTION_URI = new uri_1.default('debug:exception://');
BreakpointManager.FUNCTION_URI = new uri_1.default('debug:function://');
BreakpointManager.INSTRUCTION_URI = new uri_1.default('debug:instruction://');
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.StorageService),
    tslib_1.__metadata("design:type", Object)
], BreakpointManager.prototype, "storage", void 0);
exports.BreakpointManager = BreakpointManager = BreakpointManager_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], BreakpointManager);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/breakpoint/breakpoint-marker.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/breakpoint/breakpoint-marker.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InstructionBreakpoint = exports.FunctionBreakpoint = exports.ExceptionBreakpoint = exports.BreakpointMarker = exports.SourceBreakpoint = exports.BREAKPOINT_KIND = void 0;
const coreutils_1 = __webpack_require__(/*! @theia/core/shared/@lumino/coreutils */ "../../node_modules/@theia/core/shared/@lumino/coreutils/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
exports.BREAKPOINT_KIND = 'breakpoint';
var SourceBreakpoint;
(function (SourceBreakpoint) {
    function create(uri, data, origin) {
        return {
            id: origin ? origin.id : coreutils_1.UUID.uuid4(),
            uri: uri.toString(),
            enabled: origin ? origin.enabled : true,
            raw: {
                ...(origin && origin.raw),
                ...data
            }
        };
    }
    SourceBreakpoint.create = create;
})(SourceBreakpoint || (exports.SourceBreakpoint = SourceBreakpoint = {}));
var BreakpointMarker;
(function (BreakpointMarker) {
    function is(node) {
        return 'kind' in node && node.kind === exports.BREAKPOINT_KIND;
    }
    BreakpointMarker.is = is;
})(BreakpointMarker || (exports.BreakpointMarker = BreakpointMarker = {}));
var ExceptionBreakpoint;
(function (ExceptionBreakpoint) {
    function create(data, origin) {
        return {
            enabled: origin ? origin.enabled : false,
            condition: origin ? origin.condition : undefined,
            raw: {
                ...(origin && origin.raw),
                ...data
            }
        };
    }
    ExceptionBreakpoint.create = create;
})(ExceptionBreakpoint || (exports.ExceptionBreakpoint = ExceptionBreakpoint = {}));
var FunctionBreakpoint;
(function (FunctionBreakpoint) {
    function create(data, origin) {
        return {
            id: origin ? origin.id : coreutils_1.UUID.uuid4(),
            enabled: origin ? origin.enabled : true,
            raw: {
                ...(origin && origin.raw),
                ...data
            }
        };
    }
    FunctionBreakpoint.create = create;
})(FunctionBreakpoint || (exports.FunctionBreakpoint = FunctionBreakpoint = {}));
var InstructionBreakpoint;
(function (InstructionBreakpoint) {
    function create(raw, existing) {
        var _a, _b;
        return {
            ...raw,
            id: (_a = existing === null || existing === void 0 ? void 0 : existing.id) !== null && _a !== void 0 ? _a : coreutils_1.UUID.uuid4(),
            enabled: (_b = existing === null || existing === void 0 ? void 0 : existing.enabled) !== null && _b !== void 0 ? _b : true,
        };
    }
    InstructionBreakpoint.create = create;
    function is(arg) {
        return (0, common_1.isObject)(arg) && (0, common_1.isString)(arg.instructionReference);
    }
    InstructionBreakpoint.is = is;
})(InstructionBreakpoint || (exports.InstructionBreakpoint = InstructionBreakpoint = {}));


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/console/debug-console-contribution.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/console/debug-console-contribution.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var DebugConsoleContribution_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugConsoleContribution = exports.DebugConsoleCommands = exports.InDebugReplContextKey = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const console_session_manager_1 = __webpack_require__(/*! @theia/console/lib/browser/console-session-manager */ "../../node_modules/@theia/console/lib/browser/console-session-manager.js");
const console_widget_1 = __webpack_require__(/*! @theia/console/lib/browser/console-widget */ "../../node_modules/@theia/console/lib/browser/console-widget.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const tab_bar_toolbar_1 = __webpack_require__(/*! @theia/core/lib/browser/shell/tab-bar-toolbar */ "../../node_modules/@theia/core/lib/browser/shell/tab-bar-toolbar/index.js");
const command_1 = __webpack_require__(/*! @theia/core/lib/common/command */ "../../node_modules/@theia/core/lib/common/command.js");
const severity_1 = __webpack_require__(/*! @theia/core/lib/common/severity */ "../../node_modules/@theia/core/lib/common/severity.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const select_component_1 = __webpack_require__(/*! @theia/core/lib/browser/widgets/select-component */ "../../node_modules/@theia/core/lib/browser/widgets/select-component.js");
const debug_session_manager_1 = __webpack_require__(/*! ../debug-session-manager */ "../../node_modules/@theia/debug/lib/browser/debug-session-manager.js");
const debug_console_session_1 = __webpack_require__(/*! ./debug-console-session */ "../../node_modules/@theia/debug/lib/browser/console/debug-console-session.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
exports.InDebugReplContextKey = Symbol('inDebugReplContextKey');
var DebugConsoleCommands;
(function (DebugConsoleCommands) {
    DebugConsoleCommands.DEBUG_CATEGORY = 'Debug';
    DebugConsoleCommands.CLEAR = command_1.Command.toDefaultLocalizedCommand({
        id: 'debug.console.clear',
        category: DebugConsoleCommands.DEBUG_CATEGORY,
        label: 'Clear Console',
        iconClass: (0, browser_1.codicon)('clear-all')
    });
})(DebugConsoleCommands || (exports.DebugConsoleCommands = DebugConsoleCommands = {}));
let DebugConsoleContribution = DebugConsoleContribution_1 = class DebugConsoleContribution extends browser_1.AbstractViewContribution {
    constructor() {
        super({
            widgetId: DebugConsoleContribution_1.options.id,
            widgetName: DebugConsoleContribution_1.options.title.label,
            defaultWidgetOptions: {
                area: 'bottom'
            },
            toggleCommandId: 'debug:console:toggle',
            toggleKeybinding: 'ctrlcmd+shift+y'
        });
        this.changeDebugConsole = (option) => {
            const id = option.value;
            const session = this.consoleSessionManager.get(id);
            this.consoleSessionManager.selectedSession = session;
        };
        this.changeSeverity = (option) => {
            this.consoleSessionManager.severity = severity_1.Severity.fromValue(option.value);
        };
    }
    init() {
        this.resources.add(debug_console_session_1.DebugConsoleSession.uri, '');
        this.debugSessionManager.onDidCreateDebugSession(session => {
            const consoleParent = session.findConsoleParent();
            if (consoleParent) {
                const parentConsoleSession = this.consoleSessionManager.get(consoleParent.id);
                if (parentConsoleSession instanceof debug_console_session_1.DebugConsoleSession) {
                    session.on('output', event => parentConsoleSession.logOutput(parentConsoleSession.debugSession, event));
                }
            }
            else {
                const consoleSession = this.debugConsoleSessionFactory(session);
                this.consoleSessionManager.add(consoleSession);
                session.on('output', event => consoleSession.logOutput(session, event));
            }
        });
        this.debugSessionManager.onDidChangeActiveDebugSession(event => this.handleActiveDebugSessionChanged(event));
        this.debugSessionManager.onDidDestroyDebugSession(session => {
            this.consoleSessionManager.delete(session.id);
        });
    }
    handleActiveDebugSessionChanged(event) {
        if (!event.current) {
            this.consoleSessionManager.selectedSession = undefined;
        }
        else {
            const topSession = event.current.findConsoleParent() || event.current;
            const consoleSession = topSession ? this.consoleSessionManager.get(topSession.id) : undefined;
            this.consoleSessionManager.selectedSession = consoleSession;
            const consoleSelector = document.getElementById('debugConsoleSelector');
            if (consoleSession && consoleSelector instanceof HTMLSelectElement) {
                consoleSelector.value = consoleSession.id;
            }
        }
    }
    registerCommands(commands) {
        super.registerCommands(commands);
        commands.registerCommand(DebugConsoleCommands.CLEAR, {
            isEnabled: widget => this.withWidget(widget, () => true),
            isVisible: widget => this.withWidget(widget, () => true),
            execute: widget => this.withWidget(widget, () => {
                this.clearConsole();
            }),
        });
    }
    async registerToolbarItems(toolbarRegistry) {
        toolbarRegistry.registerItem({
            id: 'debug-console-severity',
            render: widget => this.renderSeveritySelector(widget),
            isVisible: widget => this.withWidget(widget, () => true),
            onDidChange: this.consoleSessionManager.onDidChangeSeverity
        });
        toolbarRegistry.registerItem({
            id: 'debug-console-session-selector',
            render: widget => this.renderDebugConsoleSelector(widget),
            isVisible: widget => this.withWidget(widget, () => this.consoleSessionManager.all.length > 1)
        });
        toolbarRegistry.registerItem({
            id: DebugConsoleCommands.CLEAR.id,
            command: DebugConsoleCommands.CLEAR.id,
            tooltip: DebugConsoleCommands.CLEAR.label,
            priority: 0,
        });
    }
    static async create(parent) {
        const inputFocusContextKey = parent.get(exports.InDebugReplContextKey);
        const child = console_widget_1.ConsoleWidget.createContainer(parent, {
            ...DebugConsoleContribution_1.options,
            inputFocusContextKey
        });
        const widget = child.get(console_widget_1.ConsoleWidget);
        await widget.ready;
        return widget;
    }
    static bindContribution(bind) {
        bind(exports.InDebugReplContextKey).toDynamicValue(({ container }) => container.get(context_key_service_1.ContextKeyService).createKey('inDebugRepl', false)).inSingletonScope();
        bind(debug_console_session_1.DebugConsoleSession).toSelf().inRequestScope();
        bind(debug_console_session_1.DebugConsoleSessionFactory).toFactory(context => (session) => {
            const consoleSession = context.container.get(debug_console_session_1.DebugConsoleSession);
            consoleSession.debugSession = session;
            return consoleSession;
        });
        bind(console_session_manager_1.ConsoleSessionManager).toSelf().inSingletonScope();
        (0, browser_1.bindViewContribution)(bind, DebugConsoleContribution_1);
        bind(tab_bar_toolbar_1.TabBarToolbarContribution).toService(DebugConsoleContribution_1);
        bind(browser_1.WidgetFactory).toDynamicValue(({ container }) => ({
            id: DebugConsoleContribution_1.options.id,
            createWidget: () => DebugConsoleContribution_1.create(container)
        }));
    }
    renderSeveritySelector(widget) {
        const severityElements = severity_1.Severity.toArray().map(e => ({
            value: e,
            label: severity_1.Severity.toLocaleString(e)
        }));
        return React.createElement(select_component_1.SelectComponent, { key: "debugConsoleSeverity", options: severityElements, defaultValue: this.consoleSessionManager.severity || severity_1.Severity.Ignore, onChange: this.changeSeverity });
    }
    renderDebugConsoleSelector(widget) {
        const availableConsoles = [];
        this.consoleSessionManager.all.forEach(e => {
            if (e instanceof debug_console_session_1.DebugConsoleSession) {
                availableConsoles.push({
                    value: e.id,
                    label: e.debugSession.label
                });
            }
        });
        return React.createElement(select_component_1.SelectComponent, { key: "debugConsoleSelector", options: availableConsoles, defaultValue: 0, onChange: this.changeDebugConsole });
    }
    withWidget(widget = this.tryGetWidget(), fn) {
        if (widget instanceof console_widget_1.ConsoleWidget && widget.id === DebugConsoleContribution_1.options.id) {
            return fn(widget);
        }
        return false;
    }
    /**
     * Clear the console widget.
     */
    async clearConsole() {
        const widget = await this.widget;
        widget.clear();
    }
};
exports.DebugConsoleContribution = DebugConsoleContribution;
DebugConsoleContribution.options = {
    id: 'debug-console',
    title: {
        label: nls_1.nls.localizeByDefault('Debug Console'),
        iconClass: (0, browser_1.codicon)('debug-console')
    },
    input: {
        uri: debug_console_session_1.DebugConsoleSession.uri,
        options: {
            autoSizing: true,
            minHeight: 1,
            maxHeight: 10
        }
    }
};
tslib_1.__decorate([
    (0, inversify_1.inject)(console_session_manager_1.ConsoleSessionManager),
    tslib_1.__metadata("design:type", console_session_manager_1.ConsoleSessionManager)
], DebugConsoleContribution.prototype, "consoleSessionManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_console_session_1.DebugConsoleSessionFactory),
    tslib_1.__metadata("design:type", Function)
], DebugConsoleContribution.prototype, "debugConsoleSessionFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_session_manager_1.DebugSessionManager),
    tslib_1.__metadata("design:type", debug_session_manager_1.DebugSessionManager)
], DebugConsoleContribution.prototype, "debugSessionManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.InMemoryResources),
    tslib_1.__metadata("design:type", core_1.InMemoryResources)
], DebugConsoleContribution.prototype, "resources", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugConsoleContribution.prototype, "init", null);
exports.DebugConsoleContribution = DebugConsoleContribution = DebugConsoleContribution_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__metadata("design:paramtypes", [])
], DebugConsoleContribution);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/console/debug-console-items.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/console/debug-console-items.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugScope = exports.ExpressionItem = exports.DebugVirtualVariable = exports.DebugVariable = exports.ExpressionContainer = void 0;
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const console_session_1 = __webpack_require__(/*! @theia/console/lib/browser/console-session */ "../../node_modules/@theia/console/lib/browser/console-session.js");
const severity_1 = __webpack_require__(/*! @theia/core/lib/common/severity */ "../../node_modules/@theia/core/lib/common/severity.js");
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
class ExpressionContainer {
    get session() {
        return this.sessionProvider();
    }
    constructor(options) {
        this.sessionProvider = options.session;
        this.variablesReference = options.variablesReference || 0;
        this.namedVariables = options.namedVariables;
        this.indexedVariables = options.indexedVariables;
        this.startOfVariables = options.startOfVariables || 0;
    }
    render() {
        return undefined;
    }
    get hasElements() {
        return !!this.variablesReference;
    }
    async getElements() {
        if (!this.hasElements || !this.session) {
            return [][Symbol.iterator]();
        }
        if (!this.elements) {
            this.elements = this.doResolve();
        }
        return (await this.elements)[Symbol.iterator]();
    }
    async doResolve() {
        const result = [];
        if (this.namedVariables) {
            await this.fetch(result, 'named');
        }
        if (this.indexedVariables) {
            let chunkSize = ExpressionContainer.BASE_CHUNK_SIZE;
            while (this.indexedVariables > chunkSize * ExpressionContainer.BASE_CHUNK_SIZE) {
                chunkSize *= ExpressionContainer.BASE_CHUNK_SIZE;
            }
            if (this.indexedVariables > chunkSize) {
                const numberOfChunks = Math.ceil(this.indexedVariables / chunkSize);
                for (let i = 0; i < numberOfChunks; i++) {
                    const start = this.startOfVariables + i * chunkSize;
                    const count = Math.min(chunkSize, this.indexedVariables - i * chunkSize);
                    const { variablesReference } = this;
                    result.push(new DebugVirtualVariable({
                        session: this.sessionProvider,
                        variablesReference,
                        namedVariables: 0,
                        indexedVariables: count,
                        startOfVariables: start,
                        name: `[${start}..${start + count - 1}]`
                    }));
                }
                return result;
            }
        }
        await this.fetch(result, 'indexed', this.startOfVariables, this.indexedVariables);
        return result;
    }
    async fetch(result, filter, start, count) {
        try {
            const { variablesReference } = this;
            const response = await this.session.sendRequest('variables', { variablesReference, filter, start, count });
            const { variables } = response.body;
            const names = new Set();
            for (const variable of variables) {
                if (!names.has(variable.name)) {
                    result.push(new DebugVariable(this.sessionProvider, variable, this));
                    names.add(variable.name);
                }
            }
        }
        catch (e) {
            result.push({
                severity: severity_1.Severity.Error,
                visible: !!e.message,
                render: () => e.message
            });
        }
    }
}
exports.ExpressionContainer = ExpressionContainer;
ExpressionContainer.BASE_CHUNK_SIZE = 100;
class DebugVariable extends ExpressionContainer {
    constructor(session, variable, parent) {
        super({
            session,
            variablesReference: variable.variablesReference,
            namedVariables: variable.namedVariables,
            indexedVariables: variable.indexedVariables
        });
        this.variable = variable;
        this.parent = parent;
        this.setValueRef = (valueRef) => this.valueRef = valueRef || undefined;
        this.setNameRef = (nameRef) => this.nameRef = nameRef || undefined;
    }
    get name() {
        return this.variable.name;
    }
    get type() {
        return this._type || this.variable.type;
    }
    get value() {
        return this._value || this.variable.value;
    }
    get readOnly() {
        var _a, _b, _c;
        return (_c = (_b = (_a = this.variable.presentationHint) === null || _a === void 0 ? void 0 : _a.attributes) === null || _b === void 0 ? void 0 : _b.includes('readOnly')) !== null && _c !== void 0 ? _c : false;
    }
    render() {
        const { type, value, name } = this;
        return React.createElement("div", { className: this.variableClassName },
            React.createElement("span", { title: type || name, className: 'name', ref: this.setNameRef },
                name,
                !!value && ': '),
            React.createElement("span", { title: value, ref: this.setValueRef }, value));
    }
    get variableClassName() {
        const { type, value } = this;
        const classNames = ['theia-debug-console-variable'];
        if (type === 'number' || type === 'boolean' || type === 'string') {
            classNames.push(type);
        }
        else if (!isNaN(+value)) {
            classNames.push('number');
        }
        else if (DebugVariable.booleanRegex.test(value)) {
            classNames.push('boolean');
        }
        else if (DebugVariable.stringRegex.test(value)) {
            classNames.push('string');
        }
        return classNames.join(' ');
    }
    get supportSetVariable() {
        return !!this.session && !!this.session.capabilities.supportsSetVariable;
    }
    async setValue(value) {
        if (!this.session) {
            return;
        }
        const { name, parent } = this;
        const variablesReference = parent['variablesReference'];
        try {
            const response = await this.session.sendRequest('setVariable', { variablesReference, name, value });
            this._value = response.body.value;
            this._type = response.body.type;
            this.variablesReference = response.body.variablesReference || 0;
            this.namedVariables = response.body.namedVariables;
            this.indexedVariables = response.body.indexedVariables;
            this.elements = undefined;
            this.session['fireDidChange']();
        }
        catch (error) {
            console.error('setValue failed:', error);
        }
    }
    get supportCopyValue() {
        return !!this.valueRef && document.queryCommandSupported('copy');
    }
    copyValue() {
        const selection = document.getSelection();
        if (this.valueRef && selection) {
            selection.selectAllChildren(this.valueRef);
            document.execCommand('copy');
        }
    }
    get supportCopyAsExpression() {
        return !!this.nameRef && document.queryCommandSupported('copy');
    }
    copyAsExpression() {
        const selection = document.getSelection();
        if (this.nameRef && selection) {
            selection.selectAllChildren(this.nameRef);
            document.execCommand('copy');
        }
    }
    async open() {
        if (!this.supportSetVariable || this.readOnly) {
            return;
        }
        const input = new browser_1.SingleTextInputDialog({
            title: core_1.nls.localize('theia/debug/debugVariableInput', 'Set {0} Value', this.name),
            initialValue: this.value,
            placeholder: core_1.nls.localizeByDefault('Value')
        });
        const newValue = await input.open();
        if (newValue) {
            await this.setValue(newValue);
        }
    }
}
exports.DebugVariable = DebugVariable;
DebugVariable.booleanRegex = /^true|false$/i;
DebugVariable.stringRegex = /^(['"]).*\1$/;
class DebugVirtualVariable extends ExpressionContainer {
    constructor(options) {
        super(options);
        this.options = options;
    }
    render() {
        return this.options.name;
    }
}
exports.DebugVirtualVariable = DebugVirtualVariable;
class ExpressionItem extends ExpressionContainer {
    get value() {
        return this._value;
    }
    get type() {
        return this._type;
    }
    get available() {
        return this._available;
    }
    constructor(_expression, session) {
        super({ session });
        this._expression = _expression;
        this._value = ExpressionItem.notAvailable;
        this._available = false;
    }
    get expression() {
        return this._expression;
    }
    render() {
        const valueClassNames = [];
        if (!this._available) {
            valueClassNames.push(console_session_1.ConsoleItem.errorClassName);
            valueClassNames.push('theia-debug-console-unavailable');
        }
        return React.createElement("div", { className: 'theia-debug-console-expression' },
            React.createElement("div", null, this._expression),
            React.createElement("div", { className: valueClassNames.join(' ') }, this._value));
    }
    async evaluate(context = 'repl') {
        const session = this.session;
        if (!(session === null || session === void 0 ? void 0 : session.currentFrame)) {
            this.setResult(undefined, ExpressionItem.notAvailable);
            return;
        }
        try {
            const body = await session.evaluate(this._expression, context);
            this.setResult(body);
        }
        catch (err) {
            this.setResult(undefined, err.message);
        }
    }
    setResult(body, error = ExpressionItem.notAvailable) {
        if (body) {
            this._value = body.result;
            this._type = body.type;
            this._available = true;
            this.variablesReference = body.variablesReference;
            this.namedVariables = body.namedVariables;
            this.indexedVariables = body.indexedVariables;
            this.severity = severity_1.Severity.Log;
        }
        else {
            this._value = error;
            this._type = undefined;
            this._available = false;
            this.variablesReference = 0;
            this.namedVariables = undefined;
            this.indexedVariables = undefined;
            this.severity = severity_1.Severity.Error;
        }
        this.elements = undefined;
    }
}
exports.ExpressionItem = ExpressionItem;
ExpressionItem.notAvailable = 'not available';
class DebugScope extends ExpressionContainer {
    constructor(raw, session) {
        super({
            session,
            variablesReference: raw.variablesReference,
            namedVariables: raw.namedVariables,
            indexedVariables: raw.indexedVariables
        });
        this.raw = raw;
    }
    render() {
        return this.name;
    }
    get expensive() {
        return this.raw.expensive;
    }
    get range() {
        const { line, column, endLine, endColumn } = this.raw;
        if (line !== undefined && column !== undefined && endLine !== undefined && endColumn !== undefined) {
            return new monaco.Range(line, column, endLine, endColumn);
        }
        return undefined;
    }
    get name() {
        return this.raw.name;
    }
    expandByDefault() {
        return this.raw.presentationHint === 'locals';
    }
}
exports.DebugScope = DebugScope;


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/console/debug-console-session.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/console/debug-console-session.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var DebugConsoleSession_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugConsoleSession = exports.DebugConsoleSessionFactory = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const throttle = __webpack_require__(/*! @theia/core/shared/lodash.throttle */ "../../node_modules/@theia/core/shared/lodash.throttle/index.js");
const console_session_1 = __webpack_require__(/*! @theia/console/lib/browser/console-session */ "../../node_modules/@theia/console/lib/browser/console-session.js");
const ansi_console_item_1 = __webpack_require__(/*! @theia/console/lib/browser/ansi-console-item */ "../../node_modules/@theia/console/lib/browser/ansi-console-item.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const debug_console_items_1 = __webpack_require__(/*! ./debug-console-items */ "../../node_modules/@theia/debug/lib/browser/console/debug-console-items.js");
const severity_1 = __webpack_require__(/*! @theia/core/lib/common/severity */ "../../node_modules/@theia/core/lib/common/severity.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const debug_session_manager_1 = __webpack_require__(/*! ../debug-session-manager */ "../../node_modules/@theia/debug/lib/browser/debug-session-manager.js");
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
exports.DebugConsoleSessionFactory = Symbol('DebugConsoleSessionFactory');
let DebugConsoleSession = DebugConsoleSession_1 = class DebugConsoleSession extends console_session_1.ConsoleSession {
    constructor() {
        super(...arguments);
        this.items = [];
        this.completionKinds = new Map();
        this.fireDidChange = throttle(() => super.fireDidChange(), 50);
    }
    get debugSession() {
        return this._debugSession;
    }
    set debugSession(value) {
        this._debugSession = value;
        this.id = value.id;
    }
    init() {
        this.completionKinds.set('method', monaco.languages.CompletionItemKind.Method);
        this.completionKinds.set('function', monaco.languages.CompletionItemKind.Function);
        this.completionKinds.set('constructor', monaco.languages.CompletionItemKind.Constructor);
        this.completionKinds.set('field', monaco.languages.CompletionItemKind.Field);
        this.completionKinds.set('variable', monaco.languages.CompletionItemKind.Variable);
        this.completionKinds.set('class', monaco.languages.CompletionItemKind.Class);
        this.completionKinds.set('interface', monaco.languages.CompletionItemKind.Interface);
        this.completionKinds.set('module', monaco.languages.CompletionItemKind.Module);
        this.completionKinds.set('property', monaco.languages.CompletionItemKind.Property);
        this.completionKinds.set('unit', monaco.languages.CompletionItemKind.Unit);
        this.completionKinds.set('value', monaco.languages.CompletionItemKind.Value);
        this.completionKinds.set('enum', monaco.languages.CompletionItemKind.Enum);
        this.completionKinds.set('keyword', monaco.languages.CompletionItemKind.Keyword);
        this.completionKinds.set('snippet', monaco.languages.CompletionItemKind.Snippet);
        this.completionKinds.set('text', monaco.languages.CompletionItemKind.Text);
        this.completionKinds.set('color', monaco.languages.CompletionItemKind.Color);
        this.completionKinds.set('file', monaco.languages.CompletionItemKind.File);
        this.completionKinds.set('reference', monaco.languages.CompletionItemKind.Reference);
        this.completionKinds.set('customcolor', monaco.languages.CompletionItemKind.Color);
        this.toDispose.push(monaco.languages.registerCompletionItemProvider({
            scheme: DebugConsoleSession_1.uri.scheme,
            hasAccessToAllModels: true
        }, {
            triggerCharacters: ['.'],
            provideCompletionItems: (model, position) => this.completions(model, position),
        }));
    }
    getElements() {
        return this.items.filter(e => !this.severity || e.severity === this.severity)[Symbol.iterator]();
    }
    async completions(model, position) {
        const completionSession = this.findCompletionSession();
        if (completionSession) {
            const column = position.column;
            const lineNumber = position.lineNumber;
            const word = model.getWordAtPosition({ column, lineNumber });
            const overwriteBefore = word ? word.word.length : 0;
            const text = model.getValue();
            const items = await completionSession.completions(text, column, lineNumber);
            const suggestions = items.map(item => this.asCompletionItem(text, position, overwriteBefore, item));
            return { suggestions };
        }
        return undefined;
    }
    findCurrentSession() {
        const currentSession = this.sessionManager.currentSession;
        if (!currentSession) {
            return undefined;
        }
        if (currentSession.id === this.debugSession.id) {
            // perfect match
            return this.debugSession;
        }
        const parentSession = currentSession.findConsoleParent();
        if ((parentSession === null || parentSession === void 0 ? void 0 : parentSession.id) === this.debugSession.id) {
            // child of our session
            return currentSession;
        }
        return undefined;
    }
    findCompletionSession() {
        let completionSession = this.findCurrentSession();
        while (completionSession !== undefined) {
            if (completionSession.capabilities.supportsCompletionsRequest) {
                return completionSession;
            }
            completionSession = completionSession.parentSession;
        }
        return completionSession;
    }
    asCompletionItem(text, position, overwriteBefore, item) {
        return {
            label: item.label,
            insertText: item.text || item.label,
            kind: this.completionKinds.get(item.type) || monaco.languages.CompletionItemKind.Property,
            filterText: (item.start && item.length) ? text.substring(item.start, item.start + item.length).concat(item.label) : undefined,
            range: monaco.Range.fromPositions(position.delta(0, -(item.length || overwriteBefore)), position),
            sortText: item.sortText
        };
    }
    async execute(value) {
        const expression = new debug_console_items_1.ExpressionItem(value, () => this.findCurrentSession());
        this.items.push(expression);
        await expression.evaluate();
        this.fireDidChange();
    }
    clear() {
        this.items = [];
        this.fireDidChange();
    }
    append(value) {
        if (!value) {
            return;
        }
        const lastItem = this.items.slice(-1)[0];
        if (lastItem instanceof ansi_console_item_1.AnsiConsoleItem && lastItem.content === this.uncompletedItemContent) {
            this.items.pop();
            this.uncompletedItemContent += value;
        }
        else {
            this.uncompletedItemContent = value;
        }
        this.items.push(new ansi_console_item_1.AnsiConsoleItem(this.uncompletedItemContent, severity_1.Severity.Info));
        this.fireDidChange();
    }
    appendLine(value) {
        this.items.push(new ansi_console_item_1.AnsiConsoleItem(value, severity_1.Severity.Info));
        this.fireDidChange();
    }
    async logOutput(session, event) {
        const body = event.body;
        const { category, variablesReference } = body;
        if (category === 'telemetry') {
            console.debug(`telemetry/${event.body.output}`, event.body.data);
            return;
        }
        const severity = category === 'stderr' ? severity_1.Severity.Error : event.body.category === 'console' ? severity_1.Severity.Warning : severity_1.Severity.Info;
        if (variablesReference) {
            const items = await new debug_console_items_1.ExpressionContainer({ session: () => session, variablesReference }).getElements();
            for (const item of items) {
                this.items.push(Object.assign(item, { severity }));
            }
        }
        else if (typeof body.output === 'string') {
            for (const line of body.output.split('\n')) {
                this.items.push(new ansi_console_item_1.AnsiConsoleItem(line, severity));
            }
        }
        this.fireDidChange();
    }
};
exports.DebugConsoleSession = DebugConsoleSession;
DebugConsoleSession.uri = new uri_1.default().withScheme('debugconsole');
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_session_manager_1.DebugSessionManager),
    tslib_1.__metadata("design:type", debug_session_manager_1.DebugSessionManager)
], DebugConsoleSession.prototype, "sessionManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugConsoleSession.prototype, "init", null);
exports.DebugConsoleSession = DebugConsoleSession = DebugConsoleSession_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugConsoleSession);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/debug-call-stack-item-type-key.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/debug-call-stack-item-type-key.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugCallStackItemTypeKey = void 0;
exports.DebugCallStackItemTypeKey = Symbol('DebugCallStackItemTypeKey');


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/debug-configuration-manager.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/debug-configuration-manager.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugConfigurationManager = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
/*---------------------------------------------------------------------------------------------
*  Copyright (c) Microsoft Corporation. All rights reserved.
*  Licensed under the MIT License. See License.txt in the project root for license information.
*--------------------------------------------------------------------------------------------*/
const debounce = __webpack_require__(/*! p-debounce */ "../../node_modules/p-debounce/index.js");
const jsonc_parser_1 = __webpack_require__(/*! jsonc-parser */ "../../node_modules/jsonc-parser/lib/esm/main.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "../../node_modules/@theia/core/lib/common/event.js");
const browser_1 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const monaco_editor_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-editor */ "../../node_modules/@theia/monaco/lib/browser/monaco-editor.js");
const browser_2 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const quick_pick_service_1 = __webpack_require__(/*! @theia/core/lib/common/quick-pick-service */ "../../node_modules/@theia/core/lib/common/quick-pick-service.js");
const workspace_service_1 = __webpack_require__(/*! @theia/workspace/lib/browser/workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
const debug_configuration_model_1 = __webpack_require__(/*! ./debug-configuration-model */ "../../node_modules/@theia/debug/lib/browser/debug-configuration-model.js");
const debug_session_options_1 = __webpack_require__(/*! ./debug-session-options */ "../../node_modules/@theia/debug/lib/browser/debug-session-options.js");
const debug_service_1 = __webpack_require__(/*! ../common/debug-service */ "../../node_modules/@theia/debug/lib/common/debug-service.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
const debug_common_1 = __webpack_require__(/*! ../common/debug-common */ "../../node_modules/@theia/debug/lib/common/debug-common.js");
const workspace_variable_contribution_1 = __webpack_require__(/*! @theia/workspace/lib/browser/workspace-variable-contribution */ "../../node_modules/@theia/workspace/lib/browser/workspace-variable-contribution.js");
const preference_configurations_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences/preference-configurations */ "../../node_modules/@theia/core/lib/browser/preferences/preference-configurations.js");
const monaco_text_model_service_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-text-model-service */ "../../node_modules/@theia/monaco/lib/browser/monaco-text-model-service.js");
const commands_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/platform/commands/common/commands */ "../../node_modules/@theia/monaco-editor-core/esm/vs/platform/commands/common/commands.js");
const standaloneServices_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/standalone/browser/standaloneServices */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/standalone/browser/standaloneServices.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
let DebugConfigurationManager = class DebugConfigurationManager {
    constructor() {
        this.onDidChangeEmitter = new event_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
        this.onWillProvideDebugConfigurationEmitter = new event_1.Emitter();
        this.onWillProvideDebugConfiguration = this.onWillProvideDebugConfigurationEmitter.event;
        this.onWillProvideDynamicDebugConfigurationEmitter = new event_1.Emitter();
        this.recentDynamicOptionsTracker = [];
        this.models = new Map();
        this.updateModels = debounce(async () => {
            const roots = await this.workspaceService.roots;
            const toDelete = new Set(this.models.keys());
            for (const rootStat of roots) {
                const key = rootStat.resource.toString();
                toDelete.delete(key);
                if (!this.models.has(key)) {
                    const model = new debug_configuration_model_1.DebugConfigurationModel(key, this.preferences);
                    model.onDidChange(() => this.updateCurrent());
                    model.onDispose(() => this.models.delete(key));
                    this.models.set(key, model);
                }
            }
            for (const uri of toDelete) {
                const model = this.models.get(uri);
                if (model) {
                    model.dispose();
                }
            }
            this.updateCurrent();
        }, 500);
    }
    get onWillProvideDynamicDebugConfiguration() {
        return this.onWillProvideDynamicDebugConfigurationEmitter.event;
    }
    get onDidChangeConfigurationProviders() {
        return this.debug.onDidChangeDebugConfigurationProviders;
    }
    init() {
        this.doInit();
    }
    async doInit() {
        this.debugConfigurationTypeKey = this.contextKeyService.createKey('debugConfigurationType', undefined);
        this.initialized = this.preferences.ready.then(() => {
            this.workspaceService.onWorkspaceChanged(this.updateModels);
            this.preferences.onPreferenceChanged(e => {
                if (e.preferenceName === 'launch') {
                    this.updateModels();
                }
            });
            return this.updateModels();
        });
    }
    /**
     * All _non-dynamic_ debug configurations.
     */
    get all() {
        return this.getAll();
    }
    *getAll() {
        for (const model of this.models.values()) {
            for (const configuration of model.configurations) {
                yield this.configurationToOptions(configuration, model.workspaceFolderUri);
            }
            for (const compound of model.compounds) {
                yield this.compoundToOptions(compound, model.workspaceFolderUri);
            }
        }
    }
    get supported() {
        return this.getSupported();
    }
    async getSupported() {
        await this.initialized;
        const debugTypes = await this.debug.debugTypes();
        return this.doGetSupported(new Set(debugTypes));
    }
    *doGetSupported(debugTypes) {
        for (const options of this.getAll()) {
            if (options.configuration && debugTypes.has(options.configuration.type)) {
                yield options;
            }
        }
    }
    get current() {
        return this._currentOptions;
    }
    async getSelectedConfiguration() {
        if (!debug_session_options_1.DebugSessionOptions.isDynamic(this._currentOptions)) {
            return this._currentOptions;
        }
        // Refresh a dynamic configuration from the provider.
        // This allow providers to update properties before the execution e.g. program
        const { providerType, workspaceFolderUri, configuration: { name } } = this._currentOptions;
        const configuration = await this.fetchDynamicDebugConfiguration(name, providerType, workspaceFolderUri);
        if (!configuration) {
            const message = core_1.nls.localize('theia/debug/missingConfiguration', "Dynamic configuration '{0}:{1}' is missing or not applicable", providerType, name);
            throw new Error(message);
        }
        return { name, configuration, providerType, workspaceFolderUri };
    }
    set current(option) {
        this.updateCurrent(option);
        this.updateRecentlyUsedDynamicConfigurationOptions(option);
    }
    updateRecentlyUsedDynamicConfigurationOptions(option) {
        if (debug_session_options_1.DebugSessionOptions.isDynamic(option)) {
            // Removing an item already present in the list
            const index = this.recentDynamicOptionsTracker.findIndex(item => this.dynamicOptionsMatch(item, option));
            if (index > -1) {
                this.recentDynamicOptionsTracker.splice(index, 1);
            }
            // Adding new item, most recent at the top of the list
            const recentMax = 3;
            if (this.recentDynamicOptionsTracker.unshift(option) > recentMax) {
                // Keep the latest 3 dynamic configuration options to not clutter the dropdown.
                this.recentDynamicOptionsTracker.splice(recentMax);
            }
        }
    }
    dynamicOptionsMatch(one, other) {
        return one.providerType !== undefined
            && one.configuration.name === other.configuration.name
            && one.providerType === other.providerType
            && one.workspaceFolderUri === other.workspaceFolderUri;
    }
    get recentDynamicOptions() {
        return this.recentDynamicOptionsTracker;
    }
    updateCurrent(options = this._currentOptions) {
        var _a;
        if (debug_session_options_1.DebugSessionOptions.isCompound(options)) {
            this._currentOptions = options && this.find(options.compound, options.workspaceFolderUri);
        }
        else {
            this._currentOptions = options && this.find(options.configuration, options.workspaceFolderUri, options.providerType);
        }
        if (!this._currentOptions) {
            const model = this.getModel();
            if (model) {
                const configuration = model.configurations[0];
                if (configuration) {
                    this._currentOptions = this.configurationToOptions(configuration, model.workspaceFolderUri);
                }
            }
        }
        this.debugConfigurationTypeKey.set(this.current && ((_a = this.current.configuration) === null || _a === void 0 ? void 0 : _a.type));
        this.onDidChangeEmitter.fire(undefined);
    }
    find(nameOrConfigurationOrCompound, workspaceFolderUri, providerType) {
        if (debug_common_1.DebugConfiguration.is(nameOrConfigurationOrCompound) && providerType) {
            // providerType is only applicable to dynamic debug configurations and may only be created if we have a configuration given
            return this.configurationToOptions(nameOrConfigurationOrCompound, workspaceFolderUri, providerType);
        }
        const name = typeof nameOrConfigurationOrCompound === 'string' ? nameOrConfigurationOrCompound : nameOrConfigurationOrCompound.name;
        const configuration = this.findConfiguration(name, workspaceFolderUri);
        if (configuration) {
            return this.configurationToOptions(configuration, workspaceFolderUri);
        }
        const compound = this.findCompound(name, workspaceFolderUri);
        if (compound) {
            return this.compoundToOptions(compound, workspaceFolderUri);
        }
    }
    findConfigurations(name, workspaceFolderUri) {
        const matches = [];
        for (const model of this.models.values()) {
            if (model.workspaceFolderUri === workspaceFolderUri) {
                for (const configuration of model.configurations) {
                    if (configuration.name === name) {
                        matches.push(configuration);
                    }
                }
            }
        }
        return matches;
    }
    findConfiguration(name, workspaceFolderUri) {
        for (const model of this.models.values()) {
            if (model.workspaceFolderUri === workspaceFolderUri) {
                for (const configuration of model.configurations) {
                    if (configuration.name === name) {
                        return configuration;
                    }
                }
            }
        }
    }
    findCompound(name, workspaceFolderUri) {
        for (const model of this.models.values()) {
            if (model.workspaceFolderUri === workspaceFolderUri) {
                for (const compound of model.compounds) {
                    if (compound.name === name) {
                        return compound;
                    }
                }
            }
        }
    }
    async openConfiguration() {
        var _a;
        const currentUri = new uri_1.default((_a = this.current) === null || _a === void 0 ? void 0 : _a.workspaceFolderUri);
        const model = this.getModel(currentUri);
        if (model) {
            await this.doOpen(model);
        }
    }
    configurationToOptions(configuration, workspaceFolderUri, providerType) {
        return { name: configuration.name, configuration, providerType, workspaceFolderUri };
    }
    compoundToOptions(compound, workspaceFolderUri) {
        return { name: compound.name, compound, workspaceFolderUri };
    }
    async addConfiguration() {
        var _a;
        let rootUri = undefined;
        if (this.workspaceService.saved && this.workspaceService.tryGetRoots().length > 1) {
            rootUri = await this.selectRootUri();
            // Do not continue if the user explicitly does not choose a location.
            if (!rootUri) {
                return;
            }
        }
        const model = this.getModel(rootUri);
        if (!model) {
            return;
        }
        const editor = (_a = monaco_editor_1.MonacoEditor.get(await this.doOpen(model))) === null || _a === void 0 ? void 0 : _a.getControl();
        const editorModel = editor && editor.getModel();
        if (!editorModel) {
            return;
        }
        const commandService = standaloneServices_1.StandaloneServices.get(commands_1.ICommandService);
        let position;
        let depthInArray = 0;
        let lastProperty = '';
        (0, jsonc_parser_1.visit)(editor.getValue(), {
            onObjectProperty: property => {
                lastProperty = property;
            },
            onArrayBegin: offset => {
                if (lastProperty === 'configurations' && depthInArray === 0) {
                    position = editorModel.getPositionAt(offset + 1);
                }
                depthInArray++;
            },
            onArrayEnd: () => {
                depthInArray--;
            }
        });
        if (!position) {
            return;
        }
        // Check if there are more characters on a line after a "configurations": [, if yes enter a newline
        if (editorModel.getLineLastNonWhitespaceColumn(position.lineNumber) > position.column) {
            editor.setPosition(position);
            editor.trigger('debug', 'lineBreakInsert', undefined);
        }
        // Check if there is already an empty line to insert suggest, if yes just place the cursor
        if (editorModel.getLineLastNonWhitespaceColumn(position.lineNumber + 1) === 0) {
            editor.setPosition({ lineNumber: position.lineNumber + 1, column: 1 << 30 });
            await commandService.executeCommand('editor.action.deleteLines');
        }
        editor.setPosition(position);
        await commandService.executeCommand('editor.action.insertLineAfter');
        await commandService.executeCommand('editor.action.triggerSuggest');
    }
    async selectRootUri() {
        const workspaceRoots = this.workspaceService.tryGetRoots();
        const items = [];
        for (const workspaceRoot of workspaceRoots) {
            items.push({
                label: this.labelProvider.getName(workspaceRoot.resource),
                description: this.labelProvider.getLongName(workspaceRoot.resource),
                value: workspaceRoot.resource
            });
        }
        const root = await this.quickPickService.show(items, {
            placeholder: core_1.nls.localize('theia/debug/addConfigurationPlaceholder', 'Select workspace root to add configuration to'),
        });
        return root === null || root === void 0 ? void 0 : root.value;
    }
    getModel(uri) {
        const workspaceFolderUri = this.workspaceVariables.getWorkspaceRootUri(uri);
        if (workspaceFolderUri) {
            const key = workspaceFolderUri.toString();
            for (const model of this.models.values()) {
                if (model.workspaceFolderUri === key) {
                    return model;
                }
            }
        }
        for (const model of this.models.values()) {
            if (model.uri) {
                return model;
            }
        }
        return this.models.values().next().value;
    }
    async doOpen(model) {
        const uri = await this.doCreate(model);
        return this.editorManager.open(uri, {
            mode: 'activate'
        });
    }
    async doCreate(model) {
        var _a;
        const uri = (_a = model.uri) !== null && _a !== void 0 ? _a : this.preferences.getConfigUri(browser_2.PreferenceScope.Folder, model.workspaceFolderUri, 'launch');
        if (!uri) { // Since we are requesting information about a known workspace folder, this should never happen.
            throw new Error('PreferenceService.getConfigUri has returned undefined when a URI was expected.');
        }
        const settingsUri = this.preferences.getConfigUri(browser_2.PreferenceScope.Folder, model.workspaceFolderUri);
        // Users may have placed their debug configurations in a `settings.json`, in which case we shouldn't modify the file.
        if (settingsUri && !uri.isEqual(settingsUri)) {
            await this.ensureContent(uri, model);
        }
        return uri;
    }
    /**
     * Checks whether a `launch.json` file contains the minimum necessary content.
     * If content not found, provides content and populates the file using Monaco.
     */
    async ensureContent(uri, model) {
        const textModel = await this.textModelService.createModelReference(uri);
        const currentContent = textModel.object.valid ? textModel.object.getText() : '';
        try { // Look for the minimal well-formed launch.json content: {configurations: []}
            const parsedContent = (0, jsonc_parser_1.parse)(currentContent);
            if (Array.isArray(parsedContent.configurations)) {
                return;
            }
        }
        catch {
            // Just keep going
        }
        const debugType = await this.selectDebugType();
        const configurations = debugType ? await this.provideDebugConfigurations(debugType, model.workspaceFolderUri) : [];
        const content = this.getInitialConfigurationContent(configurations);
        textModel.object.textEditorModel.setValue(content); // Will clobber anything the user has entered!
        await textModel.object.save();
    }
    async provideDebugConfigurations(debugType, workspaceFolderUri) {
        await this.fireWillProvideDebugConfiguration();
        return this.debug.provideDebugConfigurations(debugType, workspaceFolderUri);
    }
    async fireWillProvideDebugConfiguration() {
        await event_1.WaitUntilEvent.fire(this.onWillProvideDebugConfigurationEmitter, {});
    }
    async provideDynamicDebugConfigurations() {
        await this.fireWillProvideDynamicDebugConfiguration();
        const roots = this.workspaceService.tryGetRoots();
        const promises = roots.map(async (root) => {
            const configsMap = await this.debug.provideDynamicDebugConfigurations(root.resource.toString());
            const optionsMap = Object.fromEntries(Object.entries(configsMap).map(([type, configs]) => {
                const options = configs.map(config => ({
                    name: config.name,
                    providerType: type,
                    configuration: config,
                    workspaceFolderUri: root.resource.toString()
                }));
                return [type, options];
            }));
            return optionsMap;
        });
        const typesToOptionsRecords = await Promise.all(promises);
        const consolidatedTypesToOptions = {};
        for (const typesToOptionsInstance of typesToOptionsRecords) {
            for (const [providerType, configurationsOptions] of Object.entries(typesToOptionsInstance)) {
                if (!consolidatedTypesToOptions[providerType]) {
                    consolidatedTypesToOptions[providerType] = [];
                }
                consolidatedTypesToOptions[providerType].push(...configurationsOptions);
            }
        }
        return consolidatedTypesToOptions;
    }
    async fetchDynamicDebugConfiguration(name, type, folder) {
        await this.fireWillProvideDynamicDebugConfiguration();
        return this.debug.fetchDynamicDebugConfiguration(name, type, folder);
    }
    async fireWillProvideDynamicDebugConfiguration() {
        await this.initialized;
        await event_1.WaitUntilEvent.fire(this.onWillProvideDynamicDebugConfigurationEmitter, {});
    }
    getInitialConfigurationContent(initialConfigurations) {
        return `{
  // Use IntelliSense to learn about possible attributes.
  // Hover to view descriptions of existing attributes.
  "version": "0.2.0",
  "configurations": ${JSON.stringify(initialConfigurations, undefined, '  ').split('\n').map(line => '  ' + line).join('\n').trim()}
}
`;
    }
    async selectDebugType() {
        const widget = this.editorManager.currentEditor;
        if (!widget) {
            return undefined;
        }
        const { languageId } = widget.editor.document;
        const debuggers = await this.debug.getDebuggersForLanguage(languageId);
        if (debuggers.length === 0) {
            return undefined;
        }
        const items = debuggers.map(({ label, type }) => ({ label, value: type }));
        const selectedItem = await this.quickPickService.show(items, { placeholder: 'Select Environment' });
        return selectedItem === null || selectedItem === void 0 ? void 0 : selectedItem.value;
    }
    async load() {
        var _a, _b;
        await this.initialized;
        const data = await this.storage.getData('debug.configurations', {});
        this.resolveRecentDynamicOptionsFromData(data.recentDynamicOptions);
        // Between versions v1.26 and v1.27, the expected format of the data changed so that old stored data
        // may not contain the configuration key.
        if (debug_session_options_1.DebugSessionOptions.isConfiguration(data.current)) {
            // ensure options name is reflected from old configurations data
            data.current.name = (_a = data.current.name) !== null && _a !== void 0 ? _a : (_b = data.current.configuration) === null || _b === void 0 ? void 0 : _b.name;
            this.current = this.find(data.current.configuration, data.current.workspaceFolderUri, data.current.providerType);
        }
        else if (debug_session_options_1.DebugSessionOptions.isCompound(data.current)) {
            this.current = this.find(data.current.name, data.current.workspaceFolderUri);
        }
    }
    resolveRecentDynamicOptionsFromData(options) {
        if (!options || this.recentDynamicOptionsTracker.length !== 0) {
            return;
        }
        // ensure options name is reflected from old configurations data
        const dynamicOptions = options.map(option => {
            var _a;
            option.name = (_a = option.name) !== null && _a !== void 0 ? _a : option.configuration.name;
            return option;
        }).filter(debug_session_options_1.DebugSessionOptions.isDynamic);
        this.recentDynamicOptionsTracker = dynamicOptions;
    }
    save() {
        const data = {};
        const { current, recentDynamicOptionsTracker } = this;
        if (current) {
            data.current = current;
        }
        if (this.recentDynamicOptionsTracker.length > 0) {
            data.recentDynamicOptions = recentDynamicOptionsTracker;
        }
        if (Object.keys(data).length > 0) {
            this.storage.setData('debug.configurations', data);
        }
    }
};
exports.DebugConfigurationManager = DebugConfigurationManager;
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], DebugConfigurationManager.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.EditorManager),
    tslib_1.__metadata("design:type", browser_1.EditorManager)
], DebugConfigurationManager.prototype, "editorManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_service_1.DebugService),
    tslib_1.__metadata("design:type", Object)
], DebugConfigurationManager.prototype, "debug", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(quick_pick_service_1.QuickPickService),
    tslib_1.__metadata("design:type", Object)
], DebugConfigurationManager.prototype, "quickPickService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    tslib_1.__metadata("design:type", Object)
], DebugConfigurationManager.prototype, "contextKeyService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.LabelProvider),
    tslib_1.__metadata("design:type", browser_2.LabelProvider)
], DebugConfigurationManager.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(monaco_text_model_service_1.MonacoTextModelService),
    tslib_1.__metadata("design:type", monaco_text_model_service_1.MonacoTextModelService)
], DebugConfigurationManager.prototype, "textModelService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], DebugConfigurationManager.prototype, "preferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_configurations_1.PreferenceConfigurations),
    tslib_1.__metadata("design:type", preference_configurations_1.PreferenceConfigurations)
], DebugConfigurationManager.prototype, "preferenceConfigurations", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_variable_contribution_1.WorkspaceVariableContribution),
    tslib_1.__metadata("design:type", workspace_variable_contribution_1.WorkspaceVariableContribution)
], DebugConfigurationManager.prototype, "workspaceVariables", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugConfigurationManager.prototype, "init", null);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.StorageService),
    tslib_1.__metadata("design:type", Object)
], DebugConfigurationManager.prototype, "storage", void 0);
exports.DebugConfigurationManager = DebugConfigurationManager = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugConfigurationManager);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/debug-configuration-model.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/debug-configuration-model.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugConfigurationModel = void 0;
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "../../node_modules/@theia/core/lib/common/event.js");
const disposable_1 = __webpack_require__(/*! @theia/core/lib/common/disposable */ "../../node_modules/@theia/core/lib/common/disposable.js");
const debug_common_1 = __webpack_require__(/*! ../common/debug-common */ "../../node_modules/@theia/debug/lib/common/debug-common.js");
const debug_compound_1 = __webpack_require__(/*! ../common/debug-compound */ "../../node_modules/@theia/debug/lib/common/debug-compound.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
class DebugConfigurationModel {
    constructor(workspaceFolderUri, preferences) {
        this.workspaceFolderUri = workspaceFolderUri;
        this.preferences = preferences;
        this.onDidChangeEmitter = new event_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
        this.toDispose = new disposable_1.DisposableCollection(this.onDidChangeEmitter);
        this.reconcile();
        this.toDispose.push(this.preferences.onPreferenceChanged(e => {
            if (e.preferenceName === 'launch' && e.affects(workspaceFolderUri)) {
                this.reconcile();
            }
        }));
    }
    get uri() {
        return this.json.uri;
    }
    dispose() {
        this.toDispose.dispose();
    }
    get onDispose() {
        return this.toDispose.onDispose;
    }
    get configurations() {
        return this.json.configurations;
    }
    get compounds() {
        return this.json.compounds;
    }
    async reconcile() {
        this.json = this.parseConfigurations();
        this.onDidChangeEmitter.fire(undefined);
    }
    parseConfigurations() {
        const configurations = [];
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        const { configUri, value } = this.preferences.resolve('launch', undefined, this.workspaceFolderUri);
        if ((0, common_1.isObject)(value) && Array.isArray(value.configurations)) {
            for (const configuration of value.configurations) {
                if (debug_common_1.DebugConfiguration.is(configuration)) {
                    configurations.push(configuration);
                }
            }
        }
        const compounds = [];
        if ((0, common_1.isObject)(value) && Array.isArray(value.compounds)) {
            for (const compound of value.compounds) {
                if (debug_compound_1.DebugCompound.is(compound)) {
                    compounds.push(compound);
                }
            }
        }
        return { uri: configUri, configurations, compounds };
    }
}
exports.DebugConfigurationModel = DebugConfigurationModel;


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/debug-contribution.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/debug-contribution.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2021 SAP SE or an SAP affiliate company and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugContribution = void 0;
exports.DebugContribution = Symbol('DebugContribution');


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/debug-frontend-application-contribution.js":
/*!**********************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/debug-frontend-application-contribution.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugFrontendApplicationContribution = exports.DebugBreakpointWidgetCommands = exports.DebugEditorContextCommands = exports.DebugSessionContextCommands = exports.DebugThreadContextCommands = exports.DebugCommands = exports.DebugMenus = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_2 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const debug_session_manager_1 = __webpack_require__(/*! ./debug-session-manager */ "../../node_modules/@theia/debug/lib/browser/debug-session-manager.js");
const debug_widget_1 = __webpack_require__(/*! ./view/debug-widget */ "../../node_modules/@theia/debug/lib/browser/view/debug-widget.js");
const breakpoint_marker_1 = __webpack_require__(/*! ./breakpoint/breakpoint-marker */ "../../node_modules/@theia/debug/lib/browser/breakpoint/breakpoint-marker.js");
const breakpoint_manager_1 = __webpack_require__(/*! ./breakpoint/breakpoint-manager */ "../../node_modules/@theia/debug/lib/browser/breakpoint/breakpoint-manager.js");
const debug_configuration_manager_1 = __webpack_require__(/*! ./debug-configuration-manager */ "../../node_modules/@theia/debug/lib/browser/debug-configuration-manager.js");
const debug_session_1 = __webpack_require__(/*! ./debug-session */ "../../node_modules/@theia/debug/lib/browser/debug-session.js");
const debug_breakpoints_widget_1 = __webpack_require__(/*! ./view/debug-breakpoints-widget */ "../../node_modules/@theia/debug/lib/browser/view/debug-breakpoints-widget.js");
const debug_source_breakpoint_1 = __webpack_require__(/*! ./model/debug-source-breakpoint */ "../../node_modules/@theia/debug/lib/browser/model/debug-source-breakpoint.js");
const debug_threads_widget_1 = __webpack_require__(/*! ./view/debug-threads-widget */ "../../node_modules/@theia/debug/lib/browser/view/debug-threads-widget.js");
const debug_thread_1 = __webpack_require__(/*! ./model/debug-thread */ "../../node_modules/@theia/debug/lib/browser/model/debug-thread.js");
const debug_stack_frames_widget_1 = __webpack_require__(/*! ./view/debug-stack-frames-widget */ "../../node_modules/@theia/debug/lib/browser/view/debug-stack-frames-widget.js");
const debug_stack_frame_1 = __webpack_require__(/*! ./model/debug-stack-frame */ "../../node_modules/@theia/debug/lib/browser/model/debug-stack-frame.js");
const debug_variables_widget_1 = __webpack_require__(/*! ./view/debug-variables-widget */ "../../node_modules/@theia/debug/lib/browser/view/debug-variables-widget.js");
const debug_console_items_1 = __webpack_require__(/*! ./console/debug-console-items */ "../../node_modules/@theia/debug/lib/browser/console/debug-console-items.js");
const debug_editor_model_1 = __webpack_require__(/*! ./editor/debug-editor-model */ "../../node_modules/@theia/debug/lib/browser/editor/debug-editor-model.js");
const debug_editor_service_1 = __webpack_require__(/*! ./editor/debug-editor-service */ "../../node_modules/@theia/debug/lib/browser/editor/debug-editor-service.js");
const debug_console_contribution_1 = __webpack_require__(/*! ./console/debug-console-contribution */ "../../node_modules/@theia/debug/lib/browser/console/debug-console-contribution.js");
const debug_service_1 = __webpack_require__(/*! ../common/debug-service */ "../../node_modules/@theia/debug/lib/common/debug-service.js");
const debug_schema_updater_1 = __webpack_require__(/*! ./debug-schema-updater */ "../../node_modules/@theia/debug/lib/browser/debug-schema-updater.js");
const debug_preferences_1 = __webpack_require__(/*! ./debug-preferences */ "../../node_modules/@theia/debug/lib/browser/debug-preferences.js");
const debug_watch_widget_1 = __webpack_require__(/*! ./view/debug-watch-widget */ "../../node_modules/@theia/debug/lib/browser/view/debug-watch-widget.js");
const debug_watch_expression_1 = __webpack_require__(/*! ./view/debug-watch-expression */ "../../node_modules/@theia/debug/lib/browser/view/debug-watch-expression.js");
const debug_watch_manager_1 = __webpack_require__(/*! ./debug-watch-manager */ "../../node_modules/@theia/debug/lib/browser/debug-watch-manager.js");
const debug_function_breakpoint_1 = __webpack_require__(/*! ./model/debug-function-breakpoint */ "../../node_modules/@theia/debug/lib/browser/model/debug-function-breakpoint.js");
const debug_breakpoint_1 = __webpack_require__(/*! ./model/debug-breakpoint */ "../../node_modules/@theia/debug/lib/browser/model/debug-breakpoint.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const debug_instruction_breakpoint_1 = __webpack_require__(/*! ./model/debug-instruction-breakpoint */ "../../node_modules/@theia/debug/lib/browser/model/debug-instruction-breakpoint.js");
const debug_exception_breakpoint_1 = __webpack_require__(/*! ./view/debug-exception-breakpoint */ "../../node_modules/@theia/debug/lib/browser/view/debug-exception-breakpoint.js");
var DebugMenus;
(function (DebugMenus) {
    DebugMenus.DEBUG = [...common_1.MAIN_MENU_BAR, '6_debug'];
    DebugMenus.DEBUG_CONTROLS = [...DebugMenus.DEBUG, 'a_controls'];
    DebugMenus.DEBUG_CONFIGURATION = [...DebugMenus.DEBUG, 'b_configuration'];
    DebugMenus.DEBUG_THREADS = [...DebugMenus.DEBUG, 'c_threads'];
    DebugMenus.DEBUG_SESSIONS = [...DebugMenus.DEBUG, 'd_sessions'];
    DebugMenus.DEBUG_BREAKPOINT = [...DebugMenus.DEBUG, 'e_breakpoint'];
    DebugMenus.DEBUG_NEW_BREAKPOINT = [...DebugMenus.DEBUG_BREAKPOINT, 'a_new_breakpoint'];
    DebugMenus.DEBUG_BREAKPOINTS = [...DebugMenus.DEBUG, 'f_breakpoints'];
})(DebugMenus || (exports.DebugMenus = DebugMenus = {}));
function nlsEditBreakpoint(breakpoint) {
    return nls_1.nls.localizeByDefault('Edit {0}...', nls_1.nls.localizeByDefault(breakpoint));
}
function nlsRemoveBreakpoint(breakpoint) {
    return nls_1.nls.localizeByDefault('Remove {0}', nls_1.nls.localizeByDefault(breakpoint));
}
function nlsEnableBreakpoint(breakpoint) {
    return nls_1.nls.localizeByDefault('Enable {0}', nls_1.nls.localizeByDefault(breakpoint));
}
function nlsDisableBreakpoint(breakpoint) {
    return nls_1.nls.localizeByDefault('Disable {0}', nls_1.nls.localizeByDefault(breakpoint));
}
var DebugCommands;
(function (DebugCommands) {
    DebugCommands.DEBUG_CATEGORY = 'Debug';
    DebugCommands.DEBUG_CATEGORY_KEY = nls_1.nls.getDefaultKey(DebugCommands.DEBUG_CATEGORY);
    DebugCommands.START = common_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.debug.start',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Start Debugging',
        iconClass: (0, browser_1.codicon)('debug-alt')
    });
    DebugCommands.START_NO_DEBUG = common_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.debug.run',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Start Without Debugging'
    });
    DebugCommands.STOP = common_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.debug.stop',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Stop',
        iconClass: (0, browser_1.codicon)('debug-stop')
    });
    DebugCommands.RESTART = common_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.debug.restart',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Restart',
    });
    DebugCommands.OPEN_CONFIGURATIONS = common_1.Command.toDefaultLocalizedCommand({
        id: 'debug.configurations.open',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Open Configurations'
    });
    DebugCommands.ADD_CONFIGURATION = common_1.Command.toDefaultLocalizedCommand({
        id: 'debug.configurations.add',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Add Configuration...'
    });
    DebugCommands.STEP_OVER = common_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.debug.stepOver',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Step Over',
        iconClass: (0, browser_1.codicon)('debug-step-over')
    });
    DebugCommands.STEP_INTO = common_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.debug.stepInto',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Step Into',
        iconClass: (0, browser_1.codicon)('debug-step-into')
    });
    DebugCommands.STEP_OUT = common_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.debug.stepOut',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Step Out',
        iconClass: (0, browser_1.codicon)('debug-step-out')
    });
    DebugCommands.CONTINUE = common_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.debug.continue',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Continue',
        iconClass: (0, browser_1.codicon)('debug-continue')
    });
    DebugCommands.PAUSE = common_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.debug.pause',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Pause',
        iconClass: (0, browser_1.codicon)('debug-pause')
    });
    DebugCommands.CONTINUE_ALL = common_1.Command.toLocalizedCommand({
        id: 'debug.thread.continue.all',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Continue All',
        iconClass: (0, browser_1.codicon)('debug-continue')
    }, 'theia/debug/continueAll', DebugCommands.DEBUG_CATEGORY_KEY);
    DebugCommands.PAUSE_ALL = common_1.Command.toLocalizedCommand({
        id: 'debug.thread.pause.all',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Pause All',
        iconClass: (0, browser_1.codicon)('debug-pause')
    }, 'theia/debug/pauseAll', DebugCommands.DEBUG_CATEGORY_KEY);
    DebugCommands.TOGGLE_BREAKPOINT = common_1.Command.toDefaultLocalizedCommand({
        id: 'editor.debug.action.toggleBreakpoint',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Toggle Breakpoint',
    });
    DebugCommands.INLINE_BREAKPOINT = common_1.Command.toDefaultLocalizedCommand({
        id: 'editor.debug.action.inlineBreakpoint',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Inline Breakpoint',
    });
    DebugCommands.ADD_CONDITIONAL_BREAKPOINT = common_1.Command.toDefaultLocalizedCommand({
        id: 'debug.breakpoint.add.conditional',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Add Conditional Breakpoint...',
    });
    DebugCommands.ADD_LOGPOINT = common_1.Command.toDefaultLocalizedCommand({
        id: 'debug.breakpoint.add.logpoint',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Add Logpoint...',
    });
    DebugCommands.ADD_FUNCTION_BREAKPOINT = common_1.Command.toDefaultLocalizedCommand({
        id: 'debug.breakpoint.add.function',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Add Function Breakpoint',
    });
    DebugCommands.ENABLE_ALL_BREAKPOINTS = common_1.Command.toDefaultLocalizedCommand({
        id: 'debug.breakpoint.enableAll',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Enable All Breakpoints',
    });
    DebugCommands.DISABLE_ALL_BREAKPOINTS = common_1.Command.toDefaultLocalizedCommand({
        id: 'debug.breakpoint.disableAll',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Disable All Breakpoints',
    });
    DebugCommands.EDIT_BREAKPOINT = common_1.Command.toLocalizedCommand({
        id: 'debug.breakpoint.edit',
        category: DebugCommands.DEBUG_CATEGORY,
        originalLabel: 'Edit Breakpoint...',
        label: nlsEditBreakpoint('Breakpoint')
    }, '', DebugCommands.DEBUG_CATEGORY_KEY);
    DebugCommands.EDIT_LOGPOINT = common_1.Command.toLocalizedCommand({
        id: 'debug.logpoint.edit',
        category: DebugCommands.DEBUG_CATEGORY,
        originalLabel: 'Edit Logpoint...',
        label: nlsEditBreakpoint('Logpoint')
    }, '', DebugCommands.DEBUG_CATEGORY_KEY);
    DebugCommands.EDIT_BREAKPOINT_CONDITION = common_1.Command.toLocalizedCommand({
        id: 'debug.breakpoint.editCondition',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Edit Condition...'
    }, '', DebugCommands.DEBUG_CATEGORY_KEY);
    DebugCommands.REMOVE_BREAKPOINT = common_1.Command.toLocalizedCommand({
        id: 'debug.breakpoint.remove',
        category: DebugCommands.DEBUG_CATEGORY,
        originalLabel: 'Remove Breakpoint',
        label: nlsRemoveBreakpoint('Breakpoint')
    }, '', DebugCommands.DEBUG_CATEGORY_KEY);
    DebugCommands.REMOVE_LOGPOINT = common_1.Command.toLocalizedCommand({
        id: 'debug.logpoint.remove',
        category: DebugCommands.DEBUG_CATEGORY,
        originalLabel: 'Remove Logpoint',
        label: nlsRemoveBreakpoint('Logpoint')
    }, '', DebugCommands.DEBUG_CATEGORY_KEY);
    DebugCommands.REMOVE_ALL_BREAKPOINTS = common_1.Command.toDefaultLocalizedCommand({
        id: 'debug.breakpoint.removeAll',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Remove All Breakpoints',
    });
    DebugCommands.TOGGLE_BREAKPOINTS_ENABLED = common_1.Command.toLocalizedCommand({
        id: 'debug.breakpoint.toggleEnabled'
    });
    DebugCommands.SHOW_HOVER = common_1.Command.toDefaultLocalizedCommand({
        id: 'editor.debug.action.showDebugHover',
        label: 'Debug: Show Hover'
    });
    DebugCommands.JUMP_TO_CURSOR = common_1.Command.toDefaultLocalizedCommand({
        id: 'editor.debug.action.jumpToCursor',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Jump to Cursor'
    });
    DebugCommands.RESTART_FRAME = common_1.Command.toDefaultLocalizedCommand({
        id: 'debug.frame.restart',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Restart Frame',
    });
    DebugCommands.COPY_CALL_STACK = common_1.Command.toDefaultLocalizedCommand({
        id: 'debug.callStack.copy',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Copy Call Stack',
    });
    DebugCommands.SET_VARIABLE_VALUE = common_1.Command.toDefaultLocalizedCommand({
        id: 'debug.variable.setValue',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Set Value',
    });
    DebugCommands.COPY_VARIABLE_VALUE = common_1.Command.toDefaultLocalizedCommand({
        id: 'debug.variable.copyValue',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Copy Value',
    });
    DebugCommands.COPY_VARIABLE_AS_EXPRESSION = common_1.Command.toDefaultLocalizedCommand({
        id: 'debug.variable.copyAsExpression',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Copy as Expression',
    });
    DebugCommands.WATCH_VARIABLE = common_1.Command.toDefaultLocalizedCommand({
        id: 'debug.variable.watch',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Add to Watch',
    });
    DebugCommands.ADD_WATCH_EXPRESSION = common_1.Command.toDefaultLocalizedCommand({
        id: 'debug.watch.addExpression',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Add Expression'
    });
    DebugCommands.EDIT_WATCH_EXPRESSION = common_1.Command.toDefaultLocalizedCommand({
        id: 'debug.watch.editExpression',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Edit Expression'
    });
    DebugCommands.COPY_WATCH_EXPRESSION_VALUE = common_1.Command.toLocalizedCommand({
        id: 'debug.watch.copyExpressionValue',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Copy Expression Value'
    }, 'theia/debug/copyExpressionValue', DebugCommands.DEBUG_CATEGORY_KEY);
    DebugCommands.REMOVE_WATCH_EXPRESSION = common_1.Command.toDefaultLocalizedCommand({
        id: 'debug.watch.removeExpression',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Remove Expression'
    });
    DebugCommands.COLLAPSE_ALL_WATCH_EXPRESSIONS = common_1.Command.toDefaultLocalizedCommand({
        id: 'debug.watch.collapseAllExpressions',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Collapse All'
    });
    DebugCommands.REMOVE_ALL_WATCH_EXPRESSIONS = common_1.Command.toDefaultLocalizedCommand({
        id: 'debug.watch.removeAllExpressions',
        category: DebugCommands.DEBUG_CATEGORY,
        label: 'Remove All Expressions'
    });
})(DebugCommands || (exports.DebugCommands = DebugCommands = {}));
var DebugThreadContextCommands;
(function (DebugThreadContextCommands) {
    DebugThreadContextCommands.STEP_OVER = {
        id: 'debug.thread.context.context.next'
    };
    DebugThreadContextCommands.STEP_INTO = {
        id: 'debug.thread.context.stepin'
    };
    DebugThreadContextCommands.STEP_OUT = {
        id: 'debug.thread.context.stepout'
    };
    DebugThreadContextCommands.CONTINUE = {
        id: 'debug.thread.context.continue'
    };
    DebugThreadContextCommands.PAUSE = {
        id: 'debug.thread.context.pause'
    };
    DebugThreadContextCommands.TERMINATE = {
        id: 'debug.thread.context.terminate'
    };
})(DebugThreadContextCommands || (exports.DebugThreadContextCommands = DebugThreadContextCommands = {}));
var DebugSessionContextCommands;
(function (DebugSessionContextCommands) {
    DebugSessionContextCommands.STOP = {
        id: 'debug.session.context.stop'
    };
    DebugSessionContextCommands.RESTART = {
        id: 'debug.session.context.restart'
    };
    DebugSessionContextCommands.PAUSE_ALL = {
        id: 'debug.session.context.pauseAll'
    };
    DebugSessionContextCommands.CONTINUE_ALL = {
        id: 'debug.session.context.continueAll'
    };
    DebugSessionContextCommands.REVEAL = {
        id: 'debug.session.context.reveal'
    };
})(DebugSessionContextCommands || (exports.DebugSessionContextCommands = DebugSessionContextCommands = {}));
var DebugEditorContextCommands;
(function (DebugEditorContextCommands) {
    DebugEditorContextCommands.ADD_BREAKPOINT = {
        id: 'debug.editor.context.addBreakpoint'
    };
    DebugEditorContextCommands.ADD_CONDITIONAL_BREAKPOINT = {
        id: 'debug.editor.context.addBreakpoint.conditional'
    };
    DebugEditorContextCommands.ADD_LOGPOINT = {
        id: 'debug.editor.context.add.logpoint'
    };
    DebugEditorContextCommands.REMOVE_BREAKPOINT = {
        id: 'debug.editor.context.removeBreakpoint'
    };
    DebugEditorContextCommands.EDIT_BREAKPOINT = {
        id: 'debug.editor.context.edit.breakpoint'
    };
    DebugEditorContextCommands.ENABLE_BREAKPOINT = {
        id: 'debug.editor.context.enableBreakpoint'
    };
    DebugEditorContextCommands.DISABLE_BREAKPOINT = {
        id: 'debug.editor.context.disableBreakpoint'
    };
    DebugEditorContextCommands.REMOVE_LOGPOINT = {
        id: 'debug.editor.context.logpoint.remove'
    };
    DebugEditorContextCommands.EDIT_LOGPOINT = {
        id: 'debug.editor.context.logpoint.edit'
    };
    DebugEditorContextCommands.ENABLE_LOGPOINT = {
        id: 'debug.editor.context.logpoint.enable'
    };
    DebugEditorContextCommands.DISABLE_LOGPOINT = {
        id: 'debug.editor.context.logpoint.disable'
    };
    DebugEditorContextCommands.JUMP_TO_CURSOR = {
        id: 'debug.editor.context.jumpToCursor'
    };
})(DebugEditorContextCommands || (exports.DebugEditorContextCommands = DebugEditorContextCommands = {}));
var DebugBreakpointWidgetCommands;
(function (DebugBreakpointWidgetCommands) {
    DebugBreakpointWidgetCommands.ACCEPT = {
        id: 'debug.breakpointWidget.accept'
    };
    DebugBreakpointWidgetCommands.CLOSE = {
        id: 'debug.breakpointWidget.close'
    };
})(DebugBreakpointWidgetCommands || (exports.DebugBreakpointWidgetCommands = DebugBreakpointWidgetCommands = {}));
let DebugFrontendApplicationContribution = class DebugFrontendApplicationContribution extends browser_1.AbstractViewContribution {
    constructor() {
        super({
            widgetId: debug_widget_1.DebugWidget.ID,
            widgetName: debug_widget_1.DebugWidget.LABEL,
            defaultWidgetOptions: {
                area: 'left',
                rank: 400
            },
            toggleCommandId: 'debug:toggle',
            toggleKeybinding: 'ctrlcmd+shift+d'
        });
        this.firstSessionStart = true;
    }
    async initializeLayout() {
        await this.openView();
    }
    async onStart() {
        this.manager.onDidCreateDebugSession(session => this.openSession(session, { reveal: false }));
        this.manager.onDidStartDebugSession(session => {
            const { noDebug } = session.configuration;
            const openDebug = session.configuration.openDebug || this.preference['debug.openDebug'];
            const internalConsoleOptions = session.configuration.internalConsoleOptions || this.preference['debug.internalConsoleOptions'];
            if (internalConsoleOptions === 'openOnSessionStart' ||
                (internalConsoleOptions === 'openOnFirstSessionStart' && this.firstSessionStart)) {
                this.console.openView({
                    reveal: true,
                    activate: false,
                });
            }
            const shouldOpenDebug = openDebug === 'openOnSessionStart' || (openDebug === 'openOnFirstSessionStart' && this.firstSessionStart);
            // Do not open debug view when suppressed via configuration
            if (!noDebug && !this.getOption(session, 'suppressDebugView') && shouldOpenDebug) {
                this.openSession(session);
            }
            this.firstSessionStart = false;
        });
        this.manager.onDidStopDebugSession(session => {
            const { openDebug } = session.configuration;
            if (!this.getOption(session, 'suppressDebugView') && openDebug === 'openOnDebugBreak') {
                this.openSession(session);
            }
        });
        this.updateStatusBar();
        this.manager.onDidChange(() => this.updateStatusBar());
        this.schemaUpdater.update();
        this.configurations.load();
        this.breakpointManager.load();
        this.watchManager.load();
    }
    onStop() {
        this.configurations.save();
        this.breakpointManager.save();
        this.watchManager.save();
    }
    onWillStop() {
        if (this.preference['debug.confirmOnExit'] === 'always' && this.manager.currentSession) {
            return {
                reason: 'active-debug-sessions',
                action: async () => {
                    if (this.manager.currentSession) {
                        const msg = this.manager.sessions.length === 1
                            ? nls_1.nls.localizeByDefault('There is an active debug session, are you sure you want to stop it?')
                            : nls_1.nls.localizeByDefault('There are active debug sessions, are you sure you want to stop them?');
                        const safeToExit = await new browser_1.ConfirmDialog({
                            title: '',
                            msg,
                            ok: nls_1.nls.localizeByDefault('Stop Debugging'),
                            cancel: browser_1.Dialog.CANCEL,
                        }).open();
                        return safeToExit === true;
                    }
                    return true;
                },
            };
        }
    }
    registerMenus(menus) {
        super.registerMenus(menus);
        const registerMenuActions = (menuPath, ...commands) => {
            for (const [index, command] of commands.entries()) {
                const label = command.label;
                const debug = `${DebugCommands.DEBUG_CATEGORY}:`;
                menus.registerMenuAction(menuPath, {
                    commandId: command.id,
                    label: label && label.startsWith(debug) && label.slice(debug.length).trimStart() || label,
                    icon: command.iconClass,
                    order: String.fromCharCode('a'.charCodeAt(0) + index)
                });
            }
        };
        menus.registerSubmenu(DebugMenus.DEBUG, nls_1.nls.localizeByDefault('Run'));
        registerMenuActions(DebugMenus.DEBUG_CONTROLS, DebugCommands.START, DebugCommands.START_NO_DEBUG, DebugCommands.STOP, DebugCommands.RESTART);
        registerMenuActions(DebugMenus.DEBUG_CONFIGURATION, DebugCommands.OPEN_CONFIGURATIONS, DebugCommands.ADD_CONFIGURATION);
        registerMenuActions(DebugMenus.DEBUG_THREADS, DebugCommands.CONTINUE, DebugCommands.STEP_OVER, DebugCommands.STEP_INTO, DebugCommands.STEP_OUT, DebugCommands.PAUSE);
        registerMenuActions(DebugMenus.DEBUG_SESSIONS, DebugCommands.CONTINUE_ALL, DebugCommands.PAUSE_ALL);
        registerMenuActions(DebugMenus.DEBUG_BREAKPOINT, DebugCommands.TOGGLE_BREAKPOINT);
        menus.registerSubmenu(DebugMenus.DEBUG_NEW_BREAKPOINT, nls_1.nls.localizeByDefault('New Breakpoint'));
        registerMenuActions(DebugMenus.DEBUG_NEW_BREAKPOINT, DebugCommands.ADD_CONDITIONAL_BREAKPOINT, DebugCommands.INLINE_BREAKPOINT, DebugCommands.ADD_FUNCTION_BREAKPOINT, DebugCommands.ADD_LOGPOINT);
        registerMenuActions(DebugMenus.DEBUG_BREAKPOINTS, DebugCommands.ENABLE_ALL_BREAKPOINTS, DebugCommands.DISABLE_ALL_BREAKPOINTS, DebugCommands.REMOVE_ALL_BREAKPOINTS);
        registerMenuActions(debug_threads_widget_1.DebugThreadsWidget.CONTROL_MENU, { ...DebugCommands.PAUSE, ...DebugThreadContextCommands.PAUSE }, { ...DebugCommands.CONTINUE, ...DebugThreadContextCommands.CONTINUE }, { ...DebugCommands.STEP_OVER, ...DebugThreadContextCommands.STEP_OVER }, { ...DebugCommands.STEP_INTO, ...DebugThreadContextCommands.STEP_INTO }, { ...DebugCommands.STEP_OUT, ...DebugThreadContextCommands.STEP_OUT }, { ...DebugCommands.PAUSE_ALL, ...DebugSessionContextCommands.PAUSE_ALL }, { ...DebugCommands.CONTINUE_ALL, ...DebugSessionContextCommands.CONTINUE_ALL });
        registerMenuActions(debug_threads_widget_1.DebugThreadsWidget.TERMINATE_MENU, { ...DebugCommands.RESTART, ...DebugSessionContextCommands.RESTART }, { ...DebugCommands.STOP, ...DebugSessionContextCommands.STOP }, { ...DebugThreadContextCommands.TERMINATE, label: nls_1.nls.localizeByDefault('Terminate Thread') });
        registerMenuActions(debug_threads_widget_1.DebugThreadsWidget.OPEN_MENU, { ...DebugSessionContextCommands.REVEAL, label: nls_1.nls.localize('theia/debug/reveal', 'Reveal') });
        registerMenuActions(debug_stack_frames_widget_1.DebugStackFramesWidget.CONTEXT_MENU, DebugCommands.RESTART_FRAME, DebugCommands.COPY_CALL_STACK);
        registerMenuActions(debug_variables_widget_1.DebugVariablesWidget.EDIT_MENU, DebugCommands.SET_VARIABLE_VALUE, DebugCommands.COPY_VARIABLE_VALUE, DebugCommands.COPY_VARIABLE_AS_EXPRESSION);
        registerMenuActions(debug_variables_widget_1.DebugVariablesWidget.WATCH_MENU, DebugCommands.WATCH_VARIABLE);
        registerMenuActions(debug_watch_widget_1.DebugWatchWidget.EDIT_MENU, DebugCommands.EDIT_WATCH_EXPRESSION, DebugCommands.COPY_WATCH_EXPRESSION_VALUE);
        registerMenuActions(debug_watch_widget_1.DebugWatchWidget.REMOVE_MENU, DebugCommands.REMOVE_WATCH_EXPRESSION, DebugCommands.REMOVE_ALL_WATCH_EXPRESSIONS);
        registerMenuActions(debug_breakpoints_widget_1.DebugBreakpointsWidget.EDIT_MENU, DebugCommands.EDIT_BREAKPOINT, DebugCommands.EDIT_LOGPOINT, DebugCommands.EDIT_BREAKPOINT_CONDITION);
        registerMenuActions(debug_breakpoints_widget_1.DebugBreakpointsWidget.REMOVE_MENU, DebugCommands.REMOVE_BREAKPOINT, DebugCommands.REMOVE_LOGPOINT, DebugCommands.REMOVE_ALL_BREAKPOINTS);
        registerMenuActions(debug_breakpoints_widget_1.DebugBreakpointsWidget.ENABLE_MENU, DebugCommands.ENABLE_ALL_BREAKPOINTS, DebugCommands.DISABLE_ALL_BREAKPOINTS);
        const DEBUG_EDITOR_CONTEXT_MENU_GROUP = [...browser_2.EDITOR_CONTEXT_MENU, '2_debug'];
        registerMenuActions(DEBUG_EDITOR_CONTEXT_MENU_GROUP, DebugCommands.JUMP_TO_CURSOR);
        registerMenuActions(debug_editor_model_1.DebugEditorModel.CONTEXT_MENU, { ...DebugEditorContextCommands.ADD_BREAKPOINT, label: nls_1.nls.localizeByDefault('Add Breakpoint') }, { ...DebugEditorContextCommands.ADD_CONDITIONAL_BREAKPOINT, label: DebugCommands.ADD_CONDITIONAL_BREAKPOINT.label }, { ...DebugEditorContextCommands.ADD_LOGPOINT, label: DebugCommands.ADD_LOGPOINT.label }, { ...DebugEditorContextCommands.REMOVE_BREAKPOINT, label: DebugCommands.REMOVE_BREAKPOINT.label }, { ...DebugEditorContextCommands.EDIT_BREAKPOINT, label: DebugCommands.EDIT_BREAKPOINT.label }, { ...DebugEditorContextCommands.ENABLE_BREAKPOINT, label: nlsEnableBreakpoint('Breakpoint') }, { ...DebugEditorContextCommands.DISABLE_BREAKPOINT, label: nlsDisableBreakpoint('Breakpoint') }, { ...DebugEditorContextCommands.REMOVE_LOGPOINT, label: DebugCommands.REMOVE_LOGPOINT.label }, { ...DebugEditorContextCommands.EDIT_LOGPOINT, label: DebugCommands.EDIT_LOGPOINT.label }, { ...DebugEditorContextCommands.ENABLE_LOGPOINT, label: nlsEnableBreakpoint('Logpoint') }, { ...DebugEditorContextCommands.DISABLE_LOGPOINT, label: nlsDisableBreakpoint('Logpoint') }, { ...DebugEditorContextCommands.JUMP_TO_CURSOR, label: nls_1.nls.localizeByDefault('Jump to Cursor') });
        menus.linkSubmenu(browser_2.EDITOR_LINENUMBER_CONTEXT_MENU, debug_editor_model_1.DebugEditorModel.CONTEXT_MENU, { role: 1 /* CompoundMenuNodeRole.Group */ });
    }
    registerCommands(registry) {
        super.registerCommands(registry);
        registry.registerCommand(DebugCommands.START, {
            execute: (config) => this.start(false, config)
        });
        registry.registerCommand(DebugCommands.START_NO_DEBUG, {
            execute: (config) => this.start(true, config)
        });
        registry.registerCommand(DebugCommands.STOP, {
            execute: () => this.manager.terminateSession(),
            isEnabled: () => this.manager.state !== debug_session_1.DebugState.Inactive
        });
        registry.registerCommand(DebugCommands.RESTART, {
            execute: () => this.manager.restartSession(),
            isEnabled: () => this.manager.state !== debug_session_1.DebugState.Inactive
        });
        registry.registerCommand(DebugCommands.OPEN_CONFIGURATIONS, {
            execute: () => this.configurations.openConfiguration()
        });
        registry.registerCommand(DebugCommands.ADD_CONFIGURATION, {
            execute: () => this.configurations.addConfiguration()
        });
        registry.registerCommand(DebugCommands.STEP_OVER, {
            execute: () => this.manager.currentThread && this.manager.currentThread.stepOver(),
            isEnabled: () => this.manager.state === debug_session_1.DebugState.Stopped
        });
        registry.registerCommand(DebugCommands.STEP_INTO, {
            execute: () => this.manager.currentThread && this.manager.currentThread.stepIn(),
            isEnabled: () => this.manager.state === debug_session_1.DebugState.Stopped
        });
        registry.registerCommand(DebugCommands.STEP_OUT, {
            execute: () => this.manager.currentThread && this.manager.currentThread.stepOut(),
            isEnabled: () => this.manager.state === debug_session_1.DebugState.Stopped
        });
        registry.registerCommand(DebugCommands.CONTINUE, {
            execute: () => this.manager.currentThread && this.manager.currentThread.continue(),
            isEnabled: () => this.manager.state === debug_session_1.DebugState.Stopped
        });
        registry.registerCommand(DebugCommands.PAUSE, {
            execute: () => this.manager.currentThread && this.manager.currentThread.pause(),
            isEnabled: () => this.manager.state === debug_session_1.DebugState.Running
        });
        registry.registerCommand(DebugCommands.PAUSE_ALL, {
            execute: () => this.manager.currentSession && this.manager.currentSession.pauseAll(),
            isEnabled: () => !!this.manager.currentSession && !!this.manager.currentSession.runningThreads.next().value
        });
        registry.registerCommand(DebugCommands.CONTINUE_ALL, {
            execute: () => this.manager.currentSession && this.manager.currentSession.continueAll(),
            isEnabled: () => !!this.manager.currentSession && !!this.manager.currentSession.stoppedThreads.next().value
        });
        registry.registerCommand(DebugThreadContextCommands.STEP_OVER, {
            execute: () => this.selectedThread && this.selectedThread.stepOver(),
            isEnabled: () => !!this.selectedThread && this.selectedThread.stopped,
            isVisible: () => !!this.selectedThread
        });
        registry.registerCommand(DebugThreadContextCommands.STEP_INTO, {
            execute: () => this.selectedThread && this.selectedThread.stepIn(),
            isEnabled: () => !!this.selectedThread && this.selectedThread.stopped,
            isVisible: () => !!this.selectedThread
        });
        registry.registerCommand(DebugThreadContextCommands.STEP_OUT, {
            execute: () => this.selectedThread && this.selectedThread.stepOut(),
            isEnabled: () => !!this.selectedThread && this.selectedThread.stopped,
            isVisible: () => !!this.selectedThread
        });
        registry.registerCommand(DebugThreadContextCommands.CONTINUE, {
            execute: () => this.selectedThread && this.selectedThread.continue(),
            isEnabled: () => !!this.selectedThread && this.selectedThread.stopped,
            isVisible: () => !!this.selectedThread && this.selectedThread.stopped,
        });
        registry.registerCommand(DebugThreadContextCommands.PAUSE, {
            execute: () => this.selectedThread && this.selectedThread.pause(),
            isEnabled: () => !!this.selectedThread && !this.selectedThread.stopped,
            isVisible: () => !!this.selectedThread && !this.selectedThread.stopped,
        });
        registry.registerCommand(DebugThreadContextCommands.TERMINATE, {
            execute: () => this.selectedThread && this.selectedThread.terminate(),
            isEnabled: () => !!this.selectedThread && this.selectedThread.supportsTerminate,
            isVisible: () => !!this.selectedThread && this.selectedThread.supportsTerminate
        });
        registry.registerCommand(DebugSessionContextCommands.STOP, {
            execute: () => this.selectedSession && this.manager.terminateSession(this.selectedSession),
            isEnabled: () => !!this.selectedSession && this.selectedSession.state !== debug_session_1.DebugState.Inactive,
            isVisible: () => !this.selectedThread
        });
        registry.registerCommand(DebugSessionContextCommands.RESTART, {
            execute: () => this.selectedSession && this.manager.restartSession(this.selectedSession),
            isEnabled: () => !!this.selectedSession && this.selectedSession.state !== debug_session_1.DebugState.Inactive,
            isVisible: () => !this.selectedThread
        });
        registry.registerCommand(DebugSessionContextCommands.CONTINUE_ALL, {
            execute: () => this.selectedSession && this.selectedSession.continueAll(),
            isEnabled: () => !!this.selectedSession && !!this.selectedSession.stoppedThreads.next().value,
            isVisible: () => !this.selectedThread
        });
        registry.registerCommand(DebugSessionContextCommands.PAUSE_ALL, {
            execute: () => this.selectedSession && this.selectedSession.pauseAll(),
            isEnabled: () => !!this.selectedSession && !!this.selectedSession.runningThreads.next().value,
            isVisible: () => !this.selectedThread
        });
        registry.registerCommand(DebugSessionContextCommands.REVEAL, {
            execute: () => this.selectedSession && this.revealSession(this.selectedSession),
            isEnabled: () => Boolean(this.selectedSession),
            isVisible: () => !this.selectedThread && Boolean(this.selectedSession)
        });
        registry.registerCommand(DebugCommands.TOGGLE_BREAKPOINT, {
            execute: () => this.editors.toggleBreakpoint(),
            isEnabled: () => !!this.editors.model
        });
        registry.registerCommand(DebugCommands.INLINE_BREAKPOINT, {
            execute: () => this.editors.addInlineBreakpoint(),
            isEnabled: () => !!this.editors.model && !this.editors.getInlineBreakpoint()
        });
        registry.registerCommand(DebugCommands.ADD_CONDITIONAL_BREAKPOINT, {
            execute: () => this.editors.addBreakpoint('condition'),
            isEnabled: () => !!this.editors.model && !this.editors.anyBreakpoint()
        });
        registry.registerCommand(DebugCommands.ADD_LOGPOINT, {
            execute: () => this.editors.addBreakpoint('logMessage'),
            isEnabled: () => !!this.editors.model && !this.editors.anyBreakpoint()
        });
        registry.registerCommand(DebugCommands.ADD_FUNCTION_BREAKPOINT, {
            execute: async () => {
                const { labelProvider, breakpointManager, editorManager } = this;
                const options = { labelProvider, breakpoints: breakpointManager, editorManager };
                await new debug_function_breakpoint_1.DebugFunctionBreakpoint(breakpoint_marker_1.FunctionBreakpoint.create({ name: '' }), options).open();
            },
            isEnabled: widget => !(widget instanceof browser_1.Widget) || widget instanceof debug_breakpoints_widget_1.DebugBreakpointsWidget,
            isVisible: widget => !(widget instanceof browser_1.Widget) || widget instanceof debug_breakpoints_widget_1.DebugBreakpointsWidget
        });
        registry.registerCommand(DebugCommands.ENABLE_ALL_BREAKPOINTS, {
            execute: () => this.breakpointManager.enableAllBreakpoints(true),
            isEnabled: () => this.breakpointManager.hasBreakpoints()
        });
        registry.registerCommand(DebugCommands.DISABLE_ALL_BREAKPOINTS, {
            execute: () => this.breakpointManager.enableAllBreakpoints(false),
            isEnabled: () => this.breakpointManager.hasBreakpoints()
        });
        registry.registerCommand(DebugCommands.EDIT_BREAKPOINT, {
            execute: async () => {
                const { selectedBreakpoint, selectedFunctionBreakpoint } = this;
                if (selectedBreakpoint) {
                    await this.editors.editBreakpoint(selectedBreakpoint);
                }
                else if (selectedFunctionBreakpoint) {
                    await selectedFunctionBreakpoint.open();
                }
            },
            isEnabled: () => !!this.selectedBreakpoint || !!this.selectedFunctionBreakpoint,
            isVisible: () => !!this.selectedBreakpoint || !!this.selectedFunctionBreakpoint
        });
        registry.registerCommand(DebugCommands.EDIT_LOGPOINT, {
            execute: async () => {
                const { selectedLogpoint } = this;
                if (selectedLogpoint) {
                    await this.editors.editBreakpoint(selectedLogpoint);
                }
            },
            isEnabled: () => !!this.selectedLogpoint,
            isVisible: () => !!this.selectedLogpoint
        });
        registry.registerCommand(DebugCommands.EDIT_BREAKPOINT_CONDITION, {
            execute: async () => {
                const { selectedExceptionBreakpoint } = this;
                if (selectedExceptionBreakpoint) {
                    await selectedExceptionBreakpoint.editCondition();
                }
            },
            isEnabled: () => { var _a; return !!((_a = this.selectedExceptionBreakpoint) === null || _a === void 0 ? void 0 : _a.data.raw.supportsCondition); },
            isVisible: () => { var _a; return !!((_a = this.selectedExceptionBreakpoint) === null || _a === void 0 ? void 0 : _a.data.raw.supportsCondition); }
        });
        registry.registerCommand(DebugCommands.REMOVE_BREAKPOINT, {
            execute: () => {
                const selectedBreakpoint = this.selectedSettableBreakpoint;
                if (selectedBreakpoint) {
                    selectedBreakpoint.remove();
                }
            },
            isEnabled: () => Boolean(this.selectedSettableBreakpoint),
            isVisible: () => Boolean(this.selectedSettableBreakpoint),
        });
        registry.registerCommand(DebugCommands.REMOVE_LOGPOINT, {
            execute: () => {
                const { selectedLogpoint } = this;
                if (selectedLogpoint) {
                    selectedLogpoint.remove();
                }
            },
            isEnabled: () => !!this.selectedLogpoint,
            isVisible: () => !!this.selectedLogpoint
        });
        registry.registerCommand(DebugCommands.REMOVE_ALL_BREAKPOINTS, {
            execute: () => this.breakpointManager.removeBreakpoints(),
            isEnabled: () => this.breakpointManager.hasBreakpoints(),
            isVisible: widget => !(widget instanceof browser_1.Widget) || (widget instanceof debug_breakpoints_widget_1.DebugBreakpointsWidget)
        });
        registry.registerCommand(DebugCommands.TOGGLE_BREAKPOINTS_ENABLED, {
            execute: () => this.breakpointManager.breakpointsEnabled = !this.breakpointManager.breakpointsEnabled,
            isVisible: arg => arg instanceof debug_breakpoints_widget_1.DebugBreakpointsWidget
        });
        registry.registerCommand(DebugCommands.SHOW_HOVER, {
            execute: () => this.editors.showHover(),
            isEnabled: () => this.editors.canShowHover()
        });
        registry.registerCommand(DebugCommands.JUMP_TO_CURSOR, {
            execute: () => {
                const model = this.editors.model;
                if (model && this.manager.currentThread) {
                    this.manager.currentThread.jumpToCursor(model.editor.getResourceUri(), model.position);
                }
            },
            isEnabled: () => !!this.manager.currentThread && this.manager.currentThread.supportsGoto,
            isVisible: () => !!this.manager.currentThread && this.manager.currentThread.supportsGoto
        });
        registry.registerCommand(DebugCommands.RESTART_FRAME, {
            execute: () => this.selectedFrame && this.selectedFrame.restart(),
            isEnabled: () => !!this.selectedFrame
        });
        registry.registerCommand(DebugCommands.COPY_CALL_STACK, {
            execute: () => {
                const { frames } = this;
                const selection = document.getSelection();
                if (frames && selection) {
                    selection.selectAllChildren(frames.node);
                    document.execCommand('copy');
                }
            },
            isEnabled: () => document.queryCommandSupported('copy'),
            isVisible: () => document.queryCommandSupported('copy')
        });
        registry.registerCommand(DebugCommands.SET_VARIABLE_VALUE, {
            execute: () => this.selectedVariable && this.selectedVariable.open(),
            isEnabled: () => !!this.selectedVariable && this.selectedVariable.supportSetVariable && !this.selectedVariable.readOnly,
            isVisible: () => !!this.selectedVariable && this.selectedVariable.supportSetVariable
        });
        registry.registerCommand(DebugCommands.COPY_VARIABLE_VALUE, {
            execute: () => this.selectedVariable && this.selectedVariable.copyValue(),
            isEnabled: () => !!this.selectedVariable && this.selectedVariable.supportCopyValue,
            isVisible: () => !!this.selectedVariable && this.selectedVariable.supportCopyValue
        });
        registry.registerCommand(DebugCommands.COPY_VARIABLE_AS_EXPRESSION, {
            execute: () => this.selectedVariable && this.selectedVariable.copyAsExpression(),
            isEnabled: () => !!this.selectedVariable && this.selectedVariable.supportCopyAsExpression,
            isVisible: () => !!this.selectedVariable && this.selectedVariable.supportCopyAsExpression
        });
        registry.registerCommand(DebugCommands.WATCH_VARIABLE, {
            execute: () => {
                const { selectedVariable, watch } = this;
                if (selectedVariable && watch) {
                    watch.viewModel.addWatchExpression(selectedVariable.name);
                }
            },
            isEnabled: () => !!this.selectedVariable && !!this.watch,
            isVisible: () => !!this.selectedVariable && !!this.watch,
        });
        // Debug context menu commands
        registry.registerCommand(DebugEditorContextCommands.ADD_BREAKPOINT, {
            execute: position => this.isPosition(position) && this.editors.toggleBreakpoint(this.asPosition(position)),
            isEnabled: position => this.isPosition(position) && !this.editors.anyBreakpoint(this.asPosition(position)),
            isVisible: position => this.isPosition(position) && !this.editors.anyBreakpoint(this.asPosition(position))
        });
        registry.registerCommand(DebugEditorContextCommands.ADD_CONDITIONAL_BREAKPOINT, {
            execute: position => this.isPosition(position) && this.editors.addBreakpoint('condition', this.asPosition(position)),
            isEnabled: position => this.isPosition(position) && !this.editors.anyBreakpoint(this.asPosition(position)),
            isVisible: position => this.isPosition(position) && !this.editors.anyBreakpoint(this.asPosition(position))
        });
        registry.registerCommand(DebugEditorContextCommands.ADD_LOGPOINT, {
            execute: position => this.isPosition(position) && this.editors.addBreakpoint('logMessage', this.asPosition(position)),
            isEnabled: position => this.isPosition(position) && !this.editors.anyBreakpoint(this.asPosition(position)),
            isVisible: position => this.isPosition(position) && !this.editors.anyBreakpoint(this.asPosition(position))
        });
        registry.registerCommand(DebugEditorContextCommands.REMOVE_BREAKPOINT, {
            execute: position => this.isPosition(position) && this.editors.toggleBreakpoint(this.asPosition(position)),
            isEnabled: position => this.isPosition(position) && !!this.editors.getBreakpoint(this.asPosition(position)),
            isVisible: position => this.isPosition(position) && !!this.editors.getBreakpoint(this.asPosition(position))
        });
        registry.registerCommand(DebugEditorContextCommands.EDIT_BREAKPOINT, {
            execute: position => this.isPosition(position) && this.editors.editBreakpoint(this.asPosition(position)),
            isEnabled: position => this.isPosition(position) && !!this.editors.getBreakpoint(this.asPosition(position)),
            isVisible: position => this.isPosition(position) && !!this.editors.getBreakpoint(this.asPosition(position))
        });
        registry.registerCommand(DebugEditorContextCommands.ENABLE_BREAKPOINT, {
            execute: position => this.isPosition(position) && this.editors.setBreakpointEnabled(this.asPosition(position), true),
            isEnabled: position => this.isPosition(position) && this.editors.getBreakpointEnabled(this.asPosition(position)) === false,
            isVisible: position => this.isPosition(position) && this.editors.getBreakpointEnabled(this.asPosition(position)) === false
        });
        registry.registerCommand(DebugEditorContextCommands.DISABLE_BREAKPOINT, {
            execute: position => this.isPosition(position) && this.editors.setBreakpointEnabled(this.asPosition(position), false),
            isEnabled: position => this.isPosition(position) && !!this.editors.getBreakpointEnabled(this.asPosition(position)),
            isVisible: position => this.isPosition(position) && !!this.editors.getBreakpointEnabled(this.asPosition(position))
        });
        registry.registerCommand(DebugEditorContextCommands.REMOVE_LOGPOINT, {
            execute: position => this.isPosition(position) && this.editors.toggleBreakpoint(this.asPosition(position)),
            isEnabled: position => this.isPosition(position) && !!this.editors.getLogpoint(this.asPosition(position)),
            isVisible: position => this.isPosition(position) && !!this.editors.getLogpoint(this.asPosition(position))
        });
        registry.registerCommand(DebugEditorContextCommands.EDIT_LOGPOINT, {
            execute: position => this.isPosition(position) && this.editors.editBreakpoint(this.asPosition(position)),
            isEnabled: position => this.isPosition(position) && !!this.editors.getLogpoint(this.asPosition(position)),
            isVisible: position => this.isPosition(position) && !!this.editors.getLogpoint(this.asPosition(position))
        });
        registry.registerCommand(DebugEditorContextCommands.ENABLE_LOGPOINT, {
            execute: position => this.isPosition(position) && this.editors.setBreakpointEnabled(this.asPosition(position), true),
            isEnabled: position => this.isPosition(position) && this.editors.getLogpointEnabled(this.asPosition(position)) === false,
            isVisible: position => this.isPosition(position) && this.editors.getLogpointEnabled(this.asPosition(position)) === false
        });
        registry.registerCommand(DebugEditorContextCommands.DISABLE_LOGPOINT, {
            execute: position => this.isPosition(position) && this.editors.setBreakpointEnabled(this.asPosition(position), false),
            isEnabled: position => this.isPosition(position) && !!this.editors.getLogpointEnabled(this.asPosition(position)),
            isVisible: position => this.isPosition(position) && !!this.editors.getLogpointEnabled(this.asPosition(position))
        });
        registry.registerCommand(DebugEditorContextCommands.JUMP_TO_CURSOR, {
            execute: position => {
                if (this.isPosition(position) && this.editors.currentUri && this.manager.currentThread) {
                    this.manager.currentThread.jumpToCursor(this.editors.currentUri, this.asPosition(position));
                }
            },
            isEnabled: () => !!this.manager.currentThread && this.manager.currentThread.supportsGoto,
            isVisible: () => !!this.manager.currentThread && this.manager.currentThread.supportsGoto
        });
        registry.registerCommand(DebugBreakpointWidgetCommands.ACCEPT, {
            execute: () => this.editors.acceptBreakpoint()
        });
        registry.registerCommand(DebugBreakpointWidgetCommands.CLOSE, {
            execute: () => this.editors.closeBreakpoint()
        });
        registry.registerCommand(DebugCommands.ADD_WATCH_EXPRESSION, {
            execute: widget => {
                if (widget instanceof browser_1.Widget) {
                    if (widget instanceof debug_watch_widget_1.DebugWatchWidget) {
                        widget.viewModel.addWatchExpression();
                    }
                }
                else if (this.watch) {
                    this.watch.viewModel.addWatchExpression();
                }
            },
            isEnabled: widget => widget instanceof browser_1.Widget ? widget instanceof debug_watch_widget_1.DebugWatchWidget : !!this.watch,
            isVisible: widget => widget instanceof browser_1.Widget ? widget instanceof debug_watch_widget_1.DebugWatchWidget : !!this.watch
        });
        registry.registerCommand(DebugCommands.EDIT_WATCH_EXPRESSION, {
            execute: () => {
                const { watchExpression } = this;
                if (watchExpression) {
                    watchExpression.open();
                }
            },
            isEnabled: () => !!this.watchExpression,
            isVisible: () => !!this.watchExpression
        });
        registry.registerCommand(DebugCommands.COPY_WATCH_EXPRESSION_VALUE, {
            execute: () => this.watchExpression && this.watchExpression.copyValue(),
            isEnabled: () => !!this.watchExpression && this.watchExpression.supportCopyValue,
            isVisible: () => !!this.watchExpression && this.watchExpression.supportCopyValue
        });
        registry.registerCommand(DebugCommands.COLLAPSE_ALL_WATCH_EXPRESSIONS, {
            execute: widget => {
                if (widget instanceof debug_watch_widget_1.DebugWatchWidget) {
                    const root = widget.model.root;
                    widget.model.collapseAll(browser_1.CompositeTreeNode.is(root) ? root : undefined);
                }
            },
            isEnabled: widget => widget instanceof debug_watch_widget_1.DebugWatchWidget,
            isVisible: widget => widget instanceof debug_watch_widget_1.DebugWatchWidget
        });
        registry.registerCommand(DebugCommands.REMOVE_WATCH_EXPRESSION, {
            execute: () => {
                const { watch, watchExpression } = this;
                if (watch && watchExpression) {
                    watch.viewModel.removeWatchExpression(watchExpression);
                }
            },
            isEnabled: () => !!this.watchExpression,
            isVisible: () => !!this.watchExpression
        });
        registry.registerCommand(DebugCommands.REMOVE_ALL_WATCH_EXPRESSIONS, {
            execute: widget => {
                if (widget instanceof browser_1.Widget) {
                    if (widget instanceof debug_watch_widget_1.DebugWatchWidget) {
                        widget.viewModel.removeWatchExpressions();
                    }
                }
                else if (this.watch) {
                    this.watch.viewModel.removeWatchExpressions();
                }
            },
            isEnabled: widget => widget instanceof browser_1.Widget ? widget instanceof debug_watch_widget_1.DebugWatchWidget : !!this.watch,
            isVisible: widget => widget instanceof browser_1.Widget ? widget instanceof debug_watch_widget_1.DebugWatchWidget : !!this.watch
        });
    }
    registerKeybindings(keybindings) {
        super.registerKeybindings(keybindings);
        keybindings.registerKeybinding({
            command: DebugCommands.START.id,
            keybinding: 'f5'
        });
        keybindings.registerKeybinding({
            command: DebugCommands.START_NO_DEBUG.id,
            keybinding: 'ctrl+f5'
        });
        keybindings.registerKeybinding({
            command: DebugCommands.STOP.id,
            keybinding: 'shift+f5',
            when: 'inDebugMode'
        });
        keybindings.registerKeybinding({
            command: DebugCommands.RESTART.id,
            keybinding: 'shift+ctrlcmd+f5',
            when: 'inDebugMode'
        });
        keybindings.registerKeybinding({
            command: DebugCommands.STEP_OVER.id,
            keybinding: 'f10',
            when: 'inDebugMode'
        });
        keybindings.registerKeybinding({
            command: DebugCommands.STEP_INTO.id,
            keybinding: 'f11',
            when: 'inDebugMode'
        });
        keybindings.registerKeybinding({
            command: DebugCommands.STEP_OUT.id,
            keybinding: 'shift+f11',
            when: 'inDebugMode'
        });
        keybindings.registerKeybinding({
            command: DebugCommands.CONTINUE.id,
            keybinding: 'f5',
            when: 'inDebugMode'
        });
        keybindings.registerKeybinding({
            command: DebugCommands.PAUSE.id,
            keybinding: 'f6',
            when: 'inDebugMode'
        });
        keybindings.registerKeybinding({
            command: DebugCommands.TOGGLE_BREAKPOINT.id,
            keybinding: 'f9',
            when: 'editorTextFocus'
        });
        keybindings.registerKeybinding({
            command: DebugCommands.INLINE_BREAKPOINT.id,
            keybinding: 'shift+f9',
            when: 'editorTextFocus'
        });
        keybindings.registerKeybinding({
            command: DebugBreakpointWidgetCommands.ACCEPT.id,
            keybinding: 'enter',
            when: 'breakpointWidgetFocus'
        });
        keybindings.registerKeybinding({
            command: DebugBreakpointWidgetCommands.CLOSE.id,
            keybinding: 'esc',
            when: 'isBreakpointWidgetVisible || breakpointWidgetFocus'
        });
    }
    registerToolbarItems(toolbar) {
        const onDidChangeToggleBreakpointsEnabled = new common_1.Emitter();
        const toggleBreakpointsEnabled = {
            id: DebugCommands.TOGGLE_BREAKPOINTS_ENABLED.id,
            command: DebugCommands.TOGGLE_BREAKPOINTS_ENABLED.id,
            icon: (0, browser_1.codicon)('activate-breakpoints'),
            onDidChange: onDidChangeToggleBreakpointsEnabled.event,
            priority: 1
        };
        const updateToggleBreakpointsEnabled = () => {
            const activateBreakpoints = nls_1.nls.localizeByDefault('Enable All Breakpoints');
            const deactivateBreakpoints = nls_1.nls.localizeByDefault('Disable All Breakpoints');
            const tooltip = this.breakpointManager.breakpointsEnabled ? deactivateBreakpoints : activateBreakpoints;
            if (toggleBreakpointsEnabled.tooltip !== tooltip) {
                toggleBreakpointsEnabled.tooltip = tooltip;
                onDidChangeToggleBreakpointsEnabled.fire(undefined);
            }
        };
        toolbar.registerItem({
            id: DebugCommands.ADD_FUNCTION_BREAKPOINT.id,
            command: DebugCommands.ADD_FUNCTION_BREAKPOINT.id,
            icon: (0, browser_1.codicon)('add'),
            tooltip: DebugCommands.ADD_FUNCTION_BREAKPOINT.label
        });
        updateToggleBreakpointsEnabled();
        this.breakpointManager.onDidChangeBreakpoints(updateToggleBreakpointsEnabled);
        toolbar.registerItem(toggleBreakpointsEnabled);
        toolbar.registerItem({
            id: DebugCommands.REMOVE_ALL_BREAKPOINTS.id,
            command: DebugCommands.REMOVE_ALL_BREAKPOINTS.id,
            icon: (0, browser_1.codicon)('close-all'),
            priority: 2
        });
        toolbar.registerItem({
            id: DebugCommands.ADD_WATCH_EXPRESSION.id,
            command: DebugCommands.ADD_WATCH_EXPRESSION.id,
            icon: (0, browser_1.codicon)('add'),
            tooltip: DebugCommands.ADD_WATCH_EXPRESSION.label
        });
        toolbar.registerItem({
            id: DebugCommands.COLLAPSE_ALL_WATCH_EXPRESSIONS.id,
            command: DebugCommands.COLLAPSE_ALL_WATCH_EXPRESSIONS.id,
            icon: (0, browser_1.codicon)('collapse-all'),
            tooltip: DebugCommands.COLLAPSE_ALL_WATCH_EXPRESSIONS.label,
            priority: 1
        });
        toolbar.registerItem({
            id: DebugCommands.REMOVE_ALL_WATCH_EXPRESSIONS.id,
            command: DebugCommands.REMOVE_ALL_WATCH_EXPRESSIONS.id,
            icon: (0, browser_1.codicon)('close-all'),
            tooltip: DebugCommands.REMOVE_ALL_WATCH_EXPRESSIONS.label,
            priority: 2
        });
    }
    async openSession(session, options) {
        const { reveal } = {
            reveal: true,
            ...options
        };
        const debugWidget = await this.openView({ reveal });
        debugWidget.sessionManager.currentSession = session;
        return debugWidget['sessionWidget'];
    }
    revealSession(session) {
        var _a;
        const widget = (_a = this.tryGetWidget()) === null || _a === void 0 ? void 0 : _a['sessionWidget'];
        if (widget) {
            this.shell.revealWidget(widget.id);
        }
        return widget;
    }
    async start(noDebug, debugSessionOptions) {
        let current = debugSessionOptions ? debugSessionOptions : this.configurations.current;
        // If no configurations are currently present, create the `launch.json` and prompt users to select the config.
        if (!current) {
            await this.configurations.addConfiguration();
            return;
        }
        if (noDebug !== undefined) {
            if (current.configuration) {
                current = {
                    ...current,
                    configuration: {
                        ...current.configuration,
                        noDebug
                    }
                };
            }
            else {
                current = {
                    ...current,
                    noDebug
                };
            }
        }
        await this.manager.start(current);
    }
    get threads() {
        const { currentWidget } = this.shell;
        return currentWidget instanceof debug_threads_widget_1.DebugThreadsWidget && currentWidget || undefined;
    }
    get selectedSession() {
        const { threads } = this;
        return threads && threads.selectedElement instanceof debug_session_1.DebugSession && threads.selectedElement || undefined;
    }
    get selectedThread() {
        const { threads } = this;
        return threads && threads.selectedElement instanceof debug_thread_1.DebugThread && threads.selectedElement || undefined;
    }
    get frames() {
        const { currentWidget } = this.shell;
        return currentWidget instanceof debug_stack_frames_widget_1.DebugStackFramesWidget && currentWidget || undefined;
    }
    get selectedFrame() {
        const { frames } = this;
        return frames && frames.selectedElement instanceof debug_stack_frame_1.DebugStackFrame && frames.selectedElement || undefined;
    }
    get breakpoints() {
        const { currentWidget } = this.shell;
        return currentWidget instanceof debug_breakpoints_widget_1.DebugBreakpointsWidget && currentWidget || undefined;
    }
    get selectedAnyBreakpoint() {
        const { breakpoints } = this;
        const selectedElement = breakpoints && breakpoints.selectedElement;
        return selectedElement instanceof debug_breakpoint_1.DebugBreakpoint ? selectedElement : undefined;
    }
    get selectedBreakpoint() {
        const breakpoint = this.selectedAnyBreakpoint;
        return breakpoint && breakpoint instanceof debug_source_breakpoint_1.DebugSourceBreakpoint && !breakpoint.logMessage ? breakpoint : undefined;
    }
    get selectedLogpoint() {
        const breakpoint = this.selectedAnyBreakpoint;
        return breakpoint && breakpoint instanceof debug_source_breakpoint_1.DebugSourceBreakpoint && !!breakpoint.logMessage ? breakpoint : undefined;
    }
    get selectedFunctionBreakpoint() {
        const breakpoint = this.selectedAnyBreakpoint;
        return breakpoint && breakpoint instanceof debug_function_breakpoint_1.DebugFunctionBreakpoint ? breakpoint : undefined;
    }
    get selectedInstructionBreakpoint() {
        if (this.selectedAnyBreakpoint instanceof debug_instruction_breakpoint_1.DebugInstructionBreakpoint) {
            return this.selectedAnyBreakpoint;
        }
    }
    get selectedExceptionBreakpoint() {
        const { breakpoints } = this;
        const selectedElement = breakpoints && breakpoints.selectedElement;
        return selectedElement instanceof debug_exception_breakpoint_1.DebugExceptionBreakpoint ? selectedElement : undefined;
    }
    get selectedSettableBreakpoint() {
        const selected = this.selectedAnyBreakpoint;
        if (selected instanceof debug_function_breakpoint_1.DebugFunctionBreakpoint || selected instanceof debug_instruction_breakpoint_1.DebugInstructionBreakpoint || selected instanceof debug_source_breakpoint_1.DebugSourceBreakpoint) {
            return selected;
        }
    }
    get variables() {
        const { currentWidget } = this.shell;
        return currentWidget instanceof debug_variables_widget_1.DebugVariablesWidget && currentWidget || undefined;
    }
    get selectedVariable() {
        const { variables } = this;
        return variables && variables.selectedElement instanceof debug_console_items_1.DebugVariable && variables.selectedElement || undefined;
    }
    get watch() {
        const { currentWidget } = this.shell;
        return currentWidget instanceof debug_watch_widget_1.DebugWatchWidget && currentWidget || undefined;
    }
    get watchExpression() {
        const { watch } = this;
        return watch && watch.selectedElement instanceof debug_watch_expression_1.DebugWatchExpression && watch.selectedElement || undefined;
    }
    isPosition(position) {
        return monaco.Position.isIPosition(position);
    }
    asPosition(position) {
        return monaco.Position.lift(position);
    }
    registerColors(colors) {
        colors.register(
        // Debug colors should be aligned with https://code.visualstudio.com/api/references/theme-color#debug-colors
        {
            id: 'editor.stackFrameHighlightBackground',
            defaults: {
                dark: '#ffff0033',
                light: '#ffff6673',
                hcDark: '#fff600',
                hcLight: '#ffff6673'
            }, description: 'Background color for the highlight of line at the top stack frame position.'
        }, {
            id: 'editor.focusedStackFrameHighlightBackground',
            defaults: {
                dark: '#7abd7a4d',
                light: '#cee7ce73',
                hcDark: '#cee7ce',
                hcLight: '#cee7ce73'
            }, description: 'Background color for the highlight of line at focused stack frame position.'
        }, 
        // Status bar colors should be aligned with debugging colors from https://code.visualstudio.com/api/references/theme-color#status-bar-colors
        {
            id: 'statusBar.debuggingBackground', defaults: {
                dark: '#CC6633',
                light: '#CC6633',
                hcDark: '#CC6633',
                hcLight: '#B5200D'
            }, description: 'Status bar background color when a program is being debugged. The status bar is shown in the bottom of the window'
        }, {
            id: 'statusBar.debuggingForeground', defaults: {
                dark: 'statusBar.foreground',
                light: 'statusBar.foreground',
                hcDark: 'statusBar.foreground',
                hcLight: 'statusBar.foreground'
            }, description: 'Status bar foreground color when a program is being debugged. The status bar is shown in the bottom of the window'
        }, {
            id: 'statusBar.debuggingBorder', defaults: {
                dark: 'statusBar.border',
                light: 'statusBar.border',
                hcDark: 'statusBar.border',
                hcLight: 'statusBar.border'
            }, description: 'Status bar border color separating to the sidebar and editor when a program is being debugged. The status bar is shown in the bottom of the window'
        }, 
        // Debug Exception Widget colors should be aligned with
        // https://github.com/microsoft/vscode/blob/ff5f581425da6230b6f9216ecf19abf6c9d285a6/src/vs/workbench/contrib/debug/browser/exceptionWidget.ts#L23
        {
            id: 'debugExceptionWidget.border', defaults: {
                dark: '#a31515',
                light: '#a31515',
                hcDark: '#a31515',
                hcLight: '#a31515'
            }, description: 'Exception widget border color.',
        }, {
            id: 'debugExceptionWidget.background', defaults: {
                dark: '#420b0d',
                light: '#f1dfde',
                hcDark: '#420b0d',
                hcLight: '#f1dfde'
            }, description: 'Exception widget background color.'
        }, 
        // Debug Icon colors should be aligned with
        // https://code.visualstudio.com/api/references/theme-color#debug-icons-colors
        {
            id: 'debugIcon.breakpointForeground', defaults: {
                dark: '#E51400',
                light: '#E51400',
                hcDark: '#E51400',
                hcLight: '#E51400'
            },
            description: 'Icon color for breakpoints.'
        }, {
            id: 'debugIcon.breakpointDisabledForeground', defaults: {
                dark: '#848484',
                light: '#848484',
                hcDark: '#848484',
                hcLight: '#848484'
            },
            description: 'Icon color for disabled breakpoints.'
        }, {
            id: 'debugIcon.breakpointUnverifiedForeground', defaults: {
                dark: '#848484',
                light: '#848484',
                hcDark: '#848484',
                hcLight: '#848484'
            },
            description: 'Icon color for unverified breakpoints.'
        }, {
            id: 'debugIcon.breakpointCurrentStackframeForeground', defaults: {
                dark: '#FFCC00',
                light: '#BE8700',
                hcDark: '#FFCC00',
                hcLight: '#BE8700'
            },
            description: 'Icon color for the current breakpoint stack frame.'
        }, {
            id: 'debugIcon.breakpointStackframeForeground', defaults: {
                dark: '#89D185',
                light: '#89D185',
                hcDark: '#89D185',
                hcLight: '#89D185'
            },
            description: 'Icon color for all breakpoint stack frames.'
        }, {
            id: 'debugIcon.startForeground', defaults: {
                dark: '#89D185',
                light: '#388A34',
                hcDark: '#89D185',
                hcLight: '#388A34'
            }, description: 'Debug toolbar icon for start debugging.'
        }, {
            id: 'debugIcon.pauseForeground', defaults: {
                dark: '#75BEFF',
                light: '#007ACC',
                hcDark: '#75BEFF',
                hcLight: '#007ACC'
            }, description: 'Debug toolbar icon for pause.'
        }, {
            id: 'debugIcon.stopForeground', defaults: {
                dark: '#F48771',
                light: '#A1260D',
                hcDark: '#F48771',
                hcLight: '#A1260D'
            }, description: 'Debug toolbar icon for stop.'
        }, {
            id: 'debugIcon.disconnectForeground', defaults: {
                dark: '#F48771',
                light: '#A1260D',
                hcDark: '#F48771',
                hcLight: '#A1260D'
            }, description: 'Debug toolbar icon for disconnect.'
        }, {
            id: 'debugIcon.restartForeground', defaults: {
                dark: '#89D185',
                light: '#388A34',
                hcDark: '#89D185',
                hcLight: '#388A34'
            }, description: 'Debug toolbar icon for restart.'
        }, {
            id: 'debugIcon.stepOverForeground', defaults: {
                dark: '#75BEFF',
                light: '#007ACC',
                hcDark: '#75BEFF',
                hcLight: '#007ACC',
            }, description: 'Debug toolbar icon for step over.'
        }, {
            id: 'debugIcon.stepIntoForeground', defaults: {
                dark: '#75BEFF',
                light: '#007ACC',
                hcDark: '#75BEFF',
                hcLight: '#007ACC'
            }, description: 'Debug toolbar icon for step into.'
        }, {
            id: 'debugIcon.stepOutForeground', defaults: {
                dark: '#75BEFF',
                light: '#007ACC',
                hcDark: '#75BEFF',
                hcLight: '#007ACC',
            }, description: 'Debug toolbar icon for step over.'
        }, {
            id: 'debugIcon.continueForeground', defaults: {
                dark: '#75BEFF',
                light: '#007ACC',
                hcDark: '#75BEFF',
                hcLight: '#007ACC'
            }, description: 'Debug toolbar icon for continue.'
        }, {
            id: 'debugIcon.stepBackForeground', defaults: {
                dark: '#75BEFF',
                light: '#007ACC',
                hcDark: '#75BEFF',
                hcLight: '#007ACC'
            }, description: 'Debug toolbar icon for step back.'
        }, {
            id: 'debugConsole.infoForeground', defaults: {
                dark: 'editorInfo.foreground',
                light: 'editorInfo.foreground',
                hcDark: 'foreground',
                hcLight: 'foreground'
            }, description: 'Foreground color for info messages in debug REPL console.'
        }, {
            id: 'debugConsole.warningForeground', defaults: {
                dark: 'editorWarning.foreground',
                light: 'editorWarning.foreground',
                hcDark: '#008000',
                hcLight: 'editorWarning.foreground'
            },
            description: 'Foreground color for warning messages in debug REPL console.'
        }, {
            id: 'debugConsole.errorForeground', defaults: {
                dark: 'errorForeground',
                light: 'errorForeground',
                hcDark: 'errorForeground',
                hcLight: 'errorForeground'
            },
            description: 'Foreground color for error messages in debug REPL console.',
        }, {
            id: 'debugConsole.sourceForeground', defaults: {
                dark: 'foreground',
                light: 'foreground',
                hcDark: 'foreground',
                hcLight: 'foreground'
            },
            description: 'Foreground color for source filenames in debug REPL console.',
        }, {
            id: 'debugConsoleInputIcon.foreground', defaults: {
                dark: 'foreground',
                light: 'foreground',
                hcDark: 'foreground',
                hcLight: 'foreground'
            },
            description: 'Foreground color for debug console input marker icon.'
        });
    }
    updateStatusBar() {
        if (this.debuggingStatusBar === document.body.classList.contains('theia-mod-debugging')) {
            return;
        }
        document.body.classList.toggle('theia-mod-debugging');
    }
    get debuggingStatusBar() {
        if (this.manager.state < debug_session_1.DebugState.Running) {
            return false;
        }
        const session = this.manager.currentSession;
        if (session) {
            if (session.configuration.noDebug) {
                return false;
            }
            if (this.getOption(session, 'suppressDebugStatusbar')) {
                return false;
            }
        }
        return true;
    }
    getOption(session, option) {
        // If session is undefined there will be no option
        if (!session) {
            return false;
        }
        // If undefined take the value of the parent
        if (option in session.configuration && session.configuration[option] !== undefined) {
            return session.configuration[option];
        }
        return this.getOption(session.parentSession, option);
    }
};
exports.DebugFrontendApplicationContribution = DebugFrontendApplicationContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_service_1.DebugService),
    tslib_1.__metadata("design:type", Object)
], DebugFrontendApplicationContribution.prototype, "debug", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_session_manager_1.DebugSessionManager),
    tslib_1.__metadata("design:type", debug_session_manager_1.DebugSessionManager)
], DebugFrontendApplicationContribution.prototype, "manager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_configuration_manager_1.DebugConfigurationManager),
    tslib_1.__metadata("design:type", debug_configuration_manager_1.DebugConfigurationManager)
], DebugFrontendApplicationContribution.prototype, "configurations", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(breakpoint_manager_1.BreakpointManager),
    tslib_1.__metadata("design:type", breakpoint_manager_1.BreakpointManager)
], DebugFrontendApplicationContribution.prototype, "breakpointManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_editor_service_1.DebugEditorService),
    tslib_1.__metadata("design:type", debug_editor_service_1.DebugEditorService)
], DebugFrontendApplicationContribution.prototype, "editors", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_console_contribution_1.DebugConsoleContribution),
    tslib_1.__metadata("design:type", debug_console_contribution_1.DebugConsoleContribution)
], DebugFrontendApplicationContribution.prototype, "console", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_schema_updater_1.DebugSchemaUpdater),
    tslib_1.__metadata("design:type", debug_schema_updater_1.DebugSchemaUpdater)
], DebugFrontendApplicationContribution.prototype, "schemaUpdater", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_preferences_1.DebugPreferences),
    tslib_1.__metadata("design:type", Object)
], DebugFrontendApplicationContribution.prototype, "preference", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_watch_manager_1.DebugWatchManager),
    tslib_1.__metadata("design:type", debug_watch_manager_1.DebugWatchManager)
], DebugFrontendApplicationContribution.prototype, "watchManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.LabelProvider),
    tslib_1.__metadata("design:type", browser_1.LabelProvider)
], DebugFrontendApplicationContribution.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.EditorManager),
    tslib_1.__metadata("design:type", browser_2.EditorManager)
], DebugFrontendApplicationContribution.prototype, "editorManager", void 0);
exports.DebugFrontendApplicationContribution = DebugFrontendApplicationContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__metadata("design:paramtypes", [])
], DebugFrontendApplicationContribution);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/debug-preferences.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/debug-preferences.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.bindDebugPreferences = exports.createDebugPreferences = exports.DebugPreferences = exports.DebugPreferenceContribution = exports.DebugConfiguration = exports.debugPreferencesSchema = void 0;
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const preferences_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences */ "../../node_modules/@theia/core/lib/browser/preferences/index.js");
exports.debugPreferencesSchema = {
    type: 'object',
    properties: {
        'debug.trace': {
            type: 'boolean',
            default: false,
            description: nls_1.nls.localize('theia/debug/toggleTracing', 'Enable/disable tracing communications with debug adapters')
        },
        'debug.openDebug': {
            enum: ['neverOpen', 'openOnSessionStart', 'openOnFirstSessionStart', 'openOnDebugBreak'],
            default: 'openOnSessionStart',
            description: nls_1.nls.localizeByDefault('Controls when the debug view should open.')
        },
        'debug.internalConsoleOptions': {
            enum: ['neverOpen', 'openOnSessionStart', 'openOnFirstSessionStart'],
            default: 'openOnFirstSessionStart',
            description: nls_1.nls.localizeByDefault('Controls when the internal Debug Console should open.')
        },
        'debug.inlineValues': {
            type: 'boolean',
            default: false,
            description: nls_1.nls.localizeByDefault('Show variable values inline in editor while debugging.')
        },
        'debug.showInStatusBar': {
            enum: ['never', 'always', 'onFirstSessionStart'],
            enumDescriptions: [
                nls_1.nls.localizeByDefault('Never show debug in Status bar'),
                nls_1.nls.localizeByDefault('Always show debug in Status bar'),
                nls_1.nls.localizeByDefault('Show debug in Status bar only after debug was started for the first time')
            ],
            description: nls_1.nls.localizeByDefault('Controls when the debug Status bar should be visible.'),
            default: 'onFirstSessionStart'
        },
        'debug.confirmOnExit': {
            description: 'Controls whether to confirm when the window closes if there are active debug sessions.',
            type: 'string',
            enum: ['never', 'always'],
            enumDescriptions: [
                'Never confirm.',
                'Always confirm if there are debug sessions.',
            ],
            default: 'never'
        },
        'debug.disassemblyView.showSourceCode': {
            description: nls_1.nls.localizeByDefault('Show Source Code in Disassembly View.'),
            type: 'boolean',
            default: true,
        }
    }
};
class DebugConfiguration {
}
exports.DebugConfiguration = DebugConfiguration;
exports.DebugPreferenceContribution = Symbol('DebugPreferenceContribution');
exports.DebugPreferences = Symbol('DebugPreferences');
function createDebugPreferences(preferences, schema = exports.debugPreferencesSchema) {
    return (0, preferences_1.createPreferenceProxy)(preferences, schema);
}
exports.createDebugPreferences = createDebugPreferences;
function bindDebugPreferences(bind) {
    bind(exports.DebugPreferences).toDynamicValue(ctx => {
        const preferences = ctx.container.get(preferences_1.PreferenceService);
        const contribution = ctx.container.get(exports.DebugPreferenceContribution);
        return createDebugPreferences(preferences, contribution.schema);
    }).inSingletonScope();
    bind(exports.DebugPreferenceContribution).toConstantValue({ schema: exports.debugPreferencesSchema });
    bind(preferences_1.PreferenceContribution).toService(exports.DebugPreferenceContribution);
}
exports.bindDebugPreferences = bindDebugPreferences;


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/debug-schema-updater.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/debug-schema-updater.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.launchSchemaId = exports.DebugSchemaUpdater = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const json_schema_store_1 = __webpack_require__(/*! @theia/core/lib/browser/json-schema-store */ "../../node_modules/@theia/core/lib/browser/json-schema-store.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const debug_service_1 = __webpack_require__(/*! ../common/debug-service */ "../../node_modules/@theia/debug/lib/common/debug-service.js");
const debug_preferences_1 = __webpack_require__(/*! ./debug-preferences */ "../../node_modules/@theia/debug/lib/browser/debug-preferences.js");
const variable_input_schema_1 = __webpack_require__(/*! @theia/variable-resolver/lib/browser/variable-input-schema */ "../../node_modules/@theia/variable-resolver/lib/browser/variable-input-schema.js");
const browser_1 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const debug_compound_1 = __webpack_require__(/*! ../common/debug-compound */ "../../node_modules/@theia/debug/lib/common/debug-compound.js");
let DebugSchemaUpdater = class DebugSchemaUpdater {
    constructor() {
        this.uri = new uri_1.default(exports.launchSchemaId);
    }
    init() {
        this.jsonStorage.setSchema(this.uri, '');
    }
    registerSchemas(context) {
        context.registerSchema({
            fileMatch: ['launch.json'],
            url: this.uri.toString()
        });
        this.workspaceService.updateSchema('launch', { $ref: this.uri.toString() });
    }
    async update() {
        const types = await this.debug.debugTypes();
        const schema = { ...(0, common_1.deepClone)(launchSchema) };
        const items = schema.properties['configurations'].items;
        const attributePromises = types.map(type => this.debug.getSchemaAttributes(type));
        for (const attributes of await Promise.all(attributePromises)) {
            for (const attribute of attributes) {
                const properties = {};
                for (const key of ['debugViewLocation', 'openDebug', 'internalConsoleOptions']) {
                    properties[key] = debug_preferences_1.debugPreferencesSchema.properties[`debug.${key}`];
                }
                attribute.properties = Object.assign(properties, attribute.properties);
                items.oneOf.push(attribute);
            }
        }
        items.defaultSnippets.push(...await this.debug.getConfigurationSnippets());
        this.jsonStorage.setSchema(this.uri, schema);
    }
};
exports.DebugSchemaUpdater = DebugSchemaUpdater;
tslib_1.__decorate([
    (0, inversify_1.inject)(json_schema_store_1.JsonSchemaDataStore),
    tslib_1.__metadata("design:type", json_schema_store_1.JsonSchemaDataStore)
], DebugSchemaUpdater.prototype, "jsonStorage", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.WorkspaceService),
    tslib_1.__metadata("design:type", browser_1.WorkspaceService)
], DebugSchemaUpdater.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_service_1.DebugService),
    tslib_1.__metadata("design:type", Object)
], DebugSchemaUpdater.prototype, "debug", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugSchemaUpdater.prototype, "init", null);
exports.DebugSchemaUpdater = DebugSchemaUpdater = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugSchemaUpdater);
exports.launchSchemaId = 'vscode://schemas/launch';
const launchSchema = {
    $id: exports.launchSchemaId,
    type: 'object',
    title: common_1.nls.localizeByDefault('Launch'),
    required: [],
    default: { version: '0.2.0', configurations: [], compounds: [] },
    properties: {
        version: {
            type: 'string',
            description: common_1.nls.localizeByDefault('Version of this file format.'),
            default: '0.2.0'
        },
        configurations: {
            type: 'array',
            description: common_1.nls.localizeByDefault('List of configurations. Add new configurations or edit existing ones by using IntelliSense.'),
            items: {
                defaultSnippets: [],
                'type': 'object',
                oneOf: []
            }
        },
        compounds: {
            type: 'array',
            description: common_1.nls.localizeByDefault('List of compounds. Each compound references multiple configurations which will get launched together.'),
            items: {
                type: 'object',
                required: ['name', 'configurations'],
                properties: {
                    name: {
                        type: 'string',
                        description: common_1.nls.localizeByDefault('Name of compound. Appears in the launch configuration drop down menu.')
                    },
                    configurations: {
                        type: 'array',
                        default: [],
                        items: {
                            oneOf: [{
                                    type: 'string',
                                    description: common_1.nls.localizeByDefault('Please use unique configuration names.')
                                }, {
                                    type: 'object',
                                    required: ['name'],
                                    properties: {
                                        name: {
                                            enum: [],
                                            description: common_1.nls.localizeByDefault('Name of compound. Appears in the launch configuration drop down menu.')
                                        },
                                        folder: {
                                            enum: [],
                                            description: common_1.nls.localizeByDefault('Name of folder in which the compound is located.')
                                        }
                                    }
                                }]
                        },
                        description: common_1.nls.localizeByDefault('Names of configurations that will be started as part of this compound.')
                    },
                    stopAll: {
                        type: 'boolean',
                        default: false,
                        description: common_1.nls.localizeByDefault('Controls whether manually terminating one session will stop all of the compound sessions.')
                    },
                    preLaunchTask: {
                        type: 'string',
                        default: '',
                        description: common_1.nls.localizeByDefault('Task to run before any of the compound configurations start.')
                    }
                },
                default: debug_compound_1.defaultCompound
            },
            default: [debug_compound_1.defaultCompound]
        },
        inputs: variable_input_schema_1.inputsSchema.definitions.inputs
    },
    allowComments: true,
    allowTrailingCommas: true,
};


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/debug-session-configuration-label-provider.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/debug-session-configuration-label-provider.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugSessionConfigurationLabelProvider = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
/**
 * Provides a label for the debug session without the need to create the session.
 * Debug session labels are used to check if sessions are the "same".
 */
let DebugSessionConfigurationLabelProvider = class DebugSessionConfigurationLabelProvider {
    // https://github.com/microsoft/vscode/blob/907518a25c6d6b9467cbcc57132c6adb7e7396b0/src/vs/workbench/contrib/debug/browser/debugSession.ts#L253-L256
    getLabel(params, includeRoot = this.workspaceService.tryGetRoots().length > 1) {
        let { name, workspaceFolderUri } = params;
        if (includeRoot && workspaceFolderUri) {
            const uri = new uri_1.default(workspaceFolderUri);
            const path = uri.path;
            const basenameOrAuthority = path.name || uri.authority;
            name += ` (${basenameOrAuthority})`;
        }
        return name;
    }
};
exports.DebugSessionConfigurationLabelProvider = DebugSessionConfigurationLabelProvider;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.WorkspaceService),
    tslib_1.__metadata("design:type", browser_1.WorkspaceService)
], DebugSessionConfigurationLabelProvider.prototype, "workspaceService", void 0);
exports.DebugSessionConfigurationLabelProvider = DebugSessionConfigurationLabelProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugSessionConfigurationLabelProvider);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/debug-session-connection.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/debug-session-connection.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugSessionConnection = exports.DebugEventTypes = void 0;
const promise_util_1 = __webpack_require__(/*! @theia/core/lib/common/promise-util */ "../../node_modules/@theia/core/lib/common/promise-util.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
var DebugEventTypes;
(function (DebugEventTypes) {
    function isStandardEvent(event) {
        return standardDebugEvents.has(event);
    }
    DebugEventTypes.isStandardEvent = isStandardEvent;
    ;
})(DebugEventTypes || (exports.DebugEventTypes = DebugEventTypes = {}));
const standardDebugEvents = new Set([
    'breakpoint',
    'capabilities',
    'continued',
    'exited',
    'initialized',
    'invalidated',
    'loadedSource',
    'module',
    'output',
    'process',
    'progressEnd',
    'progressStart',
    'progressUpdate',
    'stopped',
    'terminated',
    'thread'
]);
class DebugSessionConnection {
    constructor(sessionId, connectionFactory, traceOutputChannel) {
        this.sessionId = sessionId;
        this.traceOutputChannel = traceOutputChannel;
        this.sequence = 1;
        this.pendingRequests = new Map();
        this.requestHandlers = new Map();
        this.onDidCustomEventEmitter = new core_1.Emitter();
        this.onDidCustomEvent = this.onDidCustomEventEmitter.event;
        this.onDidCloseEmitter = new core_1.Emitter();
        this.onDidClose = this.onDidCloseEmitter.event;
        this.isClosed = false;
        this.toDispose = new core_1.DisposableCollection(this.onDidCustomEventEmitter, core_1.Disposable.create(() => this.pendingRequests.clear()), core_1.Disposable.create(() => this.emitters.clear()));
        this.allThreadsContinued = true;
        this.emitters = new Map();
        this.connectionPromise = this.createConnection(connectionFactory);
    }
    get disposed() {
        return this.toDispose.disposed;
    }
    checkDisposed() {
        if (this.disposed) {
            throw new Error('the debug session connection is disposed, id: ' + this.sessionId);
        }
    }
    dispose() {
        this.toDispose.dispose();
    }
    async createConnection(connectionFactory) {
        const connection = await connectionFactory(this.sessionId);
        connection.onClose(() => {
            this.isClosed = true;
            this.cancelPendingRequests();
            this.onDidCloseEmitter.fire();
        });
        connection.onMessage(data => this.handleMessage(data));
        return connection;
    }
    async sendRequest(command, args, timeout) {
        const result = await this.doSendRequest(command, args, timeout);
        if (command === 'next' || command === 'stepIn' ||
            command === 'stepOut' || command === 'stepBack' ||
            command === 'reverseContinue' || command === 'restartFrame') {
            this.fireContinuedEvent(args.threadId);
        }
        if (command === 'continue') {
            const response = result;
            const allThreadsContinued = response && response.body && response.body.allThreadsContinued;
            if (allThreadsContinued !== undefined) {
                this.allThreadsContinued = result.body.allThreadsContinued;
            }
            this.fireContinuedEvent(args.threadId, this.allThreadsContinued);
            return result;
        }
        return result;
    }
    sendCustomRequest(command, args) {
        return this.doSendRequest(command, args);
    }
    cancelPendingRequests() {
        this.pendingRequests.forEach((deferred, requestId) => {
            deferred.reject(new Error(`Request ${requestId} cancelled on connection close`));
        });
    }
    doSendRequest(command, args, timeout) {
        const result = new promise_util_1.Deferred();
        if (this.isClosed) {
            result.reject(new Error('Connection is closed'));
        }
        else {
            const request = {
                seq: this.sequence++,
                type: 'request',
                command: command,
                arguments: args
            };
            this.pendingRequests.set(request.seq, result);
            if (timeout) {
                const handle = setTimeout(() => {
                    const pendingRequest = this.pendingRequests.get(request.seq);
                    if (pendingRequest) {
                        // request has not been handled
                        this.pendingRequests.delete(request.seq);
                        const error = {
                            type: 'response',
                            seq: 0,
                            request_seq: request.seq,
                            success: false,
                            command,
                            message: `Request #${request.seq}: ${request.command} timed out`
                        };
                        pendingRequest.reject(error);
                    }
                }, timeout);
                result.promise.finally(() => clearTimeout(handle));
            }
            this.send(request);
        }
        return result.promise;
    }
    async send(message) {
        const connection = await this.connectionPromise;
        const messageStr = JSON.stringify(message);
        if (this.traceOutputChannel) {
            const now = new Date();
            const dateStr = `${now.toLocaleString(undefined, { hour12: false })}.${now.getMilliseconds()}`;
            this.traceOutputChannel.appendLine(`${this.sessionId.substring(0, 8)} ${dateStr} theia -> adapter: ${JSON.stringify(message, undefined, 4)}`);
        }
        connection.send(messageStr);
    }
    handleMessage(data) {
        const message = JSON.parse(data);
        if (this.traceOutputChannel) {
            const now = new Date();
            const dateStr = `${now.toLocaleString(undefined, { hour12: false })}.${now.getMilliseconds()}`;
            this.traceOutputChannel.appendLine(`${this.sessionId.substring(0, 8)} ${dateStr} theia <- adapter: ${JSON.stringify(message, undefined, 4)}`);
        }
        if (message.type === 'request') {
            this.handleRequest(message);
        }
        else if (message.type === 'response') {
            this.handleResponse(message);
        }
        else if (message.type === 'event') {
            this.handleEvent(message);
        }
    }
    handleResponse(response) {
        const pendingRequest = this.pendingRequests.get(response.request_seq);
        if (pendingRequest) {
            this.pendingRequests.delete(response.request_seq);
            if (!response.success) {
                pendingRequest.reject(response);
            }
            else {
                pendingRequest.resolve(response);
            }
        }
    }
    onRequest(command, handler) {
        this.requestHandlers.set(command, handler);
    }
    async handleRequest(request) {
        const response = {
            type: 'response',
            seq: 0,
            command: request.command,
            request_seq: request.seq,
            success: true,
        };
        const handler = this.requestHandlers.get(request.command);
        if (handler) {
            try {
                response.body = await handler(request);
            }
            catch (error) {
                response.success = false;
                response.message = error.message;
            }
        }
        else {
            console.error('Unhandled request', request);
        }
        await this.send(response);
    }
    handleEvent(event) {
        if (event.event === 'continued') {
            this.allThreadsContinued = event.body.allThreadsContinued === false ? false : true;
        }
        if (DebugEventTypes.isStandardEvent(event.event)) {
            this.doFire(event.event, event);
        }
        else {
            this.onDidCustomEventEmitter.fire(event);
        }
    }
    on(kind, listener) {
        return this.getEmitter(kind).event(listener);
    }
    onEvent(kind) {
        return this.getEmitter(kind).event;
    }
    fire(kind, e) {
        this.doFire(kind, e);
    }
    doFire(kind, e) {
        this.getEmitter(kind).fire(e);
    }
    getEmitter(kind) {
        const emitter = this.emitters.get(kind) || this.newEmitter();
        this.emitters.set(kind, emitter);
        return emitter;
    }
    newEmitter() {
        const emitter = new core_1.Emitter();
        this.checkDisposed();
        this.toDispose.push(emitter);
        return emitter;
    }
    fireContinuedEvent(threadId, allThreadsContinued = false) {
        this.fire('continued', {
            type: 'event',
            event: 'continued',
            body: {
                threadId,
                allThreadsContinued
            },
            seq: -1
        });
    }
}
exports.DebugSessionConnection = DebugSessionConnection;


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/debug-session-contribution.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/debug-session-contribution.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DefaultDebugSessionFactory = exports.DebugSessionFactory = exports.DebugSessionContributionRegistryImpl = exports.DebugSessionContributionRegistry = exports.DebugSessionContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const browser_2 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const terminal_service_1 = __webpack_require__(/*! @theia/terminal/lib/browser/base/terminal-service */ "../../node_modules/@theia/terminal/lib/browser/base/terminal-service.js");
const debug_session_1 = __webpack_require__(/*! ./debug-session */ "../../node_modules/@theia/debug/lib/browser/debug-session.js");
const breakpoint_manager_1 = __webpack_require__(/*! ./breakpoint/breakpoint-manager */ "../../node_modules/@theia/debug/lib/browser/breakpoint/breakpoint-manager.js");
const output_channel_1 = __webpack_require__(/*! @theia/output/lib/browser/output-channel */ "../../node_modules/@theia/output/lib/browser/output-channel.js");
const debug_preferences_1 = __webpack_require__(/*! ./debug-preferences */ "../../node_modules/@theia/debug/lib/browser/debug-preferences.js");
const debug_session_connection_1 = __webpack_require__(/*! ./debug-session-connection */ "../../node_modules/@theia/debug/lib/browser/debug-session-connection.js");
const debug_service_1 = __webpack_require__(/*! ../common/debug-service */ "../../node_modules/@theia/debug/lib/common/debug-service.js");
const contribution_provider_1 = __webpack_require__(/*! @theia/core/lib/common/contribution-provider */ "../../node_modules/@theia/core/lib/common/contribution-provider.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const debug_contribution_1 = __webpack_require__(/*! ./debug-contribution */ "../../node_modules/@theia/debug/lib/browser/debug-contribution.js");
const browser_3 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const service_connection_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/messaging/service-connection-provider */ "../../node_modules/@theia/core/lib/browser/messaging/service-connection-provider.js");
const test_service_1 = __webpack_require__(/*! @theia/test/lib/browser/test-service */ "../../node_modules/@theia/test/lib/browser/test-service.js");
/**
 * DebugSessionContribution symbol for DI.
 */
exports.DebugSessionContribution = Symbol('DebugSessionContribution');
/**
 * DebugSessionContributionRegistry symbol for DI.
 */
exports.DebugSessionContributionRegistry = Symbol('DebugSessionContributionRegistry');
let DebugSessionContributionRegistryImpl = class DebugSessionContributionRegistryImpl {
    constructor() {
        this.contribs = new Map();
    }
    init() {
        for (const contrib of this.contributions.getContributions()) {
            this.contribs.set(contrib.debugType, contrib);
        }
    }
    get(debugType) {
        return this.contribs.get(debugType);
    }
};
exports.DebugSessionContributionRegistryImpl = DebugSessionContributionRegistryImpl;
tslib_1.__decorate([
    (0, inversify_1.inject)(contribution_provider_1.ContributionProvider),
    (0, inversify_1.named)(exports.DebugSessionContribution),
    tslib_1.__metadata("design:type", Object)
], DebugSessionContributionRegistryImpl.prototype, "contributions", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugSessionContributionRegistryImpl.prototype, "init", null);
exports.DebugSessionContributionRegistryImpl = DebugSessionContributionRegistryImpl = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugSessionContributionRegistryImpl);
/**
 * DebugSessionFactory symbol for DI.
 */
exports.DebugSessionFactory = Symbol('DebugSessionFactory');
let DefaultDebugSessionFactory = class DefaultDebugSessionFactory {
    get(manager, sessionId, options, parentSession) {
        const connection = new debug_session_connection_1.DebugSessionConnection(sessionId, () => new Promise(resolve => this.connectionProvider.listen(`${debug_service_1.DebugAdapterPath}/${sessionId}`, (_, wsChannel) => {
            resolve(new debug_service_1.ForwardingDebugChannel(wsChannel));
        }, false)), this.getTraceOutputChannel());
        return new debug_session_1.DebugSession(sessionId, options, parentSession, this.testService, options.testRun, manager, connection, this.terminalService, this.editorManager, this.breakpoints, this.labelProvider, this.messages, this.fileService, this.debugContributionProvider, this.workspaceService);
    }
    getTraceOutputChannel() {
        if (this.debugPreferences['debug.trace']) {
            return this.outputChannelManager.getChannel('Debug adapters');
        }
    }
};
exports.DefaultDebugSessionFactory = DefaultDebugSessionFactory;
tslib_1.__decorate([
    (0, inversify_1.inject)(service_connection_provider_1.RemoteConnectionProvider),
    tslib_1.__metadata("design:type", service_connection_provider_1.ServiceConnectionProvider)
], DefaultDebugSessionFactory.prototype, "connectionProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(terminal_service_1.TerminalService),
    tslib_1.__metadata("design:type", Object)
], DefaultDebugSessionFactory.prototype, "terminalService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.EditorManager),
    tslib_1.__metadata("design:type", browser_2.EditorManager)
], DefaultDebugSessionFactory.prototype, "editorManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(breakpoint_manager_1.BreakpointManager),
    tslib_1.__metadata("design:type", breakpoint_manager_1.BreakpointManager)
], DefaultDebugSessionFactory.prototype, "breakpoints", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.LabelProvider),
    tslib_1.__metadata("design:type", browser_1.LabelProvider)
], DefaultDebugSessionFactory.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.MessageClient),
    tslib_1.__metadata("design:type", common_1.MessageClient)
], DefaultDebugSessionFactory.prototype, "messages", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(output_channel_1.OutputChannelManager),
    tslib_1.__metadata("design:type", output_channel_1.OutputChannelManager)
], DefaultDebugSessionFactory.prototype, "outputChannelManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_preferences_1.DebugPreferences),
    tslib_1.__metadata("design:type", Object)
], DefaultDebugSessionFactory.prototype, "debugPreferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], DefaultDebugSessionFactory.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(contribution_provider_1.ContributionProvider),
    (0, inversify_1.named)(debug_contribution_1.DebugContribution),
    tslib_1.__metadata("design:type", Object)
], DefaultDebugSessionFactory.prototype, "debugContributionProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(test_service_1.TestService),
    tslib_1.__metadata("design:type", Object)
], DefaultDebugSessionFactory.prototype, "testService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_3.WorkspaceService),
    tslib_1.__metadata("design:type", browser_3.WorkspaceService)
], DefaultDebugSessionFactory.prototype, "workspaceService", void 0);
exports.DefaultDebugSessionFactory = DefaultDebugSessionFactory = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DefaultDebugSessionFactory);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/debug-session-manager.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/debug-session-manager.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugSessionManager = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const browser_2 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const quick_open_task_1 = __webpack_require__(/*! @theia/task/lib/browser/quick-open-task */ "../../node_modules/@theia/task/lib/browser/quick-open-task.js");
const task_service_1 = __webpack_require__(/*! @theia/task/lib/browser/task-service */ "../../node_modules/@theia/task/lib/browser/task-service.js");
const browser_3 = __webpack_require__(/*! @theia/variable-resolver/lib/browser */ "../../node_modules/@theia/variable-resolver/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const debug_service_1 = __webpack_require__(/*! ../common/debug-service */ "../../node_modules/@theia/debug/lib/common/debug-service.js");
const breakpoint_manager_1 = __webpack_require__(/*! ./breakpoint/breakpoint-manager */ "../../node_modules/@theia/debug/lib/browser/breakpoint/breakpoint-manager.js");
const debug_configuration_manager_1 = __webpack_require__(/*! ./debug-configuration-manager */ "../../node_modules/@theia/debug/lib/browser/debug-configuration-manager.js");
const debug_session_1 = __webpack_require__(/*! ./debug-session */ "../../node_modules/@theia/debug/lib/browser/debug-session.js");
const debug_session_contribution_1 = __webpack_require__(/*! ./debug-session-contribution */ "../../node_modules/@theia/debug/lib/browser/debug-session-contribution.js");
const debug_session_options_1 = __webpack_require__(/*! ./debug-session-options */ "../../node_modules/@theia/debug/lib/browser/debug-session-options.js");
const debug_source_breakpoint_1 = __webpack_require__(/*! ./model/debug-source-breakpoint */ "../../node_modules/@theia/debug/lib/browser/model/debug-source-breakpoint.js");
const debug_function_breakpoint_1 = __webpack_require__(/*! ./model/debug-function-breakpoint */ "../../node_modules/@theia/debug/lib/browser/model/debug-function-breakpoint.js");
const debug_instruction_breakpoint_1 = __webpack_require__(/*! ./model/debug-instruction-breakpoint */ "../../node_modules/@theia/debug/lib/browser/model/debug-instruction-breakpoint.js");
const debug_widget_1 = __webpack_require__(/*! ./view/debug-widget */ "../../node_modules/@theia/debug/lib/browser/view/debug-widget.js");
const debug_session_configuration_label_provider_1 = __webpack_require__(/*! ./debug-session-configuration-label-provider */ "../../node_modules/@theia/debug/lib/browser/debug-session-configuration-label-provider.js");
let DebugSessionManager = class DebugSessionManager {
    constructor() {
        this._sessions = new Map();
        this.onWillStartDebugSessionEmitter = new core_1.Emitter();
        this.onWillStartDebugSession = this.onWillStartDebugSessionEmitter.event;
        this.onWillResolveDebugConfigurationEmitter = new core_1.Emitter();
        this.onWillResolveDebugConfiguration = this.onWillResolveDebugConfigurationEmitter.event;
        this.onDidCreateDebugSessionEmitter = new core_1.Emitter();
        this.onDidCreateDebugSession = this.onDidCreateDebugSessionEmitter.event;
        this.onDidStartDebugSessionEmitter = new core_1.Emitter();
        this.onDidStartDebugSession = this.onDidStartDebugSessionEmitter.event;
        this.onDidStopDebugSessionEmitter = new core_1.Emitter();
        this.onDidStopDebugSession = this.onDidStopDebugSessionEmitter.event;
        this.onDidChangeActiveDebugSessionEmitter = new core_1.Emitter();
        this.onDidChangeActiveDebugSession = this.onDidChangeActiveDebugSessionEmitter.event;
        this.onDidDestroyDebugSessionEmitter = new core_1.Emitter();
        this.onDidDestroyDebugSession = this.onDidDestroyDebugSessionEmitter.event;
        this.onDidReceiveDebugSessionCustomEventEmitter = new core_1.Emitter();
        this.onDidReceiveDebugSessionCustomEvent = this.onDidReceiveDebugSessionCustomEventEmitter.event;
        this.onDidFocusStackFrameEmitter = new core_1.Emitter();
        this.onDidFocusStackFrame = this.onDidFocusStackFrameEmitter.event;
        this.onDidFocusThreadEmitter = new core_1.Emitter();
        this.onDidFocusThread = this.onDidFocusThreadEmitter.event;
        this.onDidChangeBreakpointsEmitter = new core_1.Emitter();
        this.onDidChangeBreakpoints = this.onDidChangeBreakpointsEmitter.event;
        this.onDidChangeEmitter = new core_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
        this.configurationIds = new Map();
        this.disposeOnCurrentSessionChanged = new core_1.DisposableCollection();
    }
    fireDidChangeBreakpoints(event) {
        this.onDidChangeBreakpointsEmitter.fire(event);
    }
    fireDidChange(current) {
        this.debugTypeKey.set(current === null || current === void 0 ? void 0 : current.configuration.type);
        this.inDebugModeKey.set(this.inDebugMode);
        this.debugStateKey.set((0, debug_session_1.debugStateContextValue)(this.state));
        this.onDidChangeEmitter.fire(current);
    }
    init() {
        this.debugTypeKey = this.contextKeyService.createKey('debugType', undefined);
        this.inDebugModeKey = this.contextKeyService.createKey('inDebugMode', this.inDebugMode);
        this.debugStateKey = this.contextKeyService.createKey('debugState', (0, debug_session_1.debugStateContextValue)(this.state));
        this.breakpoints.onDidChangeMarkers(uri => this.fireDidChangeBreakpoints({ uri }));
        this.labelProvider.onDidChange(event => {
            for (const uriString of this.breakpoints.getUris()) {
                const uri = new uri_1.default(uriString);
                if (event.affects(uri)) {
                    this.fireDidChangeBreakpoints({ uri });
                }
            }
        });
    }
    get inDebugMode() {
        return this.state > debug_session_1.DebugState.Inactive;
    }
    isCurrentEditorFrame(uri) {
        var _a, _b;
        return ((_b = (_a = this.currentFrame) === null || _a === void 0 ? void 0 : _a.source) === null || _b === void 0 ? void 0 : _b.uri.toString()) === (uri instanceof uri_1.default ? uri : new uri_1.default(uri.toString())).toString();
    }
    async saveAll() {
        if (!this.shell.canSaveAll()) {
            return true; // Nothing to save.
        }
        try {
            await this.shell.saveAll();
            return true;
        }
        catch (error) {
            console.error('saveAll failed:', error);
            return false;
        }
    }
    async start(optionsOrName) {
        if (typeof optionsOrName === 'string') {
            const options = this.debugConfigurationManager.find(optionsOrName);
            return !!options && this.start(options);
        }
        return optionsOrName.configuration ? this.startConfiguration(optionsOrName) : this.startCompound(optionsOrName);
    }
    async startConfiguration(options) {
        return this.progressService.withProgress('Start...', 'debug', async () => {
            try {
                // If a parent session is available saving should be handled by the parent
                if (!options.configuration.parentSessionId && !options.configuration.suppressSaveBeforeStart && !await this.saveAll()) {
                    return undefined;
                }
                await this.fireWillStartDebugSession();
                const resolved = await this.resolveConfiguration(options);
                if (!resolved || !resolved.configuration) {
                    // As per vscode API: https://code.visualstudio.com/api/references/vscode-api#DebugConfigurationProvider
                    // "Returning the value 'undefined' prevents the debug session from starting.
                    // Returning the value 'null' prevents the debug session from starting and opens the
                    // underlying debug configuration instead."
                    // eslint-disable-next-line no-null/no-null
                    if (resolved === null) {
                        this.debugConfigurationManager.openConfiguration();
                    }
                    return undefined;
                }
                const sessionConfigurationLabel = this.sessionConfigurationLabelProvider.getLabel(resolved);
                if ((options === null || options === void 0 ? void 0 : options.startedByUser)
                    && options.configuration.suppressMultipleSessionWarning !== true
                    && this.sessions.some(s => this.sessionConfigurationLabelProvider.getLabel(s.options) === sessionConfigurationLabel)) {
                    const yes = await new browser_1.ConfirmDialog({
                        title: debug_widget_1.DebugWidget.LABEL,
                        msg: core_1.nls.localizeByDefault("'{0}' is already running. Do you want to start another instance?", sessionConfigurationLabel)
                    }).open();
                    if (!yes) {
                        return undefined;
                    }
                }
                // preLaunchTask isn't run in case of auto restart as well as postDebugTask
                if (!options.configuration.__restart) {
                    const taskRun = await this.runTask(options.workspaceFolderUri, resolved.configuration.preLaunchTask, true);
                    if (!taskRun) {
                        return undefined;
                    }
                }
                const sessionId = await this.debug.createDebugSession(resolved.configuration, options.workspaceFolderUri);
                return this.doStart(sessionId, resolved);
            }
            catch (e) {
                if (debug_service_1.DebugError.NotFound.is(e)) {
                    this.messageService.error(`The debug session type "${e.data.type}" is not supported.`);
                    return undefined;
                }
                this.messageService.error('There was an error starting the debug session, check the logs for more details.');
                console.error('Error starting the debug session', e);
                throw e;
            }
        });
    }
    async startCompound(options) {
        let configurations = [];
        const compoundRoot = options.compound.stopAll ? new debug_session_options_1.DebugCompoundRoot() : undefined;
        try {
            configurations = this.getCompoundConfigurations(options, compoundRoot);
        }
        catch (error) {
            this.messageService.error(error.message);
            return;
        }
        if (options.compound.preLaunchTask) {
            const taskRun = await this.runTask(options.workspaceFolderUri, options.compound.preLaunchTask, true);
            if (!taskRun) {
                return undefined;
            }
        }
        // Compound launch is a success only if each configuration launched successfully
        const values = await Promise.all(configurations.map(async (configuration) => {
            const newSession = await this.startConfiguration(configuration);
            if (newSession) {
                compoundRoot === null || compoundRoot === void 0 ? void 0 : compoundRoot.onDidSessionStop(() => newSession.stop(false, () => this.debug.terminateDebugSession(newSession.id)));
            }
            return newSession;
        }));
        const result = values.every(success => !!success);
        return result;
    }
    getCompoundConfigurations(options, compoundRoot) {
        const compound = options.compound;
        if (!compound.configurations) {
            throw new Error(core_1.nls.localizeByDefault('Compound must have "configurations" attribute set in order to start multiple configurations.'));
        }
        const configurations = [];
        for (const configData of compound.configurations) {
            const name = typeof configData === 'string' ? configData : configData.name;
            if (name === compound.name) {
                throw new Error(core_1.nls.localize('theia/debug/compound-cycle', "Launch configuration '{0}' contains a cycle with itself", name));
            }
            const workspaceFolderUri = typeof configData === 'string' ? options.workspaceFolderUri : configData.folder;
            const matchingOptions = [...this.debugConfigurationManager.all]
                .filter(option => option.name === name && !!option.configuration && option.workspaceFolderUri === workspaceFolderUri);
            if (matchingOptions.length === 1) {
                const match = matchingOptions[0];
                if (debug_session_options_1.DebugSessionOptions.isConfiguration(match)) {
                    configurations.push({ ...match, compoundRoot, configuration: { ...match.configuration, noDebug: options.noDebug } });
                }
                else {
                    throw new Error(core_1.nls.localizeByDefault("Could not find launch configuration '{0}' in the workspace.", name));
                }
            }
            else {
                throw new Error(matchingOptions.length === 0
                    ? workspaceFolderUri
                        ? core_1.nls.localizeByDefault("Can not find folder with name '{0}' for configuration '{1}' in compound '{2}'.", workspaceFolderUri, name, compound.name)
                        : core_1.nls.localizeByDefault("Could not find launch configuration '{0}' in the workspace.", name)
                    : core_1.nls.localizeByDefault("There are multiple launch configurations '{0}' in the workspace. Use folder name to qualify the configuration.", name));
            }
        }
        return configurations;
    }
    async fireWillStartDebugSession() {
        await core_1.WaitUntilEvent.fire(this.onWillStartDebugSessionEmitter, {});
    }
    async resolveConfiguration(options) {
        if (debug_session_options_1.InternalDebugSessionOptions.is(options)) {
            return options;
        }
        const { workspaceFolderUri } = options;
        let configuration = await this.resolveDebugConfiguration(options.configuration, workspaceFolderUri);
        if (configuration) {
            // Resolve command variables provided by the debugger
            const commandIdVariables = await this.debug.provideDebuggerVariables(configuration.type);
            configuration = await this.variableResolver.resolve(configuration, {
                context: options.workspaceFolderUri ? new uri_1.default(options.workspaceFolderUri) : undefined,
                configurationSection: 'launch',
                commandIdVariables,
                configuration
            });
            if (configuration) {
                configuration = await this.resolveDebugConfigurationWithSubstitutedVariables(configuration, workspaceFolderUri);
            }
        }
        if (!configuration) {
            return configuration;
        }
        const key = configuration.name + workspaceFolderUri;
        const id = this.configurationIds.has(key) ? this.configurationIds.get(key) + 1 : 0;
        this.configurationIds.set(key, id);
        return {
            id,
            ...options,
            name: configuration.name,
            configuration
        };
    }
    async resolveDebugConfiguration(configuration, workspaceFolderUri) {
        await this.fireWillResolveDebugConfiguration(configuration.type);
        return this.debug.resolveDebugConfiguration(configuration, workspaceFolderUri);
    }
    async fireWillResolveDebugConfiguration(debugType) {
        await core_1.WaitUntilEvent.fire(this.onWillResolveDebugConfigurationEmitter, { debugType });
    }
    async resolveDebugConfigurationWithSubstitutedVariables(configuration, workspaceFolderUri) {
        return this.debug.resolveDebugConfigurationWithSubstitutedVariables(configuration, workspaceFolderUri);
    }
    async doStart(sessionId, options) {
        const parentSession = options.configuration.parentSessionId ? this._sessions.get(options.configuration.parentSessionId) : undefined;
        const contrib = this.sessionContributionRegistry.get(options.configuration.type);
        const sessionFactory = contrib ? contrib.debugSessionFactory() : this.debugSessionFactory;
        const session = sessionFactory.get(this, sessionId, options, parentSession);
        this._sessions.set(sessionId, session);
        this.debugTypeKey.set(session.configuration.type);
        this.onDidCreateDebugSessionEmitter.fire(session);
        let state = debug_session_1.DebugState.Inactive;
        session.onDidChange(() => {
            if (state !== session.state) {
                state = session.state;
                if (state === debug_session_1.DebugState.Stopped) {
                    this.onDidStopDebugSessionEmitter.fire(session);
                }
            }
            this.updateCurrentSession(session);
        });
        session.onDidChangeBreakpoints(uri => this.fireDidChangeBreakpoints({ session, uri }));
        session.on('terminated', async (event) => {
            const restart = event.body && event.body.restart;
            if (restart) {
                // postDebugTask isn't run in case of auto restart as well as preLaunchTask
                this.doRestart(session, !!restart);
            }
            else {
                await session.disconnect(false, () => this.debug.terminateDebugSession(session.id));
                await this.runTask(session.options.workspaceFolderUri, session.configuration.postDebugTask);
            }
        });
        session.on('exited', async (event) => {
            await session.disconnect(false, () => this.debug.terminateDebugSession(session.id));
        });
        session.onDispose(() => this.cleanup(session));
        session.start().then(() => this.onDidStartDebugSessionEmitter.fire(session)).catch(e => {
            session.stop(false, () => {
                this.debug.terminateDebugSession(session.id);
            });
        });
        session.onDidCustomEvent(({ event, body }) => this.onDidReceiveDebugSessionCustomEventEmitter.fire({ event, body, session }));
        return session;
    }
    cleanup(session) {
        if (this.remove(session.id)) {
            this.onDidDestroyDebugSessionEmitter.fire(session);
        }
    }
    async doRestart(session, isRestart) {
        if (session.canRestart()) {
            await session.restart();
            return session;
        }
        const { options, configuration } = session;
        session.stop(isRestart, () => this.debug.terminateDebugSession(session.id));
        configuration.__restart = isRestart;
        return this.start(options);
    }
    async terminateSession(session) {
        if (!session) {
            this.updateCurrentSession(this._currentSession);
            session = this._currentSession;
        }
        if (session) {
            if (session.options.compoundRoot) {
                session.options.compoundRoot.stopSession();
            }
            else if (session.parentSession && session.configuration.lifecycleManagedByParent) {
                this.terminateSession(session.parentSession);
            }
            else {
                session.stop(false, () => this.debug.terminateDebugSession(session.id));
            }
        }
    }
    async restartSession(session) {
        if (!session) {
            this.updateCurrentSession(this._currentSession);
            session = this._currentSession;
        }
        if (session) {
            if (session.parentSession && session.configuration.lifecycleManagedByParent) {
                return this.restartSession(session.parentSession);
            }
            else {
                return this.doRestart(session, true);
            }
        }
    }
    remove(sessionId) {
        const existed = this._sessions.delete(sessionId);
        const { currentSession } = this;
        if (currentSession && currentSession.id === sessionId) {
            this.updateCurrentSession(undefined);
        }
        return existed;
    }
    getSession(sessionId) {
        return this._sessions.get(sessionId);
    }
    get sessions() {
        return Array.from(this._sessions.values()).filter(session => session.state > debug_session_1.DebugState.Inactive);
    }
    get currentSession() {
        return this._currentSession;
    }
    set currentSession(current) {
        if (this._currentSession === current) {
            return;
        }
        this.disposeOnCurrentSessionChanged.dispose();
        const previous = this.currentSession;
        this._currentSession = current;
        this.onDidChangeActiveDebugSessionEmitter.fire({ previous, current });
        if (current) {
            this.disposeOnCurrentSessionChanged.push(current.onDidChange(() => {
                if (this.currentFrame === this.topFrame) {
                    this.open();
                }
                this.fireDidChange(current);
            }));
            this.disposeOnCurrentSessionChanged.push(current.onDidFocusStackFrame(frame => this.onDidFocusStackFrameEmitter.fire(frame)));
            this.disposeOnCurrentSessionChanged.push(current.onDidFocusThread(thread => this.onDidFocusThreadEmitter.fire(thread)));
            const { currentThread } = current;
            this.onDidFocusThreadEmitter.fire(currentThread);
        }
        this.updateBreakpoints(previous, current);
        this.open();
        this.fireDidChange(current);
    }
    open() {
        const { currentFrame } = this;
        if (currentFrame && currentFrame.thread.stopped) {
            currentFrame.open();
        }
    }
    updateBreakpoints(previous, current) {
        const affectedUri = new Set();
        for (const session of [previous, current]) {
            if (session) {
                for (const uriString of session.breakpointUris) {
                    if (!affectedUri.has(uriString)) {
                        affectedUri.add(uriString);
                        this.fireDidChangeBreakpoints({
                            session: current,
                            uri: new uri_1.default(uriString)
                        });
                    }
                }
            }
        }
    }
    updateCurrentSession(session) {
        this.currentSession = session || this.sessions[0];
    }
    get currentThread() {
        const session = this.currentSession;
        return session && session.currentThread;
    }
    get state() {
        const session = this.currentSession;
        return session ? session.state : debug_session_1.DebugState.Inactive;
    }
    get currentFrame() {
        const { currentThread } = this;
        return currentThread && currentThread.currentFrame;
    }
    get topFrame() {
        const { currentThread } = this;
        return currentThread && currentThread.topFrame;
    }
    getFunctionBreakpoints(session = this.currentSession) {
        if (session && session.state > debug_session_1.DebugState.Initializing) {
            return session.getFunctionBreakpoints();
        }
        const { labelProvider, breakpoints, editorManager } = this;
        return this.breakpoints.getFunctionBreakpoints().map(origin => new debug_function_breakpoint_1.DebugFunctionBreakpoint(origin, { labelProvider, breakpoints, editorManager }));
    }
    getInstructionBreakpoints(session = this.currentSession) {
        if (session && session.state > debug_session_1.DebugState.Initializing) {
            return session.getInstructionBreakpoints();
        }
        const { labelProvider, breakpoints, editorManager } = this;
        return this.breakpoints.getInstructionBreakpoints().map(origin => new debug_instruction_breakpoint_1.DebugInstructionBreakpoint(origin, { labelProvider, breakpoints, editorManager }));
    }
    getBreakpoints(arg, arg2) {
        const uri = arg instanceof uri_1.default ? arg : undefined;
        const session = arg instanceof debug_session_1.DebugSession ? arg : arg2 instanceof debug_session_1.DebugSession ? arg2 : this.currentSession;
        if (session && session.state > debug_session_1.DebugState.Initializing) {
            return session.getSourceBreakpoints(uri);
        }
        const { labelProvider, breakpoints, editorManager } = this;
        return this.breakpoints.findMarkers({ uri }).map(({ data }) => new debug_source_breakpoint_1.DebugSourceBreakpoint(data, { labelProvider, breakpoints, editorManager }));
    }
    getLineBreakpoints(uri, line) {
        const session = this.currentSession;
        if (session && session.state > debug_session_1.DebugState.Initializing) {
            return session.getSourceBreakpoints(uri).filter(breakpoint => breakpoint.line === line);
        }
        const { labelProvider, breakpoints, editorManager } = this;
        return this.breakpoints.getLineBreakpoints(uri, line).map(origin => new debug_source_breakpoint_1.DebugSourceBreakpoint(origin, { labelProvider, breakpoints, editorManager }));
    }
    getInlineBreakpoint(uri, line, column) {
        const session = this.currentSession;
        if (session && session.state > debug_session_1.DebugState.Initializing) {
            return session.getSourceBreakpoints(uri).filter(breakpoint => breakpoint.line === line && breakpoint.column === column)[0];
        }
        const origin = this.breakpoints.getInlineBreakpoint(uri, line, column);
        const { labelProvider, breakpoints, editorManager } = this;
        return origin && new debug_source_breakpoint_1.DebugSourceBreakpoint(origin, { labelProvider, breakpoints, editorManager });
    }
    /**
     * Runs the given tasks.
     * @param taskName the task name to run, see [TaskNameResolver](#TaskNameResolver)
     * @return true if it allowed to continue debugging otherwise it returns false
     */
    async runTask(workspaceFolderUri, taskName, checkErrors) {
        if (!taskName) {
            return true;
        }
        const taskInfo = await this.taskService.runWorkspaceTask(this.taskService.startUserAction(), workspaceFolderUri, taskName);
        if (!checkErrors) {
            return true;
        }
        if (!taskInfo) {
            return this.doPostTaskAction(`Could not run the task '${taskName}'.`);
        }
        const getExitCodePromise = this.taskService.getExitCode(taskInfo.taskId).then(result => ({ taskEndedType: task_service_1.TaskEndedTypes.TaskExited, value: result }));
        const isBackgroundTaskEndedPromise = this.taskService.isBackgroundTaskEnded(taskInfo.taskId).then(result => ({ taskEndedType: task_service_1.TaskEndedTypes.BackgroundTaskEnded, value: result }));
        // After start running the task, we wait for the task process to exit and if it is a background task, we also wait for a feedback
        // that a background task is active, as soon as one of the promises fulfills, we can continue and analyze the results.
        const taskEndedInfo = await Promise.race([getExitCodePromise, isBackgroundTaskEndedPromise]);
        if (taskEndedInfo.taskEndedType === task_service_1.TaskEndedTypes.BackgroundTaskEnded && taskEndedInfo.value) {
            return true;
        }
        if (taskEndedInfo.taskEndedType === task_service_1.TaskEndedTypes.TaskExited && taskEndedInfo.value === 0) {
            return true;
        }
        else if (taskEndedInfo.taskEndedType === task_service_1.TaskEndedTypes.TaskExited && taskEndedInfo.value !== undefined) {
            return this.doPostTaskAction(`Task '${taskName}' terminated with exit code ${taskEndedInfo.value}.`);
        }
        else {
            const signal = await this.taskService.getTerminateSignal(taskInfo.taskId);
            if (signal !== undefined) {
                return this.doPostTaskAction(`Task '${taskName}' terminated by signal ${signal}.`);
            }
            else {
                return this.doPostTaskAction(`Task '${taskName}' terminated for unknown reason.`);
            }
        }
    }
    async doPostTaskAction(errorMessage) {
        const actions = ['Open launch.json', 'Cancel', 'Configure Task', 'Debug Anyway'];
        const result = await this.messageService.error(errorMessage, ...actions);
        switch (result) {
            case actions[0]: // open launch.json
                this.debugConfigurationManager.openConfiguration();
                return false;
            case actions[1]: // cancel
                return false;
            case actions[2]: // configure tasks
                this.quickOpenTask.configure();
                return false;
            default: // continue debugging
                return true;
        }
    }
};
exports.DebugSessionManager = DebugSessionManager;
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_session_contribution_1.DebugSessionFactory),
    tslib_1.__metadata("design:type", Object)
], DebugSessionManager.prototype, "debugSessionFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_service_1.DebugService),
    tslib_1.__metadata("design:type", Object)
], DebugSessionManager.prototype, "debug", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.LabelProvider),
    tslib_1.__metadata("design:type", browser_1.LabelProvider)
], DebugSessionManager.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.EditorManager),
    tslib_1.__metadata("design:type", browser_2.EditorManager)
], DebugSessionManager.prototype, "editorManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(breakpoint_manager_1.BreakpointManager),
    tslib_1.__metadata("design:type", breakpoint_manager_1.BreakpointManager)
], DebugSessionManager.prototype, "breakpoints", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_3.VariableResolverService),
    tslib_1.__metadata("design:type", browser_3.VariableResolverService)
], DebugSessionManager.prototype, "variableResolver", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_session_contribution_1.DebugSessionContributionRegistry),
    tslib_1.__metadata("design:type", Object)
], DebugSessionManager.prototype, "sessionContributionRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.MessageService),
    tslib_1.__metadata("design:type", core_1.MessageService)
], DebugSessionManager.prototype, "messageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ProgressService),
    tslib_1.__metadata("design:type", core_1.ProgressService)
], DebugSessionManager.prototype, "progressService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    tslib_1.__metadata("design:type", Object)
], DebugSessionManager.prototype, "contextKeyService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(task_service_1.TaskService),
    tslib_1.__metadata("design:type", task_service_1.TaskService)
], DebugSessionManager.prototype, "taskService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_configuration_manager_1.DebugConfigurationManager),
    tslib_1.__metadata("design:type", debug_configuration_manager_1.DebugConfigurationManager)
], DebugSessionManager.prototype, "debugConfigurationManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(quick_open_task_1.QuickOpenTask),
    tslib_1.__metadata("design:type", quick_open_task_1.QuickOpenTask)
], DebugSessionManager.prototype, "quickOpenTask", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ApplicationShell),
    tslib_1.__metadata("design:type", browser_1.ApplicationShell)
], DebugSessionManager.prototype, "shell", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_session_configuration_label_provider_1.DebugSessionConfigurationLabelProvider),
    tslib_1.__metadata("design:type", debug_session_configuration_label_provider_1.DebugSessionConfigurationLabelProvider)
], DebugSessionManager.prototype, "sessionConfigurationLabelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugSessionManager.prototype, "init", null);
exports.DebugSessionManager = DebugSessionManager = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugSessionManager);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/debug-session-options.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/debug-session-options.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InternalDebugSessionOptions = exports.DebugSessionOptions = exports.DebugCompoundRoot = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
class DebugCompoundRoot {
    constructor() {
        this.stopped = false;
        this.stopEmitter = new core_1.Emitter();
        this.onDidSessionStop = this.stopEmitter.event;
    }
    stopSession() {
        if (!this.stopped) { // avoid sending extraneous terminate events
            this.stopped = true;
            this.stopEmitter.fire();
        }
    }
}
exports.DebugCompoundRoot = DebugCompoundRoot;
var DebugSessionOptions;
(function (DebugSessionOptions) {
    function isConfiguration(options) {
        return !!options && 'configuration' in options && !!options.configuration;
    }
    DebugSessionOptions.isConfiguration = isConfiguration;
    function isDynamic(options) {
        return isConfiguration(options) && 'providerType' in options && !!options.providerType;
    }
    DebugSessionOptions.isDynamic = isDynamic;
    function isCompound(options) {
        return !!options && 'compound' in options && !!options.compound;
    }
    DebugSessionOptions.isCompound = isCompound;
})(DebugSessionOptions || (exports.DebugSessionOptions = DebugSessionOptions = {}));
var InternalDebugSessionOptions;
(function (InternalDebugSessionOptions) {
    const SEPARATOR = '__CONF__';
    const SEPARATOR_CONFIGS = '__COMP__';
    function is(options) {
        return 'id' in options;
    }
    InternalDebugSessionOptions.is = is;
    /** @deprecated Please use `JSON.stringify` to serialize the options. */
    function toValue(options) {
        var _a;
        if (DebugSessionOptions.isCompound(options)) {
            return options.compound.name + SEPARATOR +
                options.workspaceFolderUri + SEPARATOR +
                ((_a = options.compound) === null || _a === void 0 ? void 0 : _a.configurations.join(SEPARATOR_CONFIGS));
        }
        return options.configuration.name + SEPARATOR +
            options.configuration.type + SEPARATOR +
            options.configuration.request + SEPARATOR +
            options.workspaceFolderUri + SEPARATOR +
            options.providerType;
    }
    InternalDebugSessionOptions.toValue = toValue;
    /** @deprecated Please use `JSON.parse` to restore previously serialized debug session options. */
    // eslint-disable-next-line deprecation/deprecation
    function parseValue(value) {
        const split = value.split(SEPARATOR);
        if (split.length === 5) {
            return { name: split[0], type: split[1], request: split[2], workspaceFolderUri: split[3], providerType: split[4] };
        }
        if (split.length === 3) {
            return { name: split[0], workspaceFolderUri: split[1], configurations: split[2].split(SEPARATOR_CONFIGS) };
        }
        throw new Error('Unexpected argument, the argument is expected to have been generated by the \'toValue\' function');
    }
    InternalDebugSessionOptions.parseValue = parseValue;
})(InternalDebugSessionOptions || (exports.InternalDebugSessionOptions = InternalDebugSessionOptions = {}));


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/debug-session.js":
/*!********************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/debug-session.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugSession = exports.debugStateContextValue = exports.DebugState = void 0;
/* eslint-disable @typescript-eslint/no-explicit-any */
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const debug_thread_1 = __webpack_require__(/*! ./model/debug-thread */ "../../node_modules/@theia/debug/lib/browser/model/debug-thread.js");
const debug_source_1 = __webpack_require__(/*! ./model/debug-source */ "../../node_modules/@theia/debug/lib/browser/model/debug-source.js");
const debug_source_breakpoint_1 = __webpack_require__(/*! ./model/debug-source-breakpoint */ "../../node_modules/@theia/debug/lib/browser/model/debug-source-breakpoint.js");
const debounce = __webpack_require__(/*! p-debounce */ "../../node_modules/p-debounce/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const breakpoint_manager_1 = __webpack_require__(/*! ./breakpoint/breakpoint-manager */ "../../node_modules/@theia/debug/lib/browser/breakpoint/breakpoint-manager.js");
const debug_session_options_1 = __webpack_require__(/*! ./debug-session-options */ "../../node_modules/@theia/debug/lib/browser/debug-session-options.js");
const debug_common_1 = __webpack_require__(/*! ../common/debug-common */ "../../node_modules/@theia/debug/lib/common/debug-common.js");
const breakpoint_marker_1 = __webpack_require__(/*! ./breakpoint/breakpoint-marker */ "../../node_modules/@theia/debug/lib/browser/breakpoint/breakpoint-marker.js");
const debug_function_breakpoint_1 = __webpack_require__(/*! ./model/debug-function-breakpoint */ "../../node_modules/@theia/debug/lib/browser/model/debug-function-breakpoint.js");
const promise_util_1 = __webpack_require__(/*! @theia/core/lib/common/promise-util */ "../../node_modules/@theia/core/lib/common/promise-util.js");
const debug_instruction_breakpoint_1 = __webpack_require__(/*! ./model/debug-instruction-breakpoint */ "../../node_modules/@theia/debug/lib/browser/model/debug-instruction-breakpoint.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const test_service_1 = __webpack_require__(/*! @theia/test/lib/browser/test-service */ "../../node_modules/@theia/test/lib/browser/test-service.js");
var DebugState;
(function (DebugState) {
    DebugState[DebugState["Inactive"] = 0] = "Inactive";
    DebugState[DebugState["Initializing"] = 1] = "Initializing";
    DebugState[DebugState["Running"] = 2] = "Running";
    DebugState[DebugState["Stopped"] = 3] = "Stopped";
})(DebugState || (exports.DebugState = DebugState = {}));
/**
 * The mapped string values must not change as they are used for the `debugState` when context closure.
 * For more details see the `Debugger contexts` section of the [official doc](https://code.visualstudio.com/api/references/when-clause-contexts#available-contexts).
 */
function debugStateContextValue(state) {
    switch (state) {
        case DebugState.Initializing: return 'initializing';
        case DebugState.Stopped: return 'stopped';
        case DebugState.Running: return 'running';
        default: return 'inactive';
    }
}
exports.debugStateContextValue = debugStateContextValue;
// FIXME: make injectable to allow easily inject services
class DebugSession {
    fireDidChange() {
        this.onDidChangeEmitter.fire(undefined);
    }
    get onDidFocusStackFrame() {
        return this.onDidFocusStackFrameEmitter.event;
    }
    get onDidFocusThread() {
        return this.onDidFocusThreadEmitter.event;
    }
    fireDidChangeBreakpoints(uri) {
        this.onDidChangeBreakpointsEmitter.fire(uri);
    }
    constructor(id, options, parentSession, testService, testRun, sessionManager, connection, terminalServer, editorManager, breakpoints, labelProvider, messages, fileService, debugContributionProvider, workspaceService, 
    /**
     * Number of millis after a `stop` request times out. It's 5 seconds by default.
     */
    stopTimeout = 5000) {
        this.id = id;
        this.options = options;
        this.parentSession = parentSession;
        this.connection = connection;
        this.terminalServer = terminalServer;
        this.editorManager = editorManager;
        this.breakpoints = breakpoints;
        this.labelProvider = labelProvider;
        this.messages = messages;
        this.fileService = fileService;
        this.debugContributionProvider = debugContributionProvider;
        this.workspaceService = workspaceService;
        this.stopTimeout = stopTimeout;
        this.deferredOnDidConfigureCapabilities = new promise_util_1.Deferred();
        this.onDidChangeEmitter = new common_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
        this.onDidFocusStackFrameEmitter = new common_1.Emitter();
        this.onDidFocusThreadEmitter = new common_1.Emitter();
        this.onDidChangeBreakpointsEmitter = new common_1.Emitter();
        this.onDidChangeBreakpoints = this.onDidChangeBreakpointsEmitter.event;
        this.childSessions = new Map();
        this.toDispose = new common_1.DisposableCollection();
        this.isStopping = false;
        this._capabilities = {};
        this.sources = new Map();
        this._threads = new Map();
        this.toDisposeOnCurrentThread = new common_1.DisposableCollection();
        /**
         * The `send('initialize')` request could resolve later than `on('initialized')` emits the event.
         * Hence, the `configure` would use the empty object `capabilities`.
         * Using the empty `capabilities` could result in missing exception breakpoint filters, as
         * always `capabilities.exceptionBreakpointFilters` is falsy. This deferred promise works
         * around this timing issue. https://github.com/eclipse-theia/theia/issues/11886
         */
        this.didReceiveCapabilities = new promise_util_1.Deferred();
        this.initialized = false;
        this.scheduleUpdateThreads = debounce(() => this.updateThreads(undefined), 100);
        this.pendingThreads = Promise.resolve();
        this._breakpoints = new Map();
        this.updatingBreakpoints = false;
        this.connection.onRequest('runInTerminal', (request) => this.runInTerminal(request));
        this.connection.onDidClose(() => {
            this.toDispose.dispose();
        });
        this.registerDebugContributions(options.configuration.type, this.connection);
        if (parentSession) {
            parentSession.childSessions.set(id, this);
            this.toDispose.push(common_1.Disposable.create(() => {
                var _a, _b;
                (_b = (_a = this.parentSession) === null || _a === void 0 ? void 0 : _a.childSessions) === null || _b === void 0 ? void 0 : _b.delete(id);
            }));
        }
        if (testRun) {
            try {
                const run = test_service_1.TestServices.withTestRun(testService, testRun.controllerId, testRun.runId);
                run.onDidChangeProperty(evt => {
                    if (evt.isRunning === false) {
                        sessionManager.terminateSession(this);
                    }
                });
            }
            catch (err) {
                console.error(err);
            }
        }
        this.connection.onDidClose(() => this.toDispose.dispose());
        this.toDispose.pushAll([
            this.onDidChangeEmitter,
            this.onDidChangeBreakpointsEmitter,
            common_1.Disposable.create(() => {
                this.clearBreakpoints();
                this.doUpdateThreads([]);
            }),
            this.connection,
            this.connection.on('initialized', () => this.configure()),
            this.connection.on('breakpoint', ({ body }) => this.updateBreakpoint(body)),
            this.connection.on('continued', e => this.handleContinued(e)),
            this.connection.on('stopped', e => this.handleStopped(e)),
            this.connection.on('thread', e => this.handleThread(e)),
            this.connection.on('capabilities', event => this.updateCapabilities(event.body.capabilities)),
            this.breakpoints.onDidChangeMarkers(uri => this.updateBreakpoints({ uri, sourceModified: true }))
        ]);
    }
    get onDispose() {
        return this.toDispose.onDispose;
    }
    get configuration() {
        return this.options.configuration;
    }
    get capabilities() {
        return this._capabilities;
    }
    getSource(raw) {
        const uri = debug_source_1.DebugSource.toUri(raw).toString();
        const source = this.sources.get(uri) || new debug_source_1.DebugSource(this, this.editorManager, this.labelProvider);
        source.update({ raw });
        this.sources.set(uri, source);
        return source;
    }
    getSourceForUri(uri) {
        return this.sources.get(uri.toString());
    }
    async toSource(uri) {
        const source = this.getSourceForUri(uri);
        if (source) {
            return source;
        }
        return this.getSource(await this.toDebugSource(uri));
    }
    async toDebugSource(uri) {
        if (uri.scheme === debug_source_1.DebugSource.SCHEME) {
            return {
                name: uri.path.toString(),
                sourceReference: Number(uri.query)
            };
        }
        const name = uri.displayName;
        let path;
        const underlying = await this.fileService.toUnderlyingResource(uri);
        if (underlying.scheme === 'file') {
            path = await this.fileService.fsPath(underlying);
        }
        else {
            path = uri.toString();
        }
        return { name, path };
    }
    get threads() {
        return this._threads.values();
    }
    get threadCount() {
        return this._threads.size;
    }
    *getThreads(filter) {
        for (const thread of this.threads) {
            if (filter(thread)) {
                yield thread;
            }
        }
    }
    get runningThreads() {
        return this.getThreads(thread => !thread.stopped);
    }
    get stoppedThreads() {
        return this.getThreads(thread => thread.stopped);
    }
    async pauseAll() {
        const promises = [];
        for (const thread of this.runningThreads) {
            promises.push((async () => {
                try {
                    await thread.pause();
                }
                catch (e) {
                    console.error('pauseAll failed:', e);
                }
            })());
        }
        await Promise.all(promises);
    }
    async continueAll() {
        const promises = [];
        for (const thread of this.stoppedThreads) {
            promises.push((async () => {
                try {
                    await thread.continue();
                }
                catch (e) {
                    console.error('continueAll failed:', e);
                }
            })());
        }
        await Promise.all(promises);
    }
    get currentFrame() {
        return this.currentThread && this.currentThread.currentFrame;
    }
    get currentThread() {
        return this._currentThread;
    }
    set currentThread(thread) {
        var _a;
        if (((_a = this._currentThread) === null || _a === void 0 ? void 0 : _a.id) === (thread === null || thread === void 0 ? void 0 : thread.id)) {
            return;
        }
        this.toDisposeOnCurrentThread.dispose();
        this._currentThread = thread;
        this.onDidFocusThreadEmitter.fire(thread);
        this.fireDidChange();
        if (thread) {
            this.toDisposeOnCurrentThread.push(thread.onDidChanged(() => this.fireDidChange()));
            this.toDisposeOnCurrentThread.push(thread.onDidFocusStackFrame(frame => this.onDidFocusStackFrameEmitter.fire(frame)));
            // If this thread is missing stack frame information, then load that.
            this.updateFrames();
        }
    }
    get state() {
        if (this.connection.disposed) {
            return DebugState.Inactive;
        }
        if (!this.initialized) {
            return DebugState.Initializing;
        }
        const thread = this.currentThread;
        if (thread) {
            return thread.stopped ? DebugState.Stopped : DebugState.Running;
        }
        return !!this.stoppedThreads.next().value ? DebugState.Stopped : DebugState.Running;
    }
    async getScopes() {
        const { currentFrame } = this;
        return currentFrame ? currentFrame.getScopes() : [];
    }
    showMessage(messageType, message) {
        this.messages.showMessage({
            type: messageType,
            text: message,
            options: {
                timeout: 10000
            }
        });
    }
    async start() {
        await this.initialize();
        await this.launchOrAttach();
    }
    async initialize() {
        try {
            const response = await this.connection.sendRequest('initialize', {
                clientID: 'Theia',
                clientName: 'Theia IDE',
                adapterID: this.configuration.type,
                locale: 'en-US',
                linesStartAt1: true,
                columnsStartAt1: true,
                pathFormat: 'path',
                supportsVariableType: false,
                supportsVariablePaging: false,
                supportsRunInTerminalRequest: true
            });
            this.updateCapabilities((response === null || response === void 0 ? void 0 : response.body) || {});
            this.didReceiveCapabilities.resolve();
        }
        catch (err) {
            this.didReceiveCapabilities.reject(err);
            throw err;
        }
    }
    async launchOrAttach() {
        try {
            await this.sendRequest(this.configuration.request, this.configuration);
        }
        catch (reason) {
            this.showMessage(common_1.MessageType.Error, reason.message || 'Debug session initialization failed. See console for details.');
            throw reason;
        }
    }
    async configure() {
        await this.didReceiveCapabilities.promise;
        if (this.capabilities.exceptionBreakpointFilters) {
            const exceptionBreakpoints = [];
            for (const filter of this.capabilities.exceptionBreakpointFilters) {
                const origin = this.breakpoints.getExceptionBreakpoint(filter.filter);
                exceptionBreakpoints.push(breakpoint_marker_1.ExceptionBreakpoint.create(filter, origin));
            }
            this.breakpoints.setExceptionBreakpoints(exceptionBreakpoints);
        }
        // mark as initialized, so updated breakpoints are shown in editor
        this.initialized = true;
        await this.updateBreakpoints({ sourceModified: false });
        if (this.capabilities.supportsConfigurationDoneRequest) {
            await this.sendRequest('configurationDone', {});
        }
        await this.updateThreads(undefined);
    }
    canTerminate() {
        return !!this.capabilities.supportsTerminateRequest;
    }
    canRestart() {
        return !!this.capabilities.supportsRestartRequest;
    }
    async restart() {
        if (this.canRestart()) {
            await this.sendRequest('restart', {});
        }
    }
    async stop(isRestart, callback) {
        if (!this.isStopping) {
            this.isStopping = true;
            if (this.canTerminate()) {
                const terminated = this.waitFor('terminated', this.stopTimeout);
                try {
                    await this.connection.sendRequest('terminate', { restart: isRestart }, this.stopTimeout);
                    await terminated;
                }
                catch (e) {
                    this.handleTerminateError(e);
                }
            }
            else {
                const terminateDebuggee = this.initialized && this.capabilities.supportTerminateDebuggee;
                try {
                    await this.sendRequest('disconnect', { restart: isRestart, terminateDebuggee }, this.stopTimeout);
                }
                catch (e) {
                    this.handleDisconnectError(e);
                }
            }
            callback();
        }
    }
    /**
     * Invoked when sending the `terminate` request to the debugger is rejected or timed out.
     */
    handleTerminateError(err) {
        console.error('Did not receive terminated event in time', err);
    }
    /**
     * Invoked when sending the `disconnect` request to the debugger is rejected or timed out.
     */
    handleDisconnectError(err) {
        console.error('Error on disconnect', err);
    }
    async disconnect(isRestart, callback) {
        if (!this.isStopping) {
            this.isStopping = true;
            await this.sendRequest('disconnect', { restart: isRestart });
            callback();
        }
    }
    async completions(text, column, line) {
        const frameId = this.currentFrame && this.currentFrame.raw.id;
        const response = await this.sendRequest('completions', { frameId, text, column, line });
        return response.body.targets;
    }
    async evaluate(expression, context) {
        const frameId = this.currentFrame && this.currentFrame.raw.id;
        const response = await this.sendRequest('evaluate', { expression, frameId, context });
        return response.body;
    }
    sendRequest(command, args, timeout) {
        return this.connection.sendRequest(command, args, timeout);
    }
    sendCustomRequest(command, args) {
        return this.connection.sendCustomRequest(command, args);
    }
    on(kind, listener) {
        return this.connection.on(kind, listener);
    }
    waitFor(kind, ms) {
        return (0, promise_util_1.waitForEvent)(this.connection.onEvent(kind), ms).then();
    }
    get onDidCustomEvent() {
        return this.connection.onDidCustomEvent;
    }
    async runInTerminal({ arguments: { title, cwd, args, env } }) {
        const terminal = await this.doCreateTerminal({ title, cwd, env, useServerTitle: false });
        const { processId } = terminal;
        await terminal.executeCommand({ cwd, args, env });
        return { processId: await processId };
    }
    async doCreateTerminal(options) {
        let terminal = undefined;
        for (const t of this.terminalServer.all) {
            if ((t.title.label === options.title || t.title.caption === options.title) && (await t.hasChildProcesses()) === false) {
                terminal = t;
                break;
            }
        }
        if (!terminal) {
            terminal = await this.terminalServer.newTerminal(options);
            await terminal.start();
        }
        this.terminalServer.open(terminal);
        return terminal;
    }
    clearThreads() {
        for (const thread of this.threads) {
            thread.clear();
        }
        this.updateCurrentThread();
    }
    clearThread(threadId) {
        const thread = this._threads.get(threadId);
        if (thread) {
            thread.clear();
        }
        this.updateCurrentThread();
    }
    updateThreads(stoppedDetails) {
        return this.pendingThreads = this.pendingThreads.then(async () => {
            try {
                const response = await this.sendRequest('threads', {});
                // java debugger returns an empty body sometimes
                const threads = response && response.body && response.body.threads || [];
                this.doUpdateThreads(threads, stoppedDetails);
            }
            catch (e) {
                console.error('updateThreads failed:', e);
            }
        });
    }
    doUpdateThreads(threads, stoppedDetails) {
        const existing = this._threads;
        this._threads = new Map();
        for (const raw of threads) {
            const id = raw.id;
            const thread = existing.get(id) || new debug_thread_1.DebugThread(this);
            this._threads.set(id, thread);
            const data = { raw };
            if (stoppedDetails) {
                if (stoppedDetails.threadId === id) {
                    data.stoppedDetails = stoppedDetails;
                }
                else if (stoppedDetails.allThreadsStopped) {
                    data.stoppedDetails = {
                        // When a debug adapter notifies us that all threads are stopped,
                        // we do not know why the others are stopped, so we should default
                        // to something generic.
                        reason: '',
                    };
                }
            }
            thread.update(data);
        }
        this.updateCurrentThread(stoppedDetails);
    }
    updateCurrentThread(stoppedDetails) {
        const { currentThread } = this;
        let threadId = currentThread && currentThread.raw.id;
        if (stoppedDetails && !stoppedDetails.preserveFocusHint && !!stoppedDetails.threadId) {
            threadId = stoppedDetails.threadId;
        }
        this.currentThread = typeof threadId === 'number' && this._threads.get(threadId)
            || this._threads.values().next().value;
    }
    async updateFrames() {
        const thread = this._currentThread;
        if (!thread || thread.pendingFrameCount || thread.frameCount) {
            return;
        }
        if (this.capabilities.supportsDelayedStackTraceLoading) {
            await thread.fetchFrames(1);
            await thread.fetchFrames(19);
        }
        else {
            await thread.fetchFrames();
        }
    }
    updateCapabilities(capabilities) {
        Object.assign(this._capabilities, capabilities);
        this.deferredOnDidConfigureCapabilities.resolve();
    }
    get breakpointUris() {
        return this._breakpoints.keys();
    }
    getSourceBreakpoints(uri) {
        const breakpoints = [];
        for (const breakpoint of this.getBreakpoints(uri)) {
            if (breakpoint instanceof debug_source_breakpoint_1.DebugSourceBreakpoint) {
                breakpoints.push(breakpoint);
            }
        }
        return breakpoints;
    }
    getFunctionBreakpoints() {
        return this.getBreakpoints(breakpoint_manager_1.BreakpointManager.FUNCTION_URI).filter((breakpoint) => breakpoint instanceof debug_function_breakpoint_1.DebugFunctionBreakpoint);
    }
    getInstructionBreakpoints() {
        if (this.capabilities.supportsInstructionBreakpoints) {
            return this.getBreakpoints(breakpoint_manager_1.BreakpointManager.INSTRUCTION_URI)
                .filter((breakpoint) => breakpoint instanceof debug_instruction_breakpoint_1.DebugInstructionBreakpoint);
        }
        return this.breakpoints.getInstructionBreakpoints().map(origin => new debug_instruction_breakpoint_1.DebugInstructionBreakpoint(origin, this.asDebugBreakpointOptions()));
    }
    getBreakpoints(uri) {
        if (uri) {
            return this._breakpoints.get(uri.toString()) || [];
        }
        const result = [];
        for (const breakpoints of this._breakpoints.values()) {
            result.push(...breakpoints);
        }
        return result;
    }
    getBreakpoint(id) {
        for (const breakpoints of this._breakpoints.values()) {
            const breakpoint = breakpoints.find(b => b.id === id);
            if (breakpoint) {
                return breakpoint;
            }
        }
        return undefined;
    }
    clearBreakpoints() {
        const uris = [...this._breakpoints.keys()];
        this._breakpoints.clear();
        for (const uri of uris) {
            this.fireDidChangeBreakpoints(new uri_1.default(uri));
        }
    }
    updateBreakpoint(body) {
        this.updatingBreakpoints = true;
        try {
            const raw = body.breakpoint;
            if (body.reason === 'new') {
                if (raw.source && typeof raw.line === 'number') {
                    const uri = debug_source_1.DebugSource.toUri(raw.source);
                    const origin = breakpoint_marker_1.SourceBreakpoint.create(uri, { line: raw.line, column: raw.column });
                    if (this.breakpoints.addBreakpoint(origin)) {
                        const breakpoints = this.getSourceBreakpoints(uri);
                        const breakpoint = new debug_source_breakpoint_1.DebugSourceBreakpoint(origin, this.asDebugBreakpointOptions());
                        breakpoint.update({ raw });
                        breakpoints.push(breakpoint);
                        this.setSourceBreakpoints(uri, breakpoints);
                    }
                }
            }
            if (body.reason === 'removed' && typeof raw.id === 'number') {
                const toRemove = this.findBreakpoint(b => b.idFromAdapter === raw.id);
                if (toRemove) {
                    toRemove.remove();
                    const breakpoints = this.getBreakpoints(toRemove.uri);
                    const index = breakpoints.indexOf(toRemove);
                    if (index !== -1) {
                        breakpoints.splice(index, 1);
                        this.setBreakpoints(toRemove.uri, breakpoints);
                    }
                }
            }
            if (body.reason === 'changed' && typeof raw.id === 'number') {
                const toUpdate = this.findBreakpoint(b => b.idFromAdapter === raw.id);
                if (toUpdate) {
                    toUpdate.update({ raw });
                    if (toUpdate instanceof debug_source_breakpoint_1.DebugSourceBreakpoint) {
                        const sourceBreakpoints = this.getSourceBreakpoints(toUpdate.uri);
                        // in order to dedup again if a debugger converted line breakpoint to inline breakpoint
                        // i.e. assigned a column to a line breakpoint
                        this.setSourceBreakpoints(toUpdate.uri, sourceBreakpoints);
                    }
                    else {
                        this.fireDidChangeBreakpoints(toUpdate.uri);
                    }
                }
            }
        }
        finally {
            this.updatingBreakpoints = false;
        }
    }
    findBreakpoint(match) {
        for (const [, breakpoints] of this._breakpoints) {
            for (const breakpoint of breakpoints) {
                if (match(breakpoint)) {
                    return breakpoint;
                }
            }
        }
        return undefined;
    }
    async updateBreakpoints(options) {
        if (this.updatingBreakpoints) {
            return;
        }
        const { uri, sourceModified } = options;
        await this.deferredOnDidConfigureCapabilities.promise;
        for (const affectedUri of this.getAffectedUris(uri)) {
            if (affectedUri.toString() === breakpoint_manager_1.BreakpointManager.EXCEPTION_URI.toString()) {
                await this.sendExceptionBreakpoints();
            }
            else if (affectedUri.toString() === breakpoint_manager_1.BreakpointManager.FUNCTION_URI.toString()) {
                await this.sendFunctionBreakpoints(affectedUri);
            }
            else if (affectedUri.toString() === breakpoint_manager_1.BreakpointManager.INSTRUCTION_URI.toString()) {
                await this.sendInstructionBreakpoints();
            }
            else {
                await this.sendSourceBreakpoints(affectedUri, sourceModified);
            }
        }
    }
    async sendExceptionBreakpoints() {
        const filters = [];
        const filterOptions = this.capabilities.supportsExceptionFilterOptions ? [] : undefined;
        for (const breakpoint of this.breakpoints.getExceptionBreakpoints()) {
            if (breakpoint.enabled) {
                if (filterOptions) {
                    filterOptions.push({
                        filterId: breakpoint.raw.filter,
                        condition: breakpoint.condition
                    });
                }
                else {
                    filters.push(breakpoint.raw.filter);
                }
            }
        }
        await this.sendRequest('setExceptionBreakpoints', { filters, filterOptions });
    }
    async sendFunctionBreakpoints(affectedUri) {
        const all = this.breakpoints.getFunctionBreakpoints().map(origin => new debug_function_breakpoint_1.DebugFunctionBreakpoint(origin, this.asDebugBreakpointOptions()));
        const enabled = all.filter(b => b.enabled);
        if (this.capabilities.supportsFunctionBreakpoints) {
            try {
                const response = await this.sendRequest('setFunctionBreakpoints', {
                    breakpoints: enabled.map(b => b.origin.raw)
                });
                // Apparently, `body` and `breakpoints` can be missing.
                // https://github.com/eclipse-theia/theia/issues/11885
                // https://github.com/microsoft/vscode/blob/80004351ccf0884b58359f7c8c801c91bb827d83/src/vs/workbench/contrib/debug/browser/debugSession.ts#L448-L449
                if (response && response.body) {
                    response.body.breakpoints.forEach((raw, index) => {
                        // node debug adapter returns more breakpoints sometimes
                        if (enabled[index]) {
                            enabled[index].update({ raw });
                        }
                    });
                }
            }
            catch (error) {
                // could be error or promise rejection of DebugProtocol.SetFunctionBreakpoints
                if (error instanceof Error) {
                    console.error(`Error setting breakpoints: ${error.message}`);
                }
                else {
                    // handle adapters that send failed DebugProtocol.SetFunctionBreakpoints for invalid breakpoints
                    const genericMessage = 'Function breakpoint not valid for current debug session';
                    const message = error.message ? `${error.message}` : genericMessage;
                    console.warn(`Could not handle function breakpoints: ${message}, disabling...`);
                    enabled.forEach(b => b.update({
                        raw: {
                            verified: false,
                            message
                        }
                    }));
                }
            }
        }
        this.setBreakpoints(affectedUri, all);
    }
    async sendSourceBreakpoints(affectedUri, sourceModified) {
        const source = await this.toSource(affectedUri);
        const all = this.breakpoints.findMarkers({ uri: affectedUri }).map(({ data }) => new debug_source_breakpoint_1.DebugSourceBreakpoint(data, this.asDebugBreakpointOptions()));
        const enabled = all.filter(b => b.enabled);
        try {
            const breakpoints = enabled.map(({ origin }) => origin.raw);
            const response = await this.sendRequest('setBreakpoints', {
                source: source.raw,
                sourceModified,
                breakpoints,
                lines: breakpoints.map(({ line }) => line)
            });
            response.body.breakpoints.forEach((raw, index) => {
                // node debug adapter returns more breakpoints sometimes
                if (enabled[index]) {
                    enabled[index].update({ raw });
                }
            });
        }
        catch (error) {
            // could be error or promise rejection of DebugProtocol.SetBreakpointsResponse
            if (error instanceof Error) {
                console.error(`Error setting breakpoints: ${error.message}`);
            }
            else {
                // handle adapters that send failed DebugProtocol.SetBreakpointsResponse for invalid breakpoints
                const genericMessage = 'Breakpoint not valid for current debug session';
                const message = error.message ? `${error.message}` : genericMessage;
                console.warn(`Could not handle breakpoints for ${affectedUri}: ${message}, disabling...`);
                enabled.forEach(b => b.update({
                    raw: {
                        verified: false,
                        message
                    }
                }));
            }
        }
        this.setSourceBreakpoints(affectedUri, all);
    }
    async sendInstructionBreakpoints() {
        if (!this.capabilities.supportsInstructionBreakpoints) {
            return;
        }
        const all = this.breakpoints.getInstructionBreakpoints().map(breakpoint => new debug_instruction_breakpoint_1.DebugInstructionBreakpoint(breakpoint, this.asDebugBreakpointOptions()));
        const enabled = all.filter(breakpoint => breakpoint.enabled);
        try {
            const response = await this.sendRequest('setInstructionBreakpoints', {
                breakpoints: enabled.map(renderable => renderable.origin),
            });
            response.body.breakpoints.forEach((raw, index) => { var _a; return (_a = enabled[index]) === null || _a === void 0 ? void 0 : _a.update({ raw }); });
        }
        catch {
            enabled.forEach(breakpoint => breakpoint.update({ raw: { verified: false } }));
        }
        this.setBreakpoints(breakpoint_manager_1.BreakpointManager.INSTRUCTION_URI, all);
    }
    setBreakpoints(uri, breakpoints) {
        this._breakpoints.set(uri.toString(), breakpoints);
        this.fireDidChangeBreakpoints(uri);
    }
    setSourceBreakpoints(uri, breakpoints) {
        const distinct = this.dedupSourceBreakpoints(breakpoints);
        this.setBreakpoints(uri, distinct);
    }
    dedupSourceBreakpoints(all) {
        const positions = new Map();
        for (const breakpoint of all) {
            let primary = positions.get(breakpoint.renderPosition()) || breakpoint;
            if (primary !== breakpoint) {
                let secondary = breakpoint;
                if (secondary.raw && secondary.raw.line === secondary.origin.raw.line && secondary.raw.column === secondary.origin.raw.column) {
                    [primary, secondary] = [breakpoint, primary];
                }
                primary.origins.push(...secondary.origins);
            }
            positions.set(primary.renderPosition(), primary);
        }
        return [...positions.values()];
    }
    *getAffectedUris(uri) {
        if (uri) {
            yield uri;
        }
        else {
            for (const uriString of this.breakpoints.getUris()) {
                yield new uri_1.default(uriString);
            }
            yield breakpoint_manager_1.BreakpointManager.FUNCTION_URI;
            yield breakpoint_manager_1.BreakpointManager.EXCEPTION_URI;
        }
    }
    asDebugBreakpointOptions() {
        const { labelProvider, breakpoints, editorManager } = this;
        return { labelProvider, breakpoints, editorManager, session: this };
    }
    get label() {
        const suffixes = [];
        if (debug_session_options_1.InternalDebugSessionOptions.is(this.options) && this.options.id) {
            suffixes.push(String(this.options.id + 1));
        }
        if (this.workspaceService.isMultiRootWorkspaceOpened && this.options.workspaceFolderUri) {
            suffixes.push(this.labelProvider.getName(new uri_1.default(this.options.workspaceFolderUri)));
        }
        return suffixes.length === 0 ? this.configuration.name : this.configuration.name + ` (${suffixes.join(' - ')})`;
    }
    get visible() {
        return this.state > DebugState.Inactive;
    }
    render() {
        let label = '';
        const state = this.state === DebugState.Stopped ? core_1.nls.localizeByDefault('Paused') : core_1.nls.localizeByDefault('Running');
        const child = this.getSingleChildSession();
        if (child && child.configuration.compact) {
            // Inlines the name of the child debug session
            label = `: ${child.label}`;
        }
        return React.createElement("div", { className: 'theia-debug-session', title: 'Session' },
            React.createElement("span", { className: 'label' }, this.label + label),
            React.createElement("span", { className: 'status' }, state));
    }
    *getElements() {
        const child = this.getSingleChildSession();
        if (child && child.configuration.compact) {
            // Inlines the elements of the child debug session
            return yield* child.getElements();
        }
        yield* this.threads;
        yield* this.childSessions.values();
    }
    getSingleChildSession() {
        if (this._threads.size === 0 && this.childSessions.size === 1) {
            const child = this.childSessions.values().next().value;
            return child;
        }
        return undefined;
    }
    async handleContinued({ body: { allThreadsContinued, threadId } }) {
        if (allThreadsContinued !== false) {
            this.clearThreads();
        }
        else {
            this.clearThread(threadId);
        }
    }
    ;
    async handleStopped({ body }) {
        // Update thread list
        await this.updateThreads(body);
        // Update current thread's frames immediately
        await this.updateFrames();
    }
    ;
    async handleThread({ body: { reason, threadId } }) {
        if (reason === 'started') {
            this.scheduleUpdateThreads();
        }
        else if (reason === 'exited') {
            this._threads.delete(threadId);
            this.updateCurrentThread();
        }
    }
    ;
    registerDebugContributions(configType, connection) {
        for (const contrib of this.debugContributionProvider.getContributions()) {
            contrib.register(configType, connection);
        }
    }
    ;
    /**
     * Returns the top-most parent session that is responsible for the console. If this session uses a {@link DebugConsoleMode.Separate separate console}
     * or does not have any parent session, undefined is returned.
     */
    findConsoleParent() {
        if (this.configuration.consoleMode !== debug_common_1.DebugConsoleMode.MergeWithParent) {
            return undefined;
        }
        let debugSession = this;
        do {
            debugSession = debugSession.parentSession;
        } while ((debugSession === null || debugSession === void 0 ? void 0 : debugSession.parentSession) && debugSession.configuration.consoleMode === debug_common_1.DebugConsoleMode.MergeWithParent);
        return debugSession;
    }
}
exports.DebugSession = DebugSession;


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/debug-watch-manager.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/debug-watch-manager.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugWatchManager = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "../../node_modules/@theia/core/lib/common/event.js");
const storage_service_1 = __webpack_require__(/*! @theia/core/lib/browser/storage-service */ "../../node_modules/@theia/core/lib/browser/storage-service.js");
let DebugWatchManager = class DebugWatchManager {
    constructor() {
        this.onDidChangeEmitter = new event_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
        this.idSequence = 0;
        this._watchExpressions = new Map();
    }
    get watchExpressions() {
        return this._watchExpressions.entries();
    }
    addWatchExpression(expression) {
        const id = this.idSequence++;
        this._watchExpressions.set(id, expression);
        this.onDidChangeEmitter.fire(undefined);
        return id;
    }
    removeWatchExpression(id) {
        if (!this._watchExpressions.has(id)) {
            return false;
        }
        this._watchExpressions.delete(id);
        this.onDidChangeEmitter.fire(undefined);
        return true;
    }
    removeWatchExpressions() {
        if (this._watchExpressions.size) {
            this.idSequence = 0;
            this._watchExpressions.clear();
            this.onDidChangeEmitter.fire(undefined);
        }
    }
    async load() {
        const data = await this.storage.getData(this.storageKey, {
            expressions: []
        });
        this.restoreState(data);
    }
    save() {
        const data = this.storeState();
        this.storage.setData(this.storageKey, data);
    }
    get storageKey() {
        return 'debug:watch';
    }
    storeState() {
        return {
            expressions: [...this._watchExpressions.values()]
        };
    }
    restoreState(state) {
        for (const expression of state.expressions) {
            this.addWatchExpression(expression);
        }
    }
};
exports.DebugWatchManager = DebugWatchManager;
tslib_1.__decorate([
    (0, inversify_1.inject)(storage_service_1.StorageService),
    tslib_1.__metadata("design:type", Object)
], DebugWatchManager.prototype, "storage", void 0);
exports.DebugWatchManager = DebugWatchManager = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugWatchManager);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/editor/debug-breakpoint-widget.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/editor/debug-breakpoint-widget.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var DebugBreakpointWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugBreakpointWidget = exports.BREAKPOINT_INPUT_SCHEME = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const client_1 = __webpack_require__(/*! @theia/core/shared/react-dom/client */ "../../node_modules/@theia/core/shared/react-dom/client/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const monaco_editor_provider_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-editor-provider */ "../../node_modules/@theia/monaco/lib/browser/monaco-editor-provider.js");
const monaco_editor_zone_widget_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-editor-zone-widget */ "../../node_modules/@theia/monaco/lib/browser/monaco-editor-zone-widget.js");
const debug_editor_1 = __webpack_require__(/*! ./debug-editor */ "../../node_modules/@theia/debug/lib/browser/editor/debug-editor.js");
const debug_source_breakpoint_1 = __webpack_require__(/*! ../model/debug-source-breakpoint */ "../../node_modules/@theia/debug/lib/browser/model/debug-source-breakpoint.js");
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
const suggest_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/contrib/suggest/browser/suggest */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/contrib/suggest/browser/suggest.js");
const languageFeatures_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/common/services/languageFeatures */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/common/services/languageFeatures.js");
const standaloneServices_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/standalone/browser/standaloneServices */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/standalone/browser/standaloneServices.js");
const select_component_1 = __webpack_require__(/*! @theia/core/lib/browser/widgets/select-component */ "../../node_modules/@theia/core/lib/browser/widgets/select-component.js");
exports.BREAKPOINT_INPUT_SCHEME = 'breakpointinput';
let DebugBreakpointWidget = DebugBreakpointWidget_1 = class DebugBreakpointWidget {
    constructor() {
        this.toDispose = new core_1.DisposableCollection();
        this.context = 'condition';
        this._values = {};
        this.selectComponentRef = React.createRef();
        this.updateInput = (option) => {
            if (this._input) {
                this._values[this.context] = this._input.getControl().getValue();
            }
            this.context = option.value;
            this.render();
            if (this._input) {
                this._input.focus();
            }
        };
    }
    get values() {
        if (!this._input) {
            return undefined;
        }
        return {
            ...this._values,
            [this.context]: this._input.getControl().getValue()
        };
    }
    get input() {
        return this._input;
    }
    // eslint-disable-next-line no-null/no-null
    set inputSize(dimension) {
        if (this._input) {
            if (dimension) {
                this._input.setSize(dimension);
            }
            else {
                this._input.resizeToFit();
            }
        }
    }
    init() {
        this.doInit();
    }
    async doInit() {
        this.uri = new uri_1.default().withScheme(exports.BREAKPOINT_INPUT_SCHEME).withPath(this.editor.getControl().getId());
        this.toDispose.push(this.resources.add(this.uri, ''));
        this.toDispose.push(this.zone = new monaco_editor_zone_widget_1.MonacoEditorZoneWidget(this.editor.getControl()));
        this.zone.containerNode.classList.add('theia-debug-breakpoint-widget');
        const selectNode = this.selectNode = document.createElement('div');
        selectNode.classList.add('theia-debug-breakpoint-select');
        this.zone.containerNode.appendChild(selectNode);
        this.selectNodeRoot = (0, client_1.createRoot)(this.selectNode);
        this.toDispose.push(core_1.Disposable.create(() => this.selectNodeRoot.unmount()));
        const inputNode = document.createElement('div');
        inputNode.classList.add('theia-debug-breakpoint-input');
        this.zone.containerNode.appendChild(inputNode);
        const input = this._input = await this.createInput(inputNode);
        if (this.toDispose.disposed) {
            input.dispose();
            return;
        }
        this.toDispose.push(input);
        this.toDispose.push(monaco.languages.registerCompletionItemProvider({ scheme: input.uri.scheme }, {
            provideCompletionItems: async (model, position, context, token) => {
                const editor = this.editor.getControl();
                const editorModel = editor.getModel();
                const suggestions = [];
                if (editorModel && (this.context === 'condition' || this.context === 'logMessage')
                    && input.uri.toString() === model.uri.toString()) {
                    const completions = await (0, suggest_1.provideSuggestionItems)(standaloneServices_1.StandaloneServices.get(languageFeatures_1.ILanguageFeaturesService).completionProvider, editorModel, new monaco.Position(editor.getPosition().lineNumber, 1), new suggest_1.CompletionOptions(undefined, new Set().add(27 /* CompletionItemKind.Snippet */)), context, token);
                    let overwriteBefore = 0;
                    if (this.context === 'condition') {
                        overwriteBefore = position.column - 1;
                    }
                    else {
                        // Inside the curly brackets, need to count how many useful characters are behind the position so they would all be taken into account
                        const value = editor.getModel().getValue();
                        while ((position.column - 2 - overwriteBefore >= 0)
                            && value[position.column - 2 - overwriteBefore] !== '{' && value[position.column - 2 - overwriteBefore] !== ' ') {
                            overwriteBefore++;
                        }
                    }
                    for (const { completion } of completions.items) {
                        completion.range = monaco.Range.fromPositions(position.delta(0, -overwriteBefore), position);
                        suggestions.push(completion);
                    }
                }
                return { suggestions };
            }
        }));
        this.toDispose.push(this.zone.onDidLayoutChange(dimension => this.layout(dimension)));
        this.toDispose.push(this.editor.getControl().onDidChangeModel(() => {
            this.zone.hide();
        }));
        this.toDispose.push(input.getControl().onDidChangeModelContent(() => {
            var _a;
            const heightInLines = (((_a = input.getControl().getModel()) === null || _a === void 0 ? void 0 : _a.getLineCount()) || 0) + 1;
            this.zone.layout(heightInLines);
            this.updatePlaceholder();
        }));
        this._input.getControl().contextKeyService.createKey('breakpointWidgetFocus', true);
    }
    dispose() {
        this.toDispose.dispose();
    }
    get position() {
        const options = this.zone.options;
        return options && new monaco.Position(options.afterLineNumber, options.afterColumn || -1);
    }
    show(options) {
        if (!this._input) {
            return;
        }
        const breakpoint = options instanceof debug_source_breakpoint_1.DebugSourceBreakpoint ? options : 'breakpoint' in options ? options.breakpoint : undefined;
        this._values = breakpoint ? {
            condition: breakpoint.condition,
            hitCondition: breakpoint.hitCondition,
            logMessage: breakpoint.logMessage
        } : {};
        if (options instanceof debug_source_breakpoint_1.DebugSourceBreakpoint) {
            if (options.logMessage) {
                this.context = 'logMessage';
            }
            else if (options.hitCondition && !options.condition) {
                this.context = 'hitCondition';
            }
            else {
                this.context = 'condition';
            }
        }
        else {
            this.context = options.context;
        }
        this.render();
        const position = 'position' in options ? options.position : undefined;
        const afterLineNumber = breakpoint ? breakpoint.line : position.lineNumber;
        const afterColumn = breakpoint ? breakpoint.column : position.column;
        const editor = this._input.getControl();
        const editorModel = editor.getModel();
        const heightInLines = ((editorModel === null || editorModel === void 0 ? void 0 : editorModel.getLineCount()) || 0) + 1;
        this.zone.show({ afterLineNumber, afterColumn, heightInLines, frameWidth: 1 });
        if (editorModel) {
            editor.setPosition(editorModel.getPositionAt(editorModel.getValueLength()));
        }
        this._input.focus();
        this.editor.getControl().createContextKey('isBreakpointWidgetVisible', true);
    }
    hide() {
        this.zone.hide();
        this.editor.getControl().createContextKey('isBreakpointWidgetVisible', false);
        this.editor.focus();
    }
    layout(dimension) {
        if (this._input) {
            this._input.getControl().layout(dimension);
        }
    }
    createInput(node) {
        return this.editorProvider.createSimpleInline(this.uri, node, {
            autoSizing: false
        });
    }
    render() {
        const value = this._values[this.context] || '';
        this.resources.update(this.uri, value);
        if (this._input) {
            this._input.getControl().setValue(value);
        }
        const selectComponent = this.selectComponentRef.current;
        if (selectComponent && selectComponent.value !== this.context) {
            selectComponent.value = this.context;
        }
        this.selectNodeRoot.render(React.createElement(select_component_1.SelectComponent, { defaultValue: this.context, onChange: this.updateInput, options: [
                { value: 'condition', label: core_1.nls.localizeByDefault('Expression') },
                { value: 'hitCondition', label: core_1.nls.localizeByDefault('Hit Count') },
                { value: 'logMessage', label: core_1.nls.localizeByDefault('Log Message') },
            ], ref: this.selectComponentRef }));
    }
    updatePlaceholder() {
        if (!this._input) {
            return;
        }
        const value = this._input.getControl().getValue();
        const decorations = !!value ? [] : [{
                range: {
                    startLineNumber: 0,
                    endLineNumber: 0,
                    startColumn: 0,
                    endColumn: 1
                },
                renderOptions: {
                    after: {
                        contentText: this.placeholder,
                        opacity: '0.4'
                    }
                }
            }];
        this._input.getControl().setDecorationsByType('Debug breakpoint placeholder', DebugBreakpointWidget_1.PLACEHOLDER_DECORATION, decorations);
    }
    get placeholder() {
        const acceptString = 'Enter';
        const closeString = 'Escape';
        if (this.context === 'logMessage') {
            return core_1.nls.localizeByDefault("Message to log when breakpoint is hit. Expressions within {} are interpolated. '{0}' to accept, '{1}' to cancel.", acceptString, closeString);
        }
        if (this.context === 'hitCondition') {
            return core_1.nls.localizeByDefault("Break when hit count condition is met. '{0}' to accept, '{1}' to cancel.", acceptString, closeString);
        }
        return core_1.nls.localizeByDefault("Break when expression evaluates to true. '{0}' to accept, '{1}' to cancel.", acceptString, closeString);
    }
};
exports.DebugBreakpointWidget = DebugBreakpointWidget;
DebugBreakpointWidget.PLACEHOLDER_DECORATION = 'placeholderDecoration';
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_editor_1.DebugEditor),
    tslib_1.__metadata("design:type", Object)
], DebugBreakpointWidget.prototype, "editor", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(monaco_editor_provider_1.MonacoEditorProvider),
    tslib_1.__metadata("design:type", monaco_editor_provider_1.MonacoEditorProvider)
], DebugBreakpointWidget.prototype, "editorProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.InMemoryResources),
    tslib_1.__metadata("design:type", core_1.InMemoryResources)
], DebugBreakpointWidget.prototype, "resources", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugBreakpointWidget.prototype, "init", null);
exports.DebugBreakpointWidget = DebugBreakpointWidget = DebugBreakpointWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugBreakpointWidget);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/editor/debug-editor-model.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/editor/debug-editor-model.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var DebugEditorModel_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugEditorModel = exports.DebugEditorModelFactory = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const debounce = __webpack_require__(/*! p-debounce */ "../../node_modules/p-debounce/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
const configuration_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/platform/configuration/common/configuration */ "../../node_modules/@theia/monaco-editor-core/esm/vs/platform/configuration/common/configuration.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const vscode_uri_1 = __webpack_require__(/*! @theia/core/shared/vscode-uri */ "../../node_modules/@theia/core/shared/vscode-uri/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const breakpoint_manager_1 = __webpack_require__(/*! ../breakpoint/breakpoint-manager */ "../../node_modules/@theia/debug/lib/browser/breakpoint/breakpoint-manager.js");
const debug_session_manager_1 = __webpack_require__(/*! ../debug-session-manager */ "../../node_modules/@theia/debug/lib/browser/debug-session-manager.js");
const breakpoint_marker_1 = __webpack_require__(/*! ../breakpoint/breakpoint-marker */ "../../node_modules/@theia/debug/lib/browser/breakpoint/breakpoint-marker.js");
const debug_editor_1 = __webpack_require__(/*! ./debug-editor */ "../../node_modules/@theia/debug/lib/browser/editor/debug-editor.js");
const debug_hover_widget_1 = __webpack_require__(/*! ./debug-hover-widget */ "../../node_modules/@theia/debug/lib/browser/editor/debug-hover-widget.js");
const debug_breakpoint_widget_1 = __webpack_require__(/*! ./debug-breakpoint-widget */ "../../node_modules/@theia/debug/lib/browser/editor/debug-breakpoint-widget.js");
const debug_exception_widget_1 = __webpack_require__(/*! ./debug-exception-widget */ "../../node_modules/@theia/debug/lib/browser/editor/debug-exception-widget.js");
const debug_inline_value_decorator_1 = __webpack_require__(/*! ./debug-inline-value-decorator */ "../../node_modules/@theia/debug/lib/browser/editor/debug-inline-value-decorator.js");
const standaloneServices_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/standalone/browser/standaloneServices */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/standalone/browser/standaloneServices.js");
exports.DebugEditorModelFactory = Symbol('DebugEditorModelFactory');
let DebugEditorModel = DebugEditorModel_1 = class DebugEditorModel {
    constructor() {
        this.toDispose = new core_1.DisposableCollection();
        this.toDisposeOnUpdate = new core_1.DisposableCollection();
        this.breakpointDecorations = [];
        this.breakpointRanges = new Map();
        this.currentBreakpointDecorations = [];
        this.editorDecorations = [];
        this.updatingDecorations = false;
        this.toDisposeOnModelChange = new core_1.DisposableCollection();
        this.update = debounce(async () => {
            if (this.toDispose.disposed) {
                return;
            }
            this.toDisposeOnUpdate.dispose();
            this.toggleExceptionWidget();
            await this.updateEditorDecorations();
            this.updateEditorHover();
        }, 100);
        this.hintDecorations = [];
    }
    static createContainer(parent, editor) {
        const child = (0, debug_hover_widget_1.createDebugHoverWidgetContainer)(parent, editor);
        child.bind(DebugEditorModel_1).toSelf();
        child.bind(debug_breakpoint_widget_1.DebugBreakpointWidget).toSelf();
        child.bind(debug_exception_widget_1.DebugExceptionWidget).toSelf();
        return child;
    }
    static createModel(parent, editor) {
        return DebugEditorModel_1.createContainer(parent, editor).get(DebugEditorModel_1);
    }
    init() {
        this.uri = new uri_1.default(this.editor.getResourceUri().toString());
        this.toDispose.pushAll([
            this.hover,
            this.breakpointWidget,
            this.exceptionWidget,
            this.editor.getControl().onMouseDown(event => this.handleMouseDown(event)),
            this.editor.getControl().onMouseMove(event => this.handleMouseMove(event)),
            this.editor.getControl().onMouseLeave(event => this.handleMouseLeave(event)),
            this.editor.getControl().onKeyDown(() => this.hover.hide({ immediate: false })),
            this.editor.getControl().onDidChangeModelContent(() => this.update()),
            this.editor.getControl().onDidChangeModel(e => this.updateModel()),
            this.editor.onDidResize(e => this.breakpointWidget.inputSize = e),
            this.sessions.onDidChange(() => this.update()),
            this.toDisposeOnUpdate,
            this.sessionManager.onDidChangeBreakpoints(({ session, uri }) => {
                if ((!session || session === this.sessionManager.currentSession) && uri.isEqual(this.uri)) {
                    this.render();
                }
            }),
            this.breakpoints.onDidChangeBreakpoints(event => this.closeBreakpointIfAffected(event)),
        ]);
        this.update();
        this.render();
    }
    updateModel() {
        this.toDisposeOnModelChange.dispose();
        this.toDisposeOnModelChange = new core_1.DisposableCollection();
        const model = this.editor.getControl().getModel();
        if (model) {
            this.toDisposeOnModelChange.push(model.onDidChangeDecorations(() => this.updateBreakpoints()));
        }
        this.update();
        this.render();
    }
    dispose() {
        this.toDispose.dispose();
    }
    /**
     * To disable the default editor-contribution hover from Code when
     * the editor has the `currentFrame`. Otherwise, both `textdocument/hover`
     * and the debug hovers are visible at the same time when hovering over a symbol.
     */
    async updateEditorHover() {
        if (this.sessions.isCurrentEditorFrame(this.uri)) {
            const codeEditor = this.editor.getControl();
            codeEditor.updateOptions({ hover: { enabled: false } });
            this.toDisposeOnUpdate.push(core_1.Disposable.create(() => {
                const model = codeEditor.getModel();
                const overrides = {
                    resource: vscode_uri_1.URI.parse(this.editor.getResourceUri().toString()),
                    overrideIdentifier: model === null || model === void 0 ? void 0 : model.getLanguageId(),
                };
                const { enabled, delay, sticky } = standaloneServices_1.StandaloneServices.get(configuration_1.IConfigurationService).getValue('editor.hover', overrides);
                codeEditor.updateOptions({
                    hover: {
                        enabled,
                        delay,
                        sticky
                    }
                });
            }));
        }
    }
    async updateEditorDecorations() {
        const [newFrameDecorations, inlineValueDecorations] = await Promise.all([
            this.createFrameDecorations(),
            this.createInlineValueDecorations()
        ]);
        const codeEditor = this.editor.getControl();
        codeEditor.removeDecorations([debug_inline_value_decorator_1.INLINE_VALUE_DECORATION_KEY]);
        codeEditor.setDecorationsByType('Inline debug decorations', debug_inline_value_decorator_1.INLINE_VALUE_DECORATION_KEY, inlineValueDecorations);
        this.editorDecorations = this.deltaDecorations(this.editorDecorations, newFrameDecorations);
    }
    async createInlineValueDecorations() {
        if (!this.sessions.isCurrentEditorFrame(this.uri)) {
            return [];
        }
        const { currentFrame } = this.sessions;
        return this.inlineValueDecorator.calculateDecorations(this, currentFrame);
    }
    createFrameDecorations() {
        const { currentFrame, topFrame } = this.sessions;
        if (!currentFrame) {
            return [];
        }
        if (!currentFrame.thread.stopped) {
            return [];
        }
        if (!this.sessions.isCurrentEditorFrame(this.uri)) {
            return [];
        }
        const decorations = [];
        const columnUntilEOLRange = new monaco.Range(currentFrame.raw.line, currentFrame.raw.column, currentFrame.raw.line, 1 << 30);
        const range = new monaco.Range(currentFrame.raw.line, currentFrame.raw.column, currentFrame.raw.line, currentFrame.raw.column + 1);
        if (topFrame === currentFrame) {
            decorations.push({
                options: DebugEditorModel_1.TOP_STACK_FRAME_MARGIN,
                range
            });
            decorations.push({
                options: DebugEditorModel_1.TOP_STACK_FRAME_DECORATION,
                range: columnUntilEOLRange
            });
            const firstNonWhitespaceColumn = this.editor.document.textEditorModel.getLineFirstNonWhitespaceColumn(currentFrame.raw.line);
            if (currentFrame.raw.column > firstNonWhitespaceColumn) {
                decorations.push({
                    options: DebugEditorModel_1.TOP_STACK_FRAME_INLINE_DECORATION,
                    range: columnUntilEOLRange
                });
            }
        }
        else {
            decorations.push({
                options: DebugEditorModel_1.FOCUSED_STACK_FRAME_MARGIN,
                range
            });
            decorations.push({
                options: DebugEditorModel_1.FOCUSED_STACK_FRAME_DECORATION,
                range: columnUntilEOLRange
            });
        }
        return decorations;
    }
    async toggleExceptionWidget() {
        const { currentFrame } = this.sessions;
        if (!currentFrame) {
            return;
        }
        if (!this.sessions.isCurrentEditorFrame(this.uri)) {
            this.exceptionWidget.hide();
            return;
        }
        const info = await currentFrame.thread.getExceptionInfo();
        if (!info) {
            this.exceptionWidget.hide();
            return;
        }
        this.exceptionWidget.show({
            info,
            lineNumber: currentFrame.raw.line,
            column: currentFrame.raw.column
        });
    }
    render() {
        this.renderBreakpoints();
        this.renderCurrentBreakpoints();
    }
    renderBreakpoints() {
        const breakpoints = this.breakpoints.getBreakpoints(this.uri);
        const decorations = this.createBreakpointDecorations(breakpoints);
        this.breakpointDecorations = this.deltaDecorations(this.breakpointDecorations, decorations);
        this.updateBreakpointRanges(breakpoints);
    }
    createBreakpointDecorations(breakpoints) {
        return breakpoints.map(breakpoint => this.createBreakpointDecoration(breakpoint));
    }
    createBreakpointDecoration(breakpoint) {
        const lineNumber = breakpoint.raw.line;
        const column = breakpoint.raw.column;
        const range = typeof column === 'number' ? new monaco.Range(lineNumber, column, lineNumber, column + 1) : new monaco.Range(lineNumber, 1, lineNumber, 2);
        return {
            range,
            options: {
                stickiness: DebugEditorModel_1.STICKINESS
            }
        };
    }
    updateBreakpointRanges(breakpoints) {
        var _a;
        this.breakpointRanges.clear();
        for (let i = 0; i < this.breakpointDecorations.length; i++) {
            const decoration = this.breakpointDecorations[i];
            const breakpoint = breakpoints[i];
            const range = (_a = this.editor.getControl().getModel()) === null || _a === void 0 ? void 0 : _a.getDecorationRange(decoration);
            if (range) {
                this.breakpointRanges.set(decoration, [range, breakpoint]);
            }
        }
    }
    renderCurrentBreakpoints() {
        const decorations = this.createCurrentBreakpointDecorations();
        this.currentBreakpointDecorations = this.deltaDecorations(this.currentBreakpointDecorations, decorations);
    }
    createCurrentBreakpointDecorations() {
        const breakpoints = this.sessions.getBreakpoints(this.uri);
        return breakpoints.map(breakpoint => this.createCurrentBreakpointDecoration(breakpoint));
    }
    createCurrentBreakpointDecoration(breakpoint) {
        var _a;
        const lineNumber = breakpoint.line;
        const column = breakpoint.column;
        const range = typeof column === 'number' ? new monaco.Range(lineNumber, column, lineNumber, column + 1) : new monaco.Range(lineNumber, 1, lineNumber, 1);
        const { className, message } = breakpoint.getDecoration();
        const renderInline = typeof column === 'number' && (column > (((_a = this.editor.getControl().getModel()) === null || _a === void 0 ? void 0 : _a.getLineFirstNonWhitespaceColumn(lineNumber)) || 0));
        return {
            range,
            options: {
                glyphMarginClassName: className,
                glyphMarginHoverMessage: message.map(value => ({ value })),
                stickiness: DebugEditorModel_1.STICKINESS,
                beforeContentClassName: renderInline ? `theia-debug-breakpoint-column codicon ${className}` : undefined
            }
        };
    }
    updateBreakpoints() {
        if (this.areBreakpointsAffected()) {
            const breakpoints = this.createBreakpoints();
            this.breakpoints.setBreakpoints(this.uri, breakpoints);
        }
    }
    areBreakpointsAffected() {
        var _a;
        if (this.updatingDecorations || !this.editor.getControl().getModel()) {
            return false;
        }
        for (const decoration of this.breakpointDecorations) {
            const range = (_a = this.editor.getControl().getModel()) === null || _a === void 0 ? void 0 : _a.getDecorationRange(decoration);
            const oldRange = this.breakpointRanges.get(decoration)[0];
            if (!range || !range.equalsRange(oldRange)) {
                return true;
            }
        }
        return false;
    }
    createBreakpoints() {
        var _a, _b;
        const { uri } = this;
        const lines = new Set();
        const breakpoints = [];
        for (const decoration of this.breakpointDecorations) {
            const range = (_a = this.editor.getControl().getModel()) === null || _a === void 0 ? void 0 : _a.getDecorationRange(decoration);
            if (range && !lines.has(range.startLineNumber)) {
                const line = range.startLineNumber;
                const column = range.startColumn;
                const oldBreakpoint = (_b = this.breakpointRanges.get(decoration)) === null || _b === void 0 ? void 0 : _b[1];
                const isLineBreakpoint = (oldBreakpoint === null || oldBreakpoint === void 0 ? void 0 : oldBreakpoint.raw.line) !== undefined && (oldBreakpoint === null || oldBreakpoint === void 0 ? void 0 : oldBreakpoint.raw.column) === undefined;
                const change = isLineBreakpoint ? { line } : { line, column };
                const breakpoint = breakpoint_marker_1.SourceBreakpoint.create(uri, change, oldBreakpoint);
                breakpoints.push(breakpoint);
                lines.add(line);
            }
        }
        return breakpoints;
    }
    get position() {
        return this.editor.getControl().getPosition();
    }
    getBreakpoint(position = this.position) {
        return this.getInlineBreakpoint(position) || this.getLineBreakpoints(position)[0];
    }
    getInlineBreakpoint(position = this.position) {
        return this.sessions.getInlineBreakpoint(this.uri, position.lineNumber, position.column);
    }
    getLineBreakpoints(position = this.position) {
        return this.sessions.getLineBreakpoints(this.uri, position.lineNumber);
    }
    addBreakpoint(raw) {
        this.breakpoints.addBreakpoint(breakpoint_marker_1.SourceBreakpoint.create(this.uri, raw));
    }
    toggleBreakpoint(position = this.position) {
        const { lineNumber } = position;
        const breakpoints = this.getLineBreakpoints(position);
        if (breakpoints.length) {
            for (const breakpoint of breakpoints) {
                breakpoint.remove();
            }
        }
        else {
            this.addBreakpoint({ line: lineNumber });
        }
    }
    addInlineBreakpoint() {
        const { position } = this;
        const { lineNumber, column } = position;
        const breakpoint = this.getInlineBreakpoint(position);
        if (breakpoint) {
            return;
        }
        this.addBreakpoint({ line: lineNumber, column });
    }
    acceptBreakpoint() {
        const { position, values } = this.breakpointWidget;
        if (position && values) {
            const breakpoint = position.column > 0 ? this.getInlineBreakpoint(position) : this.getLineBreakpoints(position)[0];
            if (breakpoint) {
                breakpoint.updateOrigins(values);
            }
            else {
                const { lineNumber } = position;
                const column = position.column > 0 ? position.column : undefined;
                this.addBreakpoint({ line: lineNumber, column, ...values });
            }
            this.breakpointWidget.hide();
        }
    }
    handleMouseDown(event) {
        if (event.target && event.target.type === monaco.editor.MouseTargetType.GUTTER_GLYPH_MARGIN) {
            if (!event.event.rightButton) {
                this.toggleBreakpoint(event.target.position);
            }
        }
        this.hintBreakpoint(event);
    }
    handleMouseMove(event) {
        this.showHover(event);
        this.hintBreakpoint(event);
    }
    handleMouseLeave(event) {
        this.hideHover(event);
        this.deltaHintDecorations([]);
    }
    hintBreakpoint(event) {
        const hintDecorations = this.createHintDecorations(event);
        this.deltaHintDecorations(hintDecorations);
    }
    deltaHintDecorations(hintDecorations) {
        this.hintDecorations = this.deltaDecorations(this.hintDecorations, hintDecorations);
    }
    createHintDecorations(event) {
        if (event.target && event.target.type === monaco.editor.MouseTargetType.GUTTER_GLYPH_MARGIN && event.target.position) {
            const lineNumber = event.target.position.lineNumber;
            if (this.getLineBreakpoints(event.target.position).length) {
                return [];
            }
            return [{
                    range: new monaco.Range(lineNumber, 1, lineNumber, 1),
                    options: DebugEditorModel_1.BREAKPOINT_HINT_DECORATION
                }];
        }
        return [];
    }
    closeBreakpointIfAffected({ uri, removed }) {
        if (!uri.isEqual(this.uri)) {
            return;
        }
        const position = this.breakpointWidget.position;
        if (!position) {
            return;
        }
        for (const breakpoint of removed) {
            if (breakpoint.raw.line === position.lineNumber) {
                this.breakpointWidget.hide();
                break;
            }
        }
    }
    showHover(mouseEvent) {
        const targetType = mouseEvent.target.type;
        const stopKey = core_1.isOSX ? 'metaKey' : 'ctrlKey';
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        if (targetType === monaco.editor.MouseTargetType.CONTENT_WIDGET && mouseEvent.target.detail === this.hover.getId() && !mouseEvent.event[stopKey]) {
            // mouse moved on top of debug hover widget
            return;
        }
        if (targetType === monaco.editor.MouseTargetType.CONTENT_TEXT) {
            this.hover.show({
                selection: mouseEvent.target.range,
                immediate: false
            });
        }
        else {
            this.hover.hide({ immediate: false });
        }
    }
    hideHover({ event }) {
        const rect = this.hover.getDomNode().getBoundingClientRect();
        if (event.posx < rect.left || event.posx > rect.right || event.posy < rect.top || event.posy > rect.bottom) {
            this.hover.hide({ immediate: false });
        }
    }
    deltaDecorations(oldDecorations, newDecorations) {
        this.updatingDecorations = true;
        try {
            return this.editor.getControl().deltaDecorations(oldDecorations, newDecorations);
        }
        finally {
            this.updatingDecorations = false;
        }
    }
};
exports.DebugEditorModel = DebugEditorModel;
DebugEditorModel.CONTEXT_MENU = ['debug-editor-context-menu'];
DebugEditorModel.STICKINESS = monaco.editor.TrackedRangeStickiness.NeverGrowsWhenTypingAtEdges;
DebugEditorModel.BREAKPOINT_HINT_DECORATION = {
    glyphMarginClassName: 'codicon-debug-hint',
    stickiness: DebugEditorModel_1.STICKINESS
};
DebugEditorModel.TOP_STACK_FRAME_MARGIN = {
    glyphMarginClassName: 'codicon-debug-stackframe',
    stickiness: DebugEditorModel_1.STICKINESS
};
DebugEditorModel.FOCUSED_STACK_FRAME_MARGIN = {
    glyphMarginClassName: 'codicon-debug-stackframe-focused',
    stickiness: DebugEditorModel_1.STICKINESS
};
DebugEditorModel.TOP_STACK_FRAME_DECORATION = {
    isWholeLine: true,
    className: 'theia-debug-top-stack-frame-line',
    stickiness: DebugEditorModel_1.STICKINESS
};
DebugEditorModel.TOP_STACK_FRAME_INLINE_DECORATION = {
    beforeContentClassName: 'theia-debug-top-stack-frame-column'
};
DebugEditorModel.FOCUSED_STACK_FRAME_DECORATION = {
    isWholeLine: true,
    className: 'theia-debug-focused-stack-frame-line',
    stickiness: DebugEditorModel_1.STICKINESS
};
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_hover_widget_1.DebugHoverWidget),
    tslib_1.__metadata("design:type", debug_hover_widget_1.DebugHoverWidget)
], DebugEditorModel.prototype, "hover", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_editor_1.DebugEditor),
    tslib_1.__metadata("design:type", Object)
], DebugEditorModel.prototype, "editor", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(breakpoint_manager_1.BreakpointManager),
    tslib_1.__metadata("design:type", breakpoint_manager_1.BreakpointManager)
], DebugEditorModel.prototype, "breakpoints", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_session_manager_1.DebugSessionManager),
    tslib_1.__metadata("design:type", debug_session_manager_1.DebugSessionManager)
], DebugEditorModel.prototype, "sessions", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ContextMenuRenderer),
    tslib_1.__metadata("design:type", browser_1.ContextMenuRenderer)
], DebugEditorModel.prototype, "contextMenu", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_breakpoint_widget_1.DebugBreakpointWidget),
    tslib_1.__metadata("design:type", debug_breakpoint_widget_1.DebugBreakpointWidget)
], DebugEditorModel.prototype, "breakpointWidget", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_exception_widget_1.DebugExceptionWidget),
    tslib_1.__metadata("design:type", debug_exception_widget_1.DebugExceptionWidget)
], DebugEditorModel.prototype, "exceptionWidget", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_inline_value_decorator_1.DebugInlineValueDecorator),
    tslib_1.__metadata("design:type", debug_inline_value_decorator_1.DebugInlineValueDecorator)
], DebugEditorModel.prototype, "inlineValueDecorator", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_session_manager_1.DebugSessionManager),
    tslib_1.__metadata("design:type", debug_session_manager_1.DebugSessionManager)
], DebugEditorModel.prototype, "sessionManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugEditorModel.prototype, "init", null);
exports.DebugEditorModel = DebugEditorModel = DebugEditorModel_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugEditorModel);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/editor/debug-editor-service.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/editor/debug-editor-service.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugEditorService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
const browser_1 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const browser_2 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const monaco_editor_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-editor */ "../../node_modules/@theia/monaco/lib/browser/monaco-editor.js");
const debug_session_manager_1 = __webpack_require__(/*! ../debug-session-manager */ "../../node_modules/@theia/debug/lib/browser/debug-session-manager.js");
const debug_editor_model_1 = __webpack_require__(/*! ./debug-editor-model */ "../../node_modules/@theia/debug/lib/browser/editor/debug-editor-model.js");
const breakpoint_manager_1 = __webpack_require__(/*! ../breakpoint/breakpoint-manager */ "../../node_modules/@theia/debug/lib/browser/breakpoint/breakpoint-manager.js");
let DebugEditorService = class DebugEditorService {
    constructor() {
        this.models = new Map();
    }
    init() {
        this.editors.all.forEach(widget => this.push(widget));
        this.editors.onCreated(widget => this.push(widget));
    }
    push(widget) {
        const editor = monaco_editor_1.MonacoEditor.get(widget);
        if (!editor) {
            return;
        }
        const debugModel = this.factory(editor);
        this.models.set(editor, debugModel);
        widget.onDispose(() => {
            debugModel.dispose();
            this.models.delete(editor);
        });
    }
    get model() {
        const { currentEditor } = this.editors;
        return currentEditor && this.models.get(currentEditor.editor);
    }
    get currentUri() {
        const { currentEditor } = this.editors;
        return currentEditor && currentEditor.getResourceUri();
    }
    getLogpoint(position) {
        const logpoint = this.anyBreakpoint(position);
        return logpoint && logpoint.logMessage ? logpoint : undefined;
    }
    getLogpointEnabled(position) {
        const logpoint = this.getLogpoint(position);
        return logpoint && logpoint.enabled;
    }
    getBreakpoint(position) {
        const breakpoint = this.anyBreakpoint(position);
        return breakpoint && breakpoint.logMessage ? undefined : breakpoint;
    }
    getBreakpointEnabled(position) {
        const breakpoint = this.getBreakpoint(position);
        return breakpoint && breakpoint.enabled;
    }
    anyBreakpoint(position) {
        return this.model && this.model.getBreakpoint(position);
    }
    getInlineBreakpoint(position) {
        return this.model && this.model.getInlineBreakpoint(position);
    }
    toggleBreakpoint(position) {
        const { model } = this;
        if (model) {
            model.toggleBreakpoint(position);
        }
    }
    setBreakpointEnabled(position, enabled) {
        const breakpoint = this.anyBreakpoint(position);
        if (breakpoint) {
            breakpoint.setEnabled(enabled);
        }
    }
    addInlineBreakpoint() {
        const { model } = this;
        if (model) {
            model.addInlineBreakpoint();
        }
    }
    showHover() {
        const { model } = this;
        if (model) {
            const selection = model.editor.getControl().getSelection();
            model.hover.show({ selection, focus: true });
        }
    }
    canShowHover() {
        var _a;
        const { model } = this;
        if (model) {
            const selection = model.editor.getControl().getSelection();
            return !!((_a = model.editor.getControl().getModel()) === null || _a === void 0 ? void 0 : _a.getWordAtPosition(selection.getStartPosition()));
        }
        return false;
    }
    addBreakpoint(context, position) {
        const { model } = this;
        if (model) {
            position = position || model.position;
            const breakpoint = model.getBreakpoint(position);
            if (breakpoint) {
                model.breakpointWidget.show({ breakpoint, context });
            }
            else {
                model.breakpointWidget.show({
                    position,
                    context
                });
            }
        }
    }
    async editBreakpoint(breakpointOrPosition) {
        if (breakpointOrPosition instanceof monaco.Position) {
            breakpointOrPosition = this.anyBreakpoint(breakpointOrPosition);
        }
        if (breakpointOrPosition) {
            const editor = await breakpointOrPosition.open();
            const model = this.models.get(editor.editor);
            if (model) {
                model.breakpointWidget.show(breakpointOrPosition);
            }
        }
    }
    closeBreakpoint() {
        const { model } = this;
        if (model) {
            model.breakpointWidget.hide();
        }
    }
    acceptBreakpoint() {
        const { model } = this;
        if (model) {
            model.acceptBreakpoint();
        }
    }
};
exports.DebugEditorService = DebugEditorService;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.EditorManager),
    tslib_1.__metadata("design:type", browser_1.EditorManager)
], DebugEditorService.prototype, "editors", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(breakpoint_manager_1.BreakpointManager),
    tslib_1.__metadata("design:type", breakpoint_manager_1.BreakpointManager)
], DebugEditorService.prototype, "breakpoints", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_session_manager_1.DebugSessionManager),
    tslib_1.__metadata("design:type", debug_session_manager_1.DebugSessionManager)
], DebugEditorService.prototype, "sessionManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.ContextMenuRenderer),
    tslib_1.__metadata("design:type", browser_2.ContextMenuRenderer)
], DebugEditorService.prototype, "contextMenu", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_editor_model_1.DebugEditorModelFactory),
    tslib_1.__metadata("design:type", Function)
], DebugEditorService.prototype, "factory", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugEditorService.prototype, "init", null);
exports.DebugEditorService = DebugEditorService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugEditorService);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/editor/debug-editor.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/editor/debug-editor.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugEditor = void 0;
exports.DebugEditor = Symbol('DebugEditor');


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/editor/debug-exception-widget.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/editor/debug-exception-widget.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugExceptionWidget = exports.DebugExceptionMonacoEditorZoneWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const client_1 = __webpack_require__(/*! @theia/core/shared/react-dom/client */ "../../node_modules/@theia/core/shared/react-dom/client/index.js");
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const disposable_1 = __webpack_require__(/*! @theia/core/lib/common/disposable */ "../../node_modules/@theia/core/lib/common/disposable.js");
const monaco_editor_zone_widget_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-editor-zone-widget */ "../../node_modules/@theia/monaco/lib/browser/monaco-editor-zone-widget.js");
const debug_editor_1 = __webpack_require__(/*! ./debug-editor */ "../../node_modules/@theia/debug/lib/browser/editor/debug-editor.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const widgets_1 = __webpack_require__(/*! @theia/core/lib/browser/widgets */ "../../node_modules/@theia/core/lib/browser/widgets/index.js");
class DebugExceptionMonacoEditorZoneWidget extends monaco_editor_zone_widget_1.MonacoEditorZoneWidget {
    computeContainerHeight(zoneHeight) {
        // reset height to match it to the content
        this.containerNode.style.height = 'initial';
        const height = this.containerNode.offsetHeight;
        const result = super.computeContainerHeight(zoneHeight);
        result.height = height;
        return result;
    }
}
exports.DebugExceptionMonacoEditorZoneWidget = DebugExceptionMonacoEditorZoneWidget;
let DebugExceptionWidget = class DebugExceptionWidget {
    constructor() {
        this.toDispose = new disposable_1.DisposableCollection();
    }
    init() {
        this.doInit();
    }
    async doInit() {
        this.toDispose.push(this.zone = new DebugExceptionMonacoEditorZoneWidget(this.editor.getControl()));
        this.zone.containerNode.classList.add('theia-debug-exception-widget');
        this.containerNodeRoot = (0, client_1.createRoot)(this.zone.containerNode);
        this.toDispose.push(disposable_1.Disposable.create(() => this.containerNodeRoot.unmount()));
        this.toDispose.push(this.editor.getControl().onDidLayoutChange(() => this.layout()));
    }
    dispose() {
        this.toDispose.dispose();
    }
    show({ info, lineNumber, column }) {
        this.render(info, () => {
            const fontInfo = this.editor.getControl().getOption(monaco.editor.EditorOption.fontInfo);
            this.zone.containerNode.style.fontSize = `${fontInfo.fontSize}px`;
            this.zone.containerNode.style.lineHeight = `${fontInfo.lineHeight}px`;
            if (lineNumber !== undefined && column !== undefined) {
                const afterLineNumber = lineNumber;
                const afterColumn = column;
                this.zone.show({ showFrame: true, afterLineNumber, afterColumn, heightInLines: 0, frameWidth: 1 });
            }
            this.layout();
        });
    }
    hide() {
        this.zone.hide();
    }
    render(info, cb) {
        const stackTrace = info.details && info.details.stackTrace;
        const exceptionTitle = info.id ?
            nls_1.nls.localizeByDefault('Exception has occurred: {0}', info.id) :
            nls_1.nls.localizeByDefault('Exception has occurred.');
        this.containerNodeRoot.render(React.createElement(React.Fragment, null,
            React.createElement("div", { className: 'title', ref: cb },
                exceptionTitle,
                React.createElement("span", { id: "exception-close", className: (0, widgets_1.codicon)('close', true), onClick: () => this.hide(), title: nls_1.nls.localizeByDefault('Close') })),
            info.description && React.createElement("div", { className: 'description' }, info.description),
            stackTrace && React.createElement("div", { className: 'stack-trace' }, stackTrace)));
    }
    layout() {
        // reset height to match it to the content
        this.zone.containerNode.style.height = 'initial';
        const lineHeight = this.editor.getControl().getOption(monaco.editor.EditorOption.lineHeight);
        const heightInLines = Math.ceil(this.zone.containerNode.offsetHeight / lineHeight);
        this.zone.layout(heightInLines);
    }
};
exports.DebugExceptionWidget = DebugExceptionWidget;
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_editor_1.DebugEditor),
    tslib_1.__metadata("design:type", Object)
], DebugExceptionWidget.prototype, "editor", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugExceptionWidget.prototype, "init", null);
exports.DebugExceptionWidget = DebugExceptionWidget = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugExceptionWidget);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/editor/debug-expression-provider.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/editor/debug-expression-provider.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation and others. All rights reserved.
 *  Licensed under the MIT License. See https://github.com/Microsoft/vscode/blob/master/LICENSE.txt for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugExpressionProvider = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
/**
 * TODO: introduce a new request to LSP to look up an expression range: https://github.com/Microsoft/language-server-protocol/issues/462
 */
let DebugExpressionProvider = class DebugExpressionProvider {
    get(model, selection) {
        const lineContent = model.getLineContent(selection.startLineNumber);
        const { start, end } = this.getExactExpressionStartAndEnd(lineContent, selection.startColumn, selection.endColumn);
        return lineContent.substring(start - 1, end);
    }
    getExactExpressionStartAndEnd(lineContent, looseStart, looseEnd) {
        let matchingExpression = undefined;
        let startOffset = 0;
        // Some example supported expressions: myVar.prop, a.b.c.d, myVar?.prop, myVar->prop, MyClass::StaticProp, *myVar
        // Match any character except a set of characters which often break interesting sub-expressions
        const expression = /([^()\[\]{}<>\s+\-/%~#^;=|,`!]|\->)+/g;
        // eslint-disable-next-line no-null/no-null
        let result = null;
        // First find the full expression under the cursor
        while (result = expression.exec(lineContent)) {
            const start = result.index + 1;
            const end = start + result[0].length;
            if (start <= looseStart && end >= looseEnd) {
                matchingExpression = result[0];
                startOffset = start;
                break;
            }
        }
        // If there are non-word characters after the cursor, we want to truncate the expression then.
        // For example in expression 'a.b.c.d', if the focus was under 'b', 'a.b' would be evaluated.
        if (matchingExpression) {
            const subExpression = /\w+/g;
            // eslint-disable-next-line no-null/no-null
            let subExpressionResult = null;
            while (subExpressionResult = subExpression.exec(matchingExpression)) {
                const subEnd = subExpressionResult.index + 1 + startOffset + subExpressionResult[0].length;
                if (subEnd >= looseEnd) {
                    break;
                }
            }
            if (subExpressionResult) {
                matchingExpression = matchingExpression.substring(0, subExpression.lastIndex);
            }
        }
        return matchingExpression ?
            { start: startOffset, end: startOffset + matchingExpression.length - 1 } :
            { start: 0, end: 0 };
    }
};
exports.DebugExpressionProvider = DebugExpressionProvider;
exports.DebugExpressionProvider = DebugExpressionProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugExpressionProvider);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/editor/debug-hover-source.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/editor/debug-hover-source.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugHoverSource = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const source_tree_1 = __webpack_require__(/*! @theia/core/lib/browser/source-tree */ "../../node_modules/@theia/core/lib/browser/source-tree/index.js");
const debug_console_items_1 = __webpack_require__(/*! ../console/debug-console-items */ "../../node_modules/@theia/debug/lib/browser/console/debug-console-items.js");
const debug_session_manager_1 = __webpack_require__(/*! ../debug-session-manager */ "../../node_modules/@theia/debug/lib/browser/debug-session-manager.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
let DebugHoverSource = class DebugHoverSource extends source_tree_1.TreeSource {
    constructor() {
        super(...arguments);
        this.elements = [];
    }
    get expression() {
        return this._expression;
    }
    getElements() {
        return this.elements[Symbol.iterator]();
    }
    renderTitle(element) {
        return React.createElement("div", { className: 'theia-debug-hover-title', title: element.value }, element.value);
    }
    reset() {
        this._expression = undefined;
        this.elements = [];
        this.fireDidChange();
    }
    async evaluate(expression) {
        const evaluated = await this.doEvaluate(expression);
        const elements = evaluated && await evaluated.getElements();
        this._expression = evaluated;
        this.elements = elements ? [...elements] : [];
        this.fireDidChange();
        return evaluated;
    }
    async doEvaluate(expression) {
        const { currentSession } = this.sessions;
        if (!currentSession) {
            return undefined;
        }
        if (currentSession.capabilities.supportsEvaluateForHovers) {
            const item = new debug_console_items_1.ExpressionItem(expression, () => currentSession);
            await item.evaluate('hover');
            return item.available && item || undefined;
        }
        return this.findVariable(expression.split('.').map(word => word.trim()).filter(word => !!word));
    }
    async findVariable(namesToFind) {
        const { currentFrame } = this.sessions;
        if (!currentFrame) {
            return undefined;
        }
        let variable;
        const scopes = await currentFrame.getScopes();
        for (const scope of scopes) {
            const found = await this.doFindVariable(scope, namesToFind);
            if (!variable) {
                variable = found;
            }
            else if (found && found.value !== variable.value) {
                // only show if all expressions found have the same value
                return undefined;
            }
        }
        return variable;
    }
    async doFindVariable(owner, namesToFind) {
        const elements = await owner.getElements();
        const variables = [];
        for (const element of elements) {
            if (element instanceof debug_console_items_1.DebugVariable && element.name === namesToFind[0]) {
                variables.push(element);
            }
        }
        if (variables.length !== 1) {
            return undefined;
        }
        if (namesToFind.length === 1) {
            return variables[0];
        }
        else {
            return this.doFindVariable(variables[0], namesToFind.slice(1));
        }
    }
};
exports.DebugHoverSource = DebugHoverSource;
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_session_manager_1.DebugSessionManager),
    tslib_1.__metadata("design:type", debug_session_manager_1.DebugSessionManager)
], DebugHoverSource.prototype, "sessions", void 0);
exports.DebugHoverSource = DebugHoverSource = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugHoverSource);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/editor/debug-hover-widget.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/editor/debug-hover-widget.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var DebugHoverWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugHoverWidget = exports.createDebugHoverWidgetContainer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const debounce = __webpack_require__(/*! @theia/core/shared/lodash.debounce */ "../../node_modules/@theia/core/shared/lodash.debounce/index.js");
const widgets_1 = __webpack_require__(/*! @theia/core/shared/@lumino/widgets */ "../../node_modules/@theia/core/shared/@lumino/widgets/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const source_tree_1 = __webpack_require__(/*! @theia/core/lib/browser/source-tree */ "../../node_modules/@theia/core/lib/browser/source-tree/index.js");
const disposable_1 = __webpack_require__(/*! @theia/core/lib/common/disposable */ "../../node_modules/@theia/core/lib/common/disposable.js");
const debug_session_manager_1 = __webpack_require__(/*! ../debug-session-manager */ "../../node_modules/@theia/debug/lib/browser/debug-session-manager.js");
const debug_editor_1 = __webpack_require__(/*! ./debug-editor */ "../../node_modules/@theia/debug/lib/browser/editor/debug-editor.js");
const debug_expression_provider_1 = __webpack_require__(/*! ./debug-expression-provider */ "../../node_modules/@theia/debug/lib/browser/editor/debug-expression-provider.js");
const debug_hover_source_1 = __webpack_require__(/*! ./debug-hover-source */ "../../node_modules/@theia/debug/lib/browser/editor/debug-hover-source.js");
const debug_console_items_1 = __webpack_require__(/*! ../console/debug-console-items */ "../../node_modules/@theia/debug/lib/browser/console/debug-console-items.js");
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
const standaloneServices_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/standalone/browser/standaloneServices */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/standalone/browser/standaloneServices.js");
const languageFeatures_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/common/services/languageFeatures */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/common/services/languageFeatures.js");
const cancellation_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/base/common/cancellation */ "../../node_modules/@theia/monaco-editor-core/esm/vs/base/common/cancellation.js");
const position_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/common/core/position */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/common/core/position.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
function createDebugHoverWidgetContainer(parent, editor) {
    const child = source_tree_1.SourceTreeWidget.createContainer(parent, {
        virtualized: false
    });
    child.bind(debug_editor_1.DebugEditor).toConstantValue(editor);
    child.bind(debug_hover_source_1.DebugHoverSource).toSelf();
    child.unbind(source_tree_1.SourceTreeWidget);
    child.bind(debug_expression_provider_1.DebugExpressionProvider).toSelf();
    child.bind(DebugHoverWidget).toSelf();
    return child;
}
exports.createDebugHoverWidgetContainer = createDebugHoverWidgetContainer;
let DebugHoverWidget = DebugHoverWidget_1 = class DebugHoverWidget extends source_tree_1.SourceTreeWidget {
    constructor() {
        super(...arguments);
        this.allowEditorOverflow = true;
        this.domNode = document.createElement('div');
        this.titleNode = document.createElement('div');
        this.contentNode = document.createElement('div');
        this.doSchedule = debounce((fn) => fn(), 300);
    }
    getId() {
        return DebugHoverWidget_1.ID;
    }
    getDomNode() {
        return this.domNode;
    }
    init() {
        super.init();
        this.domNode.className = 'theia-debug-hover';
        this.titleNode.className = 'theia-debug-hover-title';
        this.domNode.appendChild(this.titleNode);
        this.contentNode.className = 'theia-debug-hover-content';
        this.domNode.appendChild(this.contentNode);
        // for stopping scroll events from contentNode going to the editor
        this.contentNode.addEventListener('wheel', e => e.stopPropagation());
        this.editor.getControl().addContentWidget(this);
        this.source = this.hoverSource;
        this.toDispose.pushAll([
            this.hoverSource,
            disposable_1.Disposable.create(() => this.editor.getControl().removeContentWidget(this)),
            disposable_1.Disposable.create(() => this.hide()),
            this.sessions.onDidChange(() => {
                if (!this.isEditorFrame()) {
                    this.hide();
                }
            })
        ]);
    }
    dispose() {
        this.toDispose.dispose();
    }
    show(options) {
        this.schedule(() => this.doShow(options), options && options.immediate);
    }
    hide(options) {
        this.schedule(() => this.doHide(), options && options.immediate);
    }
    schedule(fn, immediate = true) {
        if (immediate) {
            this.doSchedule.cancel();
            fn();
        }
        else {
            this.doSchedule(fn);
        }
    }
    doHide() {
        if (!this.isVisible) {
            return;
        }
        if (this.domNode.contains(document.activeElement)) {
            this.editor.getControl().focus();
        }
        if (this.isAttached) {
            widgets_1.Widget.detach(this);
        }
        this.hoverSource.reset();
        super.hide();
        this.options = undefined;
        this.editor.getControl().layoutContentWidget(this);
    }
    async doShow(options = this.options) {
        const cancellationSource = new cancellation_1.CancellationTokenSource();
        if (!this.isEditorFrame()) {
            this.hide();
            return;
        }
        if (!options) {
            this.hide();
            return;
        }
        if (this.options && this.options.selection.equalsRange(options.selection)) {
            return;
        }
        if (!this.isAttached) {
            widgets_1.Widget.attach(this, this.contentNode);
        }
        this.options = options;
        let matchingExpression;
        const pluginExpressionProvider = standaloneServices_1.StandaloneServices.get(languageFeatures_1.ILanguageFeaturesService).evaluatableExpressionProvider;
        const textEditorModel = this.editor.document.textEditorModel;
        if (pluginExpressionProvider && pluginExpressionProvider.has(textEditorModel)) {
            const registeredProviders = pluginExpressionProvider.ordered(textEditorModel);
            const position = new position_1.Position(this.options.selection.startLineNumber, this.options.selection.startColumn);
            const promises = registeredProviders.map(support => Promise.resolve(support.provideEvaluatableExpression(textEditorModel, position, cancellationSource.token)));
            const results = await Promise.all(promises).then(core_1.ArrayUtils.coalesce);
            if (results.length > 0) {
                matchingExpression = results[0].expression;
                const range = results[0].range;
                if (!matchingExpression) {
                    const lineContent = textEditorModel.getLineContent(position.lineNumber);
                    matchingExpression = lineContent.substring(range.startColumn - 1, range.endColumn - 1);
                }
            }
        }
        else { // use fallback if no provider was registered
            const model = this.editor.getControl().getModel();
            if (model) {
                matchingExpression = this.expressionProvider.get(model, options.selection);
                if (matchingExpression) {
                    const expressionLineContent = model.getLineContent(this.options.selection.startLineNumber);
                    const startColumn = expressionLineContent.indexOf(matchingExpression, this.options.selection.startColumn - matchingExpression.length) + 1;
                    const endColumn = startColumn + matchingExpression.length;
                    this.options.selection = new monaco.Range(this.options.selection.startLineNumber, startColumn, this.options.selection.startLineNumber, endColumn);
                }
            }
        }
        if (!matchingExpression) {
            this.hide();
            return;
        }
        const toFocus = new disposable_1.DisposableCollection();
        if (this.options.focus === true) {
            toFocus.push(this.model.onNodeRefreshed(() => {
                toFocus.dispose();
                this.activate();
            }));
        }
        const expression = await this.hoverSource.evaluate(matchingExpression);
        if (!expression) {
            toFocus.dispose();
            this.hide();
            return;
        }
        this.contentNode.hidden = false;
        ['number', 'boolean', 'string'].forEach(token => this.titleNode.classList.remove(token));
        this.domNode.classList.remove('complex-value');
        if (expression.hasElements) {
            this.domNode.classList.add('complex-value');
        }
        else {
            this.contentNode.hidden = true;
            if (expression.type === 'number' || expression.type === 'boolean' || expression.type === 'string') {
                this.titleNode.classList.add(expression.type);
            }
            else if (!isNaN(+expression.value)) {
                this.titleNode.classList.add('number');
            }
            else if (debug_console_items_1.DebugVariable.booleanRegex.test(expression.value)) {
                this.titleNode.classList.add('boolean');
            }
            else if (debug_console_items_1.DebugVariable.stringRegex.test(expression.value)) {
                this.titleNode.classList.add('string');
            }
        }
        super.show();
        await new Promise(resolve => {
            setTimeout(() => window.requestAnimationFrame(() => {
                this.editor.getControl().layoutContentWidget(this);
                resolve();
            }), 0);
        });
    }
    isEditorFrame() {
        return this.sessions.isCurrentEditorFrame(this.editor.getResourceUri());
    }
    getPosition() {
        if (!this.isVisible) {
            return undefined;
        }
        const position = this.options && this.options.selection.getStartPosition();
        return position
            ? {
                position: new monaco.Position(position.lineNumber, position.column),
                preference: [
                    monaco.editor.ContentWidgetPositionPreference.ABOVE,
                    monaco.editor.ContentWidgetPositionPreference.BELOW,
                ],
            }
            : undefined;
    }
    onUpdateRequest(msg) {
        super.onUpdateRequest(msg);
        const { expression } = this.hoverSource;
        const value = expression && expression.value || '';
        this.titleNode.textContent = value;
        this.titleNode.title = value;
    }
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        this.addKeyListener(this.domNode, browser_1.Key.ESCAPE, () => this.hide());
    }
};
exports.DebugHoverWidget = DebugHoverWidget;
DebugHoverWidget.ID = 'debug.editor.hover';
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_editor_1.DebugEditor),
    tslib_1.__metadata("design:type", Object)
], DebugHoverWidget.prototype, "editor", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_session_manager_1.DebugSessionManager),
    tslib_1.__metadata("design:type", debug_session_manager_1.DebugSessionManager)
], DebugHoverWidget.prototype, "sessions", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_hover_source_1.DebugHoverSource),
    tslib_1.__metadata("design:type", debug_hover_source_1.DebugHoverSource)
], DebugHoverWidget.prototype, "hoverSource", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_expression_provider_1.DebugExpressionProvider),
    tslib_1.__metadata("design:type", debug_expression_provider_1.DebugExpressionProvider)
], DebugHoverWidget.prototype, "expressionProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugHoverWidget.prototype, "init", null);
exports.DebugHoverWidget = DebugHoverWidget = DebugHoverWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugHoverWidget);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/editor/debug-inline-value-decorator.js":
/*!******************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/editor/debug-inline-value-decorator.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2020 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugInlineValueDecorator = exports.INLINE_VALUE_DECORATION_KEY = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
const cancellation_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/base/common/cancellation */ "../../node_modules/@theia/monaco-editor-core/esm/vs/base/common/cancellation.js");
const wordHelper_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/common/core/wordHelper */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/common/core/wordHelper.js");
const languageFeatures_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/common/services/languageFeatures */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/common/services/languageFeatures.js");
const standaloneServices_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/standalone/browser/standaloneServices */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/standalone/browser/standaloneServices.js");
const debug_console_items_1 = __webpack_require__(/*! ../console/debug-console-items */ "../../node_modules/@theia/debug/lib/browser/console/debug-console-items.js");
const debug_preferences_1 = __webpack_require__(/*! ../debug-preferences */ "../../node_modules/@theia/debug/lib/browser/debug-preferences.js");
const codeEditorService_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/browser/services/codeEditorService */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/browser/services/codeEditorService.js");
// https://github.com/theia-ide/vscode/blob/standalone/0.19.x/src/vs/workbench/contrib/debug/browser/debugEditorContribution.ts#L40-L43
exports.INLINE_VALUE_DECORATION_KEY = 'inlinevaluedecoration';
const MAX_NUM_INLINE_VALUES = 100; // JS Global scope can have 700+ entries. We want to limit ourselves for perf reasons
const MAX_INLINE_DECORATOR_LENGTH = 150; // Max string length of each inline decorator when debugging. If exceeded ... is added
const MAX_TOKENIZATION_LINE_LEN = 500; // If line is too long, then inline values for the line are skipped
/**
 * MAX SMI (SMall Integer) as defined in v8.
 * one bit is lost for boxing/unboxing flag.
 * one bit is lost for sign flag.
 * See https://thibaultlaurens.github.io/javascript/2013/04/29/how-the-v8-engine-works/#tagged-values
 */
// https://github.com/theia-ide/vscode/blob/standalone/0.19.x/src/vs/base/common/uint.ts#L7-L13
const MAX_SAFE_SMALL_INTEGER = 1 << 30;
class InlineSegment {
    constructor(column, text) {
        this.column = column;
        this.text = text;
    }
}
let DebugInlineValueDecorator = class DebugInlineValueDecorator {
    constructor() {
        this.enabled = false;
        this.wordToLineNumbersMap = new Map();
    }
    onStart() {
        standaloneServices_1.StandaloneServices.get(codeEditorService_1.ICodeEditorService).registerDecorationType('Inline debug decorations', exports.INLINE_VALUE_DECORATION_KEY, {});
        this.enabled = !!this.preferences['debug.inlineValues'];
        this.preferences.onPreferenceChanged(({ preferenceName, newValue }) => {
            if (preferenceName === 'debug.inlineValues' && !!newValue !== this.enabled) {
                this.enabled = !!newValue;
            }
        });
    }
    async calculateDecorations(debugEditorModel, stackFrame) {
        this.wordToLineNumbersMap = undefined;
        const model = debugEditorModel.editor.getControl().getModel() || undefined;
        return this.updateInlineValueDecorations(debugEditorModel, model, stackFrame);
    }
    // https://github.com/theia-ide/vscode/blob/standalone/0.19.x/src/vs/workbench/contrib/debug/browser/debugEditorContribution.ts#L382-L408
    async updateInlineValueDecorations(debugEditorModel, model, stackFrame) {
        if (!this.enabled || !model || !stackFrame || !stackFrame.source || model.uri.toString() !== stackFrame.source.uri.toString()) {
            return [];
        }
        // XXX: Here is a difference between the VS Code's `IStackFrame` and the `DebugProtocol.StackFrame`.
        // In DAP, `source` is optional, hence `range` is optional too.
        const { range: stackFrameRange } = stackFrame;
        if (!stackFrameRange) {
            return [];
        }
        const scopes = await stackFrame.getMostSpecificScopes(stackFrameRange);
        // Get all top level children in the scope chain
        const decorationsPerScope = await Promise.all(scopes.map(async (scope) => {
            const children = Array.from(await scope.getElements());
            let range = new monaco.Range(0, 0, stackFrameRange.startLineNumber, stackFrameRange.startColumn);
            if (scope.range) {
                range = range.setStartPosition(scope.range.startLineNumber, scope.range.startColumn);
            }
            return this.createInlineValueDecorationsInsideRange(children, range, model, debugEditorModel, stackFrame);
        }));
        return decorationsPerScope.reduce((previous, current) => previous.concat(current), []);
    }
    // https://github.com/theia-ide/vscode/blob/standalone/0.19.x/src/vs/workbench/contrib/debug/browser/debugEditorContribution.ts#L410-L452
    async createInlineValueDecorationsInsideRange(expressions, range, model, debugEditorModel, stackFrame) {
        const decorations = [];
        const inlineValuesProvider = standaloneServices_1.StandaloneServices.get(languageFeatures_1.ILanguageFeaturesService).inlineValuesProvider;
        const textEditorModel = debugEditorModel.editor.document.textEditorModel;
        if (inlineValuesProvider && inlineValuesProvider.has(textEditorModel)) {
            const findVariable = async (variableName, caseSensitiveLookup) => {
                const scopes = await stackFrame.getMostSpecificScopes(stackFrame.range);
                const key = caseSensitiveLookup ? variableName : variableName.toLowerCase();
                for (const scope of scopes) {
                    const expressionContainers = await scope.getElements();
                    let container = expressionContainers.next();
                    while (!container.done) {
                        const debugVariable = container.value;
                        if (debugVariable && debugVariable instanceof debug_console_items_1.DebugVariable) {
                            if (caseSensitiveLookup) {
                                if (debugVariable.name === key) {
                                    return debugVariable;
                                }
                            }
                            else {
                                if (debugVariable.name.toLowerCase() === key) {
                                    return debugVariable;
                                }
                            }
                        }
                        container = expressionContainers.next();
                    }
                }
                return undefined;
            };
            const context = {
                frameId: stackFrame.raw.id,
                stoppedLocation: range
            };
            const cancellationToken = new cancellation_1.CancellationTokenSource().token;
            const registeredProviders = inlineValuesProvider.ordered(textEditorModel).reverse();
            const visibleRanges = debugEditorModel.editor.getControl().getVisibleRanges();
            const lineDecorations = new Map();
            for (const provider of registeredProviders) {
                for (const visibleRange of visibleRanges) {
                    const result = await provider.provideInlineValues(textEditorModel, visibleRange, context, cancellationToken);
                    if (result) {
                        for (const inlineValue of result) {
                            let text = undefined;
                            switch (inlineValue.type) {
                                case 'text':
                                    text = inlineValue.text;
                                    break;
                                case 'variable': {
                                    let varName = inlineValue.variableName;
                                    if (!varName) {
                                        const lineContent = model.getLineContent(inlineValue.range.startLineNumber);
                                        varName = lineContent.substring(inlineValue.range.startColumn - 1, inlineValue.range.endColumn - 1);
                                    }
                                    const variable = await findVariable(varName, inlineValue.caseSensitiveLookup);
                                    if (variable) {
                                        text = this.formatInlineValue(varName, variable.value);
                                    }
                                    break;
                                }
                                case 'expression': {
                                    let expr = inlineValue.expression;
                                    if (!expr) {
                                        const lineContent = model.getLineContent(inlineValue.range.startLineNumber);
                                        expr = lineContent.substring(inlineValue.range.startColumn - 1, inlineValue.range.endColumn - 1);
                                    }
                                    if (expr) {
                                        const expression = new debug_console_items_1.ExpressionItem(expr, () => stackFrame.thread.session);
                                        await expression.evaluate('watch');
                                        if (expression.available) {
                                            text = this.formatInlineValue(expr, expression.value);
                                        }
                                    }
                                    break;
                                }
                            }
                            if (text) {
                                const line = inlineValue.range.startLineNumber;
                                let lineSegments = lineDecorations.get(line);
                                if (!lineSegments) {
                                    lineSegments = [];
                                    lineDecorations.set(line, lineSegments);
                                }
                                if (!lineSegments.some(segment => segment.text === text)) {
                                    lineSegments.push(new InlineSegment(inlineValue.range.startColumn, text));
                                }
                            }
                        }
                    }
                }
            }
            ;
            // sort line segments and concatenate them into a decoration
            const separator = ', ';
            lineDecorations.forEach((segments, line) => {
                if (segments.length > 0) {
                    segments = segments.sort((a, b) => a.column - b.column);
                    const text = segments.map(s => s.text).join(separator);
                    decorations.push(this.createInlineValueDecoration(line, text));
                }
            });
        }
        else { // use fallback if no provider was registered
            const lineToNamesMap = new Map();
            const nameValueMap = new Map();
            for (const expr of expressions) {
                if (expr instanceof debug_console_items_1.DebugVariable) { // XXX: VS Code uses `IExpression` that has `name` and `value`.
                    nameValueMap.set(expr.name, expr.value);
                }
                // Limit the size of map. Too large can have a perf impact
                if (nameValueMap.size >= MAX_NUM_INLINE_VALUES) {
                    break;
                }
            }
            const wordToPositionsMap = this.getWordToPositionsMap(model);
            // Compute unique set of names on each line
            nameValueMap.forEach((_, name) => {
                const positions = wordToPositionsMap.get(name);
                if (positions) {
                    for (const position of positions) {
                        if (range.containsPosition(position)) {
                            if (!lineToNamesMap.has(position.lineNumber)) {
                                lineToNamesMap.set(position.lineNumber, []);
                            }
                            if (lineToNamesMap.get(position.lineNumber).indexOf(name) === -1) {
                                lineToNamesMap.get(position.lineNumber).push(name);
                            }
                        }
                    }
                }
            });
            // Compute decorators for each line
            lineToNamesMap.forEach((names, line) => {
                const contentText = names.sort((first, second) => {
                    const content = model.getLineContent(line);
                    return content.indexOf(first) - content.indexOf(second);
                }).map(name => `${name} = ${nameValueMap.get(name)}`).join(', ');
                decorations.push(this.createInlineValueDecoration(line, contentText));
            });
        }
        return decorations;
    }
    formatInlineValue(...args) {
        const valuePattern = '{0} = {1}';
        const formatRegExp = /{(\d+)}/g;
        if (args.length === 0) {
            return valuePattern;
        }
        return valuePattern.replace(formatRegExp, (match, group) => {
            const idx = parseInt(group, 10);
            return isNaN(idx) || idx < 0 || idx >= args.length ?
                match :
                args[idx];
        });
    }
    // https://github.com/theia-ide/vscode/blob/standalone/0.19.x/src/vs/workbench/contrib/debug/browser/debugEditorContribution.ts#L454-L485
    createInlineValueDecoration(lineNumber, contentText) {
        // If decoratorText is too long, trim and add ellipses. This could happen for minified files with everything on a single line
        if (contentText.length > MAX_INLINE_DECORATOR_LENGTH) {
            contentText = contentText.substring(0, MAX_INLINE_DECORATOR_LENGTH) + '...';
        }
        return {
            range: {
                startLineNumber: lineNumber,
                endLineNumber: lineNumber,
                startColumn: MAX_SAFE_SMALL_INTEGER,
                endColumn: MAX_SAFE_SMALL_INTEGER
            },
            renderOptions: {
                after: {
                    contentText,
                    backgroundColor: 'rgba(255, 200, 0, 0.2)',
                    margin: '10px'
                },
                dark: {
                    after: {
                        color: 'rgba(255, 255, 255, 0.5)',
                    }
                },
                light: {
                    after: {
                        color: 'rgba(0, 0, 0, 0.5)',
                    }
                }
            }
        };
    }
    // https://github.com/theia-ide/vscode/blob/standalone/0.19.x/src/vs/workbench/contrib/debug/browser/debugEditorContribution.ts#L487-L531
    getWordToPositionsMap(model) {
        model = model;
        if (!this.wordToLineNumbersMap) {
            this.wordToLineNumbersMap = new Map();
            if (!model) {
                return this.wordToLineNumbersMap;
            }
            // For every word in every line, map its ranges for fast lookup
            for (let lineNumber = 1, len = model.getLineCount(); lineNumber <= len; ++lineNumber) {
                const lineContent = model.getLineContent(lineNumber);
                // If line is too long then skip the line
                if (lineContent.length > MAX_TOKENIZATION_LINE_LEN) {
                    continue;
                }
                model.tokenization.forceTokenization(lineNumber);
                const lineTokens = model.tokenization.getLineTokens(lineNumber);
                for (let tokenIndex = 0, tokenCount = lineTokens.getCount(); tokenIndex < tokenCount; tokenIndex++) {
                    const tokenStartOffset = lineTokens.getStartOffset(tokenIndex);
                    const tokenEndOffset = lineTokens.getEndOffset(tokenIndex);
                    const tokenType = lineTokens.getStandardTokenType(tokenIndex);
                    const tokenStr = lineContent.substring(tokenStartOffset, tokenEndOffset);
                    // Token is a word and not a comment
                    if (tokenType === 0 /* StandardTokenType.Other */) {
                        wordHelper_1.DEFAULT_WORD_REGEXP.lastIndex = 0; // We assume tokens will usually map 1:1 to words if they match
                        const wordMatch = wordHelper_1.DEFAULT_WORD_REGEXP.exec(tokenStr);
                        if (wordMatch) {
                            const word = wordMatch[0];
                            if (!this.wordToLineNumbersMap.has(word)) {
                                this.wordToLineNumbersMap.set(word, []);
                            }
                            this.wordToLineNumbersMap.get(word).push(new monaco.Position(lineNumber, tokenStartOffset));
                        }
                    }
                }
            }
        }
        return this.wordToLineNumbersMap;
    }
};
exports.DebugInlineValueDecorator = DebugInlineValueDecorator;
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_preferences_1.DebugPreferences),
    tslib_1.__metadata("design:type", Object)
], DebugInlineValueDecorator.prototype, "preferences", void 0);
exports.DebugInlineValueDecorator = DebugInlineValueDecorator = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugInlineValueDecorator);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/model/debug-breakpoint.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/model/debug-breakpoint.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugBreakpoint = exports.DebugBreakpointDecoration = exports.DebugBreakpointOptions = exports.DebugBreakpointData = void 0;
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
class DebugBreakpointData {
}
exports.DebugBreakpointData = DebugBreakpointData;
class DebugBreakpointOptions {
}
exports.DebugBreakpointOptions = DebugBreakpointOptions;
class DebugBreakpointDecoration {
}
exports.DebugBreakpointDecoration = DebugBreakpointDecoration;
class DebugBreakpoint extends DebugBreakpointOptions {
    constructor(uri, options) {
        super();
        this.uri = uri;
        this.setBreakpointEnabled = (event) => {
            this.setEnabled(event.target.checked);
        };
        Object.assign(this, options);
    }
    update(data) {
        Object.assign(this, data);
    }
    get idFromAdapter() {
        return this.raw && this.raw.id;
    }
    get id() {
        return this.origin.id;
    }
    get enabled() {
        return this.breakpoints.breakpointsEnabled && this.origin.enabled;
    }
    get installed() {
        return !!this.raw;
    }
    get verified() {
        return !!this.raw ? this.raw.verified : true;
    }
    get message() {
        return this.raw && this.raw.message || '';
    }
    render() {
        const classNames = ['theia-source-breakpoint'];
        if (!this.isEnabled()) {
            classNames.push(browser_1.DISABLED_CLASS);
        }
        const decoration = this.getDecoration();
        return React.createElement("div", { title: decoration.message.join('\n'), className: classNames.join(' ') },
            React.createElement("span", { className: 'theia-debug-breakpoint-icon codicon ' + decoration.className }),
            React.createElement("input", { className: 'theia-input', type: 'checkbox', checked: this.origin.enabled, onChange: this.setBreakpointEnabled }),
            this.doRender());
    }
    isEnabled() {
        return this.breakpoints.breakpointsEnabled && this.verified;
    }
    getDecoration() {
        if (!this.enabled) {
            return this.getDisabledBreakpointDecoration();
        }
        if (this.installed && !this.verified) {
            return this.getUnverifiedBreakpointDecoration();
        }
        return this.doGetDecoration();
    }
    getUnverifiedBreakpointDecoration() {
        const decoration = this.getBreakpointDecoration();
        return {
            className: decoration.className + '-unverified',
            message: [this.message || 'Unverified ' + decoration.message[0]]
        };
    }
    getDisabledBreakpointDecoration(message) {
        const decoration = this.getBreakpointDecoration();
        return {
            className: decoration.className + '-disabled',
            message: [message || ('Disabled ' + decoration.message[0])]
        };
    }
    doGetDecoration(messages = []) {
        if (this.message) {
            if (messages.length) {
                messages[messages.length - 1].concat(', ' + this.message);
            }
            else {
                messages.push(this.message);
            }
        }
        return this.getBreakpointDecoration(messages);
    }
}
exports.DebugBreakpoint = DebugBreakpoint;


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/model/debug-function-breakpoint.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/model/debug-function-breakpoint.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugFunctionBreakpoint = void 0;
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const breakpoint_manager_1 = __webpack_require__(/*! ../breakpoint/breakpoint-manager */ "../../node_modules/@theia/debug/lib/browser/breakpoint/breakpoint-manager.js");
const debug_breakpoint_1 = __webpack_require__(/*! ./debug-breakpoint */ "../../node_modules/@theia/debug/lib/browser/model/debug-breakpoint.js");
const dialogs_1 = __webpack_require__(/*! @theia/core/lib/browser/dialogs */ "../../node_modules/@theia/core/lib/browser/dialogs.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
class DebugFunctionBreakpoint extends debug_breakpoint_1.DebugBreakpoint {
    constructor(origin, options) {
        super(breakpoint_manager_1.BreakpointManager.FUNCTION_URI, options);
        this.origin = origin;
    }
    setEnabled(enabled) {
        const breakpoints = this.breakpoints.getFunctionBreakpoints();
        const breakpoint = breakpoints.find(b => b.id === this.id);
        if (breakpoint && breakpoint.enabled !== enabled) {
            breakpoint.enabled = enabled;
            this.breakpoints.setFunctionBreakpoints(breakpoints);
        }
    }
    isEnabled() {
        return super.isEnabled() && this.isSupported();
    }
    isSupported() {
        const { session } = this;
        return !session || !!session.capabilities.supportsFunctionBreakpoints;
    }
    remove() {
        const breakpoints = this.breakpoints.getFunctionBreakpoints();
        const newBreakpoints = breakpoints.filter(b => b.id !== this.id);
        if (breakpoints.length !== newBreakpoints.length) {
            this.breakpoints.setFunctionBreakpoints(newBreakpoints);
        }
    }
    get name() {
        return this.origin.raw.name;
    }
    doRender() {
        return React.createElement("span", { className: 'line-info' }, this.name);
    }
    doGetDecoration() {
        if (!this.isSupported()) {
            return this.getDisabledBreakpointDecoration(core_1.nls.localizeByDefault('Function breakpoints are not supported by this debug type'));
        }
        return super.doGetDecoration();
    }
    getBreakpointDecoration(message) {
        return {
            className: 'codicon-debug-breakpoint-function',
            message: message || [core_1.nls.localizeByDefault('Function Breakpoint')]
        };
    }
    async open() {
        const input = new dialogs_1.SingleTextInputDialog({
            title: core_1.nls.localizeByDefault('Add Function Breakpoint'),
            initialValue: this.name
        });
        const newValue = await input.open();
        if (newValue !== undefined && newValue !== this.name) {
            const breakpoints = this.breakpoints.getFunctionBreakpoints();
            const breakpoint = breakpoints.find(b => b.id === this.id);
            if (breakpoint) {
                if (breakpoint.raw.name !== newValue) {
                    breakpoint.raw.name = newValue;
                    this.breakpoints.setFunctionBreakpoints(breakpoints);
                }
            }
            else {
                this.origin.raw.name = newValue;
                breakpoints.push(this.origin);
                this.breakpoints.setFunctionBreakpoints(breakpoints);
            }
        }
    }
}
exports.DebugFunctionBreakpoint = DebugFunctionBreakpoint;


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/model/debug-instruction-breakpoint.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/model/debug-instruction-breakpoint.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2022 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugInstructionBreakpoint = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const breakpoint_manager_1 = __webpack_require__(/*! ../breakpoint/breakpoint-manager */ "../../node_modules/@theia/debug/lib/browser/breakpoint/breakpoint-manager.js");
const debug_breakpoint_1 = __webpack_require__(/*! ./debug-breakpoint */ "../../node_modules/@theia/debug/lib/browser/model/debug-breakpoint.js");
class DebugInstructionBreakpoint extends debug_breakpoint_1.DebugBreakpoint {
    constructor(origin, options) {
        super(breakpoint_manager_1.BreakpointManager.INSTRUCTION_URI, options);
        this.origin = origin;
    }
    setEnabled(enabled) {
        if (enabled !== this.origin.enabled) {
            this.breakpoints.updateInstructionBreakpoint(this.origin.id, { enabled });
        }
    }
    isEnabled() {
        return super.isEnabled() && this.isSupported();
    }
    isSupported() {
        var _a;
        return Boolean((_a = this.session) === null || _a === void 0 ? void 0 : _a.capabilities.supportsInstructionBreakpoints);
    }
    remove() {
        this.breakpoints.removeInstructionBreakpoint(this.origin.instructionReference);
    }
    doRender() {
        return React.createElement("span", { className: "line-info" }, this.origin.instructionReference);
    }
    getBreakpointDecoration(message) {
        if (!this.isSupported()) {
            return {
                className: 'codicon-debug-breakpoint-unsupported',
                message: message !== null && message !== void 0 ? message : [core_1.nls.localize('theia/debug/instruction-breakpoint', 'Instruction Breakpoint')],
            };
        }
        if (this.origin.condition || this.origin.hitCondition) {
            return {
                className: 'codicon-debug-breakpoint-conditional',
                message: message || [core_1.nls.localizeByDefault('Conditional Breakpoint...')]
            };
        }
        return {
            className: 'codicon-debug-breakpoint',
            message: message || [core_1.nls.localize('theia/debug/instruction-breakpoint', 'Instruction Breakpoint')]
        };
    }
}
exports.DebugInstructionBreakpoint = DebugInstructionBreakpoint;


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/model/debug-source-breakpoint.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/model/debug-source-breakpoint.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugSourceBreakpoint = exports.DebugSourceBreakpointData = void 0;
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const debug_breakpoint_1 = __webpack_require__(/*! ./debug-breakpoint */ "../../node_modules/@theia/debug/lib/browser/model/debug-breakpoint.js");
class DebugSourceBreakpointData extends debug_breakpoint_1.DebugBreakpointData {
}
exports.DebugSourceBreakpointData = DebugSourceBreakpointData;
class DebugSourceBreakpoint extends debug_breakpoint_1.DebugBreakpoint {
    constructor(origin, options) {
        super(new uri_1.default(origin.uri), options);
        this.setBreakpointEnabled = (event) => {
            this.setEnabled(event.target.checked);
        };
        this.origins = [origin];
    }
    update(data) {
        super.update(data);
    }
    get origin() {
        return this.origins[0];
    }
    setEnabled(enabled) {
        const { uri, raw } = this;
        let shouldUpdate = false;
        let breakpoints = raw && this.doRemove(this.origins.filter(origin => !(origin.raw.line === raw.line && origin.raw.column === raw.column)));
        // Check for breakpoints array with at least one entry
        if (breakpoints && breakpoints.length) {
            shouldUpdate = true;
        }
        else {
            breakpoints = this.breakpoints.getBreakpoints(uri);
        }
        for (const breakpoint of breakpoints) {
            if (breakpoint.raw.line === this.origin.raw.line && breakpoint.raw.column === this.origin.raw.column && breakpoint.enabled !== enabled) {
                breakpoint.enabled = enabled;
                shouldUpdate = true;
            }
        }
        if (shouldUpdate) {
            this.breakpoints.setBreakpoints(this.uri, breakpoints);
        }
    }
    updateOrigins(data) {
        const breakpoints = this.breakpoints.getBreakpoints(this.uri);
        let shouldUpdate = false;
        const originPositions = new Set();
        this.origins.forEach(origin => originPositions.add(origin.raw.line + ':' + origin.raw.column));
        for (const breakpoint of breakpoints) {
            if (originPositions.has(breakpoint.raw.line + ':' + breakpoint.raw.column)) {
                Object.assign(breakpoint.raw, data);
                shouldUpdate = true;
            }
        }
        if (shouldUpdate) {
            this.breakpoints.setBreakpoints(this.uri, breakpoints);
        }
    }
    /** 1-based */
    get line() {
        return this.raw && this.raw.line || this.origins[0].raw.line;
    }
    get column() {
        return this.raw && this.raw.column || this.origins[0].raw.column;
    }
    get endLine() {
        return this.raw && this.raw.endLine;
    }
    get endColumn() {
        return this.raw && this.raw.endColumn;
    }
    get condition() {
        return this.origin.raw.condition;
    }
    get hitCondition() {
        return this.origin.raw.hitCondition;
    }
    get logMessage() {
        return this.origin.raw.logMessage;
    }
    get source() {
        return this.raw && this.raw.source && this.session && this.session.getSource(this.raw.source);
    }
    async open(options = {
        mode: 'reveal'
    }) {
        const { line, column, endLine, endColumn } = this;
        const selection = {
            start: {
                line: line - 1,
                character: typeof column === 'number' ? column - 1 : undefined
            }
        };
        if (typeof endLine === 'number') {
            selection.end = {
                line: endLine - 1,
                character: typeof endColumn === 'number' ? endColumn - 1 : undefined
            };
        }
        if (this.source) {
            return await this.source.open({
                ...options,
                selection
            });
        }
        else {
            return await this.editorManager.open(this.uri, {
                ...options,
                selection
            });
        }
    }
    doRender() {
        return React.createElement(React.Fragment, null,
            React.createElement("span", { className: 'line-info', title: this.labelProvider.getLongName(this.uri) },
                React.createElement("span", { className: 'name' },
                    this.labelProvider.getName(this.uri),
                    " "),
                React.createElement("span", { className: 'path ' + browser_1.TREE_NODE_INFO_CLASS },
                    this.labelProvider.getLongName(this.uri.parent),
                    " ")),
            React.createElement("span", { className: 'line' }, this.renderPosition()));
    }
    renderPosition() {
        return this.line + (typeof this.column === 'number' ? ':' + this.column : '');
    }
    doGetDecoration(messages = []) {
        if (this.logMessage || this.condition || this.hitCondition) {
            const { session } = this;
            if (this.logMessage) {
                if (session && !session.capabilities.supportsLogPoints) {
                    return this.getUnsupportedBreakpointDecoration('Logpoints not supported by this debug type');
                }
                messages.push('Log Message: ' + this.logMessage);
            }
            if (this.condition) {
                if (session && !session.capabilities.supportsConditionalBreakpoints) {
                    return this.getUnsupportedBreakpointDecoration('Conditional breakpoints not supported by this debug type');
                }
                messages.push('Expression: ' + this.condition);
            }
            if (this.hitCondition) {
                if (session && !session.capabilities.supportsHitConditionalBreakpoints) {
                    return this.getUnsupportedBreakpointDecoration('Hit conditional breakpoints not supported by this debug type');
                }
                messages.push('Hit Count: ' + this.hitCondition);
            }
        }
        return super.doGetDecoration(messages);
    }
    getUnsupportedBreakpointDecoration(message) {
        return {
            className: 'codicon-debug-breakpoint-unsupported',
            message: [message]
        };
    }
    getBreakpointDecoration(message) {
        if (this.logMessage) {
            return {
                className: 'codicon-debug-breakpoint-log',
                message: message || ['Logpoint']
            };
        }
        if (this.condition || this.hitCondition) {
            return {
                className: 'codicon-debug-breakpoint-conditional',
                message: message || ['Conditional Breakpoint']
            };
        }
        return {
            className: 'codicon-debug-breakpoint',
            message: message || ['Breakpoint']
        };
    }
    remove() {
        const breakpoints = this.doRemove(this.origins);
        if (breakpoints) {
            this.breakpoints.setBreakpoints(this.uri, breakpoints);
        }
    }
    doRemove(origins) {
        if (!origins.length) {
            return undefined;
        }
        const { uri } = this;
        const toRemove = new Set();
        origins.forEach(origin => toRemove.add(origin.raw.line + ':' + origin.raw.column));
        let shouldUpdate = false;
        const breakpoints = this.breakpoints.findMarkers({
            uri,
            dataFilter: data => {
                const result = !toRemove.has(data.raw.line + ':' + data.raw.column);
                shouldUpdate = shouldUpdate || !result;
                return result;
            }
        }).map(({ data }) => data);
        return shouldUpdate && breakpoints || undefined;
    }
}
exports.DebugSourceBreakpoint = DebugSourceBreakpoint;


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/model/debug-source.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/model/debug-source.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugSource = exports.DebugSourceData = void 0;
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const vscode_uri_1 = __webpack_require__(/*! @theia/core/shared/vscode-uri */ "../../node_modules/@theia/core/shared/vscode-uri/index.js");
const debug_uri_utils_1 = __webpack_require__(/*! ../../common/debug-uri-utils */ "../../node_modules/@theia/debug/lib/common/debug-uri-utils.js");
class DebugSourceData {
}
exports.DebugSourceData = DebugSourceData;
class DebugSource extends DebugSourceData {
    constructor(session, editorManager, labelProvider) {
        super();
        this.session = session;
        this.editorManager = editorManager;
        this.labelProvider = labelProvider;
    }
    get uri() {
        return DebugSource.toUri(this.raw);
    }
    update(data) {
        Object.assign(this, data);
    }
    open(options) {
        return this.editorManager.open(this.uri, options);
    }
    async load() {
        const source = this.raw;
        const sourceReference = source.sourceReference;
        const response = await this.session.sendRequest('source', {
            sourceReference,
            source
        });
        return response.body.content;
    }
    get inMemory() {
        return this.uri.scheme === debug_uri_utils_1.DEBUG_SCHEME;
    }
    get name() {
        if (this.inMemory) {
            return this.raw.name || this.uri.path.base || this.uri.path.fsPath();
        }
        return this.labelProvider.getName(this.uri);
    }
    get longName() {
        if (this.inMemory) {
            return this.name;
        }
        return this.labelProvider.getLongName(this.uri);
    }
    static toUri(raw) {
        if (raw.sourceReference && raw.sourceReference > 0) {
            return new uri_1.default().withScheme(debug_uri_utils_1.DEBUG_SCHEME).withPath(raw.name).withQuery(String(raw.sourceReference));
        }
        if (!raw.path) {
            throw new Error('Unrecognized source type: ' + JSON.stringify(raw));
        }
        if (raw.path.match(debug_uri_utils_1.SCHEME_PATTERN)) {
            return new uri_1.default(raw.path);
        }
        return new uri_1.default(vscode_uri_1.URI.file(raw.path));
    }
}
exports.DebugSource = DebugSource;
DebugSource.SCHEME = debug_uri_utils_1.DEBUG_SCHEME;
DebugSource.SCHEME_PATTERN = debug_uri_utils_1.SCHEME_PATTERN;


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/model/debug-stack-frame.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/model/debug-stack-frame.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugStackFrame = exports.DebugStackFrameData = void 0;
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// Based on https://github.com/theia-ide/vscode/blob/standalone/0.19.x/src/vs/workbench/contrib/debug/common/debugModel.ts
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const browser_2 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const debug_console_items_1 = __webpack_require__(/*! ../console/debug-console-items */ "../../node_modules/@theia/debug/lib/browser/console/debug-console-items.js");
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
class DebugStackFrameData {
}
exports.DebugStackFrameData = DebugStackFrameData;
class DebugStackFrame extends DebugStackFrameData {
    constructor(thread, session) {
        super();
        this.thread = thread;
        this.session = session;
    }
    get id() {
        return this.session.id + ':' + this.thread.id + ':' + this.raw.id;
    }
    /**
     * Returns the frame identifier from the debug protocol.
     */
    get frameId() {
        return this.raw.id;
    }
    get source() {
        return this._source;
    }
    update(data) {
        Object.assign(this, data);
        this._source = this.raw.source && this.session.getSource(this.raw.source);
    }
    async restart() {
        await this.session.sendRequest('restartFrame', this.toArgs({
            threadId: this.thread.id
        }));
    }
    async open(options) {
        if (!this.source) {
            return undefined;
        }
        const { line, column, endLine, endColumn } = this.raw;
        const selection = {
            start: browser_2.Position.create(this.clampPositive(line - 1), this.clampPositive(column - 1))
        };
        if (typeof endLine === 'number') {
            selection.end = {
                line: this.clampPositive(endLine - 1),
                character: typeof endColumn === 'number' ? this.clampPositive(endColumn - 1) : undefined
            };
        }
        this.source.open({
            mode: 'reveal',
            ...options,
            selection
        });
    }
    /**
     * Debugger can send `column: 0` value despite of initializing the debug session with `columnsStartAt1: true`.
     * This method can be used to ensure that neither `column` nor `column` are negative numbers.
     * See https://github.com/microsoft/vscode-mock-debug/issues/85.
     */
    clampPositive(value) {
        return Math.max(value, 0);
    }
    getScopes() {
        return this.scopes || (this.scopes = this.doGetScopes());
    }
    async doGetScopes() {
        let response;
        try {
            response = await this.session.sendRequest('scopes', this.toArgs());
        }
        catch {
            // no-op: ignore debug adapter errors
        }
        if (!response) {
            return [];
        }
        return response.body.scopes.map(raw => new debug_console_items_1.DebugScope(raw, () => this.session));
    }
    // https://github.com/theia-ide/vscode/blob/standalone/0.19.x/src/vs/workbench/contrib/debug/common/debugModel.ts#L324-L335
    async getMostSpecificScopes(range) {
        const scopes = await this.getScopes();
        const nonExpensiveScopes = scopes.filter(s => !s.expensive);
        const haveRangeInfo = nonExpensiveScopes.some(s => !!s.range);
        if (!haveRangeInfo) {
            return nonExpensiveScopes;
        }
        const scopesContainingRange = nonExpensiveScopes.filter(scope => scope.range && monaco.Range.containsRange(scope.range, range))
            .sort((first, second) => (first.range.endLineNumber - first.range.startLineNumber) - (second.range.endLineNumber - second.range.startLineNumber));
        return scopesContainingRange.length ? scopesContainingRange : nonExpensiveScopes;
    }
    toArgs(arg) {
        return Object.assign({}, arg, {
            frameId: this.raw.id
        });
    }
    render() {
        const classNames = ['theia-debug-stack-frame'];
        if (this.raw.presentationHint === 'label') {
            classNames.push('label');
        }
        if (this.raw.presentationHint === 'subtle') {
            classNames.push('subtle');
        }
        if (!this.source || this.source.raw.presentationHint === 'deemphasize') {
            classNames.push(browser_1.DISABLED_CLASS);
        }
        return React.createElement("div", { className: classNames.join(' ') },
            React.createElement("span", { className: 'expression', title: this.raw.name }, this.raw.name),
            this.renderFile());
    }
    renderFile() {
        const { source } = this;
        if (!source) {
            return undefined;
        }
        const origin = source.raw.origin && `\n${source.raw.origin}` || '';
        return React.createElement("span", { className: 'file', title: source.longName + origin },
            React.createElement("span", { className: 'name' }, source.name),
            React.createElement("span", { className: 'line' },
                this.raw.line,
                ":",
                this.raw.column));
    }
    get range() {
        const { source, line: startLine, column: startColumn, endLine, endColumn } = this.raw;
        if (source) {
            return new monaco.Range(startLine, startColumn, endLine || startLine, endColumn || startColumn);
        }
        return undefined;
    }
}
exports.DebugStackFrame = DebugStackFrame;


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/model/debug-thread.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/model/debug-thread.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugThread = exports.DebugThreadData = void 0;
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const debug_stack_frame_1 = __webpack_require__(/*! ./debug-stack-frame */ "../../node_modules/@theia/debug/lib/browser/model/debug-stack-frame.js");
class DebugThreadData {
}
exports.DebugThreadData = DebugThreadData;
class DebugThread extends DebugThreadData {
    get onDidFocusStackFrame() {
        return this.onDidFocusStackFrameEmitter.event;
    }
    constructor(session) {
        super();
        this.session = session;
        this.onDidChangedEmitter = new core_1.Emitter();
        this.onDidChanged = this.onDidChangedEmitter.event;
        this.onDidFocusStackFrameEmitter = new core_1.Emitter();
        this._frames = new Map();
        this.pendingFetch = Promise.resolve([]);
        this._pendingFetchCount = 0;
        this.pendingFetchCancel = new core_1.CancellationTokenSource();
    }
    get id() {
        return this.session.id + ':' + this.raw.id;
    }
    get threadId() {
        return this.raw.id;
    }
    get currentFrame() {
        return this._currentFrame;
    }
    set currentFrame(frame) {
        var _a;
        if (((_a = this._currentFrame) === null || _a === void 0 ? void 0 : _a.id) === (frame === null || frame === void 0 ? void 0 : frame.id)) {
            return;
        }
        this._currentFrame = frame;
        this.onDidChangedEmitter.fire(undefined);
        this.onDidFocusStackFrameEmitter.fire(frame);
    }
    get stopped() {
        return !!this.stoppedDetails;
    }
    update(data) {
        Object.assign(this, data);
        if ('stoppedDetails' in data) {
            this.clearFrames();
        }
    }
    clear() {
        this.update({
            raw: this.raw,
            stoppedDetails: undefined
        });
    }
    continue() {
        return this.session.sendRequest('continue', this.toArgs());
    }
    stepOver() {
        return this.session.sendRequest('next', this.toArgs());
    }
    stepIn() {
        return this.session.sendRequest('stepIn', this.toArgs());
    }
    stepOut() {
        return this.session.sendRequest('stepOut', this.toArgs());
    }
    pause() {
        return this.session.sendRequest('pause', this.toArgs());
    }
    get supportsGoto() {
        return !!this.session.capabilities.supportsGotoTargetsRequest;
    }
    async jumpToCursor(uri, position) {
        var _a;
        const source = await ((_a = this.session) === null || _a === void 0 ? void 0 : _a.toDebugSource(uri));
        if (!source) {
            return undefined;
        }
        const response = await this.session.sendRequest('gotoTargets', { source, line: position.lineNumber, column: position.column });
        if (response && response.body.targets.length === 0) {
            this.session.showMessage(core_1.MessageType.Warning, 'No executable code is associated at the current cursor position.');
            return;
        }
        const targetId = response.body.targets[0].id;
        return this.session.sendRequest('goto', this.toArgs({ targetId }));
    }
    async getExceptionInfo() {
        if (this.stoppedDetails && this.stoppedDetails.reason === 'exception') {
            if (this.session.capabilities.supportsExceptionInfoRequest) {
                const response = await this.session.sendRequest('exceptionInfo', this.toArgs());
                return {
                    id: response.body.exceptionId,
                    description: response.body.description,
                    details: response.body.details
                };
            }
            return {
                description: this.stoppedDetails.text
            };
        }
        return undefined;
    }
    get supportsTerminate() {
        return !!this.session.capabilities.supportsTerminateThreadsRequest;
    }
    async terminate() {
        if (this.supportsTerminate) {
            await this.session.sendRequest('terminateThreads', {
                threadIds: [this.raw.id]
            });
        }
    }
    get frames() {
        return this._frames.values();
    }
    get topFrame() {
        return this.frames.next().value;
    }
    get frameCount() {
        return this._frames.size;
    }
    async fetchFrames(levels = 20) {
        const cancel = this.pendingFetchCancel.token;
        this._pendingFetchCount += 1;
        return this.pendingFetch = this.pendingFetch.then(async () => {
            try {
                const start = this.frameCount;
                const frames = await this.doFetchFrames(start, levels);
                if (cancel.isCancellationRequested) {
                    return [];
                }
                return this.doUpdateFrames(frames);
            }
            catch (e) {
                console.error('fetchFrames failed:', e);
                return [];
            }
            finally {
                if (!cancel.isCancellationRequested) {
                    this._pendingFetchCount -= 1;
                }
            }
        });
    }
    get pendingFrameCount() {
        return this._pendingFetchCount;
    }
    async doFetchFrames(startFrame, levels) {
        try {
            const response = await this.session.sendRequest('stackTrace', this.toArgs({ startFrame, levels }));
            if (this.stoppedDetails) {
                this.stoppedDetails.totalFrames = response.body.totalFrames;
            }
            return response.body.stackFrames;
        }
        catch (e) {
            if (this.stoppedDetails) {
                this.stoppedDetails.framesErrorMessage = e.message;
            }
            return [];
        }
    }
    doUpdateFrames(frames) {
        const result = new Set();
        for (const raw of frames) {
            const id = raw.id;
            const frame = this._frames.get(id) || new debug_stack_frame_1.DebugStackFrame(this, this.session);
            this._frames.set(id, frame);
            frame.update({ raw });
            result.add(frame);
        }
        this.updateCurrentFrame();
        return [...result.values()];
    }
    clearFrames() {
        // Clear all frames
        this._frames.clear();
        // Cancel all request promises
        this.pendingFetchCancel.cancel();
        this.pendingFetchCancel = new core_1.CancellationTokenSource();
        // Empty all current requests
        this.pendingFetch = Promise.resolve([]);
        this._pendingFetchCount = 0;
        this.updateCurrentFrame();
    }
    updateCurrentFrame() {
        const { currentFrame } = this;
        const frameId = currentFrame && currentFrame.raw.id;
        this.currentFrame = typeof frameId === 'number' &&
            this._frames.get(frameId) ||
            this._frames.values().next().value;
    }
    toArgs(arg) {
        return Object.assign({}, arg, {
            threadId: this.raw.id
        });
    }
    render() {
        return (React.createElement("div", { className: "theia-debug-thread", title: core_1.nls.localizeByDefault('Session') },
            React.createElement("span", { className: "label" }, this.raw.name),
            React.createElement("span", { className: "status" }, this.threadStatus())));
    }
    threadStatus() {
        if (!this.stoppedDetails) {
            return core_1.nls.localizeByDefault('Running');
        }
        const description = this.stoppedDetails.description;
        if (description) {
            // According to DAP we must show description as is. Translation is made by debug adapter
            return description;
        }
        const reason = this.stoppedDetails.reason;
        const localizedReason = this.getLocalizedReason(reason);
        return reason
            ? core_1.nls.localizeByDefault('Paused on {0}', localizedReason)
            : core_1.nls.localizeByDefault('Paused');
    }
    getLocalizedReason(reason) {
        switch (reason) {
            case 'step':
                return core_1.nls.localize('theia/debug/step', 'step');
            case 'breakpoint':
                return core_1.nls.localize('theia/debug/breakpoint', 'breakpoint');
            case 'exception':
                return core_1.nls.localize('theia/debug/exception', 'exception');
            case 'pause':
                return core_1.nls.localize('theia/debug/pause', 'pause');
            case 'entry':
                return core_1.nls.localize('theia/debug/entry', 'entry');
            case 'goto':
                return core_1.nls.localize('theia/debug/goto', 'goto');
            case 'function breakpoint':
                return core_1.nls.localize('theia/debug/functionBreakpoint', 'function breakpoint');
            case 'data breakpoint':
                return core_1.nls.localize('theia/debug/dataBreakpoint', 'data breakpoint');
            case 'instruction breakpoint':
                return core_1.nls.localize('theia/debug/instructionBreakpoint', 'instruction breakpoint');
            default:
                return '';
        }
    }
}
exports.DebugThread = DebugThread;


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/view/debug-action.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/view/debug-action.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugAction = void 0;
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
class DebugAction extends React.Component {
    constructor() {
        super(...arguments);
        this.setRef = (ref) => this.ref = ref || undefined;
    }
    render() {
        const { enabled, label, iconClass } = this.props;
        const classNames = ['debug-action'];
        if (iconClass) {
            classNames.push(...(0, browser_1.codiconArray)(iconClass, true));
        }
        if (enabled === false) {
            classNames.push(browser_1.DISABLED_CLASS);
        }
        return React.createElement("span", { tabIndex: 0, className: classNames.join(' '), title: label, onClick: this.props.run, ref: this.setRef }, !iconClass && React.createElement("div", null, label));
    }
    focus() {
        if (this.ref) {
            this.ref.focus();
        }
    }
}
exports.DebugAction = DebugAction;


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/view/debug-breakpoints-source.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/view/debug-breakpoints-source.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugBreakpointsSource = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const source_tree_1 = __webpack_require__(/*! @theia/core/lib/browser/source-tree */ "../../node_modules/@theia/core/lib/browser/source-tree/index.js");
const debug_view_model_1 = __webpack_require__(/*! ./debug-view-model */ "../../node_modules/@theia/debug/lib/browser/view/debug-view-model.js");
const breakpoint_manager_1 = __webpack_require__(/*! ../breakpoint/breakpoint-manager */ "../../node_modules/@theia/debug/lib/browser/breakpoint/breakpoint-manager.js");
const debug_exception_breakpoint_1 = __webpack_require__(/*! ./debug-exception-breakpoint */ "../../node_modules/@theia/debug/lib/browser/view/debug-exception-breakpoint.js");
let DebugBreakpointsSource = class DebugBreakpointsSource extends source_tree_1.TreeSource {
    init() {
        this.fireDidChange();
        this.toDispose.push(this.model.onDidChangeBreakpoints(() => this.fireDidChange()));
    }
    *getElements() {
        for (const exceptionBreakpoint of this.breakpoints.getExceptionBreakpoints()) {
            yield new debug_exception_breakpoint_1.DebugExceptionBreakpoint(exceptionBreakpoint, this.breakpoints);
        }
        for (const functionBreakpoint of this.model.functionBreakpoints) {
            yield functionBreakpoint;
        }
        for (const instructionBreakpoint of this.model.instructionBreakpoints) {
            yield instructionBreakpoint;
        }
        for (const breakpoint of this.model.breakpoints) {
            yield breakpoint;
        }
    }
};
exports.DebugBreakpointsSource = DebugBreakpointsSource;
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_view_model_1.DebugViewModel),
    tslib_1.__metadata("design:type", debug_view_model_1.DebugViewModel)
], DebugBreakpointsSource.prototype, "model", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(breakpoint_manager_1.BreakpointManager),
    tslib_1.__metadata("design:type", breakpoint_manager_1.BreakpointManager)
], DebugBreakpointsSource.prototype, "breakpoints", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugBreakpointsSource.prototype, "init", null);
exports.DebugBreakpointsSource = DebugBreakpointsSource = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugBreakpointsSource);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/view/debug-breakpoints-widget.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/view/debug-breakpoints-widget.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var DebugBreakpointsWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugBreakpointsWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const source_tree_1 = __webpack_require__(/*! @theia/core/lib/browser/source-tree */ "../../node_modules/@theia/core/lib/browser/source-tree/index.js");
const debug_breakpoints_source_1 = __webpack_require__(/*! ./debug-breakpoints-source */ "../../node_modules/@theia/debug/lib/browser/view/debug-breakpoints-source.js");
const breakpoint_manager_1 = __webpack_require__(/*! ../breakpoint/breakpoint-manager */ "../../node_modules/@theia/debug/lib/browser/breakpoint/breakpoint-manager.js");
const debug_view_model_1 = __webpack_require__(/*! ./debug-view-model */ "../../node_modules/@theia/debug/lib/browser/view/debug-view-model.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
let DebugBreakpointsWidget = DebugBreakpointsWidget_1 = class DebugBreakpointsWidget extends source_tree_1.SourceTreeWidget {
    static createContainer(parent) {
        const child = source_tree_1.SourceTreeWidget.createContainer(parent, {
            contextMenuPath: DebugBreakpointsWidget_1.CONTEXT_MENU,
            virtualized: false,
            scrollIfActive: true
        });
        child.bind(debug_breakpoints_source_1.DebugBreakpointsSource).toSelf();
        child.unbind(source_tree_1.SourceTreeWidget);
        child.bind(DebugBreakpointsWidget_1).toSelf();
        return child;
    }
    static createWidget(parent) {
        return DebugBreakpointsWidget_1.createContainer(parent).get(DebugBreakpointsWidget_1);
    }
    init() {
        super.init();
        this.id = DebugBreakpointsWidget_1.FACTORY_ID + ':' + this.viewModel.id;
        this.title.label = nls_1.nls.localizeByDefault('Breakpoints');
        this.toDispose.push(this.breakpointsSource);
        this.source = this.breakpointsSource;
    }
    getDefaultNodeStyle(node, props) {
        return undefined;
    }
};
exports.DebugBreakpointsWidget = DebugBreakpointsWidget;
DebugBreakpointsWidget.CONTEXT_MENU = ['debug-breakpoints-context-menu'];
DebugBreakpointsWidget.EDIT_MENU = [...DebugBreakpointsWidget_1.CONTEXT_MENU, 'a_edit'];
DebugBreakpointsWidget.REMOVE_MENU = [...DebugBreakpointsWidget_1.CONTEXT_MENU, 'b_remove'];
DebugBreakpointsWidget.ENABLE_MENU = [...DebugBreakpointsWidget_1.CONTEXT_MENU, 'c_enable'];
DebugBreakpointsWidget.FACTORY_ID = 'debug:breakpoints';
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_view_model_1.DebugViewModel),
    tslib_1.__metadata("design:type", debug_view_model_1.DebugViewModel)
], DebugBreakpointsWidget.prototype, "viewModel", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(breakpoint_manager_1.BreakpointManager),
    tslib_1.__metadata("design:type", breakpoint_manager_1.BreakpointManager)
], DebugBreakpointsWidget.prototype, "breakpoints", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_breakpoints_source_1.DebugBreakpointsSource),
    tslib_1.__metadata("design:type", debug_breakpoints_source_1.DebugBreakpointsSource)
], DebugBreakpointsWidget.prototype, "breakpointsSource", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugBreakpointsWidget.prototype, "init", null);
exports.DebugBreakpointsWidget = DebugBreakpointsWidget = DebugBreakpointsWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugBreakpointsWidget);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/view/debug-configuration-select.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/view/debug-configuration-select.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugConfigurationSelect = void 0;
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const debug_session_options_1 = __webpack_require__(/*! ../debug-session-options */ "../../node_modules/@theia/debug/lib/browser/debug-session-options.js");
const select_component_1 = __webpack_require__(/*! @theia/core/lib/browser/widgets/select-component */ "../../node_modules/@theia/core/lib/browser/widgets/select-component.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
class DebugConfigurationSelect extends React.Component {
    constructor(props) {
        super(props);
        this.selectRef = React.createRef();
        this.setCurrentConfiguration = (option) => {
            const value = option.value;
            if (!value) {
                return false;
            }
            else if (value === DebugConfigurationSelect.ADD_CONFIGURATION) {
                setTimeout(() => this.manager.addConfiguration());
            }
            else if (value.startsWith(DebugConfigurationSelect.PICK)) {
                const providerType = this.parsePickValue(value);
                this.selectDynamicConfigFromQuickPick(providerType);
            }
            else {
                const data = JSON.parse(value);
                this.manager.current = data;
                this.refreshDebugConfigurations();
            }
        };
        this.refreshDebugConfigurations = async () => {
            const configsOptionsPerType = await this.manager.provideDynamicDebugConfigurations();
            const providerTypes = [];
            for (const [type, configurationsOptions] of Object.entries(configsOptionsPerType)) {
                if (configurationsOptions.length > 0) {
                    providerTypes.push(type);
                }
            }
            const value = this.currentValue;
            this.selectRef.current.value = value;
            this.setState({ providerTypes, currentValue: value });
        };
        this.manager = props.manager;
        this.quickInputService = props.quickInputService;
        this.state = {
            providerTypes: [],
            currentValue: undefined
        };
        this.manager.onDidChangeConfigurationProviders(() => {
            this.refreshDebugConfigurations();
        });
    }
    componentDidUpdate() {
        var _a;
        // synchronize the currentValue with the selectComponent value
        if (((_a = this.selectRef.current) === null || _a === void 0 ? void 0 : _a.value) !== this.currentValue) {
            this.refreshDebugConfigurations();
        }
    }
    componentDidMount() {
        this.refreshDebugConfigurations();
    }
    render() {
        return React.createElement(select_component_1.SelectComponent, { options: this.renderOptions(), defaultValue: this.state.currentValue, onChange: option => this.setCurrentConfiguration(option), onFocus: () => this.refreshDebugConfigurations(), onBlur: () => this.refreshDebugConfigurations(), ref: this.selectRef });
    }
    get currentValue() {
        const { current } = this.manager;
        const matchingOption = this.getCurrentOption(current);
        return matchingOption ? matchingOption.value : current ? JSON.stringify(current) : DebugConfigurationSelect.NO_CONFIGURATION;
    }
    getCurrentOption(current) {
        if (!current || !this.selectRef.current) {
            return;
        }
        const matchingOption = this.selectRef.current.options.find(option => option.userData === DebugConfigurationSelect.CONFIG_MARKER
            && this.matchesOption(JSON.parse(option.value), current));
        return matchingOption;
    }
    matchesOption(sessionOption, current) {
        const matchesNameAndWorkspace = sessionOption.name === current.name && sessionOption.workspaceFolderUri === current.workspaceFolderUri;
        return debug_session_options_1.DebugSessionOptions.isConfiguration(sessionOption) && debug_session_options_1.DebugSessionOptions.isConfiguration(current)
            ? matchesNameAndWorkspace && sessionOption.providerType === current.providerType
            : matchesNameAndWorkspace;
    }
    toPickValue(providerType) {
        return DebugConfigurationSelect.PICK + providerType;
    }
    parsePickValue(value) {
        return value.slice(DebugConfigurationSelect.PICK.length);
    }
    async resolveDynamicConfigurationPicks(providerType) {
        const configurationsOfProviderType = (await this.manager.provideDynamicDebugConfigurations())[providerType];
        if (!configurationsOfProviderType) {
            return [];
        }
        return configurationsOfProviderType.map(options => ({
            label: options.configuration.name,
            configurationType: options.configuration.type,
            request: options.configuration.request,
            providerType: options.providerType,
            description: this.toBaseName(options.workspaceFolderUri),
            workspaceFolderUri: options.workspaceFolderUri
        }));
    }
    async selectDynamicConfigFromQuickPick(providerType) {
        const picks = await this.resolveDynamicConfigurationPicks(providerType);
        if (picks.length === 0) {
            return;
        }
        const selected = await this.quickInputService.showQuickPick(picks, {
            placeholder: nls_1.nls.localizeByDefault('Select Launch Configuration')
        });
        if (!selected) {
            return;
        }
        const selectedConfiguration = {
            name: selected.label,
            type: selected.configurationType,
            request: selected.request
        };
        this.manager.current = this.manager.find(selectedConfiguration, selected.workspaceFolderUri, selected.providerType);
        this.refreshDebugConfigurations();
    }
    renderOptions() {
        const options = [];
        // Add non dynamic debug configurations
        for (const config of this.manager.all) {
            const value = JSON.stringify(config);
            options.push({
                value,
                label: this.toName(config, this.props.isMultiRoot),
                userData: DebugConfigurationSelect.CONFIG_MARKER
            });
        }
        // Add recently used dynamic debug configurations
        const { recentDynamicOptions } = this.manager;
        if (recentDynamicOptions.length > 0) {
            if (options.length > 0) {
                options.push({
                    separator: true
                });
            }
            for (const dynamicOption of recentDynamicOptions) {
                const value = JSON.stringify(dynamicOption);
                options.push({
                    value,
                    label: this.toName(dynamicOption, this.props.isMultiRoot) + ' (' + dynamicOption.providerType + ')',
                    userData: DebugConfigurationSelect.CONFIG_MARKER
                });
            }
        }
        // Placing a 'No Configuration' entry enables proper functioning of the 'onChange' event, by
        // having an entry to switch from (E.g. a case where only one dynamic configuration type is available)
        if (options.length === 0) {
            const value = DebugConfigurationSelect.NO_CONFIGURATION;
            options.push({
                value,
                label: nls_1.nls.localizeByDefault('No Configurations')
            });
        }
        // Add dynamic configuration types for quick pick selection
        const types = this.state.providerTypes;
        if (types.length > 0) {
            options.push({
                separator: true
            });
            for (const type of types) {
                const value = this.toPickValue(type);
                options.push({
                    value,
                    label: type + '...'
                });
            }
        }
        options.push({
            separator: true
        });
        options.push({
            value: DebugConfigurationSelect.ADD_CONFIGURATION,
            label: nls_1.nls.localizeByDefault('Add Configuration...')
        });
        return options;
    }
    toName(options, multiRoot) {
        return this.props.labelProvider.getLabel(options, multiRoot);
    }
    toBaseName(uri) {
        return uri ? new uri_1.default(uri).path.base : '';
    }
}
exports.DebugConfigurationSelect = DebugConfigurationSelect;
DebugConfigurationSelect.SEPARATOR = '──────────';
DebugConfigurationSelect.PICK = '__PICK__';
DebugConfigurationSelect.NO_CONFIGURATION = '__NO_CONF__';
DebugConfigurationSelect.ADD_CONFIGURATION = '__ADD_CONF__';
DebugConfigurationSelect.CONFIG_MARKER = '__CONFIG__';


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/view/debug-configuration-widget.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/view/debug-configuration-widget.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugConfigurationWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const browser_2 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const debug_console_contribution_1 = __webpack_require__(/*! ../console/debug-console-contribution */ "../../node_modules/@theia/debug/lib/browser/console/debug-console-contribution.js");
const debug_configuration_manager_1 = __webpack_require__(/*! ../debug-configuration-manager */ "../../node_modules/@theia/debug/lib/browser/debug-configuration-manager.js");
const debug_frontend_application_contribution_1 = __webpack_require__(/*! ../debug-frontend-application-contribution */ "../../node_modules/@theia/debug/lib/browser/debug-frontend-application-contribution.js");
const debug_session_manager_1 = __webpack_require__(/*! ../debug-session-manager */ "../../node_modules/@theia/debug/lib/browser/debug-session-manager.js");
const debug_action_1 = __webpack_require__(/*! ./debug-action */ "../../node_modules/@theia/debug/lib/browser/view/debug-action.js");
const debug_configuration_select_1 = __webpack_require__(/*! ./debug-configuration-select */ "../../node_modules/@theia/debug/lib/browser/view/debug-configuration-select.js");
const debug_view_model_1 = __webpack_require__(/*! ./debug-view-model */ "../../node_modules/@theia/debug/lib/browser/view/debug-view-model.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const debug_session_options_1 = __webpack_require__(/*! ../debug-session-options */ "../../node_modules/@theia/debug/lib/browser/debug-session-options.js");
const debug_session_configuration_label_provider_1 = __webpack_require__(/*! ../debug-session-configuration-label-provider */ "../../node_modules/@theia/debug/lib/browser/debug-session-configuration-label-provider.js");
let DebugConfigurationWidget = class DebugConfigurationWidget extends browser_1.ReactWidget {
    constructor() {
        super(...arguments);
        this.onRender = new common_1.DisposableCollection();
        this.setStepRef = (stepRef) => {
            this.stepRef = stepRef || undefined;
            this.onRender.dispose();
        };
        this.start = async () => {
            let configuration;
            try {
                configuration = await this.manager.getSelectedConfiguration();
            }
            catch (e) {
                this.messageService.error(e.message);
                return;
            }
            if (debug_session_options_1.DebugSessionOptions.isConfiguration(configuration)) {
                configuration.startedByUser = true;
            }
            this.commandRegistry.executeCommand(debug_frontend_application_contribution_1.DebugCommands.START.id, configuration);
        };
        this.openConfiguration = () => this.manager.openConfiguration();
        this.openConsole = () => this.debugConsole.openView({
            activate: true
        });
    }
    init() {
        this.addClass('debug-toolbar');
        this.toDispose.push(this.manager.onDidChange(() => this.update()));
        this.toDispose.push(this.workspaceService.onWorkspaceChanged(() => this.update()));
        this.toDispose.push(this.workspaceService.onWorkspaceLocationChanged(() => this.update()));
        this.scrollOptions = undefined;
        this.update();
    }
    focus() {
        if (!this.doFocus()) {
            this.onRender.push(common_1.Disposable.create(() => this.doFocus()));
            this.update();
        }
    }
    doFocus() {
        if (!this.stepRef) {
            return false;
        }
        this.stepRef.focus();
        return true;
    }
    render() {
        return React.createElement(React.Fragment, null,
            React.createElement(debug_action_1.DebugAction, { run: this.start, label: nls_1.nls.localizeByDefault('Start Debugging'), iconClass: 'debug-start', ref: this.setStepRef }),
            React.createElement(debug_configuration_select_1.DebugConfigurationSelect, { manager: this.manager, quickInputService: this.quickInputService, isMultiRoot: this.workspaceService.isMultiRootWorkspaceOpened, labelProvider: this.sessionConfigurationLabelProvider }),
            React.createElement(debug_action_1.DebugAction, { run: this.openConfiguration, label: nls_1.nls.localizeByDefault('Open {0}', '"launch.json"'), iconClass: 'settings-gear' }),
            React.createElement(debug_action_1.DebugAction, { run: this.openConsole, label: nls_1.nls.localizeByDefault('Debug Console'), iconClass: 'terminal' }));
    }
};
exports.DebugConfigurationWidget = DebugConfigurationWidget;
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.CommandRegistry),
    tslib_1.__metadata("design:type", common_1.CommandRegistry)
], DebugConfigurationWidget.prototype, "commandRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_view_model_1.DebugViewModel),
    tslib_1.__metadata("design:type", debug_view_model_1.DebugViewModel)
], DebugConfigurationWidget.prototype, "viewModel", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_configuration_manager_1.DebugConfigurationManager),
    tslib_1.__metadata("design:type", debug_configuration_manager_1.DebugConfigurationManager)
], DebugConfigurationWidget.prototype, "manager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_session_manager_1.DebugSessionManager),
    tslib_1.__metadata("design:type", debug_session_manager_1.DebugSessionManager)
], DebugConfigurationWidget.prototype, "sessionManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_console_contribution_1.DebugConsoleContribution),
    tslib_1.__metadata("design:type", debug_console_contribution_1.DebugConsoleContribution)
], DebugConfigurationWidget.prototype, "debugConsole", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.QuickInputService),
    tslib_1.__metadata("design:type", Object)
], DebugConfigurationWidget.prototype, "quickInputService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.WorkspaceService),
    tslib_1.__metadata("design:type", browser_2.WorkspaceService)
], DebugConfigurationWidget.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.MessageService),
    tslib_1.__metadata("design:type", common_1.MessageService)
], DebugConfigurationWidget.prototype, "messageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_session_configuration_label_provider_1.DebugSessionConfigurationLabelProvider),
    tslib_1.__metadata("design:type", debug_session_configuration_label_provider_1.DebugSessionConfigurationLabelProvider)
], DebugConfigurationWidget.prototype, "sessionConfigurationLabelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugConfigurationWidget.prototype, "init", null);
exports.DebugConfigurationWidget = DebugConfigurationWidget = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugConfigurationWidget);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/view/debug-exception-breakpoint.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/view/debug-exception-breakpoint.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugExceptionBreakpoint = void 0;
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const dialogs_1 = __webpack_require__(/*! @theia/core/lib/browser/dialogs */ "../../node_modules/@theia/core/lib/browser/dialogs.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
class DebugExceptionBreakpoint {
    constructor(data, breakpoints) {
        this.data = data;
        this.breakpoints = breakpoints;
        this.toggle = () => this.breakpoints.toggleExceptionBreakpoint(this.data.raw.filter);
        this.id = data.raw.filter + ':' + data.raw.label;
    }
    render() {
        return React.createElement("div", { title: this.data.raw.description || this.data.raw.label, className: 'theia-source-breakpoint' },
            React.createElement("span", { className: 'theia-debug-breakpoint-icon' }),
            React.createElement("input", { type: 'checkbox', checked: this.data.enabled, onChange: this.toggle }),
            React.createElement("span", { className: 'line-info' },
                React.createElement("span", { className: 'name' },
                    this.data.raw.label,
                    " "),
                this.data.condition &&
                    React.createElement("span", { title: core_1.nls.localizeByDefault('Expression condition: {0}', this.data.condition), className: 'path ' + browser_1.TREE_NODE_INFO_CLASS },
                        this.data.condition,
                        " ")));
    }
    async editCondition() {
        const inputDialog = new dialogs_1.SingleTextInputDialog({
            title: this.data.raw.label,
            placeholder: this.data.raw.conditionDescription,
            initialValue: this.data.condition
        });
        let condition = await inputDialog.open();
        if (condition === undefined) {
            return;
        }
        if (condition === '') {
            condition = undefined;
        }
        if (condition !== this.data.condition) {
            this.breakpoints.updateExceptionBreakpoint(this.data.raw.filter, { condition });
        }
    }
}
exports.DebugExceptionBreakpoint = DebugExceptionBreakpoint;


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/view/debug-session-widget.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/view/debug-session-widget.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var DebugSessionWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugSessionWidget = exports.DEBUG_VIEW_CONTAINER_TITLE_OPTIONS = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const debug_threads_widget_1 = __webpack_require__(/*! ./debug-threads-widget */ "../../node_modules/@theia/debug/lib/browser/view/debug-threads-widget.js");
const debug_stack_frames_widget_1 = __webpack_require__(/*! ./debug-stack-frames-widget */ "../../node_modules/@theia/debug/lib/browser/view/debug-stack-frames-widget.js");
const debug_breakpoints_widget_1 = __webpack_require__(/*! ./debug-breakpoints-widget */ "../../node_modules/@theia/debug/lib/browser/view/debug-breakpoints-widget.js");
const debug_variables_widget_1 = __webpack_require__(/*! ./debug-variables-widget */ "../../node_modules/@theia/debug/lib/browser/view/debug-variables-widget.js");
const debug_toolbar_widget_1 = __webpack_require__(/*! ./debug-toolbar-widget */ "../../node_modules/@theia/debug/lib/browser/view/debug-toolbar-widget.js");
const debug_view_model_1 = __webpack_require__(/*! ./debug-view-model */ "../../node_modules/@theia/debug/lib/browser/view/debug-view-model.js");
const debug_watch_widget_1 = __webpack_require__(/*! ./debug-watch-widget */ "../../node_modules/@theia/debug/lib/browser/view/debug-watch-widget.js");
const frontend_application_state_1 = __webpack_require__(/*! @theia/core/lib/browser/frontend-application-state */ "../../node_modules/@theia/core/lib/browser/frontend-application-state.js");
exports.DEBUG_VIEW_CONTAINER_TITLE_OPTIONS = {
    label: 'debug',
    iconClass: (0, browser_1.codicon)('debug-alt'),
    closeable: true
};
let DebugSessionWidget = DebugSessionWidget_1 = class DebugSessionWidget extends browser_1.BaseWidget {
    static createContainer(parent) {
        const child = new inversify_1.Container({ defaultScope: 'Singleton' });
        child.parent = parent;
        child.bind(debug_view_model_1.DebugViewModel).toSelf();
        child.bind(debug_toolbar_widget_1.DebugToolBar).toSelf();
        child.bind(DebugSessionWidget_1).toSelf();
        return child;
    }
    static createWidget(parent) {
        return DebugSessionWidget_1.createContainer(parent).get(DebugSessionWidget_1);
    }
    init() {
        this.id = 'debug:session:' + this.model.id;
        this.title.label = this.model.label;
        this.title.caption = this.model.label;
        this.title.closable = true;
        this.title.iconClass = (0, browser_1.codicon)('debug-alt');
        this.addClass('theia-session-container');
        this.viewContainer = this.viewContainerFactory({
            id: 'debug:view-container:' + this.model.id
        });
        this.viewContainer.setTitleOptions(exports.DEBUG_VIEW_CONTAINER_TITLE_OPTIONS);
        this.stateService.reachedState('initialized_layout').then(() => {
            for (const subwidget of DebugSessionWidget_1.subwidgets) {
                const widgetPromises = [];
                const existingWidget = this.widgetManager.tryGetPendingWidget(subwidget.FACTORY_ID);
                // No other view container instantiated this widget during startup.
                if (!existingWidget) {
                    widgetPromises.push(this.widgetManager.getOrCreateWidget(subwidget.FACTORY_ID));
                }
                Promise.all(widgetPromises).then(widgets => widgets.forEach(widget => this.viewContainer.addWidget(widget)));
            }
        });
        this.toDispose.pushAll([
            this.toolbar,
            this.viewContainer
        ]);
        const layout = this.layout = new browser_1.PanelLayout();
        layout.addWidget(this.toolbar);
        layout.addWidget(this.viewContainer);
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        this.toolbar.focus();
    }
    onAfterShow(msg) {
        super.onAfterShow(msg);
        this.getTrackableWidgets().forEach(w => w.update());
    }
    getTrackableWidgets() {
        return [this.viewContainer];
    }
    storeState() {
        return this.viewContainer.storeState();
    }
    restoreState(oldState) {
        this.viewContainer.restoreState(oldState);
    }
};
exports.DebugSessionWidget = DebugSessionWidget;
DebugSessionWidget.subwidgets = [debug_threads_widget_1.DebugThreadsWidget, debug_stack_frames_widget_1.DebugStackFramesWidget, debug_variables_widget_1.DebugVariablesWidget, debug_watch_widget_1.DebugWatchWidget, debug_breakpoints_widget_1.DebugBreakpointsWidget];
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ViewContainer.Factory),
    tslib_1.__metadata("design:type", Function)
], DebugSessionWidget.prototype, "viewContainerFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_view_model_1.DebugViewModel),
    tslib_1.__metadata("design:type", debug_view_model_1.DebugViewModel)
], DebugSessionWidget.prototype, "model", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_toolbar_widget_1.DebugToolBar),
    tslib_1.__metadata("design:type", debug_toolbar_widget_1.DebugToolBar)
], DebugSessionWidget.prototype, "toolbar", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.WidgetManager),
    tslib_1.__metadata("design:type", browser_1.WidgetManager)
], DebugSessionWidget.prototype, "widgetManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(frontend_application_state_1.FrontendApplicationStateService),
    tslib_1.__metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], DebugSessionWidget.prototype, "stateService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugSessionWidget.prototype, "init", null);
exports.DebugSessionWidget = DebugSessionWidget = DebugSessionWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugSessionWidget);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/view/debug-stack-frames-source.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/view/debug-stack-frames-source.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LoadMoreStackFrames = exports.DebugStackFramesSource = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const source_tree_1 = __webpack_require__(/*! @theia/core/lib/browser/source-tree */ "../../node_modules/@theia/core/lib/browser/source-tree/index.js");
const debug_view_model_1 = __webpack_require__(/*! ./debug-view-model */ "../../node_modules/@theia/debug/lib/browser/view/debug-view-model.js");
const debounce = __webpack_require__(/*! p-debounce */ "../../node_modules/p-debounce/index.js");
let DebugStackFramesSource = class DebugStackFramesSource extends source_tree_1.TreeSource {
    constructor() {
        super(...arguments);
        this.refresh = debounce(() => this.fireDidChange(), 100);
    }
    init() {
        this.refresh();
        this.toDispose.push(this.model.onDidChange(() => this.refresh()));
    }
    *getElements() {
        const thread = this.model.currentThread;
        if (!thread) {
            return;
        }
        yield* thread.frames;
        if (thread.stoppedDetails) {
            const { framesErrorMessage, totalFrames } = thread.stoppedDetails;
            if (framesErrorMessage) {
                yield {
                    render: () => React.createElement("span", { title: framesErrorMessage }, framesErrorMessage)
                };
            }
            if (totalFrames && totalFrames > thread.frameCount) {
                yield new LoadMoreStackFrames(thread);
            }
        }
    }
};
exports.DebugStackFramesSource = DebugStackFramesSource;
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_view_model_1.DebugViewModel),
    tslib_1.__metadata("design:type", debug_view_model_1.DebugViewModel)
], DebugStackFramesSource.prototype, "model", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugStackFramesSource.prototype, "init", null);
exports.DebugStackFramesSource = DebugStackFramesSource = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugStackFramesSource);
class LoadMoreStackFrames {
    constructor(thread) {
        this.thread = thread;
    }
    render() {
        return React.createElement("span", { className: 'theia-load-more-frames' }, "Load More Stack Frames");
    }
    async open() {
        const frames = await this.thread.fetchFrames();
        if (frames[0]) {
            this.thread.currentFrame = frames[0];
        }
    }
}
exports.LoadMoreStackFrames = LoadMoreStackFrames;


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/view/debug-stack-frames-widget.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/view/debug-stack-frames-widget.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var DebugStackFramesWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugStackFramesWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const source_tree_1 = __webpack_require__(/*! @theia/core/lib/browser/source-tree */ "../../node_modules/@theia/core/lib/browser/source-tree/index.js");
const debug_stack_frames_source_1 = __webpack_require__(/*! ./debug-stack-frames-source */ "../../node_modules/@theia/debug/lib/browser/view/debug-stack-frames-source.js");
const debug_stack_frame_1 = __webpack_require__(/*! ../model/debug-stack-frame */ "../../node_modules/@theia/debug/lib/browser/model/debug-stack-frame.js");
const debug_view_model_1 = __webpack_require__(/*! ./debug-view-model */ "../../node_modules/@theia/debug/lib/browser/view/debug-view-model.js");
const debug_call_stack_item_type_key_1 = __webpack_require__(/*! ../debug-call-stack-item-type-key */ "../../node_modules/@theia/debug/lib/browser/debug-call-stack-item-type-key.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
let DebugStackFramesWidget = DebugStackFramesWidget_1 = class DebugStackFramesWidget extends source_tree_1.SourceTreeWidget {
    constructor() {
        super(...arguments);
        this.updatingSelection = false;
    }
    static createContainer(parent) {
        const child = source_tree_1.SourceTreeWidget.createContainer(parent, {
            contextMenuPath: DebugStackFramesWidget_1.CONTEXT_MENU,
            virtualized: false,
            scrollIfActive: true
        });
        child.bind(debug_stack_frames_source_1.DebugStackFramesSource).toSelf();
        child.unbind(source_tree_1.SourceTreeWidget);
        child.bind(DebugStackFramesWidget_1).toSelf();
        return child;
    }
    static createWidget(parent) {
        return DebugStackFramesWidget_1.createContainer(parent).get(DebugStackFramesWidget_1);
    }
    init() {
        super.init();
        this.id = DebugStackFramesWidget_1.FACTORY_ID + ':' + this.viewModel.id;
        this.title.label = nls_1.nls.localizeByDefault('Call Stack');
        this.toDispose.push(this.frames);
        this.source = this.frames;
        this.toDispose.push(this.viewModel.onDidChange(() => this.updateWidgetSelection()));
        this.toDispose.push(this.model.onNodeRefreshed(() => this.updateWidgetSelection()));
        this.toDispose.push(this.model.onSelectionChanged(() => this.updateModelSelection()));
    }
    async updateWidgetSelection() {
        if (this.updatingSelection) {
            return;
        }
        this.updatingSelection = true;
        try {
            const { currentFrame } = this.viewModel;
            if (currentFrame) {
                const node = this.model.getNode(currentFrame.id);
                if (browser_1.SelectableTreeNode.is(node)) {
                    this.model.selectNode(node);
                }
            }
        }
        finally {
            this.updatingSelection = false;
        }
    }
    async updateModelSelection() {
        if (this.updatingSelection) {
            return;
        }
        this.updatingSelection = true;
        try {
            const node = this.model.selectedNodes[0];
            if (source_tree_1.TreeElementNode.is(node)) {
                if (node.element instanceof debug_stack_frame_1.DebugStackFrame) {
                    node.element.thread.currentFrame = node.element;
                    this.debugCallStackItemTypeKey.set('stackFrame');
                }
            }
        }
        finally {
            this.updatingSelection = false;
        }
    }
    toContextMenuArgs(node) {
        if (source_tree_1.TreeElementNode.is(node)) {
            if (node.element instanceof debug_stack_frame_1.DebugStackFrame) {
                const source = node.element.source;
                if (source) {
                    if (source.inMemory) {
                        const path = source.raw.path || source.raw.sourceReference;
                        if (path !== undefined) {
                            return [path];
                        }
                    }
                    else {
                        return [source.uri.toString()];
                    }
                }
            }
        }
        return undefined;
    }
    tapNode(node) {
        if (source_tree_1.TreeElementNode.is(node) && node.element instanceof debug_stack_frames_source_1.LoadMoreStackFrames) {
            node.element.open();
        }
        super.tapNode(node);
    }
    getDefaultNodeStyle(node, props) {
        return undefined;
    }
};
exports.DebugStackFramesWidget = DebugStackFramesWidget;
DebugStackFramesWidget.CONTEXT_MENU = ['debug-frames-context-menu'];
DebugStackFramesWidget.FACTORY_ID = 'debug:frames';
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_stack_frames_source_1.DebugStackFramesSource),
    tslib_1.__metadata("design:type", debug_stack_frames_source_1.DebugStackFramesSource)
], DebugStackFramesWidget.prototype, "frames", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_view_model_1.DebugViewModel),
    tslib_1.__metadata("design:type", debug_view_model_1.DebugViewModel)
], DebugStackFramesWidget.prototype, "viewModel", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_call_stack_item_type_key_1.DebugCallStackItemTypeKey),
    tslib_1.__metadata("design:type", Object)
], DebugStackFramesWidget.prototype, "debugCallStackItemTypeKey", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugStackFramesWidget.prototype, "init", null);
exports.DebugStackFramesWidget = DebugStackFramesWidget = DebugStackFramesWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugStackFramesWidget);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/view/debug-threads-source.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/view/debug-threads-source.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugThreadsSource = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const source_tree_1 = __webpack_require__(/*! @theia/core/lib/browser/source-tree */ "../../node_modules/@theia/core/lib/browser/source-tree/index.js");
const debug_view_model_1 = __webpack_require__(/*! ./debug-view-model */ "../../node_modules/@theia/debug/lib/browser/view/debug-view-model.js");
let DebugThreadsSource = class DebugThreadsSource extends source_tree_1.TreeSource {
    init() {
        this.fireDidChange();
        this.toDispose.push(this.model.onDidChange(() => this.fireDidChange()));
    }
    get multiSession() {
        return this.model.sessionCount > 1;
    }
    *getElements() {
        if (this.model.sessionCount === 1 && this.model.session && this.model.session.threadCount) {
            return yield* this.model.session.threads;
        }
        for (const session of this.model.sessions) {
            if (!session.parentSession) {
                yield session;
            }
        }
    }
};
exports.DebugThreadsSource = DebugThreadsSource;
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_view_model_1.DebugViewModel),
    tslib_1.__metadata("design:type", debug_view_model_1.DebugViewModel)
], DebugThreadsSource.prototype, "model", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugThreadsSource.prototype, "init", null);
exports.DebugThreadsSource = DebugThreadsSource = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugThreadsSource);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/view/debug-threads-widget.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/view/debug-threads-widget.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var DebugThreadsWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugThreadsWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const source_tree_1 = __webpack_require__(/*! @theia/core/lib/browser/source-tree */ "../../node_modules/@theia/core/lib/browser/source-tree/index.js");
const debug_threads_source_1 = __webpack_require__(/*! ./debug-threads-source */ "../../node_modules/@theia/debug/lib/browser/view/debug-threads-source.js");
const debug_session_1 = __webpack_require__(/*! ../debug-session */ "../../node_modules/@theia/debug/lib/browser/debug-session.js");
const debug_thread_1 = __webpack_require__(/*! ../model/debug-thread */ "../../node_modules/@theia/debug/lib/browser/model/debug-thread.js");
const debug_view_model_1 = __webpack_require__(/*! ../view/debug-view-model */ "../../node_modules/@theia/debug/lib/browser/view/debug-view-model.js");
const debug_call_stack_item_type_key_1 = __webpack_require__(/*! ../debug-call-stack-item-type-key */ "../../node_modules/@theia/debug/lib/browser/debug-call-stack-item-type-key.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
let DebugThreadsWidget = DebugThreadsWidget_1 = class DebugThreadsWidget extends source_tree_1.SourceTreeWidget {
    constructor() {
        super(...arguments);
        this.updatingSelection = false;
    }
    static createContainer(parent) {
        const child = source_tree_1.SourceTreeWidget.createContainer(parent, {
            contextMenuPath: DebugThreadsWidget_1.CONTEXT_MENU,
            virtualized: false,
            scrollIfActive: true
        });
        child.bind(debug_threads_source_1.DebugThreadsSource).toSelf();
        child.unbind(source_tree_1.SourceTreeWidget);
        child.bind(DebugThreadsWidget_1).toSelf();
        return child;
    }
    static createWidget(parent) {
        return DebugThreadsWidget_1.createContainer(parent).get(DebugThreadsWidget_1);
    }
    init() {
        super.init();
        this.id = DebugThreadsWidget_1.FACTORY_ID + ':' + this.viewModel.id;
        this.title.label = nls_1.nls.localize('theia/debug/threads', 'Threads');
        this.toDispose.push(this.threads);
        this.source = this.threads;
        this.toDispose.push(this.viewModel.onDidChange(() => this.updateWidgetSelection()));
        this.toDispose.push(this.model.onSelectionChanged(() => this.updateModelSelection()));
    }
    updateWidgetSelection() {
        if (this.updatingSelection) {
            return;
        }
        this.updatingSelection = true;
        try {
            const { currentThread } = this.viewModel;
            if (currentThread) {
                const node = this.model.getNode(currentThread.id);
                if (browser_1.SelectableTreeNode.is(node)) {
                    this.model.selectNode(node);
                }
            }
        }
        finally {
            this.updatingSelection = false;
        }
    }
    updateModelSelection() {
        if (this.updatingSelection) {
            return;
        }
        this.updatingSelection = true;
        try {
            const node = this.model.selectedNodes[0];
            if (source_tree_1.TreeElementNode.is(node)) {
                if (node.element instanceof debug_session_1.DebugSession) {
                    this.viewModel.currentSession = node.element;
                    this.debugCallStackItemTypeKey.set('session');
                }
                else if (node.element instanceof debug_thread_1.DebugThread) {
                    this.viewModel.currentSession = node.element.session;
                    node.element.session.currentThread = node.element;
                    this.debugCallStackItemTypeKey.set('thread');
                }
            }
        }
        finally {
            this.updatingSelection = false;
        }
    }
    toContextMenuArgs(node) {
        if (source_tree_1.TreeElementNode.is(node) && node.element instanceof debug_thread_1.DebugThread) {
            return [node.element.raw.id];
        }
        return undefined;
    }
    getDefaultNodeStyle(node, props) {
        if (this.threads.multiSession) {
            return super.getDefaultNodeStyle(node, props);
        }
        return undefined;
    }
};
exports.DebugThreadsWidget = DebugThreadsWidget;
DebugThreadsWidget.CONTEXT_MENU = ['debug-threads-context-menu'];
DebugThreadsWidget.CONTROL_MENU = [...DebugThreadsWidget_1.CONTEXT_MENU, 'a_control'];
DebugThreadsWidget.TERMINATE_MENU = [...DebugThreadsWidget_1.CONTEXT_MENU, 'b_terminate'];
DebugThreadsWidget.OPEN_MENU = [...DebugThreadsWidget_1.CONTEXT_MENU, 'c_open'];
DebugThreadsWidget.FACTORY_ID = 'debug:threads';
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_threads_source_1.DebugThreadsSource),
    tslib_1.__metadata("design:type", debug_threads_source_1.DebugThreadsSource)
], DebugThreadsWidget.prototype, "threads", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_view_model_1.DebugViewModel),
    tslib_1.__metadata("design:type", debug_view_model_1.DebugViewModel)
], DebugThreadsWidget.prototype, "viewModel", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_call_stack_item_type_key_1.DebugCallStackItemTypeKey),
    tslib_1.__metadata("design:type", Object)
], DebugThreadsWidget.prototype, "debugCallStackItemTypeKey", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugThreadsWidget.prototype, "init", null);
exports.DebugThreadsWidget = DebugThreadsWidget = DebugThreadsWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugThreadsWidget);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/view/debug-toolbar-widget.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/view/debug-toolbar-widget.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var DebugToolBar_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugToolBar = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
const widgets_1 = __webpack_require__(/*! @theia/core/lib/browser/widgets */ "../../node_modules/@theia/core/lib/browser/widgets/index.js");
const debug_view_model_1 = __webpack_require__(/*! ./debug-view-model */ "../../node_modules/@theia/debug/lib/browser/view/debug-view-model.js");
const debug_session_1 = __webpack_require__(/*! ../debug-session */ "../../node_modules/@theia/debug/lib/browser/debug-session.js");
const debug_action_1 = __webpack_require__(/*! ./debug-action */ "../../node_modules/@theia/debug/lib/browser/view/debug-action.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
let DebugToolBar = DebugToolBar_1 = class DebugToolBar extends widgets_1.ReactWidget {
    constructor() {
        super(...arguments);
        this.onRender = new core_1.DisposableCollection();
        this.setStepRef = (stepRef) => {
            this.stepRef = stepRef || undefined;
            this.onRender.dispose();
        };
        this.start = () => this.model.start({ startedByUser: true });
        this.restart = () => this.model.restart();
        this.stop = () => this.model.terminate();
        this.continue = () => this.model.currentThread && this.model.currentThread.continue();
        this.pause = () => this.model.currentThread && this.model.currentThread.pause();
        this.stepOver = () => this.model.currentThread && this.model.currentThread.stepOver();
        this.stepIn = () => this.model.currentThread && this.model.currentThread.stepIn();
        this.stepOut = () => this.model.currentThread && this.model.currentThread.stepOut();
    }
    init() {
        this.id = 'debug:toolbar:' + this.model.id;
        this.addClass('debug-toolbar');
        this.toDispose.push(this.model);
        this.toDispose.push(this.model.onDidChange(() => this.update()));
        this.scrollOptions = undefined;
        this.update();
    }
    focus() {
        if (!this.doFocus()) {
            this.onRender.push(core_1.Disposable.create(() => this.doFocus()));
            this.update();
        }
    }
    doFocus() {
        if (!this.stepRef) {
            return false;
        }
        this.stepRef.focus();
        return true;
    }
    render() {
        const { state } = this.model;
        return React.createElement(React.Fragment, null,
            this.renderContributedCommands(),
            this.renderContinue(),
            React.createElement(debug_action_1.DebugAction, { enabled: state === debug_session_1.DebugState.Stopped, run: this.stepOver, label: nls_1.nls.localizeByDefault('Step Over'), iconClass: 'debug-step-over', ref: this.setStepRef }),
            React.createElement(debug_action_1.DebugAction, { enabled: state === debug_session_1.DebugState.Stopped, run: this.stepIn, label: nls_1.nls.localizeByDefault('Step Into'), iconClass: 'debug-step-into' }),
            React.createElement(debug_action_1.DebugAction, { enabled: state === debug_session_1.DebugState.Stopped, run: this.stepOut, label: nls_1.nls.localizeByDefault('Step Out'), iconClass: 'debug-step-out' }),
            React.createElement(debug_action_1.DebugAction, { enabled: state !== debug_session_1.DebugState.Inactive, run: this.restart, label: nls_1.nls.localizeByDefault('Restart'), iconClass: 'debug-restart' }),
            this.renderStart());
    }
    renderContributedCommands() {
        const debugActions = [];
        // first, search for CompoundMenuNodes:
        this.menuModelRegistry.getMenu(DebugToolBar_1.MENU).children.forEach(compoundMenuNode => {
            if (core_1.CompoundMenuNode.is(compoundMenuNode) && this.matchContext(compoundMenuNode.when)) {
                // second, search for nested CommandMenuNodes:
                compoundMenuNode.children.forEach(commandMenuNode => {
                    if (core_1.CommandMenuNode.is(commandMenuNode) && this.matchContext(commandMenuNode.when)) {
                        debugActions.push(this.debugAction(commandMenuNode));
                    }
                });
            }
        });
        return debugActions;
    }
    matchContext(when) {
        return !when || this.contextKeyService.match(when);
    }
    debugAction(commandMenuNode) {
        const { command, icon = '', label = '' } = commandMenuNode;
        if (!label && !icon) {
            const { when } = commandMenuNode;
            console.warn(`Neither 'label' nor 'icon' properties were defined for the command menu node. (${JSON.stringify({ command, when })}}. Skipping.`);
            return;
        }
        const run = () => this.commandRegistry.executeCommand(command);
        return React.createElement(debug_action_1.DebugAction, { key: command, enabled: true, label: label, iconClass: icon, run: run });
    }
    renderStart() {
        const { state } = this.model;
        if (state === debug_session_1.DebugState.Inactive && this.model.sessionCount === 1) {
            return React.createElement(debug_action_1.DebugAction, { run: this.start, label: nls_1.nls.localizeByDefault('Start'), iconClass: 'debug-start' });
        }
        return React.createElement(debug_action_1.DebugAction, { enabled: state !== debug_session_1.DebugState.Inactive, run: this.stop, label: nls_1.nls.localizeByDefault('Stop'), iconClass: 'debug-stop' });
    }
    renderContinue() {
        const { state } = this.model;
        if (state === debug_session_1.DebugState.Stopped) {
            return React.createElement(debug_action_1.DebugAction, { run: this.continue, label: nls_1.nls.localizeByDefault('Continue'), iconClass: 'debug-continue' });
        }
        return React.createElement(debug_action_1.DebugAction, { enabled: state === debug_session_1.DebugState.Running, run: this.pause, label: nls_1.nls.localizeByDefault('Pause'), iconClass: 'debug-pause' });
    }
};
exports.DebugToolBar = DebugToolBar;
DebugToolBar.MENU = ['debug-toolbar-menu'];
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.CommandRegistry),
    tslib_1.__metadata("design:type", core_1.CommandRegistry)
], DebugToolBar.prototype, "commandRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.MenuModelRegistry),
    tslib_1.__metadata("design:type", core_1.MenuModelRegistry)
], DebugToolBar.prototype, "menuModelRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    tslib_1.__metadata("design:type", Object)
], DebugToolBar.prototype, "contextKeyService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_view_model_1.DebugViewModel),
    tslib_1.__metadata("design:type", debug_view_model_1.DebugViewModel)
], DebugToolBar.prototype, "model", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugToolBar.prototype, "init", null);
exports.DebugToolBar = DebugToolBar = DebugToolBar_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugToolBar);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/view/debug-variables-source.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/view/debug-variables-source.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugVariablesSource = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const source_tree_1 = __webpack_require__(/*! @theia/core/lib/browser/source-tree */ "../../node_modules/@theia/core/lib/browser/source-tree/index.js");
const debug_view_model_1 = __webpack_require__(/*! ./debug-view-model */ "../../node_modules/@theia/debug/lib/browser/view/debug-view-model.js");
const debounce = __webpack_require__(/*! p-debounce */ "../../node_modules/p-debounce/index.js");
let DebugVariablesSource = class DebugVariablesSource extends source_tree_1.TreeSource {
    constructor() {
        super(...arguments);
        this.refresh = debounce(() => this.fireDidChange(), 400);
    }
    init() {
        this.refresh();
        this.toDispose.push(this.model.onDidChange(() => this.refresh()));
    }
    async getElements() {
        const { currentSession } = this.model;
        const scopes = currentSession ? await currentSession.getScopes() : [];
        return scopes[Symbol.iterator]();
    }
};
exports.DebugVariablesSource = DebugVariablesSource;
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_view_model_1.DebugViewModel),
    tslib_1.__metadata("design:type", debug_view_model_1.DebugViewModel)
], DebugVariablesSource.prototype, "model", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugVariablesSource.prototype, "init", null);
exports.DebugVariablesSource = DebugVariablesSource = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugVariablesSource);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/view/debug-variables-widget.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/view/debug-variables-widget.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var DebugVariablesWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugVariablesWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const source_tree_1 = __webpack_require__(/*! @theia/core/lib/browser/source-tree */ "../../node_modules/@theia/core/lib/browser/source-tree/index.js");
const debug_variables_source_1 = __webpack_require__(/*! ./debug-variables-source */ "../../node_modules/@theia/debug/lib/browser/view/debug-variables-source.js");
const debug_view_model_1 = __webpack_require__(/*! ./debug-view-model */ "../../node_modules/@theia/debug/lib/browser/view/debug-view-model.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
let DebugVariablesWidget = DebugVariablesWidget_1 = class DebugVariablesWidget extends source_tree_1.SourceTreeWidget {
    static createContainer(parent) {
        const child = source_tree_1.SourceTreeWidget.createContainer(parent, {
            contextMenuPath: DebugVariablesWidget_1.CONTEXT_MENU,
            virtualized: false,
            scrollIfActive: true
        });
        child.bind(debug_variables_source_1.DebugVariablesSource).toSelf();
        child.unbind(source_tree_1.SourceTreeWidget);
        child.bind(DebugVariablesWidget_1).toSelf();
        return child;
    }
    static createWidget(parent) {
        return DebugVariablesWidget_1.createContainer(parent).get(DebugVariablesWidget_1);
    }
    init() {
        super.init();
        this.id = DebugVariablesWidget_1.FACTORY_ID + ':' + this.viewModel.id;
        this.title.label = nls_1.nls.localizeByDefault('Variables');
        this.toDispose.push(this.variables);
        this.source = this.variables;
    }
};
exports.DebugVariablesWidget = DebugVariablesWidget;
DebugVariablesWidget.CONTEXT_MENU = ['debug-variables-context-menu'];
DebugVariablesWidget.EDIT_MENU = [...DebugVariablesWidget_1.CONTEXT_MENU, 'a_edit'];
DebugVariablesWidget.WATCH_MENU = [...DebugVariablesWidget_1.CONTEXT_MENU, 'b_watch'];
DebugVariablesWidget.FACTORY_ID = 'debug:variables';
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_view_model_1.DebugViewModel),
    tslib_1.__metadata("design:type", debug_view_model_1.DebugViewModel)
], DebugVariablesWidget.prototype, "viewModel", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_variables_source_1.DebugVariablesSource),
    tslib_1.__metadata("design:type", debug_variables_source_1.DebugVariablesSource)
], DebugVariablesWidget.prototype, "variables", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugVariablesWidget.prototype, "init", null);
exports.DebugVariablesWidget = DebugVariablesWidget = DebugVariablesWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugVariablesWidget);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/view/debug-view-model.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/view/debug-view-model.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugViewModel = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const p_debounce_1 = __webpack_require__(/*! p-debounce */ "../../node_modules/p-debounce/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const debug_session_1 = __webpack_require__(/*! ../debug-session */ "../../node_modules/@theia/debug/lib/browser/debug-session.js");
const debug_session_manager_1 = __webpack_require__(/*! ../debug-session-manager */ "../../node_modules/@theia/debug/lib/browser/debug-session-manager.js");
const debug_watch_expression_1 = __webpack_require__(/*! ./debug-watch-expression */ "../../node_modules/@theia/debug/lib/browser/view/debug-watch-expression.js");
const debug_watch_manager_1 = __webpack_require__(/*! ../debug-watch-manager */ "../../node_modules/@theia/debug/lib/browser/debug-watch-manager.js");
let DebugViewModel = class DebugViewModel {
    constructor() {
        this.onDidChangeEmitter = new common_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
        this.onDidChangeBreakpointsEmitter = new common_1.Emitter();
        this.onDidChangeBreakpoints = this.onDidChangeBreakpointsEmitter.event;
        this._watchExpressions = new Map();
        this.onDidChangeWatchExpressionsEmitter = new common_1.Emitter();
        this.onDidChangeWatchExpressions = this.onDidChangeWatchExpressionsEmitter.event;
        this.toDispose = new common_1.DisposableCollection(this.onDidChangeEmitter, this.onDidChangeBreakpointsEmitter, this.onDidChangeWatchExpressionsEmitter);
        this.refreshWatchExpressionsQueue = Promise.resolve();
        this.refreshWatchExpressions = (0, p_debounce_1.default)(() => {
            this.refreshWatchExpressionsQueue = this.refreshWatchExpressionsQueue.then(async () => {
                try {
                    await Promise.all(Array.from(this.watchExpressions).map(expr => expr.evaluate()));
                }
                catch (e) {
                    console.error('Failed to refresh watch expressions: ', e);
                }
            });
        }, 50);
    }
    fireDidChange() {
        this.refreshWatchExpressions();
        this.onDidChangeEmitter.fire(undefined);
    }
    fireDidChangeBreakpoints(uri) {
        this.onDidChangeBreakpointsEmitter.fire(uri);
    }
    fireDidChangeWatchExpressions() {
        this.onDidChangeWatchExpressionsEmitter.fire(undefined);
    }
    get sessions() {
        return this.manager.sessions[Symbol.iterator]();
    }
    get sessionCount() {
        return this.manager.sessions.length;
    }
    get session() {
        return this.currentSession;
    }
    get id() {
        return this.session && this.session.id || '-1';
    }
    get label() {
        return this.session && this.session.label || 'Unknown Session';
    }
    init() {
        this.toDispose.push(this.manager.onDidChangeActiveDebugSession(() => {
            this.fireDidChange();
        }));
        this.toDispose.push(this.manager.onDidChange(current => {
            if (current === this.currentSession) {
                this.fireDidChange();
            }
        }));
        this.toDispose.push(this.manager.onDidChangeBreakpoints(({ session, uri }) => {
            if (!session || session === this.currentSession) {
                this.fireDidChangeBreakpoints(uri);
            }
        }));
        this.updateWatchExpressions();
        this.toDispose.push(this.watch.onDidChange(() => this.updateWatchExpressions()));
    }
    dispose() {
        this.toDispose.dispose();
    }
    get currentSession() {
        const { currentSession } = this.manager;
        return currentSession;
    }
    set currentSession(currentSession) {
        this.manager.currentSession = currentSession;
    }
    get state() {
        const { currentSession } = this;
        return currentSession && currentSession.state || debug_session_1.DebugState.Inactive;
    }
    get currentThread() {
        const { currentSession } = this;
        return currentSession && currentSession.currentThread;
    }
    get currentFrame() {
        const { currentThread } = this;
        return currentThread && currentThread.currentFrame;
    }
    get breakpoints() {
        return this.manager.getBreakpoints(this.currentSession);
    }
    get functionBreakpoints() {
        return this.manager.getFunctionBreakpoints(this.currentSession);
    }
    get instructionBreakpoints() {
        return this.manager.getInstructionBreakpoints(this.currentSession);
    }
    async start(options = {}) {
        const { session } = this;
        if (!session) {
            return;
        }
        const optionsCopy = (0, common_1.deepClone)(session.options);
        const newSession = await this.manager.start(Object.assign(optionsCopy, options));
        if (newSession) {
            this.fireDidChange();
        }
    }
    async restart() {
        const { session } = this;
        if (!session) {
            return;
        }
        await this.manager.restartSession(session);
        this.fireDidChange();
    }
    async terminate() {
        this.manager.terminateSession();
    }
    get watchExpressions() {
        return this._watchExpressions.values();
    }
    async addWatchExpression(expression = '') {
        const watchExpression = new debug_watch_expression_1.DebugWatchExpression({
            id: Number.MAX_SAFE_INTEGER,
            expression,
            session: () => this.currentSession,
            remove: () => this.removeWatchExpression(watchExpression),
            onDidChange: () => { },
        });
        await watchExpression.open();
        if (!watchExpression.expression) {
            return undefined;
        }
        const id = this.watch.addWatchExpression(watchExpression.expression);
        return this._watchExpressions.get(id);
    }
    removeWatchExpressions() {
        this.watch.removeWatchExpressions();
    }
    removeWatchExpression(expression) {
        this.watch.removeWatchExpression(expression.id);
    }
    updateWatchExpressions() {
        let added = false;
        const toRemove = new Set(this._watchExpressions.keys());
        for (const [id, expression] of this.watch.watchExpressions) {
            toRemove.delete(id);
            if (!this._watchExpressions.has(id)) {
                added = true;
                const watchExpression = new debug_watch_expression_1.DebugWatchExpression({
                    id,
                    expression,
                    session: () => this.currentSession,
                    remove: () => this.removeWatchExpression(watchExpression),
                    onDidChange: () => this.fireDidChangeWatchExpressions()
                });
                this._watchExpressions.set(id, watchExpression);
                watchExpression.evaluate();
            }
        }
        for (const id of toRemove) {
            this._watchExpressions.delete(id);
        }
        if (added || toRemove.size) {
            this.fireDidChangeWatchExpressions();
        }
    }
};
exports.DebugViewModel = DebugViewModel;
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_session_manager_1.DebugSessionManager),
    tslib_1.__metadata("design:type", debug_session_manager_1.DebugSessionManager)
], DebugViewModel.prototype, "manager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_watch_manager_1.DebugWatchManager),
    tslib_1.__metadata("design:type", debug_watch_manager_1.DebugWatchManager)
], DebugViewModel.prototype, "watch", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugViewModel.prototype, "init", null);
exports.DebugViewModel = DebugViewModel = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugViewModel);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/view/debug-watch-expression.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/view/debug-watch-expression.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugWatchExpression = void 0;
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const dialogs_1 = __webpack_require__(/*! @theia/core/lib/browser/dialogs */ "../../node_modules/@theia/core/lib/browser/dialogs.js");
const debug_console_items_1 = __webpack_require__(/*! ../console/debug-console-items */ "../../node_modules/@theia/debug/lib/browser/console/debug-console-items.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
class DebugWatchExpression extends debug_console_items_1.ExpressionItem {
    constructor(options) {
        super(options.expression, options.session);
        this.options = options;
        this.setValueRef = (valueRef) => this.valueRef = valueRef || undefined;
        this.id = options.id;
    }
    async evaluate() {
        await super.evaluate('watch');
    }
    setResult(body, error) {
        const session = this.options.session();
        this.isNotAvailable = false;
        this.isError = false;
        // not available must be set regardless of the session's availability.
        // not available is used when there is no session or the current stack frame is not available.
        if (error === debug_console_items_1.ExpressionItem.notAvailable) {
            super.setResult(undefined, error);
            this.isNotAvailable = true;
        }
        else if (session) {
            super.setResult(body, error);
            this.isError = !!error;
        }
        this.options.onDidChange();
    }
    render() {
        const valueClass = this.valueClass();
        return React.createElement("div", { className: 'theia-debug-console-variable theia-debug-watch-expression' },
            React.createElement("div", { className: browser_1.TREE_NODE_SEGMENT_GROW_CLASS },
                React.createElement("span", { title: this.type || this._expression, className: 'name' },
                    this._expression,
                    ": "),
                React.createElement("span", { title: this._value, ref: this.setValueRef, className: valueClass }, this._value)),
            React.createElement("div", { className: (0, browser_1.codicon)('close', true), title: core_1.nls.localizeByDefault('Remove Expression'), onClick: this.options.remove }));
    }
    valueClass() {
        if (this.isError) {
            return 'watch-error';
        }
        if (this.isNotAvailable) {
            return 'watch-not-available';
        }
        return '';
    }
    async open() {
        const input = new dialogs_1.SingleTextInputDialog({
            title: core_1.nls.localizeByDefault('Edit Expression'),
            initialValue: this.expression,
            placeholder: core_1.nls.localizeByDefault('Expression to watch')
        });
        const newValue = await input.open();
        if (newValue !== undefined) {
            this._expression = newValue;
            await this.evaluate();
        }
    }
    get supportCopyValue() {
        return !!this.valueRef && document.queryCommandSupported('copy');
    }
    copyValue() {
        const selection = document.getSelection();
        if (this.valueRef && selection) {
            selection.selectAllChildren(this.valueRef);
            document.execCommand('copy');
        }
    }
}
exports.DebugWatchExpression = DebugWatchExpression;


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/view/debug-watch-source.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/view/debug-watch-source.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugWatchSource = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const source_tree_1 = __webpack_require__(/*! @theia/core/lib/browser/source-tree */ "../../node_modules/@theia/core/lib/browser/source-tree/index.js");
const debug_view_model_1 = __webpack_require__(/*! ./debug-view-model */ "../../node_modules/@theia/debug/lib/browser/view/debug-view-model.js");
const debounce = __webpack_require__(/*! p-debounce */ "../../node_modules/p-debounce/index.js");
let DebugWatchSource = class DebugWatchSource extends source_tree_1.TreeSource {
    constructor() {
        super(...arguments);
        this.refresh = debounce(() => this.fireDidChange(), 100);
    }
    init() {
        this.refresh();
        this.toDispose.push(this.model.onDidChangeWatchExpressions(() => this.refresh()));
    }
    async getElements() {
        return this.model.watchExpressions[Symbol.iterator]();
    }
};
exports.DebugWatchSource = DebugWatchSource;
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_view_model_1.DebugViewModel),
    tslib_1.__metadata("design:type", debug_view_model_1.DebugViewModel)
], DebugWatchSource.prototype, "model", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugWatchSource.prototype, "init", null);
exports.DebugWatchSource = DebugWatchSource = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugWatchSource);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/view/debug-watch-widget.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/view/debug-watch-widget.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var DebugWatchWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugWatchWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const source_tree_1 = __webpack_require__(/*! @theia/core/lib/browser/source-tree */ "../../node_modules/@theia/core/lib/browser/source-tree/index.js");
const debug_watch_source_1 = __webpack_require__(/*! ./debug-watch-source */ "../../node_modules/@theia/debug/lib/browser/view/debug-watch-source.js");
const debug_view_model_1 = __webpack_require__(/*! ./debug-view-model */ "../../node_modules/@theia/debug/lib/browser/view/debug-view-model.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
let DebugWatchWidget = DebugWatchWidget_1 = class DebugWatchWidget extends source_tree_1.SourceTreeWidget {
    static createContainer(parent) {
        const child = source_tree_1.SourceTreeWidget.createContainer(parent, {
            contextMenuPath: DebugWatchWidget_1.CONTEXT_MENU,
            virtualized: false,
            scrollIfActive: true
        });
        child.bind(debug_watch_source_1.DebugWatchSource).toSelf();
        child.unbind(source_tree_1.SourceTreeWidget);
        child.bind(DebugWatchWidget_1).toSelf();
        return child;
    }
    static createWidget(parent) {
        return DebugWatchWidget_1.createContainer(parent).get(DebugWatchWidget_1);
    }
    init() {
        super.init();
        this.id = DebugWatchWidget_1.FACTORY_ID + ':' + this.viewModel.id;
        this.title.label = nls_1.nls.localizeByDefault('Watch');
        this.toDispose.push(this.variables);
        this.source = this.variables;
    }
};
exports.DebugWatchWidget = DebugWatchWidget;
DebugWatchWidget.CONTEXT_MENU = ['debug-watch-context-menu'];
DebugWatchWidget.EDIT_MENU = [...DebugWatchWidget_1.CONTEXT_MENU, 'a_edit'];
DebugWatchWidget.REMOVE_MENU = [...DebugWatchWidget_1.CONTEXT_MENU, 'b_remove'];
DebugWatchWidget.FACTORY_ID = 'debug:watch';
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_view_model_1.DebugViewModel),
    tslib_1.__metadata("design:type", debug_view_model_1.DebugViewModel)
], DebugWatchWidget.prototype, "viewModel", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_watch_source_1.DebugWatchSource),
    tslib_1.__metadata("design:type", debug_watch_source_1.DebugWatchSource)
], DebugWatchWidget.prototype, "variables", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugWatchWidget.prototype, "init", null);
exports.DebugWatchWidget = DebugWatchWidget = DebugWatchWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugWatchWidget);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/browser/view/debug-widget.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/browser/view/debug-widget.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var DebugWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const debug_session_widget_1 = __webpack_require__(/*! ./debug-session-widget */ "../../node_modules/@theia/debug/lib/browser/view/debug-session-widget.js");
const debug_configuration_widget_1 = __webpack_require__(/*! ./debug-configuration-widget */ "../../node_modules/@theia/debug/lib/browser/view/debug-configuration-widget.js");
const debug_view_model_1 = __webpack_require__(/*! ./debug-view-model */ "../../node_modules/@theia/debug/lib/browser/view/debug-view-model.js");
const debug_session_manager_1 = __webpack_require__(/*! ../debug-session-manager */ "../../node_modules/@theia/debug/lib/browser/debug-session-manager.js");
const progress_bar_factory_1 = __webpack_require__(/*! @theia/core/lib/browser/progress-bar-factory */ "../../node_modules/@theia/core/lib/browser/progress-bar-factory.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
let DebugWidget = DebugWidget_1 = class DebugWidget extends browser_1.BaseWidget {
    static createContainer(parent) {
        const child = debug_session_widget_1.DebugSessionWidget.createContainer(parent);
        child.bind(debug_configuration_widget_1.DebugConfigurationWidget).toSelf();
        child.bind(DebugWidget_1).toSelf();
        return child;
    }
    static createWidget(parent) {
        return DebugWidget_1.createContainer(parent).get(DebugWidget_1);
    }
    init() {
        this.id = DebugWidget_1.ID;
        this.title.label = DebugWidget_1.LABEL;
        this.title.caption = DebugWidget_1.LABEL;
        this.title.closable = true;
        this.title.iconClass = (0, browser_1.codicon)('debug-alt');
        this.addClass('theia-debug-container');
        this.toDispose.pushAll([
            this.toolbar,
            this.sessionWidget,
        ]);
        const layout = this.layout = new browser_1.PanelLayout();
        layout.addWidget(this.toolbar);
        layout.addWidget(this.sessionWidget);
        this.toDispose.push(this.progressBarFactory({ container: this.node, insertMode: 'prepend', locationId: 'debug' }));
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        this.toolbar.focus();
    }
    getTrackableWidgets() {
        return [this.sessionWidget];
    }
    storeState() {
        return this.sessionWidget.storeState();
    }
    restoreState(oldState) {
        this.sessionWidget.restoreState(oldState);
    }
};
exports.DebugWidget = DebugWidget;
DebugWidget.ID = 'debug';
DebugWidget.LABEL = nls_1.nls.localizeByDefault('Debug');
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_view_model_1.DebugViewModel),
    tslib_1.__metadata("design:type", debug_view_model_1.DebugViewModel)
], DebugWidget.prototype, "model", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_session_manager_1.DebugSessionManager),
    tslib_1.__metadata("design:type", debug_session_manager_1.DebugSessionManager)
], DebugWidget.prototype, "sessionManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_configuration_widget_1.DebugConfigurationWidget),
    tslib_1.__metadata("design:type", debug_configuration_widget_1.DebugConfigurationWidget)
], DebugWidget.prototype, "toolbar", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(debug_session_widget_1.DebugSessionWidget),
    tslib_1.__metadata("design:type", debug_session_widget_1.DebugSessionWidget)
], DebugWidget.prototype, "sessionWidget", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(progress_bar_factory_1.ProgressBarFactory),
    tslib_1.__metadata("design:type", Function)
], DebugWidget.prototype, "progressBarFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DebugWidget.prototype, "init", null);
exports.DebugWidget = DebugWidget = DebugWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DebugWidget);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/common/debug-common.js":
/*!******************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/common/debug-common.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// FIXME: refactor extensions to get rid of this file and remove it
tslib_1.__exportStar(__webpack_require__(/*! ./debug-configuration */ "../../node_modules/@theia/debug/lib/common/debug-configuration.js"), exports);


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/common/debug-compound.js":
/*!********************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/common/debug-compound.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2022 EclipseSource and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugCompound = exports.defaultCompound = void 0;
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
exports.defaultCompound = { name: 'Compound', configurations: [] };
var DebugCompound;
(function (DebugCompound) {
    function is(arg) {
        return (0, common_1.isObject)(arg) && 'name' in arg && 'configurations' in arg;
    }
    DebugCompound.is = is;
})(DebugCompound || (exports.DebugCompound = DebugCompound = {}));


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/common/debug-configuration.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/common/debug-configuration.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DebugConsoleMode = exports.DebugConfiguration = void 0;
// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
var DebugConfiguration;
(function (DebugConfiguration) {
    function is(arg) {
        return (0, common_1.isObject)(arg) && 'type' in arg && 'name' in arg && 'request' in arg;
    }
    DebugConfiguration.is = is;
})(DebugConfiguration || (exports.DebugConfiguration = DebugConfiguration = {}));
var DebugConsoleMode;
(function (DebugConsoleMode) {
    DebugConsoleMode[DebugConsoleMode["Separate"] = 0] = "Separate";
    DebugConsoleMode[DebugConsoleMode["MergeWithParent"] = 1] = "MergeWithParent";
})(DebugConsoleMode || (exports.DebugConsoleMode = DebugConsoleMode = {}));


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/common/debug-service.js":
/*!*******************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/common/debug-service.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ForwardingDebugChannel = exports.DebugError = exports.DebugAdapterPath = exports.DebugService = exports.DebugPath = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const application_error_1 = __webpack_require__(/*! @theia/core/lib/common/application-error */ "../../node_modules/@theia/core/lib/common/application-error.js");
/**
 * The WS endpoint path to the Debug service.
 */
exports.DebugPath = '/services/debug';
/**
 * DebugService symbol for DI.
 */
exports.DebugService = Symbol('DebugService');
/**
 * The endpoint path to the debug adapter session.
 */
exports.DebugAdapterPath = '/services/debug-adapter';
var DebugError;
(function (DebugError) {
    DebugError.NotFound = application_error_1.ApplicationError.declare(-41000, (type) => ({
        message: `'${type}' debugger type is not supported.`,
        data: { type }
    }));
})(DebugError || (exports.DebugError = DebugError = {}));
/**
 * A {@link DebugChannel} wrapper implementation that sends and receives messages to/from an underlying {@link Channel}.
 */
class ForwardingDebugChannel {
    constructor(underlyingChannel) {
        this.underlyingChannel = underlyingChannel;
        this.onMessageEmitter = new core_1.Emitter();
        this.underlyingChannel.onMessage(msg => this.onMessageEmitter.fire(msg().readString()));
    }
    send(content) {
        this.underlyingChannel.getWriteBuffer().writeString(content).commit();
    }
    onMessage(cb) {
        this.onMessageEmitter.event(cb);
    }
    onError(cb) {
        this.underlyingChannel.onError(cb);
    }
    onClose(cb) {
        this.underlyingChannel.onClose(event => { var _a; return cb((_a = event.code) !== null && _a !== void 0 ? _a : -1, event.reason); });
    }
    close() {
        this.underlyingChannel.close();
        this.onMessageEmitter.dispose();
    }
}
exports.ForwardingDebugChannel = ForwardingDebugChannel;


/***/ }),

/***/ "../../node_modules/@theia/debug/lib/common/debug-uri-utils.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@theia/debug/lib/common/debug-uri-utils.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/********************************************************************************
 * Copyright (C) 2022 STMicroelectronics and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SCHEME_PATTERN = exports.DEBUG_SCHEME = void 0;
/**
 * The URI scheme for debug URIs.
 */
exports.DEBUG_SCHEME = 'debug';
/**
 * The pattern for URI schemes.
 */
exports.SCHEME_PATTERN = /^[a-zA-Z][a-zA-Z0-9\+\-\.]+:/;


/***/ }),

/***/ "../../node_modules/@theia/monaco/lib/browser/monaco-editor-zone-widget.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@theia/monaco/lib/browser/monaco-editor-zone-widget.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation and others. All rights reserved.
 *  Licensed under the MIT License. See https://github.com/Microsoft/vscode/blob/master/LICENSE.txt for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MonacoEditorZoneWidget = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
class MonacoEditorZoneWidget {
    constructor(editorInstance, showArrow = true) {
        this.showArrow = showArrow;
        this.zoneNode = document.createElement('div');
        this.containerNode = document.createElement('div');
        this.onDidLayoutChangeEmitter = new core_1.Emitter();
        this.onDidLayoutChange = this.onDidLayoutChangeEmitter.event;
        this.toHide = new core_1.DisposableCollection();
        this.toDispose = new core_1.DisposableCollection(this.onDidLayoutChangeEmitter, this.toHide);
        this.editor = editorInstance;
        this.zoneNode.classList.add('zone-widget');
        this.containerNode.classList.add('zone-widget-container');
        this.zoneNode.appendChild(this.containerNode);
        this.updateWidth();
        this.toDispose.push(this.editor.onDidLayoutChange(info => this.updateWidth(info)));
    }
    dispose() {
        this.toDispose.dispose();
        this.hide();
    }
    get options() {
        return this.viewZone ? this._options : undefined;
    }
    hide() {
        this.toHide.dispose();
    }
    show(options) {
        let { afterLineNumber, afterColumn, heightInLines } = this._options = { showFrame: true, ...options };
        const lineHeight = this.editor.getOption(monaco.editor.EditorOption.lineHeight);
        // adjust heightInLines to viewport
        const maxHeightInLines = Math.max(12, (this.editor.getLayoutInfo().height / lineHeight) * 0.8);
        heightInLines = Math.min(heightInLines, maxHeightInLines);
        let arrowHeight = 0;
        this.toHide.dispose();
        this.editor.changeViewZones(accessor => {
            this.zoneNode.style.top = '-1000px';
            const domNode = document.createElement('div');
            domNode.style.overflow = 'hidden';
            const zone = {
                domNode,
                afterLineNumber,
                afterColumn,
                heightInLines,
                onDomNodeTop: zoneTop => this.updateTop(zoneTop),
                onComputedHeight: zoneHeight => this.updateHeight(zoneHeight)
            };
            this.viewZone = Object.assign(zone, {
                id: accessor.addZone(zone)
            });
            const id = this.viewZone.id;
            this.toHide.push(core_1.Disposable.create(() => {
                this.editor.changeViewZones(a => a.removeZone(id));
                this.viewZone = undefined;
            }));
            if (this.showArrow) {
                this.arrow = new Arrow(this.editor);
                arrowHeight = Math.round(lineHeight / 3);
                this.arrow.height = arrowHeight;
                this.arrow.show({ lineNumber: options.afterLineNumber, column: 0 });
                this.toHide.push(this.arrow);
            }
            const widget = {
                getId: () => 'editor-zone-widget-' + id,
                getDomNode: () => this.zoneNode,
                // eslint-disable-next-line no-null/no-null
                getPosition: () => null
            };
            this.editor.addOverlayWidget(widget);
            this.toHide.push(core_1.Disposable.create(() => this.editor.removeOverlayWidget(widget)));
        });
        this.containerNode.style.overflow = 'hidden';
        this.updateContainerHeight(heightInLines * lineHeight);
        const model = this.editor.getModel();
        if (model) {
            const revealLineNumber = Math.min(model.getLineCount(), Math.max(1, afterLineNumber + 1));
            this.editor.revealLine(revealLineNumber, monaco.editor.ScrollType.Smooth);
        }
    }
    layout(heightInLines) {
        if (this.viewZone && this.viewZone.heightInLines !== heightInLines) {
            this.viewZone.heightInLines = heightInLines;
            const id = this.viewZone.id;
            this.editor.changeViewZones(accessor => accessor.layoutZone(id));
        }
    }
    updateTop(top) {
        this.zoneNode.style.top = top + (this.showArrow ? 6 : 0) + 'px';
    }
    updateHeight(zoneHeight) {
        this.zoneNode.style.height = zoneHeight + 'px';
        this.updateContainerHeight(zoneHeight);
    }
    updateContainerHeight(zoneHeight) {
        const { frameWidth, height } = this.computeContainerHeight(zoneHeight);
        this.containerNode.style.height = height + 'px';
        this.containerNode.style.borderTopWidth = frameWidth + 'px';
        this.containerNode.style.borderBottomWidth = frameWidth + 'px';
        const width = this.computeWidth();
        this.onDidLayoutChangeEmitter.fire({ height, width });
    }
    computeContainerHeight(zoneHeight) {
        const lineHeight = this.editor.getOption(monaco.editor.EditorOption.lineHeight);
        const frameWidth = this._options && this._options.frameWidth;
        const frameThickness = this._options && this._options.showFrame ? Math.round(lineHeight / 9) : 0;
        return {
            frameWidth: frameWidth !== undefined ? frameWidth : frameThickness,
            height: zoneHeight - 2 * frameThickness
        };
    }
    updateWidth(info = this.editor.getLayoutInfo()) {
        const width = this.computeWidth(info);
        this.zoneNode.style.width = width + 'px';
        this.zoneNode.style.left = this.computeLeft(info) + 'px';
    }
    computeWidth(info = this.editor.getLayoutInfo()) {
        return info.width - info.minimap.minimapWidth - info.verticalScrollbarWidth;
    }
    computeLeft(info = this.editor.getLayoutInfo()) {
        // If minimap is to the left, we move beyond it
        if (info.minimap.minimapWidth > 0 && info.minimap.minimapLeft === 0) {
            return info.minimap.minimapWidth;
        }
        return 0;
    }
}
exports.MonacoEditorZoneWidget = MonacoEditorZoneWidget;
class IdGenerator {
    constructor(prefix) {
        this.prefix = prefix;
        this.lastId = 0;
    }
    nextId() {
        return this.prefix + (++this.lastId);
    }
}
class Arrow {
    constructor(_editor) {
        this._editor = _editor;
        this.idGenerator = new IdGenerator('.arrow-decoration-');
        this.ruleName = this.idGenerator.nextId();
        this.decorations = [];
        this._height = -1;
    }
    dispose() {
        this.hide();
    }
    set height(value) {
        if (this._height !== value) {
            this._height = value;
            this._updateStyle();
        }
    }
    _updateStyle() {
        const style = document.createElement('style');
        style.type = 'text/css';
        style.media = 'screen';
        document.getElementsByTagName('head')[0].appendChild(style);
        const selector = `.monaco-editor ${this.ruleName}`;
        const cssText = `border-style: solid; border-color: transparent transparent var(--theia-peekView-border); border-width:
            ${this._height}px; bottom: -${this._height}px; margin-left: -${this._height}px; `;
        style.sheet.insertRule(selector + '{' + cssText + '}', 0);
    }
    show(where) {
        this.decorations = this._editor.deltaDecorations(this.decorations, [{ range: monaco.Range.fromPositions(where), options: { className: this.ruleName, stickiness: browser_1.TrackedRangeStickiness.NeverGrowsWhenTypingAtEdges } }]);
    }
    hide() {
        this._editor.deltaDecorations(this.decorations, []);
    }
}


/***/ }),

/***/ "../../node_modules/anser/lib/index.js":
/*!*********************************************!*\
  !*** ../../node_modules/anser/lib/index.js ***!
  \*********************************************/
/***/ ((module) => {

"use strict";


// This file was originally written by @drudru (https://github.com/drudru/ansi_up), MIT, 2011

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var ANSI_COLORS = [[{ color: "0, 0, 0", "class": "ansi-black" }, { color: "187, 0, 0", "class": "ansi-red" }, { color: "0, 187, 0", "class": "ansi-green" }, { color: "187, 187, 0", "class": "ansi-yellow" }, { color: "0, 0, 187", "class": "ansi-blue" }, { color: "187, 0, 187", "class": "ansi-magenta" }, { color: "0, 187, 187", "class": "ansi-cyan" }, { color: "255,255,255", "class": "ansi-white" }], [{ color: "85, 85, 85", "class": "ansi-bright-black" }, { color: "255, 85, 85", "class": "ansi-bright-red" }, { color: "0, 255, 0", "class": "ansi-bright-green" }, { color: "255, 255, 85", "class": "ansi-bright-yellow" }, { color: "85, 85, 255", "class": "ansi-bright-blue" }, { color: "255, 85, 255", "class": "ansi-bright-magenta" }, { color: "85, 255, 255", "class": "ansi-bright-cyan" }, { color: "255, 255, 255", "class": "ansi-bright-white" }]];
// https://datatracker.ietf.org/doc/html/rfc3986#appendix-A
var linkRegex = /(https?:\/\/(?:[A-Za-z0-9#;/?:@=+$',_.!~*()[\]-]|&amp;|%[A-Fa-f0-9]{2})+)/gm;

var Anser = function () {
    _createClass(Anser, null, [{
        key: "escapeForHtml",


        /**
         * Anser.escapeForHtml
         * Escape the input HTML.
         *
         * This does the minimum escaping of text to make it compliant with HTML.
         * In particular, the '&','<', and '>' characters are escaped. This should
         * be run prior to `ansiToHtml`.
         *
         * @name Anser.escapeForHtml
         * @function
         * @param {String} txt The input text (containing the ANSI snippets).
         * @returns {String} The escaped html.
         */
        value: function escapeForHtml(txt) {
            return new Anser().escapeForHtml(txt);
        }

        /**
         * Anser.linkify
         * Adds the links in the HTML.
         *
         * This replaces any links in the text with anchor tags that display the
         * link. You should apply this after you have run `ansiToHtml` on the text.
         *
         * @name Anser.linkify
         * @function
         * @param {String} txt The input text.
         * @returns {String} The HTML containing the <a> tags (unescaped).
         */

    }, {
        key: "linkify",
        value: function linkify(txt) {
            return new Anser().linkify(txt);
        }

        /**
         * Anser.ansiToHtml
         * This replaces ANSI terminal escape codes with SPAN tags that wrap the
         * content.
         *
         * This function only interprets ANSI SGR (Select Graphic Rendition) codes
         * that can be represented in HTML.
         * For example, cursor movement codes are ignored and hidden from output.
         * The default style uses colors that are very close to the prescribed
         * standard. The standard assumes that the text will have a black
         * background. These colors are set as inline styles on the SPAN tags.
         *
         * Another option is to set `use_classes: true` in the options argument.
         * This will instead set classes on the spans so the colors can be set via
         * CSS. The class names used are of the format `ansi-*-fg/bg` and
         * `ansi-bright-*-fg/bg` where `*` is the color name,
         * i.e black/red/green/yellow/blue/magenta/cyan/white.
         *
         * @name Anser.ansiToHtml
         * @function
         * @param {String} txt The input text.
         * @param {Object} options The options passed to the ansiToHTML method.
         * @returns {String} The HTML output.
         */

    }, {
        key: "ansiToHtml",
        value: function ansiToHtml(txt, options) {
            return new Anser().ansiToHtml(txt, options);
        }

        /**
         * Anser.ansiToJson
         * Converts ANSI input into JSON output.
         *
         * @name Anser.ansiToJson
         * @function
         * @param {String} txt The input text.
         * @param {Object} options The options passed to the ansiToHTML method.
         * @returns {String} The HTML output.
         */

    }, {
        key: "ansiToJson",
        value: function ansiToJson(txt, options) {
            return new Anser().ansiToJson(txt, options);
        }

        /**
         * Anser.ansiToText
         * Converts ANSI input into text output.
         *
         * @name Anser.ansiToText
         * @function
         * @param {String} txt The input text.
         * @returns {String} The text output.
         */

    }, {
        key: "ansiToText",
        value: function ansiToText(txt) {
            return new Anser().ansiToText(txt);
        }

        /**
         * Anser
         * The `Anser` class.
         *
         * @name Anser
         * @function
         * @returns {Anser}
         */

    }]);

    function Anser() {
        _classCallCheck(this, Anser);

        this.fg = this.bg = this.fg_truecolor = this.bg_truecolor = null;
        this.bright = 0;
        this.decorations = [];
    }

    /**
     * setupPalette
     * Sets up the palette.
     *
     * @name setupPalette
     * @function
     */


    _createClass(Anser, [{
        key: "setupPalette",
        value: function setupPalette() {
            this.PALETTE_COLORS = [];

            // Index 0..15 : System color
            for (var i = 0; i < 2; ++i) {
                for (var j = 0; j < 8; ++j) {
                    this.PALETTE_COLORS.push(ANSI_COLORS[i][j].color);
                }
            }

            // Index 16..231 : RGB 6x6x6
            // https://gist.github.com/jasonm23/2868981#file-xterm-256color-yaml
            var levels = [0, 95, 135, 175, 215, 255];
            var format = function format(r, g, b) {
                return levels[r] + ", " + levels[g] + ", " + levels[b];
            };
            var r = void 0,
                g = void 0,
                b = void 0;
            for (var _r = 0; _r < 6; ++_r) {
                for (var _g = 0; _g < 6; ++_g) {
                    for (var _b = 0; _b < 6; ++_b) {
                        this.PALETTE_COLORS.push(format(_r, _g, _b));
                    }
                }
            }

            // Index 232..255 : Grayscale
            var level = 8;
            for (var _i = 0; _i < 24; ++_i, level += 10) {
                this.PALETTE_COLORS.push(format(level, level, level));
            }
        }

        /**
         * escapeForHtml
         * Escapes the input text.
         *
         * @name escapeForHtml
         * @function
         * @param {String} txt The input text.
         * @returns {String} The escpaed HTML output.
         */

    }, {
        key: "escapeForHtml",
        value: function escapeForHtml(txt) {
            return txt.replace(/[&<>\"]/gm, function (str) {
                return str == "&" ? "&amp;" : str == '"' ? "&quot;" : str == "<" ? "&lt;" : str == ">" ? "&gt;" : "";
            });
        }

        /**
         * linkify
         * Adds HTML link elements.
         *
         * @name linkify
         * @function
         * @param {String} txt The input text.
         * @returns {String} The HTML output containing link elements.
         */

    }, {
        key: "linkify",
        value: function linkify(txt) {
            return txt.replace(linkRegex, function (str) {
                return "<a href=\"" + str + "\">" + str + "</a>";
            });
        }

        /**
         * ansiToHtml
         * Converts ANSI input into HTML output.
         *
         * @name ansiToHtml
         * @function
         * @param {String} txt The input text.
         * @param {Object} options The options passed ot the `process` method.
         * @returns {String} The HTML output.
         */

    }, {
        key: "ansiToHtml",
        value: function ansiToHtml(txt, options) {
            return this.process(txt, options, true);
        }

        /**
         * ansiToJson
         * Converts ANSI input into HTML output.
         *
         * @name ansiToJson
         * @function
         * @param {String} txt The input text.
         * @param {Object} options The options passed ot the `process` method.
         * @returns {String} The JSON output.
         */

    }, {
        key: "ansiToJson",
        value: function ansiToJson(txt, options) {
            options = options || {};
            options.json = true;
            options.clearLine = false;
            return this.process(txt, options, true);
        }

        /**
         * ansiToText
         * Converts ANSI input into HTML output.
         *
         * @name ansiToText
         * @function
         * @param {String} txt The input text.
         * @returns {String} The text output.
         */

    }, {
        key: "ansiToText",
        value: function ansiToText(txt) {
            return this.process(txt, {}, false);
        }

        /**
         * process
         * Processes the input.
         *
         * @name process
         * @function
         * @param {String} txt The input text.
         * @param {Object} options An object passed to `processChunk` method, extended with:
         *
         *  - `json` (Boolean): If `true`, the result will be an object.
         *  - `use_classes` (Boolean): If `true`, HTML classes will be appended to the HTML output.
         *
         * @param {Boolean} markup
         */

    }, {
        key: "process",
        value: function process(txt, options, markup) {
            var _this = this;

            var self = this;
            var raw_text_chunks = txt.split(/\033\[/);
            var first_chunk = raw_text_chunks.shift(); // the first chunk is not the result of the split

            if (options === undefined || options === null) {
                options = {};
            }
            options.clearLine = /\r/.test(txt); // check for Carriage Return
            var color_chunks = raw_text_chunks.map(function (chunk) {
                return _this.processChunk(chunk, options, markup);
            });

            if (options && options.json) {
                var first = self.processChunkJson("");
                first.content = first_chunk;
                first.clearLine = options.clearLine;
                color_chunks.unshift(first);
                if (options.remove_empty) {
                    color_chunks = color_chunks.filter(function (c) {
                        return !c.isEmpty();
                    });
                }
                return color_chunks;
            } else {
                color_chunks.unshift(first_chunk);
            }

            return color_chunks.join("");
        }

        /**
         * processChunkJson
         * Processes the current chunk into json output.
         *
         * @name processChunkJson
         * @function
         * @param {String} text The input text.
         * @param {Object} options An object containing the following fields:
         *
         *  - `json` (Boolean): If `true`, the result will be an object.
         *  - `use_classes` (Boolean): If `true`, HTML classes will be appended to the HTML output.
         *
         * @param {Boolean} markup If false, the colors will not be parsed.
         * @return {Object} The result object:
         *
         *  - `content` (String): The text.
         *  - `fg` (String|null): The foreground color.
         *  - `bg` (String|null): The background color.
         *  - `fg_truecolor` (String|null): The foreground true color (if 16m color is enabled).
         *  - `bg_truecolor` (String|null): The background true color (if 16m color is enabled).
         *  - `clearLine` (Boolean): `true` if a carriageReturn \r was fount at end of line.
         *  - `was_processed` (Bolean): `true` if the colors were processed, `false` otherwise.
         *  - `isEmpty` (Function): A function returning `true` if the content is empty, or `false` otherwise.
         *
         */

    }, {
        key: "processChunkJson",
        value: function processChunkJson(text, options, markup) {

            // Are we using classes or styles?
            options = typeof options == "undefined" ? {} : options;
            var use_classes = options.use_classes = typeof options.use_classes != "undefined" && options.use_classes;
            var key = options.key = use_classes ? "class" : "color";

            var result = {
                content: text,
                fg: null,
                bg: null,
                fg_truecolor: null,
                bg_truecolor: null,
                isInverted: false,
                clearLine: options.clearLine,
                decoration: null,
                decorations: [],
                was_processed: false,
                isEmpty: function isEmpty() {
                    return !result.content;
                }
            };

            // Each "chunk" is the text after the CSI (ESC + "[") and before the next CSI/EOF.
            //
            // This regex matches four groups within a chunk.
            //
            // The first and third groups match code type.
            // We supported only SGR command. It has empty first group and "m" in third.
            //
            // The second group matches all of the number+semicolon command sequences
            // before the "m" (or other trailing) character.
            // These are the graphics or SGR commands.
            //
            // The last group is the text (including newlines) that is colored by
            // the other group"s commands.
            var matches = text.match(/^([!\x3c-\x3f]*)([\d;]*)([\x20-\x2c]*[\x40-\x7e])([\s\S]*)/m);

            if (!matches) return result;

            var orig_txt = result.content = matches[4];
            var nums = matches[2].split(";");

            // We currently support only "SGR" (Select Graphic Rendition)
            // Simply ignore if not a SGR command.
            if (matches[1] !== "" || matches[3] !== "m") {
                return result;
            }

            if (!markup) {
                return result;
            }

            var self = this;

            while (nums.length > 0) {
                var num_str = nums.shift();
                var num = parseInt(num_str);

                if (isNaN(num) || num === 0) {
                    self.fg = self.bg = null;
                    self.decorations = [];
                } else if (num === 1) {
                    self.decorations.push("bold");
                } else if (num === 2) {
                    self.decorations.push("dim");
                    // Enable code 2 to get string
                } else if (num === 3) {
                    self.decorations.push("italic");
                } else if (num === 4) {
                    self.decorations.push("underline");
                } else if (num === 5) {
                    self.decorations.push("blink");
                } else if (num === 7) {
                    self.decorations.push("reverse");
                } else if (num === 8) {
                    self.decorations.push("hidden");
                    // Enable code 9 to get strikethrough
                } else if (num === 9) {
                    self.decorations.push("strikethrough");
                    /**
                     * Add several widely used style codes
                     * @see https://en.wikipedia.org/wiki/ANSI_escape_code#SGR_(Select_Graphic_Rendition)_parameters
                     */
                } else if (num === 21) {
                    self.removeDecoration("bold");
                } else if (num === 22) {
                    self.removeDecoration("bold");
                    self.removeDecoration("dim");
                } else if (num === 23) {
                    self.removeDecoration("italic");
                } else if (num === 24) {
                    self.removeDecoration("underline");
                } else if (num === 25) {
                    self.removeDecoration("blink");
                } else if (num === 27) {
                    self.removeDecoration("reverse");
                } else if (num === 28) {
                    self.removeDecoration("hidden");
                } else if (num === 29) {
                    self.removeDecoration("strikethrough");
                } else if (num === 39) {
                    self.fg = null;
                } else if (num === 49) {
                    self.bg = null;
                    // Foreground color
                } else if (num >= 30 && num < 38) {
                    self.fg = ANSI_COLORS[0][num % 10][key];
                    // Foreground bright color
                } else if (num >= 90 && num < 98) {
                    self.fg = ANSI_COLORS[1][num % 10][key];
                    // Background color
                } else if (num >= 40 && num < 48) {
                    self.bg = ANSI_COLORS[0][num % 10][key];
                    // Background bright color
                } else if (num >= 100 && num < 108) {
                    self.bg = ANSI_COLORS[1][num % 10][key];
                } else if (num === 38 || num === 48) {
                    // extend color (38=fg, 48=bg)
                    var is_foreground = num === 38;
                    if (nums.length >= 1) {
                        var mode = nums.shift();
                        if (mode === "5" && nums.length >= 1) {
                            // palette color
                            var palette_index = parseInt(nums.shift());
                            if (palette_index >= 0 && palette_index <= 255) {
                                if (!use_classes) {
                                    if (!this.PALETTE_COLORS) {
                                        self.setupPalette();
                                    }
                                    if (is_foreground) {
                                        self.fg = this.PALETTE_COLORS[palette_index];
                                    } else {
                                        self.bg = this.PALETTE_COLORS[palette_index];
                                    }
                                } else {
                                    var klass = palette_index >= 16 ? "ansi-palette-" + palette_index : ANSI_COLORS[palette_index > 7 ? 1 : 0][palette_index % 8]["class"];
                                    if (is_foreground) {
                                        self.fg = klass;
                                    } else {
                                        self.bg = klass;
                                    }
                                }
                            }
                        } else if (mode === "2" && nums.length >= 3) {
                            // true color
                            var r = parseInt(nums.shift());
                            var g = parseInt(nums.shift());
                            var b = parseInt(nums.shift());
                            if (r >= 0 && r <= 255 && g >= 0 && g <= 255 && b >= 0 && b <= 255) {
                                var color = r + ", " + g + ", " + b;
                                if (!use_classes) {
                                    if (is_foreground) {
                                        self.fg = color;
                                    } else {
                                        self.bg = color;
                                    }
                                } else {
                                    if (is_foreground) {
                                        self.fg = "ansi-truecolor";
                                        self.fg_truecolor = color;
                                    } else {
                                        self.bg = "ansi-truecolor";
                                        self.bg_truecolor = color;
                                    }
                                }
                            }
                        }
                    }
                }
            }

            if (self.fg === null && self.bg === null && self.decorations.length === 0) {
                return result;
            } else {
                var styles = [];
                var classes = [];
                var data = {};

                result.fg = self.fg;
                result.bg = self.bg;
                result.fg_truecolor = self.fg_truecolor;
                result.bg_truecolor = self.bg_truecolor;
                result.decorations = self.decorations;
                result.decoration = self.decorations.slice(-1).pop() || null;
                result.was_processed = true;

                return result;
            }
        }

        /**
         * processChunk
         * Processes the current chunk of text.
         *
         * @name processChunk
         * @function
         * @param {String} text The input text.
         * @param {Object} options An object containing the following fields:
         *
         *  - `json` (Boolean): If `true`, the result will be an object.
         *  - `use_classes` (Boolean): If `true`, HTML classes will be appended to the HTML output.
         *
         * @param {Boolean} markup If false, the colors will not be parsed.
         * @return {Object|String} The result (object if `json` is wanted back or string otherwise).
         */

    }, {
        key: "processChunk",
        value: function processChunk(text, options, markup) {
            var _this2 = this;

            options = options || {};
            var jsonChunk = this.processChunkJson(text, options, markup);
            var use_classes = options.use_classes;

            // "reverse" decoration reverses foreground and background colors
            jsonChunk.decorations = jsonChunk.decorations.filter(function (decoration) {
                if (decoration === "reverse") {
                    // when reversing, missing colors are defaulted to black (bg) and white (fg)
                    if (!jsonChunk.fg) {
                        jsonChunk.fg = ANSI_COLORS[0][7][use_classes ? "class" : "color"];
                    }
                    if (!jsonChunk.bg) {
                        jsonChunk.bg = ANSI_COLORS[0][0][use_classes ? "class" : "color"];
                    }
                    var tmpFg = jsonChunk.fg;
                    jsonChunk.fg = jsonChunk.bg;
                    jsonChunk.bg = tmpFg;
                    var tmpFgTrue = jsonChunk.fg_truecolor;
                    jsonChunk.fg_truecolor = jsonChunk.bg_truecolor;
                    jsonChunk.bg_truecolor = tmpFgTrue;
                    jsonChunk.isInverted = true;
                    return false;
                }
                return true;
            });

            if (options.json) {
                return jsonChunk;
            }
            if (jsonChunk.isEmpty()) {
                return "";
            }
            if (!jsonChunk.was_processed) {
                return jsonChunk.content;
            }

            var colors = [];
            var decorations = [];
            var textDecorations = [];
            var data = {};

            var render_data = function render_data(data) {
                var fragments = [];
                var key = void 0;
                for (key in data) {
                    if (data.hasOwnProperty(key)) {
                        fragments.push("data-" + key + "=\"" + _this2.escapeForHtml(data[key]) + "\"");
                    }
                }
                return fragments.length > 0 ? " " + fragments.join(" ") : "";
            };

            if (jsonChunk.isInverted) {
                data["ansi-is-inverted"] = "true";
            }

            if (jsonChunk.fg) {
                if (use_classes) {
                    colors.push(jsonChunk.fg + "-fg");
                    if (jsonChunk.fg_truecolor !== null) {
                        data["ansi-truecolor-fg"] = jsonChunk.fg_truecolor;
                        jsonChunk.fg_truecolor = null;
                    }
                } else {
                    colors.push("color:rgb(" + jsonChunk.fg + ")");
                }
            }

            if (jsonChunk.bg) {
                if (use_classes) {
                    colors.push(jsonChunk.bg + "-bg");
                    if (jsonChunk.bg_truecolor !== null) {
                        data["ansi-truecolor-bg"] = jsonChunk.bg_truecolor;
                        jsonChunk.bg_truecolor = null;
                    }
                } else {
                    colors.push("background-color:rgb(" + jsonChunk.bg + ")");
                }
            }

            jsonChunk.decorations.forEach(function (decoration) {
                // use classes
                if (use_classes) {
                    decorations.push("ansi-" + decoration);
                    return;
                }
                // use styles
                if (decoration === "bold") {
                    decorations.push("font-weight:bold");
                } else if (decoration === "dim") {
                    decorations.push("opacity:0.5");
                } else if (decoration === "italic") {
                    decorations.push("font-style:italic");
                } else if (decoration === "hidden") {
                    decorations.push("visibility:hidden");
                } else if (decoration === "strikethrough") {
                    textDecorations.push("line-through");
                } else {
                    // underline and blink are treated here
                    textDecorations.push(decoration);
                }
            });

            if (textDecorations.length) {
                decorations.push("text-decoration:" + textDecorations.join(" "));
            }

            if (use_classes) {
                return "<span class=\"" + colors.concat(decorations).join(" ") + "\"" + render_data(data) + ">" + jsonChunk.content + "</span>";
            } else {
                return "<span style=\"" + colors.concat(decorations).join(";") + "\"" + render_data(data) + ">" + jsonChunk.content + "</span>";
            }
        }
    }, {
        key: "removeDecoration",
        value: function removeDecoration(decoration) {
            var index = this.decorations.indexOf(decoration);

            if (index >= 0) {
                this.decorations.splice(index, 1);
            }
        }
    }]);

    return Anser;
}();

module.exports = Anser;

/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_debug_lib_browser_debug-session-manager_js.js.map