/// <reference types="node" />
/// <reference types="node" />
/*********************************************************************
 * Copyright (c) 2018 QNX Software Systems and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
import * as events from 'events';
import { Writable } from 'stream';
import { AttachRequestArguments, LaunchRequestArguments } from '../types/session';
import { MIBreakpointInsertOptions, MIBreakpointLocation, MIShowResponse } from '../mi';
import { VarManager } from '../varManager';
import { IGDBBackend, IGDBProcessManager, IStdioProcess } from '../types/gdb';
import { MIParser } from '../MIParser';
export declare class GDBBackend extends events.EventEmitter implements IGDBBackend {
    protected readonly processManager: IGDBProcessManager;
    protected parser: MIParser;
    protected varMgr: VarManager;
    protected out?: Writable;
    protected token: number;
    protected proc?: IStdioProcess;
    private gdbVersion?;
    protected gdbAsync: boolean;
    protected gdbNonStop: boolean;
    protected hardwareBreakpoint: boolean;
    constructor(processManager: IGDBProcessManager);
    get varManager(): VarManager;
    spawn(requestArgs: LaunchRequestArguments | AttachRequestArguments): Promise<void>;
    setAsyncMode(isSet?: boolean): Promise<void>;
    getAsyncMode(): boolean;
    setNonStopMode(isSet?: boolean): Promise<void>;
    isNonStopMode(): boolean;
    getBreakpointOptions(_: MIBreakpointLocation, initialOptions: MIBreakpointInsertOptions): Promise<MIBreakpointInsertOptions>;
    isUseHWBreakpoint(): boolean;
    pause(threadId?: number): void;
    gdbVersionAtLeast(targetVersion: string): boolean;
    sendCommands(commands?: string[]): Promise<void>;
    sendCommand<T>(command: string): Promise<T>;
    sendEnablePrettyPrint(): Promise<unknown>;
    standardEscape(arg: string, needQuotes?: boolean): string;
    sendFileExecAndSymbols(program: string): Promise<unknown>;
    sendFileSymbolFile(symbols: string): Promise<unknown>;
    sendAddSymbolFile(symbols: string, offset: string): Promise<unknown>;
    sendLoad(imageFileName: string, imageOffset: string | undefined): Promise<unknown>;
    sendGDBSet(params: string): Promise<unknown>;
    sendGDBShow(params: string): Promise<MIShowResponse>;
    sendGDBExit(): Promise<unknown>;
    protected nextToken(): number;
}
