/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CUCorrectionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class CorrectPackageDeclarationProposal
extends CUCorrectionProposal {
    private IProblemLocationCore fLocation;

    public CorrectPackageDeclarationProposal(ICompilationUnit cu, IProblemLocationCore location, int relevance) {
        super(CorrectionMessages.CorrectPackageDeclarationProposal_name, "quickfix", cu, null, relevance);
        this.fLocation = location;
    }

    @Override
    protected void addEdits(IDocument doc, TextEdit root) throws CoreException {
        super.addEdits(doc, root);
        ICompilationUnit cu = this.getCompilationUnit();
        IPackageFragment parentPack = (IPackageFragment)cu.getParent();
        IPackageDeclaration[] decls = cu.getPackageDeclarations();
        if (parentPack.isDefaultPackage() && decls.length > 0) {
            int i = 0;
            while (i < decls.length) {
                ISourceRange range = decls[i].getSourceRange();
                root.addChild((TextEdit)new DeleteEdit(range.getOffset(), range.getLength()));
                ++i;
            }
            return;
        }
        if (!parentPack.isDefaultPackage() && decls.length == 0) {
            String lineDelim = "\n";
            String str = "package " + parentPack.getElementName() + ";" + lineDelim + lineDelim;
            root.addChild((TextEdit)new InsertEdit(0, str));
            return;
        }
        root.addChild((TextEdit)new ReplaceEdit(this.fLocation.getOffset(), this.fLocation.getLength(), parentPack.getElementName()));
    }

    public String getName() {
        ICompilationUnit cu = this.getCompilationUnit();
        IPackageFragment parentPack = (IPackageFragment)cu.getParent();
        try {
            IPackageDeclaration[] decls = cu.getPackageDeclarations();
            if (parentPack.isDefaultPackage() && decls.length > 0) {
                return Messages.format(CorrectionMessages.CorrectPackageDeclarationProposal_remove_description, BasicElementLabels.getJavaElementName((String)decls[0].getElementName()));
            }
            if (!parentPack.isDefaultPackage() && decls.length == 0) {
                return Messages.format(CorrectionMessages.CorrectPackageDeclarationProposal_add_description, JavaElementLabelsCore.getElementLabel((IJavaElement)parentPack, (long)0x200009L));
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.log((CoreException)((Object)e));
        }
        return Messages.format(CorrectionMessages.CorrectPackageDeclarationProposal_change_description, JavaElementLabelsCore.getElementLabel((IJavaElement)parentPack, (long)0x200009L));
    }
}

