/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public abstract class JavaElementResourceMapping
extends ResourceMapping {
    protected JavaElementResourceMapping() {
    }

    public IJavaElement getJavaElement() {
        Object o = this.getModelObject();
        if (o instanceof IJavaElement) {
            return (IJavaElement)o;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JavaElementResourceMapping)) {
            return false;
        }
        return this.getJavaElement().equals(((JavaElementResourceMapping)((Object)obj)).getJavaElement());
    }

    public int hashCode() {
        IJavaElement javaElement = this.getJavaElement();
        if (javaElement == null) {
            return super.hashCode();
        }
        return javaElement.hashCode();
    }

    public String getModelProviderId() {
        return "";
    }

    public boolean contains(ResourceMapping mapping) {
        if (mapping instanceof JavaElementResourceMapping) {
            JavaElementResourceMapping javaMapping = (JavaElementResourceMapping)mapping;
            IJavaElement element = this.getJavaElement();
            IJavaElement other = javaMapping.getJavaElement();
            if (other != null && element != null) {
                return element.getPath().isPrefixOf(other.getPath());
            }
        }
        return false;
    }

    private static ResourceTraversal[] getPackageFragmentTraversals(IPackageFragment pack) throws CoreException {
        ArrayList<ResourceTraversal> res = new ArrayList<ResourceTraversal>();
        IContainer container = (IContainer)pack.getResource();
        if (container != null) {
            res.add(new ResourceTraversal(new IResource[]{container}, 1, 0));
            if (pack.exists()) {
                Object[] nonJavaResources = pack.getNonJavaResources();
                int i = 0;
                while (i < nonJavaResources.length) {
                    Object resource = nonJavaResources[i];
                    if (resource instanceof IFolder) {
                        res.add(new ResourceTraversal(new IResource[]{(IResource)resource}, 2, 0));
                    }
                    ++i;
                }
            }
        }
        return res.toArray(new ResourceTraversal[res.size()]);
    }

    private static ResourceTraversal[] getRemotePackageFragmentTraversals(IPackageFragment pack, RemoteResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        ArrayList<ResourceTraversal> res = new ArrayList<ResourceTraversal>();
        IContainer container = (IContainer)pack.getResource();
        if (container != null) {
            res.add(new ResourceTraversal(new IResource[]{container}, 1, 0));
            IResource[] remoteMembers = context.fetchRemoteMembers(container, monitor);
            if (remoteMembers == null) {
                remoteMembers = context.fetchMembers(container, monitor);
            }
            if (remoteMembers != null) {
                int i = 0;
                while (i < remoteMembers.length) {
                    IResource member = remoteMembers[i];
                    if (member instanceof IFolder && JavaConventionsUtil.validatePackageName((String)member.getName(), (IJavaElement)pack).getSeverity() == 4) {
                        res.add(new ResourceTraversal(new IResource[]{member}, 2, 0));
                    }
                    ++i;
                }
            }
        }
        return res.toArray(new ResourceTraversal[res.size()]);
    }

    public static ResourceMapping create(IJavaElement element) {
        switch (element.getElementType()) {
            case 7: {
                return JavaElementResourceMapping.create((IType)element);
            }
            case 5: {
                return JavaElementResourceMapping.create((ICompilationUnit)element);
            }
            case 6: {
                return JavaElementResourceMapping.create((IClassFile)element);
            }
            case 4: {
                return JavaElementResourceMapping.create((IPackageFragment)element);
            }
            case 3: {
                return JavaElementResourceMapping.create((IPackageFragmentRoot)element);
            }
            case 2: {
                return JavaElementResourceMapping.create((IJavaProject)element);
            }
            case 1: {
                return JavaElementResourceMapping.create((IJavaModel)element);
            }
        }
        return null;
    }

    public static ResourceMapping create(IJavaModel model) {
        return new JavaModelResourceMapping(model);
    }

    public static ResourceMapping create(IJavaProject project) {
        return new JavaProjectResourceMapping(project);
    }

    public static ResourceMapping create(IPackageFragmentRoot root) {
        if (root.isExternal()) {
            return null;
        }
        return new PackageFragementRootResourceMapping(root);
    }

    public static ResourceMapping create(IPackageFragment pack) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)pack.getAncestor(3);
        if (!root.isArchive() && !root.isExternal()) {
            return new PackageFragmentResourceMapping(pack);
        }
        return null;
    }

    public static ResourceMapping create(ICompilationUnit unit) {
        if (unit == null) {
            return null;
        }
        return new CompilationUnitResourceMapping(unit.getPrimary());
    }

    public static ResourceMapping create(IClassFile classFile) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)classFile.getAncestor(3);
        if (!root.isArchive() && !root.isExternal()) {
            return new ClassFileResourceMapping(classFile);
        }
        return null;
    }

    public static ResourceMapping create(IType type) {
        IJavaElement parent = type.getParent();
        if (parent instanceof ICompilationUnit) {
            return JavaElementResourceMapping.create((ICompilationUnit)parent);
        }
        return null;
    }

    private static final class ClassFileResourceMapping
    extends JavaElementResourceMapping {
        private final IClassFile fClassFile;

        private ClassFileResourceMapping(IClassFile classFile) {
            this.fClassFile = classFile;
        }

        public Object getModelObject() {
            return this.fClassFile;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fClassFile.getJavaProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fClassFile.getResource()}, 1, 0)};
        }
    }

    private static final class CompilationUnitResourceMapping
    extends JavaElementResourceMapping {
        private final ICompilationUnit fUnit;

        private CompilationUnitResourceMapping(ICompilationUnit unit) {
            Assert.isNotNull((Object)unit);
            this.fUnit = unit;
        }

        public Object getModelObject() {
            return this.fUnit;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fUnit.getJavaProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fUnit.getResource()}, 1, 0)};
        }
    }

    private static final class JavaModelResourceMapping
    extends JavaElementResourceMapping {
        private final IJavaModel fJavaModel;

        private JavaModelResourceMapping(IJavaModel model) {
            Assert.isNotNull((Object)model);
            this.fJavaModel = model;
        }

        public Object getModelObject() {
            return this.fJavaModel;
        }

        public IProject[] getProjects() {
            IJavaProject[] projects = null;
            try {
                projects = this.fJavaModel.getJavaProjects();
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.log((CoreException)((Object)e));
                return new IProject[0];
            }
            IProject[] result = new IProject[projects.length];
            int i = 0;
            while (i < projects.length) {
                result[i] = projects[i].getProject();
                ++i;
            }
            return result;
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            IJavaProject[] projects = this.fJavaModel.getJavaProjects();
            ResourceTraversal[] result = new ResourceTraversal[projects.length];
            int i = 0;
            while (i < projects.length) {
                result[i] = new ResourceTraversal(new IResource[]{projects[i].getProject()}, 2, 0);
                ++i;
            }
            return result;
        }
    }

    private static final class JavaProjectResourceMapping
    extends JavaElementResourceMapping {
        private final IJavaProject fProject;

        private JavaProjectResourceMapping(IJavaProject project) {
            Assert.isNotNull((Object)project);
            this.fProject = project;
        }

        public Object getModelObject() {
            return this.fProject;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fProject.getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fProject.getProject()}, 2, 0)};
        }
    }

    private static final class LogicalPackageResourceMapping
    extends ResourceMapping {
        private final IPackageFragment[] fFragments;

        private LogicalPackageResourceMapping(IPackageFragment[] fragments) {
            this.fFragments = fragments;
        }

        public Object getModelObject() {
            return this.fFragments;
        }

        public IProject[] getProjects() {
            HashSet<IProject> result = new HashSet<IProject>();
            int i = 0;
            while (i < this.fFragments.length) {
                result.add(this.fFragments[i].getJavaProject().getProject());
                ++i;
            }
            return result.toArray(new IProject[result.size()]);
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            ArrayList<ResourceTraversal> result = new ArrayList<ResourceTraversal>();
            if (context instanceof RemoteResourceMappingContext) {
                int i = 0;
                while (i < this.fFragments.length) {
                    result.addAll(Arrays.asList(JavaElementResourceMapping.getRemotePackageFragmentTraversals(this.fFragments[i], (RemoteResourceMappingContext)context, monitor)));
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.fFragments.length) {
                    result.addAll(Arrays.asList(JavaElementResourceMapping.getPackageFragmentTraversals(this.fFragments[i])));
                    ++i;
                }
            }
            return result.toArray(new ResourceTraversal[result.size()]);
        }

        public String getModelProviderId() {
            return "";
        }
    }

    private static final class PackageFragementRootResourceMapping
    extends JavaElementResourceMapping {
        private final IPackageFragmentRoot fRoot;

        private PackageFragementRootResourceMapping(IPackageFragmentRoot root) {
            Assert.isNotNull((Object)root);
            this.fRoot = root;
        }

        public Object getModelObject() {
            return this.fRoot;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fRoot.getJavaProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fRoot.getResource()}, 2, 0)};
        }
    }

    private static final class PackageFragmentResourceMapping
    extends JavaElementResourceMapping {
        private final IPackageFragment fPack;

        private PackageFragmentResourceMapping(IPackageFragment pack) {
            Assert.isNotNull((Object)pack);
            this.fPack = pack;
        }

        public Object getModelObject() {
            return this.fPack;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fPack.getJavaProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            if (context instanceof RemoteResourceMappingContext) {
                return JavaElementResourceMapping.getRemotePackageFragmentTraversals(this.fPack, (RemoteResourceMappingContext)context, monitor);
            }
            return JavaElementResourceMapping.getPackageFragmentTraversals(this.fPack);
        }
    }
}

