/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.ls.core.internal.AbstractProjectImporter;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.BasicFileDetector;
import org.eclipse.jdt.ls.core.internal.managers.DigestStore;
import org.eclipse.jdt.ls.core.internal.managers.MavenBuildSupport;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.preferences.MavenConfigurationImpl;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.project.IMavenProjectImportResult;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.LocalProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class MavenProjectImporter
extends AbstractProjectImporter {
    private static final int MAX_PROJECTS_TO_IMPORT = 50;
    private static final long MAX_MEMORY = 0x60000000L;
    public static final String IMPORTING_MAVEN_PROJECTS = "Importing Maven project(s)";
    public static final String POM_FILE = "pom.xml";
    private static final String DUPLICATE_ARTIFACT_TEMPLATE = "[groupId]-[artifactId]";
    private static final String STATE_FILENAME = "workspaceState.ser";
    private Set<MavenProjectInfo> projectInfos = null;
    private IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
    private DigestStore digestStore = JavaLanguageServerPlugin.getDigestStore();

    @Override
    public boolean applies(IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferencesManager != null && !preferencesManager.getPreferences().isImportMavenEnabled()) {
            return false;
        }
        if (this.directories == null) {
            BasicFileDetector mavenDetector = new BasicFileDetector(this.rootFolder.toPath(), POM_FILE).includeNested(false).addExclusions("**/target");
            IProject[] iProjectArray = ProjectUtils.getAllProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (!ProjectUtils.isMavenProject(project)) {
                    String path = project.getLocation().toOSString();
                    mavenDetector.addExclusions(path);
                }
                ++n2;
            }
            this.directories = mavenDetector.scan(monitor);
        }
        return !this.directories.isEmpty();
    }

    @Override
    public boolean applies(Collection<IPath> buildFiles, IProgressMonitor monitor) {
        if (!MavenProjectImporter.getPreferences().isImportMavenEnabled()) {
            return false;
        }
        Collection<java.nio.file.Path> configurationDirs = this.findProjectPathByConfigurationName(buildFiles, Arrays.asList(POM_FILE), true);
        if (configurationDirs == null || configurationDirs.isEmpty()) {
            return false;
        }
        HashSet<java.nio.file.Path> noneMavenProjectPaths = new HashSet<java.nio.file.Path>();
        IProject[] iProjectArray = ProjectUtils.getAllProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!ProjectUtils.isMavenProject(project)) {
                noneMavenProjectPaths.add(project.getLocation().toFile().toPath());
            }
            ++n2;
        }
        this.directories = configurationDirs.stream().filter(d -> {
            boolean folderIsImported = noneMavenProjectPaths.stream().anyMatch(path2 -> path2.compareTo((java.nio.file.Path)d) == 0);
            return !folderIsImported;
        }).collect(Collectors.toList());
        return !this.directories.isEmpty();
    }

    synchronized Set<MavenProjectInfo> getMavenProjectInfo(IProgressMonitor monitor) throws OperationCanceledException {
        if (this.projectInfos == null) {
            this.projectInfos = this.collectMavenProjectInfo(monitor);
        }
        return this.projectInfos;
    }

    Set<MavenProjectInfo> collectMavenProjectInfo(IProgressMonitor monitor) throws OperationCanceledException {
        MavenModelManager modelManager = MavenPlugin.getMavenModelManager();
        return this.getMavenProjects(this.getProjectDirectory(), modelManager, monitor);
    }

    @Override
    public void reset() {
        this.projectInfos = null;
    }

    @Override
    public void importToWorkspace(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        JavaLanguageServerPlugin.logInfo(IMPORTING_MAVEN_PROJECTS);
        MavenConfigurationImpl configurationImpl = (MavenConfigurationImpl)MavenPlugin.getMavenConfiguration();
        configurationImpl.setDownloadSources(JavaLanguageServerPlugin.getPreferencesManager().getPreferences().isMavenDownloadSources());
        configurationImpl.setNotCoveredMojoExecutionSeverity(JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getMavenNotCoveredPluginExecutionSeverity());
        PluginExecutionAction action = PluginExecutionAction.valueOf((String)JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getMavenDefaultMojoExecutionAction());
        configurationImpl.setDefaultMojoExecutionAction(action);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)105);
        subMonitor.setTaskName(IMPORTING_MAVEN_PROJECTS);
        Set<MavenProjectInfo> files = this.getMavenProjectInfo((IProgressMonitor)subMonitor.split(5));
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        LinkedHashSet<IProject> projects = new LinkedHashSet<IProject>();
        LinkedHashSet<MavenProjectInfo> toImport = new LinkedHashSet<MavenProjectInfo>();
        long lastWorkspaceStateSaved = this.getLastWorkspaceStateModified();
        LinkedHashSet<String> artifactIds = new LinkedHashSet<String>();
        for (MavenProjectInfo projectInfo : files) {
            boolean valid;
            MavenProjectInfo parentInfo;
            File parentPom;
            IContainer parentContainer;
            File pom = projectInfo.getPomFile();
            IContainer container = root.getContainerForLocation((IPath)new Path(pom.getAbsolutePath()));
            if (container != null && projectInfo.getParent() != null && (parentContainer = root.getContainerForLocation((IPath)new Path((parentPom = (parentInfo = projectInfo.getParent()).getPomFile()).getAbsolutePath()))) != null && Objects.equals(container.getProject(), parentContainer.getProject())) {
                container = null;
            }
            if (container == null) {
                this.digestStore.updateDigest(pom.toPath());
                toImport.add(projectInfo);
                artifactIds.add(projectInfo.getModel().getArtifactId());
                continue;
            }
            IProject project = container.getProject();
            boolean bl = valid = !ProjectUtils.isJavaProject(project) || project.getFile(".classpath").exists();
            if (ProjectUtils.isMavenProject(project) && valid) {
                projects.add(container.getProject());
                continue;
            }
            if (project == null) continue;
            this.digestStore.updateDigest(pom.toPath());
            project.delete(9, (IProgressMonitor)subMonitor.split(5));
            toImport.add(projectInfo);
            artifactIds.add(projectInfo.getModel().getArtifactId());
        }
        if (!toImport.isEmpty()) {
            ProjectImportConfiguration importConfig = new ProjectImportConfiguration();
            if (toImport.size() > artifactIds.size()) {
                importConfig.setProjectNameTemplate(DUPLICATE_ARTIFACT_TEMPLATE);
            }
            if (toImport.size() > 50 && Runtime.getRuntime().maxMemory() <= 0x60000000L) {
                JavaLanguageServerPlugin.logInfo("Projects size:" + toImport.size());
                Iterator iter = toImport.iterator();
                ArrayList results = new ArrayList(50);
                SubMonitor monitor2 = SubMonitor.convert((IProgressMonitor)monitor, (int)(toImport.size() * 2));
                int it = 1;
                while (iter.hasNext()) {
                    int percent = Math.min(100, it++ * 100 * 50 / (toImport.size() + 1));
                    monitor2.setTaskName(percent + "% Importing Maven project(s)");
                    ArrayList<MavenProjectInfo> importPartial = new ArrayList<MavenProjectInfo>();
                    int i = 0;
                    while (i++ < 50 && iter.hasNext()) {
                        importPartial.add((MavenProjectInfo)iter.next());
                    }
                    List result = this.configurationManager.importProjects(importPartial, importConfig, (IProgressMonitor)monitor2.split(50));
                    results.addAll(result);
                    monitor2.setWorkRemaining(toImport.size() * 2 - it * 50);
                }
                ArrayList<IProject> imported = new ArrayList<IProject>(results.size());
                for (IMavenProjectImportResult result : results) {
                    imported.add(result.getProject());
                }
                monitor2.setTaskName("Updating Maven project(s)");
                this.updateProjects(imported, lastWorkspaceStateSaved, (IProgressMonitor)monitor2.split(projects.size()));
                monitor2.done();
            } else {
                this.configurationManager.importProjects(toImport, importConfig, (IProgressMonitor)subMonitor.split(75));
            }
        }
        subMonitor.setWorkRemaining(20);
        this.updateProjects(projects, lastWorkspaceStateSaved, (IProgressMonitor)subMonitor.split(20));
        subMonitor.done();
    }

    private long getLastWorkspaceStateModified() {
        Bundle bundle = FrameworkUtil.getBundle(IMaven.class);
        if (bundle != null) {
            IPath result = Platform.getStateLocation((Bundle)bundle);
            File bundleStateLocation = result.toFile();
            File workspaceStateFile = new File(bundleStateLocation, STATE_FILENAME);
            return workspaceStateFile.lastModified();
        }
        return 0L;
    }

    private File getProjectDirectory() {
        return this.rootFolder;
    }

    private void updateProjects(final Collection<IProject> projects, long lastWorkspaceStateSaved, IProgressMonitor monitor) throws CoreException {
        if (projects.isEmpty()) {
            return;
        }
        Iterator<IProject> iterator = projects.iterator();
        while (iterator.hasNext()) {
            IProject project = iterator.next();
            project.open(monitor);
            if ("win32".equals(Platform.getOS())) {
                project.refreshLocal(1, monitor);
                ((Workspace)ResourcesPlugin.getWorkspace()).getRefreshManager().refresh((IResource)project);
            } else {
                project.refreshLocal(2, monitor);
            }
            if (this.needsMavenUpdate(project, lastWorkspaceStateSaved)) continue;
            iterator.remove();
        }
        if (projects.isEmpty()) {
            return;
        }
        new WorkspaceJob("Update Maven project configuration"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                MavenBuildSupport mavenBuildSupport = new MavenBuildSupport();
                mavenBuildSupport.setShouldCollectProjects(false);
                for (IProject project : projects) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    mavenBuildSupport.update(project, false, monitor);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private boolean needsMavenUpdate(IProject project, long lastWorkspaceStateSaved) {
        return project.getFile(POM_FILE).getLocalTimeStamp() > lastWorkspaceStateSaved;
    }

    private Set<MavenProjectInfo> getMavenProjects(File directory, MavenModelManager modelManager, IProgressMonitor monitor) throws OperationCanceledException {
        if (directory == null || this.directories == null || this.directories.isEmpty()) {
            return Collections.emptySet();
        }
        try {
            List folders = this.directories.stream().map(java.nio.file.Path::toAbsolutePath).map(Object::toString).collect(Collectors.toList());
            LocalProjectScanner scanner = new LocalProjectScanner(folders, false, modelManager);
            scanner.run(monitor);
            return this.collectProjects(scanner.getProjects());
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException();
        }
    }

    public boolean isMavenProject() {
        return this.isMavenProject(this.getProjectDirectory());
    }

    private boolean isMavenProject(File dir) {
        if (!this.isReadable(dir) || !dir.isDirectory()) {
            return false;
        }
        return this.isReadable(new File(dir, POM_FILE));
    }

    private boolean isReadable(File destination) {
        return destination != null && destination.canRead();
    }

    public Set<MavenProjectInfo> collectProjects(Collection<MavenProjectInfo> projects) {
        return new LinkedHashSet<MavenProjectInfo>(){
            private static final long serialVersionUID = 1L;

            public Set<MavenProjectInfo> collectProjects(Collection<MavenProjectInfo> projects) {
                for (MavenProjectInfo projectInfo : projects) {
                    this.add(projectInfo);
                    this.collectProjects(projectInfo.getProjects());
                }
                return this;
            }
        }.collectProjects(projects);
    }
}

