/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javadoc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IModularClassFile;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class JavaDocLocations {
    private static final String JAR_PROTOCOL = "jar";
    public static final String ARCHIVE_PREFIX = "jar:";
    private static final QualifiedName PROJECT_JAVADOC = new QualifiedName("test", "project_javadoc_location");

    public static void setProjectJavadocLocation(IJavaProject project, URL url) {
        try {
            String location = url != null ? url.toExternalForm() : null;
            JavaDocLocations.setProjectJavadocLocation(project, location);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private static void setProjectJavadocLocation(IJavaProject project, String url) throws CoreException {
        project.getProject().setPersistentProperty(PROJECT_JAVADOC, url);
    }

    public static URL getProjectJavadocLocation(IJavaProject project) {
        String prop;
        block4: {
            if (!project.getProject().isAccessible()) {
                return null;
            }
            try {
                prop = project.getProject().getPersistentProperty(PROJECT_JAVADOC);
                if (prop != null) break block4;
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return JavaDocLocations.parseURL(prop);
    }

    public static URL getLibraryJavadocLocation(IClasspathEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Entry must not be null");
        }
        int kind = entry.getEntryKind();
        if (kind != 1 && kind != 4) {
            throw new IllegalArgumentException("Entry must be of kind CPE_LIBRARY or CPE_VARIABLE");
        }
        IClasspathAttribute[] extraAttributes = entry.getExtraAttributes();
        int i = 0;
        while (i < extraAttributes.length) {
            IClasspathAttribute attrib = extraAttributes[i];
            if ("javadoc_location".equals(attrib.getName())) {
                return JavaDocLocations.parseURL(attrib.getValue());
            }
            ++i;
        }
        return null;
    }

    public static URL getJavadocBaseLocation(IJavaElement element) throws JavaModelException {
        if (element.getElementType() == 2) {
            return JavaDocLocations.getProjectJavadocLocation((IJavaProject)element);
        }
        IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot((IJavaElement)element);
        if (root == null) {
            return null;
        }
        if (root.getKind() == 2) {
            IClasspathEntry entry = root.getResolvedClasspathEntry();
            URL javadocLocation = JavaDocLocations.getLibraryJavadocLocation(entry);
            if (javadocLocation != null) {
                return JavaDocLocations.getLibraryJavadocLocation(entry);
            }
            entry = root.getRawClasspathEntry();
            switch (entry.getEntryKind()) {
                case 1: 
                case 4: {
                    return JavaDocLocations.getLibraryJavadocLocation(entry);
                }
            }
            return null;
        }
        return JavaDocLocations.getProjectJavadocLocation(root.getJavaProject());
    }

    /*
     * WARNING - void declaration
     */
    public static URL getJavadocLocation(IJavaElement element, boolean includeMemberReference) throws JavaModelException {
        URL baseLocation = JavaDocLocations.getJavadocBaseLocation(element);
        if (baseLocation == null) {
            return null;
        }
        String urlString = baseLocation.toExternalForm();
        StringBuffer urlBuffer = new StringBuffer(urlString);
        if (!urlString.endsWith("/")) {
            urlBuffer.append('/');
        }
        StringBuffer pathBuffer = new StringBuffer();
        StringBuffer fragmentBuffer = new StringBuffer();
        switch (element.getElementType()) {
            case 4: {
                JavaDocLocations.appendPackageSummaryPath((IPackageFragment)element, pathBuffer);
                break;
            }
            case 2: 
            case 3: {
                JavaDocLocations.appendIndexPath(pathBuffer);
                break;
            }
            case 12: {
                element = element.getParent();
            }
            case 5: {
                IType mainType = ((ICompilationUnit)element).findPrimaryType();
                if (mainType == null) {
                    return null;
                }
                JavaDocLocations.appendTypePath(mainType, pathBuffer);
                break;
            }
            case 6: {
                IJavaElement iJavaElement = element;
                if (iJavaElement instanceof IModularClassFile) {
                    IModularClassFile iModularClassFile = (IModularClassFile)iJavaElement;
                    IModularClassFile cfr_ignored_0 = (IModularClassFile)iJavaElement;
                    try {
                        void modularClassFile;
                        JavaDocLocations.appendModuleSummaryPath(modularClassFile.getModule(), pathBuffer);
                        break;
                    }
                    catch (JavaModelException e) {
                        return null;
                    }
                }
                JavaDocLocations.appendTypePath(((IOrdinaryClassFile)element).getType(), pathBuffer);
                break;
            }
            case 7: {
                JavaDocLocations.appendTypePath((IType)element, pathBuffer);
                break;
            }
            case 8: {
                IField field = (IField)element;
                JavaDocLocations.appendTypePath(field.getDeclaringType(), pathBuffer);
                if (!includeMemberReference) break;
                JavaDocLocations.appendFieldReference(field, fragmentBuffer);
                break;
            }
            case 9: {
                IMethod method = (IMethod)element;
                JavaDocLocations.appendTypePath(method.getDeclaringType(), pathBuffer);
                if (!includeMemberReference) break;
                JavaDocLocations.appendMethodReference(method, fragmentBuffer);
                break;
            }
            case 10: {
                JavaDocLocations.appendTypePath(((IMember)element).getDeclaringType(), pathBuffer);
                break;
            }
            case 13: {
                IImportDeclaration decl = (IImportDeclaration)element;
                if (decl.isOnDemand()) {
                    void pkg;
                    IJavaElement cont = JavaModelUtil.findTypeContainer((IJavaProject)element.getJavaProject(), (String)Signature.getQualifier((String)decl.getElementName()));
                    IJavaElement iJavaElement = cont;
                    if (iJavaElement instanceof IType) {
                        void type;
                        IType iType = (IType)iJavaElement;
                        IType cfr_ignored_1 = (IType)iJavaElement;
                        JavaDocLocations.appendTypePath((IType)type, pathBuffer);
                        break;
                    }
                    IJavaElement iJavaElement2 = cont;
                    if (!(iJavaElement2 instanceof IPackageFragment)) break;
                    IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement2;
                    IPackageFragment cfr_ignored_2 = (IPackageFragment)iJavaElement2;
                    JavaDocLocations.appendPackageSummaryPath((IPackageFragment)pkg, pathBuffer);
                    break;
                }
                IType imp = element.getJavaProject().findType(decl.getElementName());
                JavaDocLocations.appendTypePath(imp, pathBuffer);
                break;
            }
            case 11: {
                IJavaElement pack = element.getAncestor(4);
                if (pack != null) {
                    JavaDocLocations.appendPackageSummaryPath((IPackageFragment)pack, pathBuffer);
                    break;
                }
                return null;
            }
            case 17: {
                IModuleDescription module = (IModuleDescription)element;
                JavaDocLocations.appendModuleSummaryPath(module, pathBuffer);
                break;
            }
            default: {
                return null;
            }
        }
        try {
            String fragment = fragmentBuffer.length() == 0 ? null : fragmentBuffer.toString();
            try {
                URI relativeURI = new URI(null, null, pathBuffer.toString(), fragment);
                urlBuffer.append(relativeURI.toString());
                return new URL(urlBuffer.toString());
            }
            catch (URISyntaxException e) {
                return new URL(urlBuffer.append(pathBuffer).toString());
            }
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static void appendPackageSummaryPath(IPackageFragment pack, StringBuffer buf) {
        String packPath = pack.getElementName().replace('.', '/');
        buf.append(packPath);
        buf.append("/package-summary.html");
    }

    private static void appendModuleSummaryPath(IModuleDescription module, StringBuffer buf) {
        String moduleName = module.getElementName();
        buf.append(moduleName);
        buf.append("-summary.html");
    }

    private static void appendIndexPath(StringBuffer buf) {
        buf.append("index.html");
    }

    private static void appendTypePath(IType type, StringBuffer buf) {
        IPackageFragment pack = type.getPackageFragment();
        String packPath = pack.getElementName().replace('.', '/');
        String typePath = type.getTypeQualifiedName('.');
        if (packPath.length() > 0) {
            buf.append(packPath);
            buf.append('/');
        }
        buf.append(typePath);
        buf.append(".html");
    }

    private static void appendFieldReference(IField field, StringBuffer buf) {
        buf.append(field.getElementName());
    }

    private static void appendMethodReference(IMethod meth, StringBuffer buf) throws JavaModelException {
        buf.append(meth.getElementName());
        boolean is1d8OrHigher = JavaModelUtil.is1d8OrHigher((IJavaProject)meth.getJavaProject());
        buf.append(is1d8OrHigher ? (char)'-' : '(');
        String[] params = meth.getParameterTypes();
        IType declaringType = meth.getDeclaringType();
        boolean isVararg = Flags.isVarargs((int)meth.getFlags());
        int lastParam = params.length - 1;
        int i = 0;
        while (i <= lastParam) {
            String curr;
            String fullName;
            if (i != 0) {
                buf.append(is1d8OrHigher ? "-" : ", ");
            }
            if ((fullName = JavaModelUtil.getResolvedTypeName((String)(curr = Signature.getTypeErasure((String)params[i])), (IType)declaringType)) == null) {
                fullName = Signature.toString((String)Signature.getElementType((String)curr));
            }
            if (fullName != null) {
                buf.append(fullName);
                int dim = Signature.getArrayCount((String)curr);
                if (i == lastParam && isVararg) {
                    --dim;
                }
                while (dim > 0) {
                    buf.append(is1d8OrHigher ? ":A" : "[]");
                    --dim;
                }
                if (i == lastParam && isVararg) {
                    buf.append("...");
                }
            }
            ++i;
        }
        buf.append(is1d8OrHigher ? (char)'-' : ')');
    }

    public static String getBaseURL(IJavaElement element, boolean isBinary) throws JavaModelException {
        if (isBinary) {
            URL baseURL = JavaDocLocations.getJavadocLocation(element, false);
            if (baseURL != null) {
                baseURL.getProtocol().equals(JAR_PROTOCOL);
                return baseURL.toExternalForm();
            }
        } else {
            IPath location;
            IResource resource = element.getResource();
            if (resource != null && (location = resource.getLocation()) != null) {
                return location.toFile().toURI().toString();
            }
        }
        return null;
    }

    public static URL parseURL(String url) {
        try {
            try {
                return new URI(url).toURL();
            }
            catch (URISyntaxException e) {
                try {
                    if (url.startsWith("file:/")) {
                        return new URI("file", null, url.substring(5), null).toURL();
                    }
                    return URIUtil.fromString((String)url).toURL();
                }
                catch (URISyntaxException e1) {
                    return new URL(url);
                }
            }
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static File toFile(URL url) {
        try {
            return URIUtil.toFile((URI)url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(url.getFile());
        }
    }
}

