/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;

public abstract class AbstractMethodCorrectionProposal
extends ASTRewriteCorrectionProposal {
    private ASTNode fNode;
    private ITypeBinding fSenderBinding;

    public AbstractMethodCorrectionProposal(String label, ICompilationUnit targetCU, ASTNode invocationNode, ITypeBinding binding, int relevance) {
        super(label, "quickfix", targetCU, (ASTRewrite)null, relevance);
        Assert.isTrue((binding != null && Bindings.isDeclarationBinding((IBinding)binding) ? 1 : 0) != 0);
        this.fNode = invocationNode;
        this.fSenderBinding = binding;
    }

    protected ASTNode getInvocationNode() {
        return this.fNode;
    }

    protected ITypeBinding getSenderBinding() {
        return this.fSenderBinding;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        boolean isInDifferentCU;
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit((ASTNode)this.fNode);
        ASTNode typeDecl = astRoot.findDeclaringNode((IBinding)this.fSenderBinding);
        ASTNode newTypeDecl = null;
        if (typeDecl != null) {
            isInDifferentCU = false;
            newTypeDecl = typeDecl;
        } else {
            isInDifferentCU = true;
            astRoot = ASTResolving.createQuickFixAST((ICompilationUnit)this.getCompilationUnit(), null);
            newTypeDecl = astRoot.findDeclaringNode(this.fSenderBinding.getKey());
        }
        this.createImportRewrite(astRoot);
        if (newTypeDecl != null) {
            ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
            MethodDeclaration newStub = this.getStub(rewrite, newTypeDecl);
            ChildListPropertyDescriptor property = ASTNodes.getBodyDeclarationsProperty((ASTNode)newTypeDecl);
            List members = ASTNodes.getBodyDeclarations((ASTNode)newTypeDecl);
            int insertIndex = this.isConstructor() ? this.findConstructorInsertIndex(members) : (!isInDifferentCU ? this.findMethodInsertIndex(members, this.fNode.getStartPosition()) : members.size());
            ListRewrite listRewriter = rewrite.getListRewrite(newTypeDecl, property);
            listRewriter.insertAt((ASTNode)newStub, insertIndex, null);
            return rewrite;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private MethodDeclaration getStub(ASTRewrite rewrite, ASTNode targetTypeDecl) throws CoreException {
        block7: {
            context = new ContextSensitiveImportRewriteContext(targetTypeDecl, this.getImportRewrite());
            ast = targetTypeDecl.getAST();
            decl = ast.newMethodDeclaration();
            newNameNode = this.getNewName(rewrite);
            decl.setConstructor(this.isConstructor());
            this.addNewModifiers(rewrite, targetTypeDecl, decl.modifiers());
            takenNames = new ArrayList<String>();
            this.addNewTypeParameters(rewrite, takenNames, decl.typeParameters(), (ImportRewrite.ImportRewriteContext)context);
            decl.setName(newNameNode);
            declaredFields = this.fSenderBinding.getDeclaredFields();
            i = 0;
            while (i < declaredFields.length) {
                takenNames.add(declaredFields[i].getName());
                ++i;
            }
            bodyStatement = "";
            v0 = isAbstractMethod = Modifier.isAbstract((int)decl.getModifiers()) != false || this.fSenderBinding.isInterface() != false && Modifier.isStatic((int)decl.getModifiers()) == false && Modifier.isDefault((int)decl.getModifiers()) == false;
            if (this.isConstructor()) break block7;
            returnType = this.getNewMethodType(rewrite, (ImportRewrite.ImportRewriteContext)context);
            decl.setReturnType2(returnType);
            var15_13 = returnType;
            if (!(var15_13 instanceof PrimitiveType)) ** GOTO lbl-1000
            var13_14 = (PrimitiveType)var15_13;
            (PrimitiveType)var15_13;
            if (PrimitiveType.VOID.equals(primitiveType.getPrimitiveTypeCode())) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = isVoid = false;
            }
            if (!isAbstractMethod && !isVoid) {
                returnStatement = ast.newReturnStatement();
                returnStatement.setExpression(ASTNodeFactory.newDefaultExpression((AST)ast, (Type)returnType, (int)0));
                bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, (int)0, (String)String.valueOf('\n'), (Map)this.getCompilationUnit().getOptions(true));
            }
        }
        this.addNewParameters(rewrite, takenNames, decl.parameters(), (ImportRewrite.ImportRewriteContext)context);
        this.addNewExceptions(rewrite, decl.thrownExceptionTypes(), (ImportRewrite.ImportRewriteContext)context);
        body = null;
        if (!isAbstractMethod && !Flags.isAbstract((int)decl.getModifiers())) {
            body = ast.newBlock();
            if (bodyStatement.length() > 0) {
                todoNode = (ReturnStatement)rewrite.createStringPlaceholder(bodyStatement, 41);
                body.statements().add(todoNode);
            }
        }
        decl.setBody(body);
        settings = PreferenceManager.getCodeGenerationSettings(this.getCompilationUnit());
        if (settings.createComments && !this.fSenderBinding.isAnonymous() && (string = CodeGeneration.getMethodComment((ICompilationUnit)this.getCompilationUnit(), (String)this.fSenderBinding.getName(), (MethodDeclaration)decl, null, (String)String.valueOf('\n'))) != null) {
            javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    private int findMethodInsertIndex(List<BodyDeclaration> decls, int currPos) {
        int nDecls = decls.size();
        int i = 0;
        while (i < nDecls) {
            BodyDeclaration curr = decls.get(i);
            if (curr instanceof MethodDeclaration && currPos < curr.getStartPosition() + curr.getLength()) {
                return i + 1;
            }
            ++i;
        }
        return nDecls;
    }

    /*
     * WARNING - void declaration
     */
    private int findConstructorInsertIndex(List<BodyDeclaration> decls) {
        int nDecls = decls.size();
        int lastMethod = 0;
        int i = nDecls - 1;
        while (i >= 0) {
            BodyDeclaration curr = decls.get(i);
            BodyDeclaration bodyDeclaration = curr;
            if (bodyDeclaration instanceof MethodDeclaration) {
                void method;
                MethodDeclaration cfr_ignored_0 = (MethodDeclaration)bodyDeclaration;
                MethodDeclaration cfr_ignored_1 = (MethodDeclaration)bodyDeclaration;
                if (method.isConstructor()) {
                    return i + 1;
                }
                lastMethod = i;
            }
            --i;
        }
        return lastMethod;
    }

    protected abstract boolean isConstructor();

    protected abstract void addNewModifiers(ASTRewrite var1, ASTNode var2, List<IExtendedModifier> var3);

    protected abstract void addNewTypeParameters(ASTRewrite var1, List<String> var2, List<TypeParameter> var3, ImportRewrite.ImportRewriteContext var4) throws CoreException;

    protected abstract void addNewParameters(ASTRewrite var1, List<String> var2, List<SingleVariableDeclaration> var3, ImportRewrite.ImportRewriteContext var4) throws CoreException;

    protected abstract void addNewExceptions(ASTRewrite var1, List<Type> var2, ImportRewrite.ImportRewriteContext var3) throws CoreException;

    protected abstract SimpleName getNewName(ASTRewrite var1);

    protected abstract Type getNewMethodType(ASTRewrite var1, ImportRewrite.ImportRewriteContext var2) throws CoreException;
}

