/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.corext.refactoring.CuCollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;

class MethodOccurenceCollector
extends CuCollectingSearchRequestor {
    private static final int InternalTokenNameIdentifier = 5;
    private final String fName;

    public MethodOccurenceCollector(String methodName) {
        this(methodName, null);
    }

    public MethodOccurenceCollector(String methodName, ReferencesInBinaryContext binaryRefs) {
        super(binaryRefs);
        this.fName = methodName;
    }

    public void acceptSearchMatch(ICompilationUnit unit, SearchMatch match) throws CoreException {
        if (match instanceof MethodReferenceMatch && ((MethodReferenceMatch)match).isSuperInvocation() && match.getAccuracy() == 1) {
            return;
        }
        if (match.isImplicit()) {
            this.collectMatch(match);
            return;
        }
        int start = match.getOffset();
        int length = match.getLength();
        String matchText = unit.getBuffer().getText(start, length);
        if (this.fName.equals(matchText)) {
            this.collectMatch(match);
            return;
        }
        if (match instanceof MethodDeclarationMatch && match.getElement() instanceof IMethod && ((IMethod)match.getElement()).isLambdaMethod()) {
            return;
        }
        IScanner scanner = this.getScanner(unit);
        scanner.setSource(matchText.toCharArray());
        int simpleNameStart = -1;
        int simpleNameEnd = -1;
        try {
            int token = scanner.getNextToken();
            while (token != 158 && token != 7) {
                if (token == 5) {
                    simpleNameStart = scanner.getCurrentTokenStartPosition();
                    simpleNameEnd = scanner.getCurrentTokenEndPosition();
                }
                token = scanner.getNextToken();
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        if (simpleNameStart != -1) {
            match.setOffset(start + simpleNameStart);
            match.setLength(simpleNameEnd + 1 - simpleNameStart);
        }
        this.collectMatch(match);
    }
}

