/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.managers.TelemetryEvent;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;

public class TelemetryManager {
    private static final String JAVA_PROJECT_BUILD = "java.workspace.initialized";
    private JavaClientConnection.JavaLanguageClient client;
    private PreferenceManager prefs;
    private ProjectsManager projectsManager;
    private long languageServerStartTime;
    private long serviceReadyTime;
    private long projectsInitializedTime;
    private boolean firstTimeInitialization;

    public TelemetryManager(JavaClientConnection.JavaLanguageClient client, PreferenceManager prefs) {
        this.client = client;
        this.prefs = prefs;
    }

    public TelemetryManager() {
    }

    public void setLanguageClient(JavaClientConnection.JavaLanguageClient client) {
        this.client = client;
    }

    public void setPreferenceManager(PreferenceManager prefs) {
        this.prefs = prefs;
    }

    public void onLanguageServerStart(long timeMillis, boolean firstTimeInitialization) {
        this.languageServerStartTime = timeMillis;
        this.firstTimeInitialization = firstTimeInitialization;
    }

    public void onProjectsInitialized(ProjectsManager projectsManager, long timeMillis) {
        this.projectsManager = projectsManager;
        this.projectsInitializedTime = timeMillis;
    }

    public void onServiceReady(long timeMillis) {
        this.serviceReadyTime = timeMillis;
    }

    public void onBuildFinished(long buildFinishedTime) {
        if (!this.prefs.getPreferences().isTelemetryEnabled()) {
            return;
        }
        JsonObject properties = new JsonObject();
        float sourceLevelMin = 0.0f;
        float sourceLevelMax = 0.0f;
        int javaProjectCount = 0;
        JsonArray buildToolNamesList = new JsonArray();
        long projectErrors = 0L;
        long unresolvedImportErrors = 0L;
        boolean jdkMismatch = false;
        IProject[] iProjectArray = ProjectUtils.getAllProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            Optional<IBuildSupport> bs = this.projectsManager.getBuildSupport(project);
            if (bs.isPresent() && !"jdt.ls-java-project".equals(project.getName())) {
                String sourceLevel;
                String buildToolName = bs.get().buildToolName();
                if (!buildToolNamesList.contains((JsonElement)new JsonPrimitive(buildToolName))) {
                    buildToolNamesList.add(buildToolName);
                }
                if ((sourceLevel = ProjectUtils.getJavaSourceLevel(project)) != null) {
                    ++javaProjectCount;
                    if (sourceLevelMin == 0.0f || Float.parseFloat(sourceLevel) < sourceLevelMin) {
                        sourceLevelMin = Float.parseFloat(sourceLevel);
                    }
                    if (sourceLevelMax == 0.0f || Float.parseFloat(sourceLevel) > sourceLevelMax) {
                        sourceLevelMax = Float.parseFloat(sourceLevel);
                    }
                }
                try {
                    IMarker[] projectMarkers = project.findMarkers(null, true, 0);
                    projectErrors += Stream.of(projectMarkers).filter(m -> m.getAttribute("severity", 0) == 2).count();
                    IMarker[] allmarkers = project.findMarkers(null, true, 2);
                    unresolvedImportErrors += Stream.of(allmarkers).filter(m -> ResourceUtils.isUnresolvedImportError(m)).count();
                }
                catch (CoreException projectMarkers) {
                    // empty catch block
                }
                IJavaProject javaProject = ProjectUtils.getJavaProject(project);
                if (javaProject != null) {
                    try {
                        IVMInstall vmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
                        if (JavaRuntime.compareJavaVersions((IVMInstall)vmInstall, (String)sourceLevel) < 0) {
                            jdkMismatch = true;
                        }
                    }
                    catch (CoreException vmInstall) {
                        // empty catch block
                    }
                }
            }
            ++n2;
        }
        properties.addProperty("project.projectErrorCount", Long.toString(projectErrors));
        properties.addProperty("project.unresolvedImportErrorCount", Long.toString(unresolvedImportErrors));
        properties.addProperty("project.autobuild", Boolean.toString(this.prefs.getPreferences().isAutobuildEnabled()));
        properties.addProperty("project.jdkMismatch", Boolean.toString(jdkMismatch));
        long projectInitElapsedTime = this.projectsInitializedTime - this.languageServerStartTime;
        long serviceReadyElapsedTime = this.serviceReadyTime - this.languageServerStartTime;
        long buildFinishedElapsedTime = buildFinishedTime - this.languageServerStartTime;
        properties.add("buildToolNames", (JsonElement)buildToolNamesList);
        properties.addProperty("javaProjectCount", (Number)javaProjectCount);
        if (sourceLevelMin != 0.0f) {
            properties.addProperty("compiler.source.min", Float.toString(sourceLevelMin));
        }
        if (sourceLevelMax != 0.0f) {
            properties.addProperty("compiler.source.max", Float.toString(sourceLevelMax));
        }
        properties.addProperty("time.projectsinitialized", Long.toString(projectInitElapsedTime));
        properties.addProperty("time.serviceready", Long.toString(serviceReadyElapsedTime));
        properties.addProperty("time.buildFinished", Long.toString(buildFinishedElapsedTime));
        properties.addProperty("initialization.first", Boolean.toString(this.firstTimeInitialization));
        Map<IPath, Long> deps = TelemetryManager.computeDependencySize();
        int indexCount = deps.size();
        long librarySize = deps.values().stream().reduce(0L, Long::sum);
        properties.addProperty("dependency.count", Integer.toString(indexCount));
        properties.addProperty("dependency.size", Long.toString(librarySize));
        this.telemetryEvent(JAVA_PROJECT_BUILD, properties);
    }

    private static Map<IPath, Long> computeDependencySize() {
        HashMap<IPath, Long> result = new HashMap<IPath, Long>();
        IJavaProject[] iJavaProjectArray = ProjectUtils.getJavaProjects();
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject proj = iJavaProjectArray[n2];
            if (!"jdt.ls-java-project".equals(proj.getProject().getName())) {
                try {
                    IPackageFragmentRoot[] pfroots = proj.getPackageFragmentRoots();
                    List<String> vmLibraries = TelemetryManager.getVMLibraries(proj);
                    IPackageFragmentRoot[] iPackageFragmentRootArray = pfroots;
                    int n3 = pfroots.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot pfroot = iPackageFragmentRootArray[n4];
                        IPath pfPath = pfroot.getPath();
                        if (TelemetryManager.isValidDependency(pfroot, vmLibraries)) {
                            result.put(pfPath, pfPath.toFile().length());
                        }
                        ++n4;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return result;
    }

    private static List<String> getVMLibraries(IJavaProject proj) throws CoreException {
        IVMInstall vmInstall = JavaRuntime.getVMInstall((IJavaProject)proj.getJavaProject());
        if (vmInstall == null) {
            return Collections.emptyList();
        }
        List<String> vmLibLocations = Arrays.stream(JavaRuntime.getLibraryLocations((IVMInstall)vmInstall)).map(lib -> {
            try {
                return lib.getSystemLibraryPath().toFile().getCanonicalPath();
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return vmLibLocations;
    }

    private static boolean isValidDependency(IPackageFragmentRoot pfRoot, List<String> vmLibLocations) {
        try {
            String pfPath;
            return pfRoot.getKind() == 2 && pfRoot.getPath() != null && !vmLibLocations.contains(pfPath = pfRoot.getPath().toFile().getCanonicalPath());
        }
        catch (IOException | CoreException e) {
            return false;
        }
    }

    private void telemetryEvent(String name, JsonObject properties) {
        boolean telemetryEnabled = this.prefs.getPreferences().isTelemetryEnabled();
        if (telemetryEnabled) {
            this.client.telemetryEvent(new TelemetryEvent(name, properties));
        }
    }
}

