/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.ls.core.internal.AbstractProjectImporter;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.managers.UpdateClasspathJob;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;

public class InvisibleProjectImporter
extends AbstractProjectImporter {
    public static final String[][] SRC_PREFIXES = new String[][]{{"src"}};

    @Override
    public boolean applies(IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        IPath rootPath;
        IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (workspaceLocation.equals((Object)(rootPath = ResourceUtils.filePathFromURI(this.rootFolder.toPath().toUri().toString())))) {
            return false;
        }
        return ProjectUtils.getVisibleProjects(rootPath).isEmpty();
    }

    @Override
    public void importToWorkspace(IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferencesManager == null || preferencesManager.getPreferences() == null) {
            return;
        }
        Collection<IPath> triggerFiles = preferencesManager.getPreferences().getTriggerFiles();
        if (triggerFiles == null || triggerFiles.isEmpty()) {
            return;
        }
        IPath rootPath = ResourceUtils.filePathFromURI(this.rootFolder.toPath().toUri().toString());
        Optional<IPath> triggerJavaFile = triggerFiles.stream().filter(triggerFile -> rootPath.isPrefixOf(triggerFile)).findFirst();
        if (!triggerJavaFile.isPresent()) {
            return;
        }
        InvisibleProjectImporter.loadInvisibleProject(triggerJavaFile.get(), rootPath, true, monitor);
    }

    @Override
    public void reset() {
    }

    public static boolean loadInvisibleProject(IPath javaFile, IPath rootPath, boolean forceUpdateLibPath, IProgressMonitor monitor) throws CoreException {
        if (!ProjectUtils.getVisibleProjects(rootPath).isEmpty()) {
            return false;
        }
        String packageName = InvisibleProjectImporter.getPackageName(javaFile, rootPath);
        IPath sourceDirectory = InvisibleProjectImporter.inferSourceDirectory(javaFile.toFile().toPath(), packageName);
        if (sourceDirectory == null || !rootPath.isPrefixOf(sourceDirectory) || InvisibleProjectImporter.isPartOfMatureProject(sourceDirectory)) {
            return false;
        }
        String invisibleProjectName = ProjectUtils.getWorkspaceInvisibleProjectName(rootPath);
        IProject invisibleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(invisibleProjectName);
        if (!invisibleProject.exists()) {
            try {
                JavaLanguageServerPlugin.logInfo("Try to create an invisible project for the workspace " + rootPath);
                invisibleProject = ProjectUtils.createInvisibleProjectIfNotExist(rootPath);
                forceUpdateLibPath = true;
                JavaLanguageServerPlugin.logInfo("Successfully created a workspace invisible project " + invisibleProjectName);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Failed to create the invisible project.", e);
                return false;
            }
        }
        if (!invisibleProject.hasNature("org.eclipse.jdt.ls.unmanagedFolderNature")) {
            InvisibleProjectImporter.addMissingNature(invisibleProject, monitor);
        }
        IJavaProject javaProject = JavaCore.create((IProject)invisibleProject);
        IFolder workspaceLinkFolder = invisibleProject.getFolder("_");
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        List<String> sourcePathsFromPreferences = null;
        if (preferencesManager != null && preferencesManager.getPreferences() != null) {
            sourcePathsFromPreferences = preferencesManager.getPreferences().getInvisibleProjectSourcePaths();
        }
        HashSet<IPath> sourcePaths = new HashSet<IPath>();
        if (sourcePathsFromPreferences != null) {
            sourcePaths.addAll(InvisibleProjectImporter.getSourcePaths(sourcePathsFromPreferences, workspaceLinkFolder));
        } else {
            IPath relativeSourcePath = sourceDirectory.makeRelativeTo(rootPath);
            IFolder sourceFolder = workspaceLinkFolder.getFolder(relativeSourcePath);
            sourcePaths.addAll(InvisibleProjectImporter.collectSourcePaths(javaFile, sourceFolder, workspaceLinkFolder));
        }
        List<IPath> excludingPaths = InvisibleProjectImporter.getExcludingPath(javaProject, rootPath, workspaceLinkFolder);
        IPath outputPath = InvisibleProjectImporter.getOutputPath(javaProject, preferencesManager.getPreferences().getInvisibleProjectOutputPath(), false);
        IClasspathEntry[] classpathEntries = InvisibleProjectImporter.resolveClassPathEntries(javaProject, new ArrayList<IPath>(sourcePaths), excludingPaths, outputPath);
        javaProject.setRawClasspath(classpathEntries, outputPath, monitor);
        if (forceUpdateLibPath && preferencesManager != null && preferencesManager.getPreferences() != null) {
            UpdateClasspathJob.getInstance().updateClasspath(javaProject, preferencesManager.getPreferences().getReferencedLibraries());
        }
        return true;
    }

    private static Collection<IPath> collectSourcePaths(IPath triggerFilePath, IFolder triggerFolder, IFolder linkedFolder) {
        IPath linkedFolderPath = linkedFolder.getLocation();
        Collection<File> foldersToSearch = InvisibleProjectImporter.collectFoldersToSearch(triggerFilePath, triggerFolder, linkedFolderPath);
        IProject currentProject = linkedFolder.getProject();
        if (currentProject == null) {
            return Collections.emptySet();
        }
        Collection<IPath> triggerFiles = InvisibleProjectImporter.collectTriggerFiles(currentProject, foldersToSearch);
        HashSet<IPath> sourcePaths = new HashSet<IPath>();
        sourcePaths.add(triggerFolder.getFullPath());
        for (IPath javaFilePath : triggerFiles) {
            String packageName = InvisibleProjectImporter.getPackageName(javaFilePath, linkedFolderPath);
            IPath directory = InvisibleProjectImporter.inferSourceDirectory(javaFilePath.toFile().toPath(), packageName);
            if (directory == null || !linkedFolderPath.isPrefixOf(directory) || InvisibleProjectImporter.isPartOfMatureProject(directory)) continue;
            IPath relativeSourcePath = directory.makeRelativeTo(linkedFolderPath);
            IPath sourcePath = linkedFolder.getFolder(relativeSourcePath).getFullPath();
            sourcePaths.add(sourcePath);
        }
        return sourcePaths;
    }

    private static Collection<File> collectFoldersToSearch(IPath triggerFilePath, IFolder triggerFolder, IPath linkedFolderPath) {
        HashSet<File> foldersToSearch = new HashSet<File>();
        if (Objects.equals(triggerFolder.getLocation(), linkedFolderPath)) {
            foldersToSearch.addAll(InvisibleProjectImporter.getDirectChildFolders(triggerFilePath, triggerFolder));
        } else {
            foldersToSearch.addAll(InvisibleProjectImporter.getSiblingFolders(triggerFolder, linkedFolderPath));
        }
        return foldersToSearch;
    }

    private static Collection<File> getDirectChildFolders(IPath triggerFilePath, IFolder parentFolder) {
        File[] childrenFiles;
        File parent = parentFolder.getLocation().toFile();
        if (parent.isFile()) {
            return Collections.emptySet();
        }
        HashSet<File> children = new HashSet<File>();
        File[] fileArray = childrenFiles = parent.listFiles();
        int n = childrenFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Path dirPath;
            File dir = fileArray[n2];
            if (dir.isDirectory() && !(dirPath = new Path(dir.getAbsolutePath())).isPrefixOf(triggerFilePath)) {
                children.add(dir);
            }
            ++n2;
        }
        return children;
    }

    private static Collection<File> getSiblingFolders(IFolder triggerFolder, IPath linkedFolderPath) {
        File[] peerFiles;
        HashSet<File> siblings = new HashSet<File>();
        IContainer parentFolder = triggerFolder.getParent();
        if (parentFolder == null) {
            return Collections.emptySet();
        }
        if (!linkedFolderPath.isPrefixOf(parentFolder.getLocation())) {
            return Collections.emptySet();
        }
        File parent = parentFolder.getLocation().toFile();
        if (parent.isFile()) {
            return Collections.emptySet();
        }
        File[] fileArray = peerFiles = parent.listFiles();
        int n = peerFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File peerFile = fileArray[n2];
            if (peerFile.isDirectory() && !peerFile.getName().equals(triggerFolder.getName())) {
                siblings.add(peerFile);
            }
            ++n2;
        }
        return siblings;
    }

    private static Collection<IPath> collectTriggerFiles(IProject project, Collection<File> searchFolders) {
        JavaFileDetector javaFileDetector = new JavaFileDetector(project);
        for (File file : searchFolders) {
            try {
                Files.walkFileTree(file.toPath(), EnumSet.noneOf(FileVisitOption.class), 3, javaFileDetector);
            }
            catch (IOException e) {
                JavaLanguageServerPlugin.logException(e);
            }
        }
        return javaFileDetector.getTriggerFiles();
    }

    public static void inferSourceRoot(final IJavaProject javaProject, IPath unitPath) {
        IProject project = javaProject.getProject();
        IPath projectRealFolder = ProjectUtils.getProjectRealFolder(project);
        IPath rootPath = ProjectUtils.findBelongedWorkspaceRoot(projectRealFolder);
        if (rootPath == null) {
            return;
        }
        String packageName = InvisibleProjectImporter.getPackageName(unitPath, rootPath);
        IPath sourceDirectory = InvisibleProjectImporter.inferSourceDirectory(unitPath.toFile().toPath(), packageName);
        if (sourceDirectory == null || !rootPath.isPrefixOf(sourceDirectory) || InvisibleProjectImporter.isPartOfMatureProject(sourceDirectory)) {
            return;
        }
        IPath relativeSourcePath = sourceDirectory.makeRelativeTo(rootPath);
        IFolder workspaceLinkFolder = project.getFolder("_");
        IPath sourcePath = workspaceLinkFolder.getFolder(relativeSourcePath).getFullPath();
        HashSet<IPath> sourcePaths = new HashSet<IPath>();
        sourcePaths.add(sourcePath);
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    sourcePaths.add(entry.getPath());
                }
                ++n2;
            }
            List<IPath> excludingPaths = InvisibleProjectImporter.getExcludingPath(javaProject, rootPath, workspaceLinkFolder);
            final IPath outputPath = InvisibleProjectImporter.getOutputPath(javaProject, InvisibleProjectImporter.getPreferences().getInvisibleProjectOutputPath(), false);
            final IClasspathEntry[] classpathEntries = InvisibleProjectImporter.resolveClassPathEntries(javaProject, new ArrayList<IPath>(sourcePaths), excludingPaths, outputPath);
            WorkspaceJob updateClasspathJob = new WorkspaceJob("Update invisible project classpath"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        javaProject.setRawClasspath(classpathEntries, outputPath, monitor);
                        ProjectUtils.refreshDiagnostics(monitor);
                    }
                    catch (CoreException e) {
                        JavaLanguageServerPlugin.log(e);
                    }
                    return Status.OK_STATUS;
                }
            };
            updateClasspathJob.setPriority(40);
            updateClasspathJob.setSystem(true);
            updateClasspathJob.schedule();
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.log(e);
            return;
        }
    }

    public static IClasspathEntry[] resolveClassPathEntries(IJavaProject javaProject, List<IPath> sourcePaths, List<IPath> excludingPaths, IPath outputPath) throws CoreException {
        LinkedList<Object> newEntries = new LinkedList<Object>();
        IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() != 3) {
                newEntries.add(entry);
            }
            ++n2;
        }
        Collections.sort(sourcePaths, new Comparator<IPath>(){

            @Override
            public int compare(IPath path1, IPath path2) {
                return path1.toString().compareTo(path2.toString()) * -1;
            }
        });
        LinkedList<IClasspathEntry> sourceEntries = new LinkedList<IClasspathEntry>();
        for (IPath currentPath : sourcePaths) {
            boolean canAddToSourceEntries = true;
            ArrayList<IPath> exclusionPatterns = new ArrayList<IPath>();
            for (IClasspathEntry sourceEntry : sourceEntries) {
                if (Objects.equals(sourceEntry.getPath(), currentPath)) {
                    JavaLanguageServerPlugin.logError("Skip duplicated source path: " + currentPath.toString());
                    canAddToSourceEntries = false;
                    break;
                }
                if (!currentPath.isPrefixOf(sourceEntry.getPath())) continue;
                exclusionPatterns.add(sourceEntry.getPath().makeRelativeTo(currentPath).addTrailingSeparator());
            }
            if (currentPath.isPrefixOf(outputPath)) {
                exclusionPatterns.add(outputPath.makeRelativeTo(currentPath).addTrailingSeparator());
            }
            if (!canAddToSourceEntries) continue;
            if (excludingPaths != null) {
                for (IPath exclusion : excludingPaths) {
                    if (!currentPath.isPrefixOf(exclusion) || currentPath.equals((Object)exclusion)) continue;
                    exclusionPatterns.add(exclusion.makeRelativeTo(currentPath).addTrailingSeparator());
                }
            }
            sourceEntries.add(JavaCore.newSourceEntry((IPath)currentPath, (IPath[])((IPath[])exclusionPatterns.toArray(IPath[]::new))));
        }
        newEntries.addAll(sourceEntries);
        IClasspathEntry[] rawClasspath = (IClasspathEntry[])newEntries.toArray(IClasspathEntry[]::new);
        IJavaModelStatus checkStatus = ClasspathEntry.validateClasspath((IJavaProject)javaProject, (IClasspathEntry[])rawClasspath, (IPath)outputPath);
        if (!checkStatus.isOK()) {
            throw new CoreException((IStatus)checkStatus);
        }
        return rawClasspath;
    }

    public static IPath getOutputPath(IJavaProject javaProject, String outputPath, boolean isUpdate) throws CoreException {
        if (new Path(outputPath = outputPath == null ? "" : outputPath.trim()).isAbsolute()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "The output path must be a relative path to the workspace."));
        }
        IProject project = javaProject.getProject();
        if (StringUtils.isEmpty((CharSequence)outputPath)) {
            return javaProject.getProject().getFolder("bin").getFullPath();
        }
        outputPath = "_/" + outputPath;
        IPath outputFullPath = project.getFolder(outputPath).getFullPath();
        if (javaProject.getOutputLocation().equals((Object)outputFullPath)) {
            return outputFullPath;
        }
        File outputDirectory = project.getFolder(outputPath).getLocation().toFile();
        if (isUpdate && outputDirectory.exists() && outputDirectory.list().length != 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "Cannot set the output path to a folder which is not empty, please provide a new path."));
        }
        return outputFullPath;
    }

    public static List<IPath> getSourcePaths(List<String> sourcePaths, IFolder workspaceLinkFolder) throws CoreException {
        if (sourcePaths == null) {
            return Collections.emptyList();
        }
        sourcePaths = sourcePaths.stream().map(path -> path.trim()).distinct().collect(Collectors.toList());
        LinkedList<IPath> sourceList = new LinkedList<IPath>();
        for (String sourcePath : sourcePaths) {
            if (new Path(sourcePath).isAbsolute()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "The source path must be a relative path to the workspace."));
            }
            IFolder sourceFolder = workspaceLinkFolder.getFolder(sourcePath);
            if (!sourceFolder.exists()) continue;
            sourceList.add(sourceFolder.getFullPath());
        }
        return sourceList;
    }

    public static List<IPath> getExcludingPath(IJavaProject javaProject, IPath rootPath, IFolder workspaceLinkFolder) throws CoreException {
        if (rootPath == null) {
            rootPath = ProjectUtils.findBelongedWorkspaceRoot(workspaceLinkFolder.getLocation());
        }
        if (rootPath == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "Failed to find the belonging root of the linked folder: " + workspaceLinkFolder.toString()));
        }
        IPath root = rootPath;
        Path libFolder = new Path("lib");
        List<IProject> subProjects = ProjectUtils.getVisibleProjects(rootPath);
        List<IPath> excludingPaths = subProjects.stream().map(project -> {
            IPath relativePath = project.getLocation().makeRelativeTo(root);
            return workspaceLinkFolder.getFolder(relativePath).getFullPath();
        }).collect(Collectors.toList());
        excludingPaths.add((IPath)libFolder);
        return excludingPaths;
    }

    private static boolean isPartOfMatureProject(IPath sourcePath) {
        List<String> segments = Arrays.asList((sourcePath = sourcePath.removeTrailingSeparator()).segments());
        int index = segments.lastIndexOf("src");
        if (index <= 0) {
            return false;
        }
        IPath srcPath = sourcePath.removeLastSegments(segments.size() - 1 - index);
        IPath container = srcPath.removeLastSegments(1);
        return container.append("pom.xml").toFile().exists() || container.append("build.gradle").toFile().exists() || container.append("settings.gradle").toFile().exists() || container.append("build.gradle.kts").toFile().exists() || container.append("settings.gradle.kts").toFile().exists();
    }

    private static String getPackageName(IPath javaFile, IPath workspaceRoot) {
        return InvisibleProjectImporter.getPackageName(javaFile, workspaceRoot, SRC_PREFIXES);
    }

    private static String getPackageName(IPath javaFile, IPath workspaceRoot, String[][] srcPrefixes) {
        IProject project = ProjectsManager.getDefaultProject();
        if (project == null || !project.isAccessible()) {
            return "";
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return InvisibleProjectImporter.getPackageName(javaFile, workspaceRoot, javaProject, srcPrefixes);
    }

    public static String getPackageName(IPath javaFile, IPath workspaceRoot, IJavaProject javaProject) {
        return InvisibleProjectImporter.getPackageName(javaFile, workspaceRoot, javaProject, SRC_PREFIXES);
    }

    public static String getPackageName(IPath javaFile, IPath workspaceRoot, IJavaProject javaProject, String[][] srcPrefixes) {
        File nioFile = javaFile.toFile();
        try {
            String content = Files.readString(nioFile.toPath());
            if (StringUtils.isBlank((CharSequence)content)) {
                File found = InvisibleProjectImporter.findNearbyNonEmptyFile(nioFile);
                if (found == null) {
                    return InvisibleProjectImporter.inferPackageNameFromPath(javaFile, workspaceRoot, srcPrefixes);
                }
                nioFile = found;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return JDTUtils.getPackageName(javaProject, nioFile.toURI());
    }

    private static File findNearbyNonEmptyFile(File nioFile) throws IOException {
        java.nio.file.Path directory = nioFile.getParentFile().toPath();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<java.nio.file.Path> walk = Files.walk(directory, 1, new FileVisitOption[0]);){
                Optional<java.nio.file.Path> found = walk.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(file2 -> {
                    try {
                        return file2.toString().endsWith(".java") && !Objects.equals(nioFile.getName(), file2.toFile().getName()) && Files.size(file2) > 0L;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }).findFirst();
                if (found.isPresent()) {
                    return found.get().toFile();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String inferPackageNameFromPath(IPath javaFile, IPath workspaceRoot, String[][] srcPrefixes) {
        IPath parentPath = javaFile.removeTrailingSeparator().removeLastSegments(1);
        IPath relativePath = parentPath.makeRelativeTo(workspaceRoot);
        List<String> segments = Arrays.asList(relativePath.segments());
        int i = 0;
        while (i < srcPrefixes.length) {
            int index = Collections.indexOfSubList(segments, Arrays.asList(srcPrefixes[i]));
            if (index > -1) {
                return String.join((CharSequence)".", segments.subList(index + srcPrefixes[i].length, segments.size()));
            }
            ++i;
        }
        return String.join((CharSequence)".", segments);
    }

    private static IPath inferSourceDirectory(java.nio.file.Path filePath, String packageName) {
        String packagePath = packageName.replace(".", "/");
        java.nio.file.Path sourcePath = filePath.getParent();
        if (StringUtils.isBlank((CharSequence)packagePath)) {
            return ResourceUtils.filePathFromURI(sourcePath.toUri().toString());
        }
        if (sourcePath.endsWith(Paths.get(packagePath, new String[0]))) {
            int packageCount = packageName.split("\\.").length;
            while (packageCount > 0) {
                sourcePath = sourcePath.getParent();
                --packageCount;
            }
            return ResourceUtils.filePathFromURI(sourcePath.toUri().toString());
        }
        return null;
    }

    public static IPath tryResolveSourceDirectory(IPath javaFile, IPath rootPath, String[][] potentialSrcPrefixes) {
        String packageName = InvisibleProjectImporter.getPackageName(javaFile, rootPath, potentialSrcPrefixes);
        return InvisibleProjectImporter.inferSourceDirectory(javaFile.toFile().toPath(), packageName);
    }

    private static void addMissingNature(IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natureIds = description.getNatureIds();
        String[] newNatureIds = new String[natureIds.length + 1];
        System.arraycopy(natureIds, 0, newNatureIds, 0, natureIds.length);
        newNatureIds[newNatureIds.length - 1] = "org.eclipse.jdt.ls.unmanagedFolderNature";
        description.setNatureIds(newNatureIds);
        project.setDescription(description, monitor);
    }

    public static class JavaFileDetector
    extends SimpleFileVisitor<java.nio.file.Path> {
        private IProject currentProject;
        private Set<IPath> javaFiles;
        private Set<String> exclusions;
        private Set<IPath> projectPaths;
        private Set<String> buildFiles;

        public JavaFileDetector(IProject currentProject) {
            IProject[] allProjects;
            this.currentProject = currentProject;
            this.javaFiles = new HashSet<IPath>();
            this.exclusions = new HashSet<String>();
            List<String> javaImportExclusions = JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getJavaImportExclusions();
            if (javaImportExclusions != null) {
                this.exclusions.addAll(javaImportExclusions);
            }
            this.buildFiles = new HashSet<String>(Arrays.asList("pom.xml", "build.gradle", "build.gradle.kts", "settings.gradle", "settings.gradle.kts", ".project", ".classpath"));
            this.projectPaths = new HashSet<IPath>();
            IProject[] iProjectArray = allProjects = ProjectUtils.getAllProjects();
            int n = allProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (!Objects.equals(project, this.currentProject)) {
                    if (ProjectUtils.isVisibleProject(project)) {
                        this.projectPaths.add(project.getLocation());
                    } else if (!Objects.equals(project.getName(), "jdt.ls-java-project")) {
                        try {
                            project.accept(resource -> {
                                if (resource.isLinked()) {
                                    this.projectPaths.add(resource.getLocation().removeLastSegments(1));
                                    return false;
                                }
                                return true;
                            }, 2, false);
                        }
                        catch (CoreException e) {
                            JavaLanguageServerPlugin.log(e);
                        }
                    }
                }
                ++n2;
            }
        }

        @Override
        public FileVisitResult preVisitDirectory(java.nio.file.Path dirPath, BasicFileAttributes attrs) throws IOException {
            if (this.isExcluded(dirPath)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            File dir = dirPath.toFile();
            File[] files = dir.listFiles();
            if (files == null) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            File javaFile = null;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile()) {
                    if (this.buildFiles.contains(f.getName())) {
                        return FileVisitResult.TERMINATE;
                    }
                    if (javaFile == null && f.getName().endsWith(".java")) {
                        javaFile = f;
                    }
                }
                ++n2;
            }
            if (javaFile != null) {
                this.javaFiles.add((IPath)new Path(javaFile.getPath()));
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }

        public Set<IPath> getTriggerFiles() {
            return this.javaFiles;
        }

        private boolean isExcluded(java.nio.file.Path dir) {
            if (dir.getFileName() == null) {
                return true;
            }
            IPath path = ResourceUtils.filePathFromURI(dir.toUri().toString());
            for (IPath projectPath : this.projectPaths) {
                if (!projectPath.isPrefixOf(path)) continue;
                return true;
            }
            boolean excluded = false;
            for (String pattern : this.exclusions) {
                PathMatcher matcher;
                boolean includePattern = false;
                if (pattern.startsWith("!")) {
                    includePattern = true;
                    pattern = pattern.substring(1);
                }
                if (!(matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern)).matches(dir)) continue;
                boolean bl = excluded = !includePattern;
            }
            return excluded;
        }
    }
}

