/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javadoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.javadoc.JavaDoc2MarkdownConverter;
import org.eclipse.jdt.ls.core.internal.javadoc.JavaDocHTMLPathHandler;
import org.eclipse.jdt.ls.core.internal.javadoc.JavaDocLocations;
import org.eclipse.jdt.ls.core.internal.javadoc.JavaDocSnippetStringEvaluator;
import org.eclipse.jdt.ls.core.internal.javadoc.JavaElementLinks;
import org.eclipse.jdt.ls.core.internal.javadoc.JavadocContentAccess;

public class JavadocContentAccess2 {
    private static final String UL_CLASS_BLOCK_LIST = "<ul class=\"blockList\">";
    private static final String BASE_URL_COMMENT_INTRO = "<!-- baseURL=\"";
    private static final String BLOCK_TAG_START = "<ul>";
    private static final String BLOCK_TAG_END = "</ul>";
    public static final String BlOCK_TAG_TITLE_START = "<dt>";
    public static final String BlOCK_TAG_TITLE_END = "</dt>";
    private static final String BlOCK_TAG_ENTRY_START = "<li>";
    private static final String BlOCK_TAG_ENTRY_END = "</li>";
    private static final String PARAM_NAME_START = "<b>";
    private static final String PARAM_NAME_END = "</b> ";
    private static final String JavaDoc2HTMLTextReader_parameters_section = "Parameters:";
    private static final String JavaDoc2HTMLTextReader_returns_section = "Returns:";
    private static final String JavaDoc2HTMLTextReader_throws_section = "Throws:";
    private static final String JavaDoc2HTMLTextReader_type_parameters_section = "Type Parameters:";
    private static final String JavaDoc2HTMLTextReader_author_section = "Author:";
    private static final String JavaDoc2HTMLTextReader_deprecated_section = "Deprecated";
    private static final String JavaDoc2HTMLTextReader_method_in_type = "{0}in{1}";
    private static final String JavaDoc2HTMLTextReader_overrides_section = "Overrides:";
    private static final String JavaDoc2HTMLTextReader_see_section = "See Also:";
    private static final String JavaDoc2HTMLTextReader_api_note = "API Note:";
    private static final String JavaDoc2HTMLTextReader_since_section = "Since:";
    private static final String JavaDoc2HTMLTextReader_specified_by_section = "Specified by:";
    private static final String JavaDoc2HTMLTextReader_version_section = "Version:";
    private static final String JavadocContentAccess2_getproperty_message = "<p>Gets the value ofthe property{0}.</p><dl><dt>Property Description:</dt><dd>{1}</dd></dl>";
    private static final String JavadocContentAccess2_setproperty_message = "<p>Sets the value ofthe property {0}.</p><dl><dt>Property Description:</dt><dd>{1}</dd></dl>";
    private static final String CONTENT_CONTAINER = "<div class=\"contentContainer\">";
    private final IJavaElement fElement;
    private final JavaDocSnippetStringEvaluator fSnippetStringEvaluator;
    private final IMethod fMethod;
    private final Javadoc fJavadoc;
    private final String fSource;
    private final JavadocLookup fJavadocLookup;
    private StringBuffer fBuf;
    private int fLiteralContent;
    private StringBuffer fMainDescription;
    private StringBuffer fReturnDescription;
    private StringBuffer[] fTypeParamDescriptions;
    private StringBuffer[] fParamDescriptions;
    private HashMap<String, StringBuffer> fExceptionDescriptions;

    private JavadocContentAccess2(IJavaElement element, Javadoc javadoc, String source, JavadocLookup lookup) {
        Assert.isNotNull((Object)element);
        Assert.isTrue((element instanceof IMethod || element instanceof ILocalVariable || element instanceof ITypeParameter ? 1 : 0) != 0);
        this.fElement = element;
        this.fSnippetStringEvaluator = new JavaDocSnippetStringEvaluator(this.fElement);
        this.fMethod = (IMethod)(element instanceof ILocalVariable || element instanceof ITypeParameter ? element.getParent() : element);
        this.fJavadoc = javadoc;
        this.fSource = source;
        this.fJavadocLookup = lookup;
    }

    private JavadocContentAccess2(IJavaElement element, Javadoc javadoc, String source) {
        Assert.isTrue((element instanceof IMember || element instanceof IPackageFragment || element instanceof ILocalVariable || element instanceof ITypeParameter ? 1 : 0) != 0);
        this.fElement = element;
        this.fSnippetStringEvaluator = new JavaDocSnippetStringEvaluator(this.fElement);
        this.fMethod = null;
        this.fJavadoc = javadoc;
        this.fSource = source;
        this.fJavadocLookup = JavadocLookup.NONE;
    }

    /*
     * WARNING - void declaration
     */
    public static String getHTMLContent(IJavaElement element, boolean useAttachedJavadoc) throws CoreException {
        IJavaElement iJavaElement = element;
        if (iJavaElement instanceof IPackageFragment) {
            void packageFragment;
            IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
            IPackageFragment cfr_ignored_0 = (IPackageFragment)iJavaElement;
            return JavadocContentAccess2.getHTMLContent((IPackageFragment)packageFragment);
        }
        IJavaElement iJavaElement2 = element;
        if (iJavaElement2 instanceof IPackageDeclaration) {
            void packageDecl;
            IPackageDeclaration iPackageDeclaration = (IPackageDeclaration)iJavaElement2;
            IPackageDeclaration cfr_ignored_1 = (IPackageDeclaration)iJavaElement2;
            return JavadocContentAccess2.getHTMLContent((IPackageDeclaration)packageDecl);
        }
        if (!(element instanceof IMember || element instanceof ITypeParameter || element instanceof ILocalVariable && ((ILocalVariable)element).isParameter())) {
            return null;
        }
        String sourceJavadoc = JavadocContentAccess2.getHTMLContentFromSource(element);
        if ((sourceJavadoc == null || sourceJavadoc.length() == 0 || sourceJavadoc.trim().equals("{@inheritDoc}")) && useAttachedJavadoc) {
            if (element.getOpenable().getBuffer() == null) {
                try {
                    return element.getAttachedJavadoc(null);
                }
                catch (Exception e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                    return null;
                }
            }
            IMember member = null;
            IJavaElement iJavaElement3 = element;
            if (iJavaElement3 instanceof ILocalVariable) {
                void localVariable;
                ILocalVariable iLocalVariable = (ILocalVariable)iJavaElement3;
                ILocalVariable cfr_ignored_2 = (ILocalVariable)iJavaElement3;
                member = localVariable.getDeclaringMember();
            } else {
                IJavaElement iJavaElement4 = element;
                if (iJavaElement4 instanceof ITypeParameter) {
                    void typeParam;
                    ITypeParameter iTypeParameter = (ITypeParameter)iJavaElement4;
                    ITypeParameter cfr_ignored_3 = (ITypeParameter)iJavaElement4;
                    member = typeParam.getDeclaringMember();
                } else {
                    IJavaElement iJavaElement5 = element;
                    if (iJavaElement5 instanceof IMember) {
                        void memberElement;
                        IMember iMember = (IMember)iJavaElement5;
                        IMember cfr_ignored_4 = (IMember)iJavaElement5;
                        member = memberElement;
                    }
                }
            }
            if (JavadocContentAccess2.canInheritJavadoc(member)) {
                IMethod method = (IMethod)member;
                String attachedDocInHierarchy = JavadocContentAccess2.findAttachedDocInHierarchy(method);
                if (attachedDocInHierarchy == null) {
                    return sourceJavadoc;
                }
                StringBuffer superMethodReferences = JavadocContentAccess2.createSuperMethodReferences(method);
                if (superMethodReferences == null) {
                    return attachedDocInHierarchy;
                }
                superMethodReferences.append(attachedDocInHierarchy);
                return superMethodReferences.toString();
            }
        }
        return sourceJavadoc;
    }

    private static StringBuffer createSuperMethodReferences(final IMethod method) throws JavaModelException {
        boolean hasSuperInterfaceMethods;
        IType type = method.getDeclaringType();
        ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy((IType)type);
        final MethodOverrideTester tester = SuperTypeHierarchyCache.getMethodOverrideTester((IType)type);
        final ArrayList superInterfaceMethods = new ArrayList();
        final IMethod[] superClassMethod = new IMethod[1];
        new InheritDocVisitor(){

            @Override
            public Object visit(IType currType) throws JavaModelException {
                IMethod overridden = tester.findOverriddenMethodInType(currType, method);
                if (overridden == null) {
                    return InheritDocVisitor.CONTINUE;
                }
                if (currType.isInterface()) {
                    superInterfaceMethods.add(overridden);
                } else {
                    superClassMethod[0] = overridden;
                }
                return STOP_BRANCH;
            }
        }.visitInheritDoc(type, hierarchy);
        boolean bl = hasSuperInterfaceMethods = superInterfaceMethods.size() != 0;
        if (!hasSuperInterfaceMethods && superClassMethod[0] == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        return buf;
    }

    private static String createMethodInTypeLinks(IMethod overridden) {
        CharSequence methodLink = JavadocContentAccess2.createSimpleMemberLink((IMember)overridden);
        CharSequence typeLink = JavadocContentAccess2.createSimpleMemberLink((IMember)overridden.getDeclaringType());
        String methodInType = MessageFormat.format(JavaDoc2HTMLTextReader_method_in_type, methodLink, typeLink);
        return methodInType;
    }

    private static CharSequence createSimpleMemberLink(IMember member) {
        StringBuffer buf = new StringBuffer();
        buf.append("<a href='");
        try {
            String uri = JavaElementLinks.createURI(null, (IJavaElement)member);
            buf.append(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        buf.append("'>");
        buf.append("</a>");
        return buf;
    }

    /*
     * WARNING - void declaration
     */
    private static String getHTMLContentFromSource(IJavaElement element) throws JavaModelException {
        IMember member;
        IJavaElement iJavaElement = element;
        if (iJavaElement instanceof ILocalVariable) {
            void localVariable;
            ILocalVariable iLocalVariable = (ILocalVariable)iJavaElement;
            ILocalVariable cfr_ignored_0 = (ILocalVariable)iJavaElement;
            member = localVariable.getDeclaringMember();
        } else {
            IJavaElement iJavaElement2 = element;
            if (iJavaElement2 instanceof ITypeParameter) {
                void typeParam;
                ITypeParameter iTypeParameter = (ITypeParameter)iJavaElement2;
                ITypeParameter cfr_ignored_1 = (ITypeParameter)iJavaElement2;
                member = typeParam.getDeclaringMember();
            } else {
                IJavaElement iJavaElement3 = element;
                if (iJavaElement3 instanceof IMember) {
                    void memberElement;
                    IMember iMember = (IMember)iJavaElement3;
                    IMember cfr_ignored_2 = (IMember)iJavaElement3;
                    member = memberElement;
                } else {
                    return null;
                }
            }
        }
        IBuffer buf = member.getOpenable().getBuffer();
        if (buf == null) {
            return null;
        }
        ISourceRange javadocRange = member.getJavadocRange();
        if (javadocRange == null) {
            String inheritedJavadoc;
            if (JavadocContentAccess2.canInheritJavadoc(member) && (inheritedJavadoc = JavadocContentAccess2.javadoc2HTML(member, element, "/***/")) != null && inheritedJavadoc.length() > 0) {
                return inheritedJavadoc;
            }
            return JavadocContentAccess2.getJavaFxPropertyDoc(member);
        }
        String rawJavadoc = buf.getText(javadocRange.getOffset(), javadocRange.getLength());
        return JavadocContentAccess2.javadoc2HTML(member, element, rawJavadoc);
    }

    private static String getJavaFxPropertyDoc(IMember member) throws JavaModelException {
        if (member instanceof IMethod) {
            boolean isSetter;
            String name = member.getElementName();
            boolean isGetter = name.startsWith("get") && name.length() > 3;
            boolean isBooleanGetter = name.startsWith("is") && name.length() > 2;
            boolean bl = isSetter = name.startsWith("set") && name.length() > 3;
            if (isGetter || isBooleanGetter || isSetter) {
                String propertyName = JavadocContentAccess2.firstToLower(name.substring(isBooleanGetter ? 2 : 3));
                IType type = member.getDeclaringType();
                IMethod method = type.getMethod(String.valueOf(propertyName) + "Property", new String[0]);
                if (method.exists()) {
                    String content = JavadocContentAccess2.getHTMLContentFromSource((IJavaElement)method);
                    if (content != null) {
                        // empty if block
                    }
                    return content;
                }
            } else if (name.endsWith("Property")) {
                String propertyName = name.substring(0, name.length() - 8);
                IType type = member.getDeclaringType();
                IField field = type.getField(propertyName);
                if (field.exists()) {
                    return JavadocContentAccess2.getHTMLContentFromSource((IJavaElement)field);
                }
            }
        }
        return null;
    }

    private static String firstToLower(String propertyName) {
        char[] c = propertyName.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return String.valueOf(c);
    }

    private static Javadoc getJavadocNode(IJavaElement element, String rawJavadoc) {
        String source = String.valueOf(rawJavadoc) + "class C{}";
        CompilationUnit root = JavadocContentAccess2.createAST(element, source);
        if (root == null) {
            return null;
        }
        List types = root.types();
        if (types.size() != 1) {
            return null;
        }
        AbstractTypeDeclaration type = (AbstractTypeDeclaration)types.get(0);
        return type.getJavadoc();
    }

    private static Javadoc getPackageJavadocNode(IJavaElement element, String cuSource) {
        PackageDeclaration packDecl;
        CompilationUnit cu = JavadocContentAccess2.createAST(element, cuSource);
        if (cu != null && (packDecl = cu.getPackage()) != null) {
            return packDecl.getJavadoc();
        }
        return null;
    }

    private static CompilationUnit createAST(IJavaElement element, String cuSource) {
        Assert.isNotNull((Object)element);
        ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
        IJavaProject javaProject = element.getJavaProject();
        parser.setProject(javaProject);
        Map options = javaProject.getOptions(true);
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        parser.setCompilerOptions(options);
        parser.setSource(cuSource.toCharArray());
        return (CompilationUnit)parser.createAST(null);
    }

    private static String javadoc2HTML(IMember member, IJavaElement element, String rawJavadoc) {
        Javadoc javadoc = JavadocContentAccess2.getJavadocNode((IJavaElement)member, rawJavadoc);
        if (javadoc == null) {
            Reader contentReader = null;
            try {
                contentReader = JavadocContentAccess.getHTMLContentReader(member, false, false);
                if (contentReader != null) {
                    String string = JavadocContentAccess2.getString(contentReader);
                    return string;
                }
            }
            catch (JavaModelException javaModelException) {
            }
            finally {
                if (contentReader != null) {
                    try {
                        contentReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return null;
        }
        if (JavadocContentAccess2.canInheritJavadoc(member)) {
            IMethod method = (IMethod)member;
            return new JavadocContentAccess2(element, javadoc, rawJavadoc, new JavadocLookup(method.getDeclaringType())).toHTML();
        }
        return new JavadocContentAccess2(element, javadoc, rawJavadoc).toHTML();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean canInheritJavadoc(IMember member) {
        IMember iMember = member;
        if (iMember instanceof IMethod) {
            IMethod iMethod = (IMethod)iMember;
            IMethod cfr_ignored_0 = (IMethod)iMember;
            if (member.getJavaProject().exists()) {
                try {
                    void method;
                    return !method.isConstructor();
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private static String getString(Reader reader) {
        StringBuffer buf = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            int count;
            while ((count = reader.read(buffer)) != -1) {
                buf.append(buffer, 0, count);
            }
        }
        catch (IOException e) {
            return null;
        }
        return buf.toString();
    }

    private static String findAttachedDocInHierarchy(final IMethod method) throws JavaModelException {
        IType type = method.getDeclaringType();
        ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy((IType)type);
        final MethodOverrideTester tester = SuperTypeHierarchyCache.getMethodOverrideTester((IType)type);
        return (String)new InheritDocVisitor(){

            @Override
            public Object visit(IType currType) throws JavaModelException {
                String attachedJavadoc;
                IMethod overridden = tester.findOverriddenMethodInType(currType, method);
                if (overridden == null) {
                    return InheritDocVisitor.CONTINUE;
                }
                if (overridden.getOpenable().getBuffer() == null && (attachedJavadoc = overridden.getAttachedJavadoc(null)) != null) {
                    String baseURL = JavaDocLocations.getBaseURL((IJavaElement)overridden, overridden.isBinary());
                    if (baseURL != null) {
                        attachedJavadoc = JavadocContentAccess2.BASE_URL_COMMENT_INTRO + baseURL + "\"--> " + attachedJavadoc;
                    }
                    return attachedJavadoc;
                }
                return CONTINUE;
            }
        }.visitInheritDoc(type, hierarchy);
    }

    private String toHTML() {
        this.fBuf = new StringBuffer();
        this.fLiteralContent = 0;
        if (this.fElement instanceof ILocalVariable || this.fElement instanceof ITypeParameter) {
            this.parameterToHTML();
        } else {
            this.elementToHTML();
        }
        String result = this.fBuf.toString();
        this.fBuf = null;
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void parameterToHTML() {
        List<String> typeParameterNames;
        int i;
        String elementName = this.fElement.getElementName();
        List tags = this.fJavadoc.tags();
        for (TagElement tag : tags) {
            void thirdTextElement;
            void secondName;
            void textElement;
            Object e;
            List fragments;
            int size;
            String tagName = tag.getTagName();
            if (!"@param".equals(tagName) || (size = (fragments = tag.fragments()).size()) <= 0) continue;
            Object first = fragments.get(0);
            Object e2 = first;
            if (e2 instanceof SimpleName) {
                void simpleName;
                SimpleName cfr_ignored_0 = (SimpleName)e2;
                SimpleName cfr_ignored_1 = (SimpleName)e2;
                String name = simpleName.getIdentifier();
                if (!elementName.equals(name)) continue;
                this.handleContentElements(fragments.subList(1, size));
                return;
            }
            if (size <= 2 || !(this.fElement instanceof ITypeParameter) || !((e = first) instanceof TextElement)) continue;
            TextElement cfr_ignored_2 = (TextElement)e;
            TextElement cfr_ignored_3 = (TextElement)e;
            String firstText = textElement.getText();
            if (!"<".equals(firstText)) continue;
            Object second = fragments.get(1);
            Object third = fragments.get(2);
            Object e3 = second;
            if (!(e3 instanceof SimpleName)) continue;
            SimpleName cfr_ignored_4 = (SimpleName)e3;
            SimpleName cfr_ignored_5 = (SimpleName)e3;
            Object e4 = third;
            if (!(e4 instanceof TextElement)) continue;
            TextElement cfr_ignored_6 = (TextElement)e4;
            TextElement cfr_ignored_7 = (TextElement)e4;
            String name = secondName.getIdentifier();
            String thirdText = thirdTextElement.getText();
            if (!elementName.equals(name) || !">".equals(thirdText)) continue;
            this.handleContentElements(fragments.subList(3, size));
            return;
        }
        if (this.fElement instanceof ILocalVariable) {
            List<String> parameterNames = this.initParameterNames();
            int i2 = parameterNames.indexOf(elementName);
            if (i2 != -1) {
                CharSequence inheritedParamDescription = this.fJavadocLookup.getInheritedParamDescription(this.fMethod, i2);
                this.handleInherited(inheritedParamDescription);
            }
        } else if (this.fElement instanceof ITypeParameter && (i = (typeParameterNames = this.initTypeParameterNames()).indexOf(elementName)) != -1) {
            CharSequence inheritedTypeParamDescription = this.fJavadocLookup.getInheritedTypeParamDescription(this.fMethod, i);
            this.handleInherited(inheritedTypeParamDescription);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void elementToHTML() {
        boolean hasExceptions;
        List<String> typeParameterNames = this.initTypeParameterNames();
        List<String> parameterNames = this.initParameterNames();
        List<String> exceptionNames = this.initExceptionNames();
        TagElement deprecatedTag = null;
        TagElement start = null;
        ArrayList<TagElement> typeParameters = new ArrayList<TagElement>();
        ArrayList<TagElement> parameters = new ArrayList<TagElement>();
        TagElement returnTag = null;
        ArrayList<TagElement> exceptions = new ArrayList<TagElement>();
        ArrayList<TagElement> versions = new ArrayList<TagElement>();
        ArrayList<TagElement> authors = new ArrayList<TagElement>();
        ArrayList<TagElement> sees = new ArrayList<TagElement>();
        ArrayList<TagElement> since = new ArrayList<TagElement>();
        ArrayList<TagElement> rest = new ArrayList<TagElement>();
        ArrayList<TagElement> apinote = new ArrayList<TagElement>(1);
        List tags = this.fJavadoc.tags();
        for (TagElement tag : tags) {
            List fragments;
            String tagName = tag.getTagName();
            if (tagName == null) {
                start = tag;
                continue;
            }
            if ("@param".equals(tagName)) {
                void thirdTextElement;
                void secondSimpleName;
                void firstTextElement;
                Object e;
                fragments = tag.fragments();
                int size = fragments.size();
                if (size <= 0) continue;
                Object first = fragments.get(0);
                Object e2 = first;
                if (e2 instanceof SimpleName) {
                    void simpleName;
                    SimpleName cfr_ignored_0 = (SimpleName)e2;
                    SimpleName cfr_ignored_1 = (SimpleName)e2;
                    String name = simpleName.getIdentifier();
                    int paramIndex = parameterNames.indexOf(name);
                    if (paramIndex != -1) {
                        parameterNames.set(paramIndex, null);
                    }
                    parameters.add(tag);
                    continue;
                }
                if (size <= 2 || !((e = first) instanceof TextElement)) continue;
                TextElement cfr_ignored_2 = (TextElement)e;
                TextElement cfr_ignored_3 = (TextElement)e;
                String firstText = firstTextElement.getText();
                if (!"<".equals(firstText)) continue;
                Object second = fragments.get(1);
                Object third = fragments.get(2);
                Object e3 = second;
                if (!(e3 instanceof SimpleName)) continue;
                SimpleName cfr_ignored_4 = (SimpleName)e3;
                SimpleName cfr_ignored_5 = (SimpleName)e3;
                Object e4 = third;
                if (!(e4 instanceof TextElement)) continue;
                TextElement cfr_ignored_6 = (TextElement)e4;
                TextElement cfr_ignored_7 = (TextElement)e4;
                String name = secondSimpleName.getIdentifier();
                String thirdText = thirdTextElement.getText();
                if (!">".equals(thirdText)) continue;
                int paramIndex = typeParameterNames.indexOf(name);
                if (paramIndex != -1) {
                    typeParameterNames.set(paramIndex, null);
                }
                typeParameters.add(tag);
                continue;
            }
            if ("@return".equals(tagName)) {
                if (returnTag != null) continue;
                returnTag = tag;
                continue;
            }
            if ("@exception".equals(tagName) || "@throws".equals(tagName)) {
                void firstName;
                Object first;
                Object e;
                exceptions.add(tag);
                fragments = tag.fragments();
                if (fragments.size() <= 0 || !((e = (first = fragments.get(0))) instanceof Name)) continue;
                Name cfr_ignored_8 = (Name)e;
                Name cfr_ignored_9 = (Name)e;
                String name = ASTNodes.getSimpleNameIdentifier((Name)firstName);
                int exceptionIndex = exceptionNames.indexOf(name);
                if (exceptionIndex == -1) continue;
                exceptionNames.set(exceptionIndex, null);
                continue;
            }
            if ("@since".equals(tagName)) {
                since.add(tag);
                continue;
            }
            if ("@version".equals(tagName)) {
                versions.add(tag);
                continue;
            }
            if ("@author".equals(tagName)) {
                authors.add(tag);
                continue;
            }
            if ("@see".equals(tagName)) {
                sees.add(tag);
                continue;
            }
            if ("@deprecated".equals(tagName)) {
                if (deprecatedTag != null) continue;
                deprecatedTag = tag;
                continue;
            }
            if ("@apiNote".equals(tagName)) {
                apinote.add(tag);
                continue;
            }
            rest.add(tag);
        }
        if (deprecatedTag != null) {
            this.handleDeprecatedTag(deprecatedTag);
        }
        if (start != null) {
            this.handleContentElements(start.fragments());
        } else if (this.fMethod != null) {
            CharSequence inherited = this.fJavadocLookup.getInheritedMainDescription(this.fMethod);
            this.handleInherited(inherited);
        }
        CharSequence[] typeParameterDescriptions = new CharSequence[typeParameterNames.size()];
        boolean hasInheritedTypeParameters = this.inheritTypeParameterDescriptions(typeParameterNames, typeParameterDescriptions);
        boolean hasTypeParameters = typeParameters.size() > 0 || hasInheritedTypeParameters;
        CharSequence[] parameterDescriptions = new CharSequence[parameterNames.size()];
        boolean hasInheritedParameters = this.inheritParameterDescriptions(parameterNames, parameterDescriptions);
        boolean hasParameters = parameters.size() > 0 || hasInheritedParameters;
        CharSequence returnDescription = null;
        if (returnTag == null && this.needsReturnTag()) {
            returnDescription = this.fJavadocLookup.getInheritedReturnDescription(this.fMethod);
        }
        boolean hasReturnTag = returnTag != null || returnDescription != null;
        CharSequence[] exceptionDescriptions = new CharSequence[exceptionNames.size()];
        boolean hasInheritedExceptions = this.inheritExceptionDescriptions(exceptionNames, exceptionDescriptions);
        boolean bl = hasExceptions = exceptions.size() > 0 || hasInheritedExceptions;
        if (hasParameters || hasTypeParameters || hasReturnTag || hasExceptions || versions.size() > 0 || authors.size() > 0 || since.size() > 0 || sees.size() > 0 || rest.size() > 0 || apinote.size() > 0 || this.fBuf.length() > 0 && (parameterDescriptions.length > 0 || exceptionDescriptions.length > 0)) {
            this.handleSuperMethodReferences();
            this.fBuf.append(BLOCK_TAG_START);
            this.handleParameterTags(typeParameters, typeParameterNames, typeParameterDescriptions, true);
            this.handleParameterTags(parameters, parameterNames, parameterDescriptions, false);
            this.handleReturnTag(returnTag, returnDescription);
            this.handleExceptionTags(exceptions, exceptionNames, exceptionDescriptions);
            this.handleBlockTags(JavaDoc2HTMLTextReader_since_section, since);
            this.handleBlockTags(JavaDoc2HTMLTextReader_version_section, versions);
            this.handleBlockTags(JavaDoc2HTMLTextReader_author_section, authors);
            this.handleBlockTags(JavaDoc2HTMLTextReader_see_section, sees);
            this.handleBlockTags(JavaDoc2HTMLTextReader_api_note, apinote);
            this.handleBlockTags(rest);
            this.fBuf.append(BLOCK_TAG_END);
        } else if (this.fBuf.length() > 0) {
            this.handleSuperMethodReferences();
        }
    }

    private void handleDeprecatedTag(TagElement tag) {
        this.fBuf.append("<p><b>");
        this.fBuf.append(JavaDoc2HTMLTextReader_deprecated_section);
        this.fBuf.append("</b> <i>");
        this.handleContentElements(tag.fragments());
        this.fBuf.append("</i><p>");
    }

    private void handleSuperMethodReferences() {
        if (this.fMethod != null) {
            try {
                StringBuffer superMethodReferences = JavadocContentAccess2.createSuperMethodReferences(this.fMethod);
                if (superMethodReferences != null) {
                    this.fBuf.append(superMethodReferences);
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    private List<String> initTypeParameterNames() {
        if (this.fMethod != null) {
            try {
                ArrayList<String> typeParameterNames = new ArrayList<String>();
                ITypeParameter[] iTypeParameterArray = this.fMethod.getTypeParameters();
                int n = iTypeParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeParameter typeParameter = iTypeParameterArray[n2];
                    typeParameterNames.add(typeParameter.getElementName());
                    ++n2;
                }
                return typeParameterNames;
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    private List<String> initParameterNames() {
        if (this.fMethod != null) {
            try {
                return new ArrayList<String>(Arrays.asList(this.fMethod.getParameterNames()));
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    private List<String> initExceptionNames() {
        if (this.fMethod != null) {
            try {
                String[] exceptionTypes = this.fMethod.getExceptionTypes();
                ArrayList<String> exceptionNames = new ArrayList<String>();
                int i = 0;
                while (i < exceptionTypes.length) {
                    exceptionNames.add(Signature.getSimpleName((String)Signature.toString((String)exceptionTypes[i])));
                    ++i;
                }
                return exceptionNames;
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    private boolean needsReturnTag() {
        if (this.fMethod == null) {
            return false;
        }
        try {
            return !"V".equals(this.fMethod.getReturnType());
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    private boolean inheritTypeParameterDescriptions(List<String> typeParameterNames, CharSequence[] typeParameterDescriptions) {
        boolean hasInheritedTypeParameters = false;
        int i = 0;
        while (i < typeParameterNames.size()) {
            String name = typeParameterNames.get(i);
            if (name != null) {
                typeParameterDescriptions[i] = this.fJavadocLookup.getInheritedTypeParamDescription(this.fMethod, i);
                if (typeParameterDescriptions[i] != null) {
                    hasInheritedTypeParameters = true;
                }
            }
            ++i;
        }
        return hasInheritedTypeParameters;
    }

    private boolean inheritParameterDescriptions(List<String> parameterNames, CharSequence[] parameterDescriptions) {
        boolean hasInheritedParameters = false;
        int i = 0;
        while (i < parameterNames.size()) {
            String name = parameterNames.get(i);
            if (name != null) {
                parameterDescriptions[i] = this.fJavadocLookup.getInheritedParamDescription(this.fMethod, i);
                if (parameterDescriptions[i] != null) {
                    hasInheritedParameters = true;
                }
            }
            ++i;
        }
        return hasInheritedParameters;
    }

    private boolean inheritExceptionDescriptions(List<String> exceptionNames, CharSequence[] exceptionDescriptions) {
        boolean hasInheritedExceptions = false;
        int i = 0;
        while (i < exceptionNames.size()) {
            String name = exceptionNames.get(i);
            if (name != null) {
                exceptionDescriptions[i] = this.fJavadocLookup.getInheritedExceptionDescription(this.fMethod, name);
                if (exceptionDescriptions[i] != null) {
                    hasInheritedExceptions = true;
                }
            }
            ++i;
        }
        return hasInheritedExceptions;
    }

    CharSequence getMainDescription() {
        if (this.fMainDescription == null) {
            this.fBuf = this.fMainDescription = new StringBuffer();
            this.fLiteralContent = 0;
            List tags = this.fJavadoc.tags();
            for (TagElement tag : tags) {
                String tagName = tag.getTagName();
                if (tagName != null) continue;
                this.handleContentElements(tag.fragments());
                break;
            }
            this.fBuf = null;
        }
        return this.fMainDescription.length() > 0 ? this.fMainDescription : null;
    }

    CharSequence getReturnDescription() {
        if (this.fReturnDescription == null) {
            this.fBuf = this.fReturnDescription = new StringBuffer();
            this.fLiteralContent = 0;
            List tags = this.fJavadoc.tags();
            for (TagElement tag : tags) {
                String tagName = tag.getTagName();
                if (!"@return".equals(tagName)) continue;
                this.handleContentElements(tag.fragments());
                break;
            }
            this.fBuf = null;
        }
        return this.fReturnDescription.length() > 0 ? this.fReturnDescription : null;
    }

    /*
     * WARNING - void declaration
     */
    CharSequence getInheritedTypeParamDescription(int typeParamIndex) {
        if (this.fMethod != null) {
            StringBuffer description;
            List<String> typeParameterNames = this.initTypeParameterNames();
            if (this.fTypeParamDescriptions == null) {
                this.fTypeParamDescriptions = new StringBuffer[typeParameterNames.size()];
            } else {
                description = this.fTypeParamDescriptions[typeParamIndex];
                if (description != null) {
                    return description.length() > 0 ? description : null;
                }
            }
            this.fTypeParamDescriptions[typeParamIndex] = description = new StringBuffer();
            this.fBuf = description;
            this.fLiteralContent = 0;
            String typeParamName = typeParameterNames.get(typeParamIndex);
            List tags = this.fJavadoc.tags();
            for (TagElement tag : tags) {
                void secondSimpleName;
                String name;
                void thirdTextElement;
                void firstTextElement;
                List fragments;
                String tagName = tag.getTagName();
                if (!"@param".equals(tagName) || (fragments = tag.fragments()).size() <= 2) continue;
                Object first = fragments.get(0);
                Object second = fragments.get(1);
                Object third = fragments.get(2);
                Object e = first;
                if (!(e instanceof TextElement)) continue;
                TextElement cfr_ignored_0 = (TextElement)e;
                TextElement cfr_ignored_1 = (TextElement)e;
                Object e2 = second;
                if (!(e2 instanceof SimpleName)) continue;
                SimpleName cfr_ignored_2 = (SimpleName)e2;
                SimpleName cfr_ignored_3 = (SimpleName)e2;
                Object e3 = third;
                if (!(e3 instanceof TextElement)) continue;
                TextElement cfr_ignored_4 = (TextElement)e3;
                TextElement cfr_ignored_5 = (TextElement)e3;
                String firstText = firstTextElement.getText();
                String thirdText = thirdTextElement.getText();
                if (!"<".equals(firstText) || !">".equals(thirdText) || !(name = secondSimpleName.getIdentifier()).equals(typeParamName)) continue;
                this.handleContentElements(fragments.subList(3, fragments.size()));
                break;
            }
            this.fBuf = null;
            return description.length() > 0 ? description : null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    CharSequence getInheritedParamDescription(int paramIndex) throws JavaModelException {
        if (this.fMethod != null) {
            StringBuffer description;
            String[] parameterNames = this.fMethod.getParameterNames();
            if (this.fParamDescriptions == null) {
                this.fParamDescriptions = new StringBuffer[parameterNames.length];
            } else {
                description = this.fParamDescriptions[paramIndex];
                if (description != null) {
                    return description.length() > 0 ? description : null;
                }
            }
            this.fParamDescriptions[paramIndex] = description = new StringBuffer();
            this.fBuf = description;
            this.fLiteralContent = 0;
            String paramName = parameterNames[paramIndex];
            List tags = this.fJavadoc.tags();
            for (TagElement tag : tags) {
                void simpleName;
                Object first;
                Object e;
                List fragments;
                String tagName = tag.getTagName();
                if (!"@param".equals(tagName) || (fragments = tag.fragments()).size() <= 0 || !((e = (first = fragments.get(0))) instanceof SimpleName)) continue;
                SimpleName cfr_ignored_0 = (SimpleName)e;
                SimpleName cfr_ignored_1 = (SimpleName)e;
                String name = simpleName.getIdentifier();
                if (!name.equals(paramName)) continue;
                this.handleContentElements(fragments.subList(1, fragments.size()));
                break;
            }
            this.fBuf = null;
            return description.length() > 0 ? description : null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    CharSequence getExceptionDescription(String simpleName) {
        if (this.fMethod != null) {
            StringBuffer description;
            if (this.fExceptionDescriptions == null) {
                this.fExceptionDescriptions = new HashMap();
            } else {
                description = this.fExceptionDescriptions.get(simpleName);
                if (description != null) {
                    return description.length() > 0 ? description : null;
                }
            }
            description = new StringBuffer();
            this.fExceptionDescriptions.put(simpleName, description);
            this.fBuf = description;
            this.fLiteralContent = 0;
            List tags = this.fJavadoc.tags();
            for (TagElement tag : tags) {
                void firstName;
                Object first;
                Object e;
                List fragments;
                String tagName = tag.getTagName();
                if (!"@throws".equals(tagName) && !"@exception".equals(tagName) || (fragments = tag.fragments()).size() <= 0 || !((e = (first = fragments.get(0))) instanceof Name)) continue;
                Name cfr_ignored_0 = (Name)e;
                Name cfr_ignored_1 = (Name)e;
                String name = ASTNodes.getSimpleNameIdentifier((Name)firstName);
                if (!name.equals(simpleName)) continue;
                if (fragments.size() <= 1) break;
                this.handleContentElements(fragments.subList(1, fragments.size()));
                break;
            }
            this.fBuf = null;
            return description.length() > 0 ? description : null;
        }
        return null;
    }

    private void handleContentElements(List<? extends ASTNode> nodes) {
        this.handleContentElements(nodes, false);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void handleContentElements(List<? extends ASTNode> nodes, boolean skipLeadingWhitespace) {
        previousNode = null;
        for (ASTNode child : nodes) {
            var9_8 = previousNode;
            if (!(var9_8 instanceof TagElement)) ** GOTO lbl-1000
            (TagElement)var9_8;
            (TagElement)var9_8;
            if ("@snippet".equals(previousTag.getTagName())) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = isInSnippet = false;
            }
            if (previousNode != null) {
                previousEnd = previousNode.getStartPosition() + previousNode.getLength();
                if (previousEnd > (childStart = child.getStartPosition())) {
                    var12_12 /* !! */  = new Exception("Illegal ASTNode positions: previousEnd=" + previousEnd + ", childStart=" + childStart + ", element=" + this.fElement.getHandleIdentifier() + ", Javadoc:\n" + this.fSource);
                } else if (previousEnd != childStart) {
                    textWithStars = this.fSource.substring(previousEnd, childStart);
                    text = this.removeDocLineIntros(textWithStars);
                    this.fBuf.append((String)text);
                }
            }
            previousNode = child;
            var12_12 /* !! */  = child;
            if (var12_12 /* !! */  instanceof TextElement) {
                (TextElement)var12_12 /* !! */ ;
                (TextElement)var12_12 /* !! */ ;
                text = textElement.getText();
                if (JavaDocHTMLPathHandler.containsHTMLTag((String)text)) {
                    text = JavaDocHTMLPathHandler.getValidatedHTMLSrcAttribute((TextElement)textElement, this.fElement);
                }
                if (skipLeadingWhitespace) {
                    text = text.stripLeading();
                }
                text = text.replaceAll("(\r\n?|\n)([ \t]*\\*)", "$1");
                this.handleText(this.markSnippet((String)text, isInSnippet));
                continue;
            }
            var15_14 = child;
            if (var15_14 instanceof TagElement) {
                (TagElement)var15_14;
                (TagElement)var15_14;
                this.handleInlineTagElement((TagElement)tagElement);
                continue;
            }
            start = child.getStartPosition();
            text = this.fSource.substring(start, start + child.getLength());
            this.fBuf.append(this.removeDocLineIntros(text));
        }
    }

    private String markSnippet(String text, boolean isInSnippet) {
        if (isInSnippet) {
            StringBuilder builder = new StringBuilder();
            text.lines().forEach(l -> {
                builder.append("SNIPPET");
                builder.append((String)l);
                builder.append("\n");
            });
            return builder.toString();
        }
        return text;
    }

    private String removeDocLineIntros(String textWithStars) {
        String lineBreakGroup = "(\\r\\n?|\\n)";
        String noBreakSpace = "[^\r\n&&\\s]";
        return textWithStars.replaceAll(String.valueOf(lineBreakGroup) + noBreakSpace + "*\\*", "$1");
    }

    private void handleText(String text) {
        if (this.fLiteralContent == 0) {
            this.fBuf.append(text);
        } else {
            JavadocContentAccess2.appendEscaped(this.fBuf, text);
        }
    }

    private static void appendEscaped(StringBuffer buf, String text) {
        int nextToCopy = 0;
        int length = text.length();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            String rep = null;
            switch (ch) {
                case '&': {
                    rep = "&amp;";
                    break;
                }
                case '\"': {
                    rep = "&quot;";
                    break;
                }
                case '<': {
                    rep = "&lt;";
                    break;
                }
                case '>': {
                    rep = "&gt;";
                }
            }
            if (rep != null) {
                if (nextToCopy < i) {
                    buf.append(text.substring(nextToCopy, i));
                }
                buf.append(rep);
                nextToCopy = i + 1;
            }
            ++i;
        }
        if (nextToCopy < length) {
            buf.append(text.substring(nextToCopy));
        }
    }

    private void handleInlineTagElement(TagElement node) {
        String name = node.getTagName();
        if ("@value".equals(name) && this.handleValueTag(node)) {
            return;
        }
        boolean isLink = "@link".equals(name);
        boolean isLinkplain = "@linkplain".equals(name);
        boolean isCode = "@code".equals(name);
        boolean isLiteral = "@literal".equals(name);
        boolean isSummary = "@summary".equals(name);
        boolean isIndex = "@index".equals(name);
        boolean isSnippet = "@snippet".equals(name);
        if (isLiteral || isCode || isSummary || isIndex) {
            ++this.fLiteralContent;
        }
        if (isCode) {
            this.fBuf.append("<code>");
        }
        if (isLink || isLinkplain) {
            this.handleLink(node.fragments());
        } else if (isSummary) {
            this.handleSummary(node.fragments());
        } else if (isIndex) {
            this.handleIndex(node.fragments());
        } else if (isCode || isLiteral) {
            this.handleContentElements(node.fragments(), true);
        } else if (isSnippet) {
            this.handleSnippet(node);
        } else if (!this.handleInheritDoc(node) && !this.handleDocRoot(node)) {
            int start = node.getStartPosition();
            String text = this.fSource.substring(start, start + node.getLength());
            this.fBuf.append(this.removeDocLineIntros(text));
        }
        if (isCode) {
            this.fBuf.append("</code>");
        }
        if (isSnippet) {
            this.fBuf.append("</code></pre>");
        }
        if (isLiteral || isCode) {
            --this.fLiteralContent;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean handleValueTag(TagElement node) {
        block12: {
            List fragments;
            block11: {
                fragments = node.fragments();
                if (this.fElement instanceof IMember) break block11;
                return false;
            }
            try {
                IType iType;
                void memberRef;
                Object first;
                Object e;
                if (fragments.isEmpty()) {
                    IJavaElement iJavaElement = this.fElement;
                    if (iJavaElement instanceof IField) {
                        IField iField = (IField)iJavaElement;
                        IField cfr_ignored_0 = (IField)iJavaElement;
                        if (JdtFlags.isStatic((IMember)((IField)this.fElement)) && JdtFlags.isFinal((IMember)((IField)this.fElement))) {
                            void field;
                            return this.handleConstantValue((IField)field, false);
                        }
                    }
                    break block12;
                }
                if (fragments.size() != 1 || !((e = (first = fragments.get(0))) instanceof MemberRef)) break block12;
                MemberRef memberRef2 = (MemberRef)e;
                MemberRef cfr_ignored_1 = (MemberRef)e;
                if (memberRef.getQualifier() != null) break block12;
                SimpleName name = memberRef.getName();
                IJavaElement iJavaElement = this.fElement;
                if (iJavaElement instanceof IType) {
                    void typeElement;
                    IType iType2 = (IType)iJavaElement;
                    IType cfr_ignored_2 = (IType)iJavaElement;
                    iType = typeElement;
                } else {
                    iType = ((IMember)this.fElement).getDeclaringType();
                }
                IType type = iType;
                while (type != null) {
                    IField field = type.getField(name.getIdentifier());
                    if (field != null && field.exists()) {
                        if (JdtFlags.isStatic((IMember)field) && JdtFlags.isFinal((IMember)field)) {
                            return this.handleConstantValue(field, true);
                        }
                        break;
                    }
                    type = type.getDeclaringType();
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean handleConstantValue(IField field, boolean link) throws JavaModelException {
        Object constant;
        ASTNode nameNode;
        ASTNode aSTNode;
        CompilationUnit cuNode;
        String text = null;
        ISourceRange nameRange = field.getNameRange();
        if (SourceRange.isAvailable((ISourceRange)nameRange) && (cuNode = CoreASTProvider.getInstance().getAST(field.getTypeRoot(), CoreASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor())) != null && (aSTNode = (nameNode = NodeFinder.perform((ASTNode)cuNode, (ISourceRange)nameRange))) instanceof SimpleName) {
            void simpleName;
            IBinding binding;
            SimpleName simpleName2 = (SimpleName)aSTNode;
            SimpleName cfr_ignored_0 = (SimpleName)aSTNode;
            IBinding iBinding = binding = simpleName.resolveBinding();
            if (iBinding instanceof IVariableBinding) {
                void variableBinding;
                IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
                IVariableBinding cfr_ignored_1 = (IVariableBinding)iBinding;
                Object constantValue = variableBinding.getConstantValue();
                if (constantValue != null) {
                    Object object = constantValue;
                    if (object instanceof String) {
                        void s;
                        String string = (String)object;
                        String cfr_ignored_2 = (String)object;
                        text = ASTNodes.getEscapedStringLiteral((String)s);
                    } else {
                        text = constantValue.toString();
                    }
                }
            }
        }
        if (text == null && (constant = field.getConstant()) != null) {
            text = constant.toString();
        }
        if (text != null) {
            text = JavadocContentAccess2.convertToHTMLContentWithWhitespace(text);
            if (link) {
                try {
                    String uri = JavaElementLinks.createURI("eclipse-javadoc", (IJavaElement)field);
                    this.fBuf.append(JavaElementLinks.createLink(uri, text));
                }
                catch (URISyntaxException e) {
                    return false;
                }
            } else {
                this.handleText(text);
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean handleDocRoot(TagElement node) {
        if (!"@docRoot".equals(node.getTagName())) {
            return false;
        }
        try {
            url = null;
            var5_4 = this.fElement;
            if (!(var5_4 instanceof IMember)) ** GOTO lbl-1000
            var3_5 = (IMember)var5_4;
            (IMember)var5_4;
            if (member.isBinary()) {
                javadocBaseLocation = JavaDocLocations.getJavadocBaseLocation(this.fElement);
                if (javadocBaseLocation != null) {
                    url = javadocBaseLocation.toExternalForm();
                }
            } else if ((srcRoot = JavaModelUtil.getPackageFragmentRoot((IJavaElement)this.fElement)) != null && (resource = srcRoot.getResource()) != null && (location = resource.getLocation()) != null) {
                url = location.toFile().toURI().toASCIIString();
            }
            if (url != null) {
                if (url.endsWith("/")) {
                    url = url.substring(0, url.length() - 1);
                }
                this.fBuf.append(url);
                return true;
            }
        }
        catch (JavaModelException var2_3) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean handleInheritDoc(TagElement node) {
        block21: {
            if (!"@inheritDoc".equals(node.getTagName())) {
                return false;
            }
            if (this.fMethod != null) break block21;
            return false;
        }
        try {
            TagElement blockTag = (TagElement)node.getParent();
            String blockTagName = blockTag.getTagName();
            if (blockTagName == null) {
                CharSequence inherited = this.fJavadocLookup.getInheritedMainDescription(this.fMethod);
                return this.handleInherited(inherited);
            }
            if ("@param".equals(blockTagName)) {
                List fragments = blockTag.fragments();
                int size = fragments.size();
                if (size > 0) {
                    Object e;
                    Object first2 = fragments.get(0);
                    Object e2 = first2;
                    if (e2 instanceof SimpleName) {
                        void simpleName;
                        SimpleName simpleName2 = (SimpleName)e2;
                        SimpleName cfr_ignored_0 = (SimpleName)e2;
                        String name = simpleName.getIdentifier();
                        String[] parameterNames = this.fMethod.getParameterNames();
                        int i = 0;
                        while (i < parameterNames.length) {
                            if (name.equals(parameterNames[i])) {
                                CharSequence inherited = this.fJavadocLookup.getInheritedParamDescription(this.fMethod, i);
                                return this.handleInherited(inherited);
                            }
                            ++i;
                        }
                    } else if (size > 2 && (e = first2) instanceof TextElement) {
                        void firstTextElement;
                        TextElement name = (TextElement)e;
                        TextElement cfr_ignored_1 = (TextElement)e;
                        String firstText = firstTextElement.getText();
                        if ("<".equals(firstText)) {
                            Object second = fragments.get(1);
                            Object third = fragments.get(2);
                            Object e3 = second;
                            if (e3 instanceof SimpleName) {
                                SimpleName simpleName = (SimpleName)e3;
                                SimpleName cfr_ignored_2 = (SimpleName)e3;
                                Object e4 = third;
                                if (e4 instanceof TextElement) {
                                    void thirdTextElement;
                                    TextElement textElement = (TextElement)e4;
                                    TextElement cfr_ignored_3 = (TextElement)e4;
                                    String thirdText = thirdTextElement.getText();
                                    if (">".equals(thirdText)) {
                                        void secondSimpleName;
                                        String name2 = secondSimpleName.getIdentifier();
                                        ITypeParameter[] typeParameters = this.fMethod.getTypeParameters();
                                        int i = 0;
                                        while (i < typeParameters.length) {
                                            ITypeParameter typeParameter = typeParameters[i];
                                            if (name2.equals(typeParameter.getElementName())) {
                                                CharSequence inherited = this.fJavadocLookup.getInheritedTypeParamDescription(this.fMethod, i);
                                                return this.handleInherited(inherited);
                                            }
                                            ++i;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                Object first;
                Object e;
                List fragments;
                if ("@return".equals(blockTagName)) {
                    CharSequence inherited = this.fJavadocLookup.getInheritedReturnDescription(this.fMethod);
                    return this.handleInherited(inherited);
                }
                if (("@throws".equals(blockTagName) || "@exception".equals(blockTagName)) && (fragments = blockTag.fragments()).size() > 0 && (e = (first = fragments.get(0))) instanceof Name) {
                    void firstName;
                    Name first2 = (Name)e;
                    Name cfr_ignored_4 = (Name)e;
                    String name = ASTNodes.getSimpleNameIdentifier((Name)firstName);
                    CharSequence inherited = this.fJavadocLookup.getInheritedExceptionDescription(this.fMethod, name);
                    return this.handleInherited(inherited);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    private boolean handleInherited(CharSequence inherited) {
        if (inherited == null) {
            return false;
        }
        this.fBuf.append(inherited);
        return true;
    }

    private void handleBlockTags(String title, List<TagElement> tags) {
        if (tags.isEmpty()) {
            return;
        }
        this.handleBlockTagTitle(title);
        for (TagElement tag : tags) {
            this.fBuf.append(BLOCK_TAG_START);
            this.fBuf.append(BlOCK_TAG_ENTRY_START);
            if ("@see".equals(tag.getTagName())) {
                this.handleSeeTag(tag);
            } else {
                this.handleContentElements(tag.fragments());
            }
            this.fBuf.append(BlOCK_TAG_ENTRY_END);
            this.fBuf.append(BLOCK_TAG_END);
        }
        this.fBuf.append(BlOCK_TAG_ENTRY_END);
    }

    private void handleReturnTag(TagElement tag, CharSequence returnDescription) {
        if (tag == null && returnDescription == null) {
            return;
        }
        this.handleBlockTagTitle(JavaDoc2HTMLTextReader_returns_section);
        this.fBuf.append(BLOCK_TAG_START);
        this.fBuf.append(BlOCK_TAG_ENTRY_START);
        if (tag != null) {
            this.handleContentElements(tag.fragments());
        } else {
            this.fBuf.append(returnDescription);
        }
        this.fBuf.append(BlOCK_TAG_ENTRY_END);
        this.fBuf.append(BLOCK_TAG_END);
        this.fBuf.append(BlOCK_TAG_ENTRY_END);
    }

    private void handleBlockTags(List<TagElement> tags) {
        for (TagElement tag : tags) {
            this.handleBlockTagTitle(tag.getTagName());
            List fragments = tag.fragments();
            if (!fragments.isEmpty()) {
                this.fBuf.append(BLOCK_TAG_START);
                this.fBuf.append(BlOCK_TAG_ENTRY_START);
                this.handleContentElements(fragments);
                this.fBuf.append(BlOCK_TAG_ENTRY_END);
                this.fBuf.append(BLOCK_TAG_END);
            }
            this.fBuf.append(BlOCK_TAG_ENTRY_END);
        }
    }

    private void handleBlockTagTitle(String title) {
        this.fBuf.append("<li><b>");
        this.fBuf.append(title);
        this.fBuf.append("</b>");
    }

    private void handleSeeTag(TagElement tag) {
        this.handleLink(tag.fragments());
    }

    private void handleExceptionTags(List<TagElement> tags, List<String> exceptionNames, CharSequence[] exceptionDescriptions) {
        if (tags.size() == 0 && this.containsOnlyNull(exceptionNames)) {
            return;
        }
        this.handleBlockTagTitle(JavaDoc2HTMLTextReader_throws_section);
        this.fBuf.append(BLOCK_TAG_START);
        for (TagElement tag : tags) {
            this.fBuf.append(BlOCK_TAG_ENTRY_START);
            this.handleThrowsTag(tag);
            this.fBuf.append(BlOCK_TAG_ENTRY_END);
        }
        int i = 0;
        while (i < exceptionDescriptions.length) {
            CharSequence description = exceptionDescriptions[i];
            String name = exceptionNames.get(i);
            if (name != null) {
                this.fBuf.append(BlOCK_TAG_ENTRY_START);
                this.handleLink(Collections.singletonList(this.fJavadoc.getAST().newSimpleName(name)));
                if (description != null) {
                    this.fBuf.append(" - ");
                    this.fBuf.append(description);
                }
                this.fBuf.append(BlOCK_TAG_ENTRY_END);
            }
            ++i;
        }
        this.fBuf.append(BLOCK_TAG_END);
        this.fBuf.append(BlOCK_TAG_ENTRY_END);
    }

    private void handleThrowsTag(TagElement tag) {
        List fragments = tag.fragments();
        int size = fragments.size();
        if (size > 0) {
            this.handleLink(fragments.subList(0, 1));
            if (size > 1) {
                this.fBuf.append(" - ");
                this.handleContentElements(fragments.subList(1, size));
            }
        }
    }

    private void handleParameterTags(List<TagElement> tags, List<String> parameterNames, CharSequence[] parameterDescriptions, boolean isTypeParameters) {
        if (tags.size() == 0 && this.containsOnlyNull(parameterNames)) {
            return;
        }
        String tagTitle = isTypeParameters ? JavaDoc2HTMLTextReader_type_parameters_section : JavaDoc2HTMLTextReader_parameters_section;
        this.handleBlockTagTitle(tagTitle);
        for (TagElement tag : tags) {
            this.fBuf.append(BLOCK_TAG_START);
            this.fBuf.append(BlOCK_TAG_ENTRY_START);
            this.handleParamTag(tag);
            this.fBuf.append(BlOCK_TAG_ENTRY_END);
            this.fBuf.append(BLOCK_TAG_END);
        }
        int i = 0;
        while (i < parameterDescriptions.length) {
            CharSequence description = parameterDescriptions[i];
            String name = parameterNames.get(i);
            if (name != null) {
                this.fBuf.append(BLOCK_TAG_START);
                this.fBuf.append(BlOCK_TAG_ENTRY_START);
                this.fBuf.append(PARAM_NAME_START);
                if (isTypeParameters) {
                    this.fBuf.append("&lt;");
                }
                this.fBuf.append(name);
                if (isTypeParameters) {
                    this.fBuf.append("&gt;");
                }
                this.fBuf.append(PARAM_NAME_END);
                if (description != null) {
                    this.fBuf.append(description);
                }
                this.fBuf.append(BlOCK_TAG_ENTRY_END);
                this.fBuf.append(BLOCK_TAG_END);
            }
            ++i;
        }
        this.fBuf.append(BlOCK_TAG_ENTRY_END);
    }

    /*
     * WARNING - void declaration
     */
    private void handleParamTag(TagElement tag) {
        List fragments = tag.fragments();
        int i = 0;
        int size = fragments.size();
        if (size > 0) {
            Object first = fragments.get(0);
            this.fBuf.append(PARAM_NAME_START);
            Object e = first;
            if (e instanceof SimpleName) {
                void simpleName;
                SimpleName simpleName2 = (SimpleName)e;
                SimpleName cfr_ignored_0 = (SimpleName)e;
                String name = simpleName.getIdentifier();
                this.fBuf.append(name);
                ++i;
            } else {
                Object e2 = first;
                if (e2 instanceof TextElement) {
                    void textElement;
                    TextElement name = (TextElement)e2;
                    TextElement cfr_ignored_1 = (TextElement)e2;
                    String firstText = textElement.getText();
                    if ("<".equals(firstText)) {
                        Object second;
                        Object e3;
                        this.fBuf.append("&lt;");
                        ++i;
                        if (size > 1 && (e3 = (second = fragments.get(1))) instanceof SimpleName) {
                            Object third;
                            String thirdText;
                            void secondSimpleName;
                            SimpleName simpleName = (SimpleName)e3;
                            SimpleName cfr_ignored_2 = (SimpleName)e3;
                            String name2 = secondSimpleName.getIdentifier();
                            this.fBuf.append(name2);
                            ++i;
                            if (size > 2 && ">".equals(thirdText = ((TextElement)(third = fragments.get(2))).getText())) {
                                this.fBuf.append("&gt;");
                                ++i;
                            }
                        }
                    }
                }
            }
            this.fBuf.append(PARAM_NAME_END);
            this.handleContentElements(fragments.subList(i, fragments.size()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleSummary(List<? extends ASTNode> fragments) {
        ASTNode first;
        ASTNode aSTNode;
        int fs = fragments.size();
        if (fs > 0 && (aSTNode = (first = fragments.get(0))) instanceof TextElement) {
            void memberRef;
            TextElement textElement = (TextElement)aSTNode;
            TextElement cfr_ignored_0 = (TextElement)aSTNode;
            this.fBuf.append("<dt>Summary: " + memberRef.getText() + BlOCK_TAG_TITLE_END);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void handleSnippet(TagElement node) {
        if (node == null) return;
        Object val = node.getProperty("IsSnippetValid");
        Object valError = node.getProperty("SnippetError");
        Object object = val;
        if (object instanceof Boolean) {
            void bool;
            Boolean bl = (Boolean)object;
            Boolean cfr_ignored_0 = (Boolean)object;
            if (bool.booleanValue() && valError == null) {
                int fs = node.fragments().size();
                if (fs <= 0) return;
                this.fBuf.append("<pre>");
                Object valID = node.getProperty("SnippetID");
                if (valID instanceof String && !valID.toString().isBlank()) {
                    this.fBuf.append("<code id=" + valID.toString() + ">");
                } else {
                    this.fBuf.append("<code>");
                }
                this.fBuf.append(BlOCK_TAG_ENTRY_START);
                this.fSnippetStringEvaluator.AddTagElementString(node, this.fBuf);
                this.fBuf.append(BlOCK_TAG_ENTRY_END);
                return;
            }
        }
        this.handleInvalidSnippet(node);
    }

    private void handleInvalidSnippet(TagElement node) {
        this.fBuf.append("<pre><code>\n");
        this.fBuf.append("<mark>invalid @Snippet</mark>");
        Object val = node.getProperty("SnippetError");
        if (val instanceof String) {
            this.fBuf.append("<br><p>" + val + "</p>");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleIndex(List<? extends ASTNode> fragments) {
        ASTNode first;
        ASTNode aSTNode;
        int fs = fragments.size();
        if (fs > 0 && (aSTNode = (first = fragments.get(0))) instanceof TextElement) {
            void memberRef;
            TextElement textElement = (TextElement)aSTNode;
            TextElement cfr_ignored_0 = (TextElement)aSTNode;
            this.fBuf.append(memberRef.getText());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleLink(List<? extends ASTNode> fragments) {
        int fs = fragments.size();
        if (fs > 0) {
            ASTNode first = fragments.get(0);
            String refTypeName = null;
            String refMemberName = null;
            String[] refMethodParamTypes = null;
            String[] refMethodParamNames = null;
            int startPosition = -1;
            ASTNode aSTNode = first;
            if (aSTNode instanceof Name) {
                void name;
                Name name2 = (Name)aSTNode;
                Name cfr_ignored_0 = (Name)aSTNode;
                refTypeName = name.getFullyQualifiedName();
                startPosition = name.getStartPosition();
            } else {
                ASTNode aSTNode2 = first;
                if (aSTNode2 instanceof MemberRef) {
                    void memberRef;
                    MemberRef memberRef2 = (MemberRef)aSTNode2;
                    MemberRef cfr_ignored_1 = (MemberRef)aSTNode2;
                    qualifier = memberRef.getQualifier();
                    refTypeName = qualifier == null ? "" : qualifier.getFullyQualifiedName();
                    refMemberName = memberRef.getName().getIdentifier();
                    startPosition = memberRef.getStartPosition();
                } else {
                    ASTNode aSTNode3 = first;
                    if (aSTNode3 instanceof MethodRef) {
                        void methodRef;
                        qualifier = (MethodRef)aSTNode3;
                        MethodRef cfr_ignored_2 = (MethodRef)aSTNode3;
                        Name qualifier = methodRef.getQualifier();
                        refTypeName = qualifier == null ? "" : qualifier.getFullyQualifiedName();
                        refMemberName = methodRef.getName().getIdentifier();
                        List params = methodRef.parameters();
                        int ps = params.size();
                        refMethodParamTypes = new String[ps];
                        refMethodParamNames = new String[ps];
                        int i = 0;
                        while (i < ps) {
                            MethodRefParameter param = (MethodRefParameter)params.get(i);
                            refMethodParamTypes[i] = ASTNodes.asString((ASTNode)param.getType());
                            SimpleName paramName = param.getName();
                            if (paramName != null) {
                                refMethodParamNames[i] = paramName.getIdentifier();
                            }
                            ++i;
                        }
                        startPosition = methodRef.getStartPosition();
                    }
                }
            }
            if (refTypeName != null) {
                this.fBuf.append("<a href=\"");
                try {
                    String uri = JavaElementLinks.createURI("file", this.fElement, refTypeName, refMemberName, refMethodParamTypes, startPosition);
                    this.fBuf.append(uri);
                }
                catch (URISyntaxException uri) {
                    // empty catch block
                }
                this.fBuf.append("\">");
                if (!(fs <= 1 || fs == 2 && JavadocContentAccess2.isWhitespaceTextElement(fragments.get(1)))) {
                    this.handleContentElements(fragments.subList(1, fs), true);
                } else {
                    this.fBuf.append(refTypeName);
                    if (refMemberName != null) {
                        if (refTypeName.length() > 0) {
                            this.fBuf.append('.');
                        }
                        this.fBuf.append(refMemberName);
                        if (refMethodParamTypes != null) {
                            this.fBuf.append('(');
                            int i = 0;
                            while (i < refMethodParamTypes.length) {
                                String pType = refMethodParamTypes[i];
                                this.fBuf.append(pType);
                                String pName = refMethodParamNames[i];
                                if (pName != null) {
                                    this.fBuf.append(' ').append(pName);
                                }
                                if (i < refMethodParamTypes.length - 1) {
                                    this.fBuf.append(", ");
                                }
                                ++i;
                            }
                            this.fBuf.append(')');
                        }
                    }
                }
                this.fBuf.append("</a>");
            } else {
                this.handleContentElements(fragments);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isWhitespaceTextElement(Object fragment) {
        Object object = fragment;
        if (object instanceof TextElement) {
            void textElement;
            TextElement textElement2 = (TextElement)object;
            TextElement cfr_ignored_0 = (TextElement)object;
            if (textElement.getText().trim().length() == 0) {
                return true;
            }
        }
        return false;
    }

    private boolean containsOnlyNull(List<String> parameterNames) {
        Iterator<String> iter = parameterNames.iterator();
        while (iter.hasNext()) {
            if (iter.next() == null) continue;
            return false;
        }
        return true;
    }

    public static String extractBaseURL(String content) {
        int introLength;
        int endIndex;
        int introStart = content.indexOf(BASE_URL_COMMENT_INTRO);
        if (introStart != -1 && (endIndex = content.indexOf(34, introStart + (introLength = BASE_URL_COMMENT_INTRO.length()))) != -1) {
            return content.substring(introStart + introLength, endIndex);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String getHTMLContent(IPackageDeclaration packageDeclaration) throws CoreException {
        String string;
        IJavaElement iJavaElement = packageDeclaration.getAncestor(4);
        if (iJavaElement instanceof IPackageFragment) {
            void pkg;
            IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
            IPackageFragment cfr_ignored_0 = (IPackageFragment)iJavaElement;
            string = JavadocContentAccess2.getHTMLContent((IPackageFragment)pkg);
        } else {
            string = null;
        }
        return string;
    }

    public static String getHTMLContent(IPackageFragment packageFragment) throws CoreException {
        String content = JavadocContentAccess2.readHTMLContent(packageFragment);
        return JavadocContentAccess2.sanitizePackageJavadoc(content);
    }

    private static String sanitizePackageJavadoc(String content) {
        int nextListIndex;
        if (content == null || content.isEmpty()) {
            return content;
        }
        if (content.indexOf(CONTENT_CONTAINER) == 0 && (nextListIndex = content.indexOf(UL_CLASS_BLOCK_LIST)) > 0) {
            content = content.substring(CONTENT_CONTAINER.length(), nextListIndex);
        }
        return content;
    }

    /*
     * WARNING - void declaration
     */
    private static String readHTMLContent(IPackageFragment packageFragment) throws CoreException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)packageFragment.getAncestor(3);
        boolean isBinary = root.getKind() == 2;
        Object packageInfo = isBinary ? packageFragment.getClassFile("package-info.class") : packageFragment.getCompilationUnit("package-info.java");
        if (packageInfo != null && packageInfo.exists()) {
            Javadoc packageJavadocNode;
            String cuSource = packageInfo.getSource();
            if (cuSource != null && (packageJavadocNode = JavadocContentAccess2.getPackageJavadocNode((IJavaElement)packageFragment, cuSource)) != null) {
                Object element = isBinary ? ((IOrdinaryClassFile)packageInfo).getType() : packageInfo.getParent();
                return new JavadocContentAccess2((IJavaElement)element, packageJavadocNode, cuSource).toHTML();
            }
        } else {
            Object object;
            Object nonJavaResource;
            Object[] nonJavaResources;
            Object[] objectArray = nonJavaResources = packageFragment.getNonJavaResources();
            int n = nonJavaResources.length;
            int n2 = 0;
            while (n2 < n) {
                nonJavaResource = objectArray[n2];
                object = nonJavaResource;
                if (object instanceof IFile) {
                    IJarEntryResource iFile;
                    IFile cfr_ignored_0 = (IFile)object;
                    IFile cfr_ignored_1 = (IFile)object;
                    if (iFile.exists() && "package.html".equals(iFile.getName())) {
                        return JavadocContentAccess2.getIFileContent((IFile)iFile);
                    }
                }
                ++n2;
            }
            if (isBinary) {
                objectArray = nonJavaResources;
                n = nonJavaResources.length;
                n2 = 0;
                while (n2 < n) {
                    nonJavaResource = objectArray[n2];
                    object = nonJavaResource;
                    if (object instanceof IJarEntryResource) {
                        void jarEntryResource;
                        IJarEntryResource cfr_ignored_2 = (IJarEntryResource)object;
                        IJarEntryResource cfr_ignored_3 = (IJarEntryResource)object;
                        String encoding = JavadocContentAccess2.getSourceAttachmentEncoding(root);
                        if ("package.html".equals(jarEntryResource.getName()) && jarEntryResource.isFile()) {
                            return JavadocContentAccess2.getHTMLContent((IJarEntryResource)jarEntryResource, encoding);
                        }
                    }
                    ++n2;
                }
                String contents = JavadocContentAccess2.getHTMLContentFromAttachedSource(root, packageFragment);
                if (contents != null) {
                    return contents;
                }
            }
        }
        if (root.isArchive() || root.isExternal()) {
            return packageFragment.getAttachedJavadoc(null);
        }
        return null;
    }

    private static String getHTMLContent(IJarEntryResource jarEntryResource, String encoding) throws CoreException {
        InputStream in = jarEntryResource.getContents();
        try {
            String string = JavadocContentAccess2.getContentsFromInputStream(in, encoding);
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getHTMLContentFromAttachedSource(IPackageFragmentRoot root, IPackageFragment packageFragment) throws CoreException {
        Javadoc packageJavadocNode;
        String filePath = String.valueOf(packageFragment.getElementName().replace('.', '/')) + '/' + "package-info.java";
        String contents = JavadocContentAccess2.getFileContentFromAttachedSource(root, filePath);
        if (contents != null && (packageJavadocNode = JavadocContentAccess2.getPackageJavadocNode((IJavaElement)packageFragment, contents)) != null) {
            return new JavadocContentAccess2((IJavaElement)packageFragment, packageJavadocNode, contents).toHTML();
        }
        filePath = String.valueOf(packageFragment.getElementName().replace('.', '/')) + '/' + "package.html";
        return JavadocContentAccess2.getFileContentFromAttachedSource(root, filePath);
    }

    /*
     * WARNING - void declaration
     */
    private static String getFileContentFromAttachedSource(IPackageFragmentRoot root, String filePath) throws CoreException {
        IPath sourceAttachmentPath = root.getSourceAttachmentPath();
        if (sourceAttachmentPath != null) {
            File file = null;
            String encoding = null;
            if (sourceAttachmentPath.getDevice() == null) {
                IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                IResource res = wsRoot.findMember(sourceAttachmentPath);
                IResource iResource = res;
                if (iResource instanceof IFile) {
                    void ifile;
                    IFile iFile = (IFile)iResource;
                    IFile cfr_ignored_0 = (IFile)iResource;
                    IPath location = res.getLocation();
                    if (location == null) {
                        return null;
                    }
                    file = location.toFile();
                    encoding = ifile.getCharset(false);
                } else {
                    IResource iResource2 = res;
                    if (iResource2 instanceof IContainer) {
                        void container;
                        IContainer location = (IContainer)iResource2;
                        IContainer cfr_ignored_1 = (IContainer)iResource2;
                        res = container.findMember(filePath);
                        if (!(res instanceof IFile)) {
                            return null;
                        }
                        encoding = ((IFile)res).getCharset(false);
                        if (encoding == null) {
                            encoding = JavadocContentAccess2.getSourceAttachmentEncoding(root);
                        }
                        return JavadocContentAccess2.getContentsFromInputStream(((IFile)res).getContents(), encoding);
                    }
                }
            }
            if (file == null || !file.exists()) {
                file = sourceAttachmentPath.toFile();
            }
            if (file.isDirectory()) {
                IPath packagedocPath = sourceAttachmentPath.append(filePath);
                if (packagedocPath.toFile().exists()) {
                    return JavadocContentAccess2.getFileContent(packagedocPath.toFile());
                }
            } else if (file.exists()) {
                IPath sourceAttachmentRootPath = root.getSourceAttachmentRootPath();
                String packagedocPath = sourceAttachmentRootPath != null ? sourceAttachmentRootPath.append(filePath).toString() : filePath;
                ZipFile zipFile = null;
                InputStream in = null;
                try {
                    zipFile = new ZipFile(file, 1);
                    ZipEntry packagedocFile = zipFile.getEntry(packagedocPath);
                    if (packagedocFile != null) {
                        in = zipFile.getInputStream(packagedocFile);
                        if (encoding == null) {
                            encoding = JavadocContentAccess2.getSourceAttachmentEncoding(root);
                        }
                        String string = JavadocContentAccess2.getContentsFromInputStream(in, encoding);
                        return string;
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    private static String getContentsFromInputStream(InputStream in, String encoding) throws CoreException {
        StringBuffer buffer;
        block15: {
            int defaultFileSize = 15360;
            buffer = new StringBuffer(15360);
            Reader reader = null;
            try {
                try {
                    reader = new BufferedReader(new InputStreamReader(in, encoding), 15360);
                    char[] readBuffer = new char[2048];
                    int charCount = reader.read(readBuffer);
                    while (charCount > 0) {
                        buffer.append(readBuffer, 0, charCount);
                        charCount = reader.read(readBuffer);
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException2) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return buffer.toString();
    }

    private static String getSourceAttachmentEncoding(IPackageFragmentRoot root) throws JavaModelException {
        int kind;
        String encoding = ResourcesPlugin.getEncoding();
        IClasspathEntry entry = root.getRawClasspathEntry();
        if (entry != null && ((kind = entry.getEntryKind()) == 1 || kind == 4)) {
            IClasspathAttribute[] extraAttributes = entry.getExtraAttributes();
            int i = 0;
            while (i < extraAttributes.length) {
                IClasspathAttribute attrib = extraAttributes[i];
                if ("source_encoding".equals(attrib.getName())) {
                    return attrib.getValue();
                }
                ++i;
            }
        }
        return encoding;
    }

    private static String getIFileContent(IFile file) throws CoreException {
        String content = null;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath fullPath = file.getFullPath();
        manager.connect(fullPath, LocationKind.IFILE, null);
        try {
            ITextFileBuffer buffer = manager.getTextFileBuffer(fullPath, LocationKind.IFILE);
            if (buffer != null) {
                content = buffer.getDocument().get();
            }
        }
        finally {
            manager.disconnect(fullPath, LocationKind.IFILE, null);
        }
        return content;
    }

    private static String getFileContent(File file) throws CoreException {
        String content = null;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        Path fullPath = new Path(file.getAbsolutePath());
        manager.connect((IPath)fullPath, LocationKind.LOCATION, null);
        try {
            ITextFileBuffer buffer = manager.getTextFileBuffer((IPath)fullPath, LocationKind.LOCATION);
            if (buffer != null) {
                content = buffer.getDocument().get();
            }
        }
        finally {
            manager.disconnect((IPath)fullPath, LocationKind.LOCATION, null);
        }
        return content;
    }

    public static String convertToHTMLContentWithWhitespace(String content) {
        content = JavadocContentAccess2.replace(content, '&', "&amp;");
        content = JavadocContentAccess2.replace(content, '\"', "&quot;");
        content = JavadocContentAccess2.replace(content, '<', "&lt;");
        content = JavadocContentAccess2.replace(content, '>', "&gt;");
        return "<span style='white-space:pre'>" + content + "</span>";
    }

    private static String replace(String text, char c, String s) {
        int previous = 0;
        int current = text.indexOf(c, previous);
        if (current == -1) {
            return text;
        }
        StringBuffer buffer = new StringBuffer();
        while (current > -1) {
            buffer.append(text.substring(previous, current));
            buffer.append(s);
            previous = current + 1;
            current = text.indexOf(c, previous);
        }
        buffer.append(text.substring(previous));
        return buffer.toString();
    }

    public static Reader getMarkdownContentReader(IJavaElement element) {
        try {
            String rawHtml = JavadocContentAccess2.getHTMLContent(element, true);
            Reader markdownReader = new JavaDoc2MarkdownConverter(rawHtml).getAsReader();
            return markdownReader;
        }
        catch (IOException | CoreException throwable) {
            return null;
        }
    }

    private static abstract class InheritDocVisitor {
        public static final Object STOP_BRANCH = new Object(){

            public String toString() {
                return "STOP_BRANCH";
            }
        };
        public static final Object CONTINUE = new Object(){

            public String toString() {
                return "CONTINUE";
            }
        };

        private InheritDocVisitor() {
        }

        public abstract Object visit(IType var1) throws JavaModelException;

        public Object visitInheritDoc(IType currentType, ITypeHierarchy typeHierarchy) throws JavaModelException {
            ArrayList<IType> visited = new ArrayList<IType>();
            visited.add(currentType);
            Object result = this.visitInheritDocInterfaces(visited, currentType, typeHierarchy);
            if (result != CONTINUE) {
                return result;
            }
            IType superClass = currentType.isInterface() ? currentType.getJavaProject().findType("java.lang.Object") : typeHierarchy.getSuperclass(currentType);
            while (superClass != null && !visited.contains(superClass)) {
                result = this.visit(superClass);
                if (result == STOP_BRANCH) {
                    return null;
                }
                if (result == CONTINUE) {
                    visited.add(superClass);
                    result = this.visitInheritDocInterfaces(visited, superClass, typeHierarchy);
                    if (result != CONTINUE) {
                        return result;
                    }
                    superClass = typeHierarchy.getSuperclass(superClass);
                    continue;
                }
                return result;
            }
            return null;
        }

        private Object visitInheritDocInterfaces(ArrayList<IType> visited, IType currentType, ITypeHierarchy typeHierarchy) throws JavaModelException {
            Object result;
            ArrayList<IType> toVisitChildren = new ArrayList<IType>();
            IType[] superInterfaces = typeHierarchy.getSuperInterfaces(currentType);
            int i = 0;
            while (i < superInterfaces.length) {
                IType superInterface = superInterfaces[i];
                if (!visited.contains(superInterface)) {
                    visited.add(superInterface);
                    result = this.visit(superInterface);
                    if (result != STOP_BRANCH) {
                        if (result == CONTINUE) {
                            toVisitChildren.add(superInterface);
                        } else {
                            return result;
                        }
                    }
                }
                ++i;
            }
            for (IType child : toVisitChildren) {
                result = this.visitInheritDocInterfaces(visited, child, typeHierarchy);
                if (result == CONTINUE) continue;
                return result;
            }
            return CONTINUE;
        }
    }

    private static class JavadocLookup {
        private static final JavadocLookup NONE = new JavadocLookup(null){

            @Override
            public CharSequence getInheritedMainDescription(IMethod method) {
                return null;
            }

            @Override
            public CharSequence getInheritedParamDescription(IMethod method, int i) {
                return null;
            }

            @Override
            public CharSequence getInheritedReturnDescription(IMethod method) {
                return null;
            }

            @Override
            public CharSequence getInheritedExceptionDescription(IMethod method, String name) {
                return null;
            }
        };
        private final IType fStartingType;
        private final HashMap<IMethod, JavadocContentAccess2> fContentAccesses;
        private ITypeHierarchy fTypeHierarchy;
        private MethodOverrideTester fOverrideTester;

        private JavadocLookup(IType startingType) {
            this.fStartingType = startingType;
            this.fContentAccesses = new HashMap();
        }

        public CharSequence getInheritedMainDescription(IMethod method) {
            return this.getInheritedDescription(method, new DescriptionGetter(){

                @Override
                public CharSequence getDescription(JavadocContentAccess2 contentAccess) {
                    return contentAccess.getMainDescription();
                }
            });
        }

        public CharSequence getInheritedTypeParamDescription(IMethod method, final int typeParamIndex) {
            return this.getInheritedDescription(method, new DescriptionGetter(){

                @Override
                public CharSequence getDescription(JavadocContentAccess2 contentAccess) throws JavaModelException {
                    return contentAccess.getInheritedTypeParamDescription(typeParamIndex);
                }
            });
        }

        public CharSequence getInheritedParamDescription(IMethod method, final int paramIndex) {
            return this.getInheritedDescription(method, new DescriptionGetter(){

                @Override
                public CharSequence getDescription(JavadocContentAccess2 contentAccess) throws JavaModelException {
                    return contentAccess.getInheritedParamDescription(paramIndex);
                }
            });
        }

        public CharSequence getInheritedReturnDescription(IMethod method) {
            return this.getInheritedDescription(method, new DescriptionGetter(){

                @Override
                public CharSequence getDescription(JavadocContentAccess2 contentAccess) {
                    return contentAccess.getReturnDescription();
                }
            });
        }

        public CharSequence getInheritedExceptionDescription(IMethod method, final String simpleName) {
            return this.getInheritedDescription(method, new DescriptionGetter(){

                @Override
                public CharSequence getDescription(JavadocContentAccess2 contentAccess) {
                    return contentAccess.getExceptionDescription(simpleName);
                }
            });
        }

        private CharSequence getInheritedDescription(final IMethod method, final DescriptionGetter descriptionGetter) {
            try {
                return (CharSequence)new InheritDocVisitor(){

                    @Override
                    public Object visit(IType currType) throws JavaModelException {
                        IMethod overridden = this.getOverrideTester().findOverriddenMethodInType(currType, method);
                        if (overridden == null) {
                            return InheritDocVisitor.CONTINUE;
                        }
                        JavadocContentAccess2 contentAccess = this.getJavadocContentAccess(overridden);
                        if (contentAccess == null) {
                            if (overridden.getOpenable().getBuffer() == null) {
                                return InheritDocVisitor.STOP_BRANCH;
                            }
                            return InheritDocVisitor.CONTINUE;
                        }
                        CharSequence overriddenDescription = descriptionGetter.getDescription(contentAccess);
                        if (overriddenDescription != null) {
                            return overriddenDescription;
                        }
                        return InheritDocVisitor.CONTINUE;
                    }
                }.visitInheritDoc(method.getDeclaringType(), this.getTypeHierarchy());
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }

        private JavadocContentAccess2 getJavadocContentAccess(IMethod method) throws JavaModelException {
            JavadocContentAccess2 cached = this.fContentAccesses.get(method);
            if (cached != null) {
                return cached;
            }
            if (this.fContentAccesses.containsKey(method)) {
                return null;
            }
            IBuffer buf = method.getOpenable().getBuffer();
            if (buf == null) {
                this.fContentAccesses.put(method, null);
                return null;
            }
            ISourceRange javadocRange = method.getJavadocRange();
            if (javadocRange == null) {
                this.fContentAccesses.put(method, null);
                return null;
            }
            String rawJavadoc = buf.getText(javadocRange.getOffset(), javadocRange.getLength());
            Javadoc javadoc = JavadocContentAccess2.getJavadocNode((IJavaElement)method, rawJavadoc);
            if (javadoc == null) {
                this.fContentAccesses.put(method, null);
                return null;
            }
            JavadocContentAccess2 contentAccess = new JavadocContentAccess2((IJavaElement)method, javadoc, rawJavadoc, this);
            this.fContentAccesses.put(method, contentAccess);
            return contentAccess;
        }

        private ITypeHierarchy getTypeHierarchy() throws JavaModelException {
            if (this.fTypeHierarchy == null) {
                this.fTypeHierarchy = SuperTypeHierarchyCache.getTypeHierarchy((IType)this.fStartingType);
            }
            return this.fTypeHierarchy;
        }

        private MethodOverrideTester getOverrideTester() throws JavaModelException {
            if (this.fOverrideTester == null) {
                this.fOverrideTester = SuperTypeHierarchyCache.getMethodOverrideTester((IType)this.fStartingType);
            }
            return this.fOverrideTester;
        }

        private static interface DescriptionGetter {
            public CharSequence getDescription(JavadocContentAccess2 var1) throws JavaModelException;
        }
    }
}

