/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.jdt.ls.core.internal.hover.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class RenameEnumConstProcessor
extends RenameFieldProcessor {
    public RenameEnumConstProcessor(IField field) {
        super(field);
    }

    public RenameEnumConstProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        super(null);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    @Override
    public String canEnableGetterRenaming() throws CoreException {
        return "";
    }

    @Override
    public String canEnableSetterRenaming() throws CoreException {
        return "";
    }

    @Override
    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        RefactoringStatus result = Checks.checkEnumConstantName((String)newName, (IJavaElement)this.getField());
        if (Checks.isAlreadyNamed((IJavaElement)this.getField(), (String)newName)) {
            result.addFatalError(RefactoringCoreMessages.RenameEnumConstRefactoring_another_name);
        }
        if (this.getField().getDeclaringType().getField(newName).exists()) {
            result.addFatalError(RefactoringCoreMessages.RenameEnumConstRefactoring_const_already_defined);
        }
        return result;
    }

    @Override
    protected RenameJavaElementDescriptor createRefactoringDescriptor() {
        IField field = this.getField();
        String project = null;
        IJavaProject javaProject = field.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        int flags = 589826;
        IType declaring = field.getDeclaringType();
        try {
            if (!Flags.isPrivate((int)declaring.getFlags())) {
                flags |= 4;
            }
            if (declaring.isAnonymous() || declaring.isLocal()) {
                flags |= 0x40000;
            }
        }
        catch (JavaModelException exception) {
            JavaLanguageServerPlugin.logException(exception);
        }
        String description = Messages.format((String)RefactoringCoreMessages.RenameEnumConstProcessor_descriptor_description_short, (Object)BasicElementLabels.getJavaElementName((String)this.fField.getElementName()));
        String header = Messages.format((String)RefactoringCoreMessages.RenameEnumConstProcessor_descriptor_description, (Object[])new String[]{BasicElementLabels.getJavaElementName((String)field.getElementName()), JavaElementLabels.getElementLabel(field.getParent(), JavaElementLabels.ALL_FULLY_QUALIFIED), BasicElementLabels.getJavaElementName((String)this.getNewElementName())});
        String comment = new JDTRefactoringDescriptorComment(project, (Object)this, header).asString();
        RenameJavaElementDescriptor descriptor = RefactoringSignatureDescriptorFactory.createRenameJavaElementDescriptor((String)"org.eclipse.jdt.ui.rename.enum.constant");
        descriptor.setProject(project);
        descriptor.setDescription(description);
        descriptor.setComment(comment);
        descriptor.setFlags(flags);
        descriptor.setJavaElement((IJavaElement)field);
        descriptor.setNewName(this.getNewElementName());
        descriptor.setUpdateReferences(this.fUpdateReferences);
        descriptor.setUpdateTextualOccurrences(this.fUpdateTextualMatches);
        return descriptor;
    }

    @Override
    public String getIdentifier() {
        return "org.eclipse.jdt.ui.renameEnumConstProcessor";
    }

    @Override
    public String getProcessorName() {
        return RefactoringCoreMessages.RenameEnumConstRefactoring_name;
    }

    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        IJavaElement element;
        String handle = extended.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement((String)extended.getProject(), (String)handle, (boolean)false);
            if (element == null || !element.exists() || element.getElementType() != 8) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus((Object)element, (String)this.getProcessorName(), (String)"org.eclipse.jdt.ui.rename.enum.constant");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"input"));
        }
        this.fField = (IField)element;
        String name = extended.getAttribute("name");
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"name"));
        }
        this.setNewElementName(name);
        String references = extended.getAttribute("references");
        if (references == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"references"));
        }
        this.setUpdateReferences(Boolean.parseBoolean(references));
        String matches = extended.getAttribute("textual");
        if (matches == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"textual"));
        }
        this.setUpdateTextualMatches(Boolean.parseBoolean(matches));
        return new RefactoringStatus();
    }

    @Override
    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameEnumConstAvailable(this.getField());
    }
}

