/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class SnippetUtils {
    private static final String MARKDOWN_LANGUAGE = "java";
    private static final String TM_SELECTED_TEXT = "\\$TM_SELECTED_TEXT";
    private static final String TM_FILENAME_BASE = "\\$TM_FILENAME_BASE";

    private SnippetUtils() {
    }

    public static String templateToSnippet(String pattern) {
        String evaluated = pattern.replaceAll("\\$\\$\\{(\\d):\\$\\{(.*?)\\}(.*?)\\}", "\\${$1:$2$3}");
        String escaped = evaluated.replaceAll("\\$\\$", "\\$");
        return escaped;
    }

    public static Either<String, MarkupContent> beautifyDocument(String raw) {
        String escapedString = raw.replaceAll("\\$\\{\\d\\|(.*?),.*?\\}", "$1");
        escapedString = escapedString.replaceAll("\\$\\{\\d:?(.*?)\\}", "$1");
        escapedString = escapedString.replaceAll(TM_SELECTED_TEXT, "");
        escapedString = escapedString.replaceAll(TM_FILENAME_BASE, "");
        if (JavaLanguageServerPlugin.getPreferencesManager() != null && JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences() != null && JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isSupportsCompletionDocumentationMarkdown()) {
            MarkupContent markupContent = new MarkupContent();
            markupContent.setKind("markdown");
            markupContent.setValue(String.format("```%s\n%s\n```", MARKDOWN_LANGUAGE, escapedString));
            return Either.forRight((Object)markupContent);
        }
        return Either.forLeft((Object)escapedString);
    }
}

