/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.internal.launching.JREContainerInitializer;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.util.NLS;

public class EECompilationParticipant
extends CompilationParticipant {
    private Set<IJavaProject> fCleaned = new HashSet<IJavaProject>();

    public boolean isActive(IJavaProject project) {
        return true;
    }

    public void cleanStarting(IJavaProject project) {
        super.cleanStarting(project);
        this.fCleaned.add(project);
    }

    public void buildFinished(IJavaProject project) {
        super.buildFinished(project);
        if (this.fCleaned.remove(project)) {
            IVMInstall vm;
            String eeId = null;
            IPath container = null;
            try {
                IClasspathEntry[] rawClasspath = project.getRawClasspath();
                int j = 0;
                while (j < rawClasspath.length) {
                    IPath path;
                    IClasspathEntry entry = rawClasspath[j];
                    if (entry.getEntryKind() == 5 && JavaRuntime.JRE_CONTAINER.equals((path = entry.getPath()).segment(0))) {
                        container = path;
                        eeId = JREContainerInitializer.getExecutionEnvironmentId(path);
                    }
                    ++j;
                }
            }
            catch (CoreException e) {
                LaunchingPlugin.log(e);
            }
            if (container != null && eeId != null) {
                vm = JREContainerInitializer.resolveVM(container);
                this.validateEnvironment(eeId, project, vm);
                if (vm instanceof IVMInstall2 && (eeId = EECompilationParticipant.getCompilerCompliance((IVMInstall2)((Object)vm))) != null) {
                    this.validateCompliance(eeId, project, vm);
                }
            } else if (container != null && (vm = JREContainerInitializer.resolveVM(container)) instanceof IVMInstall2 && (eeId = EECompilationParticipant.getCompilerCompliance((IVMInstall2)((Object)vm))) != null) {
                this.validateCompliance(eeId, project, vm);
            }
        }
    }

    private boolean isReleaseFlagEnabled(String eeId, String compId, IJavaProject project) {
        String releaseVal;
        boolean releaseFlagEnabled = false;
        if (JavaCore.compareJavaVersions((String)"9", (String)eeId) <= 0 && JavaCore.compareJavaVersions((String)"1.6", (String)compId) <= 0 && "enabled".equals(releaseVal = project.getOption("org.eclipse.jdt.core.compiler.release", true))) {
            releaseFlagEnabled = true;
        }
        return releaseFlagEnabled;
    }

    private void validateCompliance(String eeId, IJavaProject project, IVMInstall vm) {
        String id = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        if (!eeId.equals(id) && !this.isReleaseFlagEnabled(eeId, id, project)) {
            IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
            IExecutionEnvironment[] environments = manager.getExecutionEnvironments();
            IExecutionEnvironment finalEnvironment = null;
            IExecutionEnvironment[] iExecutionEnvironmentArray = environments;
            int n = environments.length;
            int n2 = 0;
            while (n2 < n) {
                IExecutionEnvironment environment = iExecutionEnvironmentArray[n2];
                if (environment.getId().indexOf(id) != -1) {
                    finalEnvironment = environment;
                    break;
                }
                ++n2;
            }
            if (finalEnvironment != null && !finalEnvironment.isStrictlyCompatible(vm)) {
                String message = NLS.bind((String)LaunchingMessages.LaunchingPlugin_39, (Object[])new String[]{id, eeId});
                int sev = this.getSeverityLevel(JavaRuntime.PREF_COMPILER_COMPLIANCE_DOES_NOT_MATCH_JRE, project.getProject());
                if (sev != -1) {
                    this.createProblemMarker(project, message, sev, JavaRuntime.JRE_COMPILER_COMPLIANCE_MARKER, LaunchingMessages.LaunchingPlugin_40);
                }
            }
        }
    }

    private void validateEnvironment(String id, IJavaProject project, IVMInstall vm) {
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment environment = manager.getEnvironment(id);
        if (environment != null) {
            if (vm == null) {
                String message = NLS.bind((String)LaunchingMessages.LaunchingPlugin_38, (Object[])new String[]{environment.getId()});
                this.createJREContainerProblem(project, message, 2);
            } else if (!environment.isStrictlyCompatible(vm)) {
                IVMInstall[] compatibleVMs = environment.getCompatibleVMs();
                int exact = 0;
                int i = 0;
                while (i < compatibleVMs.length) {
                    if (environment.isStrictlyCompatible(compatibleVMs[i])) {
                        ++exact;
                    }
                    ++i;
                }
                String message = null;
                if (exact == 0) {
                    if (vm instanceof IVMInstall2) {
                        String eeId = EECompilationParticipant.getCompilerCompliance((IVMInstall2)((Object)vm));
                        String compId = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
                        if (eeId != null && this.isReleaseFlagEnabled(eeId, compId, project)) {
                            return;
                        }
                    }
                    message = NLS.bind((String)LaunchingMessages.LaunchingPlugin_35, (Object[])new String[]{environment.getId()});
                } else {
                    message = NLS.bind((String)LaunchingMessages.LaunchingPlugin_36, (Object[])new String[]{environment.getId()});
                }
                int sev = this.getSeverityLevel(JavaRuntime.PREF_STRICTLY_COMPATIBLE_JRE_NOT_AVAILABLE, project.getProject());
                if (sev != -1) {
                    this.createJREContainerProblem(project, message, sev);
                }
            }
        }
    }

    public static String getCompilerCompliance(IVMInstall2 vMInstall) {
        String version = vMInstall.getJavaVersion();
        if (version == null) {
            return null;
        }
        if (version.startsWith("20")) {
            return "20";
        }
        if (version.startsWith("19")) {
            return "19";
        }
        if (version.startsWith("18")) {
            return "18";
        }
        if (version.startsWith("17")) {
            return "17";
        }
        if (version.startsWith("16")) {
            return "16";
        }
        if (version.startsWith("15")) {
            return "15";
        }
        if (version.startsWith("14")) {
            return "14";
        }
        if (version.startsWith("13")) {
            return "13";
        }
        if (version.startsWith("12")) {
            return "12";
        }
        if (version.startsWith("11")) {
            return "11";
        }
        if (version.startsWith("10")) {
            return "10";
        }
        if (version.startsWith("9")) {
            return "9";
        }
        if (version.startsWith("1.8")) {
            return "1.8";
        }
        if (version.startsWith("1.7")) {
            return "1.7";
        }
        if (version.startsWith("1.6")) {
            return "1.6";
        }
        if (version.startsWith("1.5")) {
            return "1.5";
        }
        if (version.startsWith("1.4")) {
            return "1.4";
        }
        if (version.startsWith("1.3")) {
            return "1.3";
        }
        if (version.startsWith("1.2")) {
            return "1.3";
        }
        if (version.startsWith("1.1")) {
            return "1.3";
        }
        return null;
    }

    private int getSeverityLevel(String prefkey, IProject project) {
        String value;
        IPreferencesService service = Platform.getPreferencesService();
        ArrayList<Object> scopes = new ArrayList<Object>();
        scopes.add(InstanceScope.INSTANCE);
        if (project != null) {
            scopes.add(new ProjectScope(project));
        }
        if ((value = service.getString("org.eclipse.jdt.launching", prefkey, null, scopes.toArray(new IScopeContext[scopes.size()]))) == null) {
            value = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.launching").get(prefkey, null);
        }
        if ("error".equals(value)) {
            return 2;
        }
        if ("warning".equals(value)) {
            return 1;
        }
        if ("info".equals(value)) {
            return 0;
        }
        return -1;
    }

    private void createJREContainerProblem(IJavaProject javaProject, String message, int severity) {
        try {
            Map<String, String> attributes = Map.of("message", message, "severity", severity, "location", LaunchingMessages.LaunchingPlugin_37);
            javaProject.getProject().createMarker(JavaRuntime.JRE_CONTAINER_MARKER, attributes);
        }
        catch (CoreException coreException) {
            return;
        }
    }

    private void createProblemMarker(IJavaProject javaProject, String message, int severity, String problemId, String location) {
        try {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("message", message);
            attributes.put("severity", severity);
            attributes.put("location", location);
            javaProject.getProject().createMarker(problemId, attributes);
        }
        catch (CoreException coreException) {
            return;
        }
    }
}

