/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.manipulation.CleanUpRequirementsCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFixCore;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.text.edits.TextEditGroup;

public class VarCleanUpCore
extends AbstractMultiFixCore {
    public VarCleanUpCore() {
        this(Collections.emptyMap());
    }

    public VarCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirementsCore getRequirementsCore() {
        boolean requireAST = this.isEnabled("cleanup.use_var");
        Map<String, String> requiredOptions = null;
        return new CleanUpRequirementsCore(requireAST, false, false, requiredOptions);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.use_var")) {
            return new String[]{MultiFixMessages.VarCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.use_var")) {
            return "var number = 0;\nvar list = new ArrayList<String>();\nvar map = new HashMap<Integer, String>();\n";
        }
        return "int number = 0;\nArrayList<String> list = new ArrayList<String>();\nHashMap<Integer, String> map = new HashMap<>();\n";
    }

    @Override
    protected ICleanUpFixCore createFix(final CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.use_var") || !JavaModelUtil.is10OrHigher(unit.getJavaElement().getJavaProject())) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(VariableDeclarationStatement node) {
                if (node.fragments().size() != 1) {
                    return true;
                }
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)node.fragments().get(0);
                return this.maybeUseVar(node.getType(), fragment.getInitializer(), fragment.getExtraDimensions());
            }

            public boolean visit(VariableDeclarationExpression node) {
                if (node.fragments().size() != 1) {
                    return true;
                }
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)node.fragments().get(0);
                return this.maybeUseVar(node.getType(), fragment.getInitializer(), fragment.getExtraDimensions());
            }

            public boolean visit(SingleVariableDeclaration node) {
                return this.maybeUseVar(node.getType(), node.getInitializer(), node.getExtraDimensions());
            }

            private boolean maybeUseVar(Type type, Expression initializer, int extraDimensions) {
                if (type.isVar() || initializer == null || initializer.resolveTypeBinding() == null || type.resolveBinding() == null || extraDimensions > 0 || initializer instanceof ArrayInitializer) {
                    if (JavaModelUtil.is11OrHigher(unit.getJavaElement().getJavaProject()) && !type.isVar() && initializer == null && type.resolveBinding() != null && extraDimensions == 0 && type.getParent() instanceof SingleVariableDeclaration && type.getParent().getParent() instanceof LambdaExpression && type.getParent().getLocationInParent() == LambdaExpression.PARAMETERS_PROPERTY) {
                        LambdaExpression lambda = (LambdaExpression)type.getParent().getParent();
                        ASTNode lambdaParent = lambda.getParent();
                        if (lambdaParent instanceof MethodInvocation) {
                            IMethodBinding methodBinding;
                            MethodInvocation methodInvocation = (MethodInvocation)lambdaParent;
                            List args = methodInvocation.arguments();
                            if (VarCleanUpCore.this.checkForWildCard(lambda, args, methodBinding = methodInvocation.resolveMethodBinding())) {
                                return true;
                            }
                        } else if (lambdaParent instanceof ClassInstanceCreation) {
                            IMethodBinding methodBinding;
                            ClassInstanceCreation classInstance = (ClassInstanceCreation)lambdaParent;
                            List args = classInstance.arguments();
                            if (VarCleanUpCore.this.checkForWildCard(lambda, args, methodBinding = classInstance.resolveConstructorBinding())) {
                                return true;
                            }
                        } else if (lambdaParent instanceof SuperMethodInvocation) {
                            IMethodBinding methodBinding;
                            SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)lambdaParent;
                            List args = superMethodInvocation.arguments();
                            if (VarCleanUpCore.this.checkForWildCard(lambda, args, methodBinding = superMethodInvocation.resolveMethodBinding())) {
                                return true;
                            }
                        } else if (lambdaParent instanceof SuperConstructorInvocation) {
                            IMethodBinding methodBinding;
                            SuperConstructorInvocation superConstructorInvocation = (SuperConstructorInvocation)lambdaParent;
                            List args = superConstructorInvocation.arguments();
                            if (VarCleanUpCore.this.checkForWildCard(lambda, args, methodBinding = superConstructorInvocation.resolveConstructorBinding())) {
                                return true;
                            }
                        } else if (lambdaParent instanceof VariableDeclarationFragment) {
                            VariableDeclarationStatement statement = ASTNodes.getFirstAncestorOrNull(lambdaParent, VariableDeclarationStatement.class);
                            FieldDeclaration fieldDeclaration = ASTNodes.getFirstAncestorOrNull(lambdaParent, FieldDeclaration.class);
                            Type statementType = null;
                            if (statement != null) {
                                statementType = statement.getType();
                            } else if (fieldDeclaration != null) {
                                statementType = fieldDeclaration.getType();
                            }
                            if (statementType == null) {
                                return true;
                            }
                            if (statementType.isParameterizedType()) {
                                ParameterizedType parameterizedType = (ParameterizedType)statementType;
                                List typeArgs = parameterizedType.typeArguments();
                                for (Type typeArg : typeArgs) {
                                    if (!typeArg.isWildcardType()) continue;
                                    return true;
                                }
                            }
                        }
                        rewriteOperations.add(new VarOperation(type));
                        return false;
                    }
                    return true;
                }
                ITypeBinding variableType = type.resolveBinding();
                ITypeBinding initializerType = initializer.resolveTypeBinding();
                if (variableType != null && variableType.isParameterizedType() == initializerType.isParameterizedType()) {
                    if (Objects.equals(variableType, initializerType)) {
                        ClassInstanceCreation classInstanceCreation = ASTNodes.as(initializer, ClassInstanceCreation.class);
                        CastExpression castExpression = ASTNodes.as(initializer, CastExpression.class);
                        MethodInvocation methodInvocation = ASTNodes.as(initializer, MethodInvocation.class);
                        SuperMethodInvocation superMethodInvocation = ASTNodes.as(initializer, SuperMethodInvocation.class);
                        LambdaExpression lambdaExpression = ASTNodes.as(initializer, LambdaExpression.class);
                        Expression expression = ASTNodes.as(initializer, Expression.class);
                        MethodReference methodReference = ASTNodes.as(initializer, MethodReference.class);
                        if (!variableType.isParameterizedType() && lambdaExpression == null || classInstanceCreation != null && classInstanceCreation.getType().isParameterizedType() && classInstanceCreation.getType().resolveBinding() != null && Arrays.equals(variableType.getTypeArguments(), classInstanceCreation.getType().resolveBinding().getTypeArguments()) && !((ParameterizedType)classInstanceCreation.getType()).typeArguments().isEmpty() || castExpression != null && castExpression.getType().isParameterizedType() && castExpression.getType().resolveBinding() != null && variableType.getTypeArguments().length == ((ParameterizedType)castExpression.getType()).typeArguments().size() && Arrays.equals(variableType.getTypeArguments(), castExpression.getType().resolveBinding().getTypeArguments()) || methodInvocation != null && methodInvocation.resolveMethodBinding() != null && methodInvocation.resolveMethodBinding().getReturnType().isParameterizedType() && !methodInvocation.resolveMethodBinding().isParameterizedMethod() && Arrays.equals(variableType.getTypeArguments(), methodInvocation.resolveMethodBinding().getReturnType().getTypeArguments()) || superMethodInvocation != null && superMethodInvocation.resolveMethodBinding() != null && superMethodInvocation.resolveMethodBinding().getReturnType().isParameterizedType() && !superMethodInvocation.resolveMethodBinding().isParameterizedMethod() && Arrays.equals(variableType.getTypeArguments(), superMethodInvocation.resolveMethodBinding().getReturnType().getTypeArguments()) || classInstanceCreation == null && castExpression == null && methodInvocation == null && superMethodInvocation == null && lambdaExpression == null && methodReference == null && expression != null && expression.resolveTypeBinding() != null && expression.resolveTypeBinding().isParameterizedType() && Arrays.equals(variableType.getTypeArguments(), expression.resolveTypeBinding().getTypeArguments())) {
                            rewriteOperations.add(new VarOperation(type));
                            return false;
                        }
                        if (variableType.isParameterizedType() && methodReference == null && classInstanceCreation != null && classInstanceCreation.getType().isParameterizedType() && ((ParameterizedType)classInstanceCreation.getType()).typeArguments().isEmpty()) {
                            rewriteOperations.add(new VarOperation(type, classInstanceCreation));
                            return false;
                        }
                    } else {
                        NumberLiteral literal = ASTNodes.as(initializer, NumberLiteral.class);
                        if (literal != null && (literal.getToken().matches(".*[^lLdDfF]") || literal.getToken().matches("0x.*[^lL]"))) {
                            if (ASTNodes.hasType(variableType, Long.TYPE.getSimpleName())) {
                                rewriteOperations.add(new VarOperation(type, literal, Character.valueOf('L')));
                                return false;
                            }
                            if (ASTNodes.hasType(variableType, Float.TYPE.getSimpleName())) {
                                rewriteOperations.add(new VarOperation(type, literal, Character.valueOf('F')));
                                return false;
                            }
                            if (ASTNodes.hasType(variableType, Double.TYPE.getSimpleName())) {
                                rewriteOperations.add(new VarOperation(type, literal, Character.valueOf('D')));
                                return false;
                            }
                        }
                    }
                }
                return true;
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.VarCleanUp_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]));
    }

    private boolean checkForWildCard(LambdaExpression lambda, List<Expression> args, IMethodBinding methodBinding) {
        ITypeBinding[] typeArgs;
        int index = -1;
        int i = 0;
        while (i < args.size()) {
            if (args.get(i) == lambda) {
                index = i;
                break;
            }
            ++i;
        }
        if (index < 0) {
            return true;
        }
        if (methodBinding == null) {
            return true;
        }
        ITypeBinding lambdaParamType = methodBinding.getParameterTypes()[index];
        ITypeBinding[] iTypeBindingArray = typeArgs = lambdaParamType.getTypeArguments();
        int n = typeArgs.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeArg = iTypeBindingArray[n2];
            if (typeArg.isWildcardType()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocationCore problem) {
        return false;
    }

    @Override
    protected ICleanUpFixCore createFix(CompilationUnit unit, IProblemLocationCore[] problems) throws CoreException {
        return null;
    }

    private class VarOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final Type node;
        private final ClassInstanceCreation classInstanceCreation;
        private final NumberLiteral literal;
        private final Character postfix;

        public VarOperation(Type node) {
            this(node, null, null, null);
        }

        public VarOperation(Type node, ClassInstanceCreation classInstanceCreation) {
            this(node, classInstanceCreation, null, null);
        }

        public VarOperation(Type node, NumberLiteral literal, Character postfix) {
            this(node, null, literal, postfix);
        }

        public VarOperation(Type node, ClassInstanceCreation classInstanceCreation, NumberLiteral literal, Character postfix) {
            this.node = node;
            this.classInstanceCreation = classInstanceCreation;
            this.literal = literal;
            this.postfix = postfix;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            SimpleType replacement;
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            ImportRemover remover = cuRewrite.getImportRemover();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.VarCleanUp_description, cuRewrite);
            if (this.classInstanceCreation != null) {
                Type node1 = this.classInstanceCreation.getType();
                ASTNode replacement2 = rewrite.createCopyTarget((ASTNode)this.node);
                ASTNodes.replaceButKeepComment(rewrite, (ASTNode)node1, replacement2, group);
            } else if (this.literal != null) {
                replacement = ast.newNumberLiteral(String.valueOf(this.literal.getToken()) + this.postfix);
                ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.literal, (ASTNode)replacement, group);
            }
            replacement = ast.newSimpleType((Name)ast.newSimpleName("var"));
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.node, (ASTNode)replacement, group);
            remover.registerRemovedNode((ASTNode)this.node);
        }
    }
}

