/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;

class DetectVMInstallationsJob
extends Job {
    private static final Object FAMILY = DetectVMInstallationsJob.class;
    private final StandardVMType standardType = (StandardVMType)JavaRuntime.getVMInstallType("org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");

    DetectVMInstallationsJob() {
        super(LaunchingMessages.lookupInstalledJVMs);
    }

    /*
     * WARNING - void declaration
     */
    protected IStatus run(IProgressMonitor monitor) {
        Collection<File> candidates = this.computeCandidateVMs();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        Set<File> knownVMs = DetectVMInstallationsJob.knownVMs();
        candidates.removeIf(knownVMs::contains);
        monitor.beginTask(LaunchingMessages.lookupInstalledJVMs, candidates.size());
        for (File f : candidates) {
            SubMonitor subMon;
            block8: {
                IVMInstall install;
                block7: {
                    void vm;
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)f.getAbsolutePath(), (int)1);
                    VMStandin workingCopy = new VMStandin(this.standardType, f.getAbsolutePath());
                    workingCopy.setInstallLocation(f);
                    String name = f.getName();
                    int i = 1;
                    while (this.isDuplicateName(name)) {
                        name = String.valueOf(f.getName()) + '(' + i++ + ')';
                    }
                    workingCopy.setName(name);
                    IVMInstall iVMInstall = install = workingCopy.convertToRealVM();
                    if (!(iVMInstall instanceof IVMInstall2)) break block7;
                    IVMInstall2 cfr_ignored_0 = (IVMInstall2)((Object)iVMInstall);
                    IVMInstall2 cfr_ignored_1 = (IVMInstall2)((Object)iVMInstall);
                    if (vm.getJavaVersion() != null) break block8;
                }
                this.standardType.disposeVMInstall(install.getId());
            }
            subMon.done();
        }
        return Status.OK_STATUS;
    }

    private boolean isDuplicateName(String name) {
        return Stream.of(JavaRuntime.getVMInstallTypes()).flatMap(vmType -> Arrays.stream(vmType.getVMInstalls())).map(IVMInstall::getName).anyMatch(name::equals);
    }

    private Collection<File> computeCandidateVMs() {
        String jdkHome;
        HashSet<File> rootDirectories = new HashSet<File>();
        if (!"win32".equals(Platform.getOS())) {
            rootDirectories.add(new File("/usr/lib/jvm"));
        }
        if ("macosx".equals(Platform.getOS())) {
            rootDirectories.add(new File("/Library/Java/JavaVirtualMachines"));
        }
        rootDirectories.add(new File(System.getProperty("user.home"), ".sdkman/candidates/java"));
        Set directories = rootDirectories.stream().filter(File::isDirectory).map(dir -> dir.listFiles(File::isDirectory)).flatMap(Arrays::stream).filter(Objects::nonNull).collect(Collectors.toSet());
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome != null) {
            directories.add(new File(javaHome));
        }
        if ((jdkHome = System.getenv("JDK_HOME")) != null) {
            directories.add(new File(jdkHome));
        }
        return directories.stream().filter(Objects::nonNull).filter(File::isDirectory).map(t -> {
            try {
                return t.getCanonicalFile();
            }
            catch (IOException iOException) {
                return null;
            }
        }).filter(Objects::nonNull).filter(location -> this.standardType.validateInstallLocation((File)location).isOK()).collect(Collectors.toCollection(HashSet::new));
    }

    private static Set<File> knownVMs() {
        return Stream.of(JavaRuntime.getVMInstallTypes()).map(IVMInstallType::getVMInstalls).flatMap(Arrays::stream).map(IVMInstall::getInstallLocation).filter(Objects::nonNull).map(t -> {
            try {
                return t.getCanonicalFile();
            }
            catch (IOException iOException) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public boolean belongsTo(Object family) {
        return family.equals(FAMILY);
    }
}

