"use strict";
/********************************************************************************
 * Copyright (C) 2022 Arm and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspaceSaveResourceService = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const workspace_frontend_contribution_1 = require("./workspace-frontend-contribution");
const browser_1 = require("@theia/core/lib/browser");
const save_resource_service_1 = require("@theia/core/lib/browser/save-resource-service");
const common_1 = require("@theia/core/lib/common");
let WorkspaceSaveResourceService = class WorkspaceSaveResourceService extends save_resource_service_1.SaveResourceService {
    canSave(saveable) {
        // In addition to dirty documents, untitled documents can be saved because for these we treat 'Save' as 'Save As'.
        return browser_1.Saveable.isDirty(saveable) || browser_1.Saveable.isUntitled(saveable);
    }
    async save(widget, options) {
        const saveable = browser_1.Saveable.get(widget);
        if (widget instanceof browser_1.Widget && this.workspaceFrontendContribution.canBeSavedAs(widget) && saveable) {
            if (browser_1.Saveable.isUntitled(saveable)) {
                this.workspaceFrontendContribution.saveAs(widget);
            }
            else {
                await saveable.save(options);
            }
        }
        else {
            // This should not happen because the caller should check this.
            this.messageService.error(`Cannot save the current widget "${widget === null || widget === void 0 ? void 0 : widget.title}" .`);
        }
    }
};
__decorate([
    (0, inversify_1.inject)(workspace_frontend_contribution_1.WorkspaceFrontendContribution),
    __metadata("design:type", workspace_frontend_contribution_1.WorkspaceFrontendContribution)
], WorkspaceSaveResourceService.prototype, "workspaceFrontendContribution", void 0);
__decorate([
    (0, inversify_1.inject)(common_1.MessageService),
    __metadata("design:type", common_1.MessageService)
], WorkspaceSaveResourceService.prototype, "messageService", void 0);
WorkspaceSaveResourceService = __decorate([
    (0, inversify_1.injectable)()
], WorkspaceSaveResourceService);
exports.WorkspaceSaveResourceService = WorkspaceSaveResourceService;
//# sourceMappingURL=workspace-save-resource-service.js.map