"use strict";
// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var MenusContributionPointHandler_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MenuTree = exports.MenusContributionPointHandler = exports.CodeEditorWidgetUtil = void 0;
/* eslint-disable @typescript-eslint/no-explicit-any */
const vscode_uri_1 = require("@theia/core/shared/vscode-uri");
const inversify_1 = require("@theia/core/shared/inversify");
const core_1 = require("@theia/core");
const browser_1 = require("@theia/editor/lib/browser");
const common_1 = require("@theia/core/lib/common");
const event_1 = require("@theia/core/lib/common/event");
const tab_bar_toolbar_1 = require("@theia/core/lib/browser/shell/tab-bar-toolbar");
const navigator_contribution_1 = require("@theia/navigator/lib/browser/navigator-contribution");
const tree_view_widget_1 = require("../view/tree-view-widget");
const common_2 = require("../../../common");
const debug_stack_frames_widget_1 = require("@theia/debug/lib/browser/view/debug-stack-frames-widget");
const debug_threads_widget_1 = require("@theia/debug/lib/browser/view/debug-threads-widget");
const tree_widget_selection_1 = require("@theia/core/lib/browser/tree/tree-widget-selection");
const scm_widget_1 = require("@theia/scm/lib/browser/scm-widget");
const scm_tree_widget_1 = require("@theia/scm/lib/browser/scm-tree-widget");
const scm_service_1 = require("@theia/scm/lib/browser/scm-service");
const scm_repository_1 = require("@theia/scm/lib/browser/scm-repository");
const scm_main_1 = require("../scm-main");
const resource_context_key_1 = require("@theia/core/lib/browser/resource-context-key");
const plugin_view_widget_1 = require("../view/plugin-view-widget");
const view_context_key_service_1 = require("../view/view-context-key-service");
const webview_1 = require("../webview/webview");
const navigatable_1 = require("@theia/core/lib/browser/navigatable");
const context_key_service_1 = require("@theia/core/lib/browser/context-key-service");
const timeline_tree_widget_1 = require("@theia/timeline/lib/browser/timeline-tree-widget");
const comment_thread_widget_1 = require("../comments/comment-thread-widget");
const browser_2 = require("@theia/core/lib/browser");
let CodeEditorWidgetUtil = class CodeEditorWidgetUtil {
    is(arg) {
        return arg instanceof browser_1.EditorWidget || arg instanceof webview_1.WebviewWidget;
    }
    getResourceUri(editor) {
        const resourceUri = navigatable_1.Navigatable.is(editor) && editor.getResourceUri();
        return resourceUri ? resourceUri['codeUri'] : undefined;
    }
};
CodeEditorWidgetUtil = __decorate([
    (0, inversify_1.injectable)()
], CodeEditorWidgetUtil);
exports.CodeEditorWidgetUtil = CodeEditorWidgetUtil;
let MenusContributionPointHandler = MenusContributionPointHandler_1 = class MenusContributionPointHandler {
    handle(plugin) {
        const allMenus = plugin.contributes && plugin.contributes.menus;
        if (!allMenus) {
            return core_1.Disposable.NULL;
        }
        const toDispose = new core_1.DisposableCollection();
        const tree = this.getMenusTree(plugin);
        tree.forEach(rootMenu => {
            const registerMenuActions = (menus, group, submenusOrder = '') => {
                menus.forEach(menu => {
                    if (group) {
                        // Adding previous group to the start of current menu group.
                        menu.group = `${group}/${menu.group || '_'}`;
                    }
                    if (menu.isSubmenu) {
                        let [submenuGroup, submenuOrder = ''] = (menu.group || '_').split('@');
                        // Generating group in format: `<submenu group>/<submenu name>`
                        submenuGroup = `${submenuGroup}/${menu.label}`;
                        if (submenusOrder) {
                            // Adding previous submenus order to the start of current submenu order
                            // in format: `<submenu order>/<submenu order>.../<menu order>`.
                            submenuOrder = `${submenusOrder}/${submenuOrder}`;
                        }
                        registerMenuActions(menu.children, submenuGroup, submenuOrder);
                    }
                    else {
                        menu.submenusOrder = submenusOrder;
                        toDispose.push(this.registerAction(plugin, rootMenu.id, menu));
                    }
                });
            };
            registerMenuActions(rootMenu.children, undefined, undefined);
        });
        return toDispose;
    }
    /**
     * Transforms the structure of Menus & Submenus
     * into something more tree-like.
     */
    getMenusTree(plugin) {
        const allMenus = plugin.contributes && plugin.contributes.menus;
        if (!allMenus) {
            return [];
        }
        const allSubmenus = plugin.contributes && plugin.contributes.submenus;
        const tree = [];
        Object.keys(allMenus).forEach(location => {
            // Don't build menus tree for a submenu declaration at root.
            if (allSubmenus && allSubmenus.findIndex(submenu => submenu.id === location) > -1) {
                return;
            }
            /**
             * @param menus the menus to create a tree from.
             * @param submenusIds contains all the previous submenus ids in the current tree.
             * @returns {MenuTree[]} the trees for the given menus.
             */
            const getChildren = (menus, submenusIds) => {
                // Contains all the submenus ids of the current parent.
                const parentSubmenusIds = new Set();
                return menus.reduce((children, menuItem) => {
                    if (menuItem.submenu) {
                        if (parentSubmenusIds.has(menuItem.submenu)) {
                            console.warn(`Submenu ${menuItem.submenu} already registered`);
                        }
                        else if (submenusIds.has(menuItem.submenu)) {
                            console.warn(`Found submenu cycle: ${menuItem.submenu}`);
                        }
                        else {
                            parentSubmenusIds.add(menuItem.submenu);
                            const submenu = allSubmenus.find(s => s.id === menuItem.submenu);
                            const menuTree = new MenuTree(Object.assign({}, menuItem), menuItem.submenu, submenu.label);
                            menuTree.children = getChildren(allMenus[submenu.id], new Set([...submenusIds, menuItem.submenu]));
                            children.push(menuTree);
                        }
                    }
                    else {
                        children.push(new MenuTree(Object.assign({}, menuItem)));
                    }
                    return children;
                }, []);
            };
            const rootMenu = new MenuTree(undefined, location);
            rootMenu.children = getChildren(allMenus[location], new Set());
            tree.push(rootMenu);
        });
        return tree;
    }
    registerAction(plugin, location, action) {
        const allMenus = plugin.contributes && plugin.contributes.menus;
        if (!allMenus) {
            return core_1.Disposable.NULL;
        }
        switch (location) {
            case 'commandPalette': return this.registerCommandPaletteAction(action);
            case 'editor/title': return this.registerEditorTitleAction(location, action);
            case 'view/title': return this.registerViewTitleAction(location, action);
            case 'view/item/context': return this.registerViewItemContextAction(action);
            case 'scm/title': return this.registerScmTitleAction(location, action);
            case 'scm/resourceGroup/context': return this.registerScmResourceGroupAction(action);
            case 'scm/resourceFolder/context': return this.registerScmResourceFolderAction(action);
            case 'scm/resourceState/context': return this.registerScmResourceStateAction(action);
            case 'timeline/item/context': return this.registerTimelineItemAction(action);
            case 'comments/commentThread/context': return this.registerCommentThreadAction(action, plugin);
            case 'comments/comment/title': return this.registerCommentTitleAction(action);
            case 'comments/comment/context': return this.registerCommentContextAction(action);
            case 'debug/callstack/context': return this.registerDebugCallstackAction(action);
            default:
                if (allMenus.hasOwnProperty(location)) {
                    return this.registerGlobalMenuAction(action, location, plugin);
                }
                return core_1.Disposable.NULL;
        }
    }
    static parseMenuPaths(value) {
        switch (value) {
            case 'editor/context': return [browser_1.EDITOR_CONTEXT_MENU];
            case 'explorer/context': return [navigator_contribution_1.NAVIGATOR_CONTEXT_MENU];
        }
        return [];
    }
    registerCommandPaletteAction(menu) {
        if (menu.command && menu.when) {
            return this.quickCommandService.pushCommandContext(menu.command, menu.when);
        }
        return core_1.Disposable.NULL;
    }
    registerEditorTitleAction(location, action) {
        return this.registerTitleAction(location, action, {
            execute: widget => this.codeEditorWidgetUtil.is(widget) &&
                this.commands.executeCommand(action.command, this.codeEditorWidgetUtil.getResourceUri(widget)),
            isEnabled: widget => this.codeEditorWidgetUtil.is(widget) && this.commands.isEnabled(action.command, this.codeEditorWidgetUtil.getResourceUri(widget)),
            isVisible: widget => this.codeEditorWidgetUtil.is(widget) && this.commands.isVisible(action.command, this.codeEditorWidgetUtil.getResourceUri(widget))
        });
    }
    registerViewTitleAction(location, action) {
        return this.registerTitleAction(location, action, {
            execute: widget => widget instanceof plugin_view_widget_1.PluginViewWidget && this.commands.executeCommand(action.command),
            isEnabled: widget => widget instanceof plugin_view_widget_1.PluginViewWidget && this.commands.isEnabled(action.command),
            isVisible: widget => widget instanceof plugin_view_widget_1.PluginViewWidget && this.commands.isVisible(action.command),
        });
    }
    registerViewItemContextAction(menu) {
        const inline = menu.group && /^inline/.test(menu.group) || false;
        const menuPath = inline ? tree_view_widget_1.VIEW_ITEM_INLINE_MENU : tree_view_widget_1.VIEW_ITEM_CONTEXT_MENU;
        return this.registerTreeMenuAction(menuPath, menu);
    }
    registerScmResourceGroupAction(menu) {
        const inline = menu.group && /^inline/.test(menu.group) || false;
        const menuPath = inline ? scm_tree_widget_1.ScmTreeWidget.RESOURCE_GROUP_INLINE_MENU : scm_tree_widget_1.ScmTreeWidget.RESOURCE_GROUP_CONTEXT_MENU;
        return this.registerScmMenuAction(menuPath, menu);
    }
    registerScmResourceFolderAction(menu) {
        const inline = menu.group && /^inline/.test(menu.group) || false;
        const menuPath = inline ? scm_tree_widget_1.ScmTreeWidget.RESOURCE_FOLDER_INLINE_MENU : scm_tree_widget_1.ScmTreeWidget.RESOURCE_FOLDER_CONTEXT_MENU;
        return this.registerScmMenuAction(menuPath, menu);
    }
    registerScmResourceStateAction(menu) {
        const inline = menu.group && /^inline/.test(menu.group) || false;
        const menuPath = inline ? scm_tree_widget_1.ScmTreeWidget.RESOURCE_INLINE_MENU : scm_tree_widget_1.ScmTreeWidget.RESOURCE_CONTEXT_MENU;
        return this.registerScmMenuAction(menuPath, menu);
    }
    registerTimelineItemAction(menu) {
        return this.registerMenuAction(timeline_tree_widget_1.TIMELINE_ITEM_CONTEXT_MENU, menu, command => ({
            execute: (...args) => this.commands.executeCommand(command, ...this.toTimelineArgs(...args)),
            isEnabled: (...args) => this.commands.isEnabled(command, ...this.toTimelineArgs(...args)),
            isVisible: (...args) => this.commands.isVisible(command, ...this.toTimelineArgs(...args))
        }));
    }
    registerCommentThreadAction(menu, plugin) {
        return this.registerMenuAction(comment_thread_widget_1.COMMENT_THREAD_CONTEXT, menu, command => ({
            execute: (...args) => this.commands.executeCommand(command, ...this.toCommentArgs(...args)),
            isEnabled: () => {
                var _a;
                const commandContributions = (_a = plugin.contributes) === null || _a === void 0 ? void 0 : _a.commands;
                if (commandContributions) {
                    const commandContribution = commandContributions.find(c => c.command === command);
                    if (commandContribution && commandContribution.enablement) {
                        return this.contextKeyService.match(commandContribution.enablement);
                    }
                }
                return true;
            },
            isVisible: (...args) => this.commands.isVisible(command, ...this.toCommentArgs(...args))
        }));
    }
    registerCommentTitleAction(menu) {
        return this.registerMenuAction(comment_thread_widget_1.COMMENT_TITLE, menu, command => ({
            execute: (...args) => this.commands.executeCommand(command, ...this.toCommentArgs(...args)),
            isEnabled: (...args) => this.commands.isEnabled(command, ...this.toCommentArgs(...args)),
            isVisible: (...args) => this.commands.isVisible(command, ...this.toCommentArgs(...args))
        }));
    }
    registerCommentContextAction(menu) {
        return this.registerMenuAction(comment_thread_widget_1.COMMENT_CONTEXT, menu, command => ({
            execute: (...args) => this.commands.executeCommand(command, ...this.toCommentArgs(...args)),
            isEnabled: () => true,
            isVisible: (...args) => this.commands.isVisible(command, ...this.toCommentArgs(...args))
        }));
    }
    registerDebugCallstackAction(menu) {
        const toDispose = new core_1.DisposableCollection();
        [debug_stack_frames_widget_1.DebugStackFramesWidget.CONTEXT_MENU, debug_threads_widget_1.DebugThreadsWidget.CONTEXT_MENU].forEach(menuPath => {
            toDispose.push(this.registerMenuAction(menuPath, menu, command => ({
                execute: (...args) => this.commands.executeCommand(command, args[0]),
                isEnabled: (...args) => this.commands.isEnabled(command, args[0]),
                isVisible: (...args) => this.commands.isVisible(command, args[0])
            })));
        });
        return toDispose;
    }
    registerTreeMenuAction(menuPath, menu) {
        return this.registerMenuAction(menuPath, menu, command => ({
            execute: (...args) => this.commands.executeCommand(command, ...this.toTreeArgs(...args)),
            isEnabled: (...args) => this.commands.isEnabled(command, ...this.toTreeArgs(...args)),
            isVisible: (...args) => this.commands.isVisible(command, ...this.toTreeArgs(...args))
        }));
    }
    toTreeArgs(...args) {
        const treeArgs = [];
        for (const arg of args) {
            if (common_2.TreeViewSelection.is(arg)) {
                treeArgs.push(arg);
            }
        }
        return treeArgs;
    }
    registerTitleAction(location, action, handler) {
        if (!action.command) {
            return core_1.Disposable.NULL;
        }
        const toDispose = new core_1.DisposableCollection();
        const id = this.createSyntheticCommandId(action.command, { prefix: `__plugin.${location.replace('/', '.')}.action.` });
        const command = { id };
        toDispose.push(this.commands.registerCommand(command, handler));
        const { when } = action;
        const whenKeys = when && this.contextKeyService.parseKeys(when);
        let onDidChange;
        if (whenKeys && whenKeys.size) {
            const onDidChangeEmitter = new event_1.Emitter();
            toDispose.push(onDidChangeEmitter);
            onDidChange = onDidChangeEmitter.event;
            event_1.Event.addMaxListeners(this.contextKeyService.onDidChange, 1);
            toDispose.push(core_1.Disposable.create(() => {
                event_1.Event.addMaxListeners(this.contextKeyService.onDidChange, -1);
            }));
            toDispose.push(this.contextKeyService.onDidChange(event => {
                if (event.affects(whenKeys)) {
                    onDidChangeEmitter.fire(undefined);
                }
            }));
        }
        // handle group and priority
        // if group is empty or white space is will be set to navigation
        // ' ' => ['navigation', 0]
        // 'navigation@1' => ['navigation', 1]
        // '1_rest-client@2' => ['1_rest-client', 2]
        // if priority is not a number it will be set to 0
        // navigation@test => ['navigation', 0]
        const [group, sort] = (action.group || 'navigation').split('@');
        const item = { id, command: id, group: group.trim() || 'navigation', priority: ~~sort || undefined, when, onDidChange };
        toDispose.push(this.tabBarToolbar.registerItem(item));
        toDispose.push(this.onDidRegisterCommand(action.command, pluginCommand => {
            command.category = pluginCommand.category;
            item.tooltip = pluginCommand.label;
            if (group === 'navigation') {
                command.iconClass = pluginCommand.iconClass;
            }
        }));
        return toDispose;
    }
    registerScmTitleAction(location, action) {
        if (!action.command) {
            return core_1.Disposable.NULL;
        }
        const selectedRepository = () => this.toScmArg(this.scmService.selectedRepository);
        return this.registerTitleAction(location, action, {
            execute: widget => widget instanceof scm_widget_1.ScmWidget && this.commands.executeCommand(action.command, selectedRepository()),
            isEnabled: widget => widget instanceof scm_widget_1.ScmWidget && this.commands.isEnabled(action.command, selectedRepository()),
            isVisible: widget => widget instanceof scm_widget_1.ScmWidget && this.commands.isVisible(action.command, selectedRepository())
        });
    }
    registerScmMenuAction(menuPath, menu) {
        return this.registerMenuAction(menuPath, menu, command => ({
            execute: (...args) => this.commands.executeCommand(command, ...this.toScmArgs(...args)),
            isEnabled: (...args) => this.commands.isEnabled(command, ...this.toScmArgs(...args)),
            isVisible: (...args) => this.commands.isVisible(command, ...this.toScmArgs(...args))
        }));
    }
    toScmArgs(...args) {
        const scmArgs = [];
        for (const arg of args) {
            const scmArg = this.toScmArg(arg);
            if (scmArg) {
                scmArgs.push(scmArg);
            }
        }
        return scmArgs;
    }
    toScmArg(arg) {
        if (arg instanceof scm_repository_1.ScmRepository && arg.provider instanceof scm_main_1.PluginScmProvider) {
            return {
                sourceControlHandle: arg.provider.handle
            };
        }
        if (arg instanceof scm_main_1.PluginScmResourceGroup) {
            return {
                sourceControlHandle: arg.provider.handle,
                resourceGroupHandle: arg.handle
            };
        }
        if (arg instanceof scm_main_1.PluginScmResource) {
            return {
                sourceControlHandle: arg.group.provider.handle,
                resourceGroupHandle: arg.group.handle,
                resourceStateHandle: arg.handle
            };
        }
    }
    toTimelineArgs(...args) {
        const timelineArgs = [];
        const arg = args[0];
        timelineArgs.push(this.toTimelineArg(arg));
        timelineArgs.push(vscode_uri_1.URI.parse(arg.uri));
        timelineArgs.push('source' in arg ? arg.source : '');
        return timelineArgs;
    }
    toTimelineArg(arg) {
        return {
            timelineHandle: arg.handle,
            source: arg.source,
            uri: arg.uri
        };
    }
    toCommentArgs(...args) {
        const arg = args[0];
        if ('text' in arg) {
            if ('commentUniqueId' in arg) {
                return [{
                        commentControlHandle: arg.thread.controllerHandle,
                        commentThreadHandle: arg.thread.commentThreadHandle,
                        text: arg.text,
                        commentUniqueId: arg.commentUniqueId
                    }];
            }
            return [{
                    commentControlHandle: arg.thread.controllerHandle,
                    commentThreadHandle: arg.thread.commentThreadHandle,
                    text: arg.text
                }];
        }
        return [{
                commentControlHandle: arg.thread.controllerHandle,
                commentThreadHandle: arg.thread.commentThreadHandle,
                commentUniqueId: arg.commentUniqueId
            }];
    }
    registerGlobalMenuAction(menu, location, plugin) {
        const menuPaths = MenusContributionPointHandler_1.parseMenuPaths(location);
        if (!menuPaths.length) {
            this.logger.warn(`'${plugin.metadata.model.id}' plugin contributes items to a menu with invalid identifier: ${location}`);
            return core_1.Disposable.NULL;
        }
        const selectedResource = () => {
            const selection = this.selectionService.selection;
            if (tree_widget_selection_1.TreeWidgetSelection.is(selection) && selection.source instanceof tree_view_widget_1.TreeViewWidget && selection[0]) {
                return selection.source.toTreeViewSelection(selection[0]);
            }
            const uri = this.resourceContextKey.get();
            return uri ? uri['codeUri'] : undefined;
        };
        const toDispose = new core_1.DisposableCollection();
        menuPaths.forEach(menuPath => {
            toDispose.push(this.registerMenuAction(menuPath, menu, command => ({
                execute: () => this.commands.executeCommand(command, selectedResource()),
                isEnabled: () => this.commands.isEnabled(command, selectedResource()),
                isVisible: () => this.commands.isVisible(command, selectedResource())
            })));
        });
        return toDispose;
    }
    registerMenuAction(menuPath, menu, handler) {
        var _a, _b;
        if (!menu.command) {
            return core_1.Disposable.NULL;
        }
        const toDispose = new core_1.DisposableCollection();
        const commandId = this.createSyntheticCommandId(menu.command, { prefix: '__plugin.menu.action.' });
        const altId = menu.alt && this.createSyntheticCommandId(menu.alt, { prefix: '__plugin.menu.action.' });
        const inline = Boolean(menu.group && /^inline/.test(menu.group));
        const [group, order = undefined] = (menu.group || '_').split('@');
        const command = { id: commandId };
        const action = { commandId, alt: altId, order, when: menu.when };
        toDispose.push(this.commands.registerCommand(command, handler(menu.command)));
        toDispose.push((_a = this.quickCommandService) === null || _a === void 0 ? void 0 : _a.pushCommandContext(commandId, 'false'));
        toDispose.push(this.menuRegistry.registerMenuAction(inline ? menuPath : [...menuPath, ...group.split('/')], action));
        toDispose.push(this.onDidRegisterCommand(menu.command, pluginCommand => {
            command.category = pluginCommand.category;
            command.label = pluginCommand.label;
            if (inline) {
                command.iconClass = pluginCommand.iconClass;
            }
        }));
        if (menu.alt && altId) {
            const alt = { id: altId };
            toDispose.push(this.commands.registerCommand(alt, handler(menu.alt)));
            toDispose.push((_b = this.quickCommandService) === null || _b === void 0 ? void 0 : _b.pushCommandContext(altId, 'false'));
            toDispose.push(this.onDidRegisterCommand(menu.alt, pluginCommand => {
                alt.category = pluginCommand.category;
                alt.label = pluginCommand.label;
                if (inline) {
                    alt.iconClass = pluginCommand.iconClass;
                }
            }));
        }
        // Register a submenu if the group is in format `<submenu group>/<submenu name>/<submenu order>.../<menu group>`
        if (group.includes('/')) {
            const groupSplit = group.split('/');
            const orderSplit = (menu.submenusOrder || '').split('/');
            const paths = [];
            for (let i = 0, j = 0; i < groupSplit.length - 1; i += 2, j += 1) {
                const submenuGroup = groupSplit[i];
                const submenuLabel = groupSplit[i + 1];
                const submenuOrder = orderSplit[j];
                paths.push(submenuGroup, submenuLabel);
                toDispose.push(this.menuRegistry.registerSubmenu([...menuPath, ...paths], submenuLabel, { order: submenuOrder }));
            }
        }
        return toDispose;
    }
    createSyntheticCommandId(command, { prefix }) {
        let id = prefix + command;
        let index = 0;
        while (this.commands.getCommand(id)) {
            id = prefix + command + ':' + index;
            index++;
        }
        return id;
    }
    onDidRegisterCommand(id, cb) {
        const command = this.commands.getCommand(id);
        if (command) {
            cb(command);
            return core_1.Disposable.NULL;
        }
        const toDispose = new core_1.DisposableCollection();
        // Registering a menu action requires the related command to be already registered.
        // But Theia plugin registers the commands dynamically via the Commands API.
        // Let's wait for ~2 sec. It should be enough to finish registering all the contributed commands.
        // FIXME: remove this workaround (timer) once the https://github.com/theia-ide/theia/issues/3344 is fixed
        const handle = setTimeout(() => toDispose.push(this.onDidRegisterCommand(id, cb)), 2000);
        toDispose.push(core_1.Disposable.create(() => clearTimeout(handle)));
        return toDispose;
    }
};
__decorate([
    (0, inversify_1.inject)(common_1.MenuModelRegistry),
    __metadata("design:type", common_1.MenuModelRegistry)
], MenusContributionPointHandler.prototype, "menuRegistry", void 0);
__decorate([
    (0, inversify_1.inject)(core_1.CommandRegistry),
    __metadata("design:type", core_1.CommandRegistry)
], MenusContributionPointHandler.prototype, "commands", void 0);
__decorate([
    (0, inversify_1.inject)(core_1.ILogger),
    __metadata("design:type", Object)
], MenusContributionPointHandler.prototype, "logger", void 0);
__decorate([
    (0, inversify_1.inject)(scm_service_1.ScmService),
    __metadata("design:type", scm_service_1.ScmService)
], MenusContributionPointHandler.prototype, "scmService", void 0);
__decorate([
    (0, inversify_1.inject)(browser_2.QuickCommandService),
    (0, inversify_1.optional)(),
    __metadata("design:type", browser_2.QuickCommandService)
], MenusContributionPointHandler.prototype, "quickCommandService", void 0);
__decorate([
    (0, inversify_1.inject)(tab_bar_toolbar_1.TabBarToolbarRegistry),
    __metadata("design:type", tab_bar_toolbar_1.TabBarToolbarRegistry)
], MenusContributionPointHandler.prototype, "tabBarToolbar", void 0);
__decorate([
    (0, inversify_1.inject)(core_1.SelectionService),
    __metadata("design:type", core_1.SelectionService)
], MenusContributionPointHandler.prototype, "selectionService", void 0);
__decorate([
    (0, inversify_1.inject)(resource_context_key_1.ResourceContextKey),
    __metadata("design:type", resource_context_key_1.ResourceContextKey)
], MenusContributionPointHandler.prototype, "resourceContextKey", void 0);
__decorate([
    (0, inversify_1.inject)(view_context_key_service_1.ViewContextKeyService),
    __metadata("design:type", view_context_key_service_1.ViewContextKeyService)
], MenusContributionPointHandler.prototype, "viewContextKeys", void 0);
__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    __metadata("design:type", Object)
], MenusContributionPointHandler.prototype, "contextKeyService", void 0);
__decorate([
    (0, inversify_1.inject)(CodeEditorWidgetUtil),
    __metadata("design:type", CodeEditorWidgetUtil)
], MenusContributionPointHandler.prototype, "codeEditorWidgetUtil", void 0);
MenusContributionPointHandler = MenusContributionPointHandler_1 = __decorate([
    (0, inversify_1.injectable)()
], MenusContributionPointHandler);
exports.MenusContributionPointHandler = MenusContributionPointHandler;
/**
 * MenuTree representing a (sub)menu in the menu tree structure.
 */
class MenuTree {
    constructor(menu, 
    /** The location where the menu item will be open from. */
    id, 
    /** The label of the menu item which leads to the submenu. */
    label) {
        this.id = id;
        this.label = label;
        this._children = [];
        if (menu) {
            this.command = menu.command;
            this.alt = menu.alt;
            this.group = menu.group;
            this.when = menu.when;
        }
    }
    get children() {
        return this._children;
    }
    set children(items) {
        this._children.push(...items);
    }
    addChild(node) {
        this._children.push(node);
    }
    get isSubmenu() {
        return this.label !== undefined;
    }
}
exports.MenuTree = MenuTree;
//# sourceMappingURL=menus-contribution-handler.js.map